#ifndef BIN_TREE_H_
#define BIN_TREE_H_

/*###########################################################################*/
#include "RStd.h"
#include "HolderPtr.h"
#include "Interface.h"

#ifdef ROB_DEBUG
#	include <typeinfo>
#endif

#include <algorithm>
#include <iosfwd>
#include <queue>

template <typename> class RVector;

/*###########################################################################*/
// Binary tree for use in floorplanning.

template <typename T>
class BinTree :
	public Clones<BinTree<T> >,
	public Swaps<BinTree<T> >,
	public SChecks<BinTree<T> >
{
	typedef BinTree self;

public:
// Typedefs
	class Node;
	typedef long size_type;
	typedef RVector<Node *> node_vec;
	typedef RVector<const Node *> const_node_vec;

// Construction
	virtual ~BinTree() throw() {}

	BinTree() : header_(0), size_(0) {}
	BinTree(const self & bt);
	virtual BinTree & operator=(const self &);

// Interface
	virtual void self_check() const;
	virtual void self_check_deep() const;
	virtual void rswap(self & a);
	virtual self * clone() const { return new self(*this); }

// Modifiable
	virtual void clear();

	virtual void add_left(Node * nd, const T & data);
	virtual void add_right(Node * nd, const T & data);

// Puts the structure of bt to the left of nd and deletes bt's header.
	virtual void consume_left(Node * nd, BinTree & bt);

// Puts the structure of bt to the right of nd and deletes bt's header.
	virtual void consume_right(Node * nd, BinTree & bt);

	virtual void erase(Node * nd);

// Final
	Node * header() { return header_.get(); }
	const Node * header() const { return header_.get(); }

	size_type size() const { return size_; }
	bool empty() const { return ! size_; }

	const node_vec dfs(Node * top = 0);
	const const_node_vec dfs(const Node * top = 0) const;

	const node_vec bfs(Node * top = 0);
	const const_node_vec bfs(const Node * top = 0) const;

	const node_vec leaf_up(Node * top = 0);
	const const_node_vec leaf_up(const Node * top = 0) const;

	class Node :
		public Prints<Node>,
		public Clones<Node>,
		public Swaps<Node>
	{
	public:
		typedef Node self;

		Node(Node * pt, const T & dt);
		~Node() throw() {}
		bool terminal() const { return ! left_.get() && ! right_.get(); }
		bool header() const { return ! parent_; }
		Node * parent() { return parent_; }
		const Node * parent() const { return parent_; }
		Node * left() { return left_.get(); }
		const Node * left() const { return left_.get(); }
		Node * right() { return right_.get(); }
		const Node * right() const { return right_.get(); }
		T & data() { return data_; }
		const T & data() const { return data_; }

		void rswap(self & a);
		self * clone() const;
		void print_to(ostream & os) const;

	private:
		void dfs_recurse(node_vec & vec);
		Node * copy_recurse(Node * pt) const;

		Node(const Node &); // No implementation.
		Node & operator=(const Node &); // No implementation.

// Each node owns only its children.
			Node * parent_;
			HolderPtr<Node> left_;
			HolderPtr<Node> right_;
			T data_;

		friend BinTree;
	};

private:
		HolderPtr<Node> header_;
		size_type size_;
};

/*===========================================================================*/
void BinTree_test();

/*###########################################################################*/
#include "BinTree.cct"
#endif
