#ifndef DUAL_MAP_H_
#define DUAL_MAP_H_

/*###########################################################################*/
#include "Interface.h"

#include <map>
#include <functional>

/*###########################################################################*/
// Simple bi-directional ln map.

template <typename T1, typename T2,
typename LESS1 = less<T1>, typename LESS2 = less<T2> >
class DualMap {
	typedef DualMap<T1, T2> self;
	typedef map<T1, T2> impl1;
	typedef map<T2, T1> impl2;

public:
	typedef long size_type;

	DualMap() : impl1_(), impl2_() {}
	DualMap(LESS1 less1, LESS2 less2);

// Removes a->j, b->k if they exist and adds a->b, b->a.
	void assign(const T1 & a, const T2 & b);

// Returns true if a->b and b->a exist.
	bool dual(const T1 & a, const T2 & b) const;

// Returns 0 if no entry present.
	const T2 * forward_locate(const T1 & a);
	const T1 * reverse_locate(const T2 & a);

// Asserts a->b and b->a exist.  Erases a->b and b->a.
	void erase(const T1 & a, const T2 & b);

// Asserts a->j exists.  Erases j->a and a->j.
	void erase_forward(const T1 & a);

// Asserts b->k exists.  Erases k->b and b->k.
	void erase_reverse(const T2 & b);

	size_type size() const;

private:
		impl1 impl1_;
		impl2 impl2_;
};

void DualMap_test();

/*###########################################################################*/
#include "DualMap.cct"
#endif
