#include "Epsilon.h"
#include "RStd.h"

/*###########################################################################*/
template <>
	const float eps_type_info<float>::MIN = FLT_MIN;

template <>
	const float eps_type_info<float>::EPSILON = FLT_EPSILON;

template <>
	const double eps_type_info<double>::MIN = DBL_MIN;

template <>
	const double eps_type_info<double>::EPSILON = DBL_EPSILON;

/*===========================================================================*/
void Epsilon_test() {
	double x = 50000;
	double y = 50000.0000001;

	eps_less<double> lt(10000);
	eps_equal_to<double> eq(10000);
	eps_not_equal_to<double> neq(10000);

	Rassert(! lt(x, y));
	Rassert(eq(x, y));

	double a = 500;
	double b = 501;

	Rassert(lt(a, b));
	Rassert(! eq(a, b));

	Rassert(neq(50.0, 51.0));
}
