#ifndef EPSILON_H_
#define EPSILON_H_

/* Epsilon computation.  For now, only works for floats and doubles.
FIXME: This should base itself on numeric_limits<> when the compiler supports
them. */

/*###########################################################################*/
#ifdef ROB_DEBUG
#	include "RStd.h"
#endif

#include "RFunctional.h"
#include "rcmath.h"
#include "Interface.h"

#include <cfloat>

/*###########################################################################*/
template <typename T> struct eps_type_info {};

/*===========================================================================*/
template <> struct eps_type_info<float> {
	static const float MIN;
	static const float EPSILON;
};

/*===========================================================================*/
template <> struct eps_type_info<double> {
	static const double MIN;
	static const double EPSILON;
};

/*###########################################################################*/
/* For doubles:
Slack  Sensitive digits (approx.)
1      16
10     15
100    14
1000   13
10000  12
*/

const long DEFAULT_CMP_SLACK = 500;
const long DEFAULT_MODIFY_SLACK = 1;

/*===========================================================================*/
template <typename T>
	bool eps_is_equal_to(const T & a, const T & b, const T & minimum,
	const T & epsilon);

template <typename T>
	bool eps_is_less(const T & a, const T & b, const T & minimum,
	const T & epsilon);

/*===========================================================================*/
template <typename T>
struct eps_equal_to : rbinary_function<const T &, const T &, bool> {
	eps_equal_to(long slack = DEFAULT_CMP_SLACK);
	bool operator()(const T & a, const T & b) const;

private:
	const T minim;
	const T eps;
};

/*===========================================================================*/
template <typename T>
struct eps_less : rbinary_function<const T &, const T &, bool> {
	eps_less(long slack = DEFAULT_CMP_SLACK);
	bool operator()(const T & a, const T & b) const;

private:
	const T minim;
	const T eps;
};

/*===========================================================================*/
template <typename T>
struct eps_not_equal_to : rbinary_function<const T &, const T &, bool> {
	eps_not_equal_to(long slack = DEFAULT_CMP_SLACK);
	bool operator()(const T & a, const T & b) const;

	const T minim;
	const T eps;
};

template <typename T>
struct eps_greater : rbinary_function<const T &, const T &, bool> {
	eps_greater(long slack = DEFAULT_CMP_SLACK);
	bool operator()(const T & a, const T & b) const;

	const T minim;
	const T eps;
};

template <typename T>
struct eps_less_equal : rbinary_function<const T &, const T &, bool> {
	eps_less_equal(long slack = DEFAULT_CMP_SLACK);
	bool operator()(const T & a, const T & b) const;

	const T minim;
	const T eps;
};

template <typename T>
struct eps_greater_equal : rbinary_function<const T &, const T &, bool> {
	eps_greater_equal(long slack = DEFAULT_CMP_SLACK);
	bool operator()(const T & a, const T & b) const;

	const T minim;
	const T eps;
};

/*===========================================================================*/
template <typename T>
struct eps_inc : runary_function<const T &, T> {
	eps_inc(long slack = DEFAULT_MODIFY_SLACK);
	void operator()(T & a) const;

	const T minim;
	const T eps;
};

/*===========================================================================*/
template <typename T>
struct eps_dec : runary_function<const T &, T> {
	eps_dec(long slack = DEFAULT_MODIFY_SLACK);
	void operator()(T & a) const;

	const T minim;
	const T eps;
};

/*###########################################################################*/
template <typename T, long SLACK = DEFAULT_CMP_SLACK>
class eps_comp_obj {
public:
	comp_type operator()(const T & a, const T & b) const;

private:
		static const eps_less<T> lt_;
};

/*===========================================================================*/
void Epsilon_test();

/*###########################################################################*/
#include "Epsilon.cct"
#endif

