#ifndef GEOM_H_
#define GEOM_H_

/*###########################################################################*/
#include "FVector.h"
#include "Interface.h"
#include "RFunctional.h"

#include <functional>
#include <algorithm>
#include <cmath>
#include <iosfwd>
#include <cstdlib>
#include <utility>
#include <iterator>

// Simple computational geometry data types.

/* FIXME: 13 Mar 2001.  I have wasted many hours of time trying to get generic
positions and rectangles working with gcc 2.95.2.  Basically, template support
in this compiler appears to be seriously flawed.  The following idiom cannot
be compiled and results in an internal compiler error.

---
bool cmp_dbl(const double & a, const double & b) { return false; }

template <int DIM, typename NUM,
bool (*COMP)(const NUM &, const NUM &)>
struct Fred {};

template <typename T>
Fred<2, T, cmp_dbl>
make_fred(T x) {
	Fred<2, T, &cmp_dbl> a;
	return a;
}
---

I had intended to make these arbitrary-dimension, arbitrary number,
potentially fuzzy-comparison geometric objects and this would have been easy
if the compiler operated correctly.  The wrapper static comparison object is
used to work around the compiler error. */

/*###########################################################################*/
template <int DIM, typename NUM, typename COMP = comp_obj<NUM> >
class Pos :
	public FVector<DIM, NUM>
{
	typedef Pos<DIM, NUM, COMP> self;

	typedef FVector<DIM, NUM> super;

public:
// Typedefs
	typedef typename super::size_type size_type;
	static const int dimen = DIM;
	typedef NUM number;

// Construction
	Pos(const NUM & a) : super(a) {}
	Pos(const NUM & a, const NUM & b) : super(a, b) {}
	Pos(const NUM & a, const NUM & b, const NUM & c) : super(a, b, c) {}
	Pos(const NUM & a, const NUM & b, const NUM & c, const NUM & d);

	template <typename NUM2, typename COMP2>
		Pos(const Pos<DIM, NUM2, COMP2> & a) : super(a.begin(), a.end()) {}

	static const COMP & num_comp() { return comp_; }

// Interface
	virtual comp_type comp(const super & a) const;

// Modifiable
	virtual void swap_dim(size_type a, size_type b);

// Final
	self & operator+=(const self & a);
	self & operator-=(const self & a);
	self & operator*=(const NUM & a);
	self & operator/=(const NUM & a);

	self operator+(const self & a) const { return self(*this) += a; }
	self operator-(const self & a) const { return self(*this) -= a; }
	self operator*(const NUM & a) const { return self(*this) *= a; }
	self operator/(const NUM & a) const { return self(*this) /= a; }

private:
		static COMP comp_;
};

template <typename T>
	Pos<2, T> make_pos(const T & a, const T & b);

template <typename T>
	Pos<3, T> make_pos(const T & a, const T & b, const T & c);

template <typename T>
	Pos<4, T> make_pos(const T & a, const T & b, const T & c,
		const T & d);

template <int DIM, typename NUM, typename COMP>
	double dist_euclid(const Pos<DIM, NUM, COMP> & a,
	const Pos<DIM, NUM, COMP> & b);

template <int DIM, typename NUM, typename COMP>
	NUM dist_rect(const Pos<DIM, NUM, COMP> & a,
	const Pos<DIM, NUM, COMP> & b);
#ifdef PHYSICAL	
template <int DIM, typename NUM, typename COMP>
NUM dist_manhattan(const Pos<DIM, NUM, COMP> & a,
        const Pos<DIM, NUM, COMP> & b);
#endif

template <typename POS, int DIM_SEL>
struct pos_dim_less :
public rbinary_function<const POS &, const POS &, bool> {
	bool operator()(const POS & a, const POS & b) const;
};

/*===========================================================================*/
// Size.
template <int DIM, typename NUM, typename COMP = comp_obj<NUM> >
class Rect :
	public FVector<DIM, NUM>
{
	typedef FVector<DIM, NUM> super;
	typedef Rect<DIM, NUM, COMP> self;

public:
// Typedefs
	typedef typename super::size_type size_type;
	static const int dimen = DIM;
	typedef NUM number;

// Construction
	Rect(const NUM & a, const NUM & b) : super(a, b) {}
	Rect(const NUM & a, const NUM & b, const NUM & c) : super(a, b, c) {}
	Rect(const NUM & a, const NUM & b, const NUM & c, const NUM & d);

	template <typename NUM2, typename COMP2>
		Rect(const Rect<DIM, NUM2, COMP2> & a);

	static const COMP & num_comp() { return comp_; }

// Interface
	virtual void self_check() const;
	virtual comp_type comp(const super & a) const;

// Modifiable
	virtual void swap_dim(size_type a, size_type b);

// Increases size by a in all dimensions.
	self & operator+=(const NUM & a);
	self operator+(double x) const { return self(*this) += x; }
	self & operator*=(const NUM & b);
	self operator*(double x) const { return self(*this) *= x; }

// Final
	NUM area() const;

private:
		static COMP comp_;
};

template <typename T>
	Rect<2, T> make_rect(const T & a, const T & b) { return Rect<2, T>(a, b); }

template <typename T>
	Rect<3, T> make_rect(const T & a, const T & b, const T & c);

template <typename T>
	Rect<4, T> make_rect(const T & a, const T & b, const T & c, const T & d);

/*===========================================================================*/
// Center position.

template <typename T>
less<T> make_less(T) { return less<T>(); }

template <int DIM, typename NUM, typename COMP = comp_obj<NUM> >
class PRect :
	public Prints<PRect<DIM, NUM, COMP>, NUM>,
	public Comps<PRect<DIM, NUM, COMP>, NUM>,
	public Pos<DIM, NUM, COMP>,
	public Rect<DIM, NUM, COMP>
{
	typedef PRect<DIM, NUM, COMP> self;
	typedef Pos<DIM, NUM, COMP> super_pos;
	typedef Rect<DIM, NUM, COMP> super_r;

public:
// Typedefs
	typedef typename super_pos::size_type size_type;
	static const int dimen = DIM;
	typedef NUM number;

// Construction
	PRect(const super_pos & pos_a, const super_r & r);

	template <typename NUM2, typename COMP2>
		PRect(const PRect<DIM, NUM2, COMP2> & a);

	static const COMP & num_comp() { return comp_; }

// Interface
	virtual void print_to(ostream & os) const;
	virtual void self_check() const;
	virtual void self_check_deep() const;
	virtual comp_type comp(const self & a) const;

// Modifiable
	virtual void swap_dim(size_type a, size_type b);

// Final
	RVector<Pos<DIM, NUM, COMP> > corners() const;
	Rect<DIM, NUM, COMP> & rect() { return *this; }
	const Rect<DIM, NUM, COMP> & rect() const { return *this; }
	Pos<DIM, NUM, COMP> & pos() { return *this; }
	const Pos<DIM, NUM, COMP> & pos() const { return *this; }

	Pos<DIM, NUM, COMP> corner(const FVector<DIM, bool> & sign) const;

// Compile-time check only allows the correct dimension corner to be used.
	Pos<2, NUM, COMP> corner(bool x_sign, bool y_sign) const;
	Pos<3, NUM, COMP> corner(bool x_sign, bool y_sign, bool z_sign) const;

	Pos<4, NUM, COMP> corner(bool x_sign, bool y_sign, bool z_sign,
		bool p_sign) const;

	NUM min_pos(size_type dim) const;
	NUM max_pos(size_type dim) const;

	void set_min_pos(size_type dim, NUM val);
	void set_max_pos(size_type dim, NUM val);

// Splits into two along specified dimension.
	pair<self, self> split(long dim) const;

	void make_union(const self & b);
	bool intersect(const self & b);

	bool pos_intersect(const Pos<DIM, NUM, COMP> & pt) const;

private:
		static COMP comp_;
};

template <typename ITER>
struct iter_prect {
	typedef PRect<iterator_traits<ITER>::value_type::dimen,
		typename iterator_traits<ITER>::value_type::number,
		comp_obj<typename iterator_traits<ITER>::value_type::number> >
		prect;
};

template <typename ITER>
	iter_prect<ITER>::prect make_union(ITER begin_a, ITER end_a);

// Modifies pr to be the intersection of [begin, end] if true.
template <typename ITER>
	pair<bool, iter_prect<ITER>::prect> intersect(ITER begin_a, ITER end_a);

/*===========================================================================*/
void Geom_test();

/*###########################################################################*/
#include "Geom.cct"
#endif
