#ifndef HOLDER_PTR_
#define HOLDER_PTR_

/*###########################################################################*/
#include "Interface.h"

#include <algorithm>

template <typename> struct HolderPtrTraits;

/*===========================================================================*/
/* Smart pointer which copies data instead of automatically releasing it when
assigned from. */

template <typename T>
class HolderPtr :
	public Comps<HolderPtr<T> >,
	public Clones<HolderPtr<T> >,
	public Swaps<HolderPtr<T> >
{
	typedef HolderPtr self;

public:
	typedef T element_type;
	explicit HolderPtr(T * p = 0) throw();

	HolderPtr(const self & a);

	template <typename T2>
		HolderPtr(const HolderPtr<T2> & a);

	self & operator=(const self & a);

	template <class T2>
		self & operator=(const HolderPtr<T2> & a);

	~HolderPtr() throw();

// Interface
	void rswap(self & hp) { ::rswap(data_, hp.data_); }
	self * clone() const { return new self(*this); }
	comp_type comp(const self & a) const;

	T & operator*() const throw() { return *data_; }
	T * operator->() const throw() { return data_; }
	T * get() const throw () { return data_; }

	T * release() throw();
	void reset(T * p = 0) throw();

private:
		T * data_;
};

/*###########################################################################*/
#include "HolderPtr.cct"
#endif
