#include "ISet.h"

#include "RGen.h"
#include "RMath.h"

/*###########################################################################*/
void ISet_test() {
	ISet<int> is_tst(3);
	is_tst.sched(0, 1, 0);
	is_tst.sched(2, 1, 1);
	is_tst.sched(2, 1, 2);

	is_tst.print_to_default(cout);

	ISet<int> is(50);

	MAP(x, 50) {
		int earliest = RGen::gen().flat_range_l(-300, 300);
		int duration = RGen::gen().flat_range_l(1, 3);

		ISet<int>::iterator i = is.sched(earliest, duration, x);

		cout << "earliest " << earliest << " duration " << duration << " ";
		if (i == is.end()) {
			cout << " failed\n";
		} else {
			cout << *i;
			cout << " raw from " << i->raw_start() << " until " <<
			  ring_mod(i->finish(), is.period()) << "\n";
		}
	}

	ISet<int> k(120000);
	k.sched(0, 94, 0);
	ISet<int>::iterator i = k.sched(2, 90, 0);
	k.erase(i);

// Confirm that wrapping works correctly.
	ISet<int> is2(10);
	ISet<int>::iterator i2 = is2.sched(8, 5, 0);
	Rassert(i2 != is2.end());
	ISet<int>::iterator i3 = is2.sched(0, 2, 0);
	Rassert(i3 != is2.end());
	is2.print_to_default(cout);
}

