#include "MST.h"
#include "Epsilon.h"

/*###########################################################################*/
void MST_test() {
	RVector<Pos<2, int> > place;
	place.reserve(8);

	place.push_back(Pos<2, int>(3, 4));
	place.push_back(Pos<2, int>(1, 7));
	place.push_back(Pos<2, int>(16, 12));
	place.push_back(Pos<2, int>(1, 12));
	place.push_back(Pos<2, int>(22, 2));
	place.push_back(Pos<2, int>(3, 6));
	place.push_back(Pos<2, int>(8, 9));
	place.push_back(Pos<2, int>(2, 5));

	MST<2, int, double (*)(const Pos<2, int> &, const Pos<2, int> &)>
		mst(&dist_euclid<2, int>, place.begin(), place.end());

	double proper_sum = 2.0 * sqrt(2.0) + 5.0 + sqrt(5.0) +
	  sqrt(34.0) + sqrt(73.0) + sqrt(136.0);

	eps_equal_to<double> eq;
	Rassert(eq(mst.total_len(), proper_sum));
}
