#ifndef MST_H_
#define MST_H_

/*###########################################################################*/
// Minimal spanning tree.

#include "RVector.h"
#include "Geom.h"
#include "rcmath.h"

#include <utility>

template <typename> class RVector;

/*###########################################################################*/
// Minimal spanning tree computation.

template <int DIM, typename NUM,
typename DIST_FUNC = NUM (*)(const Pos<DIM, NUM> &, const Pos<DIM, NUM> &)>
class MST {
public:
// Location.
	virtual ~MST() throw() {}

// Takes iterators to container of Positions (Pos).
	template <typename ITER>
		MST(DIST_FUNC dist_func, ITER place_begin, ITER place_end);
#ifdef PHYSICAL	
	//07222002	
	 MST(DIST_FUNC dist_func, RVector< PRect<DIM, NUM> > & connected_cores);
#endif

// Total connection length.
	double total_len() const { return total_len_; }

private:
		double total_len_;
};

void MST_test();

/*###########################################################################*/
#include "MST.cct"
#endif
