#ifndef MEM_CHECKER_
#define MEM_CHECKER_

/*###########################################################################*/
// Tracks outstanding memory and watches for some out-of-bounds writes.
// Redefined new, delete, new[], and delete[].

#include <functional>
#include <map>
#include <stack>
#include <string>
#include <cstddef>

/*===========================================================================*/
// Put one of these in the outer scope of main to monitor memory management.
// Can make more for local monitoring.
class MemChecker {
public:
// Location byte -> requested bytes?
	typedef map<void *, size_t> MemMap;

	static MemChecker * mc();

	MemChecker(const char * name);
	MemChecker(const char * name, size_t min_alloc, size_t max_alloc);

	MemChecker(const char * name, size_t min_alloc, size_t max_alloc,
		size_t min_byte, size_t max_byte);

	~MemChecker() throw();

	size_t max_alloc() const { return max_alloc_; }
	size_t min_alloc() const { return min_byte_; }
	size_t max_byte() const { return max_byte_; }
	size_t min_byte() const { return min_byte_; }

	void set_expected(size_t min_alloc, size_t max_alloc);
	void set_expected(size_t min_alloc, size_t max_alloc,
		size_t min_bytes, size_t max_bytes);

	void * checked_alloc(size_t bytes);
	void checked_dealloc(void * data);

	size_t out_allocs() const;
	size_t out_bytes() const;
	void check(int max_print = 10);

private:
	static void ref(bool up);

// Location to size.
		MemMap mem_map_;
		size_t min_alloc_;
		size_t max_alloc_;
		size_t min_byte_;
		size_t max_byte_;
		string name_;
		static stack<MemChecker *> mc_stack_;
};

/*===========================================================================*/
void MemChecker_test();

/*###########################################################################*/
#endif
