#include "Geom.h"
#include "RGen.h"
#include "RAlgo.h"
#include "RStd.h"
#include "Graph.h"
#include "Epsilon.h"
#include "RMath.h"
#include "ISet.h"
#include "BinTree.h"
#include "AssocVec.h"
#include "RefAdapter.h"
#include "MST.h"
#include "RString.h"
#include "MemChecker.h"
#include "RVector.h"
#include "FVector.h"
#include "rcmath.h"
#include "DualMap.h"

#include <iostream>

/*###########################################################################*/
int
main() {
	cout << "Tests starting\n";
	RGen_test();
	Graph_test();
	RVector_test();
	FVector_test();
	RecVector_test();
	Epsilon_test();
	RMath_test();
	ISet_test();
	BinTree_test();
	AssocVec_test();
	MST_test();
	RString_test();
	RefAdapter_test();
	RStd_test();
	isfinite(5.0);
	Geom_test();
	DualMap_test();

// Keep this one last in order to do more complicated tests.
	MemChecker_test();

	cout << "Tests passed.\n";
}

#if 0

const double alpha = 0.4;

RVector<long> fred(200, 0);

MAP(x, 1000000) {
	const double a = RGen::gen().flat_range_d(-1.0, 1.0);
	const double b = RGen::gen().flat_range_d(-1.0, 1.0);

	double k = flat_merge(a, b, alpha);
	k += 1.0;
	k *= 100.0;
	++fred[static_cast<long>(floor(k))];
}

MAP(x, fred.size()) {
	cout << 1.0 - fred[x] / 5000.0 << "\n";
}

cout << "\n";

Rabort();
#endif
