#ifndef ANSI_RSTD_H_
#define ANSI_RSTD_H_

/* Misc. debugging and control flow helpers for use w. ANSI-C. */

/* Define ROB_DEBUG to turn on debugging. */

/*###########################################################################*/
#undef PI
#define PI 3.14159265358979323846

/*===========================================================================*/
/* Utility */

#define MAP(x, end_x) \
	for (x = 0; (x) < (unsigned)(end_x); (x)++)

#define MAP2(x, end_x, y, end_y) \
	for (x = 0; (x) < (unsigned)(end_x); (x)++) \
		for (y = 0; (y) < (unsigned)(end_y); (y)++)

#define MAP3(x, end_x, y, end_y, z, end_z) \
	for (x = 0; (x) < (unsigned)(end_x); (x)++) \
		for (y = 0; (y) < (unsigned)(end_y); (y)++) \
			for (z = 0; (z) < (unsigned)(end_z); (z)++)

#define MAP4(a, end_a, b, end_b, c, end_c, d, end_d) \
	for (unsigned a = 0; (a) < (unsigned)(end_a); (a)++) \
		for (unsigned b = 0; (b) < (unsigned)(end_b); (b)++) \
			for (unsigned c = 0; (c) < (unsigned)(end_c); (c)++) \
				for (unsigned d = 0; (d) < (unsigned)(end_d); (d)++)

/*===========================================================================*/
/* Debugging */
void rexit(const char * s);
void rpos_(const char * file, int line);
void rabort_(const char * file, int line);
void rassert_(int x, const char * file, int line);

#define Rpos() rpos_(__FILE__, __LINE__)
#define Rabort() rabort_(__FILE__, __LINE__)
#define Rassert(x) rassert_((x), __FILE__, __LINE__)

#ifndef ROB_DEBUG
#	define RPOS() do {} while (0)
#	define RDEBUG(x) do {} while (0)
#	define RDEBUG_START do {
#	define RDEBUG_END } while (0);
#	define RASSERT(x) do {} while (0)
#	define RLEVEL(x) do {} while (0)
#else
	extern int rob_debug_;
#	define RPOS() if (rob_debug_) rpos_(__FILE__, __LINE__)
#	define RDEBUG(x) if (rob_debug_) (x)
#	define RDEBUG_START if (rob_debug_) {
#	define RDEBUG_END }
#	define RASSERT(x) if (rob_debug_) rassert_((x), __FILE__, __LINE__)
#	define RLEVEL(x) (rob_debug_ = (x))
#endif

/*###########################################################################*/
#endif
