/********************************************************************/
/*******		File: fsm.C				*****/
/*******  Contains implementatinon of the FSM class		*****/
/********************************************************************/

#include "fsm.h"
#include "net.h"

// Not presently used
void
FSM::initialize(void)
{
mem_ok(decision_table = new Matrix<Boolean>(transitions.get_size(), inputs.get_size()));
decision_table->reset(FALSE);
}

// This message adds an output to the FSM by adding a column to the 
// action table. The column is sized by the number_of_states.
// If a NULL is passed, the message just returns.
// For new, we assume that there is no possibility that redundant output
// names can be specified. When we incorporate Symbol_table here, we should
// explicitly check for this.
FSM*
FSM::add_output(const char* add_output_name)
{
if (add_output_name) {
  // a check determining whether the output with the specified name is
  // already present should be inserted here.
  Array<Boolean>* new_column;
  Output_column *output;
  mem_ok(output = new Output_column);
  output->output_name = strdup2(add_output_name);
  mem_ok(new_column = new Array<Boolean>);
  new_column->reset(FALSE);
  output->action_table_column = new_column;
  action_table.append(output);
  }
return this;
}

// This message selects a row in the action table corresponding to the output
// with output_name. See optimization note in list_ar.h for get_position().
// If NULL is passed, the current_output_column does not change, and FALSE is
// returned. 
Boolean 
FSM::select_output(const char* output_name)
{
  if (output_name) {
    if ( strcmpl(current_output->output_name, output_name) ) {
      // current column does not match
      List_iterator<Output_column*> output_iterator;
      FOR_EACH_LISTNODE(action_table, output_iterator) { 
        if ( !strcmpl(output_iterator.get_item()->output_name, output_name) ) {
          current_output = output_iterator.get_item();
          return TRUE;
        } /* if */
      } /* FOR */
    } else { return TRUE; } // current column matches
  } /* if (output_name) */
  return FALSE;  // output_name was NULL or output not found
}

// Note: state_count is 0-based: [0, number_of_states).
// The 0th state is bound to RESET state.
FSM* 
FSM::set_active_state(int state_count, const char* output_name)
{
  FRITS_SET_MESSAGE("set_active_state");
  assert(state_count >= 0 && state_count < number_of_states);
  if (output_name) select_output(output_name);
  (*current_output->action_table_column) [state_count] = TRUE;
  return this;
}

// Assigns binary vector_value to vector_size cells (right-left) in the 
// state_count state. Starts from current_output_index or the output with
// output_name. Wraps around if hits the last column before vector_size is up.
// Used primarily for specifying fsm output for mux-tree select signals.
FSM* 
FSM::set_vector_active_state(int state_count, int vector_value, int vector_size, const char* output_name)
{
  FRITS_SET_MESSAGE("set_vector_active_state");
  assert(state_count >= 0 && state_count < number_of_states);
  List_iterator<Output_column*> output_iterator;
  Output_column* local_current_output;

  // expanded call of select_output()
  if (output_name) {
    if ( strcmpl(current_output->output_name, output_name) ) {
      // current column does not match
      FOR_EACH_LISTNODE(action_table, output_iterator) { 
        if ( !strcmpl(output_iterator.get_item()->output_name, output_name) ) {
          current_output = output_iterator.get_item();
        } /* if */
      } /* FOR */
    } // current column matches
  } /* if (output_name) */
  
  // Step through columns vector_size times
  for (int i = 0; i < vector_size; i++) {
    if ( !(local_current_output = output_iterator.get_item()) ) {
      output_iterator.increment();
      local_current_output = output_iterator.get_item();
    }  
    (*local_current_output->action_table_column) [state_count] = GETBIT(vector_value, i);
  } /* for */
  return this;
}

// A helper message for Scheduler::create_fsm().
// Based on the select_index value, creates an output of the FSM, 
// a select signal of the interconnect_unit, and connects them together
// with a new net which is returned.
Net* 
FSM::connect_to_mux_select(int select_index, Interconnect_unit*& iu)
{
FRITS_SET_MESSAGE("connect_to_mux_select");
STring output_name("X");
STring select_name("select");
char index[3];
char address[6];
Net* net;
output_name.cat(itoa(iu->get_address(), address, 10));
output_name.cat("_select");
output_name.cat(itoa(select_index, index, 10));
add_output(output_name.get());
// create a corresponding net and hook it up to dpelement and fsm
mem_ok(net = new Net(output_name.get()));
// form the select# name
select_name.cat(index);
// connect to select# port
iu->connect_select_to_net(net, select_name.get());
connect_to_net(net, output_name.get());
return net;
} 


#ifdef _SCALP_
#include "manager.h"
#include "express.h"
#include "entity.h"
#include "scaltype.h"

// This message generates a counter for the FSM which is compatible
// with the SYF program from Alliance.
Entity* 
FSM::get_counter_entity(void)
{
FRITS_SET_MESSAGE("get_counter_entity");
if (counter) return counter;
assure(number_of_states > 1);	// filter out the degenerate case
extern void *manager;
Manager* management = (Manager*)manager;
Entity *counter_template;
int i;
counter_template = management->search_package("utils")->
	search_component("counter_template")->get_entity();
assure(counter_template != NULL);
// Get a working copy of the counter
counter = counter_template /*->copy()*/;
counter->set_identifier("counter");
//counter->set_architecture(counter_template->get_architecture()->copy());
//counter->get_architecture()->set_entity(counter);
if ( number_of_states != 2 ) 	// if not matching the template
{				// have to modify the template
// Modify the width of the output
SigVarCon* onehotoutput = counter->get_port()->
	search_interface_element("OneHotOutput")->get_actual_object();
assure(onehotoutput != NULL);
Range* r;
mem_ok(r = new Range(number_of_states-1,0,_DOWNTO_));
onehotoutput->get_subtype_indication()->get_constraint()->
		get_discrete_range()->set_range(r);

// Modify the size and values of the present constants out0 and out1
Constant *c;
Block_declaration* bd;
bd = counter->get_architecture()->get_block_declaration();
c = bd->search_constant("out0");
c->get_subtype_indication()->get_constraint()->
		get_discrete_range()->set_range(r->copy());

Subtype_indication* si;
si = c->get_subtype_indication();  // to copy into all other constants

// Set value of the first constant
STring bit_string_value("\"0");
for (i=2; i < number_of_states; i++)	bit_string_value.cat("0");
bit_string_value.cat("1\"");
// all constants should have default values
c->get_expression()->get_value()->get_literal()->
	set_identifier(bit_string_value.get()); 

// Take care of the second constant in the similar manner
c = bd->search_constant("out1");
c->get_subtype_indication()->get_constraint()->
		get_discrete_range()->set_range(r->copy());

// Set value of the second constant
bit_string_value.set("\"0");
for (i=2; i < number_of_states - 1; i++)	
	bit_string_value.cat("0");
bit_string_value.cat("1");
bit_string_value.cat("0\"");
// all constants should have default values
c->get_expression()->get_value()->get_literal()->
	set_identifier(bit_string_value.get()); 

// Now create new constants to span the state space
STring constant_name;
char index[4];
for (i = number_of_states-1; i > 1; i--) // go through remaining states
	{
	mem_ok(c = new Constant);
	constant_name.set("out");
	constant_name.cat(itoa(i, index, 10));
	c->set_identifier(constant_name.get());
	c->set_subtype_indication(si->copy());
	Literal* l; mem_ok(l = new Literal);
	Primary* p; mem_ok(p = new Primary);
	bit_string_value.set("\"");
	for (int j = number_of_states-1; j >= 0; j--) // go through indexes
		{
		if ( i == j ) bit_string_value.cat("1");
		else bit_string_value.cat("0");	
		}
	bit_string_value.cat("\"");
	l->set_identifier(bit_string_value.get());
	p->set_literal(l);
	Expression* e; mem_ok(e = new Expression(p));
	c->set_expression(e);
	bd->add_constant(c);
	}

// Expand the STATE type by adding enumeration literals S#.
Scalar_type* state;
state = (Scalar_type*)bd->search_type("STATE");
assure(state != NULL);
IDentifier* id;
for (i = 2; i < number_of_states; i++)
	{
	mem_ok(id = new IDentifier("S"));
	id->cat(itoa(i, index, 10));
	state->add_enumeration_literal(id);
	}

// Update the NextState process
Process* p; 
Sequential_body* sb;
p = counter->get_architecture()->get_concurrent_body()->
				search_process("NextState");
assure(p != NULL);
assure( (sb = p->get_sequential_body()) != NULL);
Case* current_state_case;
current_state_case = sb->get_case();
Case_alternative *ca, *next_ca;
ca = current_state_case->get_case_alternative(2); // to be deleted in the end
STring id_name;
Sequential_body* casealt_sb;
Signal_assignment* sa;
for (i = 1; i < number_of_states; i++)
	{
	// copy a case alternative
	next_ca = ca->copy();
	// set identifier of the choice
	id_name.set("S"); id_name.cat(itoa(i, index, 10));
	id = state->search_enumeration_literal(id_name.get());	
	next_ca->get_choice()->get_simple_expression()->
					get_value()->set_identifier(id);
	// fix the assignments in the sequential body
	casealt_sb = next_ca->get_sequential_body();
	// assignemnt to NEXT_STATE
	sa = casealt_sb->search_signal_assignment("NEXT_STATE");
	id_name.set("S");
	if ( i != number_of_states-1 ) 
		id_name.cat(itoa(i+1, index, 10));
	else	id_name.cat("0");
	id = state->search_enumeration_literal(id_name.get());	
	sa->get_waveform_element()->get_value_expression()->get_value()->
		set_identifier(id);
	// assignemnt to OneHotOutput
	sa = casealt_sb->search_signal_assignment("OneHotOutput");
	id_name.set("out");
	id_name.cat(itoa(i, index, 10));
	c = bd->search_constant(id_name.get());	
	sa->get_waveform_element()->get_value_expression()->get_value()->
		set_actual_object(c);
	current_state_case->add_case_alternative(next_ca);
	}
current_state_case->delete_case_alternative(ca);
} /* if (number_of_states != 2) */
return counter;
}

// This message delivers the glue logic for the named control outputs
// of the FSM. If list is NULL, all outputs are assumed.
// Logic is simple: first, create an entity with one vector input and
// the named outputs, then create an architecture and add concurrent
// assignemnts corresponding to rows in the action_matrix.
// Since we are bound to SYF and Alliance, the result uses only bit and
// bit-vector types.
Entity* 
FSM::get_control_entity(List_ar<const char*> *output_names, Boolean inactive_low)
{
FRITS_SET_MESSAGE("get_control_entity");
assure(action_table.get_size != 0);
Boolean allports = FALSE;
List_iterator<Output_column*> iterator;
List_ar<Output_column*> *partial_output_list;
if (!output_names) {
  if (control) return control;
  else partial_output_list = &action_table;
} else {
  // Need this list to convert 'output_names' list to a list of Output_columns
  allports = TRUE;
  mem_ok(partial_output_list = new List_ar<Output_column*>);
  List_iterator<const char*> name_iterator;
  // Find the intersection of the two lists and put it in the partial_output_list
  FOR_EACH_LISTNODE(*output_names, name_iterator) {
    FOR_EACH_LISTNODE(action_table, iterator) {
      if (!strcmpl(name_iterator.get_item(), iterator.get_item()->output_name)) {
	partial_output_list->append(iterator.get_item());
	break;
      } /* if */
    }
  }
} /* if (!output_names) */

extern void *manager;
Manager* management = (Manager*)manager;
Entity* control_entity;
mem_ok(control_entity = new Entity);
STring control_name("control");
char control_index[4];
control_name.cat(itoa(number_of_control++, control_index, 10));
control_entity->set_identifier(control_name.get());

// Create architecture
Architecture* a;
Concurrent_body* cb;
mem_ok(cb = new Concurrent_body);
mem_ok(a=new Architecture(control_entity, NULL, cb));
a->set_identifier("behavioral");
control_entity->set_architecture(a);

// Create the port
Port* p;
mem_ok(p = new Port);
control_entity->set_port(p);

Signal *s, *s_onehot;
Subtype_indication* si;
Interface_element* ie;
Type_mark *bit, *bit_vector;
bit = management->search_package("standard")->search_type("bit");
bit_vector = management->search_package("standard")->search_type("bit_vector");

// Add OneHotOutput vector port
mem_ok(s_onehot = new Signal);
s_onehot->set_identifier("OneHotOutput");
mem_ok(si = new Subtype_indication);
si->set_type_mark(bit_vector);
Range* r;
mem_ok(r = new Range(number_of_states-1, 0, _DOWNTO_));
si->set_range(r);
s_onehot->set_subtype_indication(si);
mem_ok(ie = new Interface_element);
ie->set_signal(s_onehot);
ie->set_mode(_IN_);
p->add_interface_element(ie);

// Declarations for the concurrent assignments
Conditional_signal_assignment* csa;
Target* t;
Conditional_waveform* cw;
Waveform_element* we;
Expression *e, *e_index;
Primary *prim, *p_index;

// Process ports specified in the output_names list
FOR_EACH_LISTNODE(*partial_output_list, iterator)
	{
	// Interface part
	mem_ok(s = new Signal);
	s->set_identifier(iterator.get_item()->output_name);
	mem_ok(si = new Subtype_indication);
	si->set_type_mark(bit);
	s->set_subtype_indication(si);
	mem_ok(ie = new Interface_element);
	ie->set_signal(s);
	ie->set_mode(_OUT_);
	p->add_interface_element(ie);

	// Concurrent assignment part
	e = NULL;	// flag for the first vs. other terms
	mem_ok(csa = new Conditional_signal_assignment);
	mem_ok(t = new Target);
	Name* target_name;
	mem_ok(target_name = new Name);
	target_name->set_actual_object(s);
	t->set_name(target_name);
	csa->set_target(t);
	mem_ok(cw = new Conditional_waveform);
	mem_ok(we = new Waveform_element);
	// Set the expression of the Waveform_element based on the action_table
	select_output(iterator.get_item()->output_name);
	for (int i = 0; i < number_of_states; i++) {
	    if ( (*current_output->action_table_column) [i] ) {
		// if expression already present, need to add OR operator
		if (e)	e->add_operator(OR_);
		// create a new term for the expression
		mem_ok(prim = new Primary);
		prim->set_actual_object(s_onehot);
		mem_ok(p_index = new Primary);
		p_index->set_int((long)i);
		mem_ok(e_index = new Expression(p_index));
		prim->set_name_index(e_index);
		if (e) e->set_right(prim);
		else mem_ok(e = new Expression(prim));
	    } 
	}   
	if ( !e )	// the row for the output was empty
	    {
#ifdef DEVELOPER
	problem("Control signal %s is '0' in all states", iterator.get_item());
#endif
	    mem_ok(prim = new Primary);
	    Literal *l; mem_ok(l = new Literal);
	    IDentifier *zero; 
	    if (inactive_low) mem_ok(zero = new IDentifier("'0'"));
	    else mem_ok(zero = new IDentifier("'1'"));
	    l->set_character(zero);
	    prim->set_literal(l);
	    mem_ok(e = new Expression(prim));
	    }
	we->set_value_expression(e);
	cw->add_waveform_element(we);
	csa->add_conditional_waveform(cw);
	cb->add_conditional_signal_assignment(csa);
	}
control_entity->link_entity_signals();
if (allports) 
  control = control_entity;
return control_entity;
}

Component_instantiation* FSM::create_component_instantiation(Architecture* arch, const char* label)
{
  FRITS_SET_MESSAGE("create_component_instantiation");
  assert (counter != NULL && control != NULL);  // entities should have been created
  Component *counter_comp, *control_comp;
  Component_instantiation *counter_ci, *control_ci;

  // First, add components to the block declaration of the architecture
  mem_ok(counter_comp = new Component);
  counter_comp->set_entity(counter);
  if ( counter->get_generic() ) 
    counter_comp->set_generic(counter->get_generic()->copy(counter_comp));
  counter_comp->set_port(counter->get_port()->copy(counter_comp)); 
  mem_ok(control_comp = new Component);
  control_comp->set_entity(control);
  if ( control->get_generic() ) 
    control_comp->set_generic(control->get_generic()->copy(control_comp));
  control_comp->set_port(control->get_port()->copy(control_comp)); 
  Block_declaration* bd = arch->get_block_declaration();
  control_comp->set_identifier("control");
  counter_comp->set_identifier("counter");
  bd->add_component(control_comp);
  bd->add_component(counter_comp);
  // Add a "OneHotOutput" signal to the block declaration
  Signal *s;
  mem_ok(s = new Signal);
  s->set_identifier("OneHotOutput");
  s->set_subtype_indication(control->get_port()->
    search_interface_element("OneHotOutput")->get_actual_object()->
    get_subtype_indication()->copy());
  bd->add_signal(s);

  // Create component instantiations
  Name* compname;
  Generic_map* genmap;
  Port_map* portmap;
  Association_element* assoelem;
  Formal_designator* fd;
  Actual_designator* ad;
  mem_ok(counter_ci = new Component_instantiation);
  mem_ok(control_ci = new Component_instantiation);
  STring compinst_name;
  compinst_name.set(label);
  compinst_name.cat("counter");
  counter_ci->set_identifier(compinst_name.get());
  compinst_name.set(label);
  compinst_name.cat("control");
  control_ci->set_identifier(compinst_name.get());
  mem_ok(compname = new Name);
  compname->set_identifier(counter->get_name());
  counter_ci->set_component_name(compname);
  mem_ok(compname = new Name);
  compname->set_identifier(control->get_name());
  control_ci->set_component_name(compname);

  // Port map for the counter instantiation
  FRITS_object* net;
  mem_ok(portmap = new Port_map);

  // map "clk" port 
  mem_ok(assoelem = new Association_element);
  mem_ok(fd = new Formal_designator);
  mem_ok(ad = new Actual_designator);
  fd->set_name("clk");
  assoelem->set_formal_designator(fd);
  arch->st_search("clk", net);
  assert(net && !strcmp(net->get_id(), "Signal"));  // net exists in the architecture
  ad->set_actual_object((SigVarCon*)net); 
  assoelem->set_actual_designator(ad);
  portmap->add_association_element(assoelem);

  // map "reset" port 
  mem_ok(assoelem = new Association_element);
  mem_ok(fd = new Formal_designator);
  mem_ok(ad = new Actual_designator);
  fd->set_name("reset");
  assoelem->set_formal_designator(fd);
  arch->st_search("reset", net);
  assert(net && !strcmp(net->get_id(), "Signal"));  // net exists in the architecture
  ad->set_actual_object((SigVarCon*)net); 
  assoelem->set_actual_designator(ad);
  portmap->add_association_element(assoelem);

  // map "OneHotOutput" port 
  mem_ok(assoelem = new Association_element);
  mem_ok(fd = new Formal_designator);
  mem_ok(ad = new Actual_designator);
  fd->set_name("OneHotOutput");
  assoelem->set_formal_designator(fd);
  ad->set_actual_object(s); 
  assoelem->set_actual_designator(ad);
  portmap->add_association_element(assoelem);

  counter_ci->set_port_map(portmap);
  arch->get_concurrent_body()->add_component_instantiation(counter_ci);

  // Port map for the counter instantiation
  mem_ok(portmap = new Port_map);

  // map "OneHotOutput" port 
  mem_ok(assoelem = new Association_element);
  mem_ok(fd = new Formal_designator);
  mem_ok(ad = new Actual_designator);
  fd->set_name("OneHotOutput");
  assoelem->set_formal_designator(fd);
  ad->set_actual_object(s); 
  assoelem->set_actual_designator(ad);
  portmap->add_association_element(assoelem);

  // map all outputs of the control to the global nets.
  // It's somewhat a fake, since we assume that a port is mapped to a net
  // with the same name. However, this is the way nets are named in 
  // Scheduler::create_fsm. A proper way to do the mapping is through nets_list
  // (since it's present), but it's too inefficient because of list searches.

  List_iterator<Output_column*> outputs_iterator;
  FOR_EACH_LISTNODE(action_table, outputs_iterator) {
    mem_ok(assoelem = new Association_element);
    mem_ok(fd = new Formal_designator);
    mem_ok(ad = new Actual_designator);
    fd->set_name(outputs_iterator.get_item()->output_name);
    assoelem->set_formal_designator(fd);
    arch->st_search(get_net(outputs_iterator.get_item()->output_name)->
	get_name(), net);
    assert(net);  // net exists in the architecture
    ad->set_actual_object((SigVarCon*)net); 
    assoelem->set_actual_designator(ad);
    portmap->add_association_element(assoelem);
  } /* FOR */
      
  control_ci->set_port_map(portmap);
  arch->get_concurrent_body()->add_component_instantiation(control_ci);
  return NULL;
}

#endif /* _SCALP_ */

/********************************************************************/
#ifndef _SCALP_
// Print out a KISS format description of the FSM into
// a file with the given name
void FSM::write_kiss (char *filename)
{
  List_iterator<const char *>  inscan;        /*List of inputs     */
  List_iterator<Output_column *> columnscan;
  List_iterator<FSM_transition *> transcan;  /*List of transitions*/
  Output_column *curcolumn;
  int Incount  = 0;    /*Number of inputs */
  int Outcount = 0;    /*Number of outputs*/
  int i        = 0;    /*Counter to be used later*/
  int bitcount = 0;    /*Counter to count bits*/
  int fstate   = 0;    /*Temp to hold current state*/

  /*Writing to file*/
  char out_name[30];
  strcpy (out_name, filename);
  sprintf (out_name, "%s", filename);
  ofstream fout(out_name);

  /*Write inputs*/
  fout << "#Input_order:  ";
  FOR_EACH_LISTNODE(inputs, inscan)  {
    fout << inscan.get_item();  /*Print out the current input name*/
    fout << " ";                /*Print out a blank space*/
    Incount += 1;
  }
  fout << endl;
  fout << endl;

  /*Write Outputs*/
  fout << "#Output_order:  "; 
  FOR_EACH_LISTNODE(action_table, columnscan) {
    curcolumn = outscan.get_item();
    assert(curcolumn);
    fout << curcolumn->name;  /*Print out the current output name*/
    fout << " ";                 /*Print out a blank space*/
    Outcount += 1; 
    fout << endl;
  }
  fout << endl; 

  /*Write number of inputs and outputs*/
  fout << ".i ";
  fout << Incount;
  fout << endl;
  fout << ".o ";
  fout << Outcount;
  fout << endl;
  fout << endl;
  fout << endl;


  /*This is the extra line to provide transisiton from any*/
  /*state to the reset state under the condtion Reset=1.  */
  fout << "1 ANY S0 ";
  for (bitcount = 0; bitcount < Outcount; bitcount += 1) {
    fout << "-"; 
  }

  /*Write the input, transition, and output*/
  FSM_transition *mytransition;
  FOR_EACH_LISTNODE(controller->transitions, transcan) {
    
    fout << (*decision_table)[i][0];   /*Write input*/
    fout << " ";
    
    mytransition = transcan.get_item();
    fstate = mytransition->from_state;       /*Write     */
    fout << "S";
    fout << fstate;                          /*Transition*/
    fout << " S";
    fout << mytransition->to_state;
    fout << " ";


    /*Write the output*/
    FOR_EACH_LISTNODE(action_table, columnscan) {
      curcolumn = columnscan.get_item();
      assert(curcolumn);
      fout <<  curcolumn->action_table_column[fstate];
    }
      
    i += 1;  /*increment to next transition on decision table*/
  }
}
#endif
/********************************************************************/
