#include "wire.h"
#include "datapath.h"
#include "iscalp.h"
#include "i_macro.h"
//07252002
pair<float, float> Datapath::compute_gating_overhead
	(short tech, library *lib, Scm *scm)
{
	
	//Get the num of gated outputs
	//Get the num of gating signal switchings
	FUPTR fu;
	List_iterator<FUPTR> fuscan;
	List_iterator<EDGEPTR> varscan;
	List_node<EDGEPTR> *var, *var2;
	Storage_unit *reg;
	List_iterator<Storage_unit *> regscan;
	unsigned long gated_num(0), switch_num(0);
	FOR_EACH_LISTNODE(functional_units, fuscan) {
		fu = fuscan.get_item();
		assert(fu);
		Register outputs(NULL);
		vector<int> reg_list;
		vector<float> reduced_link;

		get_fu_reduced_output(outputs, reg_list, reduced_link,fu,scm);
		float sw_cost = scm->get_total_wiresw(outputs.get_variables());
		for(unsigned long i = 0; i<reg_list.size();i++) {
			if(sw_cost>reduced_link[i]) 
				gated_num++;
			reg = storage_units[reg_list[i]];
			var2 = NULL;
			bool single = true;
			FOR_EACH_LISTNODE(((Register *)reg)->get_variables(), varscan) {
				var = outputs.get_variables().find(varscan.get_item());
				if((var!=NULL) && (var2!=NULL)) {
					single = false;
					if(var2->get_next()!=var)
						switch_num++;
				}
				if(var!=NULL)
					var2 = var;
			}
			//if the receiver only take one variable from the sender
			//and the sender sends out more than one variable.
			if((single==true)&&(outputs.get_variables().get_size()>1))
				switch_num++;
		}
	}
	FOR_EACH_LISTNODE(storage_units, regscan) {
		reg = regscan.get_item();
		assert(reg);
		Register outputs(NULL);
		vector<int> fu_list;
		vector<float> reduced_link;

		get_reg_reduced_output(outputs, fu_list, reduced_link, reg, scm);
		float sw_cost = scm->get_total_wiresw(outputs.get_variables());
		for(unsigned long i = 0; i<fu_list.size(); i++) {
			if(sw_cost>reduced_link[i]) 
				gated_num++;
			fu = functional_units[fu_list[i]];	
			Register inputs(NULL);
			get_fu_input(inputs, fu);
			var2 = NULL;
			bool single = true;
			FOR_EACH_LISTNODE(inputs.get_variables(), varscan) {
				var = ((Register *)reg)->get_variables().find(varscan.get_item());
				if((var!=NULL) && (var2!=NULL)) {
					if(var2->get_next()!=var)
						switch_num++;
				}
				if(var!=NULL)
					var2 = var;
			}
                        if((single==true)&&(outputs.get_variables().get_size()>1))
	                                switch_num++;
		}
	}
	cout<<" Gated num = "<<gated_num<<" Switching num = "<<switch_num<<endl;	
	//Use the # of gated signals to estimate the control logic overhead
	gate_cap Gate;
	float energy, area;
	//Assume a activity factor as 0.5
	//20 double sized gates for each control signal;
	//3 fanouts
	energy = 0.5 * (float)gated_num * NUM_GATES_PER_CONTROL 
		* Gate.get_energy(GATE_SIZE, 1.0, tech)* NUM_FO*(float)get_csteps();//in pJoule      	
	area = (float) gated_num * NUM_GATES_PER_CONTROL 
		* Gate.get_area(GATE_SIZE, tech);// in um*um


	//Use the # of control signal switchings to estimate the control wire overhead
	wire_energy wire_en;
	float avg_length = sqrt(get_area_after_floorplan())*WIRE_LENGTH_SCALE;//mm
	float signal_en = 0.5*(float)(switch_num)*avg_length*wire_en.get_pattern_energy(1);
	signal_en *=lib->get_wire_scale_down();//pJoule
	signal_en +=signal_en;//To count the buffer/repeaters.
	
	control_energy_overhead = energy + signal_en;
	control_area_overhead = area;	
	return pair<float, float>(energy + signal_en, area);
}
 	
