/********Lin, 2001, Nov. 17 ******/ 
/*          FILE:iscalp.C        */
#include "iscalp.h"
#include "datapath.h"
#include <iostream>
#include <utility>
#include <vector>
#include <set>
#include "i_macro.h"
/********************************************************/
//To estimate spurious switching activity in FUs
float  Functional_unit::compute_sc(Scm *scm)
{
	NODEPTR node, pre_node(NULL);
	List_iterator<NODEPTR> nodescan;
	EDGEPTR input0, input1, last_var;
	STORPTR reg0, reg1;
	List_ar<EDGEPTR> v0, v1;
	List_node<EDGEPTR> *ln,*ln_next;
	unsigned int op_num = get_operations().get_size();
	unsigned int var_num;
	NODEPTR first_op = get_operations()[0];
	NODEPTR last_op  = get_operations()[op_num-1];
	//The FU is idle before the first operation
	if(first_op->get_birth()!=0) {
		//Then it takes inputs from input registers of the last operation 
		input0 = (last_op->get_input_edges())[0];
		input1 = (last_op->get_input_edges())[1];	
		assert(input0); assert(input1);
		reg0 = input0->get_storage_unit();
		reg1 = input1->get_storage_unit();
		assert(reg0); assert(reg1);
		var_num = reg0->get_variables().get_size();
		last_var = reg0->get_variables()[var_num-1];		
		assert(last_var);
		v0.append(last_var);
		
		var_num = reg1->get_variables().get_size();
                last_var = reg1->get_variables()[var_num-1];
                assert(last_var);
                v1.append(last_var);
	}
        input0 = first_op->get_input_edges()[0];
        input1 = first_op->get_input_edges()[1];
	assert(input0&&input1);
        v0.append(input0);v1.append(input1);

	for(int i=1; i<op_num; i++) {
		pre_node = get_operations()[i-1];
		node = get_operations()[i];
		//If the FU is idle between two operations
		if(pre_node->get_death()<node->get_birth()) {
			input0 = (pre_node->get_input_edges())[0];
			input1 = (pre_node->get_input_edges())[1];
			assert(input0&&input1);
			reg0 = input0->get_storage_unit();
			reg1 = input1->get_storage_unit();
			assert(reg0&&reg1);

			ln = reg0->get_variables().find(input0);
			assert(ln);
			ln_next = ln->get_next();
			while(ln_next) {
				input0 = ln_next->get_current();
				assert(input0);
				if(input0->get_birth()<node->get_birth()) {
					v0.append(input0);
					ln_next = ln_next->get_next();
				}
				else {
					ln_next = NULL;
				}
			}
                        
			ln = reg1->get_variables().find(input1);
                        assert(ln);
                        ln_next = ln->get_next();
                        while(ln_next) {
                                input1 = ln_next->get_current();
                                assert(input1);
                                if(input1->get_birth()<node->get_birth()) {
                                        v1.append(input1);
                                        ln_next = ln_next->get_next();
                                }
                                else {
                                        ln_next = NULL;
                                }
                        }
		}//end of if the FU is idle between the two operations
		input0 = (node->get_input_edges())[0];
		input1 = (node->get_input_edges())[1];
		assert(input0&&input1);
		v0.append(input0);v1.append(input1);
	}//end of for each operation bound to the FU.
	input0 = (last_op->get_input_edges())[0];
	input1 = (last_op->get_input_edges())[1];	
	assert(input0&&input1);
	reg0 = input0->get_storage_unit();
	reg1 = input1->get_storage_unit();
	assert(reg0&&reg1);
	
	ln = reg0->get_variables().find(input0);
	assert(ln);
	ln_next = ln->get_next();
	while(ln_next) {
		input0 = ln_next->get_current();
		assert(input0);
		v0.append(input0);
		ln_next = ln_next->get_next();
	}
        ln = reg1->get_variables().find(input1);
        assert(ln);
        ln_next = ln->get_next();
        while(ln_next) {
                input1 = ln_next->get_current();
                assert(input1);
                v1.append(input1);
                ln_next = ln_next->get_next();
        }
	//port 0
	float total = scm->get_fu_total_sc(get_libelement()->get_address(),v0,0);
	//port 1
	total += scm->get_fu_total_sc(get_libelement()->get_address(),v1,1);
#ifdef _LEAKAGE_IN_
	total +=(get_libelement()->get_leakage());
#endif
	return total;
}
float Functional_unit::compute_reduced_sc(Scm *scm)
{
	float total = scm->get_total_sc(get_libelement()->get_address(),
				get_operations());
#ifdef _LEAKAGE_IN_
	total +=(get_libelement()->get_leakage());	
#endif	
	return total;
}
/*********************************************************/
//The following is for neighborhood sensitive binding
void Functional_unit::compute_neighbors(void)
{
        NODEPTR node;
        List_iterator<NODEPTR> nodescan;
        NODEPTR parent, child;
        List_iterator<NODEPTR> parentscan, childscan;
        EDGEPTR edge;
        List_iterator<EDGEPTR> edgescan;
        FUPTR fu;

        /* To find all the behavioral neighors */
        neighbors.clear();
        FOR_EACH_LISTNODE(operations, nodescan) {
                node = nodescan.get_item();
                assert(node);
                //get its parent nodes;
                FOR_EACH_LISTNODE(node->get_input_edges(), edgescan) {
                        edge = edgescan.get_item();
                        assert(edge);
                        FOR_EACH_LISTNODE(edge->get_source_nodes(), parentscan) {
                                parent = parentscan.get_item();
                                assert(parent);
                                fu = parent->get_functional_unit();
                                assert(fu);
                                neighbors.insert(fu);
                        }
                }
               //get its child nodes
               FOR_EACH_LISTNODE(node->get_output_edges(), edgescan) {
                        edge = edgescan.get_item();
                        assert(edge);
                        FOR_EACH_LISTNODE(edge->get_sink_nodes(), childscan) {
                                child = childscan.get_item();
                                assert(child);
                                fu = child->get_functional_unit();
                                assert(fu);
                                neighbors.insert(fu);
                        }
                }

        }
	return; 
}
float Functional_unit::compute_nc(void)
{
	double nc(0.0);
	double area;
	double self_area = this->get_libelement()->get_area();
        set<FUPTR, fu_set_ltstr>::iterator neighborscan;

	compute_neighbors();
	const set<FUPTR, fu_set_ltstr> & b_n = get_neighbors(); 

	assert(self_area>0.0 && self_area<10000000000.0);
	self_area = sqrt(self_area);
	neighborscan = b_n.begin();
	for(; neighborscan!=b_n.end(); neighborscan++) {
		area = (*neighborscan)->get_libelement()->get_area();
		assert(area>0.0 && area<10000000000.0);
		area = sqrt(area);
		if(area<=self_area)
			nc += area;
		else
			nc +=self_area;
	}
	//cout<<"# of neighbors = "<<b_n.size()<<endl;
	_NC = (float)nc/self_area;		
	return _NC;
}
/*********************************************************/
void Register::compute_neighbors(void)
{
        NODEPTR node;
        List_iterator<NODEPTR> nodescan;
        EDGEPTR edge;
        List_iterator<EDGEPTR> edgescan;
        FUPTR fu;

        /* To find all the behavioral neighors */
        neighbors.clear();
        FOR_EACH_LISTNODE(variables, edgescan) {
                edge = edgescan.get_item();
                assert(edge);
                //get its source nodes;
                FOR_EACH_LISTNODE(edge->get_source_nodes(), nodescan) {
                        node = nodescan.get_item();
                        assert(node);
                        fu = node->get_functional_unit();
                        assert(fu);
                        neighbors.insert(fu);
                }
                //get its sink nodes;
                FOR_EACH_LISTNODE(edge->get_sink_nodes(), nodescan) {
                        node =nodescan.get_item();
                        assert(node);
                        fu = node->get_functional_unit();
                        assert(fu);
                        neighbors.insert(fu);
                }
        }
	return;
}
float Register::compute_nc(float reg_area)
{
        double nc(0.0);
        double area;
        double self_area = (float)reg_area;
        set<FUPTR, fu_set_ltstr>::iterator neighborscan;

	compute_neighbors();
	const set<FUPTR, fu_set_ltstr> & b_n = get_neighbors();

	assert(self_area>0.0 && self_area<10000000.0);
        self_area = sqrt(self_area);
        neighborscan = b_n.begin();
        for(; neighborscan!=b_n.end(); neighborscan++) {
                area = (*neighborscan)->get_libelement()->get_area();
		assert(area>0.0 && area<10000000.0);
                area = sqrt(area);
                if(area<=self_area)
                        nc += area;
                else
                        nc +=self_area;
        }
        _NC = (float) nc/self_area;
	//cout<<"# of neighbors = "<<neighbors.size()<<endl;
        return _NC;
}
float Datapath::compute_nc(library *lib)
{
	double nc(0.0);
	FUPTR fu;
	List_iterator<FUPTR> fuscan;
	Storage_unit *reg;
	List_iterator<Storage_unit *> regscan;
	FOR_EACH_LISTNODE(functional_units, fuscan) {
		fu = fuscan.get_item();
		assert(fu);
		nc +=fu->compute_nc();
	}
	FOR_EACH_LISTNODE(storage_units, regscan) {
		reg = regscan.get_item();
		assert(reg);
		nc +=((Register *)reg)->compute_nc(lib->get_reg_bit_area()* (float)get_bitwidth());
	}
	neighborhood_crowd = nc/(storage_units.get_size()+functional_units.get_size());
	return nc;
}

bool Datapath::check_nc(float local_threshold, float global_threshold)
{
        double nc(0.0), temp, cost(0.0);
	FUPTR fu;
	List_iterator<FUPTR> fuscan;
	Storage_unit *reg;
	List_iterator<Storage_unit *> regscan;

	FOR_EACH_LISTNODE(functional_units, fuscan) {
		fu = fuscan.get_item();
		assert(fu);
		temp = fu->get_nc()-local_threshold;
		if(temp>0.0)
			cost +=temp*temp;
	}
	FOR_EACH_LISTNODE(storage_units, regscan) {
		reg = regscan.get_item();
		assert(reg);
		temp = ((Register *)reg)->get_nc()-local_threshold;
		if(temp>0.0)
			cost +=temp*temp;
	}
	cost /=(storage_units.get_size()+functional_units.get_size());
	cost = sqrt(cost);
	if(cost > global_threshold)
		return false;
	else
		return true;
	return false;
}
		
/*************************************************************/
float Datapath::compute_sccost(library *lib, Scm *scm)
{
	float total(0.0), sc, reduced_sc;
	total = compute_reduced_module_sc(lib, scm);
	total +=compute_mux_sc(lib, scm);
	total +=compute_wire_sc(lib);
	//Note: buffers/repeaters power is approximated as the same as the wire they drive.
#ifdef PHYSICAL_DEBUG
	cout<<"Datapath::compute_sccost() ";
	cout<<" Logic Energy in pJoule = "<<get_module_sc();
	cout<<"  Wire Energy in pJoule = " <<get_wire_sc();	
	cout<<"  Mux Energy in pJoule = "<<get_mux_sc()<<endl;
	cout<<" TOTAL = "<<total<<endl;
	pair<float, float> tmp = compute_gating_overhead(1, lib, scm);
	cout<<" Gating overhead energy "<<tmp.first<<" area  "<<tmp.second<<endl;
	cout<<" wire energy computed by output network is "<<compute_wire_sc_new(lib, scm)<<endl;
	tmp = compute_shared_wire_sc(lib, scm);
	sc = tmp.first; reduced_sc = tmp.second;
	cout<<" wire energy of shared wire is "<<sc<<" reduced is "<<reduced_sc<<endl;
#endif	
	//Neighborhood sensitive binding
	//Check the neighborhood crowd for each module
	compute_nc(lib);
	cout<<" NC = "<<get_nc()<<endl;
#ifdef B_P	
	//check_nc(local_t, global_t);
	/*
	if(!check_nc(4.0, 1.0)) {
		total +=100000.0;
		printf("\n*******************Got rejected due to NC checking....**************\n");
	}
	*/
#endif	
	return total;
}

float Datapath::compute_module_sc(library *lib, Scm *scm)
{
  register FUPTR fu;
  register STORPTR reg;
  List_iterator<FUPTR> fuscan;
  List_iterator<Storage_unit *> regscan;
  float total = 0.0;

  assert(lib &&  scm);

  FOR_EACH_LISTNODE(functional_units, fuscan) {
    fu = fuscan.get_item();
    assert(fu);
    float tot=fu->compute_sc(scm);
    total +=tot;
#ifdef _LEAKAGE_IN_
    total+= fu->get_libelement()->get_leakage();
 #endif
  }
  FOR_EACH_LISTNODE(storage_units, regscan) {
    assert(!strcmp(regscan.get_item()->get_id(),"Register"));
    reg = (STORPTR) regscan.get_item();
    assert(reg);
    total += scm->get_total_sc(reg->get_variables());
  }
  total = total * FROM_35_to_18 * LIB_CLK;//pJoule
  total *= lib->get_gate_scale_down();
  module_sc = total;
  return(total);
}
float Datapath::compute_reduced_module_sc(library *lib, Scm *scm)
{
  register FUPTR fu;
  register STORPTR reg;
  List_iterator<FUPTR> fuscan;
  List_iterator<Storage_unit *> regscan;
  float total = 0.0;

  assert(lib &&  scm);

  FOR_EACH_LISTNODE(functional_units, fuscan) {
    fu = fuscan.get_item();
    assert(fu);
    total +=fu->compute_reduced_sc(scm);
#ifdef _LEAKAGE_IN_
    total+= fu->get_libelement()->get_leakage();
 #endif

  }
  FOR_EACH_LISTNODE(storage_units, regscan) {
    assert(!strcmp(regscan.get_item()->get_id(),"Register"));
    reg = (STORPTR) regscan.get_item();
    assert(reg);
    total += scm->get_total_sc(reg->get_variables());
  }
  total = total * FROM_35_to_18 * LIB_CLK;//pJoule
  total *= lib->get_gate_scale_down();
  module_sc = total;
  return(total);
}
/***************************************************/
float Datapath::compute_mux_sc(library *lib, Scm *scm) {

	double total(0.0);
	List_iterator<Interconnect_unit *> muxscan;
	Interconnect_unit * mux;
	//Check every functional unit's input
	FOR_EACH_LISTNODE(interconnect_units, muxscan) {
		mux = muxscan.get_item();
		assert(mux);
		total +=compute_mux_sc(*mux, lib, scm);
	}	
	total = total * FROM_35_to_18 * LIB_CLK;//pJoule
	total *= lib->get_gate_scale_down();
	mux_sc = total;
	return total;
}


////////////////////////////////
float Datapath::compute_mux_sc(Interconnect_unit &mux, library *lib, Scm *scm) const {

	unsigned short in_num; 
	Net *tmpnet; 
	assert(scm && lib);
	Datapath_element *dpunit; 
	in_num = mux.get_number_of_nets();
	if(in_num<3) {
		return 0.0;
	}
	double total(0.0);
	for( unsigned short i = 1 ; i< in_num ; i++) {
		char portname[10];
		sprintf(portname,"in%d",  i ); 
		tmpnet = mux.get_net(portname);
		assert(tmpnet);
		dpunit = tmpnet->get_driver();
		if(dpunit) {
			Register reg_temp(NULL);
			if(strcmp(dpunit->get_id(),"Register")) {
				//It is a functional unit
				vector<int> reg_list;	
				get_fu_output(reg_temp, reg_list, (FUPTR)dpunit);
			}
			else {
				//it is a register
				vector<int> fu_list;
				get_reg_output(reg_temp, fu_list, (Storage_unit *)dpunit);
			}
			total += scm->get_total_sc(reg_temp.get_variables());	
		} else {
			assert(pi_nets.find(tmpnet));
		}
	}
	total *= (MUX_POWER_PER_BIT/REG_POWER_PER_BIT);
	return total;	
}
////////////////////////////////////////////////////////////////////////////
float Datapath::compute_wire_sc(library *lib)
{
	if(!floorplan.is_ready()){
		cout<<"No floorplan available!"<<endl;
		assert(0);
	}
	clock_tree_sc = floorplan.clock_tree_sc()*WIRE_LENGTH_SCALE;
	clock_tree_sc *= lib->get_wire_scale_down();
	wire_sc = floorplan.total_wire_sc()*WIRE_LENGTH_SCALE;
	wire_sc *= lib->get_wire_scale_down();
	//To add buffer/repeater's cap
	wire_sc +=(BUFFER_FACTOR*wire_sc);
	return wire_sc;
}

//The following routine is for datapath power measurement only
float Datapath::compute_wire_sc(library *lib, Scm *scm) {
        if(!floorplan.is_ready()){
                cout<<"No floorplan available!"<<endl;
                assert(0);
        }
	generate_module_link(lib, scm);
	floorplan.set_tie(module_link);
	floorplan.generate_total_wire_sc();
        wire_sc = floorplan.total_wire_sc()*WIRE_LENGTH_SCALE;
        wire_sc *= lib->get_wire_scale_down();
	//To add buffer/repeated's cap
	wire_sc +=(BUFFER_FACTOR*wire_sc);
	return wire_sc;
}
//Compute the wire sc by output network 
//07212002
float Datapath::compute_wire_sc_new(library *lib, Scm *scm) {

	assert(floorplan.is_ready());
	FUPTR fu;
	List_iterator<FUPTR> fuscan;
	Storage_unit *reg;
	List_iterator<Storage_unit *> regscan;	
	float total_sc = 0.0;
	unsigned long index = 0;
	FOR_EACH_LISTNODE(functional_units, fuscan) {
		fu = fuscan.get_item();
		assert(fu);
		total_sc +=generate_fu_output_network_energy(lib, scm, 
				fu, index);
		index++;
	}
	index = 0;	
	FOR_EACH_LISTNODE(storage_units, regscan) {
		reg = regscan.get_item();
		assert(reg);
		total_sc +=generate_reg_output_network_energy(lib, scm,
				reg, index);
		index++;
	}
	float sc = total_sc*WIRE_LENGTH_SCALE*lib->get_wire_scale_down();
	//To add buffer/repeated's cap
	sc +=(BUFFER_FACTOR*sc);
	return sc;
}
//Compute the shared wire sc by output network( in the trunk branch style of Steiner Tree)
//07242002
pair<float, float> Datapath::compute_shared_wire_sc(library *lib, Scm *scm) {

        assert(floorplan.is_ready());
        FUPTR fu;
        List_iterator<FUPTR> fuscan;
        Storage_unit *reg;
        List_iterator<Storage_unit *> regscan;
	float sc(0.0), reduced_sc(0.0);
        unsigned long index = 0;
        FOR_EACH_LISTNODE(functional_units, fuscan) {
                fu = fuscan.get_item();
                assert(fu);
		pair<float, float> total_sc = generate_fu_shared_output_network_energy(lib, scm,
                                fu, index);
		sc +=total_sc.first;
		reduced_sc +=total_sc.second;
                index++;
        }
        index = 0;
        FOR_EACH_LISTNODE(storage_units, regscan) {
                reg = regscan.get_item();
                assert(reg);
                pair<float, float> total_sc =generate_reg_shared_output_network_energy(lib, scm,
                                reg, index);
                sc +=total_sc.first;
                reduced_sc +=total_sc.second;
                index++;
        }
        sc *= (WIRE_LENGTH_SCALE*lib->get_wire_scale_down());
        reduced_sc *= (WIRE_LENGTH_SCALE*lib->get_wire_scale_down());
	//To add buffer/repeated's cap
	sc +=(BUFFER_FACTOR*sc);
	reduced_sc +=reduced_sc;
        return pair<float, float>(sc, reduced_sc);
}

/////////////////////////////////////////////////////////////////////////
float Datapath::compute_reduced_mux_sc( library *lib, Scm *scm)  {
        double total(0.0);
        List_iterator<Interconnect_unit *> muxscan;
        Interconnect_unit * mux;
        //Check every functional unit's input
        FOR_EACH_LISTNODE(interconnect_units, muxscan) {
                mux = muxscan.get_item();
                assert(mux);
		total +=compute_reduced_mux_sc(*mux, lib, scm);
	}
	total = total * FROM_35_to_18 * LIB_CLK;//pJoule
	total *= lib->get_gate_scale_down();
	mux_sc = total;
	return total;
}

float Datapath::compute_reduced_mux_sc( Interconnect_unit & mux, library *lib , Scm *scm) const {
        unsigned short in_num;
        Net *tmpnet;
        assert(scm && lib);
        Datapath_element *dpunit;
	NODEPTR node;
	List_iterator<NODEPTR> nodescan;
	EDGEPTR edge;
	List_iterator<EDGEPTR> edgescan;
        in_num = mux.get_number_of_nets();
        if(in_num<3) {
                return 0.0;
        }
        double total(0.0);
        Register reg_temp(NULL);
	Register reg_temp2(NULL);
        for( unsigned short i = 1 ; i< in_num ; i++) {
                char portname[10];
                sprintf(portname,"in%d",  i );
                tmpnet = mux.get_net(portname);
                assert(tmpnet);

		dpunit  = tmpnet->get_driver();
                if(dpunit) {
                        if(strcmp(dpunit->get_id(),"Register")) {
                                //It is a functional unit
                                vector<int> reg_list;
                                get_fu_output(reg_temp, reg_list, (FUPTR)dpunit);
                        } else {
                                //it is a register
                                vector<int> fu_list;
                                get_reg_output(reg_temp, fu_list, (Storage_unit *)dpunit);
                        }
                } else {
                        assert(pi_nets.find(tmpnet));
			continue;
                }
		assert(reg_temp.get_variables().get_size());
		List_ar< Datapath_element *> dpunits; 
		tmpnet = mux.get_net(MUXOUT);
                tmpnet->get_load(dpunits);
                if(dpunits.get_size()>0) {
			assert(dpunits.get_size()==1);
			dpunit = dpunits[0];
			if(strcmp(dpunit->get_id(), "Register")) {
				//Functional unit
				FOR_EACH_LISTNODE(((FUPTR)dpunit)->get_operations(), nodescan) {
					node = nodescan.get_item();
					assert(node);
					FOR_EACH_LISTNODE(node->get_input_edges(), edgescan) {
						edge = edgescan.get_item();
						if(reg_temp.get_variables().find(edge)){
							if(reg_temp2.get_variables().find(edge)==NULL) {
								reg_temp2.add_variable(edge);
							}
						}
					}
				}
			}
			else {
				//Register
				assert(((Register *)dpunit)->get_variables().get_size()>0);
				FOR_EACH_LISTNODE( ((Register *)dpunit)->get_variables(), edgescan) {
					edge = edgescan.get_item();
					assert(edge);
					if(reg_temp.get_variables().find(edge)) {
						if(reg_temp2.get_variables().find(edge)==NULL) {
							reg_temp2.add_variable(edge);
						}
					}
				}
			}
			if(reg_temp2.get_variables().get_size()>0){
				double new_val =  scm->get_total_sc(reg_temp2.get_variables());	
		                total += new_val;
				new_val =  scm->get_total_sc(reg_temp.get_variables());
			} 
		}
		else {
			cout<<"MUX has no load"<<endl;
			assert(0);
		}
		reg_temp2.clear_variables();
		reg_temp.clear_variables();
	}
        total *= (MUX_POWER_PER_BIT/REG_POWER_PER_BIT);
        return total;
}
/////////////////////////////////////////////////////////////////////////
float Datapath::compute_reduced_wire_sc(library *lib, Scm *scm) {
	if(!floorplan.is_ready()) {
		cout<<"No floorplan available!"<<endl;
		assert(0);
	}
	generate_reduced_module_link(lib, scm);
	floorplan.set_tie(module_link);
	floorplan.generate_total_wire_sc();
	float sc = floorplan.total_wire_sc()*WIRE_LENGTH_SCALE;
	sc *= lib->get_wire_scale_down();
	//To add buffer/repeated's cap
	sc +=(BUFFER_FACTOR*sc);
	return sc;
}

