/***********Lin, 2001, Nov.17*********/
#ifndef I_SCALP
#define I_SCALP
#include "scheduler.h"
#include "scm.h"
#include "FloorPlan2.h"
class iScheduler: public Scheduler {
	

	protected:
		Scm *scm;
	public:
		iScheduler():Scheduler(){ return;}
		~iScheduler(){return;}
		//redefined
		virtual Datapath *areaschedule(Dfg &, library *, 
				const float, const float, const int);
		virtual Datapath *lpschedule(Dfg &, library *, 
				const float, const float, Scm *, 
				const Boolean, char *, const int); 
		virtual void iterative_improvement(Dfg &, library *, 
				Datapath * &, const float, 
				const float, const objective &, Scm * = (Scm *)NULL);
		virtual void iterative_reg_improvement(Dfg &, library *, 
				Datapath * &, const float, const float, 
				const objective &, Scm * = (Scm *)NULL);
		virtual Boolean generate_move(Dfg &, library *, Datapath *, Schalloc_info &,
                	         Array<Boolean> &, Array<Boolean> &, Scm *, const objective);
		virtual Boolean generate_reg_move(Dfg &, library *, Datapath *, Schalloc_info &,
		                 Array<Boolean> &, Array<Boolean> &, Scm *, const objective);

		virtual Boolean find_best_class_b_fu_move(
				Dfg &flowgraph, library *lib, Datapath *dp, 
				Schalloc_info &cur_dfg_info, 
				Array<Boolean> &nodes_visited,
				Scm *scms, const objective obj, 
				Class_b_fu_move &best_move,
                                float &best_gain);
		virtual Boolean find_best_class_b_reg_move(
				Dfg &, library *, Datapath *, Schalloc_info &,
                                 Array<Boolean> &, Scm *, const objective,
                                 Class_b_reg_move &, float &);

		float communication_gain(Datapath *dp, Class_b_fu_move &move, Scm *scms, library *lib);
		float communication_gain(Datapath *dp, Class_b_reg_move &move, Scm *scms, library *lib);
		float neighborhood_crowd_gain(Datapath *dp, Class_b_fu_move &move, library *lib);
		float neighborhood_crowd_gain(Datapath *dp, Class_b_reg_move &move, library *lib);
		virtual float compute_scgain(Datapath *dp, Class_b_fu_move &move, 
				Scm *scms, library *lib);
		virtual float compute_scgain(Datapath *dp, Class_b_reg_move &move,
				Scm *scms, library *lib);
		//redefined
		//virtual float compute_areacost(Datapath *, library *);
		//virtual float compute_sccost(Datapath *, library *, Scm *);
		//redefined
		//float compute_areagain(Datapath *, library *, Class_a_move &);
		//redefined
		//float compute_areagain(Datapath *, library *, Class_b_fu_move &);
		void set_scm(Scm *scms){scm = scms;return;}

		
};//class iScheduler

#endif
