#include "wire.h"

float wire_energy::get_wire_energy(unsigned int previous, unsigned int current, int bitwidth) const {

	assert(bitwidth<=MAX_BIT_NUM);
	float retval = 0.0;
	bool val1[MAX_BIT_NUM], val2[MAX_BIT_NUM];
	
	for(short i = 0; i <bitwidth; i++){
		val1[i] = (((previous>>i) & 0x1)==1)? true:false; 
		val2[i] = (((current>>i) & 0x1)==1)? true:false;;
	}
	//process two bits on the edge
	retval+= get_energy(val1[0], val1[1], val2[0], val2[1]);
	retval+=get_energy(val1[bitwidth-1], val1[bitwidth-2],
				val2[bitwidth-1], val2[bitwidth-2]);
	for(short i = 1; i<(bitwidth-1);i++){
		retval+=get_energy(val1[i-1], val1[i], val1[i+1],
					val2[i-1], val2[i], val2[i+1]);
	}
	
	return retval;
}

float wire_energy::get_energy(bool A0, bool A1, bool B0, bool B1) const
{
	pattern first, second;
	first = get_sw_pattern(A0, B0);
	second = get_sw_pattern(A1, B1);
	if(first==second){
		if(first==SILENT)
			return wire_sw_energy[sss];
		else
			return wire_sw_energy[stt];
	}
	else if(first==SILENT)
			return wire_sw_energy[sst];
	else if(second==SILENT)
			return wire_sw_energy[sts];	
	else
			return wire_sw_energy[sta];
}

float wire_energy::get_energy(bool A0, bool A1, bool A2, 
				bool B0, bool B1, bool B2) const
{
	pattern left, center, right;
	left = get_sw_pattern(A0, B0);
	center = get_sw_pattern(A1, B1);
	right = get_sw_pattern(A2, B2);
	//lzhong 08132002 for non-coupling cases
	if(center!=SILENT)
		return 0.025;
/*
	if(left==SILENT&&center==SILENT&&right==SILENT)
		return wire_sw_energy[sss];
	if(left==SILENT&& center==UP&&right==SILENT)
		return wire_sw_energy[sts];
	if(left==SILENT&&center==DOWN&&right==SILENT)
		return wire_sw_energy[sts];
	if (left==SILENT&&center==SILENT&&right==UP) 
		return wire_sw_energy[sst];
	if (left==SILENT&&center==SILENT&&right==DOWN) 
		return wire_sw_energy[sst];
	if (left==UP&&center==SILENT&&right==SILENT) 	
		return wire_sw_energy[sst];
	if (left==DOWN&&center==SILENT&&right==SILENT) 
		return wire_sw_energy[sst];
	if (left==UP&&center==SILENT&&right==UP) 
		return wire_sw_energy[tst];
	if (left==DOWN&&center==SILENT&&right==DOWN) 
		return wire_sw_energy[tst];
	if (left==UP&&center==SILENT&&right==DOWN) 
		return wire_sw_energy[tsa];
	if (left==DOWN&&center==SILENT&&right==UP) 
		return wire_sw_energy[tsa];
	if (left==DOWN&&center==DOWN&&right==DOWN)
		return wire_sw_energy[ttt];
	if (left==UP&&center==UP&&right==UP)
		return wire_sw_energy[ttt];
	if (left==SILENT&&center==UP&&right==UP) 
		return wire_sw_energy[stt];
	if (left==SILENT&&center==DOWN&&right==DOWN) 
		return wire_sw_energy[stt];	
	if (left==UP&&center==UP&&right==SILENT) 	
		return wire_sw_energy[stt];	
	if (left==DOWN&&center==DOWN&&right==SILENT) 	
		return wire_sw_energy[stt];	
	if (left==UP&&center==UP&&right==DOWN)
		return wire_sw_energy[tta];
	if (left==DOWN&&center==DOWN&&right==UP)
		return wire_sw_energy[tta];	
	if (left==UP&&center==DOWN&&right==DOWN) 
		return wire_sw_energy[tta];
	if (left==DOWN&&center==UP&&right==UP) 
		return wire_sw_energy[tta];	
	if (left==SILENT&&center==UP&&right==DOWN) 
		return wire_sw_energy[sta];
	if (left==SILENT&&center==DOWN&&right==UP) 
		return wire_sw_energy[sta];
	if (left==DOWN&&center== UP&&right==SILENT) 
		return wire_sw_energy[sta];
	if (left==UP&&center==DOWN&&right==SILENT) 
		return wire_sw_energy[sta];	
	if (left==DOWN&&center==UP&&right==DOWN) 
		return wire_sw_energy[ata];
	if(left==UP&&center==DOWN&&right== UP) 
		return wire_sw_energy[ata];	
	assert(0);
	*/
	return 0.0;
}
