/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*              FILE: libelem.C                                     */
/* Contains an implementation of a class Library_element and its    */
/*	subclasses 						    */
/********************************************************************/

#include "libelem.h"
#ifdef _IMPACT_
#include "entity.h"
#include "express.h"
#include "componen.h"
#endif

/********************************************************************/
#ifdef _IMPACT_
  Library_element::Library_element(Component *comp) : data_ports(), control_ports()
{
  FRITS_SET_CLASS("Library_element");
  FRITS_SET_MESSAGE("Library_element");
  int i;
  number_input_ports = 0;
  number_output_ports = 0;
  number_ports = 0;
  bitwidth = 8;	// HACK

  mem_ok( port_info_index = new Symbol_table );

  assert(comp);
  frits_component = comp;
  Entity* e = comp->get_entity();
  name = strdup2(e->get_identifier());

  Interface_element* ie = NULL;
  if ( !(ie = e->get_generic()->search_interface_element("area")) ) {
    error("Area generic not found in component '%s'", name);
    area = 0;
  } else {
    area = ie->get_expression()->get_actual_int();
  }

  // Preinitialize delay storage
  delay = 0; port_delay = NULL; bit_delay = NULL;

  
  Port* entity_port = e->get_port();
  Library_element_port* lep;
  Attribute* at;
  if ( !(at = e->search_attribute("IsData")) ||
      strcmpl(at->get_type_mark()->get_identifier(), "boolean") ) {
    problem("Attribute IsData : BOOLEAN missing in component '%s'", name);
    at = NULL;
  }

  number_ports = entity_port->number_of_interface_element();
  port_infos = new Port_info* [number_ports];
  for ( i=1; i <= number_ports; i++ ) {
   
    if ( i == 1 ) ie = entity_port->get_interface_element(1);
    else ie = entity_port->get_interface_element();
    int port_mode;
    Port_info* port_info;
    mem_ok( lep = new Library_element_port(ie->get_identifier(),
                port_mode=ie->get_mode(), ie->get_signal()->get_bitwidth()) );
    mem_ok( port_info = new Port_info(lep) );
    port_info->portlist_index = i;

    switch (port_mode)	{
	case _OUT_:	// port_class is OUTPUT by default
      		port_info->delay_matrix_index = number_output_ports++;
      		add_data_port(lep);
		// Store the port_info
		port_infos[i-1]=port_info;
		port_info_index->st_add(port_info, ie->get_identifier());
		break;
	case _IN_:	port_info->delay_matrix_index = number_input_ports++;
	      	// Some error checking
	      	Attribute_specification* as;
	      	if ( at && !(as = e->search_attribute_specification("IsData", ie->get_identifier())) ) {
			problem("Attribute IsData is not defined for port '%s' of component '%s'", ie->get_identifier(), name);
			add_data_port(lep->set_port_class(DATA));
	      	} else if ( at && !strcmpl(as->get_expression()->get_value()->get_name(),"false") ) {
			add_control_port(lep->set_port_class(CONTROL));
			port_info->is_data = FALSE;
		} else {
		  	add_data_port(lep->set_port_class(DATA));
		}
		// Store the port_info
		port_infos[i-1]=port_info;
		port_info_index->st_add(port_info, ie->get_identifier());
	
	default: error("Unsupported port type for port '%s' in component '%s'", 
			ie->get_identifier(), name);
		 delete port_info; delete lep; port_infos[i-1] = NULL;
		 break;
    } /* switch (port_mode) */
  }  /* for */

 
  Generic* g = e->get_generic();
  if ( (ie = g->search_interface_element("tpd")) ) 
	{
       
    	delay = ie->get_expression()->get_value()->get_literal()->get_decimal();
  	} 
  else  // port-to-port delays specified
	{
	// create the delay matrix first
	port_delay = new Matrix<float>(number_input_ports, number_output_ports);
	port_delay->reset(0.0);
 	List_iterator<class Library_element_port *> input_ports_iterator;  
 	List_iterator<class Library_element_port *> output_ports_iterator;
	STring generic_name;  
	FRITS_object* foin;
	FRITS_object* foout;
	FOR_EACH_LISTNODE(input_ports, input_ports_iterator)
	    FOR_EACH_LISTNODE(output_ports, output_ports_iterator)
		{
		// Costruct the name of generic to search for
		generic_name.set("tpd_");
		generic_name.cat(input_ports_iterator.get_item()->get_name());
		generic_name.cat("_");
		generic_name.cat(output_ports_iterator.get_item()->get_name());
		port_info_index->st_search_local(input_ports_iterator.get_item()->get_name(), foin);
		port_info_index->st_search_local(output_ports_iterator.get_item()->get_name(), foout);
		// Some sanity checks
		assert(foin); assert(foout);
		assert( ((Port_info*)foin)->delay_matrix_index >= 0 && 
			((Port_info*)foout)->delay_matrix_index >= 0 );
		// Retrieve the generic
		if ( (ie = g->search_interface_element(generic_name.get())) )
		    {
		    Literal* l = ie->get_expression()->get_value()->get_literal();
		    (*port_delay)[((Port_info*)foin)->delay_matrix_index][((Port_info*)foout)->delay_matrix_index] = 
			( l->get_object() == _REAL_ ? l->get_real() : (float)l->get_decimal() );
		    }
		else
		    error("Delay generic '%s' not found in Component '%s'", generic_name.get(), name);
		}
	}  /* if (search...("tpd")) */

// Get the bitwidth information
  if ( (ie = g->search_interface_element("bitwidth")) )	// generic present
	{ 
    	bitwidth = ie->get_expression()->get_value()->get_literal()->get_decimal();
	}
  else	
	{
  	FRITS_object* port_info;
	port_info_index->st_search_local("in1", port_info);
	if (port_info)
		bitwidth = 
		( (Library_element_port*) ((Port_info*)port_info)->portptr )->
		get_bitwidth();
	else
		bitwidth = 0;
	}
  
  return;
}
#else
/********************************************************************/
  Library_element::Library_element(const char* element_name, float element_area, float element_delay) : ports() {
    assert(element_name);
    assert(strlen(element_name) < MAXSTRLEN);
    strcpy(name, element_name);
    assert(element_area > 0.0);
    area = element_area;
    assert(element_delay > 0.0);
    delay = element_delay;
    return;
  }
#endif
/********************************************************************/

 Library_element::~Library_element() {
    if (port_delay) delete port_delay;
    if (bit_delay) delete bit_delay;
#ifdef _IMPACT_
    //name is defined using strdup2, a FRITS function which uses 'new'
    delete [] name;  
    delete port_info_index;
#else
    free(name);
#endif
    if (port_infos) {
	for (int i = 0; i < number_ports; i++)
	    delete port_infos[i];
	delete [] port_infos;
    }
  }

/********************************************************************/

Library_element *Library_element::add_data_port(Library_element_port *new_port)
{
  FRITS_SET_MESSAGE("add_data_port");
  //check that the fields of new_port make sense, and then append it to the list
  int bitwidth;
  assert(new_port /* && (bitwidth = new_port->get_bitwidth()) > 0.0 */);
 
  data_ports.append(new_port);
  switch (new_port->get_type()) {
	case _IN_: input_ports.append(new_port); break;
	case _OUT_: output_ports.append(new_port); break;
	default: error("Cannot add port '%s' to library element '%s' : unsupported type", new_port->get_name(), name);
	}
  return this;
}
/********************************************************************/
Library_element *Library_element::add_control_port(Library_element_port *new_port)
{
  FRITS_SET_MESSAGE("add_control_port");
  //check that the fields of new_port make sense, and then append it to the list
  int bitwidth;
 
  assert(new_port);
  control_ports.append(new_port);
  return this;
}
/********************************************************************/
#ifdef _IMPACT_
Functional_library_element::Functional_library_element(Component *comp) : Library_element(comp)
{
  FRITS_SET_CLASS("Functonal_library_element");
  char* operation;
  functions = new Boolean [ALLOPS + 1];
  for (int i = 0; i <= ALLOPS; i++) {
    functions[i] = FALSE;
  }
 
  operation = strtok((char*)comp->get_entity()->
		     search_attribute_specification("operations")->
       get_expression()->get_value()->get_name(), ",");
  while (operation) {
    if ( strstr(operation, "*") ) add_function(MULT_);
    else if ( strstr(operation, "+") ) add_function(PLUS_);
    else if ( strstr(operation, "-") ) add_function(MINUS_);
    operation = strtok(NULL, ",");
  }
  Attribute_specification* pstages;
  if ( pstages = comp->get_entity()->
	search_attribute_specification("PipelineStages") )
	pipeline_stages = pstages->get_expression()->get_actual_int();
  else
	pipeline_stages = 1;
}
#else
  Functional_library_element(const char* element_name, float element_area, float element_delay) : Library_element (element_name, element_area, element_delay), functions()
{
}
#endif

const float
Library_element::get_delay(const char* input_port_name, const char* output_port_name)
{
FRITS_SET_MESSAGE("get_delay");
FRITS_object *input_port_info, *output_port_info;
// Look up the ports
port_info_index->st_search_local(input_port_name, input_port_info);
port_info_index->st_search_local(output_port_name, output_port_info);

assert(input_port_info);
assert(output_port_info);
assert( ((Port_info*)input_port_info)->portptr->get_type() == _IN_ );
assert( ((Port_info*)output_port_info)->portptr->get_type() == _OUT_ );

if (port_delay)
	return (*port_delay) [((Port_info*)input_port_info)->delay_matrix_index] [((Port_info*)output_port_info)->delay_matrix_index];
else
	return delay; 
}

const float
Library_element::get_delay(int input_port_index, int output_port_index)
{
FRITS_SET_MESSAGE("get_delay");
assert(input_port_index <= number_ports);
assert(output_port_index <= number_ports);
assert_force( (port_infos[input_port_index-1])->portptr->get_type() == _IN_ );
assert_force( (port_infos[output_port_index-1])->portptr->get_type() == _OUT_ );

if (port_delay)
	return (*port_delay) 
		[(port_infos[input_port_index-1])->delay_matrix_index]  
		[(port_infos[output_port_index-1])->delay_matrix_index];
else
	return delay;
}


/********************************************************************/
