/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */
/*
///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>
*/

%{
void yyerror(const char *);
int trace(char *, char *);
int yylineno = 1;
%}
whitesp         [ \t]
newline         [\n]
num             [0-9]
alpha           [A-Za-z]
alnum           [A-Za-z0-9_<>$%:+\-*/&|\^\!]
dot             [.]
equal           [=]

%%
{dot}{alpha}({alnum}*)		{
			  if(!strcmp(yytext, ".begin"))		{ trace(yytext,"BEGIN_MODULE"); return BEGIN_MODULE; }
			  else if(!strcmp(yytext, ".end")) 	{ trace(yytext,"END_MODULE"); return END_MODULE; }
			  else if(!strcmp(yytext, ".bitwidth")) 	{ trace(yytext,"BITWIDTH"); return BITWIDTH; }
			  else if(!strcmp(yytext, ".area")) 	{ trace(yytext,"AREA"); return AREA; }
			  else if(!strcmp(yytext, ".delay")) 	{ trace(yytext,"LIBDELAY"); return LIBDELAY; }
			  else if(!strcmp(yytext, ".power")) 	{ trace(yytext,"POWER"); return POWER; }
			  else if(!strcmp(yytext,".operations")){ trace(yytext,"OPERATIONS"); return OPERATIONS; }
			  else if(!strcmp(yytext,".stages"))    { trace(yytext,"STAGES"); return STAGES; }
                          else if(!strcmp(yytext,".leakage"))    { trace(yytext,"LEAKAGE"); return LEAKAGE; }
			  else if(!strcmp(yytext, ".m+")) 	{ trace(yytext,"OPER_ADD"); return OPER_ADD; }
			  else if(!strcmp(yytext, ".m-")) 	{ trace(yytext,"OPER_SUB"); return OPER_SUB; }
			  else if(!strcmp(yytext, ".m*")) 	{ trace(yytext,"OPER_MUL"); return OPER_MUL; }
			  else if(!strcmp(yytext, ".m/")) 	{ trace(yytext,"OPER_DIV"); return OPER_DIV; }
			  else if(!strcmp(yytext, ".m&")) 	{ trace(yytext,"OPER_AND"); return OPER_AND; }
			  else if(!strcmp(yytext, ".m|")) 	{ trace(yytext,"OPER_OR"); return OPER_OR; }
			  else if(!strcmp(yytext, ".m^")) 	{ trace(yytext,"OPER_XOR"); return OPER_XOR; }
			  else if(!strcmp(yytext, ".m<>")) 	{ trace(yytext,"OPER_NOTEQ"); return OPER_NOTEQ; }
			  else if(!strcmp(yytext, ".m!")) 	{ trace(yytext,"OPER_NOT"); return OPER_NOT; }
			  else if(!strcmp(yytext, ".m>")) 	{ trace(yytext,"OPER_GT"); return OPER_GT; }
			  else if(!strcmp(yytext, ".m<")) 	{ trace(yytext,"OPER_LT"); return OPER_LT; }
			  else if(!strcmp(yytext, ".meq")) 	{ trace(yytext,"OPER_EQ"); return OPER_EQ; }
			  else if(!strcmp(yytext, ".load")) 	{ trace(yytext,"OPER_EQ"); return OPER_LW; }
			  else if(!strcmp(yytext, ".store")) 	{ trace(yytext,"OPER_EQ"); return OPER_SW; }
			  else { yyerror("bad keyword"); }
			}/*has to be a keyword*/

{num}+			{ trace(yytext, "INTNUMBER"); yylval.intval = atoi(yytext); return INTNUMBER;}
({num}+)(({dot}({num}+))?) { trace(yytext, "FLTNUMBER"); yylval.fltval = atof(yytext); return FLTNUMBER;}
{alpha}({alnum}*)       { trace(yytext,"IDENTIFIER"); strcpy(yylval.charptr,yytext); return IDENTIFIER; }
{newline}               {yylineno++;/* if((yylineno%10) == 0) cout << "
" << "*  Line: " << yylineno; */}
{whitesp}+		;
#.*			; /*COMMENT*/
.			{ trace(yytext,"ERROR"); yyerror("Bad character/keyword/identifier"); }
%%
void yyerror(const char *errmsg)
{
  cout << "ERROR: Line " << yylineno << ": " << errmsg << endl;
  return;
}

int trace(char *text, char *token)
{
  //printf("Line: %d Text: %s returning %s\n", yylineno,text,token);
  return(0);
}
