/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*              FILE: libmanag.h                                    */
/* Contains an implementation of a Library_manager class	    */
/********************************************************************/

#include "libmanag.h"

void
Library_manager::set_library(Library_package* library)
{
FRITS_SET_MESSAGE("set_library");
assert(library);
int i;
// Dump all the storage
for ( i=0; i<ALLOPS; i++ )
	delete functional_library_elements[i];
delete storage_library_elements;
delete interconnect_library_elements;
delete libraries;
// Create new storage
for ( i=0; i<ALLOPS; i++ )
	mem_ok(functional_library_elements[i] = new Library_storage);
mem_ok(storage_library_elements = new Library_storage);
mem_ok(interconnect_library_elements = new Library_storage);
mem_ok(libraries = new List_ar<Library_package*>);
add_library(library);
}

void
Library_manager::add_library(Library_package* library)
{
FRITS_SET_MESSAGE("add_library");
if (!library) return;
Library_element* element;
RBnode_int_bitwidth<int>* int_node;
RBnode_int_bitwidth<float>* float_node;
List_iterator<Storage_library_element*> storage_list_iterator;

FOR_EACH_LISTNODE(library->get_all_storage_libelements(), storage_list_iterator)
	{
	storage_library_elements->library_elements->
		append(element=storage_list_iterator.get_item());
	mem_ok(int_node = new RBnode_int_bitwidth<int>(element,element->get_area()));
	storage_library_elements->area_tree->insert(int_node);
	mem_ok(float_node = new RBnode_int_bitwidth<float>(element,element->get_delay()));
	storage_library_elements->delay_tree->insert(float_node);
	}
List_iterator<Interconnect_library_element*> interconn_list_iterator;
FOR_EACH_LISTNODE(library->get_all_interconnect_libelements(), interconn_list_iterator)
	{
	interconnect_library_elements->library_elements->
		append(element=interconn_list_iterator.get_item());
	mem_ok(int_node = new RBnode_int_bitwidth<int>(element,element->get_area()));
	interconnect_library_elements->area_tree->insert(int_node);
	mem_ok(float_node = new RBnode_int_bitwidth<float>(element,element->get_delay()));
	interconnect_library_elements->delay_tree->insert(float_node);
	}
List_iterator<Operator> functions;
List_iterator<Functional_library_element*> func_list_iterator;
FOR_EACH_LISTNODE(library->get_all_functional_libelements(), func_list_iterator)
    {
    FOR_EACH_LISTNODE( ((Functional_library_element*)(element=func_list_iterator.get_item()))->
				get_functions(), functions )
	{
	(functional_library_elements[(int)functions.get_item()])->
				library_elements->append(element);
	mem_ok(int_node = new RBnode_int_bitwidth<int>(element,element->get_area()));
	(functional_library_elements[(int)functions.get_item()])->area_tree->insert(int_node);
	mem_ok(float_node = new RBnode_int_bitwidth<float>(element,element->get_delay()));
	(functional_library_elements[(int)functions.get_item()])->delay_tree->insert(float_node);
	}
    }
libraries->append(library);
}


// The messages for min area and delay are exactly the same.

Library_element* 
Library_manager::get_min_area_library_element(List_ar<Operator> &list, int bitwidth)
{
Operator first_operator = list[0];
if ( list.get_size() == 1 )	// degenerate case
	return get_min_area_library_element(first_operator, bitwidth);
else
	{
	RBtree_int_bitwidth<int>* tree;
	RBnode_int_bitwidth<int>* node;
	tree = functional_library_elements[(int)first_operator]->area_tree;

	// Get the element with minimal area

	node = (RBnode_int_bitwidth<int>*)tree->tree_min();

	// Get the element with the required bitwidth and
	// then check all operators.
	while ( node &&					
		! node->get_bitwidth() == bitwidth &&	/* match the bitwidth */
 		! ((Functional_library_element*)(node->get_actual_object()))->
			can_perform(list) )	/* now match the operators */ 
		{
		// Chase elements to find the match
		node = (RBnode_int_bitwidth<int>*)tree->tree_successor();
		}
	return (node ? node->get_actual_object() : (Library_element*)NULL);
	}
}	

Library_element* 
Library_manager::get_min_delay_library_element(List_ar<Operator> &list, int bitwidth)
{
Operator first_operator = list[0];
if ( list.get_size() == 1 )	// degenerate case
	return get_min_delay_library_element(first_operator, bitwidth);
else
	{
	RBtree_int_bitwidth<float>* tree;
	RBnode_int_bitwidth<float>* node;
	tree = functional_library_elements[(int)first_operator]->delay_tree;

	// Get the element with minimal area
	node = (RBnode_int_bitwidth<float>*)tree->tree_min();

	// Get the element with the required bitwidth and
	// then check all operators.
	while ( node &&					/* not done yet */
		! node->get_bitwidth() == bitwidth &&	/* match the bitwidth */
 		! ((Functional_library_element*)(node->get_actual_object()))->
			can_perform(list) )	/* now match the operators */ 
		{
		// Chase elements to find the match
		node = (RBnode_int_bitwidth<float>*)tree->tree_successor();
		}
	return (node ? node->get_actual_object() : (Library_element*)NULL);
	}
}	
List_ar<Library_element*>*
Library_manager::get_library_elements_byArea(List_ar<Operator> operator_list, int bitwidth, int area_upper_bound, int area_lower_bound)
{
FRITS_SET_MESSAGE("get_library_elements_byArea");
Operator first_operator = operator_list[0];
List_ar<Library_element*>* element_list = 
	get_library_elements_byArea(first_operator, bitwidth, 
				area_upper_bound, area_lower_bound);
if ( operator_list.get_size() == 1 )	// degenerate case, one operator
	return element_list;		// in the list

List_iterator<Library_element*> list_iterator;
List_ar<Library_element*>* return_element_list;
mem_ok(return_element_list = new List_ar<Library_element*>);
// Filter element_list by the operator_list, add library_elements
// which pass the filter to return_element_list.
FOR_EACH_LISTNODE( *element_list, list_iterator )
	if ( ((Functional_library_element*)list_iterator.get_item())->
		can_perform(operator_list) )
		return_element_list->append(list_iterator.get_item());

if (return_element_list->is_empty())	// clean up
	{
	delete return_element_list;
	return_element_list = NULL;
	}
delete element_list;	// clean up
return  return_element_list;
}



List_ar<Library_element*>*
Library_manager::get_library_elements_byDelay(List_ar<Operator> operator_list, int bitwidth, float delay_upper_bound, float delay_lower_bound = 0.0)
{
FRITS_SET_MESSAGE("get_library_elements_byDelay");
Operator first_operator = operator_list[0];
List_ar<Library_element*>* element_list = 
	get_library_elements_byDelay(first_operator, bitwidth, 
				delay_upper_bound, delay_lower_bound);
if ( operator_list.get_size() == 1 )	// degenerate case, one operator
	return element_list;		// in the list

List_iterator<Library_element*> list_iterator;
List_ar<Library_element*>* return_element_list;
mem_ok(return_element_list = new List_ar<Library_element*>);
// Filter element_list by the operator_list
FOR_EACH_LISTNODE( *element_list, list_iterator )
	if ( ((Functional_library_element*)list_iterator.get_item())->
		can_perform(operator_list) )
		return_element_list->append(list_iterator.get_item());

if (element_list->is_empty())	// clean up
	{
	delete element_list;
	element_list = NULL;
	}
delete element_list;	// clean up
return  element_list;
}







