/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*              FILE: libmanag.h                                    */
/* Contains a description of a Library_manager class		    */
/********************************************************************/

#ifndef LIBRARY_MANAGER_H
#define LIBRARY_MANAGER_H

#include "libpack.h"  
#include "libtree.h"
#ifdef _IMPACT_
#include <Uniform.h>
#endif

// This class is intended to function as a sorted storage of Library_elements.
class Library_storage
#ifdef _IMPACT_
: public Assurance
#endif
{
friend class Library_manager;
List_ar<Library_element*>* library_elements;
RBtree_int_bitwidth<float> *delay_tree;
RBtree_int_bitwidth<int> *area_tree;

Library_storage(void)
{
FRITS_SET_CLASS("Library_storage");
mem_ok(library_elements = new List_ar<Library_element*>);
mem_ok(delay_tree = new RBtree_int_bitwidth<float>);
mem_ok(area_tree = new RBtree_int_bitwidth<int>);
}
~Library_storage()
{
if ( library_elements ) delete library_elements;
if ( delay_tree ) delete delay_tree;
if ( area_tree ) delete area_tree;
}
};


class Library_manager
#ifdef _IMPACT_
: public Symbol_table, public Assurance
#endif
{

Library_storage*	functional_library_elements[ALLOPS];


Library_storage*	storage_library_elements;
Library_storage*	interconnect_library_elements;

// Storage for libraries
List_ar<Library_package*> *libraries;


public:

Library_manager(void) 
{
FRITS_SET_CLASS("Library_manager");
int i;
for ( i=0; i<ALLOPS; i++ )
	mem_ok(functional_library_elements[i] = new Library_storage);
mem_ok(storage_library_elements = new Library_storage);
mem_ok(interconnect_library_elements = new Library_storage);
mem_ok(libraries = new List_ar<Library_package*>);
};

~Library_manager() 
{
int i;
for ( i=0; i<ALLOPS; i++ )
	delete functional_library_elements[i];
delete storage_library_elements;
delete interconnect_library_elements;
delete libraries;
};

// Loads the specified library and unloads all present libraries
void set_library(Library_package*);

// Adds a library to the present list
void add_library(Library_package*);

// Returns the library element which performs the given operation and
// has the minimum area
Library_element* get_min_area_library_element(Operator op, int bitwidth)
{
return functional_library_elements[(int)op]->area_tree->search_min(bitwidth); 
}

// Returns the library element which performs the given operation and
// has the minimum delay
Library_element* get_min_delay_library_element(Operator op, int bitwidth)
{
return functional_library_elements[(int)op]->delay_tree->search_min(bitwidth); 
}

// Returns the library element which performs the given set of operations and
// has the minimum area
Library_element* get_min_area_library_element(List_ar<Operator> &list, int bitwidth);

// Returns the library element which performs the given set of operations and
// has the minimum delay
Library_element* get_min_delay_library_element(List_ar<Operator> &list, int bitwidth);

// Returns the set of library elements which perform the given operation and
// have the area in the specified range
// For now, only 0 lower bound is supported.
List_ar<Library_element*> *get_library_elements_byArea(Operator op, int bitwidth, int area_upper_bound, int area_lower_bound = 0)
	{return functional_library_elements[(int)op]->
		area_tree->search_all(area_upper_bound, bitwidth);}

// Returns the set of library elements which perform the given set of 
// operations and have the area in the specified range
List_ar<Library_element*> *get_library_elements_byArea(List_ar<Operator>, int bitwidth, int area_upper_bound, int area_lower_bound = 0);

// Returns the set of library elements which perform the given operation and
// have the delay in the specified range
List_ar<Library_element*> *get_library_elements_byDelay(Operator op, int bitwidth, float delay_upper_bound, float delay_lower_bound = 0.0)
	{return functional_library_elements[(int)op]->
		delay_tree->search_all(delay_upper_bound, bitwidth);}

// Returns the set of library elements which perform the given set of 
// operations and have the delay in the specified range
List_ar<Library_element*> *get_library_elements_byDelay(List_ar<Operator>, int bitwidth, float delay_upper_bound, float delay_lower_bound = 0.0);

// Randomly returns a functional element which performs the given operation
Library_element* get_random_library_element(Operator op, int bitwidth)
{
}


// Randomly returns a functional element which performs the given set of operations
// Presently, not supported.
// Library_element* get_random_library_element(List_ar<Operator>, int bitwidth);

// Returns a register of a given bitwidth, with optional load_enable
Library_element* get_storage_library_element(int bitwidth, Boolean load_enable = TRUE);

// Returns a MUX with a default bitwidth = 2, optionally tri-state
Library_element* get_interconnect_library_element(int bitwidth = 2, Boolean tri_state = FALSE);

};

#endif /* LIBRARY_MANAGER_H */

