/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*             FILE: library.C                                      */
/********************************************************************/
#include "libpack.h"
#ifdef _IMPACT_
#include "componen.h"
#include "entity.h"
#include "bs_string.h"
#endif /* _IMPACT_ */

/********************************************************************/

Library_package *Library_package::add_functional_element(/* const */ Functional_library_element *new_functional_element) {
  FRITS_SET_MESSAGE("add_functional_element");
  assert(new_functional_element);

  if(functional_elements.find(new_functional_element)) {
    cerr << "ERROR: Functional library element " << new_functional_element
      << " neing added twice to Library " << this << endl;
    exit(-1);
  } else {
    functional_elements.append(new_functional_element);
  }
  return(this);
}

Library_package *Library_package::add_storage_element(/*const */ Storage_library_element *new_storage_element) {
  FRITS_SET_MESSAGE("add_storage_element");
  assert(new_storage_element);

  if(storage_elements.find(new_storage_element)) {
    cerr << "ERROR: Storage library element " << new_storage_element
      << " neing added twice to Library " << this << endl;
    exit(-1);
  } else {
    storage_elements.append(new_storage_element);
  }
  return(this);
}
/********************************************************************/

Library_package *Library_package::add_interconnect_element(/*const*/ Interconnect_library_element *new_interconnect_element) {
  FRITS_SET_MESSAGE("add_interconnect_element");
  assert(new_interconnect_element);

  if(interconnect_elements.find(new_interconnect_element)) {
    cerr << "ERROR: Interconnect library element " << new_interconnect_element
      << " neing added twice to Library " << this << endl;
    exit(-1);
  } else {
    interconnect_elements.append(new_interconnect_element);
  }
  return(this);
}
/********************************************************************/
/*Function to display the contents of a Library. The default output
 *stream is cout.
 */
void Library_package::display(ostream &output) {
  const char* pack = package_name ? package_name : "DUMMY";
  output << "Library package: " << pack << endl;
  output << "  Functional elements: " << functional_elements;
  output << "  Storage elements: " << storage_elements;
  output << "  Interconnect elements: " << interconnect_elements;
  return;
}
/********************************************************************/

#ifdef _IMPACT_
Library_package::Library_package(Package* package) : functional_elements(), storage_elements(), interconnect_elements() 
{
FRITS_SET_MESSAGE("Library_package");
assert(package);
Component* c;
Library_element *le;
char* operations = NULL;
int i;
package_name = strdup(package->get_identifier());
for ( i = 1; i <= package->number_of_component(); i++ )
	{
	c = package->get_component();
	if (operations) delete operations;
 	Attribute_specification* as = c->get_entity()->search_attribute_specification("operations");
	Expression* exp = as->get_expression();
	operations = strdup2(exp->get_value()->get_name());
#ifdef DEVELOPER
	note("Creating component '%s'\n", c->get_entity()->get_identifier());
#endif   
	if ( strstr(operations, "MUX") )
		{
		le = new Interconnect_library_element(c);
		add_interconnect_element((Interconnect_library_element*)le);
		}
	else if ( strstr(operations, "REG") )
		{
		le = new Storage_library_element(c);
		add_storage_element((Storage_library_element*)le);
		}
	else
		{
		le = new Functional_library_element(c);
		add_functional_element((Functional_library_element*)le);
		}
	}
return;
}
#endif /* _IMPACT_ */

