/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*             FILE: libpack.h                                      */
/********************************************************************/
#ifndef KAMAL_LIBRARY_H
#define KAMAL_LIBRARY_H

#include "list_ar.h"
#include "libelem.h"
#ifdef _IMPACT_
#include "package.h"
#endif /* _IMPACT_ */

#ifdef _IMPACT_
class Library_package : public Assurance {
#else
class Library_package {
#endif
private:
  List_ar<Functional_library_element *> functional_elements;
  List_ar<Storage_library_element *> storage_elements;
  List_ar<Interconnect_library_element *>  interconnect_elements;
  char* package_name;

public:
  Library_package(const char* pack_name = NULL) : functional_elements(), storage_elements(), interconnect_elements() {
    FRITS_SET_CLASS("Library_package");
    package_name = strdup(pack_name);
  }
  ~Library_package() {
    //the lists are automatically freed when their destructors are called
    //from ~Library_package()
    if (package_name) free(package_name);
  }

  const char* get_package_name(void) {return package_name;}

#ifdef _IMPACT_
  Library_package(Package* package);
#endif /* _IMPACT_ */

  //return a List containing all functional library elements
  inline const List_ar<Functional_library_element *> &get_all_functional_libelements() {
    FRITS_SET_MESSAGE("get_all_functional_libelements");
    return(functional_elements);
  };

  //return a List containing all storage library elements
  inline const List_ar<Storage_library_element *> &get_all_storage_libelements() {
    FRITS_SET_MESSAGE("get_all_storage_libelements");
    return(storage_elements);
  };

  //return a List containing all interconnect library elements
  inline const List_ar<Interconnect_library_element *> &get_all_interconnect_libelements() {
    FRITS_SET_MESSAGE("get_all_interconnect_libelements");
    return(interconnect_elements);
  };

  Library_package *add_functional_element(/*const*/ Functional_library_element *);
  Library_package *add_storage_element(/*const*/ Storage_library_element *);
  Library_package *add_interconnect_element(/*const*/ Interconnect_library_element *);

  //function to display a Library_package
  void display(ostream & = cout);
};
/********************************************************************/
//Syntactic sugar for displaying a Library
inline ostream &operator <<(ostream &output, Library_package &lib)
{lib.display(output);return(output);}

#endif
