/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */
/*
///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>
*/

%{
#include "basic.h"
#include "list_ar.h"
#include "dfgnode.h"
#include "library_patch.h"
%}

%start library

%token BEGIN_MODULE
%token END_MODULE
%token BITWIDTH
%token LEAKAGE
%token AREA
%token OPERATIONS
%token STAGES
%token LIBDELAY
%token POWER
%token OPER_ADD
%token OPER_SUB
%token OPER_MUL
%token OPER_DIV
%token OPER_AND
%token OPER_OR
%token OPER_XOR
%token OPER_NOTEQ
%token OPER_NOT
%token OPER_GT
%token OPER_LT
%token OPER_EQ
%token OPER_LW
%token OPER_SW
%token <intval> INTNUMBER
%token <fltval> FLTNUMBER
%token <charptr> IDENTIFIER

%union {
  char charptr[MAXSTRLEN];     /*to pass identifiers*/
  int intval;		       /*to pass integers*/
  float  fltval;               /*to pass numbers*/
  Operator func;               /*to pass node types*/
  List_ar<int> *listptr;          /*to pass a List of operations*/
  List_ar<float> *fltlistptr;     /*to pass a List of fp numbers*/
}

%type <func> opertype;
%type <listptr> operlist;
%type <fltlistptr> fltnumlist;
%type <charptr> begin_statement;
%type <intval> bitwidth_statement;
%type <intval> stages_statement;
%type <fltval> area_statement;
%type <fltval> delay_statement;
%type <fltval> leakage_statement;
%type <fltlistptr> power_statement;
%type <listptr> opers_statement;

%%

library : 
{
#ifdef LIBPARSE_DEBUG
  cout << "BEGIN PARSING LIBRARY..." << endl;
#endif
  //we assume an empty library at the beginning
}
modules
{
#ifdef LIBPARSE_DEBUG
  cout << "END PARSING LIBRARY..." << endl;
#endif
  yyin = anand_fclose(yyin);
};

modules : module
	| modules module;


module : begin_statement bitwidth_statement opers_statement stages_statement area_statement leakage_statement delay_statement  power_statement end_statement
{
  register libelement *newlibelement;
  List_iterator<int> l_iter;
  register int f;

  if(get_libelement($1)) {
    cerr << "Library element " << $1 << " redefined at line "
	 << yylineno << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement = add_libelement($1);

  if($2 <= 0) {
    cerr << "Bad value " << $2 << " supplied for bitwidth of library element"
      << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement->bitwidth = $2;
  
  FOR_EACH_LISTNODE((*($3)), l_iter) {
    f = l_iter.get_item();
    assert(f > NONE);
    newlibelement->operations[f-1] = T;
  }

  if($4 < 1) {
    cerr << "Bad value " << $4 << "supplied for pipeline stages (>=1 expected)"
      << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement->pipestages = $4;

  if($5 <= 0.0) {
    cerr << "Bad value " << $5 << "supplied for area"
      << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement->area = $5;

  if($6 < 0.0) {
    cerr << "Bad value " << $6 << "supplied for leakage"
	 << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement->total_leakage = $6;

  if($7 <= 0.0) {
    cerr << "Bad value " << $6 << "supplied for delay"
      << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement->delay = $7;

  assert($8);
  if($8 ->get_size() != 2*$2) {
    cerr << "Incorrect number of coefficients specified for sw. cap. model"
      << " must supply " << (2*$2)
	<< " coefficients expected for a bit-width of " << $2 << endl;
    yyerror("Illegal Library structure");
  }
  newlibelement->power_coeffs = $8;
}
	;

begin_statement : BEGIN_MODULE IDENTIFIER
{
  strcpy($$, $2);
}
	;

bitwidth_statement : BITWIDTH INTNUMBER
{
  $$ = $2;
}
        ;

opers_statement : OPERATIONS operlist
{
  $$ = $2;
}
	;

stages_statement : STAGES INTNUMBER
{
  $$ = $2;
}
	;

area_statement : AREA FLTNUMBER
{
  $$ = $2;
}
	;

leakage_statement : LEAKAGE FLTNUMBER
{
  $$ = $2;
}
	;

delay_statement : LIBDELAY FLTNUMBER
{
  $$ = $2;
}
	;

power_statement : POWER fltnumlist
{
  $$ = $2;
}
	;

end_statement : END_MODULE
{

}
	;

opertype : OPER_ADD {$$ = PLUS_;}
     | OPER_MUL {$$ = MULT_;}
     | OPER_SUB {$$ = MINUS_;}
     | OPER_DIV {$$ = DEV_;}
     | OPER_AND {$$ = AND_;}
     | OPER_OR  {$$ = OR_;}
     | OPER_XOR {$$ = XOR_;}
     | OPER_NOTEQ {$$ = NOTEQ_;}
     | OPER_NOT {$$ = NOT_;}
     | OPER_GT {$$ = GREAT_;} 
     | OPER_LT {$$ = LESS_;}
     | OPER_EQ {$$ = EQUAL_;}
     | OPER_LW {$$ = LW_;}
     | OPER_SW {$$ = SW_;}
     ;

operlist : opertype
{
  $$ = new List_ar<int>;
  $$->append((int)$1);
}
	| operlist opertype
{
  assert($1);
  $1->append((int)$2);
  $$ = $1;
}
	;

fltnumlist : FLTNUMBER
{
  $$ = new List_ar<float>;
  $$->append($1);
}
        | fltnumlist FLTNUMBER
{
  assert($1);
  $1->append($2);
  $$ = $1;
}

%%
#include "liblex.C"
int yywrap() {
/*  cout << "
" << "*  Line: " << yylineno << endl; */
  return 1;
}
