/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*              FILE: libport.h                                     */
/* Contains an implementation of the class Library_element_port     */
/********************************************************************/

#include "libport.h"

Library_element_port* Library_element_port::set_port_class(PORTCLASS portclass)
{
  FRITS_SET_MESSAGE("set_port_class");
  if ( type == _IN_ || type == _INOUT_ ) {
    assert(portclass != OUTPUT);
    port_class = portclass;
    return this;
  } else if ( type == _OUT_ ) {
    return NULL;
  }
}

//copy a given list into the power_coefficients list
Library_element_port* Library_element_port::set_power_coefficients(List_ar<float> &new_coeffs) 
{
  FRITS_SET_MESSAGE("set_power_coefficients");
  assert(type != _OUT_);
  if (bitwidth) assert(new_coeffs.get_size() == bitwidth);
  power_coefficients.copy(new_coeffs);
  return this;
}


