/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*              FILE: libport.h                                     */
/* Contains a description of the class Library_element_port 	    */
/* corresponting to a port of a library module.			    */
/********************************************************************/

#ifndef KAMAL_LIBPORT_H
#define KAMAL_LIBPORT_H

#include "list_ar.h"
#include "parameter.h"
#include "basic.h"
#ifdef _IMPACT_
#include "assuranc.h"
#else
#define _IN_		1	/* Porttype */
#define _OUT_		2
#define _INOUT_		3
#endif

// define all input ports as DATA or CONTROL
typedef enum portclass_type {
  OUTPUT = 0,	// dummy intialization
  DATA = 1,
  CONTROL = 2
} PORTCLASS;

/********************************************************************/
#ifdef _IMPACT_
class Library_element_port : public Assurance {
#else
class Library_element_port {
#endif

private:
  char *name;				// port name
  int bitwidth;                       //# of bits in this port
  int type;                           //whether this port is an IN,OUT,or INOUT
  PORTCLASS port_class;                    //whether this port is a CONTROL or DATA port
  //power coefficients for this port - one for each bit
  //NOTE - the power coefficients List should be EMPTY for an OUT port
  List_ar<float> power_coefficients;  

public:

  Library_element_port(const char* port_name, int port_type, int port_bitwidth = 1) : power_coefficients() {
    FRITS_SET_CLASS("Library_element_port");

    assert(port_name != NULL);
    name = strdup(port_name);

    assert( port_type == _IN_ || port_type == _OUT_ || port_type == _INOUT_ );
    type = port_type;
    port_class = OUTPUT;
    bitwidth = port_bitwidth;
  }

  ~Library_element_port() {
    if(name) {
      delete name;
    }
    power_coefficients.clear();
  }

  //inline functions to get fields of this Library_element_port
  inline const char *get_name(void) {
    FRITS_SET_MESSAGE("get_name");
    return name;
  }
  inline const int get_bitwidth(void) {
    FRITS_SET_MESSAGE("get_bitwidth");
    return bitwidth;
  }
  inline const int get_type(void) {
    FRITS_SET_MESSAGE("get_type");
    return type;
  }
  inline const PORTCLASS get_port_class(void) {
    FRITS_SET_MESSAGE("get_port_class");
    return port_class;
  }
  inline List_ar<float>& get_power_coefficients(void) {
    FRITS_SET_MESSAGE("get_power_coefficients");
    assert(power_coefficients.get_size() == bitwidth);
    return power_coefficients;
  }

  //functions to set fields of Library_element_port
  Library_element_port* set_port_class(PORTCLASS);

  //copy a given list into the power_coefficients list
  Library_element_port* set_power_coefficients(List_ar<float> &); 

  inline Library_element_port* add_power_coefficient(const float new_coeff) {
    FRITS_SET_MESSAGE("add_power_coefficient");
    assert(type != _OUT_);
    power_coefficients.append(new_coeff);
    return this;
  }
  virtual const char* get_id(void) {return "Library_element_port";};
};
/********************************************************************/
#endif  /* KAMAL_LIBPORT_H */
