/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/********************************************************************/
/*                FILE: library_patch.C                             */
/********************************************************************/

#include "library_patch.h"
#include "i_macro.h"

/********************************************************************/
float libelement::sw_cap(List_ar<unsigned int> &vallist1, List_ar<unsigned int> &vallist2)
{
  float retval;
  register int i;
  List_iterator<unsigned int> liter1;
  List_iterator<unsigned int> liter2;
  List_iterator<float> liter3;
  assert(vallist1.get_size()*bitwidth == power_coeffs->get_size());
  assert(vallist2.get_size()*bitwidth == power_coeffs->get_size());

  retval = 0.0;
  liter3.start(*power_coeffs);
  for(liter1.start(vallist1),liter2.start(vallist2); liter1.not_done() && liter2.not_done(); liter1.increment(), liter2.increment()) {
    for(i = 0; i < bitwidth; i++,liter3.increment()) {
      assert(liter3.not_done());
      if(GETBIT(liter1.get_item(),i) != GETBIT(liter2.get_item(),i)) {
	retval += liter3.get_item();
      }
    }
  }
  assert(!(liter1.not_done() || liter2.not_done() || liter3.not_done()));

  return(retval);
}
#ifdef PHYSICAL
/********************************************************************/
float libelement::sw_cap(unsigned int var1, unsigned int var2, short num)
{
  float retval;
  register int i;
  List_iterator<float> liter3;

  retval = 0.0;
  liter3.start(*power_coeffs);
  for(i= 0; i<num; i++) 
	  liter3.increment();
  for(i = 0; i < bitwidth; i++,liter3.increment()) {
      assert(liter3.not_done());
      if(GETBIT(var1,i) != GETBIT(var2,i)) {
        retval += liter3.get_item();
      }
  }
  return(retval);
}
#endif
/********************************************************************/
float library::reg_sw_cap(unsigned int val1, unsigned int val2, int bitwidth)
{
  register int i;
  float retval;

  assert(bitwidth > 0 && bitwidth <= 32);
  retval = 0.0;
  for(i = 0; i < bitwidth; i++) {
    if(GETBIT(val1,i) != GETBIT(val2,i)) {
      retval += REG_POWER_PER_BIT;
    }
  }
  return(retval);
}
#ifdef PHYSICAL
float library::edge_sw(unsigned int val1, unsigned int val2, int bitwidth)
{
  float retval;

  assert(bitwidth > 0 && bitwidth <= MAX_BIT_NUM);
  retval = Wire_En.get_wire_energy(val1, val2, bitwidth);
  return retval;
}
#endif

/********************************************************************/
#ifndef _SCALP_

void library::read(char *filename)
{
  int lib_parse_error;
  extern FILE *lib_in;

  assert(filename);
  lib_in = anand_fopen(filename, "r");
  cout << "*" << endl;
  cout << "*  Reading LIBRARY from file \""
    << filename << "\"" << endl;
  lib_parse_error = lib_parse();
  if(lib_parse_error) {
    cerr << "Errors occurred while parsing LIBRARY from file \""
      << filename << "\"" << endl;
    exit(-1);
  }
  cout << "*" << endl;
  return;
}
#endif /* _SCALP_ */

/********************************************************************/
libelement * library::get_libelement(char *name)
{
  register int i;
  libelement *retptr = (libelement *)NULL;

  assert(name);

  for(i = 0; i < elementcount; i++) {
    if(!strcmp(elements[i]->name, name)) {
      retptr = elements[i];
    }
  }

  return(retptr);
}

/********************************************************************/
libelement * library::add_libelement(char *name)
{
  libelement *newelement;

  assert(name);
  assert(!elements[elementcount]);

  newelement = new libelement;
  strcpy(newelement->name, name);
  elements[elementcount] = newelement;
  newelement->address = elementcount;
  elementcount++;

  return(newelement);
}

/********************************************************************/
List_ar<libelement *> *library::get_choices(Operator type,int nbits)
{
  register int i;
  List_ar<libelement *> *retlistptr = new List_ar<libelement *>;
  libelement *libel;

  assert(type >= NONE);
  assert(nbits > 0);
  for(i = 0; i < elementcount; i++) {
    libel = elements[i];
    assert(libel);
    if(libel->can_perform(type,nbits)) {
      retlistptr->append(libel);
    }
  }

  return(retlistptr);
}
/********************************************************************/
/*Return a List containing all the library elements for a particular
 *bitwidth.
 */
List_ar<libelement *> *library::get_all_elements(int nbits)
{
  register int i;
  List_ar<libelement *> *retlistptr = new List_ar<libelement *>;
  libelement *libel;

  assert(nbits > 0);
  for(i = 0; i < elementcount; i++) {
    libel = elements[i];
    assert(libel);
    if(libel->bitwidth == nbits) {
      retlistptr->append(libel);
    }
  }

  return(retlistptr);
}
/********************************************************************/
/*This routine prints the library out to the provided output stream
 */
void library::display(ostream &output)
{
  output << "Library: " << (void *)this << endl;
  output << "  Number of elements: " << elementcount << endl;
  output << "  Elements: ";
  elements.display();
  return;
}

/********************************************************************/
ostream &operator <<(ostream &output, const libelement &libel)
{
  output << libel.name;
  return(output);
}

/********************************************************************/
ostream &operator <<(ostream &output, libelement *libelptr)
{
  if(libelptr) {
    output << libelptr->name;
  }
  return(output);
}

/********************************************************************/

#ifdef _SCALP_
#include "library_patch.lp"
#endif

