/*  Copyright (c) 2000-2001 by Alternative System Concepts, Inc.  */
/*  All Rights Reserved                                           */
/*                                                                */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF                */
/*       Alternative System Concepts, Inc.                        */
/*  The copyright notice above does not evidence any              */
/*  actual or intended publication of such source code.           */

///  <HEADER>
///     <PURPOSE>
///              
///     </PURPOSE>
///              
///  </HEADER>

/****************************************************************/
/*              FILE: rbnode.h                                  */
/* Contains a description of the RBnode class 			*/
/* which implements a node for the red-black trees 		*/
/* RBnode is a unit of storage of a <type> object by		*/
/* a specified <key>.						*/
/****************************************************************/

#ifndef RBNODE_H
#define RBNODE_H

#include "basic.h"
enum Color { BLACK = 0, RED };

template<class type,class key>
class RBnode 
#ifdef _IMPACT_
: public Assurance
#endif
{
type actual_object;
key value;
RBnode* left_child;
RBnode* right_child;
RBnode* parent;
Color color;

public:

RBnode(type object, key object_value) 
{
FRITS_SET_CLASS("RBnode");
actual_object = object;
value = object_value;
left_child = NULL;
right_child = NULL;
parent = NULL;
color = BLACK;
}

~RBnode() {};

RBnode* get_right_child(void) {return right_child;}
RBnode* set_right_child(RBnode* child) {right_child = child; return this;}

RBnode* get_left_child(void) {return left_child;}
RBnode* set_left_child(RBnode* child) {left_child = child; return this;}

RBnode* get_parent(void) {return parent;}
RBnode* set_parent(RBnode* daddy) {parent = daddy; return this;}

type get_actual_object(void) {return actual_object;}
key get_value(void) {return value;}

RBnode* set_color(Color redblack)	{color = redblack; return this;}
Color get_color(void)	{return color;}

virtual const char* get_id(void) {return "RBnode";}
};

#endif 	/* RBNODE_H */


