/************************************************************************/
/*              FILE: libtree.h                                    	*/
/* Contains definition of a template class RBtree_int_bitwidth		*/
/* This class inherits from RBtree and is composed of 			*/
/* RBnode_int_bitwidth's						*/
/************************************************************************/

#ifndef LIBTREE_H
#define LIBTREE_H

#include "rbtree.h"
#include "libnode.h"

// Class RBtree_int_bitwidth adds capability to filter the results of
// searches by the 'int bitwidth' parameter. Nodes of RBtree_int_bitwidth are
// RBnode_int_bitwidth's.
template<class key>
class RBtree_int_bitwidth : public RBtree<Library_element*, key>
{
protected:
virtual void insert(RBnode<Library_element*,key>* node)   {RBtree<Library_element*,key>::insert(node);}

// This message is used internally to implement tree searches, same as
// public search(..), but with the added RBnode_int_bitwidth* parameter.
Library_element* search(key parameter, int bitwidth, RBnode_int_bitwidth<key>* node)
{
if ( !node || 
    ( node->get_value() == parameter && node->get_bitwidth() == bitwidth ) )
	return node->get_actual_object();
else if ( node->get_value() > parameter ) // go left
	{
	if ( node->get_left_child() )
		return search(parameter, bitwidth, (RBnode_int_bitwidth<key>*)node->get_left_child());
	else	return NULL;  // NOPE
	}
else	// go right, node->get_value() < parameter
	{
	if ( node->get_right_child() )
		return search(parameter, bitwidth, (RBnode_int_bitwidth<key>*)root->get_right_child());
	else if ( node->get_bitwidth() == bitwidth )
		return node->get_actual_object();
	else	return NULL; 
	}
}

// This message is used internally to implement tree searches, same as
// public search_all(..), but with the added RBnode_int_bitwidth* parameter.
List_ar<Library_element*>* search_all(key parameter, 
int bitwidth, List_ar<Library_element*> *&list, RBnode_int_bitwidth<key>* node)
{
if ( !node ) return list;
if ( node->get_left_child() ) search_all(parameter, bitwidth, list, (RBnode_int_bitwidth<key>*)node->get_left_child());
if ( node->get_value() <= parameter )
	{
	if ( node->get_bitwidth() == bitwidth ) 
		list->append(node->get_actual_object());
	if ( node->get_right_child() ) search_all(parameter, bitwidth, list, (RBnode_int_bitwidth<key>*)node->get_right_child());
	}
return list;
}

// This message supports public search_min by implementing an internal 
// search_min from an arbitrary node.
Library_element* search_min(int bitwidth, RBnode_int_bitwidth<key>* node)
{
Library_element* found;
if ( !node ) return NULL;
if ( node->get_left_child() &&
	(found = search_min(bitwidth, (RBnode_int_bitwidth<key>*)node->get_left_child())) ) 
		return found;
else if ( node->get_bitwidth() == bitwidth ) return node->get_actual_object();
else if ( node->get_right_child() )
	return search_min(bitwidth, (RBnode_int_bitwidth<key>*)node->get_right_child());
else return NULL;	// not found
}

public:
RBtree_int_bitwidth(RBnode_int_bitwidth<key>* node = NULL) 
: RBtree<Library_element*,key>((RBnode<Library_element*,key>*)node) 
{FRITS_SET_CLASS("RBtree_int_bitwidth");}
~RBtree_int_bitwidth() {};

virtual const char* get_id(void) {return "RBtree_int_bitwidth";}

// This message searches for the element with the minimal key and
// specified bitwidth.  The search is implemented as inorder-tree-walk
// which stops as soon as an element of 'bitwidth' is found.
Library_element* search_min(int bitwidth)
	{return search_min(bitwidth, (RBnode_int_bitwidth<key>*)root);}

virtual void insert(RBnode_int_bitwidth<key>* node)
   {RBtree<Library_element*,key>::insert((RBnode<Library_element*,key>*)node);}

// This message returns the first node of the tree which matches
// the specified parameter. The message searches from root. 
Library_element* search(key parameter, int bitwidth)
	{return search(parameter, bitwidth, (RBnode_int_bitwidth<key>*)root);}

// This search message return a list of all elements with specified
// bitwisth whose keys are <= than
// the specified parameter. The search starts from the root.
List_ar<Library_element*>* search_all(key parameter, 
int bitwidth, List_ar<Library_element*> *&list = NULL)
{
if ( !root ) return (list = NULL);
if ( !list ) mem_ok(list = new List_ar<Library_element*>);
return search_all(parameter, bitwidth, list, (RBnode_int_bitwidth<key>*)root);
}
};

#endif /* LIBTREE_H */
