#include "scm_new.h"

inline int Scm_new::set_edge_switch(const int n, const int m, const double sw)
{
	if(edge_switch.get_xcount()<n||edge_switch.get_ycount()<m)
		return -1;
	else
	{
		edge_switch[n][m] = sw;
		return 0;
	}
}
inline double Scm_new::get_edge_switch(const int n, const int m)
{
	assert(edge_switch.get_xcount()<n||edge_switch.get_ycount<m);
	return edge_switch[n][m];
}
/********************************************************************/
/*This routine performs a simulation of the given DFG, to extract
 *the switched capacitance matrices. The vectors are read from the
 *file that has the given name. If no file with the given name
 *exists, RANDOM vectors are used.
 */
void Scm_new::extract_scmatrices(Dfg &flowgraph, library_new *lib, char *vecfile)
{
  register int i,j,k;
  register NODEPTR node1, node2;
  register EDGEPTR edge, edge1, edge2;
  extern FILE *vec_in;
  Boolean use_random_vectors;
  Boolean first_iteration;
  libelement *libel;
  Array<unsigned int> *vals1, *vals2;
  Array<unsigned int> *previous_values, *current_values;
  static List_ar<unsigned int> loopout_values;
  static List_ar<unsigned int> vallist1, vallist2, vallist3, vallist4;
  List_iterator<EDGEPTR> edgescan;

#ifdef _SCALP_
    set_message("extract_scmatrices");
#endif
  assert_force(lib)
  intra_sc.resize(lib->numelements(), (Matrix<float> *)NULL);
  inter_sc.resize(lib->numelements(), (Matrix<float> *)NULL);
  reg_intra_sc.resize(flowgraph.numedges(), flowgraph.numedges(), 0.0);
  reg_inter_sc.resize(flowgraph.numedges(), flowgraph.numedges(), 0.0);
  edge_intra_sw.resize(flowgraph.numedges(), flowgraph.numedges(), 0.0);
  edge_inter_sw.resize(flowgraph.numedges(), flowgraph.numedges(), 0.0);
   
  //allocate the sc matrices, each of dimensions nodeount X nodecount
  for(i = 0; i < lib->numelements(); i++) {
    if(!intra_sc[i]) {
      intra_sc[i] =
	new Matrix<float>(flowgraph.numnodes(),flowgraph.numnodes());
    } else {
      intra_sc[i]->resize(flowgraph.numnodes(),flowgraph.numnodes());
    }
    intra_sc[i]->reset(0.0);
    if(!inter_sc[i]) {
      inter_sc[i] =
	new Matrix<float>(flowgraph.numnodes(),flowgraph.numnodes());
    } else {
      inter_sc[i]->resize(flowgraph.numnodes(),flowgraph.numnodes());
    }
    inter_sc[i]->reset(0.0);
  }
  
  //allocate two Arrays for storing the current and previous iteration
  //values, and initialize all values to ZERO
  vals1 = new Array<unsigned int> (flowgraph.numedges());
  vals2 = new Array<unsigned int> (flowgraph.numedges());
  vals1->reset(0);
  vals2->reset(0);
  previous_values = vals1;
  current_values = vals2;
  //allocate the loopout_values list to the appropriate size
  loopout_values.clear();
  for(i = 0; i < flowgraph.loopins.get_size(); i++) {
    loopout_values.append(0);
  }
  if(!vecfile) {
    use_random_vectors = T;
    vec_in = NULL;
    cout << "*" << endl;
    cerr << "*  No vector file specified for SC simulation - "
      << "using random vectors instead" << endl;
  } else {
    use_random_vectors = F;
    vec_in = anand_fopen(vecfile, "r");
    cout << "*" << endl;
    cout << "*  Reading vectors from file \"" << vecfile << "\"" << endl;
  }

  first_iteration = T;
  vector_number = 0;
  while(get_vector(use_random_vectors, flowgraph.inputs.get_size())) 
  {
    //simulate the Dfg for the current iteration, and capture the
    //edge values in the current_values array
    flowgraph.simulate(cur_vector, loopout_values, *current_values, first_iteration);
    if(first_iteration) 
    {
      first_iteration = F;
    }

    //update the scmatrices entries;
    for(i = 0; i < lib->numelements(); i++) 
    {
      libel = lib->get_nthelement(i);
      assert(libel);

      for(j = 0; j < flowgraph.numnodes(); j++) 
      {
	node1 = flowgraph.get_nthnode(j);
	assert(node1 && node1->get_address() == j);
	if(!libel->can_perform(node1->get_func(), flowgraph.bitwidth)) 
	{
	  continue;
	}

	for(k = j; k < flowgraph.numnodes(); k++) 
	{
	  node2 = flowgraph.get_nthnode(k);
	  assert(node2 && node2->get_address() == k);
	  if(!libel->can_perform(node2->get_func(), flowgraph.bitwidth)) 
	  {
	    continue;
	  }

	  vallist1.clear(); vallist2.clear();
	  vallist3.clear(); vallist4.clear();
	  FOR_EACH_FANIN_EDGE(node1, edgescan) 
	  {
	    edge = edgescan.get_item();
	    assert(edge);
	    vallist1.append((*current_values)[edge->get_address()]);
	    vallist3.append((*previous_values)[edge->get_address()]);
	  }
	  FOR_EACH_FANIN_EDGE(node2, edgescan) {
	    edge = edgescan.get_item();
	    assert(edge);
	    vallist2.append((*current_values)[edge->get_address()]);
	    vallist4.append((*previous_values)[edge->get_address()]);
	  }
	  //update intra_sc[i][j][k]
	  (*intra_sc[i])[j][k] += libel->sw_cap(vallist1, vallist2);
	  
	  //update intra_sc[i][k][j]
	  if(j != k) 
	  {
	    (*intra_sc[i])[k][j] += libel->sw_cap(vallist2, vallist1);
	  }
	  
	  //update inter_sc[i][j][k]
	  (*inter_sc[i])[j][k] += libel->sw_cap(vallist3, vallist2);

	  //update inter_sc[i][k][j]
	  if(j != k) 
	  {
	    (*inter_sc[i])[k][j] += libel->sw_cap(vallist4, vallist1);
	  }

	} //END FOR EACH Dfg NODE
      } //END FOR EACH Dfg NODE
    } //END FOR EACH LIBELEMENT

    //SWITCHED CAPACITANCES FOR REGISTERS
    for(i = 0; i < flowgraph.numedges(); i++) {
      for(j = i; j < flowgraph.numedges(); j++) {
	edge1 = flowgraph.get_nthedge(i);
	assert(edge1 && edge1->get_address() == i);
	edge2 = flowgraph.get_nthedge(j);
	assert(edge2 && edge2->get_address() == j);
	reg_intra_sc[i][j] += lib->reg_sw_cap((*current_values)[i],
			       (*current_values)[j], flowgraph.bitwidth);
	if( i != j) {
	  reg_intra_sc[j][i] += lib->reg_sw_cap((*current_values)[j],
				 (*current_values)[i], flowgraph.bitwidth);
	}

	reg_inter_sc[i][j] += lib->reg_sw_cap((*previous_values)[i],
			       (*current_values)[j], flowgraph.bitwidth);
	if( i != j) {
	  reg_inter_sc[j][i] += lib->reg_sw_cap((*previous_values)[j],
		  	         (*current_values)[i], flowgraph.bitwidth);
	}

      }
    }
    //Switching activities for edges
    for(i = 0; i < flowgraph.numedges(); i++) {
      for(j = i; j < flowgraph.numedges(); j++) {
	edge1 = flowgraph.get_nthedge(i);
	assert(edge1 && edge1->get_address() == i);
	edge2 = flowgraph.get_nthedge(j);
	assert(edge2 && edge2->get_address() == j);
	edge_intra_sw[i][j] += lib->edge_sw((*current_values)[i],
			       (*current_values)[j], flowgraph.bitwidth);
	if( i != j) {
	  edge_intra_sw[j][i] += lib->edge_sw((*current_values)[j],
				 (*current_values)[i], flowgraph.bitwidth);
	}

	edge_inter_sw[i][j] += lib->edge_sw((*previous_values)[i],
			       (*current_values)[j], flowgraph.bitwidth);
	if( i != j) {
	  edge_inter_sw[j][i] += lib->edge_sw((*previous_values)[j],
		  	         (*current_values)[i], flowgraph.bitwidth);
	}

      }
    }

    //transfer current values to previous values, and reset current values
    if(current_values == vals1) {
      assert(previous_values == vals2);
      current_values = vals2;
      previous_values = vals1;
    } else {
      assert(current_values == vals2 && previous_values == vals1);
      current_values = vals1;
      previous_values = vals2;
    }
    current_values->reset(0);
  }

  //Normalize the SCM entries by the number of CDFG iterations simulated
  for(i = 0; i < lib->numelements(); i++) {
    libel = lib->get_nthelement(i);
    assert(libel);

    for(j = 0; j < flowgraph.numnodes(); j++) {
      node1 = flowgraph.get_nthnode(j);
      assert(node1 && node1->get_address() == j);
      if(!libel->can_perform(node1->get_func(), flowgraph.bitwidth)) {
	continue;
      }

      for(k = j; k < flowgraph.numnodes(); k++) {
	node2 = flowgraph.get_nthnode(k);
	assert(node2 && node2->get_address() == k);
	if(!libel->can_perform(node2->get_func(), flowgraph.bitwidth)) {
	  continue;
	}
	(*intra_sc[i])[j][k] /= (float) vector_number;
	if(j != k) {
	  (*intra_sc[i])[k][j] /= (float) vector_number;
	}
	(*inter_sc[i])[j][k] /= (float) vector_number;
	if(j != k) {
	  (*inter_sc[i])[k][j] /= (float) vector_number;
	}
      }
    }
  }
  for(i = 0; i < flowgraph.numedges(); i++) {
    for(j = i; j < flowgraph.numedges(); j++) {
      edge1 = flowgraph.get_nthedge(i);
      assert(edge1 && edge1->get_address() == i);
      edge2 = flowgraph.get_nthedge(j);
      assert(edge2 && edge2->get_address() == j);

      reg_intra_sc[i][j] /=  (float) vector_number;
      if(i != j) {
	reg_intra_sc[j][i] /=  (float) vector_number;
      }
      reg_inter_sc[i][j] /=  (float) vector_number;
      if(i != j) {
	reg_inter_sc[j][i] /=  (float) vector_number;
      }
    }
  }
  //lzhong
  //for edges;
  for(i = 0; i < flowgraph.numedges(); i++) {
    for(j = i; j < flowgraph.numedges(); j++) {
      edge1 = flowgraph.get_nthedge(i);
      assert(edge1 && edge1->get_address() == i);
      edge2 = flowgraph.get_nthedge(j);
      assert(edge2 && edge2->get_address() == j);

      edge_intra_sw[i][j] /=  (float) vector_number;
      if(i != j) {
	edge_intra_sw[j][i] /=  (float) vector_number;
      }
      edge_inter_sw[i][j] /=  (float) vector_number;
      if(i != j) {
	edge_inter_sw[j][i] /=  (float) vector_number;
      }
    }
  }

  cout << endl << "*" << endl;
  delete vals1;
  delete vals2;
  if(vecfile) {
    vec_in = anand_fclose(vec_in);
  }

  return;
}

