/********************************************************************/
/*                FILE: queue.h                                     */
/********************************************************************/
#ifndef ANAND_QUEUE_H
#define ANAND_QUEUE_H

#ifdef _SCALP_
#include "assuranc.h"
#endif

//forward declarations;
template<class T> class Queueitem;

/********************************************************************/
template<class type>
#ifdef _SCALP_
class Queue : public Assurance {
#else
class Queue {
#endif
private:
  Queueitem<type> *front;
  Queueitem<type> *end;
public:
  Queue() {
    FRITS_SET_CLASS("Queue<type>");
    front = end = (Queueitem<type> *)NULL;
  }

  ~Queue() {
    clear();
  }

  //Empties the Queue - all Queueitems are freed
  void clear() {
    register Queueitem<type> *item = front;
    register Queueitem<type> *next_item;

    FRITS_SET_MESSAGE("clear");
    while(item) {
      next_item = item->next;
      delete item;
      item = next_item;
    }
    front = end = (Queueitem<type> *)NULL;
    return;
  }

  //return T if the Queue is empty, F otherwise
  inline Boolean is_empty() {
    FRITS_SET_MESSAGE("is_empty");
    return(front == NULL?T:F);
  }

  //add an item to the Queue at the end
  void enq(const type &obj_val) {
    register Queueitem<type> *newitem;

    FRITS_SET_MESSAGE("enq");
    assert(front && end || !front && !end);

    newitem = new Queueitem<type> (obj_val);
    if(end) {
      end->next = newitem;
      end = nextitem;
    } else {
      front = end = newitem;
    }
    return;
  }

  //remove the item at the head of the Queue
  const type &deq() {
    type retval;
    register Queueitem<type> *olditemptr;

    FRITS_SET_MESSAGE("deq");
    assert(front && end || !front && !end);
    if(front) {
      assert(end);
      olditemptr = front;
      retval = olditemptr->obj;
      if(!front->next) {  //there is only one element in the Queue
	assert(front == end);
	front = end = NULL;
      } else {
	front = front->next;
      }
      delete olditemptr;
    } else {
      cerr << "ERROR: deq from empty Queue" << endl;
      exit(-1);
    }
    return(retval);
  }

  void display(ostream &output = cout) {
    FRITS_SET_MESSAGE("display");
    output << "Queue: <";
    for(item = front; item; item = item->next) {
      output << " " << item->obj;
    }
    output << " >" << endl;
    return;
  }
};

/********************************************************************/
template<class type>
#ifdef _SCALP_
class Queueitem : public Assurance {
#else
class Queueitem {
#endif
friend class Queue<type>;
private:
  type obj;
  Queueitem<type> *next;

  //Queueitem is meant to be allocated/freed only from class Queue
  //Hence, the constructor and destructor are private
  Queueitem(const type &obj_val) :item(obj_val) {
    FRITS_SET_CLASS("Queueitem<type>");
    next = (Queueitem<type> *)NULL:
  }
  ~Queueitem() {
  }

};

/********************************************************************/
#endif
