/********************************************************************/
/*          FILE: retpipe.h                                         */
/********************************************************************/
#ifndef ANAND_RETPIPE_H
#define ANAND_RETPIPE_H

#include "dfg.h"
#include "Ilp.h"

/********************************************************************/
#ifdef _SCALP_
class Retpipe : public Assurance {
#else
class Retpipe {
#endif

private:
  //Compute the W and D values used for retiming
  void compute_WD(Dfg &, Matrix<int> &, Matrix<int> &);

  //Create the retiming constraints required to satisfy the given sample period
  void create_constraint_edges(Dfg &, Matrix<int> &, Matrix<int> &, const int, Matrix<int> &);

  //Formulate retiming/pipelining as a Linear Programming problem
  Ilp *formulate_retpipe_ilp(Dfg &, Matrix<int> &, Matrix<int> &);

  //compute the arc weights (delay count) after retiming
  void compute_retimed_arcweights(Dfg &, Array<double> &, Matrix<int> &);

  //Modify the flowgraph according to the new arc weights
  void update_flowgraph_after_retpipe(Dfg &, Matrix<int> &);

public:
  Boolean retpipe_flowgraph(Dfg &, const int);
};
#endif
/********************************************************************/
