%{
void yyerror(const char *);
int trace(char *, char *);
int yylineno = 1;
%}
whitesp         [ \t]
newline         [\n]
num             [0-9]
alpha           [A-Za-z_+\-*/&|\^@]
alnum           [A-Za-z0-9_<>$%:+\-*/&|\^@]
dot             [.]
equal           [=]
backslash       [\\]

%%
{num}+                     { trace(yytext, "INTNUMBER"); yylval.intval = atoi(yytext); return INTNUMBER;}
({num}+)(({dot}({num}+))?) { trace(yytext, "FLTNUMBER"); yylval.fltval = atof(yytext); return FLTNUMBER;}
{backslash}                { trace(yytext, "BACKSLASH"); return BACKSLASH;}
{newline}                  {yylineno++; trace(yytext, "NEWLINE"); return NEWLINE;}
{whitesp}+		   ; /*IGNORE WHITE SPACE*/
#.*			   ; /*COMMENT*/
.			   { trace(yytext,"ERROR"); yyerror("Bad character/keyword/identifier"); }
%%
void yyerror(const char *errmsg)
{
  cout << "ERROR: Line " << yylineno << ": " << errmsg << endl;
  return;
}

int trace(char *text, char *token)
{
#ifdef VECPARSE_DEBUG
  cout << "Line: " << yylineno << " Text: " << text << " returning " << token << endl;
#endif
  return(0);
}
