%{
#include "basic.h"
#include "list_ar.h"
#include "scm.h"
%}

%token <intval> INTNUMBER;
%token <fltval> FLTNUMBER;
%token NEWLINE
%token BACKSLASH


%union {
  int intval;		        /*to pass integers*/
  float  fltval;                /*to pass numbers*/
}

%type <intval> pivalue;

%start vector;

%%

vector : 
{
#ifdef VECPARSE_DEBUG
  cout << "Begin parsing vector file..." << endl;
#endif
  //vector is assumed to be empty initially
  assert(cur_vector.get_size() == 0);
}
         pivalues NEWLINE
{
#ifdef VECPARSE_DEBUG
  cout << "Read vector, end parsing vector file..." << endl;
#endif
  assert(cur_vector.get_size());
  return(0);
}
       | NEWLINE
{
#ifdef VECPARSE_DEBUG
  cout << "End parsing vector file..." << endl;
#endif
  return(0);
}
       |
{
#ifdef VECPARSE_DEBUG
  cout << "End parsing vector file..." << endl;
#endif
  return(0);
}
       ;

pivalues : pivalue
{
  cur_vector.append((unsigned int)$1);
}
         | pivalues pivalue
{
  cur_vector.append((unsigned int)$2);
}
         ;

pivalue : INTNUMBER
{
  $$ = $1;
}
        | INTNUMBER BACKSLASH NEWLINE
{
  $$ = $1;
}
        ;

%%
#include "veclex.C"
int yywrap() {
  return 1;
}
