/********************************************************************/
/*                FILE: stack.h                                     */
/********************************************************************/
#include <assert.h>
#ifndef ANAND_STACK_H
#define ANAND_STACK_H

#ifdef _SCALP_
#include "assuranc.h"
#endif

#define BOTTOM_OF_STACK -1
template<class type>
#ifdef _SCALP_
class Stack : public Assurance {
#else
class Stack {
#endif
private:
  int top;
  int size;
  type *elements;

public:
  Stack(int count) {
    FRITS_SET_CLASS("Stack<type>");
    assert(count > 0);
    size = count;
    elements = new type[count];
    top = BOTTOM_OF_STACK;
  }

  ~Stack() {
    delete [] elements;
  }

  inline Boolean is_full() {
    FRITS_SET_MESSAGE("is_full");
    return((top == (size-1))?T:F);
  }

  inline Boolean is_empty()  {
    FRITS_SET_MESSAGE("is_empty");
    return(top == BOTTOM_OF_STACK?T:F);
  }

  void push(const type &obj_val) {
    FRITS_SET_MESSAGE("push");
    assert(top >= BOTTOM_OF_STACK && top < size);
    if(is_full()) {
      cerr << "ERROR: push on full Stack - Stack size is " << size << endl;
      exit(-1);
    }
    top++;
    elements[top] = obj_val;
    return;
  }

  type &pop() {
    FRITS_SET_MESSAGE("pop");
    assert(top >= BOTTOM_OF_STACK && top < size);
    if(is_empty()) {
      cerr << "ERROR: pop from empty Stack" << endl;
      exit(-1);
    }
    return(elements[top--]);
  }

  //clear the Stack - make it an empty Stack
  void clear() {
    FRITS_SET_MESSAGE("clear");
    assert(top >= BOTTOM_OF_STACK && top < size);
    top = BOTTOM_OF_STACK;
    return;
  }

  //print out the Stack
  void display(ostream &output = cout) {
    register int i;
    FRITS_SET_MESSAGE("display");
    assert(top >= BOTTOM_OF_STACK && top < size);
    output << "Stack: <";
    for(i = 0; i <= top; i++) {
      output << " " << elements[i];
    }
    output << " >" << endl;
    return;
  }
};
#endif
/********************************************************************/
