extern char *malloc(), *realloc();

# line 2 "bench.y"
/*
 * FILE: bench.y
 */

#include "pretg.h"

/* variables used only in the yacc (and possibly lex) */
char bench_Lasttoken[MAXSTRLEN];            /* the last token parsed */
char bench_errorbuf[MAXSTRLEN];             /* to store error messages */

extern int bench_make_primary_input();

# line 19 "bench.y"
typedef union  {
  char charptr[PLEN];           /* to pass identifiers */
  LISTPTR listptr;              /* to pass lists */
  FUNCTION function;            /* to pass function types */
} BENCH_STYPE;
# define BENCH_ID 257
# define BENCH_CR 258
# define BENCH_INPUT 259
# define BENCH_OUTPUT 260
# define BENCH_INOUT 261
# define BENCH_REQD0 262
# define BENCH_REQD1 263
# define BENCH_REQDX 264
# define BENCH_DFF 265
# define BENCH_AND 266
# define BENCH_NAND 267
# define BENCH_OR 268
# define BENCH_NOR 269
# define BENCH_XOR 270
# define BENCH_XNOR 271
# define BENCH_BUFF 272
# define BENCH_NOT 273
# define BENCH_IOBF 274
# define BENCH_ST3 275
# define BENCH_ZERO 276
# define BENCH_ONE 277
#define bench_clearin bench_char = -1
#define bench_errok bench_errflag = 0
extern int bench_char;
extern int bench_errflag;
#ifndef BENCH_MAXDEPTH
#define BENCH_MAXDEPTH 150
#endif
BENCH_STYPE bench_lval, bench_val;
# define BENCH_ERRCODE 256

# line 266 "bench.y"


#include "bench.x"

bench_error(s)
char *s;
{
  assert(s && bench_Lasttoken);

  printf("\n"); fflush(stdout);
  fprintf(stderr, "#\n# ERROR: %s on line %d near token '%s'\n#\n",
          s, bench_lineno, bench_Lasttoken);
  exit(SYNTAX__ERROR);
}

bench_semantic_error(s)
char *s;
{
  assert(s && bench_Lasttoken);

  fprintf(stderr, "#\n# ERROR on line %d near token '%s'\n# %s\n#\n#\n",
          bench_lineno, bench_Lasttoken, s);
  exit(SEMANTIC__ERROR);
}

int bench_make_primary_input(name, nodelist)
char *name;
LISTPTR *nodelist;
{
  char errorbuf[MAXSTRLEN];
  NODEPTR node;

  assert(nodelist);

  if (h_lookup(Hashtable, name)) {
    sprintf(errorbuf, "redefinition of input %s", name);
    bench_semantic_error(errorbuf);
  }

  node = nodecreate(Nodecount++, (char *)NULL, NONT);
  strcpy(node->name, strchk(name));
  h_add(Hashtable, node->name, (char *)node);
  node->func = GPI;
  node->type = PI;
  l_append(*nodelist, (int)node);

  return(node->address);
}

int bench_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define BENCH_NPROD 26
# define BENCH_LAST 50
int bench_act[]={

    28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
    38,    25,    26,    10,    50,     4,     5,     6,     7,     8,
     9,    47,    24,    23,    22,    21,    20,    19,    18,    48,
    44,    43,    49,    42,    41,    40,    39,    45,    17,    16,
    15,    14,    13,    12,     3,     2,    46,    11,    27,     1 };
int bench_pact[]={

  -244, -1000,  -244, -1000,     3,     2,     1,     0,    -1,    -2,
   -33, -1000,  -230,  -231,  -232,  -233,  -234,  -235,  -265,    -5,
    -6,    -7,    -8,   -10,   -11, -1000, -1000,    -3, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000,  -236,   -12, -1000, -1000,  -243,
 -1000 };
int bench_pgo[]={

     0,    49,    48,    46,    45,    44 };
int bench_r1[]={

     0,     1,     4,     4,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     3,     3 };
int bench_r2[]={

     0,     3,     3,     5,     9,     9,     9,     9,     9,     9,
     7,     7,    13,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     7 };
int bench_chk[]={

 -1000,    -1,    -4,    -5,   259,   260,   261,   262,   263,   264,
   257,    -5,    40,    40,    40,    40,    40,    40,    61,   257,
   257,   257,   257,   257,   257,   276,   277,    -2,   265,   266,
   267,   268,   269,   270,   271,   272,   273,   274,   275,    41,
    41,    41,    41,    41,    41,    40,    -3,   257,    41,    44,
   257 };
int bench_def[]={

     0,    -2,     1,     2,     0,     0,     0,     0,     0,     0,
     0,     3,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    10,    11,     0,    13,    14,
    15,    16,    17,    18,    19,    20,    21,    22,    23,     4,
     5,     6,     7,     8,     9,     0,     0,    24,    12,     0,
    25 };
typedef struct { char *t_name; int t_val; } bench_toktype;
#ifndef BENCH_DEBUG
#	define BENCH_DEBUG	0	/* don't allow debugging */
#endif

#if BENCH_DEBUG

bench_toktype bench_toks[] =
{
	"BENCH_ID",	257,
	"BENCH_CR",	258,
	"BENCH_INPUT",	259,
	"BENCH_OUTPUT",	260,
	"BENCH_INOUT",	261,
	"BENCH_REQD0",	262,
	"BENCH_REQD1",	263,
	"BENCH_REQDX",	264,
	"BENCH_DFF",	265,
	"BENCH_AND",	266,
	"BENCH_NAND",	267,
	"BENCH_OR",	268,
	"BENCH_NOR",	269,
	"BENCH_XOR",	270,
	"BENCH_XNOR",	271,
	"BENCH_BUFF",	272,
	"BENCH_NOT",	273,
	"BENCH_IOBF",	274,
	"BENCH_ST3",	275,
	"BENCH_ZERO",	276,
	"BENCH_ONE",	277,
	"-unknown-",	-1	/* ends search */
};

char * bench_reds[] =
{
	"-no such reduction-",
	"bench : node_list",
	"node_list : node",
	"node_list : node_list node",
	"node : BENCH_INPUT '(' BENCH_ID ')'",
	"node : BENCH_OUTPUT '(' BENCH_ID ')'",
	"node : BENCH_INOUT '(' BENCH_ID ')'",
	"node : BENCH_REQD0 '(' BENCH_ID ')'",
	"node : BENCH_REQD1 '(' BENCH_ID ')'",
	"node : BENCH_REQDX '(' BENCH_ID ')'",
	"node : BENCH_ID '=' BENCH_ZERO",
	"node : BENCH_ID '=' BENCH_ONE",
	"node : BENCH_ID '=' type '(' input_list ')'",
	"type : BENCH_DFF",
	"type : BENCH_AND",
	"type : BENCH_NAND",
	"type : BENCH_OR",
	"type : BENCH_NOR",
	"type : BENCH_XOR",
	"type : BENCH_XNOR",
	"type : BENCH_BUFF",
	"type : BENCH_NOT",
	"type : BENCH_IOBF",
	"type : BENCH_ST3",
	"input_list : BENCH_ID",
	"input_list : input_list ',' BENCH_ID",
};
#endif /* BENCH_DEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define BENCH_ERROR		goto bench_errlab
#define BENCH_ACCEPT	{ free((char *)bench_s); free((char *)bench_v); return(0); }
#define BENCH_ABORT		{ free((char *)bench_s); free((char *)bench_v); return(1); }
#define BENCH_BACKUP( newtoken, newvalue )\
{\
	if ( bench_char >= 0 || ( bench_r2[ bench_tmp ] >> 1 ) != 1 )\
	{\
		bench_error( "syntax error - cannot backup" );\
		goto bench_errlab;\
	}\
	bench_char = newtoken;\
	bench_state = *bench_ps;\
	bench_lval = newvalue;\
	goto bench_newstate;\
}
#define BENCH_RECOVERING()	(!!bench_errflag)
#ifndef BENCH_DEBUG
#	define BENCH_DEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int bench_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define BENCH_FLAG		(-1000)

/*
** static variables used by the parser
*/
static BENCH_STYPE *bench_v;			/* value stack */
static int *bench_s;			/* state stack */

static BENCH_STYPE *bench_pv;			/* top of value stack */
static int *bench_ps;			/* top of state stack */

static int bench_state;			/* current state */
static int bench_tmp;			/* extra var (lasts between blocks) */

int bench_nerrs;			/* number of errors */

int bench_errflag;			/* error recovery flag */
int bench_char;			/* current input token number */


/*
** bench_parse - return 0 if worked, 1 if syntax error not recovered from
*/
int
bench_parse()
{
	register BENCH_STYPE *bench_pvt = 0;	/* top of value stack for $vars */
	unsigned bench_maxdepth = BENCH_MAXDEPTH;

	/*
	** Initialize externals - bench_parse may be called more than once
	*/
	bench_v = (BENCH_STYPE*)malloc(bench_maxdepth*sizeof(BENCH_STYPE));
	bench_s = (int*)malloc(bench_maxdepth*sizeof(int));
	if (!bench_v || !bench_s)
	{
		bench_error( "out of memory" );
		return(1);
	}
	bench_pv = &bench_v[-1];
	bench_ps = &bench_s[-1];
	bench_state = 0;
	bench_tmp = 0;
	bench_nerrs = 0;
	bench_errflag = 0;
	bench_char = -1;

	goto bench_stack;
	{
		register BENCH_STYPE *bench__pv;	/* top of value stack */
		register int *bench__ps;		/* top of state stack */
		register int bench__state;		/* current state */
		register int  bench__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if BENCH_BACKUP was called.
		*/
	bench_newstate: if (bench_debug) goto bench_newstate;
		bench__pv = bench_pv;
		bench__ps = bench_ps;
		bench__state = bench_state;
		goto bench__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	bench_stack:
		bench__pv = bench_pv;
		bench__ps = bench_ps;
		bench__state = bench_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	bench__stack:
		/*
		** put a state and value onto the stacks
		*/
#if BENCH_DEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( bench_debug )
		{
			register int bench__i;

			(void)printf( "State %d, token ", bench__state );
			if ( bench_char == 0 )
				(void)printf( "end-of-file\n" );
			else if ( bench_char < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( bench__i = 0; bench_toks[bench__i].t_val >= 0;
					bench__i++ )
				{
					if ( bench_toks[bench__i].t_val == bench_char )
						break;
				}
				(void)printf( "%s\n", bench_toks[bench__i].t_name );
			}
		}
#endif /* BENCH_DEBUG */
		if ( ++bench__ps >= &bench_s[ bench_maxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int bench_ps_index = (bench__ps - bench_s);
			int bench_pv_index = (bench__pv - bench_v);
			int bench_pvt_index = (bench_pvt - bench_v);
			bench_maxdepth += BENCH_MAXDEPTH;
			bench_v = (BENCH_STYPE*)realloc((char*)bench_v,
				bench_maxdepth * sizeof(BENCH_STYPE));
			bench_s = (int*)realloc((char*)bench_s,
				bench_maxdepth * sizeof(int));
			if (!bench_v || !bench_s)
			{
				bench_error( "yacc stack overflow" );
				return(1);
			}
			bench__ps = bench_s + bench_ps_index;
			bench__pv = bench_v + bench_pv_index;
			bench_pvt = bench_v + bench_pvt_index;
		}
		*bench__ps = bench__state;
		*++bench__pv = bench_val;

		/*
		** we have a new state - find out what to do
		*/
	bench__newstate:
		if ( ( bench__n = bench_pact[ bench__state ] ) <= BENCH_FLAG )
			goto bench_default;		/* simple state */
#if BENCH_DEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		bench_tmp = bench_char < 0;
#endif
		if ( ( bench_char < 0 ) && ( ( bench_char = bench_lex() ) < 0 ) )
			bench_char = 0;		/* reached EOF */
#if BENCH_DEBUG
		if ( bench_debug && bench_tmp )
		{
			register int bench__i;

			(void)printf( "Received token " );
			if ( bench_char == 0 )
				(void)printf( "end-of-file\n" );
			else if ( bench_char < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( bench__i = 0; bench_toks[bench__i].t_val >= 0;
					bench__i++ )
				{
					if ( bench_toks[bench__i].t_val == bench_char )
						break;
				}
				(void)printf( "%s\n", bench_toks[bench__i].t_name );
			}
		}
#endif /* BENCH_DEBUG */
		if ( ( ( bench__n += bench_char ) < 0 ) || ( bench__n >= BENCH_LAST ) )
			goto bench_default;
		if ( bench_chk[ bench__n = bench_act[ bench__n ] ] == bench_char )	/*valid shift*/
		{
			bench_char = -1;
			bench_val = bench_lval;
			bench__state = bench__n;
			if ( bench_errflag > 0 )
				bench_errflag--;
			goto bench__stack;
		}

	bench_default:
		if ( ( bench__n = bench_def[ bench__state ] ) == -2 )
		{
#if BENCH_DEBUG
			bench_tmp = bench_char < 0;
#endif
			if ( ( bench_char < 0 ) && ( ( bench_char = bench_lex() ) < 0 ) )
				bench_char = 0;		/* reached EOF */
#if BENCH_DEBUG
			if ( bench_debug && bench_tmp )
			{
				register int bench__i;

				(void)printf( "Received token " );
				if ( bench_char == 0 )
					(void)printf( "end-of-file\n" );
				else if ( bench_char < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( bench__i = 0;
						bench_toks[bench__i].t_val >= 0;
						bench__i++ )
					{
						if ( bench_toks[bench__i].t_val
							== bench_char )
						{
							break;
						}
					}
					(void)printf( "%s\n", bench_toks[bench__i].t_name );
				}
			}
#endif /* BENCH_DEBUG */
			/*
			** look through exception table
			*/
			{
				register int *bench_xi = bench_exca;

				while ( ( *bench_xi != -1 ) ||
					( bench_xi[1] != bench__state ) )
				{
					bench_xi += 2;
				}
				while ( ( *(bench_xi += 2) >= 0 ) &&
					( *bench_xi != bench_char ) )
					;
				if ( ( bench__n = bench_xi[1] ) < 0 )
					BENCH_ACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( bench__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( bench_errflag )
			{
			case 0:		/* new error */
				bench_error( "syntax error" );
				goto skip_init;
			bench_errlab: if (bench_debug) goto bench_errlab;
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				bench__pv = bench_pv;
				bench__ps = bench_ps;
				bench__state = bench_state;
				bench_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				bench_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( bench__ps >= bench_s )
				{
					bench__n = bench_pact[ *bench__ps ] + BENCH_ERRCODE;
					if ( bench__n >= 0 && bench__n < BENCH_LAST &&
						bench_chk[bench_act[bench__n]] == BENCH_ERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						bench__state = bench_act[ bench__n ];
						goto bench__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if BENCH_DEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( bench_debug )
						(void)printf( _POP_, *bench__ps,
							bench__ps[-1] );
#	undef _POP_
#endif
					bench__ps--;
					bench__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				BENCH_ABORT;
			case 3:		/* no shift yet; eat a token */
#if BENCH_DEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( bench_debug )
				{
					register int bench__i;

					(void)printf( "Error recovery discards " );
					if ( bench_char == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( bench_char < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( bench__i = 0;
							bench_toks[bench__i].t_val >= 0;
							bench__i++ )
						{
							if ( bench_toks[bench__i].t_val
								== bench_char )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							bench_toks[bench__i].t_name );
					}
				}
#endif /* BENCH_DEBUG */
				if ( bench_char == 0 )	/* reached EOF. quit */
					BENCH_ABORT;
				bench_char = -1;
				goto bench__newstate;
			}
		}/* end if ( bench__n == 0 ) */
		/*
		** reduction by production bench__n
		** put stack tops, etc. so things right after switch
		*/
#if BENCH_DEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( bench_debug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				bench__n, bench_reds[ bench__n ] );
#endif
		bench_tmp = bench__n;			/* value to switch over */
		bench_pvt = bench__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using bench__state here as temporary
		** register variable, but why not, if it works...
		** If bench_r2[ bench__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto bench__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int bench__len = bench_r2[ bench__n ];

			if ( !( bench__len & 01 ) )
			{
				bench__len >>= 1;
				bench_val = ( bench__pv -= bench__len )[1];	/* $$ = $1 */
				bench__state = bench_pgo[ bench__n = bench_r1[ bench__n ] ] +
					*( bench__ps -= bench__len ) + 1;
				if ( bench__state >= BENCH_LAST ||
					bench_chk[ bench__state =
					bench_act[ bench__state ] ] != -bench__n )
				{
					bench__state = bench_act[ bench_pgo[ bench__n ] ];
				}
				goto bench__stack;
			}
			bench__len >>= 1;
			bench_val = ( bench__pv -= bench__len )[1];	/* $$ = $1 */
			bench__state = bench_pgo[ bench__n = bench_r1[ bench__n ] ] +
				*( bench__ps -= bench__len ) + 1;
			if ( bench__state >= BENCH_LAST ||
				bench_chk[ bench__state = bench_act[ bench__state ] ] != -bench__n )
			{
				bench__state = bench_act[ bench_pgo[ bench__n ] ];
			}
		}
					/* save until reenter driver code */
		bench_state = bench__state;
		bench_ps = bench__ps;
		bench_pv = bench__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( bench_tmp )
	{
		
case 1:
# line 59 "bench.y"
{
      TRACE("bench: node_list");

      /* finish line number output */
      display_lineno((FILE *)NULL, bench_lineno);

      assert(Nodelist);
      assert(Nodecount == l_len(Nodelist) + 1);

      allocate_nodes(&Nodelist);   /* eats Nodelist */
      assert(!Nodelist);
      fprintf(stdout, "#\n"); fflush(stdout);

      fix_connectivity();
      assert(check_connectivity());
    } break;
case 2:
# line 79 "bench.y"
{
      TRACE("node_list: node");
    } break;
case 3:
# line 83 "bench.y"
{
      TRACE("node_list: node_list node");
    } break;
case 4:
# line 90 "bench.y"
{
      TRACE("node: BENCH_INPUT '(' BENCH_ID ')'");

      bench_make_primary_input(bench_pvt[-1].charptr, &Nodelist);
    } break;
case 5:
# line 96 "bench.y"
{
      TRACE("node: BENCH_OUTPUT '(' BENCH_ID ')'");

      l_append(Outputs, (int)strcreate(bench_pvt[-1].charptr, __LINE__, __FILE__));
    } break;
case 6:
# line 102 "bench.y"
{
      TRACE("node: BENCH_INOUT '(' BENCH_ID ')'");

      l_append(Outputs, (int)strcreate(bench_pvt[-1].charptr, __LINE__, __FILE__));
    } break;
case 7:
# line 108 "bench.y"
{
      TRACE("node: BENCH_REQD0 '(' BENCH_ID ')'");
    } break;
case 8:
# line 112 "bench.y"
{
      TRACE("node: BENCH_REQD1 '(' BENCH_ID ')'");
    } break;
case 9:
# line 116 "bench.y"
{
      TRACE("node: BENCH_REQDX '(' BENCH_ID ')'");
    } break;
case 10:
# line 120 "bench.y"
{
      NODEPTR node;

      TRACE("node: BENCH_ID '=' BENCH_ZERO");

      if (h_lookup(Hashtable, bench_pvt[-2].charptr)) {
        sprintf(bench_errorbuf, "redefinition of node %s", bench_pvt[-2].charptr);
        bench_semantic_error(bench_errorbuf);
      }

      node = nodecreate(Nodecount++, (char *)NULL, NONT);
      strcpy(node->name, bench_pvt[-2].charptr);
      h_add(Hashtable, node->name, (char *)node);
      node->func = GZERO;
      l_append(Nodelist, (int)node);
    } break;
case 11:
# line 137 "bench.y"
{
      NODEPTR node;

      TRACE("node: BENCH_ID '=' BENCH_ONE");

      if (h_lookup(Hashtable, bench_pvt[-2].charptr)) {
        sprintf(bench_errorbuf, "redefinition of node %s", bench_pvt[-2].charptr);
        bench_semantic_error(bench_errorbuf);
      }

      node = nodecreate(Nodecount++, (char *)NULL, NONT);
      strcpy(node->name, bench_pvt[-2].charptr);
      h_add(Hashtable, node->name, (char *)node);
      node->func = GONE;
      l_append(Nodelist, (int)node);
    } break;
case 12:
# line 154 "bench.y"
{
      NODEPTR node;

      TRACE("node: BENCH_ID '=' type '(' input_list ')'");

      if (h_lookup(Hashtable, bench_pvt[-5].charptr)) {
        sprintf(bench_errorbuf, "redefinition of node %s", bench_pvt[-5].charptr);
        bench_semantic_error(bench_errorbuf);
      }

      node = nodecreate(Nodecount++, (char *)NULL, NONT);
      strcpy(node->name, bench_pvt[-5].charptr);
      h_add(Hashtable, node->name, (char *)node);

      if ((node->func = bench_pvt[-3].function) == GDFF) node->type = PPI;
      node->n_fanin = l_len(bench_pvt[-1].listptr);
      node->in = bench_pvt[-1].listptr;
      l_append(Nodelist, (int)node);

      /* make a primary input out of the first input of all GIOBFs */
      if (node->func == GIOBF) {
        char *p = (char *)l_delete(&node->in, node->in);
        node->n_fanin--;
        node->inout = bench_make_primary_input(p, &Nodelist);
      }
    } break;
case 13:
# line 184 "bench.y"
{
      TRACE("type: BENCH_DFF");

      bench_val.function = GDFF;
    } break;
case 14:
# line 190 "bench.y"
{
      TRACE("type: BENCH_AND");

      bench_val.function = GAND;
    } break;
case 15:
# line 196 "bench.y"
{
      TRACE("type: BENCH_NAND");

      bench_val.function = GNAND;
    } break;
case 16:
# line 202 "bench.y"
{
      TRACE("type: BENCH_OR");

      bench_val.function = GOR;
    } break;
case 17:
# line 208 "bench.y"
{
      TRACE("type: BENCH_NOR");

      bench_val.function = GNOR;
    } break;
case 18:
# line 214 "bench.y"
{
      TRACE("type: BENCH_XOR");

      bench_val.function = GXOR;
    } break;
case 19:
# line 220 "bench.y"
{
      TRACE("type: BENCH_XNOR");

      bench_val.function = GXNOR;
    } break;
case 20:
# line 226 "bench.y"
{
      TRACE("type: BENCH_BUFF");

      bench_val.function = GBUFF;
    } break;
case 21:
# line 232 "bench.y"
{
      TRACE("type: BENCH_NOT");

      bench_val.function = GNOT;
    } break;
case 22:
# line 238 "bench.y"
{
      TRACE("type: BENCH_IOBF");

      bench_val.function = GIOBF;
    } break;
case 23:
# line 244 "bench.y"
{
      TRACE("type: BENCH_ST3");

      bench_val.function = GST3;
    } break;
case 24:
# line 253 "bench.y"
{
      TRACE("input_list: BENCH_ID");

      bench_val.listptr = L_CREATE((int)strcreate(bench_pvt[-0].charptr, __LINE__, __FILE__));
    } break;
case 25:
# line 259 "bench.y"
{
      TRACE("input_list: input_list ',' BENCH_ID");

      bench_val.listptr = l_cat(bench_pvt[-2].listptr, L_CREATE((int)strcreate(bench_pvt[-0].charptr, __LINE__, __FILE__)));
    } break;
	}
	goto bench_stack;		/* reset registers in driver code */
}
