%{
/*
 * FILE: bench.l
 */

#define YYCHKPNT 1000
%}

A [Aa]
B [Bb]
C [Cc]
D [Dd]
E [Ee]
F [Ff]
G [Gg]
H [Hh]
I [Ii]
J [Jj]
K [Kk]
L [Ll]
M [Mm]
N [Nn]
O [Oo]
P [Pp]
Q [Qq]
R [Rr]
S [Ss]
T [Tt]
U [Uu]
V [Vv]
W [Ww]
X [Xx]
Y [Yy]
Z [Zz]
W1 [ \t\b\r\f\n]+
ID [A-Za-z0-9_]*[A-Za-z_][A-Za-z0-9_]*

%%
                                /* declare local variables */
                                char buf[BUFSIZ];
                                int c, done;

{W1}                            { /* ignore white space */
                                  if (!Trace) {
                                    static int yypline = 0;
                                    if (yylineno - yypline > YYCHKPNT) {
                                      yypline = yylineno - (yylineno%YYCHKPNT);
                                      display_lineno(yyin, yypline);
                                    }
                                  }
                                }

"#"                             { /* ignore comments */
                                  done = 0;
                                  while (!done) {
                                    if ((c = input()) == '\n') {
                                      done = 1; unput(c);
                                    } else if (c == EOF) {
                                      yyerror("syntax error (EOF in comment)");
                                    }
                                  }
                                }

{I}{N}{P}{U}{T}                 { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYINPUT");
                                  return(YYINPUT);;; }

{O}{U}{T}{P}{U}{T}              { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYOUTPUT");
                                  return(YYOUTPUT);;; }

{I}{N}{O}{U}{T}                 { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYINOUT");
                                  return(YYINOUT);;; }

{R}{E}{Q}{D}0                   { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYREQD0");
                                  return(YYREQD0);;; }

{R}{E}{Q}{D}1                   { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYREQD1");
                                  return(YYREQD1);;; }

{R}{E}{Q}{D}{X}                 { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYREQDX");
                                  return(YYREQDX);;; }

{D}{F}{F}                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYDFF");
                                  return(YYDFF);;; }

{A}{N}{D}                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYAND");
                                  return(YYAND);;; }

{N}{A}{N}{D}                    { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYNAND");
                                  return(YYNAND);;; }

{O}{R}                          { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYOR");
                                  return(YYOR);;; }

{N}{O}{R}                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYNOR");
                                  return(YYNOR);;; }

{X}{O}{R}                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYXOR");
                                  return(YYXOR);;; }

{X}{N}{O}{R}                    { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYXNOR");
                                  return(YYXNOR);;; }

{B}{U}{F}{F}                    { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYBUFF");
                                  return(YYBUFF);;; }

{N}{O}{T}                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYNOT");
                                  return(YYNOT);;; }

{I}{O}{B}{F}                    { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYIOBF");
                                  return(YYIOBF);;; }

{S}{T}3                         { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYST3");
                                  return(YYST3);;; }

{Z}{E}{R}{O}                    { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYZERO");
                                  return(YYZERO);;; }

{O}{N}{E}                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYONE");
                                  return(YYONE);;; }

{ID}                            { strcpy(yyLasttoken, strchk(yytext));
                                  strcpy(yylval.charptr, yytext);
                                  if (Trace)
                                    sprintf(buf, "        returning YYID (%s)",
                                            yytext);
                                  TRACE(buf);
                                  return(YYID);;; }

\\                              { /*
                                   * escaped identifier
                                   * (read all chars up to a space)
                                   */
                                  done = 0;
                                  while (!done) {
                                    if ((c = input()) == ' ' || c == '\n' ||
                                        c == '\t' || c == '\b' || c == '\r' ||
                                        c == '\f') {
                                      unput(c); done = 1;
                                    } else if (c == EOF) {
                                      yyerror("syntax error (EOF in ESC ID)");
                                    } else {
                                      yytext[yyleng++] = c;
                                    }
                                  }
                                  yytext[yyleng] = '\0';
                                  strcpy(yyLasttoken, strchk(yytext));
                                  strcpy(yylval.charptr, yytext);
                                  if (Trace)
                                    sprintf(buf, "        returning YYID (%s)",
                                            yytext);
                                  TRACE(buf);
                                  return(YYID);;; }

.                               { assert(yytext[1] == '\0');
                                  strcpy(yyLasttoken, yytext);
                                  if (Trace)
                                    sprintf(buf, "        returning '%c'",
                                            yytext[0]);
                                  TRACE(buf);
                                  return(yytext[0]);;; }


%%

int yywrap() { return(1); }

