%{
/*
 * FILE: bench.y
 */

#include "pretg.h"

/* variables used only in the yacc (and possibly lex) */
char yyLasttoken[MAXSTRLEN];            /* the last token parsed */
char yyerrorbuf[MAXSTRLEN];             /* to store error messages */

extern int yymake_primary_input();
%}

/* start rule */
%start bench

/* legal token types and rule types */
%union {
  char charptr[PLEN];           /* to pass identifiers */
  LISTPTR listptr;              /* to pass lists */
  FUNCTION function;            /* to pass function types */
}

/* typed terminal symbols (tokens) */
%token <charptr> YYID   /* an arbitrary identifier */
%token YYCR             /* a carriage return */
%token YYINPUT          /* "input" */
%token YYOUTPUT         /* "output" */
%token YYINOUT          /* "inout" */
%token YYREQD0          /* "reqd0" */
%token YYREQD1          /* "reqd1" */
%token YYREQDX          /* "reqdx" */
%token YYDFF            /* "dff" */
%token YYAND            /* "and" */
%token YYNAND           /* "nand" */
%token YYOR             /* "or" */
%token YYNOR            /* "nor" */
%token YYXOR            /* "xor" */
%token YYXNOR           /* "xnor" */
%token YYBUFF           /* "buff" */
%token YYNOT            /* "not" */
%token YYIOBF           /* "iobf" */
%token YYST3            /* "st3" */
%token YYZERO           /* "zero" */
%token YYONE            /* "one" */

/* typed non-terminal symbols (rules) */
%type <function> type
%type <listptr> input_list


/* precedence table */

%%

bench
  : node_list
    {
      TRACE("bench: node_list");

      /* finish line number output */
      display_lineno((FILE *)NULL, yylineno);

      assert(Nodelist);
      assert(Nodecount == l_len(Nodelist) + 1);

      allocate_nodes(&Nodelist);   /* eats Nodelist */
      assert(!Nodelist);
      fprintf(stdout, "#\n"); fflush(stdout);

      fix_connectivity();
      assert(check_connectivity());
    }
  ;

node_list
  : node
    {
      TRACE("node_list: node");
    }
  | node_list node
    {
      TRACE("node_list: node_list node");
    }
  ;

node
  : YYINPUT '(' YYID ')'
    {
      TRACE("node: YYINPUT '(' YYID ')'");

      yymake_primary_input($3, &Nodelist);
    }
  | YYOUTPUT '(' YYID ')'
    {
      TRACE("node: YYOUTPUT '(' YYID ')'");

      l_append(Outputs, (int)strcreate($3, __LINE__, __FILE__));
    }
  | YYINOUT '(' YYID ')'
    {
      TRACE("node: YYINOUT '(' YYID ')'");

      l_append(Outputs, (int)strcreate($3, __LINE__, __FILE__));
    }
  | YYREQD0 '(' YYID ')'
    {
      TRACE("node: YYREQD0 '(' YYID ')'");
    }
  | YYREQD1 '(' YYID ')'
    {
      TRACE("node: YYREQD1 '(' YYID ')'");
    }
  | YYREQDX '(' YYID ')'
    {
      TRACE("node: YYREQDX '(' YYID ')'");
    }
  | YYID '=' YYZERO
    {
      NODEPTR node;

      TRACE("node: YYID '=' YYZERO");

      if (h_lookup(Hashtable, $1)) {
        sprintf(yyerrorbuf, "redefinition of node %s", $1);
        yysemantic_error(yyerrorbuf);
      }

      node = nodecreate(Nodecount++, (char *)NULL, NONT);
      strcpy(node->name, $1);
      h_add(Hashtable, node->name, (char *)node);
      node->func = GZERO;
      l_append(Nodelist, (int)node);
    }
  | YYID '=' YYONE
    {
      NODEPTR node;

      TRACE("node: YYID '=' YYONE");

      if (h_lookup(Hashtable, $1)) {
        sprintf(yyerrorbuf, "redefinition of node %s", $1);
        yysemantic_error(yyerrorbuf);
      }

      node = nodecreate(Nodecount++, (char *)NULL, NONT);
      strcpy(node->name, $1);
      h_add(Hashtable, node->name, (char *)node);
      node->func = GONE;
      l_append(Nodelist, (int)node);
    }
  | YYID '=' type '(' input_list ')'
    {
      NODEPTR node;

      TRACE("node: YYID '=' type '(' input_list ')'");

      if (h_lookup(Hashtable, $1)) {
        sprintf(yyerrorbuf, "redefinition of node %s", $1);
        yysemantic_error(yyerrorbuf);
      }

      node = nodecreate(Nodecount++, (char *)NULL, NONT);
      strcpy(node->name, $1);
      h_add(Hashtable, node->name, (char *)node);

      if ((node->func = $3) == GDFF) node->type = PPI;
      node->n_fanin = l_len($5);
      node->in = $5;
      l_append(Nodelist, (int)node);

      /* make a primary input out of the first input of all GIOBFs */
      if (node->func == GIOBF) {
        char *p = (char *)l_delete(&node->in, node->in);
        node->n_fanin--;
        node->inout = yymake_primary_input(p, &Nodelist);
      }
    }
  ;

type
  : YYDFF
    {
      TRACE("type: YYDFF");

      $$ = GDFF;
    }
  | YYAND
    {
      TRACE("type: YYAND");

      $$ = GAND;
    }
  | YYNAND
    {
      TRACE("type: YYNAND");

      $$ = GNAND;
    }
  | YYOR
    {
      TRACE("type: YYOR");

      $$ = GOR;
    }
  | YYNOR
    {
      TRACE("type: YYNOR");

      $$ = GNOR;
    }
  | YYXOR
    {
      TRACE("type: YYXOR");

      $$ = GXOR;
    }
  | YYXNOR
    {
      TRACE("type: YYXNOR");

      $$ = GXNOR;
    }
  | YYBUFF
    {
      TRACE("type: YYBUFF");

      $$ = GBUFF;
    }
  | YYNOT
    {
      TRACE("type: YYNOT");

      $$ = GNOT;
    }
  | YYIOBF
    {
      TRACE("type: YYIOBF");

      $$ = GIOBF;
    }
  | YYST3
    {
      TRACE("type: YYST3");

      $$ = GST3;
    }
  ;

input_list
  : YYID
    {
      TRACE("input_list: YYID");

      $$ = L_CREATE((int)strcreate($1, __LINE__, __FILE__));
    }
  | input_list ',' YYID
    {
      TRACE("input_list: input_list ',' YYID");

      $$ = l_cat($1, L_CREATE((int)strcreate($3, __LINE__, __FILE__)));
    }
  ;

%%

#include "bench.x"

yyerror(s)
char *s;
{
  assert(s && yyLasttoken);

  printf("\n"); fflush(stdout);
  fprintf(stderr, "#\n# ERROR: %s on line %d near token '%s'\n#\n",
          s, yylineno, yyLasttoken);
  exit(SYNTAX__ERROR);
}

yysemantic_error(s)
char *s;
{
  assert(s && yyLasttoken);

  fprintf(stderr, "#\n# ERROR on line %d near token '%s'\n# %s\n#\n#\n",
          yylineno, yyLasttoken, s);
  exit(SEMANTIC__ERROR);
}

int yymake_primary_input(name, nodelist)
char *name;
LISTPTR *nodelist;
{
  char errorbuf[MAXSTRLEN];
  NODEPTR node;

  assert(nodelist);

  if (h_lookup(Hashtable, name)) {
    sprintf(errorbuf, "redefinition of input %s", name);
    yysemantic_error(errorbuf);
  }

  node = nodecreate(Nodecount++, (char *)NULL, NONT);
  strcpy(node->name, strchk(name));
  h_add(Hashtable, node->name, (char *)node);
  node->func = GPI;
  node->type = PI;
  l_append(*nodelist, (int)node);

  return(node->address);
}

