extern char *malloc(), *realloc();

# line 2 "blif.y"
/*
 * FILE: blif.y
 */

#include "pretg.h"

/* variables used only in the yacc (and possibly lex) */
char blif_Lasttoken[MAXSTRLEN];            /* the last token parsed */
char blif_errorbuf[MAXSTRLEN];             /* to store error messages */

extern void blif_mincheck(), blif_numcheck(), blif_setfunc();

# line 19 "blif.y"
typedef union  {
  char charptr[PLEN];           /* to pass identifiers */
  LISTPTR listptr;              /* to pass lists */
  char *function;               /* to pass functions */
} BLIF_STYPE;
# define BLIF_MODEL 257
# define BLIF_INPUTS 258
# define BLIF_OUTPUTS 259
# define BLIF_CLOCK 260
# define BLIF_NAMES 261
# define BLIF_WLS 262
# define BLIF_IA 263
# define BLIF_OR 264
# define BLIF_LATCH 265
# define BLIF_END 266
# define BLIF_CR 267
# define BLIF_ID 268
#define blif_clearin blif_char = -1
#define blif_errok blif_errflag = 0
extern int blif_char;
extern int blif_errflag;
#ifndef BLIF_MAXDEPTH
#define BLIF_MAXDEPTH 150
#endif
BLIF_STYPE blif_lval, blif_val;
# define BLIF_ERRCODE 256

# line 348 "blif.y"


#include "blif.x"

blif_error(s)
char *s;
{
  assert(s && blif_Lasttoken);

  printf("\n"); fflush(stdout);
  fprintf(stderr, "#\n# ERROR: %s on line %d near token '%s'\n#\n",
          s, blif_lineno, blif_Lasttoken);
  exit(SYNTAX__ERROR);
}

void blif_mincheck(s)
char *s;
{
  assert(s);

  for (; *s; s++)
    if (*s != '-' && *s != '0' && *s != '1')
      blif_error("bad minterm syntax");

  return;
}

void blif_numcheck(s)
char *s;
{
  assert(s);

  if (*s != '0' && *s != '1' && *s != '2' && *s != '3' && *s != '4' &&
      *s != '5' && *s != '6' && *s != '7' && *s != '8' && *s != '9' &&
      *s != '.' &&  *s != '-')
    blif_error("bad number syntax 0");

  for (s++; *s; s++)
    if (*s != '0' && *s != '1' && *s != '2' && *s != '3' && *s != '4' &&
        *s != '5' && *s != '6' && *s != '7' && *s != '8' && *s != '9' &&
        *s != '.')
      blif_error("bad number syntax 1");

  return;
}

void blif_setfunc(node)
NODEPTR node;
{
  assert(node && node->func == NOFUNC);

  if (!node->blifunc) {
    node->type = VSS;
    node->func = GZERO;
    node->blifunc = sr_strsav("0\n");
    assert(!node->n_fanin && !node->in);
  } else if (!strcmp(node->blifunc, "0\n")) {
    node->type = VSS;
    node->func = GZERO;
    assert(!node->n_fanin && !node->in);
  } else if (!strcmp(node->blifunc, "1\n")) {
    node->type = VDD;
    node->func = GONE;
    assert(!node->n_fanin && !node->in);
  } else if (!strcmp(node->blifunc, "- 0\n")) {
    node->type = VSS;
    node->func = GZERO;
    strfree(node->blifunc, __LINE__, __FILE__);
    node->blifunc = strcreate("0\n", __LINE__, __FILE__);
    node->n_fanin = 0;
    while (node->in)
      strfree((char *)l_delete(&node->in, node->in), __LINE__, __FILE__);
  } else if (!strcmp(node->blifunc, "- 1\n")) {
    node->type = VDD;
    node->func = GONE;
    strfree(node->blifunc, __LINE__, __FILE__);
    node->blifunc = strcreate("1\n", __LINE__, __FILE__);
    node->n_fanin = 0;
    while (node->in)
      strfree((char *)l_delete(&node->in, node->in), __LINE__, __FILE__);
  } else if (!strcmp(node->blifunc, "1 1\n") ||
             !strcmp(node->blifunc, "0 0\n")) {
    node->func = GBUFF;
  } else if (!strcmp(node->blifunc, "0 1\n") ||
             !strcmp(node->blifunc, "1 0\n")) {
    node->func = GNOT;
  } else if (!strcmp(node->blifunc, "10 1\n01 1\n") ||
             !strcmp(node->blifunc, "01 1\n10 1\n") ||
             !strcmp(node->blifunc, "00 0\n11 0\n") ||
             !strcmp(node->blifunc, "11 0\n00 0\n") ||
             !strcmp(node->blifunc, "001 1\n010 1\n100 1\n111 1\n") ||
             !strcmp(node->blifunc, "001 1\n010 1\n111 1\n100 1\n") ||
             !strcmp(node->blifunc, "001 1\n100 1\n010 1\n111 1\n") ||
             !strcmp(node->blifunc, "001 1\n100 1\n111 1\n010 1\n") ||
             !strcmp(node->blifunc, "001 1\n111 1\n010 1\n100 1\n") ||
             !strcmp(node->blifunc, "001 1\n111 1\n100 1\n010 1\n") ||
             !strcmp(node->blifunc, "010 1\n001 1\n100 1\n111 1\n") ||
             !strcmp(node->blifunc, "010 1\n001 1\n111 1\n100 1\n") ||
             !strcmp(node->blifunc, "010 1\n100 1\n001 1\n111 1\n") ||
             !strcmp(node->blifunc, "010 1\n100 1\n111 1\n001 1\n") ||
             !strcmp(node->blifunc, "010 1\n111 1\n001 1\n100 1\n") ||
             !strcmp(node->blifunc, "010 1\n111 1\n100 1\n001 1\n") ||
             !strcmp(node->blifunc, "100 1\n001 1\n010 1\n111 1\n") ||
             !strcmp(node->blifunc, "100 1\n001 1\n111 1\n010 1\n") ||
             !strcmp(node->blifunc, "100 1\n010 1\n001 1\n111 1\n") ||
             !strcmp(node->blifunc, "100 1\n010 1\n111 1\n001 1\n") ||
             !strcmp(node->blifunc, "100 1\n111 1\n001 1\n010 1\n") ||
             !strcmp(node->blifunc, "100 1\n111 1\n010 1\n001 1\n") ||
             !strcmp(node->blifunc, "111 1\n001 1\n010 1\n100 1\n") ||
             !strcmp(node->blifunc, "111 1\n001 1\n100 1\n010 1\n") ||
             !strcmp(node->blifunc, "111 1\n010 1\n001 1\n100 1\n") ||
             !strcmp(node->blifunc, "111 1\n010 1\n100 1\n001 1\n") ||
             !strcmp(node->blifunc, "111 1\n100 1\n001 1\n010 1\n") ||
             !strcmp(node->blifunc, "111 1\n100 1\n010 1\n001 1\n") ||
             !strcmp(node->blifunc, "000 0\n011 0\n101 0\n110 0\n") ||
             !strcmp(node->blifunc, "000 0\n011 0\n110 0\n101 0\n") ||
             !strcmp(node->blifunc, "000 0\n101 0\n011 0\n110 0\n") ||
             !strcmp(node->blifunc, "000 0\n101 0\n110 0\n011 0\n") ||
             !strcmp(node->blifunc, "000 0\n110 0\n011 0\n101 0\n") ||
             !strcmp(node->blifunc, "000 0\n110 0\n101 0\n011 0\n") ||
             !strcmp(node->blifunc, "011 0\n000 0\n101 0\n110 0\n") ||
             !strcmp(node->blifunc, "011 0\n000 0\n110 0\n101 0\n") ||
             !strcmp(node->blifunc, "011 0\n101 0\n000 0\n110 0\n") ||
             !strcmp(node->blifunc, "011 0\n101 0\n110 0\n000 0\n") ||
             !strcmp(node->blifunc, "011 0\n110 0\n000 0\n101 0\n") ||
             !strcmp(node->blifunc, "011 0\n110 0\n101 0\n000 0\n") ||
             !strcmp(node->blifunc, "101 0\n000 0\n011 0\n110 0\n") ||
             !strcmp(node->blifunc, "101 0\n000 0\n110 0\n011 0\n") ||
             !strcmp(node->blifunc, "101 0\n011 0\n000 0\n110 0\n") ||
             !strcmp(node->blifunc, "101 0\n011 0\n110 0\n000 0\n") ||
             !strcmp(node->blifunc, "101 0\n110 0\n000 0\n011 0\n") ||
             !strcmp(node->blifunc, "101 0\n110 0\n011 0\n000 0\n") ||
             !strcmp(node->blifunc, "110 0\n000 0\n011 0\n101 0\n") ||
             !strcmp(node->blifunc, "110 0\n000 0\n101 0\n011 0\n") ||
             !strcmp(node->blifunc, "110 0\n011 0\n000 0\n101 0\n") ||
             !strcmp(node->blifunc, "110 0\n011 0\n101 0\n000 0\n") ||
             !strcmp(node->blifunc, "110 0\n101 0\n000 0\n011 0\n") ||
             !strcmp(node->blifunc, "110 0\n101 0\n011 0\n000 0\n")) {
    node->func = GXOR;
  } else if (!strcmp(node->blifunc, "00 1\n11 1\n") ||
             !strcmp(node->blifunc, "11 1\n00 1\n") ||
             !strcmp(node->blifunc, "10 0\n01 0\n") ||
             !strcmp(node->blifunc, "01 0\n10 0\n") ||
             !strcmp(node->blifunc, "000 1\n011 1\n101 1\n110 1\n") ||
             !strcmp(node->blifunc, "000 1\n011 1\n110 1\n101 1\n") ||
             !strcmp(node->blifunc, "000 1\n101 1\n011 1\n110 1\n") ||
             !strcmp(node->blifunc, "000 1\n101 1\n110 1\n011 1\n") ||
             !strcmp(node->blifunc, "000 1\n110 1\n011 1\n101 1\n") ||
             !strcmp(node->blifunc, "000 1\n110 1\n101 1\n011 1\n") ||
             !strcmp(node->blifunc, "011 1\n000 1\n101 1\n110 1\n") ||
             !strcmp(node->blifunc, "011 1\n000 1\n110 1\n101 1\n") ||
             !strcmp(node->blifunc, "011 1\n101 1\n000 1\n110 1\n") ||
             !strcmp(node->blifunc, "011 1\n101 1\n110 1\n000 1\n") ||
             !strcmp(node->blifunc, "011 1\n110 1\n000 1\n101 1\n") ||
             !strcmp(node->blifunc, "011 1\n110 1\n101 1\n000 1\n") ||
             !strcmp(node->blifunc, "101 1\n000 1\n011 1\n110 1\n") ||
             !strcmp(node->blifunc, "101 1\n000 1\n110 1\n011 1\n") ||
             !strcmp(node->blifunc, "101 1\n011 1\n000 1\n110 1\n") ||
             !strcmp(node->blifunc, "101 1\n011 1\n110 1\n000 1\n") ||
             !strcmp(node->blifunc, "101 1\n110 1\n000 1\n011 1\n") ||
             !strcmp(node->blifunc, "101 1\n110 1\n011 1\n000 1\n") ||
             !strcmp(node->blifunc, "110 1\n000 1\n011 1\n101 1\n") ||
             !strcmp(node->blifunc, "110 1\n000 1\n101 1\n011 1\n") ||
             !strcmp(node->blifunc, "110 1\n011 1\n000 1\n101 1\n") ||
             !strcmp(node->blifunc, "110 1\n011 1\n101 1\n000 1\n") ||
             !strcmp(node->blifunc, "110 1\n101 1\n000 1\n011 1\n") ||
             !strcmp(node->blifunc, "110 1\n101 1\n011 1\n000 1\n") ||
             !strcmp(node->blifunc, "001 0\n010 0\n100 0\n111 0\n") ||
             !strcmp(node->blifunc, "001 0\n010 0\n111 0\n100 0\n") ||
             !strcmp(node->blifunc, "001 0\n100 0\n010 0\n111 0\n") ||
             !strcmp(node->blifunc, "001 0\n100 0\n111 0\n010 0\n") ||
             !strcmp(node->blifunc, "001 0\n111 0\n010 0\n100 0\n") ||
             !strcmp(node->blifunc, "001 0\n111 0\n100 0\n010 0\n") ||
             !strcmp(node->blifunc, "010 0\n001 0\n100 0\n111 0\n") ||
             !strcmp(node->blifunc, "010 0\n001 0\n111 0\n100 0\n") ||
             !strcmp(node->blifunc, "010 0\n100 0\n001 0\n111 0\n") ||
             !strcmp(node->blifunc, "010 0\n100 0\n111 0\n001 0\n") ||
             !strcmp(node->blifunc, "010 0\n111 0\n001 0\n100 0\n") ||
             !strcmp(node->blifunc, "010 0\n111 0\n100 0\n001 0\n") ||
             !strcmp(node->blifunc, "100 0\n001 0\n010 0\n111 0\n") ||
             !strcmp(node->blifunc, "100 0\n001 0\n111 0\n010 0\n") ||
             !strcmp(node->blifunc, "100 0\n010 0\n001 0\n111 0\n") ||
             !strcmp(node->blifunc, "100 0\n010 0\n111 0\n001 0\n") ||
             !strcmp(node->blifunc, "100 0\n111 0\n001 0\n010 0\n") ||
             !strcmp(node->blifunc, "100 0\n111 0\n010 0\n001 0\n") ||
             !strcmp(node->blifunc, "111 0\n001 0\n010 0\n100 0\n") ||
             !strcmp(node->blifunc, "111 0\n001 0\n100 0\n010 0\n") ||
             !strcmp(node->blifunc, "111 0\n010 0\n001 0\n100 0\n") ||
             !strcmp(node->blifunc, "111 0\n010 0\n100 0\n001 0\n") ||
             !strcmp(node->blifunc, "111 0\n100 0\n001 0\n010 0\n") ||
             !strcmp(node->blifunc, "111 0\n100 0\n010 0\n001 0\n")) {
    node->func = GXNOR;
  }
  return;
}

int blif_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define BLIF_NPROD 30
# define BLIF_LAST 96
int blif_act[]={

    10,    11,    12,    13,    17,    14,    15,    16,    18,     4,
    23,    17,    23,     6,     4,    18,    21,    25,     9,     8,
    19,     7,     5,     2,    51,    47,    20,    46,    22,     1,
     0,     0,    28,    29,    30,     0,    32,     0,    24,     0,
     3,     0,    36,     0,    36,    36,     0,    40,    41,    36,
    43,    26,    27,     0,     0,     0,    31,     0,    44,    45,
     0,     0,    33,    34,    52,    35,    36,    37,    38,    39,
    54,     0,    42,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    48,     0,     0,    49,    50,     0,    53,     0,
     0,     0,     0,    55,     0,    56 };
int blif_pact[]={

  -253, -1000, -1000,  -254, -1000,  -257, -1000,  -250, -1000, -1000,
  -256,  -256,  -256,  -256,  -256,  -256,  -256,  -256,  -256, -1000,
 -1000,  -253,  -253, -1000,  -258, -1000,  -258,  -258,  -253,  -256,
  -256,  -258,  -256,  -254,  -254,  -254, -1000,  -254,  -254,  -254,
  -256,  -256,  -254,  -256,  -253,  -253,  -256,  -253,  -256,  -254,
  -254, -1000,  -258,  -254,  -253,  -254,  -254 };
int blif_pgo[]={

     0,    29,    27,    38,    25,    17,    24,    23,    22,    21,
    20,    40,    19,    18 };
int blif_r1[]={

     0,     1,     7,     7,    11,    11,     8,     8,    12,    12,
    12,    12,    12,    12,    12,     9,     9,    13,    13,     2,
     2,     6,     6,     4,     4,     3,     3,     5,    10,    10 };
int blif_r2[]={

     0,     9,     3,     1,     3,     5,     1,     5,     7,     7,
     7,     7,     7,    11,    11,     3,     5,     9,    11,     1,
     5,     7,     5,     3,     1,     3,     5,     3,     5,     1 };
int blif_chk[]={

 -1000,    -1,    -7,   -11,   267,    -8,   267,    -9,   -12,   -13,
   257,   258,   259,   260,   262,   263,   264,   261,   265,   -10,
   -13,   266,    -5,   268,    -3,    -5,    -3,    -3,    -5,    -5,
    -5,    -3,    -5,   -11,   -11,   -11,    -5,   -11,   -11,   -11,
    -5,    -5,   -11,    -5,    -5,    -5,    -2,    -4,    -3,   -11,
   -11,    -6,    -5,   -11,    -5,   -11,   -11 };
int blif_def[]={

     3,    -2,     6,     2,     4,     0,     5,    29,     7,    15,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     1,
    16,     0,     0,    27,     0,    25,     0,     0,     0,     0,
     0,     0,     0,    28,     8,     9,    26,    10,    11,    12,
     0,     0,    19,    24,     0,     0,    17,     0,    23,    13,
    14,    20,     0,    18,     0,    22,    21 };
typedef struct { char *t_name; int t_val; } blif_toktype;
#ifndef BLIF_DEBUG
#	define BLIF_DEBUG	0	/* don't allow debugging */
#endif

#if BLIF_DEBUG

blif_toktype blif_toks[] =
{
	"BLIF_MODEL",	257,
	"BLIF_INPUTS",	258,
	"BLIF_OUTPUTS",	259,
	"BLIF_CLOCK",	260,
	"BLIF_NAMES",	261,
	"BLIF_WLS",	262,
	"BLIF_IA",	263,
	"BLIF_OR",	264,
	"BLIF_LATCH",	265,
	"BLIF_END",	266,
	"BLIF_CR",	267,
	"BLIF_ID",	268,
	"-unknown-",	-1	/* ends search */
};

char * blif_reds[] =
{
	"-no such reduction-",
	"blif : newlines_opt header_list node_list end_opt",
	"newlines_opt : newlines",
	"newlines_opt : /* empty */",
	"newlines : BLIF_CR",
	"newlines : newlines BLIF_CR",
	"header_list : /* empty */",
	"header_list : header_list header",
	"header : BLIF_MODEL identifier newlines",
	"header : BLIF_INPUTS id_list newlines",
	"header : BLIF_OUTPUTS id_list newlines",
	"header : BLIF_CLOCK id_list newlines",
	"header : BLIF_WLS identifier newlines",
	"header : BLIF_IA identifier identifier identifier newlines",
	"header : BLIF_OR identifier identifier identifier newlines",
	"node_list : node",
	"node_list : node_list node",
	"node : BLIF_NAMES id_list newlines minterm_list",
	"node : BLIF_LATCH identifier identifier id_list_opt newlines",
	"minterm_list : /* empty */",
	"minterm_list : minterm_list minterm",
	"minterm : identifier identifier newlines",
	"minterm : identifier newlines",
	"id_list_opt : id_list",
	"id_list_opt : /* empty */",
	"id_list : identifier",
	"id_list : id_list identifier",
	"identifier : BLIF_ID",
	"end_opt : BLIF_END newlines",
	"end_opt : /* empty */",
};
#endif /* BLIF_DEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define BLIF_ERROR		goto blif_errlab
#define BLIF_ACCEPT	{ free((char *)blif_s); free((char *)blif_v); return(0); }
#define BLIF_ABORT		{ free((char *)blif_s); free((char *)blif_v); return(1); }
#define BLIF_BACKUP( newtoken, newvalue )\
{\
	if ( blif_char >= 0 || ( blif_r2[ blif_tmp ] >> 1 ) != 1 )\
	{\
		blif_error( "syntax error - cannot backup" );\
		goto blif_errlab;\
	}\
	blif_char = newtoken;\
	blif_state = *blif_ps;\
	blif_lval = newvalue;\
	goto blif_newstate;\
}
#define BLIF_RECOVERING()	(!!blif_errflag)
#ifndef BLIF_DEBUG
#	define BLIF_DEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int blif_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define BLIF_FLAG		(-1000)

/*
** static variables used by the parser
*/
static BLIF_STYPE *blif_v;			/* value stack */
static int *blif_s;			/* state stack */

static BLIF_STYPE *blif_pv;			/* top of value stack */
static int *blif_ps;			/* top of state stack */

static int blif_state;			/* current state */
static int blif_tmp;			/* extra var (lasts between blocks) */

int blif_nerrs;			/* number of errors */

int blif_errflag;			/* error recovery flag */
int blif_char;			/* current input token number */


/*
** blif_parse - return 0 if worked, 1 if syntax error not recovered from
*/
int
blif_parse()
{
	BLIF_STYPE *blif_pvt = 0;	/* top of value stack for $vars */
	unsigned blif_maxdepth = BLIF_MAXDEPTH;

	/*
	** Initialize externals - blif_parse may be called more than once
	*/
	blif_v = (BLIF_STYPE*)malloc(blif_maxdepth*sizeof(BLIF_STYPE));
	blif_s = (int*)malloc(blif_maxdepth*sizeof(int));
	if (!blif_v || !blif_s)
	{
		blif_error( "out of memory" );
		return(1);
	}
	blif_pv = &blif_v[-1];
	blif_ps = &blif_s[-1];
	blif_state = 0;
	blif_tmp = 0;
	blif_nerrs = 0;
	blif_errflag = 0;
	blif_char = -1;

	goto blif_stack;
	{
		register BLIF_STYPE *blif__pv;	/* top of value stack */
		register int *blif__ps;		/* top of state stack */
		register int blif__state;		/* current state */
		register int  blif__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if BLIF_BACKUP was called.
		*/
	blif_newstate: if (blif_debug) goto blif_newstate;
		blif__pv = blif_pv;
		blif__ps = blif_ps;
		blif__state = blif_state;
		goto blif__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	blif_stack:
		blif__pv = blif_pv;
		blif__ps = blif_ps;
		blif__state = blif_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	blif__stack:
		/*
		** put a state and value onto the stacks
		*/
#if BLIF_DEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( blif_debug )
		{
			register int blif__i;

			(void)printf( "State %d, token ", blif__state );
			if ( blif_char == 0 )
				(void)printf( "end-of-file\n" );
			else if ( blif_char < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( blif__i = 0; blif_toks[blif__i].t_val >= 0;
					blif__i++ )
				{
					if ( blif_toks[blif__i].t_val == blif_char )
						break;
				}
				(void)printf( "%s\n", blif_toks[blif__i].t_name );
			}
		}
#endif /* BLIF_DEBUG */
		if ( ++blif__ps >= &blif_s[ blif_maxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int blif_ps_index = (blif__ps - blif_s);
			int blif_pv_index = (blif__pv - blif_v);
			int blif_pvt_index = (blif_pvt - blif_v);
			blif_maxdepth += BLIF_MAXDEPTH;
			blif_v = (BLIF_STYPE*)realloc((char*)blif_v,
				blif_maxdepth * sizeof(BLIF_STYPE));
			blif_s = (int*)realloc((char*)blif_s,
				blif_maxdepth * sizeof(int));
			if (!blif_v || !blif_s)
			{
				blif_error( "yacc stack overflow" );
				return(1);
			}
			blif__ps = blif_s + blif_ps_index;
			blif__pv = blif_v + blif_pv_index;
			blif_pvt = blif_v + blif_pvt_index;
		}
		*blif__ps = blif__state;
		*++blif__pv = blif_val;

		/*
		** we have a new state - find out what to do
		*/
	blif__newstate:
		if ( ( blif__n = blif_pact[ blif__state ] ) <= BLIF_FLAG )
			goto blif_default;		/* simple state */
#if BLIF_DEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		blif_tmp = blif_char < 0;
#endif
		if ( ( blif_char < 0 ) && ( ( blif_char = blif_lex() ) < 0 ) )
			blif_char = 0;		/* reached EOF */
#if BLIF_DEBUG
		if ( blif_debug && blif_tmp )
		{
			register int blif__i;

			(void)printf( "Received token " );
			if ( blif_char == 0 )
				(void)printf( "end-of-file\n" );
			else if ( blif_char < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( blif__i = 0; blif_toks[blif__i].t_val >= 0;
					blif__i++ )
				{
					if ( blif_toks[blif__i].t_val == blif_char )
						break;
				}
				(void)printf( "%s\n", blif_toks[blif__i].t_name );
			}
		}
#endif /* BLIF_DEBUG */
		if ( ( ( blif__n += blif_char ) < 0 ) || ( blif__n >= BLIF_LAST ) )
			goto blif_default;
		if ( blif_chk[ blif__n = blif_act[ blif__n ] ] == blif_char )	/*valid shift*/
		{
			blif_char = -1;
			blif_val = blif_lval;
			blif__state = blif__n;
			if ( blif_errflag > 0 )
				blif_errflag--;
			goto blif__stack;
		}

	blif_default:
		if ( ( blif__n = blif_def[ blif__state ] ) == -2 )
		{
#if BLIF_DEBUG
			blif_tmp = blif_char < 0;
#endif
			if ( ( blif_char < 0 ) && ( ( blif_char = blif_lex() ) < 0 ) )
				blif_char = 0;		/* reached EOF */
#if BLIF_DEBUG
			if ( blif_debug && blif_tmp )
			{
				register int blif__i;

				(void)printf( "Received token " );
				if ( blif_char == 0 )
					(void)printf( "end-of-file\n" );
				else if ( blif_char < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( blif__i = 0;
						blif_toks[blif__i].t_val >= 0;
						blif__i++ )
					{
						if ( blif_toks[blif__i].t_val
							== blif_char )
						{
							break;
						}
					}
					(void)printf( "%s\n", blif_toks[blif__i].t_name );
				}
			}
#endif /* BLIF_DEBUG */
			/*
			** look through exception table
			*/
			{
				register int *blif_xi = blif_exca;

				while ( ( *blif_xi != -1 ) ||
					( blif_xi[1] != blif__state ) )
				{
					blif_xi += 2;
				}
				while ( ( *(blif_xi += 2) >= 0 ) &&
					( *blif_xi != blif_char ) )
					;
				if ( ( blif__n = blif_xi[1] ) < 0 )
					BLIF_ACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( blif__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( blif_errflag )
			{
			case 0:		/* new error */
				blif_error( "syntax error" );
				goto skip_init;
			blif_errlab: if (blif_debug) goto blif_errlab;
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				blif__pv = blif_pv;
				blif__ps = blif_ps;
				blif__state = blif_state;
				blif_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				blif_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( blif__ps >= blif_s )
				{
					blif__n = blif_pact[ *blif__ps ] + BLIF_ERRCODE;
					if ( blif__n >= 0 && blif__n < BLIF_LAST &&
						blif_chk[blif_act[blif__n]] == BLIF_ERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						blif__state = blif_act[ blif__n ];
						goto blif__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if BLIF_DEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( blif_debug )
						(void)printf( _POP_, *blif__ps,
							blif__ps[-1] );
#	undef _POP_
#endif
					blif__ps--;
					blif__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				BLIF_ABORT;
			case 3:		/* no shift yet; eat a token */
#if BLIF_DEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( blif_debug )
				{
					register int blif__i;

					(void)printf( "Error recovery discards " );
					if ( blif_char == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( blif_char < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( blif__i = 0;
							blif_toks[blif__i].t_val >= 0;
							blif__i++ )
						{
							if ( blif_toks[blif__i].t_val
								== blif_char )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							blif_toks[blif__i].t_name );
					}
				}
#endif /* BLIF_DEBUG */
				if ( blif_char == 0 )	/* reached EOF. quit */
					BLIF_ABORT;
				blif_char = -1;
				goto blif__newstate;
			}
		}/* end if ( blif__n == 0 ) */
		/*
		** reduction by production blif__n
		** put stack tops, etc. so things right after switch
		*/
#if BLIF_DEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( blif_debug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				blif__n, blif_reds[ blif__n ] );
#endif
		blif_tmp = blif__n;			/* value to switch over */
		blif_pvt = blif__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using blif__state here as temporary
		** register variable, but why not, if it works...
		** If blif_r2[ blif__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto blif__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int blif__len = blif_r2[ blif__n ];

			if ( !( blif__len & 01 ) )
			{
				blif__len >>= 1;
				blif_val = ( blif__pv -= blif__len )[1];	/* $$ = $1 */
				blif__state = blif_pgo[ blif__n = blif_r1[ blif__n ] ] +
					*( blif__ps -= blif__len ) + 1;
				if ( blif__state >= BLIF_LAST ||
					blif_chk[ blif__state =
					blif_act[ blif__state ] ] != -blif__n )
				{
					blif__state = blif_act[ blif_pgo[ blif__n ] ];
				}
				goto blif__stack;
			}
			blif__len >>= 1;
			blif_val = ( blif__pv -= blif__len )[1];	/* $$ = $1 */
			blif__state = blif_pgo[ blif__n = blif_r1[ blif__n ] ] +
				*( blif__ps -= blif__len ) + 1;
			if ( blif__state >= BLIF_LAST ||
				blif_chk[ blif__state = blif_act[ blif__state ] ] != -blif__n )
			{
				blif__state = blif_act[ blif_pgo[ blif__n ] ];
			}
		}
					/* save until reenter driver code */
		blif_state = blif__state;
		blif_ps = blif__ps;
		blif_pv = blif__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( blif_tmp )
	{
		
case 1:
# line 50 "blif.y"
{
      TRACE("blif: newlines_opt header_list node_list end_opt");

      /* finish line number output */
      display_lineno((FILE *)NULL, blif_lineno);

      assert(Nodelist);
      assert(Nodecount == l_len(Nodelist) + 1);

      allocate_nodes(&Nodelist);   /* eats Nodelist */
      assert(!Nodelist);
      fprintf(stdout, "#\n"); fflush(stdout);

      fix_connectivity();
      assert(check_connectivity());
    } break;
case 2:
# line 70 "blif.y"
{
      TRACE("newlines_opt: newlines");
    } break;
case 3:
# line 74 "blif.y"
{
      TRACE("newlines_opt: /* empty */");
    } break;
case 4:
# line 81 "blif.y"
{
      TRACE("newlines: BLIF_CR");
    } break;
case 5:
# line 85 "blif.y"
{
      TRACE("newlines: newlines BLIF_CR");
    } break;
case 6:
# line 92 "blif.y"
{
      TRACE("header_list: /* empty */");
    } break;
case 7:
# line 96 "blif.y"
{
      TRACE("header_list: header_list header");
    } break;
case 8:
# line 103 "blif.y"
{
      TRACE("header: BLIF_MODEL identifier newlines");

      /* assert(Circuit_Modelname);
      if (strcmp(Circuit_Modelname, $2)) {
        sr_free(Circuit_Modelname);
        Circuit_Modelname = sr_strsav($2);
      } */
    } break;
case 9:
# line 113 "blif.y"
{
      LISTPTR l;

      TRACE("header: BLIF_INPUTS id_list newlines");

      for (l = blif_pvt[-1].listptr; l != LISTNULL; l = l->next) {
        NODEPTR node = nodecreate(Nodecount++, (char *)NULL, NONT);
        strcpy(node->name, (char *)l->o);
        if (h_lookup(Hashtable, node->name)) {
          sprintf(blif_errorbuf, "duplicate inputs %s", node->name);
          blif_error(blif_errorbuf);
        }
        h_add(Hashtable, node->name, (char *)node);

        strfree((char *)l->o, __LINE__, __FILE__); l->o = node->address;
        node->func = GPI;
        node->type = PI;
        l_append(Nodelist, (int)node);
      }
      blif_pvt[-1].listptr = l_free(blif_pvt[-1].listptr);
    } break;
case 10:
# line 135 "blif.y"
{
      TRACE("header: BLIF_OUTPUTS id_list newlines");

      Outputs = l_cat(Outputs, blif_pvt[-1].listptr); blif_pvt[-1].listptr = LISTNULL;
    } break;
case 11:
# line 141 "blif.y"
{
      LISTPTR l;

      TRACE("header: BLIF_CLOCK id_list newlines");

      for (l = blif_pvt[-1].listptr; l != LISTNULL; l = l->next)
        l->o = (int)strfree((char *)l->o, __LINE__, __FILE__);
      blif_pvt[-1].listptr = l_free(blif_pvt[-1].listptr);
    } break;
case 12:
# line 151 "blif.y"
{
      TRACE("header: BLIF_WLS identifier newlines");

      blif_numcheck(blif_pvt[-1].charptr);
    } break;
case 13:
# line 157 "blif.y"
{
      TRACE("header: BLIF_IA identifier identifier identifier newlines");

      blif_numcheck(blif_pvt[-2].charptr); blif_numcheck(blif_pvt[-1].charptr);
    } break;
case 14:
# line 163 "blif.y"
{
      TRACE("header: BLIF_OR identifier identifier identifier newlines");

      blif_numcheck(blif_pvt[-2].charptr); blif_numcheck(blif_pvt[-1].charptr);
    } break;
case 15:
# line 172 "blif.y"
{
      TRACE("node_list: node");
    } break;
case 16:
# line 176 "blif.y"
{
      TRACE("node_list: node_list node");
    } break;
case 17:
# line 183 "blif.y"
{
      char *s;
      NODEPTR node = nodecreate(Nodecount++, (char *)NULL, NONT);

      TRACE("node: BLIF_NAMES id_list newlines minterm_list");

      node->in = blif_pvt[-2].listptr;
      node->n_fanin = l_len(blif_pvt[-2].listptr) - 1;
      strcpy(node->name, s = (char *)l_delete(&node->in, l_tail(node->in)));
      s = strfree(s, __LINE__, __FILE__);
      if (h_lookup(Hashtable, node->name)) {
        sprintf(blif_errorbuf, "multiple definition of node %s", node->name);
        blif_error(blif_errorbuf);
      }
      h_add(Hashtable, node->name, (char *)node);

      /* set node->func from node->blifunc */
      node->blifunc = blif_pvt[-0].function;
      blif_setfunc(node);
      if (node->func == NOFUNC) node->func = GCOMPLEX;
      l_append(Nodelist, (int)node);
    } break;
case 18:
# line 206 "blif.y"
{
      LISTPTR l;
      NODEPTR node = nodecreate(Nodecount++, (char *)NULL, NONT);

      TRACE("node: BLIF_LATCH identifier identifier id_list_opt newlines");

      node->in = L_CREATE((int)strcreate(blif_pvt[-3].charptr, __LINE__, __FILE__));
      node->n_fanin = 1;
      strcpy(node->name, blif_pvt[-2].charptr);
      if (h_lookup(Hashtable, node->name)) {
        sprintf(blif_errorbuf, "multiple definition of latch %s", node->name);
        blif_error(blif_errorbuf);
      }
      h_add(Hashtable, node->name, (char *)node);

      node->func = GDFF;
      node->type = PPI;
      l_append(Nodelist, (int)node);

      if (blif_pvt[-1].listptr) {
        char *initial_state = (char *)(l_tail(blif_pvt[-1].listptr)->o);
        assert(initial_state && strlen(initial_state) == 1);
        assert(*(initial_state) == '0' || *(initial_state) == '1' ||
               *(initial_state) == '2' || *(initial_state) == '3');
        node->initstate = atoi(initial_state);

        /* free $4 (list of strings) */
        for (l = blif_pvt[-1].listptr; l != LISTNULL; l = l->next)
          l->o = (int)strfree((char *)l->o, __LINE__, __FILE__);
        blif_pvt[-1].listptr = l_free(blif_pvt[-1].listptr);
      }
    } break;
case 19:
# line 242 "blif.y"
{
      TRACE("minterm_list: /* empty */");

      blif_val.function = (char *)NULL;
    } break;
case 20:
# line 248 "blif.y"
{
      int size = (blif_pvt[-1].function ? strlen(blif_pvt[-1].function) : 0) + strlen(blif_pvt[-0].charptr) + 1;

      TRACE("minterm_list: minterm_list minterm");

#define MAXFUNCSIZE 65536

      if (size > MAXFUNCSIZE) {
        sprintf(blif_errorbuf, "function exceeded max length of %d", MAXFUNCSIZE);
        sr_error(blif_errorbuf);
      }

      blif_val.function = SR_MALLOC(size);
      if (blif_pvt[-1].function) {
        strcpy(blif_val.function, blif_pvt[-1].function);
        blif_pvt[-1].function = sr_free(blif_pvt[-1].function);
      } else {
        blif_val.function[0] = '\0';
      }
      strcat(blif_val.function, blif_pvt[-0].charptr);
    } break;
case 21:
# line 273 "blif.y"
{
      TRACE("minterm: identifier identifier newlines");

      blif_mincheck(blif_pvt[-2].charptr); blif_mincheck(blif_pvt[-1].charptr);
      if (strlen(blif_pvt[-2].charptr) + strlen(blif_pvt[-1].charptr) + 3 > PLEN) {
        sprintf(blif_errorbuf, "minterm exceeded max length of %d", PLEN);
        sr_error(blif_errorbuf);
      }
      strcpy(blif_val.charptr, blif_pvt[-2].charptr);
      strcat(blif_val.charptr, " ");
      strcat(blif_val.charptr, blif_pvt[-1].charptr);
      strcat(blif_val.charptr, "\n");
    } break;
case 22:
# line 287 "blif.y"
{
      TRACE("minterm: identifier  newlines");

      if (strcmp(blif_pvt[-1].charptr, "0") && strcmp(blif_pvt[-1].charptr, "1"))
        blif_error("bad minterm syntax");

      strcpy(blif_val.charptr, blif_pvt[-1].charptr);
      strcat(blif_val.charptr, "\n");
    } break;
case 23:
# line 300 "blif.y"
{
      TRACE("id_list_opt: id_list");

      blif_val.listptr = blif_pvt[-0].listptr;
    } break;
case 24:
# line 306 "blif.y"
{
      TRACE("id_list_opt: /* empty */");

      blif_val.listptr = LISTNULL;
    } break;
case 25:
# line 315 "blif.y"
{
      TRACE("id_list: identifier");

      blif_val.listptr = L_CREATE((int)strcreate(blif_pvt[-0].charptr, __LINE__, __FILE__));
    } break;
case 26:
# line 321 "blif.y"
{
      TRACE("id_list: id_list identifier");

      blif_val.listptr = l_append(blif_pvt[-1].listptr, (int)strcreate(blif_pvt[-0].charptr, __LINE__, __FILE__));
    } break;
case 27:
# line 330 "blif.y"
{
      TRACE("identifier: BLIF_ID");

      strcpy(blif_val.charptr, blif_pvt[-0].charptr);
    } break;
case 28:
# line 339 "blif.y"
{
      TRACE("end_opt: BLIF_END newlines");
    } break;
case 29:
# line 343 "blif.y"
{
      TRACE("end_opt: /* empty */");
    } break;
	}
	goto blif_stack;		/* reset registers in driver code */
}
