%{
/*
 * FILE: blif.l
 */

#define YYCHKPNT 100
%}

W1 [ \t\b\r\f]+
ID [^ #\n\t\b\r\f\\]+

%%
                                /* declare local variables */
                                char buf[BUFSIZ];
                                int c, done;

{W1}                            { /* ignore white space */
                                  strcpy(yyLasttoken, "<newline>"); }

\\\n                            { /* ignore backslash followed by newline */ }

\n+                             { /* carriage returns (newlines) */
                                  if (!Trace) {
                                    static int yypline = 0;
                                    if (yylineno - yypline > YYCHKPNT) {
                                      yypline = yylineno - (yylineno%YYCHKPNT);
                                      display_lineno(yyin, yypline);
                                    }
                                  }
                                  strcpy(yyLasttoken, "<newline>");
                                  TRACE("        returning YYCR");
                                  return(YYCR);;; }

"#"                             { /* ignore comments */
                                  done = 0;
                                  while (!done) {
                                    if ((c = input()) == '\n') {
                                      done = 1;
                                    } else if (c == EOF) {
                                      yyerror("syntax error (EOF in comment)");
                                    }
                                  }
                                  strcpy(yyLasttoken, "<comment>");
                                  TRACE("        parsed comment");
                                }

\.model                         { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYMODEL");
                                  return(YYMODEL);;; }

\.inputs                        { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYINPUTS");
                                  return(YYINPUTS);;; }

\.outputs                       { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYOUTPUTS");
                                  return(YYOUTPUTS);;; }

\.names                         { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYNAMES");
                                  return(YYNAMES);;; }

\.latch                         { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYLATCH");
                                  return(YYLATCH);;; }

\.wire_load_slope               { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYWLS");
                                  return(YYWLS);;; }

\.input_arrival                 { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYIA");
                                  return(YYIA);;; }

\.output_required               { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYOR");
                                  return(YYOR);;; }

\.end                           { strcpy(yyLasttoken, yytext);
                                  TRACE("        returning YYEND");
                                  return(YYEND);;; }

{ID}                            { strcpy(yyLasttoken, strchk(yytext));
                                  strcpy(yylval.charptr, yytext);
                                  if (Trace) sprintf(buf, "        returning YYID (%s)", yytext);
                                  TRACE(buf);
                                  return(YYID);;; }

.                               { assert(yytext[1] == '\0');
                                  strcpy(yyLasttoken, yytext);
                                  if (Trace) sprintf(buf, "        returning '%c'", yytext[0]);
                                  TRACE(buf);
                                  return(yytext[0]);;; }


%%

int yywrap() { return(1); }

