%{
/*
 * FILE: blif.y
 */

#include "pretg.h"

/* variables used only in the yacc (and possibly lex) */
char yyLasttoken[MAXSTRLEN];            /* the last token parsed */
char yyerrorbuf[MAXSTRLEN];             /* to store error messages */

extern void yymincheck(), yynumcheck(), yysetfunc();
%}

/* start rule */
%start blif

/* legal token types and rule types */
%union {
  char charptr[PLEN];           /* to pass identifiers */
  LISTPTR listptr;              /* to pass lists */
  char *function;               /* to pass functions */
}

/* typed terminal symbols (tokens) */
%token YYMODEL          /* ".model" */
%token YYINPUTS         /* ".inputs" */
%token YYOUTPUTS        /* ".outputs" */
%token YYCLOCK          /* ".clock" */
%token YYNAMES          /* ".names" */
%token YYWLS            /* ".wire_load_slope" */
%token YYIA             /* ".input_arrival" */
%token YYOR             /* ".output_required" */
%token YYLATCH          /* ".latch" */
%token YYEND            /* ".end" */
%token YYCR             /* a carriage return (newline) */
%token <charptr> YYID   /* an identifier */

/* typed non-terminal symbols (rules) */
%type <function> minterm_list
%type <listptr> id_list id_list_opt
%type <charptr> identifier minterm

/* precedence table */

%%

blif
  : newlines_opt header_list node_list end_opt
    {
      TRACE("blif: newlines_opt header_list node_list end_opt");

      /* finish line number output */
      display_lineno((FILE *)NULL, yylineno);

      assert(Nodelist);
      assert(Nodecount == l_len(Nodelist) + 1);

      allocate_nodes(&Nodelist);   /* eats Nodelist */
      assert(!Nodelist);
      fprintf(stdout, "#\n"); fflush(stdout);

      fix_connectivity();
      assert(check_connectivity());
    }
  ;

newlines_opt
  : newlines
    {
      TRACE("newlines_opt: newlines");
    }
  | /* empty */
    {
      TRACE("newlines_opt: /* empty */");
    }
  ;

newlines
  : YYCR
    {
      TRACE("newlines: YYCR");
    }
  | newlines YYCR
    {
      TRACE("newlines: newlines YYCR");
    }
  ;

header_list
  : /* empty */
    {
      TRACE("header_list: /* empty */");
    }
  | header_list header
    {
      TRACE("header_list: header_list header");
    }
  ;

header
  : YYMODEL identifier newlines
    {
      TRACE("header: YYMODEL identifier newlines");

      /* assert(Circuit_Modelname);
      if (strcmp(Circuit_Modelname, $2)) {
        sr_free(Circuit_Modelname);
        Circuit_Modelname = sr_strsav($2);
      } */
    }
  | YYINPUTS id_list newlines
    {
      LISTPTR l;

      TRACE("header: YYINPUTS id_list newlines");

      for (l = $2; l != LISTNULL; l = l->next) {
        NODEPTR node = nodecreate(Nodecount++, (char *)NULL, NONT);
        strcpy(node->name, (char *)l->o);
        if (h_lookup(Hashtable, node->name)) {
          sprintf(yyerrorbuf, "duplicate inputs %s", node->name);
          yyerror(yyerrorbuf);
        }
        h_add(Hashtable, node->name, (char *)node);

        strfree((char *)l->o, __LINE__, __FILE__); l->o = node->address;
        node->func = GPI;
        node->type = PI;
        l_append(Nodelist, (int)node);
      }
      $2 = l_free($2);
    }
  | YYOUTPUTS id_list newlines
    {
      TRACE("header: YYOUTPUTS id_list newlines");

      Outputs = l_cat(Outputs, $2); $2 = LISTNULL;
    }
  | YYCLOCK id_list newlines
    {
      LISTPTR l;

      TRACE("header: YYCLOCK id_list newlines");

      for (l = $2; l != LISTNULL; l = l->next)
        l->o = (int)strfree((char *)l->o, __LINE__, __FILE__);
      $2 = l_free($2);
    }
  | YYWLS identifier newlines
    {
      TRACE("header: YYWLS identifier newlines");

      yynumcheck($2);
    }
  | YYIA identifier identifier identifier newlines
    {
      TRACE("header: YYIA identifier identifier identifier newlines");

      yynumcheck($3); yynumcheck($4);
    }
  | YYOR identifier identifier identifier newlines
    {
      TRACE("header: YYOR identifier identifier identifier newlines");

      yynumcheck($3); yynumcheck($4);
    }
  ;

node_list
  : node
    {
      TRACE("node_list: node");
    }
  | node_list node
    {
      TRACE("node_list: node_list node");
    }
  ;

node
  : YYNAMES id_list newlines minterm_list
    {
      char *s;
      NODEPTR node = nodecreate(Nodecount++, (char *)NULL, NONT);

      TRACE("node: YYNAMES id_list newlines minterm_list");

      node->in = $2;
      node->n_fanin = l_len($2) - 1;
      strcpy(node->name, s = (char *)l_delete(&node->in, l_tail(node->in)));
      s = strfree(s, __LINE__, __FILE__);
      if (h_lookup(Hashtable, node->name)) {
        sprintf(yyerrorbuf, "multiple definition of node %s", node->name);
        yyerror(yyerrorbuf);
      }
      h_add(Hashtable, node->name, (char *)node);

      /* set node->func from node->blifunc */
      node->blifunc = $4;
      yysetfunc(node);
      if (node->func == NOFUNC) node->func = GCOMPLEX;
      l_append(Nodelist, (int)node);
    }
  | YYLATCH identifier identifier id_list_opt newlines
    {
      LISTPTR l;
      NODEPTR node = nodecreate(Nodecount++, (char *)NULL, NONT);

      TRACE("node: YYLATCH identifier identifier id_list_opt newlines");

      node->in = L_CREATE((int)strcreate($2, __LINE__, __FILE__));
      node->n_fanin = 1;
      strcpy(node->name, $3);
      if (h_lookup(Hashtable, node->name)) {
        sprintf(yyerrorbuf, "multiple definition of latch %s", node->name);
        yyerror(yyerrorbuf);
      }
      h_add(Hashtable, node->name, (char *)node);

      node->func = GDFF;
      node->type = PPI;
      l_append(Nodelist, (int)node);

      if ($4) {
        char *initial_state = (char *)(l_tail($4)->o);
        assert(initial_state && strlen(initial_state) == 1);
        assert(*(initial_state) == '0' || *(initial_state) == '1' ||
               *(initial_state) == '2' || *(initial_state) == '3');
        node->initstate = atoi(initial_state);

        /* free $4 (list of strings) */
        for (l = $4; l != LISTNULL; l = l->next)
          l->o = (int)strfree((char *)l->o, __LINE__, __FILE__);
        $4 = l_free($4);
      }
    }
  ;

minterm_list
  : /* empty */
    {
      TRACE("minterm_list: /* empty */");

      $$ = (char *)NULL;
    }
  | minterm_list minterm
    {
      int size = ($1 ? strlen($1) : 0) + strlen($2) + 1;

      TRACE("minterm_list: minterm_list minterm");

#define MAXFUNCSIZE 65536

      if (size > MAXFUNCSIZE) {
        sprintf(yyerrorbuf, "function exceeded max length of %d", MAXFUNCSIZE);
        sr_error(yyerrorbuf);
      }

      $$ = SR_MALLOC(size);
      if ($1) {
        strcpy($$, $1);
        $1 = sr_free($1);
      } else {
        $$[0] = '\0';
      }
      strcat($$, $2);
    }
  ;

minterm
  : identifier identifier newlines
    {
      TRACE("minterm: identifier identifier newlines");

      yymincheck($1); yymincheck($2);
      if (strlen($1) + strlen($2) + 3 > PLEN) {
        sprintf(yyerrorbuf, "minterm exceeded max length of %d", PLEN);
        sr_error(yyerrorbuf);
      }
      strcpy($$, $1);
      strcat($$, " ");
      strcat($$, $2);
      strcat($$, "\n");
    }
  | identifier newlines
    {
      TRACE("minterm: identifier  newlines");

      if (strcmp($1, "0") && strcmp($1, "1"))
        yyerror("bad minterm syntax");

      strcpy($$, $1);
      strcat($$, "\n");
    }
  ;

id_list_opt
  : id_list
    {
      TRACE("id_list_opt: id_list");

      $$ = $1;
    }
  | /* empty */
    {
      TRACE("id_list_opt: /* empty */");

      $$ = LISTNULL;
    }
  ;

id_list
  : identifier
    {
      TRACE("id_list: identifier");

      $$ = L_CREATE((int)strcreate($1, __LINE__, __FILE__));
    }
  | id_list identifier
    {
      TRACE("id_list: id_list identifier");

      $$ = l_append($1, (int)strcreate($2, __LINE__, __FILE__));
    }
  ;

identifier
  : YYID
    {
      TRACE("identifier: YYID");

      strcpy($$, $1);
    }
  ;

end_opt
  : YYEND newlines
    {
      TRACE("end_opt: YYEND newlines");
    }
  | /* empty */
    {
      TRACE("end_opt: /* empty */");
    }
  ;

%%

#include "blif.x"

yyerror(s)
char *s;
{
  assert(s && yyLasttoken);

  printf("\n"); fflush(stdout);
  fprintf(stderr, "#\n# ERROR: %s on line %d near token '%s'\n#\n",
          s, yylineno, yyLasttoken);
  exit(SYNTAX__ERROR);
}

void yymincheck(s)
char *s;
{
  assert(s);

  for (; *s; s++)
    if (*s != '-' && *s != '0' && *s != '1')
      yyerror("bad minterm syntax");

  return;
}

void yynumcheck(s)
char *s;
{
  assert(s);

  if (*s != '0' && *s != '1' && *s != '2' && *s != '3' && *s != '4' &&
      *s != '5' && *s != '6' && *s != '7' && *s != '8' && *s != '9' &&
      *s != '.' &&  *s != '-')
    yyerror("bad number syntax 0");

  for (s++; *s; s++)
    if (*s != '0' && *s != '1' && *s != '2' && *s != '3' && *s != '4' &&
        *s != '5' && *s != '6' && *s != '7' && *s != '8' && *s != '9' &&
        *s != '.')
      yyerror("bad number syntax 1");

  return;
}

void yysetfunc(node)
NODEPTR node;
{
  assert(node && node->func == NOFUNC);

  if (!node->blifunc) {
    node->type = VSS;
    node->func = GZERO;
    node->blifunc = sr_strsav("0\n");
    assert(!node->n_fanin && !node->in);
  } else if (!strcmp(node->blifunc, "0\n")) {
    node->type = VSS;
    node->func = GZERO;
    assert(!node->n_fanin && !node->in);
  } else if (!strcmp(node->blifunc, "1\n")) {
    node->type = VDD;
    node->func = GONE;
    assert(!node->n_fanin && !node->in);
  } else if (!strcmp(node->blifunc, "- 0\n")) {
    node->type = VSS;
    node->func = GZERO;
    strfree(node->blifunc, __LINE__, __FILE__);
    node->blifunc = strcreate("0\n", __LINE__, __FILE__);
    node->n_fanin = 0;
    while (node->in)
      strfree((char *)l_delete(&node->in, node->in), __LINE__, __FILE__);
  } else if (!strcmp(node->blifunc, "- 1\n")) {
    node->type = VDD;
    node->func = GONE;
    strfree(node->blifunc, __LINE__, __FILE__);
    node->blifunc = strcreate("1\n", __LINE__, __FILE__);
    node->n_fanin = 0;
    while (node->in)
      strfree((char *)l_delete(&node->in, node->in), __LINE__, __FILE__);
  } else if (!strcmp(node->blifunc, "1 1\n") ||
             !strcmp(node->blifunc, "0 0\n")) {
    node->func = GBUFF;
  } else if (!strcmp(node->blifunc, "0 1\n") ||
             !strcmp(node->blifunc, "1 0\n")) {
    node->func = GNOT;
  } else if (!strcmp(node->blifunc, "10 1\n01 1\n") ||
             !strcmp(node->blifunc, "01 1\n10 1\n") ||
             !strcmp(node->blifunc, "00 0\n11 0\n") ||
             !strcmp(node->blifunc, "11 0\n00 0\n") ||
             !strcmp(node->blifunc, "001 1\n010 1\n100 1\n111 1\n") ||
             !strcmp(node->blifunc, "001 1\n010 1\n111 1\n100 1\n") ||
             !strcmp(node->blifunc, "001 1\n100 1\n010 1\n111 1\n") ||
             !strcmp(node->blifunc, "001 1\n100 1\n111 1\n010 1\n") ||
             !strcmp(node->blifunc, "001 1\n111 1\n010 1\n100 1\n") ||
             !strcmp(node->blifunc, "001 1\n111 1\n100 1\n010 1\n") ||
             !strcmp(node->blifunc, "010 1\n001 1\n100 1\n111 1\n") ||
             !strcmp(node->blifunc, "010 1\n001 1\n111 1\n100 1\n") ||
             !strcmp(node->blifunc, "010 1\n100 1\n001 1\n111 1\n") ||
             !strcmp(node->blifunc, "010 1\n100 1\n111 1\n001 1\n") ||
             !strcmp(node->blifunc, "010 1\n111 1\n001 1\n100 1\n") ||
             !strcmp(node->blifunc, "010 1\n111 1\n100 1\n001 1\n") ||
             !strcmp(node->blifunc, "100 1\n001 1\n010 1\n111 1\n") ||
             !strcmp(node->blifunc, "100 1\n001 1\n111 1\n010 1\n") ||
             !strcmp(node->blifunc, "100 1\n010 1\n001 1\n111 1\n") ||
             !strcmp(node->blifunc, "100 1\n010 1\n111 1\n001 1\n") ||
             !strcmp(node->blifunc, "100 1\n111 1\n001 1\n010 1\n") ||
             !strcmp(node->blifunc, "100 1\n111 1\n010 1\n001 1\n") ||
             !strcmp(node->blifunc, "111 1\n001 1\n010 1\n100 1\n") ||
             !strcmp(node->blifunc, "111 1\n001 1\n100 1\n010 1\n") ||
             !strcmp(node->blifunc, "111 1\n010 1\n001 1\n100 1\n") ||
             !strcmp(node->blifunc, "111 1\n010 1\n100 1\n001 1\n") ||
             !strcmp(node->blifunc, "111 1\n100 1\n001 1\n010 1\n") ||
             !strcmp(node->blifunc, "111 1\n100 1\n010 1\n001 1\n") ||
             !strcmp(node->blifunc, "000 0\n011 0\n101 0\n110 0\n") ||
             !strcmp(node->blifunc, "000 0\n011 0\n110 0\n101 0\n") ||
             !strcmp(node->blifunc, "000 0\n101 0\n011 0\n110 0\n") ||
             !strcmp(node->blifunc, "000 0\n101 0\n110 0\n011 0\n") ||
             !strcmp(node->blifunc, "000 0\n110 0\n011 0\n101 0\n") ||
             !strcmp(node->blifunc, "000 0\n110 0\n101 0\n011 0\n") ||
             !strcmp(node->blifunc, "011 0\n000 0\n101 0\n110 0\n") ||
             !strcmp(node->blifunc, "011 0\n000 0\n110 0\n101 0\n") ||
             !strcmp(node->blifunc, "011 0\n101 0\n000 0\n110 0\n") ||
             !strcmp(node->blifunc, "011 0\n101 0\n110 0\n000 0\n") ||
             !strcmp(node->blifunc, "011 0\n110 0\n000 0\n101 0\n") ||
             !strcmp(node->blifunc, "011 0\n110 0\n101 0\n000 0\n") ||
             !strcmp(node->blifunc, "101 0\n000 0\n011 0\n110 0\n") ||
             !strcmp(node->blifunc, "101 0\n000 0\n110 0\n011 0\n") ||
             !strcmp(node->blifunc, "101 0\n011 0\n000 0\n110 0\n") ||
             !strcmp(node->blifunc, "101 0\n011 0\n110 0\n000 0\n") ||
             !strcmp(node->blifunc, "101 0\n110 0\n000 0\n011 0\n") ||
             !strcmp(node->blifunc, "101 0\n110 0\n011 0\n000 0\n") ||
             !strcmp(node->blifunc, "110 0\n000 0\n011 0\n101 0\n") ||
             !strcmp(node->blifunc, "110 0\n000 0\n101 0\n011 0\n") ||
             !strcmp(node->blifunc, "110 0\n011 0\n000 0\n101 0\n") ||
             !strcmp(node->blifunc, "110 0\n011 0\n101 0\n000 0\n") ||
             !strcmp(node->blifunc, "110 0\n101 0\n000 0\n011 0\n") ||
             !strcmp(node->blifunc, "110 0\n101 0\n011 0\n000 0\n")) {
    node->func = GXOR;
  } else if (!strcmp(node->blifunc, "00 1\n11 1\n") ||
             !strcmp(node->blifunc, "11 1\n00 1\n") ||
             !strcmp(node->blifunc, "10 0\n01 0\n") ||
             !strcmp(node->blifunc, "01 0\n10 0\n") ||
             !strcmp(node->blifunc, "000 1\n011 1\n101 1\n110 1\n") ||
             !strcmp(node->blifunc, "000 1\n011 1\n110 1\n101 1\n") ||
             !strcmp(node->blifunc, "000 1\n101 1\n011 1\n110 1\n") ||
             !strcmp(node->blifunc, "000 1\n101 1\n110 1\n011 1\n") ||
             !strcmp(node->blifunc, "000 1\n110 1\n011 1\n101 1\n") ||
             !strcmp(node->blifunc, "000 1\n110 1\n101 1\n011 1\n") ||
             !strcmp(node->blifunc, "011 1\n000 1\n101 1\n110 1\n") ||
             !strcmp(node->blifunc, "011 1\n000 1\n110 1\n101 1\n") ||
             !strcmp(node->blifunc, "011 1\n101 1\n000 1\n110 1\n") ||
             !strcmp(node->blifunc, "011 1\n101 1\n110 1\n000 1\n") ||
             !strcmp(node->blifunc, "011 1\n110 1\n000 1\n101 1\n") ||
             !strcmp(node->blifunc, "011 1\n110 1\n101 1\n000 1\n") ||
             !strcmp(node->blifunc, "101 1\n000 1\n011 1\n110 1\n") ||
             !strcmp(node->blifunc, "101 1\n000 1\n110 1\n011 1\n") ||
             !strcmp(node->blifunc, "101 1\n011 1\n000 1\n110 1\n") ||
             !strcmp(node->blifunc, "101 1\n011 1\n110 1\n000 1\n") ||
             !strcmp(node->blifunc, "101 1\n110 1\n000 1\n011 1\n") ||
             !strcmp(node->blifunc, "101 1\n110 1\n011 1\n000 1\n") ||
             !strcmp(node->blifunc, "110 1\n000 1\n011 1\n101 1\n") ||
             !strcmp(node->blifunc, "110 1\n000 1\n101 1\n011 1\n") ||
             !strcmp(node->blifunc, "110 1\n011 1\n000 1\n101 1\n") ||
             !strcmp(node->blifunc, "110 1\n011 1\n101 1\n000 1\n") ||
             !strcmp(node->blifunc, "110 1\n101 1\n000 1\n011 1\n") ||
             !strcmp(node->blifunc, "110 1\n101 1\n011 1\n000 1\n") ||
             !strcmp(node->blifunc, "001 0\n010 0\n100 0\n111 0\n") ||
             !strcmp(node->blifunc, "001 0\n010 0\n111 0\n100 0\n") ||
             !strcmp(node->blifunc, "001 0\n100 0\n010 0\n111 0\n") ||
             !strcmp(node->blifunc, "001 0\n100 0\n111 0\n010 0\n") ||
             !strcmp(node->blifunc, "001 0\n111 0\n010 0\n100 0\n") ||
             !strcmp(node->blifunc, "001 0\n111 0\n100 0\n010 0\n") ||
             !strcmp(node->blifunc, "010 0\n001 0\n100 0\n111 0\n") ||
             !strcmp(node->blifunc, "010 0\n001 0\n111 0\n100 0\n") ||
             !strcmp(node->blifunc, "010 0\n100 0\n001 0\n111 0\n") ||
             !strcmp(node->blifunc, "010 0\n100 0\n111 0\n001 0\n") ||
             !strcmp(node->blifunc, "010 0\n111 0\n001 0\n100 0\n") ||
             !strcmp(node->blifunc, "010 0\n111 0\n100 0\n001 0\n") ||
             !strcmp(node->blifunc, "100 0\n001 0\n010 0\n111 0\n") ||
             !strcmp(node->blifunc, "100 0\n001 0\n111 0\n010 0\n") ||
             !strcmp(node->blifunc, "100 0\n010 0\n001 0\n111 0\n") ||
             !strcmp(node->blifunc, "100 0\n010 0\n111 0\n001 0\n") ||
             !strcmp(node->blifunc, "100 0\n111 0\n001 0\n010 0\n") ||
             !strcmp(node->blifunc, "100 0\n111 0\n010 0\n001 0\n") ||
             !strcmp(node->blifunc, "111 0\n001 0\n010 0\n100 0\n") ||
             !strcmp(node->blifunc, "111 0\n001 0\n100 0\n010 0\n") ||
             !strcmp(node->blifunc, "111 0\n010 0\n001 0\n100 0\n") ||
             !strcmp(node->blifunc, "111 0\n010 0\n100 0\n001 0\n") ||
             !strcmp(node->blifunc, "111 0\n100 0\n001 0\n010 0\n") ||
             !strcmp(node->blifunc, "111 0\n100 0\n010 0\n001 0\n")) {
    node->func = GXNOR;
  }
  return;
}

