/*
 *  File graph.c
*/

#include "pretg.h"

void create_N2V_V2N()
{
  int i, j = 0;
  
  assert(Nodetable);
  assert(Nodecount);
  assert(!Nvertices);
  assert(POaddr);

  Node2vertex = (int *)SR_MALLOC(Nodecount*sizeof(int));
  Vertex2node = (int *)SR_MALLOC(Nodecount*sizeof(int));

  for (i = 0; i < Nodecount; i++) {
    Node2vertex[i] = -1; Vertex2node[i] = -1;
  }

  /* first set the non-FF nodes */
  for (i = 1; i < Nodecount; i++) {
    assert(Nodetable[i]);
    if (Nodetable[i]->type != PPI && i != POaddr) {
      Node2vertex[i] = j; 
      Vertex2node[j++] = i;
    }
  }

  /* set Nvertices */
  Nvertices = j;

  /* set rest of the nodes */
  for (i = 0; i < Nodecount; i++) 
    if (Node2vertex[i] == -1) {
      Node2vertex[i] = j; Vertex2node[j++] = i;
    }
  return;
}

void pretg_main()
{
  char buf[MAXSTRLEN];
  WT_GRAPHPTR wt_graph = WTNULL;

  create_N2V_V2N();
  assert(!wt_graph);

  printf("# Making wt_graph..\n"); fflush(stdout);
  wt_graph = make_wt_graph(Nvertices);

  printf("# Retiming transformation..\n"); fflush(stdout);
  (void) minimize_latency(wt_graph, Nvertices);
    
  sprintf(buf, "%s_ret.blif", Circuit_Basename);
  printf("# Printing blif..\n"); fflush(stdout);
  print_wt_graph_blif(wt_graph, Nvertices, &buf[0]);

  /* free wt_graph, arrays etc */
  wt_graph = free_wt_graph(wt_graph,Nvertices);

  return;
}
