/*
 * FILE: pretg.e
 */

/* definitions of all global variables declared in pretg.h */
char *Program = (char *)NULL;           /* contains the name of the program */
LISTPTR Nodelist = LISTNULL;            /* contains nodes while parsing */
LISTPTR Newreglist = LISTNULL;          /* contains new registers created */
int *Lineno = (int *)NULL;              /* pointer to current lineno var */
H_TABLEPTR Hashtable = H_TABLENULL;     /* hash table of nodes */
char *Circuit_Filename = (char *)NULL;  /* file name of circuit */
char *Circuit_Basename = (char *)NULL;  /* base name of circuit */
char *Circuit_Modelname = (char *)NULL; /* model name of circuit */
FILE *ISfile = (FILE *)NULL;            /* initial state circuit file */
int IScount = 0;                        /* initial state circuit count */
LISTPTR ISinputs = LISTNULL;            /* inputs to initial state circuit */
LISTPTR ISoutputs = LISTNULL;           /* outputs of initial state circuit */

/* Working copy of the circuit */
int Nodecount = 1;                      /* size of Nodetable array */
NODEPTR *Nodetable = (NODEPTR *)NULL;   /* stores nodes of the circuit */
int PIcount = 0;                        /* number of primary inputs */
int POcount = 0;                        /* number of primary outputs */
int POaddr = 0;                         /* "PRIMARY_OUTPUT" node address */
NODEPTR POnode = NODENULL;              /* "PRIMARY_OUTPUT" node pointer */
int CONcount = 0;                       /* number of constants */
LISTPTR Inputs = LISTNULL;              /* list of input node indices */
LISTPTR Outputs = LISTNULL;             /* list of output node indices */
LISTPTR Constants = LISTNULL;           /* list of constant node indices */

/* Graphs */
int *Node2vertex = (int *)NULL;         /* conversion array (0..Nodecount-1) */
int *Vertex2node = (int *)NULL;         /* conversion array */
int Nvertices = 0;                      /* sizeof(Vertex2node) */

/* Command line option flags */

int Debug = 0;                          /* prints debug information if nonzero */
LANGUAGE InputLang = NOLANG;            /* type of input file */
LANGUAGE OutputLang = BLIF;             /* type of output file */
BOOLEAN Use_Rvalues = F;                /* use rvalues to retime circuit */
BOOLEAN Trace = F;                      /* prints trace information if T */
BOOLEAN Verbose = F;                    /* prints verbose information if T */





