/*
 * FILE: pretg.h
 */

#include "sr.h"
#include "listsr.h"
#include "hashsr.h"
#include "stackasr.h"
#include "queuesr.h"
#include "graphsr.h"
#include <math.h>

/* struct typedefs */
typedef struct node NODE;
typedef struct node *NODEPTR;
typedef LISTPTR WT_GRAPH;
typedef LISTPTR *WT_GRAPHPTR;
typedef struct edge EDGE;
typedef struct edge *EDGEPTR;

/* constant values corresponding to struct typedefs */
#define NODENULL (NODEPTR)NULL
#define WTNULL (WT_GRAPHPTR)NULL
#define EDGENULL (EDGEPTR)NULL

/* define maxima */
#define HASHSIZE        2039
#define MAXSTRLEN       BUFSIZ
#define PLEN            128

/* exit values defined in sr package */

/* define macros */
#define TRACE(msg) { if (Trace) fprintf(stdout, "%5d: %s\n", *Lineno, msg);}
#define ispo(n) l_find(n ? n->out : LISTNULL, POaddr)
#define PL(x) ((x) != 1 ? "s" : "")
#define N2V(i) ((int)Node2vertex[(i)])
#define V2N(i) ((int)Vertex2node[(i)])

/* enumeration typedefs */
typedef enum function { /* an enumeration of functions */
  NOFUNC = 0,           /* unknown function */
  GPI = 1,              /* primary input node */
  GPO = 2,              /* primary output node */
  GAND = 3,             /* and */
  GNAND = 4,            /* nand */
  GOR = 5,              /* or */
  GNOR = 6,             /* nor */
  GXOR = 7,             /* exclusive or */
  GXNOR = 8,            /* exclusive nor */
  GBUFF = 9,            /* non-inverting buffer */
  GNOT = 10,            /* inverter */
  GDFF = 11,            /* D flip-flop */
  GIOBF = 12,           /* inout buffer */
  GST3 = 13,            /* tristate buffer */
  GZERO = 14,           /* logic zero */
  GONE = 15,            /* logic one */
  GCOMPLEX = 16         /* complex gate (blif) */
} FUNCTION;

typedef enum nodetype { /* an enumeration of node types */
  NONT = 0,             /* unknown node type */
  PI = 1,               /* primary input */
  PPI = 2,              /* pseudo primary input (register) */
  VSS = 3,              /* logic zero */
  VDD = 4               /* logic one */
} NODETYPE;

typedef enum lang {     /* an enumeration of languages */
  NOLANG = 0,           /* unknown language */
  BENCH = 1,            /* benchmark language (<ckt>.bench) */
  BLIF = 2,             /* blif language (<ckt>.blif) */
  VERILOG = 3,          /* verilog language (<ckt>.v) */
  PWC = 4               /* pwc language (<ckt>.pwc) */
} LANGUAGE;

typedef enum direction {/* an enumeration of directions */
  NODIR = 0,            /* unknown direction */
  FORWARD = 1,          /* forward or toward outputs */
  BACKWARD = 2,         /* backward or toward inputs */
} DIRECTION;

/* structures */
struct node {           /* stores node information */
  int address;          /* address of this node */
  char name[PLEN];      /* name of this node */
  FUNCTION func;        /* function of this node (and, nand, etc.) */
  char *blifunc;        /* function of this node in blif string form */
  char *sisnode;        /* sis node corresponding to this node */
  NODETYPE type;        /* type of this node (PI, PPI, VDD, VSS, or NONT) */
  int n_fanout;         /* number of fanout nodes */
  int n_fanin;          /* number of fanin nodes */
  LISTPTR out;          /* a list of pointers to fanout nodes */
  LISTPTR in;           /* a list of pointers to fanin nodes */
  int inout;            /* inout signal: > 0 only when func == IOBF */
  int initstate;        /* the initial state of this register (GDFF) */
};

struct edge {           /* stores an edge */
  int wt;               /* weight of an edge */
  int vertex;           /* sink vertex of this edge */
};

/* declarations of all global variables defined in retg.e */
extern char *Program;                   /* contains the name of the program */
extern LISTPTR Nodelist;                /* contains nodes while parsing */
extern LISTPTR Newreglist;              /* contains new registers created
                                         * during gluing process after CPLEX*/
extern int *Lineno;                     /* pointer to current lineno var */
extern H_TABLEPTR Hashtable;            /* hash table of nodes */
extern char *Circuit_Filename;          /* file name of circuit */
extern char *Circuit_Basename;          /* base name of circuit */
extern char *Circuit_Modelname;         /* model name of circuit */
extern FILE *ISfile;                    /* initial state circuit file */
extern int IScount;                     /* initial state circuit count */
extern LISTPTR ISinputs;                /* inputs to initial state circuit */
extern LISTPTR ISoutputs;               /* outputs of initial state circuit */

/* Working copy of the circuit */
extern int Nodecount;                   /* size of Nodetable array */
extern NODEPTR *Nodetable;              /* stores nodes of the circuit */
extern int PIcount;                     /* number of primary inputs */
extern int POcount;                     /* number of primary outputs */
extern int POaddr;                      /* "PRIMARY_OUTPUT" node address */
extern NODEPTR POnode;                  /* "PRIMARY_OUTPUT" node pointer */
extern int CONcount;                    /* number of constants */
extern LISTPTR Inputs;                  /* list of input node indices */
extern LISTPTR Outputs;                 /* list of output node indices */
extern LISTPTR Constants;               /* list of constant node indices */

/* Graphs */
extern int *Node2vertex;                /* conversion array (0...Nodecount-1) */
extern int *Vertex2node;                /* conversion array */
extern int Nvertices;                   /* sizeof(Vertex2node) */
extern int NFFvertices;                 /* sizeof(Vertex2node) with PPIs */


/* Command line option flags */
extern int Debug;                       /* prints debug information if nonzero */
extern LANGUAGE InputLang;              /* type of input file */
extern LANGUAGE OutputLang;             /* type of output file */
extern BOOLEAN Use_Rvalues;             /* use rvalues to retime circuit */
extern BOOLEAN Trace;                   /* prints trace information if T */
extern BOOLEAN Verbose;                 /* prints verbose information if T */

/* chak.c */
extern void minimize_latency();

/* graph.c */
extern void pretg_main();

/* graph-util.c */
extern EDGEPTR edgecreate();
extern EDGEPTR edgefree();
extern void edge_end();
extern WT_GRAPHPTR create_wt_graph();
extern WT_GRAPHPTR free_wt_graph();
extern WT_GRAPHPTR make_wt_graph();
extern WT_GRAPHPTR reverse_wt_graph();
extern int *dfs_wt_graph();
extern void print_wt_graph();

/* main.c */
extern int main();

/* print.c */
extern void print_wt_graph_blif();
extern void print_circuit();
extern int print_bench_gate();
extern int print_blif_gate();
extern int print_verilog_gate();
extern int print_pwc_gate();
extern int printstr();
extern char *blifunc();

/* util.c */
extern void add_buffers_at_a_fanout();
extern char *strcreate();
extern char *strchk();
extern char *strfree();
extern void str_end();
extern NODEPTR nodecreate();
extern NODEPTR nodefree();
extern NODEPTR nodecopy();
extern void node_end();
extern void catch_core_dump_signals();
extern char *rmext();
extern char *basename();
extern void allocate_nodes();
extern void fix_connectivity();
extern BOOLEAN check_connectivity();
extern NODEPTR get_node();
extern void attach();
extern void attach_pos();
extern void detach();
extern BOOLEAN attached();
extern void expand_nodetable();
extern void shrink_nodetable();
extern void fix_nodelist();
extern NODEPTR mkbuff();
extern void move_fanouts();
extern void insert_as_PO();
extern int remove_buffers();
extern void fix_registers();
extern void display_lineno();
extern double get_time();
extern void free_all();
extern int isppo();
extern void swap_names();
extern void give_names_to_registers();
extern void name_register();
extern char *func2str();
extern int printl();
extern int printl_names();
extern void add_buffers_to_entire_circuit();
extern void insert_as_PO();
