/********************************************************************/
/*              FILE: scm.h                                         */
/********************************************************************/
#ifndef ANAND_SCM_H

#define ANAND_SCM_H

#ifdef _SCALP_
#include "assuranc.h"
#endif
#include "basic.h"
#include "matrix.h"
#include "dfg.h"
#include "library_patch.h"

/*Number of vectors used if no vector file is specified*/
#define MAX_RANDOM_VECTORS 200
/********************************************************************/
#ifdef _SCALP_
class Scm : public Assurance {
#else
class Scm {
#endif
 private:
  Array< Matrix<float> * > intra_sc;             //intra-iteration sw. caps for fus
  Array< Matrix<float> * > inter_sc;             //inter-iteration sw. caps for fus
  Matrix<float> reg_intra_sc;                    //intra-iteration sc for regs
  Matrix<float> reg_inter_sc;                    //inter-iteration sc for regs
  List_ar<unsigned int> cur_vector;              //current vector
  int vector_number;                              //current vector number

  //functions called by other member functions only
  int vec_parse();
  Boolean get_vector(const Boolean, const int);

 public:
  Scm() : intra_sc(0), inter_sc(0), cur_vector(), reg_intra_sc(0), reg_inter_sc(0) {
#ifdef _SCALP_
    set_class("Scm");
#endif
    return;
  }

  ~Scm() {
    register int i;
    register int numscms;
    assert(intra_sc.get_size() == inter_sc.get_size());
    numscms = intra_sc.get_size();
    for(i = 0; i < numscms; i++) {
      delete intra_sc[i];
      delete inter_sc[i];
    }
    cur_vector.clear();
    return;
  }

  //functions to access the scm entries
  inline const float get_fu_intra_entry(int type, int row, int column) {
#ifdef _SCALP_
    set_message("get_fu_intra_entry");
#endif
    return((*(intra_sc[type]))[row][column]);
  }
  inline const float get_fu_inter_entry(int type, int row, int column) {
#ifdef _SCALP_
    set_message("get_fu_inter_entry");
#endif
    return((*(inter_sc[type]))[row][column]);
  }

  inline const float get_reg_intra_entry(int row, int column) {
#ifdef _SCALP_
    set_message("get_reg_intra_entry");
#endif
    return(reg_intra_sc[row][column]);
  }

  inline const float get_reg_inter_entry(int row, int column) {
#ifdef _SCALP_
    set_message("get_reg_inter_entry");
#endif
    return(reg_inter_sc[row][column]);
  }

  //Total switched capacitance for a given module type,
  //and an ordered list of operations
  const float get_total_sc(const int, const List_ar<NODEPTR> &);
  //Total switched capacitance in a register for
  //an ordered list of variables
  const float get_total_sc(const List_ar<EDGEPTR> &);

  //perform simulation of the dfg, to extract the scmatrices
  void extract_scmatrices(Dfg &, library *, char *);

  //display the SC matrices
  void display(ofstream &, library *);
};
/********************************************************************/
#endif
