#!/usr/bin/perl

##############################################################################
#                                                                            #
#   AUTHOR:      Cameron Brien                                               #
#   FILE:        create_metrics.pl                                           #
#   DESCRIPTION: runs Chaff and Berkmin algorithms on CNF files              #
#   DATE:        16 December 2005                                            #
#                                                                            #
##############################################################################

# Check for correct number of arguments
if ($#ARGV != 1)
{	die("Incorrect number of arguments");
}

# Open directory handle and get result directory
opendir(DIR, $ARGV[0]) || die "Cannot opendir $ARGV[0]: $!";
$inDir = $ARGV[0];
$outDir = $ARGV[1];
chop($inDir);
chop($outDir);

# Run Chaff and Berkmin on each file in the directory
foreach $fileName (sort readdir(DIR)) {
    if (!($fileName eq ".") && !($fileName eq "..")) {
        print "Running Berkmin on: $fileName\n";
        `./zchaff.berkmin $inDir/$fileName`;
        `mv metrics.berkmin.dump $outDir/metrics.$fileName.berkmin.dump`;
    
        print "Running Chaff on: $fileName\n\n";
        `./zchaff.chaff $inDir/$fileName`;
        `mv metrics.chaff.dump $outDir/metrics.$fileName.chaff.dump`;
    }
}

print "Simulations complete!\n\n";
closedir(DIR);

