// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: fdivs_ieee_zero1.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/***********************************************************************
* Name:   fdivs_ieee_zero1.s
* Date:   11/6/02
*
*
**********************************************************************/

#define ENABLE_T0_Fp_disabled_0x20
#include "boot.s"

.global sam_fast_immu_miss
.global sam_fast_dmmu_miss

.text
.global main

! Testing fdivs with rounding mode zero



main:

	! Common code

	wr		%g0, 0x4, %fprs		! make sure fef is 1 
	setx		source1, %l0, %l1
	setx		source2, %l0, %l2
	setx		result, %l0, %l3
	setx		fcc_result, %l0, %l4
	setx		cexc_flag, %l0, %l5
	setx		fsr_rounding_mode, %l0, %l6
	setx		scratch, %l0, %l7


	set		480, %g1		! Set loop count
	set		0x0, %g2		! Set loop iterator


fdivs_loop:
	ldx		[%l6+0x0], %fsr


	! instruction specific code

	sll		%g2, 0x2, %g3

	ldx		[%l6], %fsr		! Load fsr with rounding mode
	ld		[%l1+%g3], %f0		! Load source 1
	ld		[%l2+%g3], %f2		! Load source 2
	fdivs		%f0, %f2, %f4		! Perform the operation
	st		%f4, [%l7+0x0]		! Store the result for comparison
	stx		%fsr, [%l7+0x8]		! Store the fsr for comparison
	ld		[%l7+0x0], %g4		! Load result from memory for comparison

        ldx     [%l7+0x8], %g5   ! Load fsr from memory for comparison
        sll     %g2, 0x3, %g3
        ldx     [%l5+%g3], %g6   ! Load fsr with expected cexc mode
        mov     0x0f, %g3              ! Mask for nv
        and     %g3, %g6, %g7          ! Mask off nv
        srl     %g7, 0x3, %g7          ! Shift to get of
        or      %g7, %g6, %g6          ! Generate correct nx with of
        mov     0x01, %g3              ! Mask to get nx
        and     %g3, %g6, %g7          ! Mask off all but nx
        sll     %g7, 0x2, %g7          ! Shift to align nx and uf
        or      %g7, 0x1b, %g7         ! Mask for all cexc bits
        and     %g7, %g6, %g6          ! Generate correct uf for denorm
	      sll     %g6, 0x5, %g7          ! Generate aexc
	      or      %g6, %g7, %g7          ! Generate expected fsr
	      ldx     [%l6], %g6        ! Load fsr with rounding mode
	      or      %g6, %g7, %g7          ! Generate expected fsr

	sll		%g2, 0x2, %g3
	ld		[%l3+%g3], %g6		! Load expected result

	subcc		%g4, %g6, %g0		! Compare
	bne,a		test_fail		! If not equal, test failed
	nop
	subcc		%g5, %g7, %g0		! Compare
	bne,a		test_fail		! If not equal, test failed
	nop


	add		%g2, 0x1, %g2		! Increment loop iterator
	subcc		%g2, %g1, %g0		! Compare
	bne,a		fdivs_loop		! Loop
	nop


/*******************************************************
 * Exit code
 *******************************************************/

test_pass:
	ta		T_GOOD_TRAP

test_fail:
	ta		T_BAD_TRAP




/*******************************************************
* Data section
*******************************************************/
.data


fsr_rounding_mode:
	.xword		0x0000000040000000


source1:
	.word		0x47000000
	.word		0xc7000000
	.word		0x47000000
	.word		0xc7000000
	.word		0x7b800000
	.word		0xfb800000
	.word		0xfb800000
	.word		0x7b800000
	.word		0x5f000000
	.word		0xdf000000
	.word		0xdf000000
	.word		0x5f000000
	.word		0x57000000
	.word		0xd7000000
	.word		0xd7000000
	.word		0x57000000
	.word		0x42200000
	.word		0xc2200000
	.word		0xc2200000
	.word		0x42200000
	.word		0x46fff000
	.word		0x461c4000
	.word		0x461c4000
	.word		0x461c4000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40000000
	.word		0x007fffff
	.word		0x007fffff
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x7f000000
	.word		0x7f000000
	.word		0xfeffffff
	.word		0x7efffffd
	.word		0x7f7fffff
	.word		0x41000000
	.word		0xc1000000
	.word		0xc1000000
	.word		0x41000000
	.word		0x01000000
	.word		0x01000003
	.word		0x01000001
	.word		0x00fffffe
	.word		0x00400000
	.word		0x80400000
	.word		0x80400000
	.word		0x00400000
	.word		0x00000002
	.word		0x80000002
	.word		0x80000002
	.word		0x00000002
	.word		0x7f7fffff
	.word		0xff000001
	.word		0x7f000003
	.word		0x01000000
	.word		0x81000001
	.word		0x01000001
	.word		0x01000003
	.word		0x81000005
	.word		0x00400000
	.word		0x80400000
	.word		0x80400000
	.word		0x00400000
	.word		0x00000002
	.word		0x80000002
	.word		0x00000002
	.word		0x80000002
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40400000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40400000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40400000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40400000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x41100000
	.word		0xc1100000
	.word		0xc1100000
	.word		0x41100000
	.word		0x40c00000
	.word		0xc0c00000
	.word		0x40c00000
	.word		0xc0c00000
	.word		0x7f7ffffd
	.word		0x7f7ffffd
	.word		0xff7ffffd
	.word		0xff7ffffd
	.word		0x00400000
	.word		0x80400000
	.word		0x80400000
	.word		0x00400000
	.word		0x00000004
	.word		0x80000004
	.word		0x80000004
	.word		0x00000004
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0x00400000
	.word		0x80400000
	.word		0x80400000
	.word		0x00400000
	.word		0x00000004
	.word		0x80000004
	.word		0x00000004
	.word		0x80000004
	.word		0x40a00000
	.word		0xc0a00000
	.word		0x40a00000
	.word		0xc0a00000
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40400000
	.word		0x40e00000
	.word		0xc0e00000
	.word		0x40e00000
	.word		0xc0e00000
	.word		0x00000001
	.word		0x80000001
	.word		0x00000001
	.word		0x80000001
	.word		0x00000009
	.word		0x00000009
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000001
	.word		0x80000003
	.word		0x00000002
	.word		0x80000004
	.word		0x007fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x3f800000
	.word		0xc0000000
	.word		0x40400000
	.word		0xc0800000
	.word		0x40a00000
	.word		0xc0c00000
	.word		0x40e00000
	.word		0xc1000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x7f000000
	.word		0xfe800000
	.word		0x7f000000
	.word		0xfe800000
	.word		0x7effffff
	.word		0xfe7fffff
	.word		0x7e7fffff
	.word		0xfeffffff
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x00800000
	.word		0x81000000
	.word		0x01000000
	.word		0x80800000
	.word		0x00ffffff
	.word		0x80800001
	.word		0x00800001
	.word		0x80ffffff
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x00000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x00000000
	.word		0x80000000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x00000001
	.word		0x80000003
	.word		0x00000002
	.word		0x80000004
	.word		0x007fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x3f800000
	.word		0xc0000000
	.word		0x40400000
	.word		0xc0800000
	.word		0x40a00000
	.word		0xc0c00000
	.word		0x40e00000
	.word		0xc1000000
	.word		0x7f000000
	.word		0xfe800000
	.word		0x7f000000
	.word		0xfe800000
	.word		0x7effffff
	.word		0xfe7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x00800000
	.word		0x81000000
	.word		0x01000000
	.word		0x80800000
	.word		0x00ffffff
	.word		0x80800001
	.word		0x00800001
	.word		0x80ffffff
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7fc00000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x00000001
	.word		0x80000001
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0x7f000000
	.word		0xff000000
	.word		0x7f000000
	.word		0xff000000
	.word		0x7b000000
	.word		0x7f7fffff
	.word		0x7f000000
	.word		0x7f7fffff
	.word		0x00800000
	.word		0x80800000
	.word		0x00800000
	.word		0x80800000
	.word		0x00000001
	.word		0x80000001
	.word		0x00000001
	.word		0x80000001
	.word		0x00000001
	.word		0x80000001
	.word		0x00000001
	.word		0x80000001
	.word		0x00ffffff
	.word		0x80ffffff
	.word		0x80ffffff
	.word		0x00ffffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x00c00000
	.word		0x80c00000
	.word		0x80c00000
	.word		0x00c00000
	.word		0x00000003
	.word		0x80000003
	.word		0x80000003
	.word		0x00000003
	.word		0x00a00000
	.word		0x80a00000
	.word		0x80a00000
	.word		0x00a00000
	.word		0x00000005
	.word		0x80000005
	.word		0x80000005
	.word		0x00000005
	.word		0x00800000
	.word		0x80800000
	.word		0x80800000
	.word		0x00800000
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x01400000
	.word		0x81400000
	.word		0x81400000
	.word		0x01400000
	.word		0x00000003
	.word		0x80000003
	.word		0x80000003
	.word		0x00000003
	.word		0x00fffffd
	.word		0x80fffffd
	.word		0x80fffffd
	.word		0x00fffffd
	.word		0x00f00003
	.word		0x00f00003
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x00800000
	.word		0x80800000
	.word		0x80800000
	.word		0x00800000
	.word		0x00800001
	.word		0x00800002
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x00bfffff
	.word		0x80bfffff
	.word		0x3f7fffff
	.word		0xbf7fffff
	.word		0x00ffffff
	.word		0x80ffffff
	.word		0x80ffffff
	.word		0x00ffffff
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0x3f800001
	.word		0x3f800001
	.word		0x3f800002
	.word		0x3f800004
	.word		0x3f800006
	.word		0x3f7fffff
	.word		0x3f7ffffe
	.word		0x3f7fffff
	.word		0x3f7ffffd
	.word		0x3f7ffffb
	.word		0x3f800001
	.word		0x3f800002
	.word		0x3f800003
	.word		0x3f800002
	.word		0x3f800004
	.word		0x3f7fffff
	.word		0x3f7ffffe
	.word		0x3f7fffff
	.word		0x3f7ffffd
	.word		0x3f7fffff
	.word		0x3f7ffffe
	.word		0x3f7ffffc
	.word		0x3f7fffff
	.word		0x3f7ffffd
	.word		0x3f7ffffe
	.word		0xbf7ffffc
	.word		0xbf7ffffc
	.word		0x3f7ffffc
	.word		0x3fbfffff
	.word		0xbfbfffff
	.word		0xbfbfffff
	.word		0x3fbfffff
	.word		0x00400000
	.word		0x80400000
	.word		0x80400000
	.word		0x00400000
	.word		0x40400002
	.word		0xc0400002
	.word		0x40400002
.align 8


source2:
	.word		0x42000000
	.word		0xc2000000
	.word		0xc2000000
	.word		0x42000000
	.word		0x49800000
	.word		0xc9800000
	.word		0x49800000
	.word		0xc9800000
	.word		0x4b000000
	.word		0xcb000000
	.word		0x4b000000
	.word		0xcb000000
	.word		0x46000000
	.word		0xc6000000
	.word		0x46000000
	.word		0xc6000000
	.word		0x41200000
	.word		0xc1200000
	.word		0x41200000
	.word		0xc1200000
	.word		0x41200000
	.word		0x41200000
	.word		0x42c80000
	.word		0x447a0000
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x7effffff
	.word		0x7e800001
	.word		0xfe800003
	.word		0x00800000
	.word		0x00800001
	.word		0x00800001
	.word		0x80800003
	.word		0x00800005
	.word		0x00200000
	.word		0x80200000
	.word		0x00200000
	.word		0x80200000
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x3f000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x40c00000
	.word		0xc0c00000
	.word		0x40c00000
	.word		0xc0c00000
	.word		0x00fffffe
	.word		0x80fffffe
	.word		0x00fffffe
	.word		0x80fffffe
	.word		0x00000002
	.word		0x00000002
	.word		0x80000002
	.word		0x80000002
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3e000000
	.word		0xbe000000
	.word		0x3e000000
	.word		0xbe000000
	.word		0x44c00000
	.word		0x44c00000
	.word		0xc4c00000
	.word		0xc4c00000
	.word		0x04fffffe
	.word		0x04fffffe
	.word		0x84fffffe
	.word		0x84fffffe
	.word		0x00000008
	.word		0x00000008
	.word		0x80000008
	.word		0x80000008
	.word		0x40400000
	.word		0xc0400000
	.word		0x40400000
	.word		0xc0400000
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40400000
	.word		0x40800000
	.word		0xc0800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x7e7fffff
	.word		0x7e7fffff
	.word		0xfe7fffff
	.word		0xfe7fffff
	.word		0x00100000
	.word		0x80100000
	.word		0x00100000
	.word		0x80100000
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x40a00000
	.word		0xc0a00000
	.word		0xc0a00000
	.word		0x40a00000
	.word		0x40400000
	.word		0xc0400000
	.word		0x40400000
	.word		0xc0400000
	.word		0x40e00000
	.word		0xc0e00000
	.word		0xc0e00000
	.word		0x40e00000
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x41100000
	.word		0xc1100000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000001
	.word		0x00000003
	.word		0x80000002
	.word		0x80000004
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x3f800000
	.word		0x40000000
	.word		0xc0400000
	.word		0xc0800000
	.word		0x40a00000
	.word		0x40c00000
	.word		0xc0e00000
	.word		0xc1000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x7f000000
	.word		0x7e800000
	.word		0xff000000
	.word		0xfe800000
	.word		0x7effffff
	.word		0x7e7fffff
	.word		0xfe7fffff
	.word		0xfeffffff
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00800000
	.word		0x01000000
	.word		0x81000000
	.word		0x80800000
	.word		0x00ffffff
	.word		0x00800001
	.word		0x80800001
	.word		0x80ffffff
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x00000000
	.word		0x80000000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x00000001
	.word		0x00000003
	.word		0x80000002
	.word		0x80000004
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x3f800000
	.word		0x40000000
	.word		0xc0400000
	.word		0xc0800000
	.word		0x40a00000
	.word		0x40c00000
	.word		0xc0e00000
	.word		0xc1000000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f000000
	.word		0x7e800000
	.word		0xff000000
	.word		0xfe800000
	.word		0x7effffff
	.word		0xfe7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x00800000
	.word		0x01000000
	.word		0x81000000
	.word		0x80800000
	.word		0x00ffffff
	.word		0x00800001
	.word		0x80800001
	.word		0x80ffffff
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0xff800000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x00000001
	.word		0x80000001
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x3f800000
	.word		0xbf800000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x3f000000
	.word		0xbf000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0x05000000
	.word		0x00000001
	.word		0x007fffff
	.word		0x3f7fffff
	.word		0x4c000000
	.word		0xcc000000
	.word		0xcc000000
	.word		0x4c000000
	.word		0x40800000
	.word		0xc0800000
	.word		0xc0800000
	.word		0x40800000
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x7f7fffff
	.word		0x4b800000
	.word		0xcb800000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x4b000000
	.word		0xcb000000
	.word		0x4b000000
	.word		0xcb000000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x40800000
	.word		0xc0800000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x41000000
	.word		0xc1000000
	.word		0x41000000
	.word		0xc1000000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x4b800000
	.word		0xcb800000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40c00000
	.word		0x4bc00000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f800002
	.word		0x3f800006
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f800002
	.word		0x3fc00000
	.word		0x3fc00000
	.word		0x7e800000
	.word		0x7e800000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f800002
	.word		0x3f800003
	.word		0x3f800004
	.word		0x3f7ffffe
	.word		0x3f7ffffc
	.word		0x3f7ffff8
	.word		0x3f800002
	.word		0x3f800003
	.word		0x3f800003
	.word		0x3f800007
	.word		0x3f800008
	.word		0x3f7ffffd
	.word		0x3f7ffffc
	.word		0x3f7ffff9
	.word		0x3f7ffff9
	.word		0x3f7ffff9
	.word		0x3f7ffffe
	.word		0x3f7ffffe
	.word		0x3f7ffffe
	.word		0x3f7ffffc
	.word		0x3f7ffffe
	.word		0x3f800001
	.word		0x3f800001
	.word		0x3f800002
	.word		0x3f800001
	.word		0x3f800003
	.word		0x3f800002
	.word		0x3f800001
	.word		0x3f800004
	.word		0x3f800002
	.word		0x3f800003
	.word		0xbf800001
	.word		0x3f800001
	.word		0xbf800001
	.word		0x3f7ffffe
	.word		0xbf7ffffe
	.word		0x3f7ffffe
	.word		0xbf7ffffe
	.word		0x00800001
	.word		0x80800001
	.word		0x00800001
	.word		0x80800001
	.word		0x3f800001
	.word		0xbf800001
	.word		0xbf800001
.align 8


result:
	.word		0x44800000
	.word		0x44800000
	.word		0xc4800000
	.word		0xc4800000
	.word		0x71800000
	.word		0x71800000
	.word		0xf1800000
	.word		0xf1800000
	.word		0x53800000
	.word		0x53800000
	.word		0xd3800000
	.word		0xd3800000
	.word		0x50800000
	.word		0x50800000
	.word		0xd0800000
	.word		0xd0800000
	.word		0x40800000
	.word		0x40800000
	.word		0xc0800000
	.word		0xc0800000
	.word		0x454cc000
	.word		0x447a0000
	.word		0x42c80000
	.word		0x41200000
	.word		0x3f800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x40000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x007fffff
	.word		0x807fffff
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x7e800000
	.word		0xfe800000
	.word		0xfe7fffff
	.word		0xfe7ffffd
	.word		0xfeffffff
	.word		0x40800000
	.word		0x40800000
	.word		0xc0800000
	.word		0xc0800000
	.word		0x80800000
	.word		0x80800003
	.word		0x80800001
	.word		0x007fffff
	.word		0x00200000
	.word		0x00200000
	.word		0x80200000
	.word		0x80200000
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x40c00000
	.word		0x40c00000
	.word		0xc0c00000
	.word		0xc0c00000
	.word		0x00fffffe
	.word		0x00fffffe
	.word		0x80fffffe
	.word		0x80fffffe
	.word		0x00000002
	.word		0x00000002
	.word		0x80000002
	.word		0x80000002
	.word		0x3f000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x3f000000
	.word		0xbf000000
	.word		0x44c00000
	.word		0x44c00000
	.word		0xc4c00000
	.word		0xc4c00000
	.word		0x04fffffe
	.word		0x04fffffe
	.word		0x84fffffe
	.word		0x84fffffe
	.word		0x00000008
	.word		0x00000008
	.word		0x80000008
	.word		0x80000008
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3b000000
	.word		0xbb000000
	.word		0x3e000000
	.word		0xbe000000
	.word		0x3e000000
	.word		0xbe000000
	.word		0x40400000
	.word		0x40400000
	.word		0xc0400000
	.word		0xc0400000
	.word		0x40000000
	.word		0x40000000
	.word		0xc0000000
	.word		0xc0000000
	.word		0x7e7ffffd
	.word		0xfe7ffffd
	.word		0xfe7ffffd
	.word		0x7e7ffffd
	.word		0x00100000
	.word		0x00100000
	.word		0x80100000
	.word		0x80100000
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x40800000
	.word		0xc0800000
	.word		0xc0800000
	.word		0x40800000
	.word		0x40800000
	.word		0x40800000
	.word		0xc0800000
	.word		0xc0800000
	.word		0x40800000
	.word		0x40800000
	.word		0xc0800000
	.word		0xc0800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x3f800000
	.word		0x3f800000
	.word		0xbf800000
	.word		0xbf800000
	.word		0x00000001
	.word		0x80000001
	.word		0x7fffffff
	.word		0x7fffffff
	.word		0x7fffffff
	.word		0x7fffffff
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fffffff
	.word		0x7fffffff
	.word		0x7fffffff
	.word		0x7fffffff
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x00280000
	.word		0x00000000
	.word		0x003fffff
	.word		0x003fffff
	.word		0x803fffff
	.word		0x803fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007ffffc
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x007ffffd
	.word		0x007fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x3f7ffffe
	.word		0x3f7ffffe
	.word		0xbf7ffffe
	.word		0xbf7ffffe
	.word		0x3f7ffffc
	.word		0x3f7ffffa
	.word		0x3f7ffff8
	.word		0x3f800001
	.word		0x3f800002
	.word		0x3f800004
	.word		0x3f7ffffe
	.word		0x3f7ffffc
	.word		0x3f7ffffe
	.word		0x3f7ffffa
	.word		0x3f7ffffc
	.word		0x3f800001
	.word		0x3f800001
	.word		0x3f800003
	.word		0x3f800002
	.word		0x3f800001
	.word		0x3f800002
	.word		0x3f800003
	.word		0x3f800004
	.word		0x3f800004
	.word		0x3f800005
	.word		0x3f7ffffd
	.word		0x3f7ffffc
	.word		0x3f7ffffb
	.word		0x3f7ffffb
	.word		0x3f7ffff9
	.word		0x3f7ffffa
	.word		0x3f7ffffa
	.word		0x3f7ffff7
	.word		0x3f7ffff9
	.word		0x3f7ffff8
	.word		0x3f7ffffa
	.word		0xbf7ffffa
	.word		0xbf7ffffa
	.word		0x3fc00000
	.word		0x3fc00000
	.word		0xbfc00000
	.word		0xbfc00000
	.word		0x3efffffe
	.word		0x3efffffe
	.word		0xbefffffe
	.word		0xbefffffe
	.word		0x40400000
	.word		0x40400000
	.word		0xc0400000
.align 8
fcc_result:


cexc_flag:
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000002
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000010
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000009
	.xword		0x0000000000000008
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
.align 8


scratch:
	.xword		0x0000000000000000
	.xword		0x0000000000000000


