// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: fmuls_ieee_zero2.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
/***********************************************************************
* Name:   fmuls_ieee_zero2.s
* Date:   11/6/02
*
*
**********************************************************************/

#define ENABLE_T0_Fp_disabled_0x20
#include "boot.s"

.global sam_fast_immu_miss
.global sam_fast_dmmu_miss

.text
.global main

! Testing fmuls with rounding mode zero



main:

	! Common code

	wr		%g0, 0x4, %fprs		! make sure fef is 1 
	setx		source1, %l0, %l1
	setx		source2, %l0, %l2
	setx		result, %l0, %l3
	setx		fcc_result, %l0, %l4
	setx		cexc_flag, %l0, %l5
	setx		fsr_rounding_mode, %l0, %l6
	setx		scratch, %l0, %l7


	set		480, %g1		! Set loop count
	set		0x0, %g2		! Set loop iterator


fmuls_loop:
	ldx		[%l6+0x0], %fsr


	! instruction specific code

	sll		%g2, 0x2, %g3

	ldx		[%l6], %fsr		! Load fsr with rounding mode
	ld		[%l1+%g3], %f0		! Load source 1
	ld		[%l2+%g3], %f2		! Load source 2
	fmuls		%f0, %f2, %f4		! Perform the operation
	st		%f4, [%l7+0x0]		! Store the result for comparison
	stx		%fsr, [%l7+0x8]		! Store the fsr for comparison
	ld		[%l7+0x0], %g4		! Load result from memory for comparison

        ldx     [%l7+0x8], %g5   ! Load fsr from memory for comparison
        sll     %g2, 0x3, %g3
        ldx     [%l5+%g3], %g6   ! Load fsr with expected cexc mode
        mov     0x0f, %g3              ! Mask for nv
        and     %g3, %g6, %g7          ! Mask off nv
        srl     %g7, 0x3, %g7          ! Shift to get of
        or      %g7, %g6, %g6          ! Generate correct nx with of
        mov     0x01, %g3              ! Mask to get nx
        and     %g3, %g6, %g7          ! Mask off all but nx
        sll     %g7, 0x2, %g7          ! Shift to align nx and uf
        or      %g7, 0x1b, %g7         ! Mask for all cexc bits
        and     %g7, %g6, %g6          ! Generate correct uf for denorm
	      sll     %g6, 0x5, %g7          ! Generate aexc
	      or      %g6, %g7, %g7          ! Generate expected fsr
	      ldx     [%l6], %g6        ! Load fsr with rounding mode
	      or      %g6, %g7, %g7          ! Generate expected fsr

	sll		%g2, 0x2, %g3
	ld		[%l3+%g3], %g6		! Load expected result

	subcc		%g4, %g6, %g0		! Compare
	bne,a		test_fail		! If not equal, test failed
	nop
	subcc		%g5, %g7, %g0		! Compare
	bne,a		test_fail		! If not equal, test failed
	nop


	add		%g2, 0x1, %g2		! Increment loop iterator
	subcc		%g2, %g1, %g0		! Compare
	bne,a		fmuls_loop		! Loop
	nop


/*******************************************************
 * Exit code
 *******************************************************/

test_pass:
	ta		T_GOOD_TRAP

test_fail:
	ta		T_BAD_TRAP




/*******************************************************
* Data section
*******************************************************/
.data


fsr_rounding_mode:
	.xword		0x0000000040000000


source1:
	.word		0x80800001
	.word		0x7f800000
	.word		0x80ffffff
	.word		0xff800000
	.word		0x7fc00000
	.word		0x7f800000
	.word		0x7fc00000
	.word		0xff800000
	.word		0x7fc00000
	.word		0x007fffff
	.word		0x7fc00000
	.word		0x807fffff
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x00000001
	.word		0x7fc00000
	.word		0x80000001
	.word		0x7fc00000
	.word		0x3f800000
	.word		0x7fc00000
	.word		0xbf800000
	.word		0x7fc00000
	.word		0x7f7fffff
	.word		0x7fc00000
	.word		0xff7fffff
	.word		0x7f000000
	.word		0x40000001
	.word		0x7f000000
	.word		0x40c00001
	.word		0x7f000000
	.word		0x40c00000
	.word		0x7f000000
	.word		0x7e800006
	.word		0xc09ffffe
	.word		0xff000000
	.word		0xc0e00000
	.word		0xff000000
	.word		0xfe7ffff9
	.word		0xff7fffff
	.word		0xff7ffffd
	.word		0xc0400001
	.word		0xc0a00000
	.word		0x7f000000
	.word		0xfe800000
	.word		0x7f000000
	.word		0x7f000000
	.word		0xc0800005
	.word		0x7f000000
	.word		0xc1000003
	.word		0x7f000000
	.word		0xc0000000
	.word		0x7f000009
	.word		0xfe800002
	.word		0x7f000009
	.word		0xc0c00002
	.word		0x3f800001
	.word		0x7f7fffff
	.word		0xbf800001
	.word		0xff7fffff
	.word		0x3f800002
	.word		0x7f7ffffe
	.word		0xbf800002
	.word		0xff7ffffe
	.word		0x3f800004
	.word		0x7f7ffffc
	.word		0xbf800004
	.word		0xff7ffffc
	.word		0x3f800008
	.word		0x7f7ffff8
	.word		0xbf800008
	.word		0xff7ffff8
	.word		0xbf800001
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0x3f800001
	.word		0xbf800002
	.word		0x7f7ffffe
	.word		0xff7ffffe
	.word		0x3f800002
	.word		0xbf800004
	.word		0x7f7ffffc
	.word		0xff7ffffc
	.word		0x3f800004
	.word		0xbf800008
	.word		0x7f7ffff8
	.word		0xff7ffff8
	.word		0x3f800008
	.word		0x7efffffd
	.word		0xc0000008
	.word		0x3ffffffc
	.word		0x7f000002
	.word		0xbffffffc
	.word		0xff000002
	.word		0xbffffffc
	.word		0x7f000002
	.word		0xff000002
	.word		0x3ffffffc
	.word		0x3ffffffe
	.word		0x7f000001
	.word		0xbffffffe
	.word		0xff000001
	.word		0xbffffffe
	.word		0x7f000001
	.word		0xff000001
	.word		0x3ffffffe
	.word		0x00800000
	.word		0x80800000
	.word		0x80800000
	.word		0x00800000
	.word		0x00800000
	.word		0x01000000
	.word		0x80800000
	.word		0x81000000
	.word		0x80800000
	.word		0x01000000
	.word		0x00800000
	.word		0x81000000
	.word		0x01000000
	.word		0x81000000
	.word		0x81000000
	.word		0x01000000
	.word		0x32800000
	.word		0x00800000
	.word		0xb2800000
	.word		0x80800000
	.word		0xb2800000
	.word		0x00800000
	.word		0x32800000
	.word		0x80800000
	.word		0x807ffff7
	.word		0x01000003
	.word		0x007ffff7
	.word		0x81000003
	.word		0x007ffff7
	.word		0x01000003
	.word		0x807ffff7
	.word		0x81000003
	.word		0x007fffff
	.word		0x007ffffe
	.word		0x807fffff
	.word		0x807ffffe
	.word		0x807fffff
	.word		0x007ffffe
	.word		0x007fffff
	.word		0x807ffffe
	.word		0x00000001
	.word		0x3e000000
	.word		0x80000001
	.word		0xbe000000
	.word		0x80000001
	.word		0x3e000000
	.word		0x00000001
	.word		0xbe000000
	.word		0x00000001
	.word		0x80000001
	.word		0x00000001
	.word		0x80000001
	.word		0x32ffffff
	.word		0x00800001
	.word		0xb2ffffff
	.word		0x80800001
	.word		0xb2ffffff
	.word		0x00800001
	.word		0x32ffffff
	.word		0x80800001
	.word		0x337fffff
	.word		0x00800000
	.word		0xb37fffff
	.word		0x80800000
	.word		0xb37fffff
	.word		0x00800000
	.word		0x337fffff
	.word		0x80800000
	.word		0x00000001
	.word		0x3e800000
	.word		0x80000001
	.word		0xbe800000
	.word		0x80000001
	.word		0x3e800000
	.word		0xbe800000
	.word		0x00000001
	.word		0x00000001
	.word		0x3fbfffff
	.word		0x80000001
	.word		0xbfbfffff
	.word		0x80000001
	.word		0x3fbfffff
	.word		0xbfbfffff
	.word		0x00000001
	.word		0x00000001
	.word		0x405fffff
	.word		0x80000001
	.word		0xc05fffff
	.word		0x80000001
	.word		0x405fffff
	.word		0xc05fffff
	.word		0x00000001
	.word		0x33800000
	.word		0x00800000
	.word		0xb3800000
	.word		0x80800000
	.word		0xb3800000
	.word		0x00800000
	.word		0x33800000
	.word		0x80800000
	.word		0x00000001
	.word		0x3f000000
	.word		0x80000001
	.word		0xbf000000
	.word		0x3f000000
	.word		0x80000001
	.word		0xbf000000
	.word		0x00000001
	.word		0x00000001
	.word		0x3fc00000
	.word		0x80000001
	.word		0xbfc00000
	.word		0x3fc00000
	.word		0x80000001
	.word		0xbfc00000
	.word		0x00000001
	.word		0x00000001
	.word		0x40200000
	.word		0x80000001
	.word		0xc0200000
	.word		0x40200000
	.word		0x80000001
	.word		0xc0200000
	.word		0x00000001
	.word		0x00000001
	.word		0x40600000
	.word		0x80000001
	.word		0xc0600000
	.word		0x40600000
	.word		0x80000001
	.word		0xc0600000
	.word		0x00000001
	.word		0x33a00000
	.word		0x00800000
	.word		0xb3a00000
	.word		0x80800000
	.word		0xb3a00000
	.word		0x00800000
	.word		0x80800000
	.word		0x33a00000
	.word		0x00000001
	.word		0x3f000001
	.word		0x80000001
	.word		0xbf000001
	.word		0x80000001
	.word		0x3f000001
	.word		0xbf000001
	.word		0x00000001
	.word		0x40200001
	.word		0x00000001
	.word		0xc0200001
	.word		0x80000001
	.word		0xc0200001
	.word		0x00000001
	.word		0x80000001
	.word		0x40200001
	.word		0x33000001
	.word		0x00ffffff
	.word		0xb3000001
	.word		0x80ffffff
	.word		0xb3000001
	.word		0x00ffffff
	.word		0x80ffffff
	.word		0x33000001
	.word		0x33c00000
	.word		0x00800000
	.word		0xb3c00000
	.word		0x80800000
	.word		0xb3c00000
	.word		0x00800000
	.word		0x80800000
	.word		0x33c00000
	.word		0x00000001
	.word		0x3f400000
	.word		0x80000001
	.word		0xbf400000
	.word		0x80000001
	.word		0x3f400000
	.word		0xbf400000
	.word		0x00000001
	.word		0x33e00000
	.word		0x00800000
	.word		0xb3e00000
	.word		0x80800000
	.word		0xb3e00000
	.word		0x00800000
	.word		0x80800000
	.word		0x33e00000
	.word		0x00000001
	.word		0x3f400001
	.word		0x80000001
	.word		0xbf400001
	.word		0x80000001
	.word		0x3f400001
	.word		0xbf400001
	.word		0x00000001
	.word		0x00000001
	.word		0x3f7fffff
	.word		0x80000001
	.word		0xbf7fffff
	.word		0x80000001
	.word		0x3f7fffff
	.word		0x00000001
	.word		0xbf7fffff
	.word		0x337fffff
	.word		0x00ffffff
	.word		0xb37fffff
	.word		0x80ffffff
	.word		0xb37fffff
	.word		0x00ffffff
	.word		0x80ffffff
	.word		0x337fffff
	.word		0x007ffffc
	.word		0x3f800001
	.word		0x807ffffc
	.word		0xbf800001
	.word		0x807ffffc
	.word		0x3f800001
	.word		0xbf800001
	.word		0x007ffffc
	.word		0x3f400000
	.word		0x00800001
	.word		0xbf400000
	.word		0x80800001
	.word		0xbf400000
	.word		0x00800001
	.word		0x80800001
	.word		0x3f400000
	.word		0x007ffffe
	.word		0x3f800001
	.word		0x807ffffe
	.word		0xbf800001
	.word		0x807ffffe
	.word		0x3f800001
	.word		0xbf800001
	.word		0x007ffffe
	.word		0x007ffff8
	.word		0x3f800001
	.word		0x807ffff8
	.word		0xbf800001
	.word		0x807ffff8
	.word		0x3f800001
	.word		0xbf800001
	.word		0x007ffff8
	.word		0x007ffff7
	.word		0x3f800001
	.word		0x807ffff7
	.word		0xbf800001
	.word		0x807ffff7
	.word		0x3f800001
	.word		0xbf800001
	.word		0x007ffff7
	.word		0x00800001
	.word		0x3f7ffffa
	.word		0x80800001
	.word		0xbf7ffffa
	.word		0x80800001
	.word		0x3f7ffffa
	.word		0xbf7ffffa
	.word		0x00800001
	.word		0x007ffffe
	.word		0x3f7ffffc
	.word		0x807ffffe
	.word		0xbf7ffffc
	.word		0x807ffffe
	.word		0x3f7ffffc
	.word		0xbf7ffffc
	.word		0x007ffffe
	.word		0x3effffff
	.word		0x00800003
	.word		0xbeffffff
	.word		0x80800003
	.word		0xbeffffff
	.word		0x00800003
	.word		0x80800003
	.word		0x3effffff
	.word		0x007fffff
	.word		0x3f800001
	.word		0x807fffff
	.word		0xbf800001
	.word		0x807fffff
	.word		0x3f800001
	.word		0xbf800001
	.word		0x007fffff
	.word		0x3f800008
	.word		0x007ffff8
	.word		0x807ffff8
	.word		0xbf800008
	.word		0x807ffff8
	.word		0x3f800008
	.word		0xbf800008
	.word		0x007ffff8
	.word		0x00800001
	.word		0x3f7ffffe
	.word		0x80800001
	.word		0xbf7ffffe
	.word		0x80800001
	.word		0x3f7ffffe
	.word		0xbf7ffffe
	.word		0x00800001
	.word		0x00800002
	.word		0x3f7ffffc
	.word		0x80800002
	.word		0xbf7ffffc
	.word		0x80800002
	.word		0x3f7ffffc
	.word		0xbf7ffffc
	.word		0x00800002
	.word		0x3f000002
	.word		0x00fffffb
	.word		0xbf000002
	.word		0x80fffffb
	.word		0xbf000002
	.word		0x00fffffb
	.word		0x80fffffb
	.word		0x3f000002
	.word		0x00ffffff
	.word		0x3f000000
	.word		0x80ffffff
	.word		0xbf000000
	.word		0x80ffffff
	.word		0x3f000000
	.word		0xbf000000
	.word		0x00ffffff
	.word		0x00800000
	.word		0x3f7ffffe
	.word		0x80800000
	.word		0xbf7ffffe
	.word		0x80800000
	.word		0x3f7ffffe
	.word		0xbf7ffffe
	.word		0x00800000
	.word		0x00fffffe
	.word		0x3f000000
	.word		0x80fffffe
	.word		0xbf000000
	.word		0x80fffffe
	.word		0x3f000000
	.word		0xbf000000
	.word		0x00fffffe
	.word		0x00fffffc
	.word		0x3f000000
	.word		0x80fffffc
	.word		0xbf000000
	.word		0x80fffffc
	.word		0x3f000000
	.word		0xbf000000
	.word		0x00fffffc
	.word		0x00fffff8
	.word		0x3f000000
	.word		0x80fffff8
	.word		0xbf000000
	.word		0x80fffff8
	.word		0x3f000000
	.word		0xbf000000
	.word		0x00fffff8
	.word		0x00000008
	.word		0x3e000000
	.word		0x80000008
	.word		0xbe000000
	.word		0x80000008
	.word		0x3e000000
	.word		0xbe000000
	.word		0x00000008
	.word		0x00000006
	.word		0x3f000000
	.word		0x80000006
	.word		0xbf000000
	.word		0x80000006
	.word		0x3f000000
	.word		0xbf000000
	.word		0x00000006
	.word		0x403fffff
	.word		0x3f7fffff
	.word		0xc03fffff
.align 8


source2:
	.word		0x7f800000
	.word		0x80800001
	.word		0xff800000
	.word		0x80ffffff
	.word		0x7f800000
	.word		0x7fc00000
	.word		0xff800000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x007fffff
	.word		0x7fc00000
	.word		0x807fffff
	.word		0x00000001
	.word		0x7fc00000
	.word		0x80000001
	.word		0x7fc00000
	.word		0x3f800000
	.word		0x7fc00000
	.word		0xbf800000
	.word		0x7fc00000
	.word		0x7f7fffff
	.word		0x7fc00000
	.word		0xff7fffff
	.word		0x7fc00000
	.word		0x40000001
	.word		0x7f000000
	.word		0x40c00001
	.word		0x7f000000
	.word		0x40c00000
	.word		0x7f000000
	.word		0x7e800006
	.word		0x7f000000
	.word		0xff000000
	.word		0xc09ffffe
	.word		0xff000000
	.word		0xc0e00000
	.word		0xff7fffff
	.word		0xfe7ffff9
	.word		0xc0400001
	.word		0xff7ffffd
	.word		0x7f000000
	.word		0xc0a00000
	.word		0x7f000000
	.word		0xfe800000
	.word		0xc0800005
	.word		0x7f000000
	.word		0xc1000003
	.word		0x7f000000
	.word		0xc0000000
	.word		0x7f000000
	.word		0xfe800002
	.word		0x7f000009
	.word		0xc0c00002
	.word		0x7f000009
	.word		0x7f7fffff
	.word		0x3f800001
	.word		0xff7fffff
	.word		0xbf800001
	.word		0x7f7ffffe
	.word		0x3f800002
	.word		0xff7ffffe
	.word		0xbf800002
	.word		0x7f7ffffc
	.word		0x3f800004
	.word		0xff7ffffc
	.word		0xbf800004
	.word		0x7f7ffff8
	.word		0x3f800008
	.word		0xff7ffff8
	.word		0xbf800008
	.word		0x7f7fffff
	.word		0xbf800001
	.word		0x3f800001
	.word		0xff7fffff
	.word		0x7f7ffffe
	.word		0xbf800002
	.word		0x3f800002
	.word		0xff7ffffe
	.word		0x7f7ffffc
	.word		0xbf800004
	.word		0x3f800004
	.word		0xff7ffffc
	.word		0x7f7ffff8
	.word		0xbf800008
	.word		0x3f800008
	.word		0xff7ffff8
	.word		0xc0000008
	.word		0x7efffffd
	.word		0x7f000002
	.word		0x3ffffffc
	.word		0xff000002
	.word		0xbffffffc
	.word		0x7f000002
	.word		0xbffffffc
	.word		0x3ffffffc
	.word		0xff000002
	.word		0x7f000001
	.word		0x3ffffffe
	.word		0xff000001
	.word		0xbffffffe
	.word		0x7f000001
	.word		0xbffffffe
	.word		0x3ffffffe
	.word		0xff000001
	.word		0x00800000
	.word		0x80800000
	.word		0x00800000
	.word		0x80800000
	.word		0x01000000
	.word		0x00800000
	.word		0x81000000
	.word		0x80800000
	.word		0x01000000
	.word		0x80800000
	.word		0x81000000
	.word		0x00800000
	.word		0x01000000
	.word		0x81000000
	.word		0x01000000
	.word		0x81000000
	.word		0x00800000
	.word		0x32800000
	.word		0x80800000
	.word		0xb2800000
	.word		0x00800000
	.word		0xb2800000
	.word		0x80800000
	.word		0x32800000
	.word		0x01000003
	.word		0x807ffff7
	.word		0x81000003
	.word		0x007ffff7
	.word		0x01000003
	.word		0x007ffff7
	.word		0x81000003
	.word		0x807ffff7
	.word		0x007ffffe
	.word		0x007fffff
	.word		0x807ffffe
	.word		0x807fffff
	.word		0x007ffffe
	.word		0x807fffff
	.word		0x807ffffe
	.word		0x007fffff
	.word		0x3e000000
	.word		0x00000001
	.word		0xbe000000
	.word		0x80000001
	.word		0x3e000000
	.word		0x80000001
	.word		0xbe000000
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00800001
	.word		0x32ffffff
	.word		0x80800001
	.word		0xb2ffffff
	.word		0x00800001
	.word		0xb2ffffff
	.word		0x80800001
	.word		0x32ffffff
	.word		0x00800000
	.word		0x337fffff
	.word		0x80800000
	.word		0xb37fffff
	.word		0x00800000
	.word		0xb37fffff
	.word		0x80800000
	.word		0x337fffff
	.word		0x3e800000
	.word		0x00000001
	.word		0xbe800000
	.word		0x80000001
	.word		0x3e800000
	.word		0x80000001
	.word		0x00000001
	.word		0xbe800000
	.word		0x3fbfffff
	.word		0x00000001
	.word		0xbfbfffff
	.word		0x80000001
	.word		0x3fbfffff
	.word		0x80000001
	.word		0x00000001
	.word		0xbfbfffff
	.word		0x405fffff
	.word		0x00000001
	.word		0xc05fffff
	.word		0x80000001
	.word		0x405fffff
	.word		0x80000001
	.word		0x00000001
	.word		0xc05fffff
	.word		0x00800000
	.word		0x33800000
	.word		0x80800000
	.word		0xb3800000
	.word		0x00800000
	.word		0xb3800000
	.word		0x80800000
	.word		0x33800000
	.word		0x3f000000
	.word		0x00000001
	.word		0xbf000000
	.word		0x80000001
	.word		0x80000001
	.word		0x3f000000
	.word		0x00000001
	.word		0xbf000000
	.word		0x3fc00000
	.word		0x00000001
	.word		0xbfc00000
	.word		0x80000001
	.word		0x80000001
	.word		0x3fc00000
	.word		0x00000001
	.word		0xbfc00000
	.word		0x40200000
	.word		0x00000001
	.word		0xc0200000
	.word		0x80000001
	.word		0x80000001
	.word		0x40200000
	.word		0x00000001
	.word		0xc0200000
	.word		0x40600000
	.word		0x00000001
	.word		0xc0600000
	.word		0x80000001
	.word		0x80000001
	.word		0x40600000
	.word		0x00000001
	.word		0xc0600000
	.word		0x00800000
	.word		0x33a00000
	.word		0x80800000
	.word		0xb3a00000
	.word		0x00800000
	.word		0xb3a00000
	.word		0x33a00000
	.word		0x80800000
	.word		0x3f000001
	.word		0x00000001
	.word		0xbf000001
	.word		0x80000001
	.word		0x3f000001
	.word		0x80000001
	.word		0x00000001
	.word		0xbf000001
	.word		0x00000001
	.word		0x40200001
	.word		0x80000001
	.word		0xc0200001
	.word		0x00000001
	.word		0xc0200001
	.word		0x40200001
	.word		0x80000001
	.word		0x00ffffff
	.word		0x33000001
	.word		0x80ffffff
	.word		0xb3000001
	.word		0x00ffffff
	.word		0xb3000001
	.word		0x33000001
	.word		0x80ffffff
	.word		0x00800000
	.word		0x33c00000
	.word		0x80800000
	.word		0xb3c00000
	.word		0x00800000
	.word		0xb3c00000
	.word		0x33c00000
	.word		0x80800000
	.word		0x3f400000
	.word		0x00000001
	.word		0xbf400000
	.word		0x80000001
	.word		0x3f400000
	.word		0x80000001
	.word		0x00000001
	.word		0xbf400000
	.word		0x00800000
	.word		0x33e00000
	.word		0x80800000
	.word		0xb3e00000
	.word		0x00800000
	.word		0xb3e00000
	.word		0x33e00000
	.word		0x80800000
	.word		0x3f400001
	.word		0x00000001
	.word		0xbf400001
	.word		0x80000001
	.word		0x3f400001
	.word		0x80000001
	.word		0x00000001
	.word		0xbf400001
	.word		0x3f7fffff
	.word		0x00000001
	.word		0xbf7fffff
	.word		0x80000001
	.word		0x3f7fffff
	.word		0x80000001
	.word		0xbf7fffff
	.word		0x00000001
	.word		0x00ffffff
	.word		0x337fffff
	.word		0x80ffffff
	.word		0xb37fffff
	.word		0x00ffffff
	.word		0xb37fffff
	.word		0x337fffff
	.word		0x80ffffff
	.word		0x3f800001
	.word		0x007ffffc
	.word		0xbf800001
	.word		0x807ffffc
	.word		0x3f800001
	.word		0x807ffffc
	.word		0x007ffffc
	.word		0xbf800001
	.word		0x00800001
	.word		0x3f400000
	.word		0x80800001
	.word		0xbf400000
	.word		0x00800001
	.word		0xbf400000
	.word		0x3f400000
	.word		0x80800001
	.word		0x3f800001
	.word		0x007ffffe
	.word		0xbf800001
	.word		0x807ffffe
	.word		0x3f800001
	.word		0x807ffffe
	.word		0x007ffffe
	.word		0xbf800001
	.word		0x3f800001
	.word		0x007ffff8
	.word		0xbf800001
	.word		0x807ffff8
	.word		0x3f800001
	.word		0x807ffff8
	.word		0x007ffff8
	.word		0xbf800001
	.word		0x3f800001
	.word		0x007ffff7
	.word		0xbf800001
	.word		0x807ffff7
	.word		0x3f800001
	.word		0x807ffff7
	.word		0x007ffff7
	.word		0xbf800001
	.word		0x3f7ffffa
	.word		0x00800001
	.word		0xbf7ffffa
	.word		0x80800001
	.word		0x3f7ffffa
	.word		0x80800001
	.word		0x00800001
	.word		0xbf7ffffa
	.word		0x3f7ffffc
	.word		0x007ffffe
	.word		0xbf7ffffc
	.word		0x807ffffe
	.word		0x3f7ffffc
	.word		0x807ffffe
	.word		0x007ffffe
	.word		0xbf7ffffc
	.word		0x00800003
	.word		0x3effffff
	.word		0x80800003
	.word		0xbeffffff
	.word		0x00800003
	.word		0xbeffffff
	.word		0x3effffff
	.word		0x80800003
	.word		0x3f800001
	.word		0x007fffff
	.word		0xbf800001
	.word		0x807fffff
	.word		0x3f800001
	.word		0x807fffff
	.word		0x007fffff
	.word		0xbf800001
	.word		0x007ffff8
	.word		0x3f800008
	.word		0xbf800008
	.word		0x807ffff8
	.word		0x3f800008
	.word		0x807ffff8
	.word		0x007ffff8
	.word		0xbf800008
	.word		0x3f7ffffe
	.word		0x00800001
	.word		0xbf7ffffe
	.word		0x80800001
	.word		0x3f7ffffe
	.word		0x80800001
	.word		0x00800001
	.word		0xbf7ffffe
	.word		0x3f7ffffc
	.word		0x00800002
	.word		0xbf7ffffc
	.word		0x80800002
	.word		0x3f7ffffc
	.word		0x80800002
	.word		0x00800002
	.word		0xbf7ffffc
	.word		0x00fffffb
	.word		0x3f000002
	.word		0x80fffffb
	.word		0xbf000002
	.word		0x00fffffb
	.word		0xbf000002
	.word		0x3f000002
	.word		0x80fffffb
	.word		0x3f000000
	.word		0x00ffffff
	.word		0xbf000000
	.word		0x80ffffff
	.word		0x3f000000
	.word		0x80ffffff
	.word		0x00ffffff
	.word		0xbf000000
	.word		0x3f7ffffe
	.word		0x00800000
	.word		0xbf7ffffe
	.word		0x80800000
	.word		0x3f7ffffe
	.word		0x80800000
	.word		0x00800000
	.word		0xbf7ffffe
	.word		0x3f000000
	.word		0x00fffffe
	.word		0xbf000000
	.word		0x80fffffe
	.word		0x3f000000
	.word		0x80fffffe
	.word		0x00fffffe
	.word		0xbf000000
	.word		0x3f000000
	.word		0x00fffffc
	.word		0xbf000000
	.word		0x80fffffc
	.word		0x3f000000
	.word		0x80fffffc
	.word		0x00fffffc
	.word		0xbf000000
	.word		0x3f000000
	.word		0x00fffff8
	.word		0xbf000000
	.word		0x80fffff8
	.word		0x3f000000
	.word		0x80fffff8
	.word		0x00fffff8
	.word		0xbf000000
	.word		0x3e000000
	.word		0x00000008
	.word		0xbe000000
	.word		0x80000008
	.word		0x3e000000
	.word		0x80000008
	.word		0x00000008
	.word		0xbe000000
	.word		0x3f000000
	.word		0x00000006
	.word		0xbf000000
	.word		0x80000006
	.word		0x3f000000
	.word		0x80000006
	.word		0x00000006
	.word		0xbf000000
	.word		0x3f7fffff
	.word		0x403fffff
	.word		0xbf7fffff
.align 8


result:
	.word		0xff800000
	.word		0xff800000
	.word		0x7f800000
	.word		0x7f800000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7fc00000
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0x7f7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0xff7fffff
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000003
	.word		0x00000003
	.word		0x00000003
	.word		0x00000003
	.word		0x80000003
	.word		0x80000003
	.word		0x80000003
	.word		0x80000003
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000002
	.word		0x00000002
	.word		0x00000002
	.word		0x00000002
	.word		0x80000002
	.word		0x80000002
	.word		0x80000002
	.word		0x80000002
	.word		0x00000003
	.word		0x00000003
	.word		0x00000003
	.word		0x00000003
	.word		0x80000003
	.word		0x80000003
	.word		0x80000003
	.word		0x80000003
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000002
	.word		0x00000002
	.word		0x00000002
	.word		0x00000002
	.word		0x80000002
	.word		0x80000002
	.word		0x80000002
	.word		0x80000002
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x00000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x80000000
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x00600000
	.word		0x00600000
	.word		0x00600000
	.word		0x00600000
	.word		0x80600000
	.word		0x80600000
	.word		0x80600000
	.word		0x80600000
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x007ffff8
	.word		0x007ffff8
	.word		0x007ffff8
	.word		0x007ffff8
	.word		0x807ffff8
	.word		0x807ffff8
	.word		0x807ffff8
	.word		0x807ffff8
	.word		0x007ffff7
	.word		0x007ffff7
	.word		0x007ffff7
	.word		0x007ffff7
	.word		0x807ffff7
	.word		0x807ffff7
	.word		0x807ffff7
	.word		0x807ffff7
	.word		0x007ffffd
	.word		0x007ffffd
	.word		0x007ffffd
	.word		0x007ffffd
	.word		0x807ffffd
	.word		0x807ffffd
	.word		0x807ffffd
	.word		0x807ffffd
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x00400001
	.word		0x00400001
	.word		0x00400001
	.word		0x00400001
	.word		0x80400001
	.word		0x80400001
	.word		0x80400001
	.word		0x80400001
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x007fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x807fffff
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x007ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x807ffffe
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x007ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x807ffffc
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x00000001
	.word		0x80000001
	.word		0x80000001
	.word		0x80000001
	.word		0x80000001
	.word		0x00000003
	.word		0x00000003
	.word		0x00000003
	.word		0x00000003
	.word		0x80000003
	.word		0x80000003
	.word		0x80000003
	.word		0x80000003
	.word		0x403ffffe
	.word		0x403ffffe
	.word		0x403ffffe
.align 8
fcc_result:


cexc_flag:
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000000
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000008
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000009
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000005
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000004
	.xword		0x0000000000000001
	.xword		0x0000000000000001
	.xword		0x0000000000000001
.align 8


scratch:
	.xword		0x0000000000000000
	.xword		0x0000000000000000


