// Modified by Princeton University on June 9th, 2015
/*
* ========== Copyright Header Begin ==========================================
* 
* OpenSPARC T1 Processor File: mpgen_diag7_060503.s
* Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
* DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
* 
* The above named program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License version 2 as published by the Free Software Foundation.
* 
* The above named program is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public
* License along with this work; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
* 
* ========== Copyright Header End ============================================
*/
!	Niagara MP Random Test
!	Seed = 35
!	CIAM can be on
!	8 Processors, 1000 lines each
!	mpgen   created on Jun 5, 2003 (15:06:41)
!	diag.s created on Jun 5, 2003 (16:25:45)
!	RC file : diag.rc

#include "custom_page1.h"

	.global	main

	.seg	"text"
	ALIGN_PAGE_8K
user_text_start:
main:

!	Check for processor ID

set     0x22,   %o0
ta	T_TRAP_EN
	th_fork(processor,%l0)

!	Random code for Processor 0

processor_0:
	ta	T_CHANGE_PRIV
	set	done_flags,%g1
	mov	1,%g2
	st	%g2,[%g1+0x00]		! Set the start flag
	wrpr	%g0,7,%cleanwin
	call	p0_init_memory_pointers
	wr	%g0,0x80,%asi		! Setting default asi to 80

!	Initialize the floating point registers for processor 0

	wr	%g0,0x4,%fprs		! Make sure fef is 1
	set	p0_init_freg,%g1
!	%f0  = c2422d93 d9af3595 0ec6a9e8 ed0150d6
!	%f4  = 72f0cb29 6994baa7 beb8162f b930b831
!	%f8  = abb39f9c 825adca4 eac02975 8ed3d0f6
!	%f12 = e2ca244b 81540798 624aa775 aa3128f1
	ldda	[%g1]ASI_BLK_P,%f0
	add	%g1,64,%g1
!	%f16 = 5a8ac424 41c0d8ac 576041d9 8fc5b799
!	%f20 = 7495d47f 79354df4 ca21b525 b2b56005
!	%f24 = 20a42de9 5f933035 dafbba2d 4be4bf40
!	%f28 = d1f73cad 9e51eef9 4038f050 4d4c7b4a
	ldda	[%g1]ASI_BLK_P,%f16
	add	%g1,64,%g1
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%g1]ASI_BLK_P,%f32
	xorcc	%g0,%g0,%g3		! init %g3 and set flags
	membar	#Sync			! Force the block loads to complete

!	Start of Random Code for processor 0

p0_label_1:
!	%f0  = c2422d93 d9af3595 0ec6a9e8 ed0150d6
!	%f4  = 72f0cb29 6994baa7 beb8162f b930b831
!	%f8  = abb39f9c 825adca4 eac02975 8ed3d0f6
!	%f12 = e2ca244b 81540798 624aa775 aa3128f1
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 0000000011800000
!	Mem[00000000110000c0] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[00000000110000d0] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000110000e0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000110000f0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	mov	0x0c0,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000110000c0
!	Mem[0000000070000044] = e3f5d882, %l2 = e81372800dab120e
	lduha	[%o0+0x044]%asi,%l2	! %l2 = 000000000000e3f5
	membar	#Sync			! Added by membar checker (1)
!	Mem[0000000011800008] = 0ec6a9e8, %l0 = 5e9d522444f0f93a
	ldsba	[%i3+%o6]0x80,%l0	! %l0 = 000000000000000e
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	mov	0x080,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000011800080

p0_label_2:
!	Mem[00000000110000c0] = dba1f0f14bd1585c, %l4 = b9540090918daa92
	ldxa	[%i2+0x0c0]%asi,%l4	! %l4 = dba1f0f14bd1585c
!	Mem[0000000071800000] = b5be837b, %l3 = d6fc58a2678e8718
	ldswa	[%o3+0x000]%asi,%l3	! %l3 = ffffffffb5be837b
	membar	#Sync			! Added by membar checker (2)
	set	p0_b1,%o7
	fbule,pt %fcc0,p0_near_1_he	! Branch Taken, %fcc0 = 0
!	Mem[0000000010000008] = b84b2bdd, %l7 = 83cf5e9254012454
	lduba	[%i0+%o6]0x80,%l7	! %l7 = 00000000000000b8
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x001,%g2
p0_b1:
!	Registers modified during the branch to p0_near_1
!	%l0  = 0000000000000000
!	%l1  = 00000003fffffffe
!	%l2  = dba1f0f14bd1585c
!	%l5  = dba1f0f14bd1fbfd
!	%l6  = bb3f41d9b62a94cd
!	%l7  = ffffffffffff5c5e
!	Mem[0000000071000004] = a4e97c64, %l0 = 0000000000000000
	ldub	[%o2+0x004],%l0		! %l0 = 00000000000000a4

p0_label_3:
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000010800000
!	%l4 = dba1f0f14bd1585c, immed = fffff0d6, %y  = 00000000
	sdivx	%l4,-0xf2a,%l5		! %l5 = 000265f4986158f0
!	Mem[0000000011800040] = 49170eca 1fec7ece b68abd29 f63eb4a4
!	Mem[0000000011800050] = 79131b17 753a9676 196762ff c4b0db6a
!	Mem[0000000011800060] = 28b889d2 96fd7c61 3b126559 f30c2e69
!	Mem[0000000011800070] = 71de445b 6d07ba62 8b95bdca 170501ab
	mov	0x040,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000011800040
!	Mem[0000000070000044] = e3f5d882, %l2 = dba1f0f14bd1585c
	lduba	[%o0+0x046]%asi,%l2	! %l2 = 00000000000000d8
!	%f17 = c1e9f47b, %f27 = 1a0ace06
	fcmpes	%fcc0,%f17,%f27		! %fcc0 = 1

p0_label_4:
!	%f16 = d9d4ff29 c1e9f47b 28c1dd7d b41c5918
!	%f20 = e4aa3d8e 07540821 0a883395 be7ffa9e
!	%f24 = 9d514ec5 7d6dbb07 e6a761aa 1a0ace06
!	%f28 = b523c9e0 6eba67d5 63b0b9d1 0bdcec80
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000011000000
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_PL,%f0	! Block Load from 0000000010800000
!	%f0  = d9d4ff29 c1e9f47b 28c1dd7d b41c5918
!	%f4  = e4aa3d8e 07540821 0a883395 be7ffa9e
!	%f8  = 9d514ec5 7d6dbb07 e6a761aa 1a0ace06
!	%f12 = b523c9e0 6eba67d5 63b0b9d1 0bdcec80
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000010000040
	membar	#Sync			! Added by membar checker (3)
!	Mem[0000000011000000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000011000010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000011000020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000011000030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i2]ASI_BLK_P,%f16	! Block Load from 0000000011000000
!	%l7 = ffffffffffff5c5e, %l4 = dba1f0f14bd1585c, %l5 = 000265f4986158f0
	or	%l7,%l4,%l5		! %l5 = ffffffffffff5c5e

p0_label_5:
!	Mem[0000000070800004] = 356877b1, %l0 = 00000000000000a4
	ldswa	[%o1+0x004]%asi,%l0	! %l0 = 00000000356877b1
!	Mem[0000000011800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000011800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 0000000011800080
!	Mem[0000000010800040] = 5ed571a7 f6c63f4e eac39dac b22eb19a
!	Mem[0000000010800050] = f501845f 1de53960 bcac6a31 1e1834e7
!	Mem[0000000010800060] = 0477cff8 d62c18c7 652037e9 9e97d217
!	Mem[0000000010800070] = 362c33c4 f8da87ea c59fba15 ee31509c
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010800040
!	Mem[00000000100000f4] = 9583b8d1, %l2 = 00000000000000d8
	lduha	[%i0+0x0f6]%asi,%l2	! %l2 = 000000000000b8d1
!	Mem[0000000072000018] = b5705fd567ee565b, %l7 = ffffffffffff5c5e
	ldx	[%o4+0x018],%g2		! %g2 = b5705fd567ee565b

p0_label_6:
!	Mem[0000000010800080] = 45a647e9 5888c838 f8dee4a2 1c2947e8
!	Mem[0000000010800090] = 0e358411 8c2cb99f f4c2e913 b6d7d351
!	Mem[00000000108000a0] = 471f3e8b 46d0f9fe 3d3481e6 bdd5e0ac
!	Mem[00000000108000b0] = ca664a82 0b1699fa 45582f03 1fe23af5
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 0000000010800080
!	Mem[00000000100000a4] = cf48297b, %l6 = bb3f41d9b62a94cd
	ldsw	[%i0+0x0a4],%l6		! %l6 = ffffffffcf48297b
!	Mem[00000000110000c0] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[00000000110000d0] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000110000e0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000110000f0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000110000c0
!	Mem[0000000012800008] = e556920e 130f32a9, %l0 = 356877b1, %l1 = fffffffe
	ldda	[%i5+%o6]0x80,%l0	! %l0 = 00000000e556920e 00000000130f32a9
!	%f0  = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f4  = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f8  = c7182cd6 f8cf7704 17d2979e e9372065
!	%f12 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f0,[%i5+%g5]ASI_BLK_P	! Block Store to 0000000012800080

p0_label_7:
	membar	#Sync
	ba,a	p0_b2			! Branch Taken, %ccr = 80, CWP = 0
!	Mem[0000000072000048] = 2bf57d99e8bcab63, %l6 = ffffffffcf48297b
	ldx	[%o4+0x048],%g2		! Annulled
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x002,%g2
p0_b2:
!	%f31 = 3e2da712, %f31 = 3e2da712, %f18 = a9a7a91b
	fsubs	%f31,%f31,%f18		! %f18 = 00000000
!	%f12 = ea87daf8, %f0  = 4e3fc6f6
	fmovs	%f12,%f0 		! %f0  = ea87daf8
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000011000000

p0_label_8:
!	%f0  = ea87daf8 a771d55e 9ab12eb2 ac9dc3ea
!	%f4  = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f8  = c7182cd6 f8cf7704 17d2979e e9372065
!	%f12 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f0,[%i3]ASI_BLK_PL	! Block Store to 0000000011800000
!	Mem[0000000011000098] = 2d1f68e1, %l5 = ffffffffffff5c5e
	lduha	[%i2+0x09a]%asi,%l5	! %l5 = 00000000000068e1
!	Mem[0000000010800000] = 7bf4e9c1, %l1 = 00000000130f32a9
	ldswa	[%i1+%g0]0x80,%l1	! %l1 = 000000007bf4e9c1
!	Mem[0000000010000080] = d61aad7c 0e4b39c9 9c1d363a 8bb596e9
!	Mem[0000000010000090] = 0d7d2425 82d81800 5c605b3b 75e29555
!	Mem[00000000100000a0] = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	Mem[00000000100000b0] = 7aa0a431 df4558e1 7037de86 97473c63
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000010000080
!	%f0  = d61aad7c 0e4b39c9 9c1d363a 8bb596e9
!	%f4  = 0d7d2425 82d81800 5c605b3b 75e29555
!	%f8  = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	%f12 = 7aa0a431 df4558e1 7037de86 97473c63
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 0000000010000000

p0_label_9:
!	Mem[0000000040a00014] = 2e2e3a3d, %l4 = dba1f0f14bd1585c
	ldsb	[%o5+0x015],%l4		! %l4 = 000000000000002e
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040
!	Mem[00000000108000f4] = 65d1967f, %l4 = 000000000000002e
	ldsba	[%i1+0x0f5]%asi,%l4	! %l4 = ffffffffffffffd1
!	%f0  = d61aad7c, %f0  = d61aad7c, %f0  = d61aad7c
	fadds	%f0 ,%f0 ,%f0 		! %f0  = d69aad7c
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000

p0_label_10:
	membar	#Sync			! Added by membar checker (4)
!	Mem[0000000010000000] = c9394b0e 7cad1ad6, %l6 = cf48297b, %l7 = ffff5c5e
	ldda	[%i0+%g0]0x80,%l6	! %l6 = 00000000c9394b0e 000000007cad1ad6
!	Mem[00000000110000e8] = 54af7f61, %l7 = 000000007cad1ad6
	ldsw	[%i2+0x0e8],%l7		! %l7 = 0000000054af7f61
!	%f0  = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	%f4  = 0d7d2425 82d81800 5c605b3b 75e29555
!	%f8  = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	%f12 = 7aa0a431 df4558e1 7037de86 97473c63
	stda	%f0,[%i0]ASI_BLK_P	! Block Store to 0000000010000000
!	Mem[0000000013000000] = db27a7ef 75f8fa0e ec8f424a 42473611
!	Mem[0000000013000010] = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	Mem[0000000013000020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000013000030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i6]ASI_BLK_P,%f0	! Block Load from 0000000013000000
	membar	#Sync			! Added by membar checker (5)
	set	p0_b3,%o7
	fbge,pn	%fcc2,p0_near_0_he	! Branch Taken, %fcc2 = 0

p0_label_11:
!	Mem[0000000010800000] = 7bf4e9c1, %l4 = ffffffffffffffd1
	lduba	[%i1+%g0]0x80,%l4	! %l4 = 000000000000007b
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p0_branch_failed
	mov	0x003,%g2
p0_b3:
!	Registers modified during the branch to p0_near_0
!	%l0  = 000000265123acc4
!	%l7  = 0000000087819bb0
!	Mem[000000007200007c] = 60f59a00, %l6 = 00000000c9394b0e
	ldsb	[%o4+0x07d],%g2		! %g2 = 0000000000000060
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000108000c0
!	Mem[00000000100000d8] = d550e48663f130ee, %l2 = 000000000000b8d1
	ldx	[%i0+0x0d8],%l2		! %l2 = d550e48663f130ee
!	Mem[0000000071000040] = 8de109dd 3f9d54fe, %l6 = c9394b0e, %l7 = 87819bb0
	ldd	[%o2+0x040],%l6		! %l6 = 000000008de109dd 000000003f9d54fe

p0_label_12:
!	Mem[0000000071000044] = 3f9d54fe, %l3 = ffffffffb5be837b
	lduwa	[%o2+0x044]%asi,%l3	! %l3 = 000000003f9d54fe
!	Mem[0000000071800040] = 27aa5595, %l3 = 000000003f9d54fe
	ldsw	[%o3+0x040],%l3		! %l3 = 0000000027aa5595
!	Mem[0000000072000040] = e52f81e7 7204d04f 2bf57d99 e8bcab63
!	Mem[0000000072000050] = 876a38ba 4684903e 4d87bc9b fb584d4b
!	Mem[0000000072000060] = 330289d1 834615f3 560b78a1 da01ee66
!	Mem[0000000072000070] = ea47ccfe 2b6b1536 b32a25dd 6960f59a
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000072000040] = e52f81e7 7204d04f 2bf57d99 e8bcab63
!	Mem[0000000072000050] = 876a38ba 4684903e 4d87bc9b fb584d4b
!	Mem[0000000072000060] = 330289d1 834615f3 560b78a1 da01ee66
!	Mem[0000000072000070] = ea47ccfe 2b6b1536 b32a25dd 6960f59a
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%f22 = 7c60467e 702cfbce, %f12 = 8694754f 31619def
	fcmpd	%fcc3,%f22,%f12		! %fcc3 = 2

p0_label_13:
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i2]ASI_BLK_P	! Block Store to 0000000011000000
	membar	#Sync
	set	p0_b4,%o7
	fble	p0_far_2_le		! Branch Taken, %fcc0 = 1
!	Mem[0000000011000094] = 954551ed, %l0 = 000000265123acc4
	ldsh	[%i2+0x096],%l0		! %l0 = 00000000000051ed
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x004,%g2
p0_b4:
!	Registers modified during the branch to p0_far_2
!	%l1  = 2686ccaa356877b1
!	%l2  = 0000000000003ec3
!	%l4  = b5be837b60ff8e53
!	%l6  = 000000000477cff8
!	%l7  = b5be837b60ffe040
!	%f21 = 161e942c, %f18 = 00000000, %f26 = eb27bc1a
	fmuls	%f21,%f18,%f26		! %f26 = 00000000

p0_label_14:
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[0000000010000000] = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	Mem[0000000010000010] = 0d7d2425 82d81800 5c605b3b 75e29555
!	Mem[0000000010000020] = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	Mem[0000000010000030] = 7aa0a431 df4558e1 7037de86 97473c63
	ldda	[%i0]ASI_BLK_P,%f16	! Block Load from 0000000010000000
!	Mem[0000000010000020] = b3399f16cf48297b, %l3 = 0000000027aa5595
	ldxa	[%i0+0x020]%asi,%l3	! %l3 = b3399f16cf48297b
!	Mem[0000000010800008] = 18591cb47dddc128, %l5 = 00000000000068e1
	ldxa	[%i1+%o6]0x80,%l5	! %l5 = 18591cb47dddc128
!	%f16 = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	%f20 = 0d7d2425 82d81800 5c605b3b 75e29555
!	%f24 = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	%f28 = 7aa0a431 df4558e1 7037de86 97473c63
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000010000040

p0_label_15:
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000118000c0
	membar	#Sync			! Added by membar checker (6)
!	Mem[0000000010000040] = c9394b0e 7cad9ad6 e996b58b 3a361d9c
!	Mem[0000000010000050] = 0018d882 25247d0d 5595e275 3b5b605c
!	Mem[0000000010000060] = 7b2948cf 169f39b3 0befa638 a7fce59e
!	Mem[0000000010000070] = e15845df 31a4a07a 633c4797 86de3770
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 0000000010000040
!	Mem[0000000010800008] = 18591cb4, %l5 = 18591cb47dddc128
	lduwa	[%i1+%o6]0x80,%l5	! %l5 = 0000000018591cb4
!	Mem[0000000010800060] = 0477cff8, %l4 = b5be837b60ff8e53
	lduh	[%i1+0x060],%l4		! %l4 = 0000000000000477
!	Mem[0000000010000008] = 9c1d363a, %l1 = 2686ccaa356877b1
	lduha	[%i0+%o6]0x80,%l1	! %l1 = 0000000000009c1d

p0_label_16:
!	Mem[0000000011800000] = 5ed571a7 f8da87ea, %l0 = 000051ed, %l1 = 00009c1d
	ldda	[%i3+%g0]0x80,%l0	! %l0 = 000000005ed571a7 00000000f8da87ea
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000100000c0
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i6+%g6]ASI_BLK_PL	! Block Store to 0000000013000040
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 0000000011800000
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000

p0_label_17:
!	Mem[0000000011800088] = a9a7a91bd3398026, %l1 = 00000000f8da87ea
	ldx	[%i3+0x088],%l1		! %l1 = a9a7a91bd3398026
!	Mem[0000000040a00010] = 3c170304, %l4 = 0000000000000477
	lduha	[%o5+0x010]%asi,%l4	! %l4 = 0000000000003c17
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000010000080
!	Mem[0000000010000000] = d69aad7c, %l5 = 0000000018591cb4
	lduwa	[%i0+%g0]0x80,%l5	! %l5 = 00000000d69aad7c
!	%f16 = c9394b0e 7cad9ad6 e996b58b 3a361d9c
!	%f20 = 0018d882 25247d0d 5595e275 3b5b605c
!	%f24 = 7b2948cf 169f39b3 0befa638 a7fce59e
!	%f28 = e15845df 31a4a07a 633c4797 86de3770
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000010800040

p0_label_18:
!	Mem[0000000011000000] = db27a7ef 75f8fa0e ec8f424a 42473611
!	Mem[0000000011000010] = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	Mem[0000000011000020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000011000030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i2]ASI_BLK_PL,%f16	! Block Load from 0000000011000000
!	Mem[0000000070800044] = 3ec3f718, %l7 = b5be837b60ffe040
	lduh	[%o1+0x046],%l7		! %l7 = 000000000000f718
	membar	#Sync			! Added by membar checker (7)
!	%f16 = 0efaf875 efa727db 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 7e695f29
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i3]ASI_BLK_PL	! Block Store to 0000000011800000
!	Mem[0000000010800000] = 7bf4e9c1, %l5 = 00000000d69aad7c
	ldsba	[%i1+%g0]0x80,%l5	! %l5 = 000000000000007b
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040

p0_label_19:
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000010800000
!	Mem[00000000108000c0] = 5c58d14b f1f0a1db 00000000 d3398026
!	Mem[00000000108000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000108000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000108000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i1+%g4]ASI_BLK_P,%f16	! Block Load from 00000000108000c0
!	%l6 = 000000000477cff8, immed = 000000d0, %l1 = a9a7a91bd3398026
	or	%l6,0x0d0,%l1		! %l1 = 000000000477cff8
!	Mem[00000000100000f8] = 3a2565b7 7f5aedf0, %l4 = 00003c17, %l5 = 0000007b
	ldda	[%i0+0x0f8]%asi,%l4	! %l4 = 000000003a2565b7 000000007f5aedf0
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 00000000100000c0

p0_label_20:
	membar	#Sync			! Added by membar checker (8)
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i3]ASI_BLK_PL	! Block Store to 0000000011800000
!	%f0  = db27a7ef 75f8fa0e ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000011000040
!	Mem[0000000011000008] = ec8f424a, %l4 = 000000003a2565b7
	lduba	[%i2+%o6]0x80,%l4	! %l4 = 00000000000000ec
	membar	#Sync
	fbuge	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000010800008] = 18591cb4, %l0 = 000000005ed571a7
	lduba	[%i1+%o6]0x80,%l0	! %l0 = 0000000000000018
p0_b5:

p0_label_21:
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000011000040] = 0efaf875 efa727db 11364742 4a428fec
!	Mem[0000000011000050] = eb6faf8a de8c3bef 3edd2478 7e695f29
!	Mem[0000000011000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 0000000011000040
!	Mem[0000000011800000] = dba1f0f1 4bd1585c 268039d3 00000000
!	Mem[0000000011800010] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000011800020] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000011800030] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000011800000
!	Mem[0000000012000044] = cecbe5a6, %l6 = 000000000477cff8
	ldub	[%i4+0x047],%l6		! %l6 = 00000000000000a6
!	%l6 = 00000000000000a6, immed = 0000000a, %l4 = 00000000000000ec
	srl	%l6,0x00a,%l4		! %l4 = 0000000000000000

p0_label_22:
!	Mem[0000000070800044] = 3ec3f718, %l3 = b3399f16cf48297b
	ldsh	[%o1+0x046],%l3		! %l3 = fffffffffffff718
!	%l2 = 0000000000003ec3, %l4 = 0000000000000000, %l3 = fffffffffffff718
	sub	%l2,%l4,%l3		! %l3 = 0000000000003ec3
!	%l2 = 0000000000003ec3, Mem[0000000071800042] = 27aa5595
	sth	%l2,[%o3+0x042]		! Mem[0000000071800040] = 27aa3ec3
!	Mem[0000000010000008] = 9c1d363a, %l1 = 000000000477cff8
	ldub	[%i0+0x00b],%l1		! %l1 = 000000000000003a
	membar	#Sync			! Added by membar checker (9)
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040

p0_label_23:
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000010800000
!	%f6  = 3edd2478 7e695f29, %f12 = ef9d6131 4f759486
	fabsd	%f6 ,%f12		! %f12 = 3edd2478 7e695f29
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[0000000010000008] = 9c1d363a 8bb596e9, %l6 = 000000a6, %l7 = 0000f718
	ldda	[%i0+%o6]0x80,%l6	! %l6 = 000000009c1d363a 000000008bb596e9
	membar	#Sync			! Added by membar checker (10)
!	%f16 = d9d4ff29 c1e9f47b 28c1dd7d b41c5918
!	%f20 = e4aa3d8e 07540821 0a883395 be7ffa9e
!	%f24 = 9d514ec5 7d6dbb07 e6a761aa 1a0ace06
!	%f28 = b523c9e0 6eba67d5 63b0b9d1 0bdcec80
	stda	%f16,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000

p0_label_24:
!	Mem[0000000011800040] = dba1f0f1 4bd1585c 268039d3 00000000
!	Mem[0000000011800050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000011800060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000011800070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 0000000011800040
!	%l3 = 0000000000003ec3, Mem[0000000010000008] = 9c1d363a
	stha	%l3,[%i0+%o6]0x80	! Mem[0000000010000008] = 3ec3363a
!	Mem[0000000070000000] = 91d9e75487819bb0, %l4 = 0000000000000000
	ldx	[%o0+0x000],%l4		! %l4 = 91d9e75487819bb0
!	Mem[0000000071800004] = 60ffe040, %l3 = 0000000000003ec3
	lduba	[%o3+0x004]%asi,%l3	! %l3 = 0000000000000060
!	Mem[00000000100000c0] = dba1f0f1 4bd1585c 268039d3 00000000
!	Mem[00000000100000d0] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000100000e0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000100000f0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000100000c0

p0_label_25:
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000011800040
!	Mem[000000007200006c] = 7d5b3eb9, %l3 = 0000000000000060
	ldsba	[%o4+0x06f]%asi,%g2	! %g2 = 000000000000007d
	membar	#Sync			! Added by membar checker (11)
!	Mem[0000000011800040] = 5c58d14b f1f0a1db 00000000 d3398026
!	Mem[0000000011800050] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[0000000011800060] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[0000000011800070] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000011800040
!	Mem[0000000010000000] = d69aad7c, %l4 = 91d9e75487819bb0
	lduwa	[%i0+%g0]0x80,%l4	! %l4 = 00000000d69aad7c
!	Mem[0000000072000018] = 9efa7fbe9533880a, %l4 = 00000000d69aad7c
	ldx	[%o4+0x018],%g2		! %g2 = 9efa7fbe9533880a

p0_label_26:
!	Mem[0000000010800084] = 5888c838, %l3 = 0000000000000060
	ldsh	[%i1+0x086],%l3		! %l3 = ffffffffffffc838
!	Mem[0000000010000000] = d69aad7c0e4b39c9, %l3 = ffffffffffffc838
	ldxa	[%i0+%g0]0x80,%l3	! %l3 = d69aad7c0e4b39c9
!	Mem[00000000118000c0] = 0efaf875 efa727db 11364742 4a428fec
!	Mem[00000000118000d0] = eb6faf8a de8c3bef 3edd2478 7e695f29
!	Mem[00000000118000e0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000118000f0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 00000000118000c0
!	Mem[0000000011000000] = db27a7ef, %l5 = 000000007f5aedf0
	ldsba	[%i2+%g0]0x80,%l5	! %l5 = ffffffffffffffdb
!	%l2 = 0000000000003ec3, immed = 000003de, %l4 = 00000000d69aad7c
	or	%l2,0x3de,%l4		! %l4 = 0000000000003fdf

p0_label_27:
!	Mem[0000000011800000] = dba1f0f1, %l7 = 000000008bb596e9
	ldswa	[%i3+%g0]0x80,%l7	! %l7 = ffffffffdba1f0f1
!	Mem[0000000010000000] = d69aad7c, %l6 = 000000009c1d363a
	ldsha	[%i0+%g0]0x80,%l6	! %l6 = ffffffffffffd69a
!	Mem[0000000071800040] = 27aa3ec3, %l6 = ffffffffffffd69a
	lduw	[%o3+0x040],%l6		! %l6 = 0000000027aa3ec3
!	Mem[000000007200004c] = 4204f2ed, %l5 = ffffffffffffffdb
	lduwa	[%o4+0x04c]%asi,%g2	! %g2 = ffffffffffffffdb
!	%l6 = 0000000027aa3ec3, %l4 = 0000000000003fdf, %l4 = 0000000000003fdf
	sllx	%l6,%l4,%l4		! %l4 = 13d51f6180000000

p0_label_28:
	membar	#Sync			! Added by membar checker (12)
	set	p0_b6,%o7
	fbul	p0_far_3_he		! Branch Taken, %fcc0 = 1
!	%f18 = 00000000, %f20 = 76fd123c, %f15 = b765253a
	fdivs	%f18,%f20,%f15		! %f15 = 00000000
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x006,%g2
p0_b6:
!	Registers modified during the branch to p0_far_3
!	%l0  = ffffffffffffffdf
!	%l2  = 0000000091d9e754
!	%l3  = 27aa3ec39ba8c36b
!	%l7  = 27aa3ec39ba8c36b
!	Mem[0000000070800000] = 2686ccaa 356877b1, %l2 = 91d9e754, %l3 = 9ba8c36b
	ldda	[%o1+0x000]%asi,%l2	! %l2 = 000000002686ccaa 00000000356877b1
!	Mem[0000000010000000] = d69aad7c, %l0 = ffffffffffffffdf
	ldswa	[%i0+%g0]0x80,%l0	! %l0 = ffffffffd69aad7c
!	%f0  = 0efaf875 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 7e695f29
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f 00000000
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 0000000011800000

p0_label_29:
!	Mem[00000000118000f0] = ef9d6131, %l1 = 000000000000003a
	lduba	[%i3+0x0f3]%asi,%l1	! %l1 = 0000000000000031
!	Mem[0000000013000000] = db27a7ef 75f8fa0e, %l6 = 27aa3ec3, %l7 = 9ba8c36b
	ldda	[%i6+%g0]0x80,%l6	! %l6 = 00000000db27a7ef 0000000075f8fa0e
!	Mem[0000000010000008] = 3ec3363a, %l0 = ffffffffd69aad7c
	lduwa	[%i0+%o6]0x80,%l0	! %l0 = 000000003ec3363a
	ba,a	p0_b7			! Branch Taken, %ccr = 88, CWP = 0
!	Mem[00000000108000cf] = d3398026, %l2 = 000000002686ccaa
	ldstub	[%i1+0x0cf],%l2		! Annulled
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p0_branch_failed
	mov	0x007,%g2
p0_b7:

p0_label_30:
!	Mem[00000000128000e4] = 0408fbc1, %l3 = 00000000356877b1
	lduha	[%i5+0x0e6]%asi,%l3	! %l3 = 000000000000fbc1
!	%l7 = 0000000075f8fa0e, %l4 = 13d51f6180000000, %y  = 00000026
	mulx	%l7,%l4,%l6		! %l6 = 2c40ee5500000000
!	%l4 = 13d51f6180000000, %l1 = 0000000000000031, %l6 = 2c40ee5500000000
	srax	%l4,%l1,%l6		! %l6 = 00000000000009ea
	fbg,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	%l4 = 13d51f6180000000, %l2 = 000000002686ccaa, %l1 = 0000000000000031
	srl	%l4,%l2,%l1		! Annulled
p0_b8:

p0_label_31:
!	Mem[0000000010800008] = 18591cb4, %l6 = 00000000000009ea
	ldswa	[%i1+%o6]0x80,%l6	! %l6 = 0000000018591cb4
!	Mem[0000000011000008] = ec8f424a, %l7 = 0000000075f8fa0e
	ldsha	[%i2+%o6]0x80,%l7	! %l7 = ffffffffffffec8f
!	Mem[000000007200001c] = 0a07bb6d, %l6 = 0000000018591cb4
	ldub	[%o4+0x01f],%g2		! %g2 = 000000000000000a
!	Mem[00000000108000c0] = 5c58d14b f1f0a1db 00000000 d3398026
!	Mem[00000000108000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000108000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000108000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i1+%g4]ASI_BLK_P,%f16	! Block Load from 00000000108000c0
!	Mem[0000000011000044] = efa727db, %l7 = ffffffffffffec8f
	ldub	[%i2+0x046],%l7		! %l7 = 0000000000000027

p0_label_32:
!	Mem[0000000010800008] = 18591cb4, %l6 = 0000000018591cb4
	ldsba	[%i1+%o6]0x80,%l6	! %l6 = 0000000000000018
!	Mem[0000000070000040] = f67031ea, %l1 = 0000000000000031
	lduha	[%o0+0x040]%asi,%l1	! %l1 = 000000000000f670
	fbe,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000010000008] = 3ec3363a, %l3 = 000000000000fbc1
	lduha	[%i0+%o6]0x80,%l3	! Annulled
p0_b9:
!	Mem[00000000110000c0] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[00000000110000d0] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000110000e0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000110000f0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000110000c0

p0_label_33:
!	Mem[0000000071800000] = b5be837b, %l6 = 0000000000000018
	lduh	[%o3+0x000],%l6		! %l6 = 000000000000b5be
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000010000080
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i5]ASI_BLK_PL	! Block Store to 0000000012800000
	bgu,a	p0_b10			! Branch Taken, %ccr = 88, CWP = 0
!	%l6 = 000000000000b5be, %l1 = 000000000000f670, %l5 = ffffffffffffffdb
	sra	%l6,%l1,%l5		! %l5 = 0000000000000000
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x00a,%g2
p0_b10:

p0_label_34:
!	Mem[0000000011000094] = 954551ed, %l7 = 0000000000000027
	ldsb	[%i2+0x097],%l7		! %l7 = ffffffffffffffed
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_PL,%f0	! Block Load from 0000000010800000
!	Mem[0000000071000004] = a4e97c64, %l4 = 13d51f6180000000
	lduba	[%o2+0x005]%asi,%l4	! %l4 = 00000000000000e9
	membar	#Sync			! Added by membar checker (13)
	set	p0_b11,%o7
	fbge,a,pn %fcc3,p0_near_1_he	! Branch Taken, %fcc3 = 2
!	Mem[0000000010000008] = 3ec3363a, %l6 = 000000000000b5be
	ldswa	[%i0+%o6]0x80,%l6	! %l6 = 000000003ec3363a
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x00b,%g2
p0_b11:
!	Registers modified during the branch to p0_near_1
!	%l4  = 000000008de109dd
!	%l5  = 000000003f9d54fe
!	%l7  = ffffffffd97933fd

p0_label_35:
!	Branch On Register, %l6 = 000000003ec3363a
	brz,pn	%l6,p0_not_taken_0	! Branch Not Taken
!	Denormal Floating Point Operation Nullified
	nop
p0_b12:
!	Mem[0000000070800040] = fa3314463ec3f718, %l7 = ffffffffd97933fd
	ldx	[%o1+0x040],%l7		! %l7 = fa3314463ec3f718
!	Mem[0000000011800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000011800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g5]ASI_BLK_P,%f0	! Block Load from 0000000011800080
!	Mem[0000000072000000] = 7bf4e9c1, %l4 = 000000008de109dd
	lduh	[%o4+0x000],%g2		! %g2 = 0000000000007bf4

p0_label_36:
	membar	#Sync			! Added by membar checker (14)
	set	p0_b13,%o7
	fbuge,pt %fcc2,p0_near_3_he	! Branch Taken, %fcc2 = 0
!	Mem[0000000070800004] = 356877b1, %l0 = 000000003ec3363a
	ldsb	[%o1+0x005],%l0		! %l0 = 0000000000000068
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x00d,%g2
p0_b13:
!	Registers modified during the branch to p0_near_3
!	%l1  = ffffffffffffd351
!	%l2  = 00000000cca44017
!	%l3  = 5c58d14bf1f0a1db
!	%l7 = fa3314463ec3f718, Mem[0000000070000000] = 91d9e75487819bb0
	stx	%l7,[%o0+0x000]		! Mem[0000000070000000] = fa3314463ec3f718
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000071000040] = 8de109dd 3f9d54fe, %l2 = cca44017, %l3 = f1f0a1db
	ldd	[%o2+0x040],%l2		! %l2 = 000000008de109dd 000000003f9d54fe

p0_label_37:
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000110000c0
!	Mem[00000000108000b8] = 45582f03, %l1 = ffffffffffffd351
	ldsb	[%i1+0x0bb],%l1		! %l1 = 0000000000000003
!	Mem[0000000071800000] = b5be837b 60ffe040, %l0 = 00000068, %l1 = 00000003
	ldd	[%o3+0x000],%l0		! %l0 = 00000000b5be837b 0000000060ffe040
!	Mem[0000000070800044] = 3ec3f718, %l6 = 000000003ec3363a
	lduh	[%o1+0x044],%l6		! %l6 = 0000000000003ec3
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000011000040

p0_label_38:
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 0000000010800080
!	Mem[0000000070000040] = f67031ea e3f5d882, %l0 = b5be837b, %l1 = 60ffe040
	ldda	[%o0+0x040]%asi,%l0	! %l0 = 00000000f67031ea 00000000e3f5d882
!	%l5 = 000000003f9d54fe, immed = 00000000, %l2 = 000000008de109dd
	srax	%l5,0x000,%l2		! %l2 = 000000003f9d54fe
!	%l2 = 000000003f9d54fe, %l1 = 00000000e3f5d882, %l1 = 00000000e3f5d882
	subccc	%l2,%l1,%l1		! %l1 = ffffffff5ba77c7c, %ccr = 91
	membar	#Sync			! Added by membar checker (15)
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p0_label_39:
!	Mem[00000000100000e0] = eada4f80 21b557be, %l2 = 3f9d54fe, %l3 = 3f9d54fe
	ldd	[%i0+0x0e0],%l2		! %l2 = 00000000eada4f80 0000000021b557be
!	Mem[00000000108000d0] = 76fd123c161e942c, %l3 = 0000000021b557be
	ldx	[%i1+0x0d0],%l3		! %l3 = 76fd123c161e942c
!	Mem[0000000010000040] = c9394b0e 7cad9ad6 e996b58b 3a361d9c
!	Mem[0000000010000050] = 0018d882 25247d0d 5595e275 3b5b605c
!	Mem[0000000010000060] = 7b2948cf 169f39b3 0befa638 a7fce59e
!	Mem[0000000010000070] = e15845df 31a4a07a 633c4797 86de3770
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010000040
	fbul,pt	%fcc1,p0_branch_failed	! Branch Not Taken, %fcc1 = 0
!	%l2 = 00000000eada4f80, immed = 00000538, %l0 = 00000000f67031ea
	xorcc	%l2,0x538,%l0		! %l0 = 00000000eada4ab8, %ccr = 08
p0_b14:

p0_label_40:
!	Mem[0000000070800040] = fa331446, %l3 = 76fd123c161e942c
	ldsb	[%o1+0x040],%l3		! %l3 = fffffffffffffffa
!	Mem[0000000011000008] = ec8f424a 42473611, %l6 = 00003ec3, %l7 = 3ec3f718
	ldda	[%i2+%o6]0x80,%l6	! %l6 = 00000000ec8f424a 0000000042473611
!	Mem[0000000070800004] = 356877b1, %l4 = 000000008de109dd
	lduha	[%o1+0x006]%asi,%l4	! %l4 = 00000000000077b1
!	Mem[0000000011800000] = 0efaf875, %l5 = 000000003f9d54fe
	lduba	[%i3+%g0]0x80,%l5	! %l5 = 000000000000000e
!	%f0  = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	%f4  = 0d7d2425 82d81800 5c605b3b 75e29555
!	%f8  = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	%f12 = 7aa0a431 df4558e1 7037de86 97473c63
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000

p0_label_41:
!	Mem[00000000100000c0] = dba1f0f1 4bd1585c 268039d3 00000000
!	Mem[00000000100000d0] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000100000e0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000100000f0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 00000000100000c0
!	Mem[00000000100000b8] = 28f2bcf3, %l7 = 0000000042473611
	lduw	[%i0+0x0b8],%l7		! %l7 = 0000000028f2bcf3
	fbe,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	%l6 = ec8f424a, %l7 = 28f2bcf3, Mem[00000000108000e0] = be57b521 804fdaea
	std	%l6,[%i1+0x0e0]		! Annulled
p0_b15:
!	%f0  = dba1f0f1 4bd1585c 268039d3 00000000
!	%f4  = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f8  = eada4f80 21b557be 54af7f61 1abc27eb
!	%f12 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040

p0_label_42:
!	%l1 = ffffffff5ba77c7c, immed = fffffc33, %l1 = ffffffff5ba77c7c
	xor	%l1,-0x3cd,%l1		! %l1 = 00000000a458804f
!	Mem[0000000012800000] = dba1f0f1, %l1 = 00000000a458804f
	ldswa	[%i5+%g0]0x80,%l1	! %l1 = ffffffffdba1f0f1
!	%f16 = 5c58d14b f1f0a1db 00000000 d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 00000000118000c0
!	Mem[0000000011000000] = db27a7ef 75f8fa0e ec8f424a 42473611
!	Mem[0000000011000010] = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	Mem[0000000011000020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000011000030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i2]ASI_BLK_PL,%f0	! Block Load from 0000000011000000
	fbul,pt	%fcc2,p0_branch_failed	! Branch Not Taken, %fcc2 = 0

p0_label_43:
!	Mem[0000000011800040] = 5c58d14b f1f0a1db 00000000 d3398026
	prefetch [%i3+0x040],22
p0_b16:
!	Mem[0000000071800000] = b5be837b 60ffe040, %l4 = 000077b1, %l5 = 0000000e
	ldda	[%o3+0x000]%asi,%l4	! %l4 = 00000000b5be837b 0000000060ffe040
!	Mem[0000000010800000] = 7bf4e9c1, %l0 = 00000000eada4ab8
	lduba	[%i1+%g0]0x80,%l0	! %l0 = 000000000000007b
!	Mem[0000000011800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000011800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000011800080
	membar	#Sync			! Added by membar checker (16)
!	Mem[000000007200000c] = 1d9c0018, %l7 = 0000000028f2bcf3
	ldsh	[%o4+0x00e],%g2		! %g2 = 0000000000001d9c

p0_label_44:
!	%f26 = 54af7f61 1abc27eb, Mem[0000000071000000] = 4fbfc50c a4e97c64
	std	%f26,[%o2+0x000]	! Mem[0000000071000000] = 54af7f61 1abc27eb
!	Mem[0000000010000008] = 3ec3363a, %l2 = 00000000eada4f80
	ldsba	[%i0+%o6]0x80,%l2	! %l2 = 000000000000003e
!	Mem[0000000010800000] = 7bf4e9c1, %l1 = ffffffffdba1f0f1
	lduba	[%i1+%g0]0x80,%l1	! %l1 = 000000000000007b
!	Mem[00000000100000d0] = 2c941e16, %l0 = 000000000000007b
	ldsha	[%i0+0x0d0]%asi,%l0	! %l0 = 0000000000002c94
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000011000040

p0_label_45:
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000108000c0
!	Mem[0000000070800004] = 356877b1, %l2 = 000000000000003e
	lduw	[%o1+0x004],%l2		! %l2 = 00000000356877b1
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 0000000010800040
!	Mem[0000000071800040] = 27aa3ec3 9ba8c36b, %l4 = b5be837b, %l5 = 60ffe040
	ldd	[%o3+0x040],%l4		! %l4 = 0000000027aa3ec3 000000009ba8c36b
	membar	#Sync			! Added by membar checker (17)
!	Mem[0000000010800040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000010800050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000010800060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000010800070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010800040

p0_label_46:
!	Mem[00000000108000dc] = 7e46607c, %l6 = 00000000ec8f424a
	lduha	[%i1+0x0dc]%asi,%l6	! %l6 = 0000000000007e46
!	Mem[0000000011000008] = ec8f424a, %l6 = 0000000000007e46
	lduha	[%i2+%o6]0x80,%l6	! %l6 = 000000000000ec8f
!	Mem[0000000010800000] = 7bf4e9c1, %l0 = 0000000000002c94
	ldsha	[%i1+%g0]0x80,%l0	! %l0 = 0000000000007bf4
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 0000000010000000

p0_label_47:
!	%f16 = dba1f0f1 4bd1585c, %f16 = dba1f0f1 4bd1585c
	fcmpd	%fcc1,%f16,%f16		! %fcc1 = 0
!	%l0 = 0000000000007bf4, Mem[0000000071800000] = b5be837b60ffe040
	stxa	%l0,[%o3+0x000]%asi	! Mem[0000000071800000] = 0000000000007bf4
!	Mem[0000000011000008] = ec8f424a, %l2 = 00000000356877b1
	ldsha	[%i2+%o6]0x80,%l2	! %l2 = ffffffffffffec8f
!	Mem[0000000011000000] = db27a7ef, %l1 = 000000000000007b
	lduba	[%i2+%g0]0x80,%l1	! %l1 = 00000000000000db
!	Mem[0000000010000040] = c9394b0e 7cad9ad6 e996b58b 3a361d9c
!	Mem[0000000010000050] = 0018d882 25247d0d 5595e275 3b5b605c
!	Mem[0000000010000060] = 7b2948cf 169f39b3 0befa638 a7fce59e
!	Mem[0000000010000070] = e15845df 31a4a07a 633c4797 86de3770
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010000040

p0_label_48:
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000108000c0
!	Mem[0000000070000040] = f67031eae3f5d882, %l7 = 0000000028f2bcf3
	ldx	[%o0+0x040],%l7		! %l7 = f67031eae3f5d882
!	Mem[0000000011000008] = ec8f424a, %l7 = f67031eae3f5d882
	ldsha	[%i2+%o6]0x80,%l7	! %l7 = ffffffffffffec8f
!	%f0  = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	%f4  = 0d7d2425 82d81800 5c605b3b 75e29555
!	%f8  = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	%f12 = 7aa0a431 df4558e1 7037de86 97473c63
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[0000000010800008] = 18591cb4, %l6 = 000000000000ec8f
	ldsha	[%i1+%o6]0x80,%l6	! %l6 = 0000000000001859

p0_label_49:
!	Mem[0000000071800004] = 00007bf4, %l4 = 0000000027aa3ec3
	lduba	[%o3+0x004]%asi,%l4	! %l4 = 0000000000000000
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000040a00014] = 2e2e3a3d, %l5 = 000000009ba8c36b
	lduh	[%o5+0x016],%l5		! %l5 = 0000000000003a3d
	membar	#Sync			! Added by membar checker (18)
!	Mem[0000000010000008] = 268039d3, %l0 = 0000000000007bf4
	lduba	[%i0+%o6]0x80,%l0	! %l0 = 0000000000000026
!	%l5 = 0000000000003a3d, immed = fffff18e, %l7 = ffffffffffffec8f
	add	%l5,-0xe72,%l7		! %l7 = 0000000000002bcb

p0_label_50:
!	Mem[0000000071000000] = 54af7f61 1abc27eb, %l2 = ffffec8f, %l3 = fffffffa
	ldd	[%o2+0x000],%l2		! %l2 = 0000000054af7f61 000000001abc27eb
!	Mem[0000000072000000] = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	Mem[0000000072000010] = 0d7d2425 82d81800 5c605b3b 75e29555
!	Mem[0000000072000020] = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	Mem[0000000072000030] = 7aa0a431 df4558e1 7037de86 97473c63
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	fbne,pn	%fcc2,p0_branch_failed	! Branch Not Taken, %fcc2 = 0
!	%l1 = 00000000000000db, immed = 00000713, %l6 = 0000000000001859
	tsubcc	%l1,0x713,%l6		! %l6 = fffffffffffff9c8, %ccr = 9b
p0_b17:
!	Mem[0000000040a00010] = 3c1703042e2e3a3d, %l7 = 0000000000002bcb, %l2 = 0000000054af7f61
	add	%o5,0x10,%g1
	casxa	[%g1]0x80,%l7,%l2	! %l2 = 3c1703042e2e3a3d

p0_label_51:
!	Mem[0000000010000008] = 268039d3, %l1 = 00000000000000db
	lduha	[%i0+%o6]0x80,%l1	! %l1 = 0000000000002680
!	%f24 = eada4f80, %f27 = 1abc27eb
	fcmpes	%fcc2,%f24,%f27		! %fcc2 = 1
!	Mem[0000000011800044] = f1f0a1db, %l3 = 000000001abc27eb
	ldsw	[%i3+0x044],%l3		! %l3 = fffffffff1f0a1db
	fbge,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	%l5 = 0000000000003a3d, immed = fffff73f, %l4 = 0000000000000000
	orcc	%l5,-0x8c1,%l4		! Annulled
p0_b18:

p0_label_52:
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000118000c0
!	Mem[0000000011800020] = 1c34ef4a, %l3 = fffffffff1f0a1db
	lduh	[%i3+0x020],%l3		! %l3 = 0000000000001c34
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000070000000] = fa3314463ec3f718, %l4 = 0000000000000000
	ldx	[%o0+0x000],%l4		! %l4 = fa3314463ec3f718
!	Mem[0000000011000060] = eada4f80, %l7 = 0000000000002bcb
	ldsba	[%i2+0x063]%asi,%l7	! %l7 = ffffffffffffff80

p0_label_53:
!	Mem[0000000071000040] = 8de109dd 3f9d54fe, %l2 = 2e2e3a3d, %l3 = 00001c34
	ldd	[%o2+0x040],%l2		! %l2 = 000000008de109dd 000000003f9d54fe
!	Mem[0000000010800000] = 7bf4e9c1, %l3 = 000000003f9d54fe
	ldswa	[%i1+%g0]0x80,%l3	! %l3 = 000000007bf4e9c1
!	Mem[0000000071000004] = 1abc27eb, %l1 = 0000000000002680
	lduha	[%o2+0x006]%asi,%l1	! %l1 = 00000000000027eb
!	%f0  = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	%f4  = 0d7d2425 82d81800 5c605b3b 75e29555
!	%f8  = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	%f12 = 7aa0a431 df4558e1 7037de86 97473c63
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040
!	%l0 = 0000000000000026, %l3 = 000000007bf4e9c1, %y  = 00000026
	udivx	%l0,%l3,%l6		! %l6 = 0000000000000000

p0_label_54:
!	Mem[0000000010800008] = 18591cb4, %l6 = 0000000000000000
	ldswa	[%i1+%o6]0x80,%l6	! %l6 = 0000000018591cb4
!	Mem[0000000070800000] = 2686ccaa 356877b1, %l4 = 3ec3f718, %l5 = 00003a3d
	ldd	[%o1+0x000],%l4		! %l4 = 000000002686ccaa 00000000356877b1
!	%l2 = 000000008de109dd, %l2 = 000000008de109dd, %y  = 00000026
	umul	%l2,%l2,%l4		! %l4 = 4ea1aaafc8db48c9
!	Mem[0000000072000000] = d69aad7c 0e4b39c9 9c1d363a 8bb596e9
!	Mem[0000000072000010] = 0d7d2425 82d81800 5c605b3b 75e29555
!	Mem[0000000072000020] = b3399f16 cf48297b 9ee5fca7 38a6ef0b
!	Mem[0000000072000030] = 7aa0a431 df4558e1 7037de86 97473c63
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[0000000011000000] = db27a7ef, %l3 = 000000007bf4e9c1
	ldswa	[%i2+%g0]0x80,%l3	! %l3 = ffffffffdb27a7ef

p0_label_55:
!	Mem[0000000011800008] = 11364742, %l1 = 00000000000027eb
	ldsba	[%i3+0x00a]%asi,%l1	! %l1 = 0000000000000047
!	Mem[0000000011000008] = ec8f424a, %l2 = 000000008de109dd
	ldsba	[%i2+%o6]0x80,%l2	! %l2 = ffffffffffffffec
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_PL,%f0	! Block Load from 0000000010800000
!	%l2 = ffffffffffffffec, Mem[00000000108000e6] = 21b557be
	sth	%l2,[%i1+0x0e6]		! Mem[00000000108000e4] = 21b5ffec
!	Mem[0000000011800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000011800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000011800080

p0_label_56:
	membar	#Sync			! Added by membar checker (19)
!	Mem[00000000118000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000118000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g4]ASI_BLK_P,%f16	! Block Load from 00000000118000c0
	membar	#Sync			! Added by membar checker (20)
	set	p0_b19,%o7
	fbl	p0_far_2_le		! Branch Taken, %fcc0 = 1
!	Mem[0000000011800008] = 11364742, %l2 = ffffffffffffffec
	ldsba	[%i3+%o6]0x80,%l2	! %l2 = 0000000000000011
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p0_branch_failed
	mov	0x013,%g2
p0_b19:
!	Registers modified during the branch to p0_far_2
!	%l1  = 2686ccaa356877b1
!	%l2  = 0000000000003ec3
!	%l4  = 0000000000007bce
!	%l6  = 000000001c34ef4a
!	%l7  = 0000000000007bf4
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
	membar	#Sync			! Added by membar checker (21)
!	Mem[0000000072000018] = 82e96b54, %l2 = 0000000000003ec3
	ldsha	[%o4+0x018]%asi,%g2	! %g2 = ffffffffffff82e9

p0_label_57:
!	Mem[0000000071800000] = 00000000, %l1 = 2686ccaa356877b1
	ldsb	[%o3+0x002],%l1		! %l1 = 0000000000000000
!	Mem[0000000070000000] = fa331446, %l7 = 0000000000007bf4
	ldswa	[%o0+0x000]%asi,%l7	! %l7 = fffffffffa331446
!	Mem[00000000118000f0] = b28929f5e61e4204, %l7 = fffffffffa331446
	ldx	[%i3+0x0f0],%l7		! %l7 = b28929f5e61e4204
!	Mem[0000000070800004] = 356877b1, %l1 = 0000000000000000
	lduh	[%o1+0x006],%l1		! %l1 = 00000000000077b1
!	Mem[0000000011800008] = 11364742, %l5 = 00000000356877b1
	ldswa	[%i3+%o6]0x80,%l5	! %l5 = 0000000011364742

p0_label_58:
!	%f0  = d9d4ff29 c1e9f47b 28c1dd7d b41c5918
!	%f4  = e4aa3d8e 07540821 0a883395 be7ffa9e
!	%f8  = 9d514ec5 7d6dbb07 e6a761aa 1a0ace06
!	%f12 = b523c9e0 6eba67d5 63b0b9d1 0bdcec80
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000010000040
!	Mem[0000000011000084] = 848a6a52, %l3 = ffffffffdb27a7ef
	ldsha	[%i2+0x086]%asi,%l3	! %l3 = 0000000000006a52
!	Mem[000000001100004c] = 1ba9a7a9, %l3 = 0000000000006a52
	lduwa	[%i2+0x04c]%asi,%l3	! %l3 = 000000001ba9a7a9
!	Mem[0000000011000000] = db27a7ef 75f8fa0e ec8f424a 42473611
!	Mem[0000000011000010] = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	Mem[0000000011000020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000011000030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i2]ASI_BLK_P,%f0	! Block Load from 0000000011000000
!	Mem[0000000012000000] = 5cb7e830, %l0 = 0000000000000026
	lduha	[%i4+%g0]0x80,%l0	! %l0 = 0000000000005cb7

p0_label_59:
!	Mem[0000000071000004] = 1abc27eb, %l7 = b28929f5e61e4204
	ldsh	[%o2+0x004],%l7		! %l7 = 0000000000001abc
!	%f16 = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000100000c0
!	Mem[0000000011000000] = db27a7ef, %l6 = 000000001c34ef4a
	lduha	[%i2+%g0]0x80,%l6	! %l6 = 000000000000db27
!	Mem[00000000110000a8] = 33389d08e9bcf9ad, %l4 = 0000000000007bce
	ldx	[%i2+0x0a8],%l4		! %l4 = 33389d08e9bcf9ad
!	Mem[0000000072000024] = 775e6d70, %l2 = 0000000000003ec3
	lduba	[%o4+0x024]%asi,%g2	! %g2 = 0000000000000077

p0_label_60:
!	%l1 = 00000000000077b1, Mem[00000000100000fc] = 3e2da712
	stw	%l1,[%i0+0x0fc]		! Mem[00000000100000fc] = 000077b1
!	%f1  = 75f8fa0e, %f1  = 75f8fa0e, %f1  = 75f8fa0e
	fsubs	%f1 ,%f1 ,%f1 		! %f1  = 00000000
!	%l0 = 0000000000005cb7, %l1 = 00000000000077b1, %l0 = 0000000000005cb7
	subccc	%l0,%l1,%l0		! %l0 = ffffffffffffe506, %ccr = 99
!	Mem[00000000108000f0] = 04421ee6f52989b2, %l2 = 0000000000003ec3
	ldx	[%i1+0x0f0],%l2		! %l2 = 04421ee6f52989b2
!	Mem[0000000070800004] = 356877b1, %l3 = 000000001ba9a7a9
	lduha	[%o1+0x004]%asi,%l3	! %l3 = 0000000000003568

p0_label_61:
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 295f697e 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040
!	%f16 = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000108000c0
	membar	#Sync			! Added by membar checker (22)
!	Mem[0000000011800040] = 00000000, %l1 = 00000000000077b1
	ldsha	[%i3+0x040]%asi,%l1	! %l1 = 0000000000000000
!	Mem[0000000010800088] = a9a7a91bd3398026, %l5 = 0000000011364742
	ldxa	[%i1+0x088]%asi,%l5	! %l5 = a9a7a91bd3398026
!	%f28 = b28929f5, %f18 = a9a7a91b d3398026
	fstod	%f28,%f18		! %f18 = be51253e a0000000

p0_label_62:
!	Mem[0000000070800004] = 356877b1, %l5 = a9a7a91bd3398026
	lduw	[%o1+0x004],%l5		! %l5 = 00000000356877b1
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000070000000] = fa331446, %l2 = 04421ee6f52989b2
	ldsba	[%o0+0x003]%asi,%l2	! %l2 = 0000000000000046
!	Mem[0000000010000060] = 9d514ec57d6dbb07, %l2 = 0000000000000046
	ldx	[%i0+0x060],%l2		! %l2 = 9d514ec57d6dbb07
!	%f16 = 5c58d14b f1f0a1db be51253e a0000000
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000011800040

p0_label_63:
	bpos	p0_not_taken_0		! Branch Not Taken, %ccr = 99
!	Mem[0000000011000008] = ec8f424a, %l4 = 33389d08e9bcf9ad
	ldsha	[%i2+%o6]0x80,%l4	! %l4 = ffffffffffffec8f
p0_b20:
!	Mem[0000000070800040] = fa331446, %l7 = 0000000000001abc
	lduha	[%o1+0x042]%asi,%l7	! %l7 = 0000000000001446
!	Mem[0000000071000000] = 54af7f611abc27eb, %l3 = 0000000000003568
	ldx	[%o2+0x000],%l3		! %l3 = 54af7f611abc27eb
!	Mem[0000000070000000] = fa331446, %l7 = 0000000000001446
	ldsb	[%o0+0x000],%l7		! %l7 = fffffffffffffffa

p0_label_64:
!	%f16 = 5c58d14b f1f0a1db be51253e a0000000
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000010000040
!	%l1 = 0000000000000000, immed = fffff814, %l5 = 00000000356877b1
	addccc	%l1,-0x7ec,%l5		! %l5 = fffffffffffff815, %ccr = 88
!	Mem[0000000071000040] = 8de109dd3f9d54fe, %l7 = fffffffffffffffa
	ldxa	[%o2+0x040]%asi,%l7	! %l7 = 8de109dd3f9d54fe
!	%f6  = 295f697e 7824dd3e, %f14 = 3a2565b7 7f5aedf0
	fcmped	%fcc1,%f6 ,%f14		! %fcc1 = 1
!	%l1 = 0000000000000000, %l2 = 9d514ec57d6dbb07, %l0 = ffffffffffffe506
	andcc	%l1,%l2,%l0		! %l0 = 0000000000000000, %ccr = 44

p0_label_65:
!	%f16 = 5c58d14b f1f0a1db be51253e a0000000
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i3]ASI_BLK_PL	! Block Store to 0000000011800000
!	%l2 = 9d514ec57d6dbb07, %l4 = ffffffffffffec8f, %l4 = ffffffffffffec8f
	srlx	%l2,%l4,%l4		! %l4 = 00013aa29d8afadb
!	Mem[0000000011000060] = eada4f8021b557be, %l2 = 9d514ec57d6dbb07
	ldxa	[%i2+0x060]%asi,%l2	! %l2 = eada4f8021b557be
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800044] = 9ba8c36b, %l5 = fffffffffffff815
	lduw	[%o3+0x044],%l5		! %l5 = 000000009ba8c36b

p0_label_66:
!	Mem[0000000071000040] = 8de109dd, %f6  = 295f697e
	ld	[%o2+0x040],%f6 	! %f6 = 8de109dd
	membar	#Sync			! Added by membar checker (23)
!	Mem[0000000011800008] = 000000a0, %l1 = 0000000000000000
	lduwa	[%i3+%o6]0x80,%l1	! %l1 = 00000000000000a0
!	%l3 = 54af7f611abc27eb, %l6 = 000000000000db27, %l5 = 000000009ba8c36b
	or	%l3,%l6,%l5		! %l5 = 54af7f611abcffef
!	Mem[0000000011800068] = eb27bc1a617faf54, %l7 = 8de109dd3f9d54fe
	ldxa	[%i3+0x068]%asi,%l7	! %l7 = eb27bc1a617faf54
!	Mem[00000000110000b0] = 3d3849f007bb149c, %l1 = 00000000000000a0
	ldx	[%i2+0x0b0],%l1		! %l1 = 3d3849f007bb149c

p0_label_67:
!	Mem[0000000071800000] = 0000000000007bf4, %l2 = eada4f8021b557be
	ldxa	[%o3+0x000]%asi,%l2	! %l2 = 0000000000007bf4
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000010800040
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i6+%g6]ASI_BLK_PL	! Block Store to 0000000013000040
!	Mem[00000000110000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000110000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000110000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000110000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i2+%g4]ASI_BLK_P,%f0	! Block Load from 00000000110000c0
!	Mem[0000000071800040] = 27aa3ec39ba8c36b, %l5 = 54af7f611abcffef
	ldxa	[%o3+0x040]%asi,%l5	! %l5 = 27aa3ec39ba8c36b

p0_label_68:
!	Mem[0000000070000040] = f67031ea, %l6 = 000000000000db27
	ldswa	[%o0+0x040]%asi,%l6	! %l6 = fffffffff67031ea
!	Mem[0000000011800008] = 000000a0, %l2 = 0000000000007bf4
	ldsha	[%i3+%o6]0x80,%l2	! %l2 = 0000000000000000
!	Mem[0000000070000004] = 3ec3f718, %l3 = 54af7f611abc27eb
	ldsh	[%o0+0x004],%l3		! %l3 = 0000000000003ec3
!	Mem[0000000012800000] = dba1f0f1, %l3 = 0000000000003ec3
	ldswa	[%i5+%g0]0x80,%l3	! %l3 = ffffffffdba1f0f1
!	%f16 = 5c58d14b f1f0a1db be51253e a0000000
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000010000040

p0_label_69:
!	Mem[00000000118000b0] = b28929f5, %l2 = 0000000000000000
	lduwa	[%i3+0x0b0]%asi,%l2	! %l2 = 00000000b28929f5
!	Mem[0000000011800000] = dba1f0f1, %l0 = 0000000000000000
	ldswa	[%i3+%g0]0x80,%l0	! %l0 = ffffffffdba1f0f1
!	Mem[00000000110000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000110000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000110000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000110000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000110000c0
!	Mem[000000007200001c] = 262206e9, %l6 = fffffffff67031ea
	ldsw	[%o4+0x01c],%g2		! %g2 = fffffffff67031ea
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000

p0_label_70:
!	Mem[00000000110000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000110000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000110000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000110000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000110000c0
!	Branch On Register, %l5 = 27aa3ec39ba8c36b
	brlez,pt %l5,p0_not_taken_0	! Branch Not Taken
!	%f24 = eada4f80 21b557be, Mem[0000000011800070] = b28929f5 e61e4204
	std	%f24,[%i3+0x070]	! Mem[0000000011800070] = eada4f80 21b557be
p0_b21:
!	Mem[0000000011800000] = dba1f0f1 4bd1585c 000000a0 3e2551be
!	Mem[0000000011800010] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000011800020] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000011800030] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i3]ASI_BLK_P,%f16	! Block Load from 0000000011800000
	ble	p0_b22			! Branch Taken, %ccr = 44, CWP = 0

p0_label_71:
!	%l2 = 00000000b28929f5, immed = fffff61f, %l0 = ffffffffdba1f0f1
	subccc	%l2,-0x9e1,%l0		! %l0 = 00000000b28933d6, %ccr = 19
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x016,%g2
p0_b22:
	membar	#Sync			! Added by membar checker (24)
!	Mem[0000000010800040] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000010800050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000010800060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000010800070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 0000000010800040
!	Mem[00000000110000c0] = 5c58d14bf1f0a1db, %l4 = 00013aa29d8afadb
	ldxa	[%i2+0x0c0]%asi,%l4	! %l4 = 5c58d14bf1f0a1db
!	Mem[0000000011000000] = db27a7ef, %l0 = 00000000b28933d6
	lduba	[%i2+%g0]0x80,%l0	! %l0 = 00000000000000db
!	Mem[0000000072000000] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000010] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000020] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000030] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p0_label_72:
!	%l5 = 27aa3ec39ba8c36b, Mem[00000000118000b0] = b28929f5
	stb	%l5,[%i3+0x0b0]		! Mem[00000000118000b0] = 6b8929f5
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000010000000] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000010000010] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000010000020] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000010000030] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000010000000
!	Mem[00000000100000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000100000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000100000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000100000f0] = b28929f5 e61e4204 28f2bcf3 000077b1
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 00000000100000c0
!	Mem[00000000108000e8] = eb27bc1a, %l3 = ffffffffdba1f0f1
	ldsw	[%i1+0x0e8],%l3		! %l3 = ffffffffeb27bc1a

p0_label_73:
!	%l6 = fffffffff67031ea, %l4 = 5c58d14bf1f0a1db, %l2 = 00000000b28929f5
	srl	%l6,%l4,%l2		! %l2 = 000000000000001e
!	Mem[00000000108000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000108000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000108000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000108000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 00000000108000c0
!	Mem[0000000011000000] = db27a7ef, %l0 = 00000000000000db
	ldsha	[%i2+%g0]0x80,%l0	! %l0 = ffffffffffffdb27
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080
!	Mem[000000007200000c] = 1ba9a7a9, %l4 = 5c58d14bf1f0a1db
	lduw	[%o4+0x00c],%g2		! %g2 = 5c58d14bf1f0a1db

p0_label_74:
!	Mem[0000000011000058] = cefb2c707e46607c, %l6 = fffffffff67031ea
	ldx	[%i2+0x058],%l6		! %l6 = cefb2c707e46607c
!	Mem[0000000011800008] = 000000a0, %l4 = 5c58d14bf1f0a1db
	lduba	[%i3+%o6]0x80,%l4	! %l4 = 0000000000000000
!	Mem[0000000011800058] = 7c60467e, %l6 = cefb2c707e46607c
	lduwa	[%i3+0x058]%asi,%l6	! %l6 = 000000007c60467e
!	Mem[0000000011800000] = dba1f0f14bd1585c, %l2 = 000000000000001e
	ldxa	[%i3+%g0]0x80,%l2	! %l2 = dba1f0f14bd1585c
!	%f16 = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 000077b1
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000

p0_label_75:
!	%l5 = 27aa3ec39ba8c36b
	setx	0x740b9d46740b9d46,%g7,%l5 ! %l5 = 740b9d46740b9d46
!	Mem[0000000010800010] = 21085407 8e3daae4, %l4 = 00000000, %l5 = 740b9d46
	ldda	[%i1+0x010]%asi,%l4	! %l4 = 0000000021085407 000000008e3daae4
!	%f0  = 5c58d14b f1f0a1db, %f0  = 5c58d14b f1f0a1db, %f0  = 5c58d14b f1f0a1db
	fsubd	%f0 ,%f0 ,%f0 		! %f0  = 00000000 00000000
!	Mem[0000000011000008] = ec8f424a, %l2 = dba1f0f14bd1585c
	lduwa	[%i2+%o6]0x80,%l2	! %l2 = 00000000ec8f424a
!	Mem[0000000010800008] = 18591cb4, %l3 = ffffffffeb27bc1a
	lduha	[%i1+%o6]0x80,%l3	! %l3 = 0000000000001859

p0_label_76:
!	%f16 = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 000077b1
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000011000080
!	Mem[0000000010800000] = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	Mem[0000000010800010] = 21085407 8e3daae4 9efa7fbe 9533880a
!	Mem[0000000010800020] = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	Mem[0000000010800030] = d567ba6e e0c923b5 80ecdc0b d1b9b063
	ldda	[%i1]ASI_BLK_P,%f0	! Block Load from 0000000010800000
!	Mem[0000000011800000] = dba1f0f1, %l1 = 3d3849f007bb149c
	ldswa	[%i3+%g0]0x80,%l1	! %l1 = ffffffffdba1f0f1
!	%f0  = 7bf4e9c1 29ffd4d9 18591cb4 7dddc128
!	%f4  = 21085407 8e3daae4 9efa7fbe 9533880a
!	%f8  = 07bb6d7d c54e519d 06ce0a1a aa61a7e6
!	%f12 = d567ba6e e0c923b5 80ecdc0b d1b9b063
	stda	%f0,[%i1+%g4]ASI_BLK_PL	! Block Store to 00000000108000c0
!	Mem[0000000011000008] = ec8f424a, %l4 = 0000000021085407
	lduha	[%i2+%o6]0x80,%l4	! %l4 = 000000000000ec8f

p0_label_77:
!	Mem[0000000011000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000011000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000011000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000011000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000011000040
!	%l4 = 000000000000ec8f, immed = 00000dd5, %l1 = ffffffffdba1f0f1
	or	%l4,0xdd5,%l1		! %l1 = 000000000000eddf
!	Mem[0000000010000040] = 5c58d14b f1f0a1db be51253e a0000000
!	Mem[0000000010000050] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[0000000010000060] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[0000000010000070] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010000040
!	Mem[0000000010000040] = 5c58d14b, %l1 = 000000000000eddf
	ldub	[%i0+0x042],%l1		! %l1 = 00000000000000d1
!	Mem[00000000100000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000100000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000100000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000100000f0] = b28929f5 e61e4204 28f2bcf3 000077b1
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000100000c0

p0_label_78:
!	Mem[0000000010000008] = 268039d3, %l2 = 00000000ec8f424a
	lduha	[%i0+%o6]0x80,%l2	! %l2 = 0000000000002680
!	Mem[0000000010800040] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000010800050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000010800060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000010800070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010800040
!	Mem[0000000010000008] = 268039d31ba9a7a9, %l0 = ffffffffffffdb27
	ldxa	[%i0+%o6]0x80,%l0	! %l0 = 268039d31ba9a7a9
!	Mem[0000000040a00010] = 3c170304, %l5 = 000000008e3daae4
	ldsb	[%o5+0x011],%l5		! %l5 = 0000000000000017
	fbg	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1

p0_label_79:
!	Mem[0000000010000000] = dba1f0f1, %l5 = 0000000000000017
	lduwa	[%i0+%g0]0x80,%l5	! %l5 = 00000000dba1f0f1
p0_b23:
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = eada4f80 21b557be 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 b1770000 f3bcf228
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 0000000010800000
!	Mem[0000000071800040] = 27aa3ec3, %l6 = 000000007c60467e
	ldsw	[%o3+0x040],%l6		! %l6 = 0000000027aa3ec3
!	Mem[0000000071800040] = 27aa3ec3, %l1 = 00000000000000d1
	ldsw	[%o3+0x040],%l1		! %l1 = 0000000027aa3ec3
	membar	#Sync			! Added by membar checker (25)
!	Mem[0000000010800008] = a9a7a91b, %l5 = 00000000dba1f0f1
	lduwa	[%i1+%o6]0x80,%l5	! %l5 = 00000000a9a7a91b

p0_label_80:
!	Mem[0000000072000030] = 8929f5e6, %l6 = 0000000027aa3ec3
	ldsb	[%o4+0x031],%g2		! %g2 = ffffffffffffff89
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i1]ASI_BLK_P	! Block Store to 0000000010800000
	membar	#Sync			! Added by membar checker (26)
	set	p0_b24,%o7
	fblg,a	p0_far_1_he		! Branch Taken, %fcc0 = 1
!	%l4 = 000000000000ec8f, immed = 000008f1, %l2 = 0000000000002680
	xorcc	%l4,0x8f1,%l2		! %l2 = 000000000000e47e, %ccr = 00
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p0_branch_failed
	mov	0x018,%g2
p0_b24:
!	Registers modified during the branch to p0_far_1
!	%l0  = 0000000000000054
!	%l1  = 000000000000006b
!	%l2  = 00000000000027db
!	%l4  = 0000000000002cb4
!	%l5  = 76fd123c161e942c
!	%f0  = db27a7ef, %f18 = 268039d3
	fcmpes	%fcc2,%f0 ,%f18		! %fcc2 = 1

p0_label_81:
!	Mem[0000000010800000] = db27a7ef 00000000, %l0 = 00000054, %l1 = 0000006b
	ldda	[%i1+%g0]0x80,%l0	! %l0 = 00000000db27a7ef 0000000000000000
!	Mem[0000000071800040] = 27aa3ec3, %l7 = eb27bc1a617faf54
	lduha	[%o3+0x042]%asi,%l7	! %l7 = 0000000000003ec3
!	Mem[00000000110000dc] = 702cfbce, %l2 = 00000000000027db
	ldub	[%i2+0x0df],%l2		! %l2 = 00000000000000ce
!	Mem[0000000071800004] = 00007bf4, %l5 = 76fd123c161e942c
	lduha	[%o3+0x006]%asi,%l5	! %l5 = 0000000000007bf4
!	%f13 = 31619def, %f13 = 31619def, %f17 = 4bd1585c
	fdivs	%f13,%f13,%f17		! %f17 = 3f800000

p0_label_82:
!	Mem[0000000070000000] = fa3314463ec3f718, %l7 = 0000000000003ec3
	ldx	[%o0+0x000],%l7		! %l7 = fa3314463ec3f718
!	%l6 = 0000000027aa3ec3, immed = fffff2d7, %l0 = 00000000db27a7ef
	add	%l6,-0xd29,%l0		! %l0 = 0000000027aa319a
!	Mem[0000000011800008] = 000000a0, %l5 = 0000000000007bf4
	ldsba	[%i3+%o6]0x80,%l5	! %l5 = 0000000000000000
!	%l4 = 0000000000002cb4, immed = 000002e7, %y  = 4ea1aaaf
	udiv	%l4,0x2e7,%l2		! %l2 = 00000000ffffffff
	mov	%l0,%y			! %y = 27aa319a
!	Mem[0000000010800040] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000010800050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000010800060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000010800070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010800040

p0_label_83:
!	Mem[0000000072000020] = be57b521804fdaea, %l7 = fa3314463ec3f718
	ldx	[%o4+0x020],%g2		! %g2 = be57b521804fdaea
!	Mem[0000000070000000] = fa3314463ec3f718, %l2 = 00000000ffffffff
	ldx	[%o0+0x000],%l2		! %l2 = fa3314463ec3f718
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000070000040] = f67031ea, %l7 = fa3314463ec3f718
	lduh	[%o0+0x042],%l7		! %l7 = 00000000000031ea
!	Mem[0000000011800080] = 5c58d14b, %l6 = 0000000027aa3ec3
	ldswa	[%i3+0x080]%asi,%l6	! %l6 = 000000005c58d14b

p0_label_84:
!	Mem[0000000010800008] = ec8f424a, %l7 = 00000000000031ea
	ldswa	[%i1+%o6]0x80,%l7	! %l7 = ffffffffec8f424a
!	Mem[0000000071000040] = 8de109dd, %l0 = 0000000027aa319a
	lduw	[%o2+0x040],%l0		! %l0 = 000000008de109dd
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000100000c0
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000110000c0
!	Mem[0000000011800008] = 000000a0, %l0 = 000000008de109dd
	ldsha	[%i3+%o6]0x80,%l0	! %l0 = 0000000000000000

p0_label_85:
!	%l7 = ffffffffec8f424a, %l0 = 0000000000000000, %l7 = ffffffffec8f424a
	subccc	%l7,%l0,%l7		! %l7 = ffffffffec8f424a, %ccr = 88
!	Mem[0000000010800020] = 7fef0172, %l4 = 0000000000002cb4
	ldswa	[%i1+0x020]%asi,%l4	! %l4 = 000000007fef0172
!	Mem[0000000011800000] = dba1f0f1, %l2 = fa3314463ec3f718
	ldsba	[%i3+%g0]0x80,%l2	! %l2 = ffffffffffffffdb
!	Mem[0000000071800040] = 27aa3ec39ba8c36b, %l1 = 0000000000000000
	ldx	[%o3+0x040],%l1		! %l1 = 27aa3ec39ba8c36b
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000010000040

p0_label_86:
	membar	#Sync			! Added by membar checker (27)
!	Branch On Register, %l2 = ffffffffffffffdb
	brlz,a,pn %l2,p0_b25		! Branch Taken
!	Mem[0000000070000040] = f67031ea e3f5d882, %l0 = 00000000, %l1 = 9ba8c36b
	ldd	[%o0+0x040],%l0		! %l0 = 00000000f67031ea 00000000e3f5d882
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p0_branch_failed
	mov	0x019,%g2
p0_b25:
	bneg	p0_b26			! Branch Taken, %ccr = 88, CWP = 0
!	Mem[0000000071000044] = 3f9d54fe, %l1 = 00000000e3f5d882
	lduh	[%o2+0x046],%l1		! %l1 = 00000000000054fe
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x01a,%g2
p0_b26:
!	Mem[0000000011000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000011000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000011000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000011000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000011000040

p0_label_87:
!	Mem[0000000010000080] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000010000090] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000100000a0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000100000b0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000010000080
!	Mem[0000000010000000] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000010000010] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000010000020] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000010000030] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i0]ASI_BLK_P,%f0	! Block Load from 0000000010000000
!	Mem[00000000110000bc] = 000077b1, %f29 = e61e4204
	ld	[%i2+0x0bc],%f29	! %f29 = 000077b1
!	Mem[0000000011000000] = db27a7ef 75f8fa0e, %l4 = 7fef0172, %l5 = 00000000
	ldda	[%i2+%g0]0x80,%l4	! %l4 = 00000000db27a7ef 0000000075f8fa0e
!	Mem[0000000010800008] = ec8f424a 42473611, %l2 = ffffffdb, %l3 = 00001859
	ldda	[%i1+%o6]0x80,%l2	! %l2 = 00000000ec8f424a 0000000042473611

p0_label_88:
!	%l3 = 0000000042473611, %l4 = 00000000db27a7ef, %l7 = ffffffffec8f424a
	subc	%l3,%l4,%l7		! %l7 = ffffffff671f8e22
!	Mem[0000000072000028] = 7dae5a86 2247f7cb, %l0 = f67031ea, %l1 = 000054fe
	ldda	[%o4+0x028]%asi,%g2	! %l0 = 00000000f67031ea 00000000000054fe
!	Mem[0000000072000048] = ec8f424a42473611, %l7 = ffffffff671f8e22
	ldx	[%o4+0x048],%g2		! %g2 = ec8f424a42473611
!	Mem[0000000010800000] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[0000000010800010] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000010800020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000010800030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000010800000
	bvc,a	p0_b27			! Branch Taken, %ccr = 88, CWP = 0

p0_label_89:
!	Mem[0000000070000040] = f67031ea, %l0 = 00000000f67031ea
	ldsw	[%o0+0x040],%l0		! %l0 = fffffffff67031ea
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p0_branch_failed
	mov	0x01b,%g2
p0_b27:
	bg,a	p0_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[0000000012000008] = 735294ee943a858d, %l1 = 00000000000054fe
	ldxa	[%i4+%o6]0x80,%l1	! Annulled
p0_b28:
!	%f12 = 04421ee6 f52989b2, %f4  = 2c941e16 3c12fd76
	fcmpd	%fcc0,%f12,%f4 		! %fcc0 = 1
!	Mem[0000000070800044] = 3ec3f718, %l5 = 0000000075f8fa0e
	ldsha	[%o1+0x046]%asi,%l5	! %l5 = fffffffffffff718

p0_label_90:
!	Mem[00000000118000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000118000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000118000c0
!	%l3 = 0000000042473611, %l1 = 00000000000054fe, %l4 = 00000000db27a7ef
	addc	%l3,%l1,%l4		! %l4 = 0000000042478b0f
!	Mem[00000000110000fe] = b765253a, %l0 = fffffffff67031ea
	ldstub	[%i2+0x0fe],%l0		! %l0 = 0000000000000025
!	%f0  = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f4  = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f8  = eada4f80 21b557be 54af7f61 1abc27eb
!	%f12 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 00000000118000c0
!	Mem[0000000072000000] = 02111a02 51dbb492 edf20442 d9184976
!	Mem[0000000072000010] = 0772388c fb9bdcc4 82e96b54 262206e9
!	Mem[0000000072000020] = 2d1a7e7d 775e6d70 7dae5a86 2247f7cb
!	Mem[0000000072000030] = d1006ccb 06b93e5b 4b250c8d 011dda34
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p0_label_91:
!	%f10 = 54af7f61 1abc27eb, %f24 = eada4f80 21b557be
	fnegd	%f10,%f24		! %f24 = d4af7f61 1abc27eb
!	Jump to jmpl_1, CWP = 0
	membar	#Sync			! Added by membar checker (28)
	set	p0_jmpl_1_he,%g1
	jmpl	%g1,%g6
!	Mem[0000000011000000] = db27a7ef, %l7 = ffffffff671f8e22
	lduha	[%i2+%g0]0x80,%l7	! %l7 = 000000000000db27
!	Registers modified during the branch to p0_jmpl_1
!	%l1  = 0000000017163452
!	%l4  = ffffffffffffffdd
!	%l5  = 00000000000000bc
!	%l6  = 00000009944ad075
!	Mem[0000000010000060] = 7fef0172 4aef341c f18b40d9 d155a333
	prefetcha [%i0+0x060]%asi,22
!	Mem[0000000070000040] = f67031ea, %l3 = 0000000042473611
	ldsw	[%o0+0x040],%l3		! %l3 = fffffffff67031ea

p0_label_92:
!	Mem[0000000011000000] = db27a7ef, %l0 = 0000000000000025
	lduba	[%i2+%g0]0x80,%l0	! %l0 = 00000000000000db
	fbuge,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000070000044] = e3f5d882, %l5 = 00000000000000bc
	lduw	[%o0+0x044],%l5		! Annulled
p0_b29:
!	Mem[0000000011000008] = ec8f424a 42473611, %l4 = ffffffdd, %l5 = 000000bc
	ldda	[%i2+%o6]0x80,%l4	! %l4 = 00000000ec8f424a 0000000042473611
!	%f16 = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f20 = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f24 = d4af7f61 1abc27eb 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000110000c0

p0_label_93:
!	Mem[0000000010800000] = db27a7ef, %l3 = fffffffff67031ea
	lduba	[%i1+%g0]0x80,%l3	! %l3 = 00000000000000db
!	%f0  = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f4  = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f8  = eada4f80 21b557be 54af7f61 1abc27eb
!	%f12 = 04421ee6 f52989b2 12a72d3e f3bcf228
	mov	0x040,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000010000040
!	%l3 = 00000000000000db, %l2 = 00000000ec8f424a, %l5 = 0000000042473611
	sllx	%l3,%l2,%l5		! %l5 = 0000000000036c00
!	Mem[00000000100000e8] = f18b40d9, %l1 = 0000000017163452
	lduw	[%i0+0x0e8],%l1		! %l1 = 00000000f18b40d9
!	Mem[0000000071800044] = 9ba8c36b, %l3 = 00000000000000db
	ldub	[%o3+0x045],%l3		! %l3 = 00000000000000a8

p0_label_94:
	membar	#Sync
	fbg,pt	%fcc1,p0_branch_failed	! Branch Not Taken, %fcc1 = 1
!	Mem[0000000072000060] = 7fef01724aef341c, %l5 = 0000000000036c00
	ldx	[%o4+0x060],%g2		! %g2 = 7fef01724aef341c
p0_b30:
!	%l0 = 00000000000000db, immed = 0000002a, %l6 = 00000009944ad075
	sllx	%l0,0x02a,%l6		! %l6 = 00036c0000000000
!	%f13 = f52989b2, %f29 = f52989b2, %f11 = 1abc27eb
	fadds	%f13,%f29,%f11		! %f11 = f5a989b2
!	%f0  = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f4  = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f8  = eada4f80 21b557be 54af7f61 f5a989b2
!	%f12 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f0,[%i5]ASI_BLK_PL	! Block Store to 0000000012800000

p0_label_95:
!	Mem[00000000108000fc] = 0bdcec80, %l4 = 00000000ec8f424a
	ldsw	[%i1+0x0fc],%l4		! %l4 = 000000000bdcec80
!	Mem[0000000010800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000010800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000108000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000108000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 0000000010800080
!	%f0  = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f4  = 76fd123c 161e942c 7c60467e 702cfbce
!	%f8  = be57b521 804fdaea eb27bc1a 617faf54
!	%f12 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000100000c0
!	%f30 = 12a72d3e f3bcf228, %f30 = 12a72d3e f3bcf228, %f20 = 2c941e16 3c12fd76
	faddd	%f30,%f30,%f20		! %f20 = 12b72d3e f3bcf228
!	Mem[0000000010800000] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[0000000010800010] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000010800020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000010800030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i1]ASI_BLK_PL,%f0	! Block Load from 0000000010800000

p0_label_96:
	membar	#Sync			! Added by membar checker (29)
!	%l1 = 00000000f18b40d9, Mem[0000000010800000] = db27a7ef
	stha	%l1,[%i1+%g0]0x80	! Mem[0000000010800000] = 40d9a7ef
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[0000000072000040] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[0000000072000050] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000072000060] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000072000070] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000010000040
	bl,a	p0_b31			! Branch Taken, %ccr = 88, CWP = 0

p0_label_97:
!	%f16 = dba1f0f1, %f16 = dba1f0f1, %f19 = 1ba9a7a9
	fdivs	%f16,%f16,%f19		! %f19 = 3f800000
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x01f,%g2
p0_b31:
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000011000080
!	%f24 = d4af7f61 1abc27eb, %f26 = 54af7f61 1abc27eb, %f18 = 268039d3 3f800000
	fsubd	%f24,%f26,%f18		! %f18 = d4bf7f61 1abc27eb
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000010000080
!	Mem[00000000118000e0] = eada4f8021b557be, %l7 = 000000000000db27, %l2 = 00000000ec8f424a
	add	%i3,0xe0,%g1
	casxa	[%g1]0x80,%l7,%l2	! %l2 = eada4f8021b557be

p0_label_98:
!	Branch On Register, %l0 = 00000000000000db
	brlez,pt %l0,p0_not_taken_0	! Branch Not Taken
!	Mem[0000000011800008] = 000000a0, %l3 = 00000000000000a8
	lduba	[%i3+%o6]0x80,%l3	! %l3 = 0000000000000000
p0_b32:
!	Mem[00000000118000d8] = cefb2c70 7e46607c, %l0 = 000000db, %l1 = f18b40d9
	ldd	[%i3+0x0d8],%l0		! %l0 = 00000000cefb2c70 000000007e46607c
!	Mem[00000000118000bc] = 3e2da712, %l4 = 000000000bdcec80
	lduwa	[%i3+0x0bc]%asi,%l4	! %l4 = 000000003e2da712
!	%l5 = 0000000000036c00, immed = fffff26f, %l1 = 000000007e46607c
	taddcc	%l5,-0xd91,%l1		! %l1 = 0000000000035e6f, %ccr = 13

p0_label_99:
	ba,a	p0_b33			! Branch Taken, %ccr = 13, CWP = 0
!	 Annulled
	ldd	[%i1+0x0e8],%l2
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p0_branch_failed
	mov	0x021,%g2
p0_b33:
!	%l6 = 00000000, %l7 = 0000db27, Mem[0000000011000008] = ec8f424a 42473611
	stda	%l6,[%i2+%o6]0x80	! Mem[0000000011000008] = 00000000 0000db27
!	Mem[0000000011000000] = db27a7ef, %l3 = 0000000000000000
	lduwa	[%i2+%g0]0x80,%l3	! %l3 = 00000000db27a7ef
	membar	#Sync			! Added by membar checker (30)
!	Branch On Register, %l7 = 000000000000db27
	brgez,pt %l7,p0_b34		! Branch Taken

p0_label_100:
!	Mem[0000000011800008] = 000000a0, %l2 = eada4f8021b557be
	lduha	[%i3+%o6]0x80,%l2	! %l2 = 0000000000000000
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p0_branch_failed
	mov	0x022,%g2
p0_b34:
	set	p0_b35,%o7
	fbule,a	p0_far_1_he		! Branch Taken, %fcc0 = 1
!	Mem[0000000011000000] = db27a7ef, %l0 = 00000000cefb2c70
	ldsba	[%i2+%g0]0x80,%l0	! %l0 = ffffffffffffffdb
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p0_branch_failed
	mov	0x023,%g2
p0_b35:
!	Registers modified during the branch to p0_far_1
!	%l0  = ffffffffffffffeb
!	%l1  = 000000000000006b
!	%l2  = 00000000000027db
!	%l4  = 0000000000002cb4
!	%l5  = 2c941e163c12fd76
!	%f16 = dba1f0f1 4bd1585c d4bf7f61 1abc27eb
!	%f20 = 12b72d3e f3bcf228 cefb2c70 7e46607c
!	%f24 = d4af7f61 1abc27eb 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000110000c0
!	%f16 = dba1f0f1 4bd1585c d4bf7f61 1abc27eb
!	%f20 = 12b72d3e f3bcf228 cefb2c70 7e46607c
!	%f24 = d4af7f61 1abc27eb 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000011000000

p0_label_101:
	membar	#Sync			! Added by membar checker (31)
!	Mem[0000000011000000] = 5c58d14b, %l0 = ffffffffffffffeb
	ldsba	[%i2+%g0]0x80,%l0	! %l0 = 000000000000005c

	ba,a	p0_not_taken_0_end
p0_not_taken_0:
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba,a	p0_branch_failed
p0_not_taken_0_end:

!	Mem[0000000011800000] = dba1f0f1, %l4 = 0000000000002cb4
	lduwa	[%i3+%g0]0x80,%l4	! %l4 = 00000000dba1f0f1
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i1]ASI_BLK_P	! Block Store to 0000000010800000
!	%f17 = 4bd1585c, %f19 = 1abc27eb, %f22 = cefb2c70 7e46607c
	fsmuld	%f17,%f19,%f22		! %f22 = 3ce33bb1 06440e80
!	Mem[0000000011800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000011800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000b0] = 6b8929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000011800080

p0_label_102:
!	%l6 = 00036c0000000000, %l3 = 00000000db27a7ef, %l0 = 000000000000005c
	xnorcc	%l6,%l3,%l0		! %l0 = fffc93ff24d85810, %ccr = 80
!	Mem[0000000011000080] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000011000090] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000110000a0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000110000b0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000011000080
!	%l4 = 00000000dba1f0f1, immed = fffff193, %l0 = fffc93ff24d85810
	xnorcc	%l4,-0xe6d,%l0		! %l0 = 00000000dba1fe9d, %ccr = 08
	fbe	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000013000008] = ec8f424a, %l3 = 00000000db27a7ef
	ldsha	[%i6+%o6]0x80,%l3	! %l3 = ffffffffffffec8f
p0_b36:

p0_label_103:
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000011000040
!	Mem[0000000072000050] = 3b8cde8a, %l7 = 000000000000db27
	ldsba	[%o4+0x051]%asi,%g2	! %g2 = 000000000000003b
!	Mem[0000000071000000] = 54af7f61 1abc27eb, %l0 = dba1fe9d, %l1 = 0000006b
	ldd	[%o2+0x000],%l0		! %l0 = 0000000054af7f61 000000001abc27eb
!	Mem[00000000100000fc] = 3e2da712, %l3 = ffffffffffffec8f
	ldsba	[%i0+0x0fd]%asi,%l3	! %l3 = 000000000000002d
!	Mem[0000000013000078] = f0ed5a7fb765253a, %l5 = 2c941e163c12fd76
	ldxa	[%i6+0x078]%asi,%l5	! %l5 = f0ed5a7fb765253a

p0_label_104:
!	Mem[0000000011800078] = 28f2bcf3 3e2da712, %l6 = 00000000, %l7 = 0000db27
	ldd	[%i3+0x078],%l6		! %l6 = 0000000028f2bcf3 000000003e2da712
!	%f16 = dba1f0f1 4bd1585c d4bf7f61 1abc27eb
!	%f20 = 12b72d3e f3bcf228 3ce33bb1 06440e80
!	%f24 = d4af7f61 1abc27eb 54af7f61 1abc27eb
!	%f28 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000011000080
!	Mem[0000000072000048] = ec8f424a42473611, %l6 = 0000000028f2bcf3
	ldx	[%o4+0x048],%g2		! %g2 = ec8f424a42473611
!	Mem[0000000040a00010] = 3c1703042e2e3a3d, %l4 = 00000000dba1f0f1
	ldx	[%o5+0x010],%l4		! %l4 = 3c1703042e2e3a3d
!	Mem[0000000011800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000011800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000118000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000118000b0] = 6b8929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000011800080

p0_label_105:
	membar	#Sync			! Added by membar checker (32)
!	%f0  = db27a7ef 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000011000080
!	Mem[0000000010800070] = ef9d6131, %l5 = f0ed5a7fb765253a
	lduh	[%i1+0x072],%l5		! %l5 = 0000000000006131
	membar	#Sync			! Added by membar checker (33)
!	Mem[0000000011000080] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000011000090] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000110000a0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000110000b0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000011000080
!	Mem[0000000011800008] = 000000a0, %l3 = 000000000000002d
	lduba	[%i3+%o6]0x80,%l3	! %l3 = 0000000000000000
!	Mem[00000000118000c8] = 268039d3, %l7 = 000000003e2da712
	ldswa	[%i3+0x0c8]%asi,%l7	! %l7 = 00000000268039d3

p0_label_106:
!	Mem[0000000072000040] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[0000000072000050] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000072000060] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000072000070] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[00000000118000c0] = dba1f0f1, %l7 = 00000000268039d3
	lduw	[%i3+0x0c0],%l7		! %l7 = 00000000dba1f0f1
!	Mem[0000000011000000] = 5c58d14b f1f0a1db, %l0 = 54af7f61, %l1 = 1abc27eb
	ldda	[%i2+%g0]0x80,%l0	! %l0 = 000000005c58d14b 00000000f1f0a1db
!	%l7 = 00000000dba1f0f1, Mem[0000000070800040] = fa3314463ec3f718
	stxa	%l7,[%o1+0x040]%asi	! Mem[0000000070800040] = 00000000dba1f0f1
!	%f9  = 4aef341c, %f2  = ec8f424a
	fstoi	%f9 ,%f2 		! %f2  = 00779a0e

p0_label_107:
!	Mem[0000000011800008] = 000000a0, %l4 = 3c1703042e2e3a3d
	lduwa	[%i3+%o6]0x80,%l4	! %l4 = 00000000000000a0
!	%f16 = 00000000 efa727db 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000108000c0
!	Mem[0000000071000044] = 3f9d54fe, %l7 = 00000000dba1f0f1
	ldsba	[%o2+0x045]%asi,%l7	! %l7 = ffffffffffffff9d
!	%f16 = 00000000 efa727db 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000118000c0
!	%f10 = f18b40d9 d155a333, %f14 = 3a2565b7 7f5aedf0
	fcmpd	%fcc3,%f10,%f14		! %fcc3 = 1

p0_label_108:
!	Mem[0000000071000004] = 1abc27eb, %l0 = 000000005c58d14b
	ldsba	[%o2+0x006]%asi,%l0	! %l0 = 0000000000000027
!	Mem[0000000072000000] = 92b4db51 021a1102, %l6 = 28f2bcf3, %l7 = ffffff9d
	ldda	[%o4+0x000]%asi,%g2	! %l6 = 0000000028f2bcf3 ffffffffffffff9d
!	Mem[0000000070000000] = fa3314463ec3f718, %l4 = 00000000000000a0
	ldx	[%o0+0x000],%l4		! %l4 = fa3314463ec3f718
!	%f0  = db27a7ef 00000000 00779a0e 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080
	membar	#Sync
	set	p0_b37,%o7
	fba,pt	%fcc2,p0_near_1_he	! Branch Taken, %fcc2 = 1

p0_label_109:
!	Mem[0000000070000040] = f67031eae3f5d882, %l2 = 00000000000027db
	ldx	[%o0+0x040],%l2		! %l2 = f67031eae3f5d882
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x025,%g2
p0_b37:
!	Registers modified during the branch to p0_near_1
!	%l4  = 000000008de109dd
!	%l5  = 000000003f9d54fe
!	%l7  = fbbfde573ecbf77d
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	%f0  = db27a7ef 00000000 00779a0e 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000011800080
!	Mem[0000000010800044] = efa727db, %l1 = 00000000f1f0a1db
	lduw	[%i1+0x044],%l1		! %l1 = 00000000efa727db
!	Mem[0000000072000000] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000010] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000020] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000030] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000

p0_label_110:
!	Mem[00000000100000f8] = 28f2bcf3, %l0 = 0000000000000027
	ldub	[%i0+0x0fa],%l0		! %l0 = 00000000000000bc
!	Mem[0000000011000000] = 5c58d14b, %l4 = 000000008de109dd
	ldsba	[%i2+%g0]0x80,%l4	! %l4 = 000000000000005c
!	Mem[00000000100000c0] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[00000000100000d0] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000100000e0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000100000f0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 00000000100000c0
!	Mem[0000000010800030] = ef9d61314f759486, %l1 = 00000000efa727db
	ldxa	[%i1+0x030]%asi,%l1	! %l1 = ef9d61314f759486
!	Mem[0000000010000000] = dba1f0f14bd1585c, %l5 = 000000003f9d54fe
	ldxa	[%i0+%g0]0x80,%l5	! %l5 = dba1f0f14bd1585c

p0_label_111:
!	%l0 = 00000000000000bc, Mem[0000000010800000] = 00000000efa727db
	stxa	%l0,[%i1+%g0]0x80	! Mem[0000000010800000] = 00000000000000bc
	membar	#Sync			! Added by membar checker (34)
!	%f16 = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000010000054] = de8c3bef, %l4 = 000000000000005c
	ldub	[%i0+0x054],%l4		! %l4 = 00000000000000de
!	Mem[0000000011000088] = 11364742, %l5 = dba1f0f14bd1585c
	ldsba	[%i2+0x089]%asi,%l5	! %l5 = 0000000000000036
!	Mem[0000000011800000] = dba1f0f1, %l2 = f67031eae3f5d882
	ldswa	[%i3+%g0]0x80,%l2	! %l2 = ffffffffdba1f0f1

p0_label_112:
!	Mem[0000000011800090] = ef3b8cde8aaf6feb, %l4 = 00000000000000de
	ldx	[%i3+0x090],%l4		! %l4 = ef3b8cde8aaf6feb
!	%l5 = 0000000000000036, %l2 = ffffffffdba1f0f1, %l6 = 0000000028f2bcf3
	sll	%l5,%l2,%l6		! %l6 = 00000000006c0000
!	%l4 = ef3b8cde8aaf6feb, %l4 = ef3b8cde8aaf6feb, %y  = 27aa319a
	udiv	%l4,%l4,%l4		! %l4 = 000000004937af5b
	mov	%l0,%y			! %y = 000000bc
!	Mem[0000000011000000] = 5c58d14b, %l5 = 0000000000000036
	lduwa	[%i2+%g0]0x80,%l5	! %l5 = 000000005c58d14b
!	Mem[0000000010000000] = dba1f0f1, %l1 = ef9d61314f759486
	lduha	[%i0+%g0]0x80,%l1	! %l1 = 000000000000dba1

p0_label_113:
!	Mem[0000000070800040] = 00000000dba1f0f1, %l4 = 000000004937af5b
	ldx	[%o1+0x040],%l4		! %l4 = 00000000dba1f0f1
!	%l0 = 00000000000000bc, immed = 00000008, %l7 = fbbfde573ecbf77d
	srl	%l0,0x008,%l7		! %l7 = 0000000000000000
	membar	#Sync			! Added by membar checker (35)
	set	p0_b38,%o7
	fbne,a,pn %fcc1,p0_near_3_le	! Branch Taken, %fcc1 = 1
!	Mem[0000000011000064] = 7201ef7f, %l0 = 00000000000000bc
	ldsh	[%i2+0x066],%l0		! %l0 = ffffffffffffef7f
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x026,%g2
p0_b38:
!	Registers modified during the branch to p0_near_3
!	%l2  = 0000000000000000
!	%l7  = 00000000000029f5
!	%f16 = 5c58d14b f1f0a1db a9a7a91b d3398026
!	%f20 = 76fd123c 161e942c 7c60467e 702cfbce
!	%f24 = be57b521 804fdaea eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000110000c0

p0_label_114:
!	Mem[0000000071000004] = 1abc27eb, %l2 = 0000000000000000
	ldswa	[%o2+0x004]%asi,%l2	! %l2 = 000000001abc27eb
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000010000048] = 113647424a428fec, %l3 = 0000000000000000
	ldx	[%i0+0x048],%l3		! %l3 = 113647424a428fec
!	Mem[0000000070000000] = fa331446 3ec3f718, %l4 = dba1f0f1, %l5 = 5c58d14b
	ldda	[%o0+0x000]%asi,%l4	! %l4 = 00000000fa331446 000000003ec3f718
!	Mem[0000000011000008] = eb27bc1a, %l5 = 000000003ec3f718
	ldswa	[%i2+%o6]0x80,%l5	! %l5 = ffffffffeb27bc1a

p0_label_115:
!	Mem[0000000011000008] = eb27bc1a, %l7 = 00000000000029f5
	lduha	[%i2+%o6]0x80,%l7	! %l7 = 000000000000eb27
!	Mem[0000000013000000] = db27a7ef75f8fa0e, %l3 = 113647424a428fec
	ldx	[%i6+0x000],%l3		! %l3 = db27a7ef75f8fa0e
!	Mem[0000000010000040] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000010000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000010000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000010000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010000040
!	Mem[0000000011000000] = 5c58d14b f1f0a1db eb27bc1a 617fbfd4
!	Mem[0000000011000010] = 28f2bcf3 3e2db712 7c60467e 702cfbce
!	Mem[0000000011000020] = eb27bc1a 617fafd4 eb27bc1a 617faf54
!	Mem[0000000011000030] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i2]ASI_BLK_P,%f0	! Block Load from 0000000011000000
!	Mem[0000000011800008] = 000000a0 3e2551be, %l4 = fa331446, %l5 = eb27bc1a
	ldda	[%i3+%o6]0x80,%l4	! %l4 = 00000000000000a0 000000003e2551be

p0_label_116:
!	Mem[0000000010800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000010800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000108000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000108000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000010800080
!	Branch On Register, %l2 = 000000001abc27eb
	brlz,a,pt %l2,p0_not_taken_0	! Branch Not Taken
!	 Annulled
	fnegd	%f26,%f22
p0_b39:
!	Mem[0000000011000008] = eb27bc1a 617fbfd4, %l6 = 006c0000, %l7 = 0000eb27
	ldda	[%i2+%o6]0x80,%l6	! %l6 = 00000000eb27bc1a 00000000617fbfd4
!	Mem[0000000012000008] = 735294ee, %l0 = ffffffffffffef7f
	ldsba	[%i4+%o6]0x80,%l0	! %l0 = 0000000000000073

p0_label_117:
!	Mem[0000000070000004] = 3ec3f718, %l7 = 00000000617fbfd4
	lduw	[%o0+0x004],%l7		! %l7 = 000000003ec3f718
!	Mem[0000000011800008] = 000000a0, %l5 = 000000003e2551be
	lduba	[%i3+%o6]0x80,%l5	! %l5 = 0000000000000000
!	Mem[0000000010800000] = 00000000, %l6 = 00000000eb27bc1a
	lduba	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000000
!	Mem[0000000071800044] = 9ba8c36b, %l3 = db27a7ef75f8fa0e
	ldswa	[%o3+0x044]%asi,%l3	! %l3 = ffffffff9ba8c36b
!	%l6 = 0000000000000000, %l6 = 0000000000000000, %l1 = 000000000000dba1
	sllx	%l6,%l6,%l1		! %l1 = 0000000000000000

p0_label_118:
!	Mem[0000000072000000] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000010] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000020] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000030] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	%l1 = 0000000000000000, immed = 0000000a, %y  = 000000bc
	umulcc	%l1,0x00a,%l7		! %l7 = 0000000000000000, %ccr = 44
!	Mem[0000000010000014] = 3c12fd76, %l3 = ffffffff9ba8c36b
	ldsh	[%i0+0x014],%l3		! %l3 = 0000000000003c12
!	Mem[0000000010800000] = 00000000, %l6 = 0000000000000000
	ldsba	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000000
	membar	#Sync			! Added by membar checker (36)
	set	p0_b40,%o7
	fbo	p0_far_3_le		! Branch Taken, %fcc0 = 1

p0_label_119:
!	Mem[0000000010000038] = 12a72d3e, %l2 = 000000001abc27eb
	lduw	[%i0+0x038],%l2		! %l2 = 0000000012a72d3e
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p0_branch_failed
	mov	0x028,%g2
p0_b40:
!	Registers modified during the branch to p0_far_3
!	%l0  = 00000000dba1f0f1
!	%l4  = 8de109dd3f9d54fe
!	%l6  = ef3b8cde8aaf6feb
!	%l7  = 00000000031cdec8
!	Mem[0000000010000008] = 268039d3, %l2 = 0000000012a72d3e
	ldstuba	[%i0+%o6]0x80,%l2	! %l2 = 0000000000000026
!	Mem[0000000070000004] = 3ec3f718, %l3 = 0000000000003c12
	ldsba	[%o0+0x007]%asi,%l3	! %l3 = 0000000000000018
!	Mem[0000000010000008] = ff8039d3, %l4 = 8de109dd3f9d54fe
	ldsha	[%i0+%o6]0x80,%l4	! %l4 = ffffffffffffff80
!	Mem[00000000118000a8] = f18b40d9, %l1 = 0000000000000000
	ldub	[%i3+0x0a8],%l1		! %l1 = 00000000000000f1

p0_label_120:
!	Mem[0000000070000000] = fa3314463ec3f718, %l7 = 00000000031cdec8
	ldx	[%o0+0x000],%l7		! %l7 = fa3314463ec3f718
	fbe,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000071800044] = 9ba8c36b, %l4 = ffffffffffffff80
	lduh	[%o3+0x044],%l4		! Annulled
p0_b41:
!	%f0  = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	%f4  = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	%f8  = eada4f80 21b557be 54af7f61 1abc27eb
!	%f12 = 04421ee6 f52989b2 12a72d3e f3bcf228
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000100000c0
	fbge,a,pn %fcc2,p0_branch_failed	! Branch Not Taken, %fcc2 = 1

p0_label_121:
!	Mem[000000001000008c] = 0e9a7700, %l0 = 00000000dba1f0f1
	ldsw	[%i0+0x08c],%l0		! Annulled
p0_b42:
!	Mem[0000000071800000] = 00000000, %l2 = 0000000000000026
	ldsh	[%o3+0x000],%l2		! %l2 = 0000000000000000
!	Mem[0000000010800000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000010800010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000010800020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000010800030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000010800000
!	Mem[00000000118000c0] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000e0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000f0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000118000c0
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000011000080

p0_label_122:
!	%f16 = bc000000 00000000 ec8f424a 42473611
!	%f20 = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000011000040
	membar	#Sync
	set	p0_b43,%o7
	fbne,pt	%fcc3,p0_near_3_le	! Branch Taken, %fcc3 = 1
!	%l0 = 00000000dba1f0f1, immed = 00000007, %l2 = 0000000000000000
	srlx	%l0,0x007,%l2		! %l2 = 0000000001b743e1
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x02b,%g2
p0_b43:
!	Registers modified during the branch to p0_near_3
!	%l2  = 0000000000000000
!	%l7  = 0000000000001ee6
!	%f19 = 42473611, %f24 = 7fef0172, %f30 = 3a2565b7 7f5aedf0
	fsmuld	%f19,%f24,%f30		! %f30 = 7ffde02e 40000000
!	Mem[00000000108000c0] = 00000000 efa727db 11364742 4a428fec
!	Mem[00000000108000d0] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000108000e0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000108000f0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1+%g4]ASI_BLK_P,%f16	! Block Load from 00000000108000c0

p0_label_123:
!	Mem[00000000108000d0] = eb6faf8ade8c3bef, %l2 = 0000000000000000
	ldx	[%i1+0x0d0],%l2		! %l2 = eb6faf8ade8c3bef
!	Mem[00000000100000f0] = 04421ee6f52989b2, %l6 = ef3b8cde8aaf6feb
	ldx	[%i0+0x0f0],%l6		! %l6 = 04421ee6f52989b2
!	Mem[0000000011800008] = 000000a03e2551be, %l6 = 04421ee6f52989b2
	ldx	[%i3+0x008],%l6		! %l6 = 000000a03e2551be
!	Mem[0000000010000080] = 00000000efa727db, %l6 = 000000a03e2551be
	ldx	[%i0+0x080],%l6		! %l6 = 00000000efa727db
	bge	p0_b44			! Branch Taken, %ccr = 44, CWP = 0

p0_label_124:
!	Mem[0000000010800008] = 11364742, %l4 = ffffffffffffff80
	lduha	[%i1+%o6]0x80,%l4	! %l4 = 0000000000001136
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p0_branch_failed
	mov	0x02c,%g2
p0_b44:
!	Mem[0000000011800080] = db27a7ef 00000000 00779a0e 42473611
!	Mem[0000000011800090] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000a0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000b0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000011800080
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000118000c0
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000011000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 0000000011000040

p0_label_125:
!	Mem[0000000072000040] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[0000000072000050] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[0000000072000060] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[0000000072000070] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i3]ASI_BLK_PL	! Block Store to 0000000011800000
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000010000040
!	Mem[0000000070800040] = 00000000dba1f0f1, %l5 = 0000000000000000
	ldx	[%o1+0x040],%l5		! %l5 = 00000000dba1f0f1
	membar	#Sync			! Added by membar checker (37)
!	Mem[000000001000004c] = 42473611, %l1 = 00000000000000f1
	lduw	[%i0+0x04c],%l1		! %l1 = 0000000042473611

p0_label_126:
!	Mem[00000000108000a0] = be57b521804fdaea, %l0 = 00000000dba1f0f1
	ldx	[%i1+0x0a0],%l0		! %l0 = be57b521804fdaea
!	Mem[0000000011000008] = eb27bc1a, %l0 = be57b521804fdaea
	ldstuba	[%i2+%o6]0x80,%l0	! %l0 = 00000000000000eb
!	Mem[0000000012800080] = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	Mem[0000000012800090] = 6039e51d 5f8401f5 e734181e 316aacbc
!	Mem[00000000128000a0] = c7182cd6 f8cf7704 17d2979e e9372065
!	Mem[00000000128000b0] = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	ldda	[%i5+%g5]ASI_BLK_P,%f0	! Block Load from 0000000012800080
!	Mem[0000000011000010] = 28f2bcf3, %l6 = 00000000efa727db
	lduba	[%i2+0x011]%asi,%l6	! %l6 = 00000000000000f2
!	Mem[0000000071000044] = 3f9d54fe, %l0 = 00000000000000eb
	ldub	[%o2+0x044],%l0		! %l0 = 000000000000003f

p0_label_127:
!	Mem[00000000118000d0] = ef3b8cde8aaf6feb, %l4 = 0000000000001136
	ldx	[%i3+0x0d0],%l4		! %l4 = ef3b8cde8aaf6feb
!	Mem[0000000010800000] = 00000000, %l5 = 00000000dba1f0f1
	lduha	[%i1+%g0]0x80,%l5	! %l5 = 0000000000000000
!	Mem[0000000070000004] = 3ec3f718, %l7 = 0000000000001ee6
	ldsw	[%o0+0x004],%l7		! %l7 = 000000003ec3f718
!	Mem[0000000010000000] = dba1f0f1, %l6 = 00000000000000f2
	ldswa	[%i0+%g0]0x80,%l6	! %l6 = ffffffffdba1f0f1
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb, %l2 = de8c3bef, %l3 = 00000018
	ldda	[%i3+0x0d0]%asi,%l2	! %l2 = 00000000ef3b8cde 000000008aaf6feb

p0_label_128:
!	Mem[0000000011000038] = 28f2bcf33e2da712, %l3 = 000000008aaf6feb
	ldx	[%i2+0x038],%l3		! %l3 = 28f2bcf33e2da712
!	Mem[0000000070800044] = dba1f0f1, %l6 = ffffffffdba1f0f1
	ldsba	[%o1+0x044]%asi,%l6	! %l6 = ffffffffffffffdb
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000011000080
	membar	#Sync			! Added by membar checker (38)
!	Mem[0000000011000000] = 5c58d14b f1f0a1db ff27bc1a 617fbfd4
!	Mem[0000000011000010] = 28f2bcf3 3e2db712 7c60467e 702cfbce
!	Mem[0000000011000020] = eb27bc1a 617fafd4 eb27bc1a 617faf54
!	Mem[0000000011000030] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i2]ASI_BLK_P,%f16	! Block Load from 0000000011000000
!	Mem[0000000011000008] = ff27bc1a, %l4 = ef3b8cde8aaf6feb
	lduha	[%i2+%o6]0x80,%l4	! %l4 = 000000000000ff27

p0_label_129:
!	Mem[0000000071800000] = 0000000000007bf4, %l5 = 0000000000000000
	ldx	[%o3+0x000],%l5		! %l5 = 0000000000007bf4
!	Mem[0000000010800040] = 00000000, %l2 = 00000000ef3b8cde
	ldsw	[%i1+0x040],%l2		! %l2 = 0000000000000000
!	%f0  = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f4  = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f8  = c7182cd6 f8cf7704 17d2979e e9372065
!	%f12 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000010000080
!	%f0  = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f4  = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f8  = c7182cd6 f8cf7704 17d2979e e9372065
!	%f12 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000110000c0
!	Mem[0000000070800040] = 00000000, %l5 = 0000000000007bf4
	lduh	[%o1+0x042],%l5		! %l5 = 0000000000000000

p0_label_130:
!	Mem[0000000010800008] = 11364742, %l6 = ffffffffffffffdb
	lduba	[%i1+%o6]0x80,%l6	! %l6 = 0000000000000011
!	Mem[0000000010800000] = 00000000, %l7 = 000000003ec3f718
	lduba	[%i1+%g0]0x80,%l7	! %l7 = 0000000000000000
!	Mem[00000000118000c0] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000e0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000f0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000118000c0
!	Mem[0000000012800040] = 33bc95c2 eae35a95 839d2bc9 1fa84cf8
!	Mem[0000000012800050] = 8154fe71 c06ccd17 96f62312 dfd0d8a6
!	Mem[0000000012800060] = 04c38084 76a8d51b 9d6d3885 5a249bd3
!	Mem[0000000012800070] = 7e590ac6 dafdecaa d1d4326e 5a46795d
	ldda	[%i5+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000012800040
!	Mem[0000000071800040] = 27aa3ec39ba8c36b, %l3 = 28f2bcf33e2da712
	ldx	[%o3+0x040],%l3		! %l3 = 27aa3ec39ba8c36b

p0_label_131:
!	Mem[0000000071000044] = 3f9d54fe, %l7 = 0000000000000000
	lduw	[%o2+0x044],%l7		! %l7 = 000000003f9d54fe
!	Mem[0000000072000000] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000010] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000020] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000030] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	%f8  = 1bd5a876 8480c304, %f10 = d39b245a 85386d9d
	fcmpd	%fcc1,%f8 ,%f10		! %fcc1 = 2
!	%f16 = 5c58d14b f1f0a1db ff27bc1a 617fbfd4
!	%f20 = 28f2bcf3 3e2db712 7c60467e 702cfbce
!	%f24 = eb27bc1a 617fafd4 eb27bc1a 617faf54
!	%f28 = b28929f5 e61e4204 28f2bcf3 3e2da712
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000011000000
!	Mem[0000000011800008] = ec8f424a, %l4 = 000000000000ff27
	lduba	[%i3+%o6]0x80,%l4	! %l4 = 00000000000000ec

p0_label_132:
!	Mem[0000000011000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000011000040
!	Mem[0000000010000000] = dba1f0f1, %l6 = 0000000000000011
	ldsba	[%i0+%g0]0x80,%l6	! %l6 = ffffffffffffffdb
!	%l6 = ffffffffffffffdb, %l0 = 000000000000003f, %l5 = 0000000000000000
	srax	%l6,%l0,%l5		! %l5 = ffffffffffffffff
!	%f32 = 92b4db51 021a1102 764918d9 4204f2ed
!	%f36 = c4dc9bfb 8c387207 e9062226 546be982
!	%f40 = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	%f44 = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	stda	%f32,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Branch On Register, %l3 = 27aa3ec39ba8c36b
	brz,pt	%l3,p0_not_taken_0	! Branch Not Taken

p0_label_133:
!	Mem[0000000011800008] = ec8f424a, %l7 = 000000003f9d54fe
	lduha	[%i3+%o6]0x80,%l7	! %l7 = 000000000000ec8f
p0_b45:
	membar	#Sync			! Added by membar checker (39)
!	Mem[0000000010000080] = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	Mem[0000000010000090] = 6039e51d 5f8401f5 e734181e 316aacbc
!	Mem[00000000100000a0] = c7182cd6 f8cf7704 17d2979e e9372065
!	Mem[00000000100000b0] = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 0000000010000080
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080
!	Mem[0000000070800000] = 2686ccaa, %l2 = 0000000000000000
	lduh	[%o1+0x000],%l2		! %l2 = 0000000000002686
!	%f16 = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f20 = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f24 = c7182cd6 f8cf7704 17d2979e e9372065
!	%f28 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000011800080

p0_label_134:
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i5+%g6]ASI_BLK_PL	! Block Store to 0000000012800040
!	%l6 = ffffffffffffffdb, %l5 = ffffffffffffffff, %l2 = 0000000000002686
	taddcc	%l6,%l5,%l2		! %l2 = ffffffffffffffda, %ccr = 9b
!	Mem[0000000011000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000011000040
!	Mem[0000000011800040] = 5c58d14b f1f0a1db be51253e a0000000
!	Mem[0000000011800050] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[0000000011800060] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[0000000011800070] = eada4f80 21b557be 28f2bcf3 3e2da712
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000011800040
!	%f16 = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f20 = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f24 = c7182cd6 f8cf7704 17d2979e e9372065
!	%f28 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040

p0_label_135:
	membar	#Sync
	bvs	p0_b46			! Branch Taken, %ccr = 9b, CWP = 0
!	Mem[0000000011000008] = d4bf7f611abc27ff, %l7 = 000000000000ec8f
	ldxa	[%i2+%o6]0x80,%l7	! %l7 = d4bf7f611abc27ff
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x02e,%g2
p0_b46:
!	Mem[0000000071800000] = 00000000, %l0 = 000000000000003f
	ldub	[%o3+0x002],%l0		! %l0 = 0000000000000000
!	%l3 = 27aa3ec39ba8c36b, Mem[000000001180007c] = ee31509c
	stw	%l3,[%i3+0x07c]		! Mem[000000001180007c] = 9ba8c36b
!	%l4 = 00000000000000ec, %l6 = ffffffffffffffdb, %l7 = d4bf7f611abc27ff
	andncc	%l4,%l6,%l7		! %l7 = 0000000000000024, %ccr = 00

p0_label_136:
	membar	#Sync			! Added by membar checker (40)
!	Mem[0000000011800040] = 5ed571a7 f6c63f4e eac39dac b22eb19a
!	Mem[0000000011800050] = f501845f 1de53960 bcac6a31 1e1834e7
!	Mem[0000000011800060] = 0477cff8 d62c18c7 652037e9 9e97d217
!	Mem[0000000011800070] = 362c33c4 f8da87ea c59fba15 9ba8c36b
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 0000000011800040
!	Mem[0000000011000000] = dba1f0f1, %l6 = ffffffffffffffdb
	ldsba	[%i2+%g0]0x80,%l6	! %l6 = ffffffffffffffdb
!	Mem[00000000100000f0] = 04421ee6, %l6 = ffffffffffffffdb
	ldsb	[%i0+0x0f3],%l6		! %l6 = ffffffffffffffe6
!	Mem[0000000070000040] = f67031ea, %l1 = 0000000042473611
	lduw	[%o0+0x040],%l1		! %l1 = 00000000f67031ea
!	Mem[0000000071800040] = 27aa3ec3, %l0 = 0000000000000000
	lduh	[%o3+0x042],%l0		! %l0 = 0000000000003ec3

p0_label_137:
!	Mem[00000000110000c0] = 5ed571a7 f6c63f4e eac39dac b22eb19a
!	Mem[00000000110000d0] = f501845f 1de53960 bcac6a31 1e1834e7
!	Mem[00000000110000e0] = 0477cff8 d62c18c7 652037e9 9e97d217
!	Mem[00000000110000f0] = 362c33c4 f8da87ea c59fba15 ee31509c
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000110000c0
	membar	#Sync			! Added by membar checker (41)
	set	p0_b47,%o7
	fbul,a,pt %fcc3,p0_near_0_le	! Branch Taken, %fcc3 = 1
!	%l7 = 0000000000000024, Mem[0000000071000044] = 3f9d54fe
	stw	%l7,[%o2+0x044]		! Mem[0000000071000044] = 00000024
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p0_branch_failed
	mov	0x02f,%g2
p0_b47:
!	Registers modified during the branch to p0_near_0
!	%l3  = 000000007c60467e
!	%l4  = 0000000000000140
!	Mem[000000001080005c] = dd09e18d, %l7 = 0000000000000024
	ldsba	[%i1+0x05e]%asi,%l7	! %l7 = ffffffffffffffe1
!	%f16 = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f20 = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f24 = c7182cd6 f8cf7704 17d2979e e9372065
!	%f28 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000010800040

p0_label_138:
!	Mem[0000000010000008] = ff8039d3, %l3 = 000000007c60467e
	lduba	[%i0+%o6]0x80,%l3	! %l3 = 00000000000000ff
	membar	#Sync			! Added by membar checker (42)
!	Mem[0000000010800048] = eac39dac, %l1 = 00000000f67031ea
	ldsha	[%i1+0x048]%asi,%l1	! %l1 = ffffffffffffeac3
!	Mem[0000000011800008] = ec8f424a, %l3 = 00000000000000ff
	lduwa	[%i3+%o6]0x80,%l3	! %l3 = 00000000ec8f424a
!	%f16 = 4e3fc6f6 a771d55e 9ab12eb2 ac9dc3ea
!	%f20 = 6039e51d 5f8401f5 e734181e 316aacbc
!	%f24 = c7182cd6 f8cf7704 17d2979e e9372065
!	%f28 = ea87daf8 c4332c36 9c5031ee 15ba9fc5
	stda	%f16,[%i0]ASI_BLK_PL	! Block Store to 0000000010000000
!	Mem[00000000110000c4] = f6c63f4e, %l2 = ffffffffffffffda
	lduha	[%i2+0x0c6]%asi,%l2	! %l2 = 0000000000003f4e

p0_label_139:
!	Mem[0000000072000068] = cbf74722865aae7d, %l6 = ffffffffffffffe6
	ldx	[%o4+0x068],%g2		! %g2 = cbf74722865aae7d
!	Mem[0000000072000040] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000050] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000060] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000070] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800040] = 27aa3ec39ba8c36b, %l0 = 0000000000003ec3
	ldx	[%o3+0x040],%l0		! %l0 = 27aa3ec39ba8c36b
!	%f6  = cefb2c70, %f1  = 4bd1585c, %f8  = eada4f80 21b557be
	fsmuld	%f6 ,%f1 ,%f8 		! %f8  = c369acbf 1f4f0800
!	Mem[00000000118000c0] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000e0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000f0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000118000c0

p0_label_140:
!	Mem[00000000128000c0] = 58477e08, %l2 = 0000000000003f4e
	ldsba	[%i5+0x0c1]%asi,%l2	! %l2 = 0000000000000047
!	Mem[0000000072000010] = c4dc9bfb 8c387207, %l2 = 00000047, %l3 = ec8f424a
	ldd	[%o4+0x010],%g2		! %l2 = 0000000000000047 00000000ec8f424a
!	Mem[0000000011000080] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000090] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000110000a0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000110000b0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000011000080
!	Mem[0000000013000080] = 42747958 6138211e ee35fc64 2511df25
!	Mem[0000000013000090] = 6b2ef9e2 555a60b6 bb960eba 78aa907d
!	Mem[00000000130000a0] = 91a9cb45 c20f5466 6a3758d9 3586e3f1
!	Mem[00000000130000b0] = 354488e2 24a50d22 a496a9f3 1434ecea
	ldda	[%i6+%g5]ASI_BLK_P,%f16	! Block Load from 0000000013000080
	membar	#Sync			! Added by membar checker (43)
	set	p0_b48,%o7
	fblg,a	p0_far_2_le		! Branch Taken, %fcc0 = 1

p0_label_141:
!	Mem[0000000070800000] = 2686ccaa356877b1, %l6 = ffffffffffffffe6
	ldx	[%o1+0x000],%l6		! %l6 = 2686ccaa356877b1
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x030,%g2
p0_b48:
!	Registers modified during the branch to p0_far_2
!	%l1  = 2686ccaa356877b1
!	%l2  = 000000000000dba1
!	%l4  = d855c13c6457b889
!	%l6  = 000000007fef0172
!	%l7  = 0000000000007bf4
!	Mem[00000000118000c0] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000e0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000f0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000118000c0
!	Mem[00000000118000e8] = f18b40d9 d155a333, %l4 = 6457b889, %l5 = ffffffff
	ldd	[%i3+0x0e8],%l4		! %l4 = 00000000f18b40d9 00000000d155a333
!	Mem[0000000011000000] = dba1f0f1, %l4 = 00000000f18b40d9
	ldsba	[%i2+%g0]0x80,%l4	! %l4 = ffffffffffffffdb
!	Mem[0000000072000040] = 92b4db51 021a1102, %l4 = ffffffdb, %l5 = d155a333
	ldda	[%o4+0x040]%asi,%g2	! %l4 = ffffffffffffffdb 00000000d155a333

p0_label_142:
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000011000080
!	Mem[0000000070800004] = 356877b1, %l4 = ffffffffffffffdb
	ldub	[%o1+0x006],%l4		! %l4 = 0000000000000077
	membar	#Sync
	set	p0_b49,%o7
	fba	p0_far_3_le		! Branch Taken, %fcc0 = 1
!	Mem[0000000011000000] = dba1f0f1, %l6 = 000000007fef0172
	lduha	[%i2+%g0]0x80,%l6	! %l6 = 000000000000dba1
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p0_branch_failed
	mov	0x031,%g2
p0_b49:
!	Registers modified during the branch to p0_far_3
!	%l0  = 00000000dba1f0f1
!	%l4  = 8de109dd00000024
!	%l6  = ef3b8cde8aaf6feb
!	%l7  = 00000c421c6b5da8
!	Mem[0000000070800044] = dba1f0f1, %l0 = 00000000dba1f0f1
	ldsh	[%o1+0x044],%l0		! %l0 = ffffffffffffdba1

p0_label_143:
	set	p0_b50,%o7
	fblg,a	p0_far_0_le		! Branch Taken, %fcc0 = 1
!	Mem[0000000011800000] = bc000000, %l3 = 00000000ec8f424a
	lduwa	[%i3+%g0]0x80,%l3	! %l3 = 00000000bc000000
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p0_branch_failed
	mov	0x032,%g2
p0_b50:
!	Registers modified during the branch to p0_far_0
!	%l0  = eb27bc1a617faf54
!	%l3  = 000000000000181e
!	Mem[0000000011800008] = ec8f424a, %l2 = 000000000000dba1
	lduba	[%i3+%o6]0x80,%l2	! %l2 = 00000000000000ec
!	%f16 = 00000000 efa727db 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000118000c0
!	Mem[0000000072000040] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000050] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000060] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000070] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p0_label_144:
	membar	#Sync			! Added by membar checker (44)
!	Branch On Register, %l4 = 8de109dd00000024
	brlz,pt	%l4,p0_b51		! Branch Taken
!	Mem[0000000070000040] = f67031eae3f5d882, %l6 = ef3b8cde8aaf6feb
	ldx	[%o0+0x040],%l6		! %l6 = f67031eae3f5d882
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x033,%g2
p0_b51:
!	Mem[0000000011000064] = 7201ef7f, %l7 = 00000c421c6b5da8
	swap	[%i2+0x064],%l7		! %l7 = 000000007201ef7f
!	%l1 = 2686ccaa356877b1, immed = fffff642, %y  = 00000c42
	udiv	%l1,-0x9be,%l0		! %l0 = 0000000000000c42
	mov	%l0,%y			! %y = 00000c42
!	Mem[0000000071800044] = 9ba8c36b, %l7 = 000000007201ef7f
	lduha	[%o3+0x044]%asi,%l7	! %l7 = 0000000000009ba8

p0_label_145:
!	Mem[00000000118000ec] = d155a333, %l4 = 8de109dd00000024
	ldsw	[%i3+0x0ec],%l4		! %l4 = ffffffffd155a333
!	Mem[0000000072000040] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000050] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000060] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000070] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Denormal Floating Point Operation Nullified
	nop
!	Mem[0000000070800000] = 2686ccaa356877b1, %l7 = 0000000000009ba8
	ldx	[%o1+0x000],%l7		! %l7 = 2686ccaa356877b1
!	%f31 = b765253a, Mem[0000000070000044] = e3f5d882
	st	%f31,[%o0+0x044]	! Mem[0000000070000044] = b765253a

p0_label_146:
!	%f19 = 4a428fec, %f11 = d9408bf1
	fstoi	%f19,%f11		! %f11 = 0030a3fb
!	Mem[0000000011000000] = dba1f0f1, %l0 = 0000000000000c42
	ldswa	[%i2+%g0]0x80,%l0	! %l0 = ffffffffdba1f0f1
!	Mem[000000001000003c] = ee31509c, %l5 = 00000000d155a333
	ldsba	[%i0+0x03e]%asi,%l5	! %l5 = 0000000000000050
!	Mem[0000000010000020] = 0477cff8d62c18c7, %l6 = f67031eae3f5d882
	ldx	[%i0+0x020],%l6		! %l6 = 0477cff8d62c18c7
!	%l5 = 0000000000000050, immed = fffff039, %l7 = 2686ccaa356877b1
	andn	%l5,-0xfc7,%l7		! %l7 = 0000000000000040

p0_label_147:
	bgu,a	p0_not_taken_0		! Branch Not Taken, %ccr = 93
!	%l1 = 2686ccaa356877b1, immed = 0000010b, %l7 = 0000000000000040
	addccc	%l1,0x10b,%l7		! Annulled
p0_b52:
!	Mem[00000000108000c0] = 00000000 efa727db, %l2 = 000000ec, %l3 = 0000181e
	ldd	[%i1+0x0c0],%l2		! %l2 = 0000000000000000 00000000efa727db
!	%f16 = 00000000 efa727db 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000110000c0
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 0030a3fb
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i1]ASI_BLK_PL	! Block Store to 0000000010800000

p0_label_148:
	membar	#Sync			! Added by membar checker (45)
!	Mem[0000000010800008] = ec8f424a42473611, %l6 = 0477cff8d62c18c7
	ldxa	[%i1+%o6]0x80,%l6	! %l6 = ec8f424a42473611
!	Mem[0000000010800080] = 5c58d14b f1f0a1db a9a7a91b d3398026
!	Mem[0000000010800090] = 76fd123c 161e942c 7c60467e 702cfbce
!	Mem[00000000108000a0] = be57b521 804fdaea eb27bc1a 617faf54
!	Mem[00000000108000b0] = b28929f5 e61e4204 28f2bcf3 3e2da712
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 0000000010800080
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 0030a3fb
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2]ASI_BLK_P	! Block Store to 0000000011000000
!	Mem[0000000070800000] = 2686ccaa, %l3 = 00000000efa727db
	ldswa	[%o1+0x000]%asi,%l3	! %l3 = 000000002686ccaa
!	%l2 = 0000000000000000, Mem[0000000011000000] = 00000000efa727db
	stxa	%l2,[%i2+%g0]0x80	! Mem[0000000011000000] = 0000000000000000

p0_label_149:
!	Mem[0000000072000000] = 92b4db51 021a1102 764918d9 4204f2ed
!	Mem[0000000072000010] = c4dc9bfb 8c387207 e9062226 546be982
!	Mem[0000000072000020] = 706d5e77 7d7e1a2d cbf74722 865aae7d
!	Mem[0000000072000030] = 5b3eb906 cb6c00d1 34da1d01 8d0c254b
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
	membar	#Sync			! Added by membar checker (46)
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 0030a3fb
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2]ASI_BLK_P	! Block Store to 0000000011000000
!	Mem[00000000110000d0] = eb6faf8ade8c3bef, %l5 = 0000000000000050
	ldx	[%i2+0x0d0],%l5		! %l5 = eb6faf8ade8c3bef
!	Mem[0000000070000044] = b765253a, %l2 = 0000000000000000
	ldub	[%o0+0x047],%l2		! %l2 = 000000000000003a
!	Mem[0000000011000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000060] = 1c34ef4a 1c6b5da8 33a355d1 d9408bf1
!	Mem[0000000011000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 0000000011000040

p0_label_150:
!	Mem[0000000071000040] = 8de109dd00000024, %l1 = 2686ccaa356877b1
	ldx	[%o2+0x040],%l1		! %l1 = 8de109dd00000024
!	Mem[0000000072000060] = 706d5e777d7e1a2d, %l1 = 8de109dd00000024
	ldx	[%o4+0x060],%g2		! %g2 = 706d5e777d7e1a2d
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 1c6b5da8 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080
	membar	#Sync			! Added by membar checker (47)
!	Mem[0000000011000000] = 00000000efa727db, %l2 = 000000000000003a
	ldxa	[%i2+%g0]0x80,%l2	! %l2 = 00000000efa727db
!	Mem[000000007200000c] = 4204f2ed, %l2 = 00000000efa727db
	ldub	[%o4+0x00c],%g2		! %g2 = 0000000000000042

p0_label_151:
!	%l7 = 0000000000000040, Mem[0000000010000000] = 5ed571a7
	stwa	%l7,[%i0+%g0]0x80	! Mem[0000000010000000] = 00000040
!	%l3 = 000000002686ccaa, %l3 = 000000002686ccaa, %l5 = eb6faf8ade8c3bef
	andncc	%l3,%l3,%l5		! %l5 = 0000000000000000, %ccr = 44
!	Mem[0000000070000004] = 3ec3f718, %l5 = 0000000000000000
	ldsb	[%o0+0x006],%l5		! %l5 = fffffffffffffff7
	set	p0_b53,%o7
	fbul,a	p0_far_2_he		! Branch Taken, %fcc0 = 1
!	Mem[0000000070800040] = 00000000dba1f0f1, %l6 = ec8f424a42473611
	ldx	[%o1+0x040],%l6		! %l6 = 00000000dba1f0f1
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x035,%g2
p0_b53:
!	Registers modified during the branch to p0_far_2
!	%l1  = 00000000000000fa
!	%l6  = 000000000000003e

p0_label_152:
!	%f0  = 00000000 efa727db 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 0030a3fb
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i5+%g6]ASI_BLK_P	! Block Store to 0000000012800040
!	Mem[0000000011000000] = 00000000, %l5 = fffffffffffffff7
	ldswa	[%i2+%g0]0x80,%l5	! %l5 = 0000000000000000
!	%l0 = ffffffffdba1f0f1, %l6 = 000000000000003e, %y  = 00000c42
	udivcc	%l0,%l6,%l1		! %l1 = 00000000ffffffff, %ccr = 0a
	mov	%l0,%y			! %y = dba1f0f1
!	Mem[0000000071000000] = 54af7f611abc27eb, %l2 = 00000000efa727db
	ldx	[%o2+0x000],%l2		! %l2 = 54af7f611abc27eb
!	Mem[0000000010800080] = 5c58d14bf1f0a1db, %l0 = ffffffffdba1f0f1
	ldx	[%i1+0x080],%l0		! %l0 = 5c58d14bf1f0a1db

p0_label_153:
!	Mem[0000000011800040] = 5ed571a7 f6c63f4e eac39dac b22eb19a
!	Mem[0000000011800050] = f501845f 1de53960 bcac6a31 1e1834e7
!	Mem[0000000011800060] = 0477cff8 d62c18c7 652037e9 9e97d217
!	Mem[0000000011800070] = 362c33c4 f8da87ea c59fba15 9ba8c36b
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 0000000011800040
!	Mem[00000000118000c0] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000e0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000f0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000118000c0
!	Mem[0000000070800000] = 2686ccaa, %l0 = 5c58d14bf1f0a1db
	lduha	[%o1+0x002]%asi,%l0	! %l0 = 000000000000ccaa
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 1c6b5da8 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000011800040
!	Mem[0000000010800090] = 76fd123c161e942c, %l5 = 0000000000000000
	ldx	[%i1+0x090],%l5		! %l5 = 76fd123c161e942c

p0_label_154:
!	Mem[0000000010800000] = db27a7ef, %l2 = 54af7f611abc27eb
	ldsba	[%i1+%g0]0x80,%l2	! %l2 = ffffffffffffffdb
	nop
!	Mem[0000000010000034] = f8da87ea, %l5 = 76fd123c161e942c
	lduh	[%i0+0x034],%l5		! %l5 = 000000000000f8da
!	Mem[0000000010800020] = 7fef01724aef341c, %f0  = 00000000 efa727db
	ldd	[%i1+0x020],%f0 	! %f0  = 7fef0172 4aef341c
	membar	#Sync			! Added by membar checker (48)
!	Mem[0000000011800048] = ec8f424a, %l1 = 00000000ffffffff
	ldsw	[%i3+0x048],%l1		! %l1 = ffffffffec8f424a

p0_label_155:
!	Mem[0000000011800058] = 8de109dd, %l2 = ffffffffffffffdb
	ldsb	[%i3+0x05b],%l2		! %l2 = ffffffffffffffdd
!	Mem[0000000010000040] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000010000050] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000010000060] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000010000070] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000010000040
!	Mem[0000000011800000] = bc000000, %l1 = ffffffffec8f424a
	lduwa	[%i3+0x000]%asi,%l1	! %l1 = 00000000bc000000
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 1c6b5da8 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000010800040

p0_label_156:
!	Mem[0000000012800000] = 5c58d14b, %l2 = ffffffffffffffdd
	ldsb	[%i5+0x001],%l2		! %l2 = 0000000000000058
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 0000000010000000
!	%f16 = 00000000 000000bc 11364742 4a428fec
!	%f20 = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f24 = 1c34ef4a 1c6b5da8 33a355d1 d9408bf1
!	%f28 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 0000000010800000
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000110000c0
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080

p0_label_157:
	membar	#Sync
	set	p0_b54,%o7
	fblg,a	p0_far_2_le		! Branch Taken, %fcc0 = 1
!	Mem[00000000118000d4] = 8aaf6feb, %l4 = ffffffffd155a333
	ldsw	[%i3+0x0d4],%l4		! %l4 = ffffffff8aaf6feb
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p0_branch_failed
	mov	0x036,%g2
p0_b54:
!	Registers modified during the branch to p0_far_2
!	%l1  = 2686ccaa356877b1
!	%l2  = 000000000000dba1
!	%l4  = ffffffffffffaf4a
!	%l6  = 000000007fef0172
!	%l7  = 0000000000007bf4
!	Mem[00000000118000c0] = db27a7ef 00000000 ec8f424a 42473611
!	Mem[00000000118000d0] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000118000e0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000118000f0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i3+%g4]ASI_BLK_P,%f16	! Block Load from 00000000118000c0
!	Mem[0000000010800088] = a9a7a91b d3398026, %l2 = 0000dba1, %l3 = 2686ccaa
	ldd	[%i1+0x088],%l2		! %l2 = 00000000a9a7a91b 00000000d3398026
!	Mem[0000000010000000] = bc000000 00000000, %l2 = a9a7a91b, %l3 = d3398026
	ldda	[%i0+%g0]0x80,%l2	! %l2 = 00000000bc000000 0000000000000000

p0_label_158:
	fbe,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000071000044] = 00000024, %l7 = 0000000000007bf4
	ldub	[%o2+0x047],%l7		! Annulled
p0_b55:
!	%f8  = 1c34ef4a, %f10 = 33a355d1
	fcmpes	%fcc3,%f8 ,%f10		! %fcc3 = 1
	nop
!	%l2 = bc000000, %l3 = 00000000, Mem[0000000071000040] = 8de109dd 00000024
	std	%l2,[%o2+0x040]	! Mem[0000000071000040] = bc000000 00000000

p0_label_159:
!	Mem[0000000010000008] = ec8f424a, %l3 = 0000000000000000
	ldsba	[%i0+%o6]0x80,%l3	! %l3 = ffffffffffffffec
!	Mem[0000000012000000] = 5cb7e830 0f048dd0, %l2 = bc000000, %l3 = ffffffec
	ldda	[%i4+%g0]0x80,%l2	! %l2 = 000000005cb7e830 000000000f048dd0
!	Mem[0000000011000008] = 11364742, %l1 = 2686ccaa356877b1
	lduha	[%i2+%o6]0x80,%l1	! %l1 = 0000000000001136
!	%l2 = 000000005cb7e830, Mem[0000000071800041] = 27aa3ec3
	stba	%l2,[%o3+0x041]%asi	! Mem[0000000071800040] = 27303ec3
	fbn	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1

p0_label_160:
!	Mem[0000000011800000] = bc000000, %l4 = ffffffffffffaf4a
	lduwa	[%i3+%g0]0x80,%l4	! %l4 = 00000000bc000000
p0_b56:
!	%l3 = 000000000f048dd0, immed = 00000c59, %l4 = 00000000bc000000
	addcc	%l3,0xc59,%l4		! %l4 = 000000000f049a29, %ccr = 00
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000011000040
	membar	#Sync
	set	p0_b57,%o7
	fbl	p0_far_1_le		! Branch Taken, %fcc0 = 1
!	Mem[0000000010000008] = ec8f424a, %l2 = 000000005cb7e830
	ldswa	[%i0+%o6]0x80,%l2	! %l2 = ffffffffec8f424a
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p0_branch_failed
	mov	0x039,%g2
p0_b57:
!	Registers modified during the branch to p0_far_1
!	%l4  = 000000008de109dd
!	%l5  = 000000007824dd3e
!	%l6  = 0000000000007f5a

p0_label_161:
!	Mem[0000000011800000] = bc000000, %l3 = 000000000f048dd0
	lduwa	[%i3+%g0]0x80,%l3	! %l3 = 00000000bc000000
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i6+%g5]ASI_BLK_PL	! Block Store to 0000000013000080
!	Mem[0000000011800008] = ec8f424a, %l6 = 0000000000007f5a
	ldsba	[%i3+%o6]0x80,%l6	! %l6 = ffffffffffffffec
!	%l1 = 0000000000001136, %l3 = 00000000bc000000, %l1 = 0000000000001136
	and	%l1,%l3,%l1		! %l1 = 0000000000000000
!	%l1 = 0000000000000000, immed = ffffffd9, %l4 = 000000008de109dd
	xorcc	%l1,-0x027,%l4		! %l4 = ffffffffffffffd9, %ccr = 88

p0_label_162:
!	%f28 = 8694754f 31619def, %f26 = f18b40d9 d155a333
	fcmped	%fcc1,%f28,%f26		! %fcc1 = 2
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 f0ed5a7f b765253a
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 0000000011800000
!	Mem[00000000100000c0] = dba1f0f1 4bd1585c 268039d3 1ba9a7a9
!	Mem[00000000100000d0] = 2c941e16 3c12fd76 cefb2c70 7e46607c
!	Mem[00000000100000e0] = eada4f80 21b557be 54af7f61 1abc27eb
!	Mem[00000000100000f0] = 04421ee6 f52989b2 12a72d3e f3bcf228
	ldda	[%i0+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000100000c0
!	%l2 = ffffffffec8f424a, %l4 = ffffffffffffffd9, %l5 = 000000007824dd3e
	sra	%l2,%l4,%l5		! %l5 = fffffffffffffff6
	membar	#Sync			! Added by membar checker (49)
	set	p0_b58,%o7
	fbl,a,pn %fcc0,p0_near_1_he	! Branch Taken, %fcc0 = 1

p0_label_163:
!	Mem[0000000070800044] = dba1f0f1, %l7 = 0000000000007bf4
	ldsw	[%o1+0x044],%l7		! %l7 = ffffffffdba1f0f1
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p0_branch_failed
	mov	0x03a,%g2
p0_b58:
!	Registers modified during the branch to p0_near_1
!	%l4  = 00000000bc000000
!	%l5  = 0000000000000000
!	%l7  = fffffffffffffffd
!	Mem[0000000072000000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000072000010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000072000020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000072000030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	Mem[000000001100003c] = b765253a, %l2 = ffffffffec8f424a
	ldsha	[%i2+0x03e]%asi,%l2	! %l2 = 000000000000253a
!	Mem[0000000011000050] = ef3b8cde, %l4 = 00000000bc000000
	lduw	[%i2+0x050],%l4		! %l4 = 00000000ef3b8cde
	set	p0_b59,%o7
	fbule,pn %fcc3,p0_near_3_he	! Branch Taken, %fcc3 = 1

p0_label_164:
!	Mem[0000000010800008] = ec8f424a 42473611, %l0 = 0000ccaa, %l1 = 00000000
	ldda	[%i1+%o6]0x80,%l0	! %l0 = 00000000ec8f424a 0000000042473611
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x03b,%g2
p0_b59:
!	Registers modified during the branch to p0_near_3
!	%l1  = fffffffffffffbce
!	%l2  = 00000000ef3b8cca
!	%l3  = bc00000000000000
!	Mem[0000000010000050] = ef3b8cde, %l6 = ffffffffffffffec
	ldsba	[%i0+0x052]%asi,%l6	! %l6 = ffffffffffffff8c
!	Mem[0000000070800004] = 356877b1, %l4 = 00000000ef3b8cde
	ldsba	[%o1+0x006]%asi,%l4	! %l4 = 0000000000000077
!	Mem[0000000010000000] = bc000000, %l3 = bc00000000000000
	ldsha	[%i0+%g0]0x80,%l3	! %l3 = ffffffffffffbc00
!	Mem[0000000010800000] = bc000000, %l5 = 0000000000000000
	lduha	[%i1+%g0]0x80,%l5	! %l5 = 000000000000bc00

p0_label_165:
!	Mem[0000000013000000] = db27a7ef, %l1 = fffffffffffffbce
	ldsba	[%i6+%g0]0x80,%l1	! %l1 = ffffffffffffffdb
!	Mem[0000000070000044] = b765253a, %l0 = 00000000ec8f424a
	lduh	[%o0+0x046],%l0		! %l0 = 000000000000253a
!	Mem[0000000010000000] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000010000010] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000010000020] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000010000030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i0]ASI_BLK_P,%f0	! Block Load from 0000000010000000
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000011800080
!	%l3 = ffffffffffffbc00, %l0 = 000000000000253a, %l6 = ffffffffffffff8c
	andn	%l3,%l0,%l6		! %l6 = ffffffffffff9800

p0_label_166:
!	Mem[0000000070000044] = b765253a, %l3 = ffffffffffffbc00
	ldsba	[%o0+0x047]%asi,%l3	! %l3 = 000000000000003a
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 0000000010800080
!	Mem[0000000010800064] = 4aef341c, %l3 = 000000000000003a
	lduh	[%i1+0x064],%l3		! %l3 = 0000000000004aef
!	%l3 = 0000000000004aef, immed = 00000616, %y  = dba1f0f1
	udivcc	%l3,0x616,%l5		! %l5 = 00000000ffffffff, %ccr = 0a
	mov	%l0,%y			! %y = 0000253a
!	Mem[0000000010000004] = 00000000, %l3 = 0000000000004aef
	ldswa	[%i0+0x004]%asi,%l3	! %l3 = 0000000000000000

p0_label_167:
!	Mem[0000000070000000] = fa3314463ec3f718, %l0 = 000000000000253a
	ldx	[%o0+0x000],%l0		! %l0 = fa3314463ec3f718
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080
!	Mem[0000000010800000] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000010800010] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000010800020] = a85d6b1c 4aef341c f18b40d9 d155a333
!	Mem[0000000010800030] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000010800000
!	Mem[0000000013000080] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000013000090] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000130000a0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000130000b0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i6+%g5]ASI_BLK_P,%f16	! Block Load from 0000000013000080
!	Mem[0000000011800000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011800010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011800020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011800030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i3]ASI_BLK_P,%f0	! Block Load from 0000000011800000

p0_label_168:
!	Mem[0000000070800044] = dba1f0f1, %l0 = fa3314463ec3f718
	ldsw	[%o1+0x044],%l0		! %l0 = ffffffffdba1f0f1
!	%f16 = bc000000 00000000 ec8f424a 42473611
!	%f20 = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 0000000010800000
	membar	#Sync			! Added by membar checker (50)
!	Mem[0000000010800034] = 4f759486, %l0 = ffffffffdba1f0f1
	lduha	[%i1+0x034]%asi,%l0	! %l0 = 0000000000004f75
!	Mem[0000000011000000] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000011000010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000020] = 1c34ef4a 7201ef7f 33a355d1 0030a3fb
!	Mem[0000000011000030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2]ASI_BLK_P,%f0	! Block Load from 0000000011000000
!	Mem[0000000010800080] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000010800090] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000108000a0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000108000b0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 0000000010800080

p0_label_169:
!	%f8  = 1c34ef4a 7201ef7f, %f6  = 3edd2478 dd09e18d
	fcmpd	%fcc2,%f8 ,%f6 		! %fcc2 = 1
!	%f16 = bc000000 00000000 ec8f424a 42473611
!	%f20 = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 3a2565b7 7f5aedf0
	stda	%f16,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000011000040] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000011000050] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000011000060] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000011000070] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000011000040
!	Mem[0000000071800040] = 27303ec3, %l0 = 0000000000004f75
	ldsb	[%o3+0x043],%l0		! %l0 = ffffffffffffffc3
!	Mem[0000000072000000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000072000010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000072000020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000072000030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p0_label_170:
!	Mem[0000000071000000] = 54af7f611abc27eb, %l3 = 0000000000000000
	ldx	[%o2+0x000],%l3		! %l3 = 54af7f611abc27eb
!	Mem[0000000011800000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011800010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011800020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011800030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i3]ASI_BLK_P,%f16	! Block Load from 0000000011800000
	membar	#Sync			! Added by membar checker (51)
!	%l6 = ffffffffffff9800, Mem[0000000072000008] = 11364742
	sth	%l6,[%o4+0x008]		! Mem[0000000072000008] = 98004742
!	Mem[0000000070800044] = dba1f0f1, %l2 = 00000000ef3b8cca
	ldsha	[%o1+0x044]%asi,%l2	! %l2 = ffffffffffffdba1
!	Mem[0000000072000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000072000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000072000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000072000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p0_label_171:
!	%l5 = 00000000ffffffff, immed = 00000f81, %y  = 0000253a
	umul	%l5,0xf81,%l7		! %l7 = 00000f80fffff07f
!	Mem[0000000071000044] = 00000000, %l2 = ffffffffffffdba1
	lduh	[%o2+0x046],%l2		! %l2 = 0000000000000000
!	Mem[0000000010800080] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000010800090] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[00000000108000a0] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[00000000108000b0] = 8694754f 31619def 3a2565b7 7f5aedf0
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 0000000010800080
!	Mem[0000000070800040] = 00000000dba1f0f1, %l1 = ffffffffffffffdb
	ldx	[%o1+0x040],%l1		! %l1 = 00000000dba1f0f1
!	Mem[0000000070000000] = fa331446, %l3 = 54af7f611abc27eb
	ldsw	[%o0+0x000],%l3		! %l3 = fffffffffa331446

p0_label_172:
!	Mem[0000000071000040] = bc000000, %l0 = ffffffffffffffc3
	ldub	[%o2+0x041],%l0		! %l0 = 0000000000000000
	membar	#Sync			! Added by membar checker (52)
	set	p0_b60,%o7
	fble,a,pn %fcc3,p0_near_1_le	! Branch Taken, %fcc3 = 1
!	%f6  = 3edd2478 dd09e18d, Mem[0000000010800010] = eb6faf8a de8c3bef
	std	%f6 ,[%i1+0x010]	! Mem[0000000010800010] = 3edd2478 dd09e18d
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p0_branch_failed
	mov	0x03c,%g2
p0_b60:
!	Registers modified during the branch to p0_near_1
!	%l6  = 000000001abc27eb
!	Mem[0000000040a00010] = 3c1703042e2e3a3d, %l4 = 0000000000000077
	ldx	[%o5+0x010],%l4		! %l4 = 3c1703042e2e3a3d
	fbg	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1

p0_label_173:
!	Mem[0000000011800000] = 00000000, %l4 = 3c1703042e2e3a3d
	lduwa	[%i3+%g0]0x80,%l4	! %l4 = 0000000000000000
p0_b61:
!	Mem[0000000011000000] = 00000000 efa727db 11364742 4a428fec
!	Mem[0000000011000010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000020] = 1c34ef4a 7201ef7f 33a355d1 0030a3fb
!	Mem[0000000011000030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i2]ASI_BLK_PL,%f0	! Block Load from 0000000011000000
!	Mem[0000000071800040] = 27303ec39ba8c36b, %l0 = 0000000000000000
	ldx	[%o3+0x040],%l0		! %l0 = 27303ec39ba8c36b
!	Mem[0000000011000034] = 4f759486, %l7 = 00000f80fffff07f
	lduwa	[%i2+0x034]%asi,%l7	! %l7 = 000000004f759486
!	Mem[0000000010000080] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000010000090] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000100000a0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000100000b0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000010000080

p0_label_174:
	fbge,a,pt %fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	%f18 = ec8f424a 42473611, %f18 = ec8f424a 42473611, %f18 = ec8f424a 42473611
	faddd	%f18,%f18,%f18	! Annulled
p0_b62:
!	Mem[0000000072000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000072000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000072000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000072000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000010000070] = 8694754f31619def, %l0 = 27303ec39ba8c36b
	ldx	[%i0+0x070],%l0		! %l0 = 8694754f31619def
!	Mem[0000000070000004] = 3ec3f718, %l2 = 0000000000000000
	lduba	[%o0+0x007]%asi,%l2	! %l2 = 0000000000000018

p0_label_175:
	membar	#Sync			! Added by membar checker (53)
	set	p0_b63,%o7
	fbne,a,pt %fcc3,p0_near_2_he	! Branch Taken, %fcc3 = 1
!	Mem[00000000130000d8] = ebd27d0df5515e7e, %l5 = 00000000ffffffff
	ldx	[%i6+0x0d8],%l5		! %l5 = ebd27d0df5515e7e
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x03f,%g2
p0_b63:
!	Registers modified during the branch to p0_near_2
!	%l2  = 0000000000000017
!	Mem[0000000072000020] = 1c34ef4a7201ef7f, %l6 = 000000001abc27eb
	ldx	[%o4+0x020],%g2		! %g2 = 1c34ef4a7201ef7f
!	Mem[0000000072000010] = eb6faf8a, %l4 = 0000000000000000
	ldsh	[%o4+0x010],%g2		! %g2 = ffffffffffffeb6f
!	Mem[0000000071800040] = 27303ec39ba8c36b, %l7 = 000000004f759486
	ldx	[%o3+0x040],%l7		! %l7 = 27303ec39ba8c36b

p0_label_176:
!	%f25 = 4aef341c, %f14 = f0ed5a7f
	fstoi	%f25,%f14		! %f14 = 00779a0e
!	%l7 = 27303ec39ba8c36b, %l2 = 0000000000000017, %l2 = 0000000000000017
	sra	%l7,%l2,%l2		! %l2 = ffffffffffffff37
!	%f24 = 7fef0172, %f22 = 8de109dd
	fcmps	%fcc3,%f24,%f22		! %fcc3 = 3
!	%f3  = 4a428fec, %f20 = ef3b8cde 8aaf6feb
	fstod	%f3 ,%f20		! %f20 = 414851fd 80000000
!	Mem[0000000011800000] = 00000000000000bc, %l7 = 27303ec39ba8c36b
	ldxa	[%i3+%g0]0x80,%l7	! %l7 = 00000000000000bc

p0_label_177:
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00779a0e b765253a
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000011000040
!	Mem[0000000011800000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011800010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011800020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011800030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000011800000
!	Mem[0000000011800008] = 11364742, %l4 = 0000000000000000
	ldsha	[%i3+%o6]0x80,%l4	! %l4 = 0000000000001136
!	Mem[0000000010800008] = 11364742, %l3 = fffffffffa331446
	ldswa	[%i1+%o6]0x80,%l3	! %l3 = 0000000011364742
!	Mem[00000000108000c0] = 00000000efa727db, %l6 = 000000001abc27eb
	ldx	[%i1+0x0c0],%l6		! %l6 = 00000000efa727db

p0_label_178:
!	Mem[0000000071000004] = 1abc27eb, %l1 = 00000000dba1f0f1
	ldsha	[%o2+0x004]%asi,%l1	! %l1 = 0000000000001abc
!	%f0  = 00000000, %f14 = 00779a0e b765253a
	fitod	%f0 ,%f14		! %f14 = 00000000 00000000
	fbug,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000011800000] = 00000000, %l4 = 0000000000001136
	ldsba	[%i3+%g0]0x80,%l4	! Annulled
p0_b64:
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000

p0_label_179:
!	Mem[0000000011800008] = 11364742, %l6 = 00000000efa727db
	ldsha	[%i3+%o6]0x80,%l6	! %l6 = 0000000000001136
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000010800040
	membar	#Sync
	bcs	p0_not_taken_0		! Branch Not Taken, %ccr = 0a
!	%f24 = 7fef0172 4aef341c, %f12 = ef9d6131 4f759486
	fcmped	%fcc1,%f24,%f12		! %fcc1 = 2
p0_b65:
!	Mem[0000000070000000] = fa3314463ec3f718, %f20 = ef3b8cde 8aaf6feb
	ldd	[%o0+0x000],%f20	! %f20 = fa331446 3ec3f718

p0_label_180:
!	%f11 = d9408bf1, %f14 = 00000000, %f18 = ec8f424a
	fadds	%f11,%f14,%f18		! %f18 = d9408bf1
!	Mem[0000000011800000] = 00000000 000000bc 11364742 4a428fec
	prefetcha [%i3+0x000]%asi,23
!	%f17 = 00000000, %f12 = ef9d6131, %f30 = 3a2565b7
	fdivs	%f17,%f12,%f30		! %f30 = 80000000
!	Mem[0000000010000008] = ec8f424a 42473611, %l0 = 31619def, %l1 = 00001abc
	ldda	[%i0+%o6]0x80,%l0	! %l0 = 00000000ec8f424a 0000000042473611
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000011800080

p0_label_181:
!	Mem[0000000072000034] = 31619def, %l5 = ebd27d0df5515e7e
	ldswa	[%o4+0x034]%asi,%g2	! %g2 = ebd27d0df5515e7e
!	Mem[0000000070000004] = 3ec3f718, %l0 = 00000000ec8f424a
	ldstub	[%o0+0x004],%l0		! %l0 = 000000000000003e
!	%f17 = 00000000, %f22 = 8de109dd
	fcmps	%fcc3,%f17,%f22		! %fcc3 = 2
!	%l4 = 0000000000001136, immed = fffff340, %l7 = 00000000000000bc
	xorcc	%l4,-0xcc0,%l7		! %l7 = ffffffffffffe276, %ccr = 88
!	Mem[0000000072000058] = 2478dd09, %l6 = 0000000000001136
	lduh	[%o4+0x05a],%g2		! %g2 = 0000000000002478

p0_label_182:
!	%l6 = 00001136, %l7 = ffffe276, Mem[0000000072000058] = 3edd2478 dd09e18d
	stda	%l6,[%o4+0x058]%asi	! Mem[0000000072000058] = 00001136 ffffe276
!	Mem[0000000071800000] = 00000000, %l2 = ffffffffffffff37
	ldub	[%o3+0x002],%l2		! %l2 = 0000000000000000
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000010000080
!	Mem[0000000011000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011000070] = ef9d6131 4f759486 00779a0e b765253a
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 0000000011000040
!	Mem[0000000070000040] = f67031ea, %l7 = ffffffffffffe276
	ldsha	[%o0+0x042]%asi,%l7	! %l7 = 00000000000031ea

p0_label_183:
!	Mem[0000000011800008] = 113647424a428fec, %l6 = 0000000000001136
	ldxa	[%i3+%o6]0x80,%l6	! %l6 = 113647424a428fec
!	Mem[000000007200002c] = d155a333, %l5 = ebd27d0df5515e7e
	ldsha	[%o4+0x02c]%asi,%g2	! %g2 = ffffffffffffd155
!	Mem[0000000072000058] = 00001136, %l7 = 00000000000031ea
	ldswa	[%o4+0x058]%asi,%g2	! %g2 = 00000000000031ea
	membar	#Sync			! Added by membar checker (54)
	set	p0_b66,%o7
	fbne,a	p0_far_2_le		! Branch Taken, %fcc0 = 1
!	Mem[0000000070000040] = f67031eab765253a, %l0 = 000000000000003e
	ldx	[%o0+0x040],%l0		! %l0 = f67031eab765253a
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p0_branch_failed
	mov	0x042,%g2
p0_b66:
!	Registers modified during the branch to p0_far_2
!	%l1  = 2686ccaa356877b1
!	%l2  = 000000000000dba1
!	%l4  = 098fce15489b56ba
!	%l6  = 000000001c34ef4a
!	%l7  = 0000000000007bf4

p0_label_184:
!	Mem[0000000072000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000072000050] = eb6faf8a de8c3bef 00001136 ffffe276
!	Mem[0000000072000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000072000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000011800080
!	Mem[0000000010800040] = bc000000 00000000 ec8f424a 42473611
!	Mem[0000000010800050] = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	Mem[0000000010800060] = 7fef0172 4aef341c f18b40d9 d155a333
!	Mem[0000000010800070] = 8694754f 31619def 00000000 00000000
	ldda	[%i1+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000010800040
!	Mem[0000000010800008] = 11364742 4a428fec, %l4 = 489b56ba, %l5 = f5515e7e
	ldda	[%i1+%o6]0x80,%l4	! %l4 = 0000000011364742 000000004a428fec
!	Mem[00000000110000d4] = 8aaf6feb, %l4 = 0000000011364742
	ldswa	[%i2+0x0d4]%asi,%l4	! %l4 = ffffffff8aaf6feb

p0_label_185:
!	Mem[0000000011000018] = 3edd2478dd09e18d, %l5 = 000000004a428fec
	ldxa	[%i2+0x018]%asi,%l5	! %l5 = 3edd2478dd09e18d
!	Mem[0000000071000000] = 54af7f61, %l7 = 0000000000007bf4
	lduw	[%o2+0x000],%l7		! %l7 = 0000000054af7f61
!	Mem[0000000072000048] = 113647424a428fec, %l4 = ffffffff8aaf6feb
	ldx	[%o4+0x048],%g2		! %g2 = 113647424a428fec
!	Mem[00000000108000c0] = 00000000 efa727db 11364742 4a428fec
!	Mem[00000000108000d0] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000108000e0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000108000f0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000108000c0
!	Mem[0000000010000008] = ec8f424a, %l6 = 000000001c34ef4a
	lduwa	[%i0+%o6]0x80,%l6	! %l6 = 00000000ec8f424a

p0_label_186:
!	Mem[0000000012000088] = 83903e62, %l0 = f67031eab765253a
	ldsh	[%i4+0x08a],%l0		! %l0 = 0000000000003e62
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000010000044] = 00000000, %l4 = ffffffff8aaf6feb
	lduw	[%i0+0x044],%l4		! %l4 = 0000000000000000
	membar	#Sync
!	Branch On Register, %l4 = 0000000000000000
	brz,a,pn %l4,p0_b67		! Branch Taken
!	Mem[0000000013000040] = 00000000efa727db, %l0 = 0000000000003e62
	ldx	[%i6+0x040],%l0		! %l0 = 00000000efa727db
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p0_branch_failed
	mov	0x043,%g2
p0_b67:

p0_label_187:
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l5 = 3edd2478dd09e18d, %l5 = 3edd2478dd09e18d, %l1 = 2686ccaa356877b1
	addccc	%l5,%l5,%l1		! %l1 = 7dba48f1ba13c31b, %ccr = 09
!	%f16 = db27a7ef 00000000, %f30 = 3a2565b7 7f5aedf0
	fnegd	%f16,%f30		! %f30 = 5b27a7ef 00000000
!	Mem[0000000011800080] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011800090] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000118000a0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000118000b0] = ef9d6131 4f759486 00000000 00000000
	ldda	[%i3+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000011800080
!	Mem[0000000010800000] = 00000000, %l1 = 7dba48f1ba13c31b
	ldsha	[%i1+%g0]0x80,%l1	! %l1 = 0000000000000000

p0_label_188:
!	Mem[0000000010000000] = bc000000 00000000, %l4 = 00000000, %l5 = dd09e18d
	ldda	[%i0+%g0]0x80,%l4	! %l4 = 00000000bc000000 0000000000000000
!	Mem[0000000070800040] = 00000000 dba1f0f1, %l4 = bc000000, %l5 = 00000000
	ldd	[%o1+0x040],%l4		! %l4 = 0000000000000000 00000000dba1f0f1
!	Mem[0000000072000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000072000050] = eb6faf8a de8c3bef 00001136 ffffe276
!	Mem[0000000072000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000072000070] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[00000000108000e4] = 7201ef7f, %l4 = 0000000000000000
	lduh	[%i1+0x0e4],%l4		! %l4 = 0000000000007201
!	Mem[00000000118000c4] = 00000000, %l7 = 0000000054af7f61
	lduw	[%i3+0x0c4],%l7		! %l7 = 0000000000000000

p0_label_189:
!	Mem[0000000013000004] = 75f8fa0e, %l5 = 00000000dba1f0f1
	ldsw	[%i6+0x004],%l5		! %l5 = 0000000075f8fa0e
!	Mem[00000000108000a0] = 7fef0172 4aef341c, %l0 = efa727db, %l1 = 00000000
	ldda	[%i1+0x0a0]%asi,%l0	! %l0 = 000000007fef0172 000000004aef341c
!	Mem[0000000010000008] = ec8f424a, %l3 = 0000000011364742
	ldswa	[%i0+%o6]0x80,%l3	! %l3 = ffffffffec8f424a
!	%l0 = 000000007fef0172, immed = 00000bf6, %y  = 00000f80
	udivx	%l0,0xbf6,%l2		! %l2 = 00000000000ab229
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 00000000 00000000
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000110000c0

p0_label_190:
	membar	#Sync			! Added by membar checker (55)
!	%f16 = db27a7ef 00000000 ec8f424a 42473611
!	%f20 = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 5b27a7ef 00000000
	stda	%f16,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
	bl	p0_b68			! Branch Taken, %ccr = 09, CWP = 0
!	Mem[000000007200005c] = ffffe276, %l6 = 00000000ec8f424a
	lduw	[%o4+0x05c],%g2		! %g2 = 00000000ec8f424a
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x044,%g2
p0_b68:
!	%l5 = 0000000075f8fa0e, Mem[0000000011800008] = 11364742
	stwa	%l5,[%i3+%o6]0x80	! Mem[0000000011800008] = 75f8fa0e
!	Mem[0000000010800060] = 7fef01724aef341c, %l7 = 0000000000000000
	ldx	[%i1+0x060],%l7		! %l7 = 7fef01724aef341c

p0_label_191:
!	Mem[0000000071800040] = 27303ec3, %l2 = 00000000000ab229
	ldub	[%o3+0x042],%l2		! %l2 = 000000000000003e
!	Mem[0000000071800004] = 00007bf4, %l2 = 000000000000003e
	lduw	[%o3+0x004],%l2		! %l2 = 0000000000007bf4
	fbg,a	%fcc0,p0_branch_failed	! Branch Not Taken, %fcc0 = 1
!	Mem[0000000011800040] = bc00000000000000, %l7 = 7fef01724aef341c
	ldx	[%i3+0x040],%l7		! Annulled
p0_b69:
!	Mem[0000000011800000] = 00000000, %l7 = 7fef01724aef341c
	lduba	[%i3+%g0]0x80,%l7	! %l7 = 0000000000000000

p0_label_192:
!	%f16 = db27a7ef 00000000 ec8f424a 42473611
!	%f20 = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 5b27a7ef 00000000
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000011800040
	membar	#Sync			! Added by membar checker (56)
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 00000000 00000000
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	%f28 = 8694754f, %f20 = ef3b8cde 8aaf6feb
	fstod	%f28,%f20		! %f20 = b8d28ea9 e0000000
!	Mem[0000000070800040] = 00000000dba1f0f1, %l3 = ffffffffec8f424a
	ldx	[%o1+0x040],%l3		! %l3 = 00000000dba1f0f1
!	Mem[0000000071800040] = 27303ec3, %l7 = 0000000000000000
	ldsha	[%o3+0x040]%asi,%l7	! %l7 = 0000000000002730

p0_label_193:
!	%f16 = db27a7ef 00000000 ec8f424a 42473611
!	%f20 = b8d28ea9 e0000000 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 5b27a7ef 00000000
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000011800080
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 00000000 00000000
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000010000040
!	Mem[0000000011000000] = 00000000, %l6 = 00000000ec8f424a
	ldswa	[%i2+%g0]0x80,%l6	! %l6 = 0000000000000000
	membar	#Sync
	bge,a	p0_not_taken_0		! Branch Not Taken, %ccr = 09
!	%f12 = 8694754f 31619def, %f0  = bc000000 00000000, %f22 = 8de109dd 7824dd3e
	fdivd	%f12,%f0 ,%f22	! Annulled
p0_b70:

p0_label_194:
!	Mem[00000000108000f0] = ef9d6131, %l1 = 000000004aef341c
	lduha	[%i1+0x0f2]%asi,%l1	! %l1 = 0000000000006131
!	Mem[0000000010800008] = 11364742, %l1 = 0000000000006131
	ldswa	[%i1+%o6]0x80,%l1	! %l1 = 0000000011364742
!	Mem[00000000118000a0] = 1c34ef4a, %l4 = 0000000000007201
	lduwa	[%i3+0x0a0]%asi,%l4	! %l4 = 000000001c34ef4a
	set	p0_b71,%o7
	fbo,pt	%fcc1,p0_near_2_le	! Branch Taken, %fcc1 = 2
!	%f27 = d155a333, %f24 = 7fef0172
	fcmpes	%fcc0,%f27,%f24		! %fcc0 = 3
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p0_branch_failed
	mov	0x047,%g2
p0_b71:
!	Registers modified during the branch to p0_near_2
!	%l1  = ffffffffffffccaa
!	%l4  = ffffffffffffffc0
!	%l5  = ffffffa68086f116

p0_label_195:
!	%f16 = db27a7ef 00000000 ec8f424a 42473611
!	%f20 = b8d28ea9 e0000000 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 5b27a7ef 00000000
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 00000000100000c0
!	Mem[0000000072000070] = ef9d61314f759486, %l5 = ffffffa68086f116
	ldx	[%o4+0x070],%g2		! %g2 = ef9d61314f759486
!	%f0  = bc000000 00000000 ec8f424a 42473611
!	%f4  = ef3b8cde 8aaf6feb 8de109dd 7824dd3e
!	%f8  = 7fef0172 4aef341c f18b40d9 d155a333
!	%f12 = 8694754f 31619def 00000000 00000000
	stda	%f0,[%i2]ASI_BLK_PL	! Block Store to 0000000011000000
!	Mem[0000000071800040] = 27303ec39ba8c36b, %l1 = ffffffffffffccaa
	ldx	[%o3+0x040],%l1		! %l1 = 27303ec39ba8c36b
!	Mem[0000000010000040] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000010000050] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000010000060] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000010000070] = ef9d6131 4f759486 00000000 00000000
	ldda	[%i0+%g6]ASI_BLK_P,%f0	! Block Load from 0000000010000040

p0_label_196:
	membar	#Sync			! Added by membar checker (57)
!	Branch On Register, %l3 = 00000000dba1f0f1
	brnz,a,pn %l3,p0_b72		! Branch Taken
!	%f11 = d9408bf1, %f10 = 33a355d1 d9408bf1
	fstox	%f11,%f10		! %f10 = fff3f740 f0000000
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p0_branch_failed
	mov	0x048,%g2
p0_b72:
!	Mem[00000000100000c0] = 00000000 efa727db 11364742 4a428fec
!	Mem[00000000100000d0] = 000000e0 a98ed2b8 3edd2478 dd09e18d
!	Mem[00000000100000e0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000100000f0] = ef9d6131 4f759486 00000000 efa7275b
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000100000c0
!	Mem[00000000110000c0] = 00000000000000bc, %l4 = ffffffffffffffc0
	ldx	[%i2+0x0c0],%l4		! %l4 = 00000000000000bc
!	Mem[00000000110000a8] = 33a355d1, %l1 = 27303ec39ba8c36b
	lduba	[%i2+0x0ab]%asi,%l1	! %l1 = 00000000000000d1

p0_label_197:
!	%f4  = eb6faf8a, %f0  = 00000000, %f0  = 00000000 000000bc
	nop
!	Mem[00000000100000b0] = 8694754f31619def, %l1 = 00000000000000d1
	ldx	[%i0+0x0b0],%l1		! %l1 = 8694754f31619def
!	%l6 = 0000000000000000
	sethi	%hi(0x355d4800),%l6	! %l6 = 00000000355d4800
!	Mem[00000000118000f8] = 3a2565b7, %l0 = 000000007fef0172
	lduha	[%i3+0x0f8]%asi,%l0	! %l0 = 0000000000003a25
!	%f14 = 00000000 00000000, Mem[00000000118000c8] = ec8f424a 42473611
	std	%f14,[%i3+0x0c8]	! Mem[00000000118000c8] = 00000000 00000000

p0_label_198:
!	Mem[00000000108000d0] = eb6faf8ade8c3bef, %l7 = 0000000000002730
	ldx	[%i1+0x0d0],%l7		! %l7 = eb6faf8ade8c3bef
!	Mem[0000000011800000] = 00000000, %l1 = 8694754f31619def
	swapa	[%i3+%g0]0x80,%l1	! %l1 = 0000000000000000
!	%l7 = eb6faf8ade8c3bef, immed = 00000807, %y  = ffffffa6
	sdiv	%l7,0x807,%l7		! %l7 = fffffffff4e588b0
	mov	%l0,%y			! %y = 00003a25
!	%f16 = db27a7ef 00000000 ec8f424a 42473611
!	%f20 = b8d28ea9 e0000000 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 5b27a7ef 00000000
	stda	%f16,[%i0]ASI_BLK_P	! Block Store to 0000000010000000
!	Mem[0000000072000070] = ef9d61314f759486, %l0 = 0000000000003a25
	ldxa	[%o4+0x070]%asi,%g2	! %g2 = ef9d61314f759486

p0_label_199:
!	Mem[00000000100000c0] = 00000000 efa727db 11364742 4a428fec
!	Mem[00000000100000d0] = 000000e0 a98ed2b8 3edd2478 dd09e18d
!	Mem[00000000100000e0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000100000f0] = ef9d6131 4f759486 00000000 efa7275b
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000100000c0
!	%f0  = 00000000 000000bc 11364742 4a428fec
!	%f4  = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	%f8  = 1c34ef4a 7201ef7f fff3f740 f0000000
!	%f12 = ef9d6131 4f759486 00000000 00000000
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000110000c0
!	Mem[00000000108000c8] = 11364742, %l5 = ffffffa68086f116
	ldswa	[%i1+0x0c8]%asi,%l5	! %l5 = 0000000011364742
!	%f16 = db27a7ef 00000000 ec8f424a 42473611
!	%f20 = b8d28ea9 e0000000 8de109dd 7824dd3e
!	%f24 = 7fef0172 4aef341c f18b40d9 d155a333
!	%f28 = 8694754f 31619def 5b27a7ef 00000000
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000011800080
	membar	#Sync			! Added by membar checker (58)
!	Mem[0000000011800000] = 31619def 000000bc 75f8fa0e 4a428fec
!	Mem[0000000011800010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011800020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011800030] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000011800000

p0_label_200:
!	Mem[00000000108000c0] = 00000000 efa727db 11364742 4a428fec
!	Mem[00000000108000d0] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[00000000108000e0] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[00000000108000f0] = ef9d6131 4f759486 f0ed5a7f b765253a
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000108000c0
!	Mem[0000000011000000] = 00000000 000000bc 11364742 4a428fec
!	Mem[0000000011000010] = eb6faf8a de8c3bef 3edd2478 dd09e18d
!	Mem[0000000011000020] = 1c34ef4a 7201ef7f 33a355d1 d9408bf1
!	Mem[0000000011000030] = ef9d6131 4f759486 00000000 00000000
	ldda	[%i2]ASI_BLK_PL,%f0	! Block Load from 0000000011000000
	membar	#Sync			! Added by membar checker (59)
	set	p0_b73,%o7
	fbne	p0_far_2_he		! Branch Taken, %fcc0 = 3
!	Mem[0000000010000090] = ef3b8cde8aaf6feb, %l2 = 0000000000007bf4
	ldx	[%i0+0x090],%l2		! %l2 = ef3b8cde8aaf6feb
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p0_branch_failed
	mov	0x049,%g2
p0_b73:
!	Registers modified during the branch to p0_far_2
!	%l1  = 00000000000000fa
!	%l6  = 000000000000003e
!	%l7 = fffffffff4e588b0, %l1 = 00000000000000fa, %l6 = 000000000000003e
	subc	%l7,%l1,%l6		! %l6 = fffffffff4e587b5
	nop

1:	membar	#Sync			! Force all stores to complete

!	End of Random Code for Processor 0

	mov	2,%g2
	set	done_flags,%g1
	st	%g2,[%g1+0x000]		! Set processor 0 done flag

!	Check Registers

p0_check_registers:
	set	p0_expected_registers,%g1
	ldx	[%g1+0x000],%g2
	cmp	%l0,%g2			! %l0 should be 0000000000003a25
	bne,a,pn %xcc,p0_reg_l0_fail
	mov	%l0,%g3
	ldx	[%g1+0x008],%g2
	cmp	%l1,%g2			! %l1 should be 00000000000000fa
	bne,a,pn %xcc,p0_reg_l1_fail
	mov	%l1,%g3
	ldx	[%g1+0x010],%g2
	cmp	%l2,%g2			! %l2 should be ef3b8cde8aaf6feb
	bne,a,pn %xcc,p0_reg_l2_fail
	mov	%l2,%g3
	ldx	[%g1+0x018],%g2
	cmp	%l3,%g2			! %l3 should be 00000000dba1f0f1
	bne,a,pn %xcc,p0_reg_l3_fail
	mov	%l3,%g3
	ldx	[%g1+0x020],%g2
	cmp	%l4,%g2			! %l4 should be 00000000000000bc
	bne,a,pn %xcc,p0_reg_l4_fail
	mov	%l4,%g3
	ldx	[%g1+0x028],%g2
	cmp	%l5,%g2			! %l5 should be 0000000011364742
	bne,a,pn %xcc,p0_reg_l5_fail
	mov	%l5,%g3
	ldx	[%g1+0x030],%g2
	cmp	%l6,%g2			! %l6 should be fffffffff4e587b5
	bne,a,pn %xcc,p0_reg_l6_fail
	mov	%l6,%g3
	ldx	[%g1+0x038],%g2
	cmp	%l7,%g2			! %l7 should be fffffffff4e588b0
	bne,a,pn %xcc,p0_reg_l7_fail
	mov	%l7,%g3

!	Check %y register

	set	0x00003a25,%g2
	rd	%y,%g3
	cmp	%g2,%g3
	bne,a	p0_failed
	mov	0x111,%g1

!	Check Floating Point Registers

p0_check_fp_registers:
	set	p0_temp,%g1
	set	p0_expected_fp_regs,%g3
	std	%f0,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x00],%l0
	cmp	%l0,%l1			! %f0  should be bc000000 00000000
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf00,%g1
	std	%f2,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x08],%l0
	cmp	%l0,%l1			! %f2  should be ec8f424a 42473611
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf02,%g1
	std	%f4,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x10],%l0
	cmp	%l0,%l1			! %f4  should be ef3b8cde 8aaf6feb
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf04,%g1
	std	%f6,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x18],%l0
	cmp	%l0,%l1			! %f6  should be 8de109dd 7824dd3e
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf06,%g1
	std	%f8,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x20],%l0
	cmp	%l0,%l1			! %f8  should be 7fef0172 4aef341c
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf08,%g1
	std	%f10,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x28],%l0
	cmp	%l0,%l1			! %f10 should be f18b40d9 d155a333
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf10,%g1
	std	%f12,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x30],%l0
	cmp	%l0,%l1			! %f12 should be 8694754f 31619def
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf12,%g1
	std	%f14,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x38],%l0
	cmp	%l0,%l1			! %f14 should be 00000000 00000000
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf14,%g1
	std	%f16,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x40],%l0
	cmp	%l0,%l1			! %f16 should be db27a7ef 00000000
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf16,%g1
	std	%f18,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x48],%l0
	cmp	%l0,%l1			! %f18 should be ec8f424a 42473611
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf18,%g1
	std	%f20,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x50],%l0
	cmp	%l0,%l1			! %f20 should be ef3b8cde 8aaf6feb
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf20,%g1
	std	%f22,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x58],%l0
	cmp	%l0,%l1			! %f22 should be 8de109dd 7824dd3e
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf22,%g1
	std	%f24,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x60],%l0
	cmp	%l0,%l1			! %f24 should be 7fef0172 4aef341c
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf24,%g1
	std	%f26,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x68],%l0
	cmp	%l0,%l1			! %f26 should be f18b40d9 d155a333
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf26,%g1
	std	%f28,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x70],%l0
	cmp	%l0,%l1			! %f28 should be 8694754f 31619def
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf28,%g1
	std	%f30,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x78],%l0
	cmp	%l0,%l1			! %f30 should be 3a2565b7 7f5aedf0
	bne,a,pn	%xcc,p0_freg_fail
	or	%g0,0xf30,%g1

!	Check Local Memory

	set	p0_local0_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = db27a7ef00000000
	ldx	[%i0+0x000],%g3		! Observed data at 0000000010000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = ec8f424a42473611
	ldx	[%i0+0x008],%g3		! Observed data at 0000000010000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = b8d28ea9e0000000
	ldx	[%i0+0x010],%g3		! Observed data at 0000000010000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i0+0x018],%g3		! Observed data at 0000000010000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i0+0x020],%g3		! Observed data at 0000000010000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i0+0x028],%g3		! Observed data at 0000000010000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 8694754f31619def
	ldx	[%i0+0x030],%g3		! Observed data at 0000000010000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 5b27a7ef00000000
	ldx	[%i0+0x038],%g3		! Observed data at 0000000010000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 00000000000000bc
	ldx	[%i0+0x040],%g3		! Observed data at 0000000010000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 113647424a428fec
	ldx	[%i0+0x048],%g3		! Observed data at 0000000010000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i0+0x050],%g3		! Observed data at 0000000010000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i0+0x058],%g3		! Observed data at 0000000010000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i0+0x060],%g3		! Observed data at 0000000010000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i0+0x068],%g3		! Observed data at 0000000010000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = ef9d61314f759486
	ldx	[%i0+0x070],%g3		! Observed data at 0000000010000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 0000000000000000
	ldx	[%i0+0x078],%g3		! Observed data at 0000000010000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = bc00000000000000
	ldx	[%i0+0x080],%g3		! Observed data at 0000000010000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = ec8f424a42473611
	ldx	[%i0+0x088],%g3		! Observed data at 0000000010000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = ef3b8cde8aaf6feb
	ldx	[%i0+0x090],%g3		! Observed data at 0000000010000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i0+0x098],%g3		! Observed data at 0000000010000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i0+0x0a0],%g3		! Observed data at 00000000100000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i0+0x0a8],%g3		! Observed data at 00000000100000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 8694754f31619def
	ldx	[%i0+0x0b0],%g3		! Observed data at 00000000100000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 0000000000000000
	ldx	[%i0+0x0b8],%g3		! Observed data at 00000000100000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 00000000efa727db
	ldx	[%i0+0x0c0],%g3		! Observed data at 00000000100000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 113647424a428fec
	ldx	[%i0+0x0c8],%g3		! Observed data at 00000000100000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 000000e0a98ed2b8
	ldx	[%i0+0x0d0],%g3		! Observed data at 00000000100000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i0+0x0d8],%g3		! Observed data at 00000000100000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i0+0x0e0],%g3		! Observed data at 00000000100000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i0+0x0e8],%g3		! Observed data at 00000000100000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = ef9d61314f759486
	ldx	[%i0+0x0f0],%g3		! Observed data at 00000000100000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 00000000efa7275b
	ldx	[%i0+0x0f8],%g3		! Observed data at 00000000100000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f8,%g4

	set	p0_local1_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 00000000000000bc
	ldx	[%i1+0x000],%g3		! Observed data at 0000000010800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 113647424a428fec
	ldx	[%i1+0x008],%g3		! Observed data at 0000000010800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i1+0x010],%g3		! Observed data at 0000000010800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i1+0x018],%g3		! Observed data at 0000000010800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i1+0x020],%g3		! Observed data at 0000000010800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i1+0x028],%g3		! Observed data at 0000000010800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = ef9d61314f759486
	ldx	[%i1+0x030],%g3		! Observed data at 0000000010800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = f0ed5a7fb765253a
	ldx	[%i1+0x038],%g3		! Observed data at 0000000010800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = bc00000000000000
	ldx	[%i1+0x040],%g3		! Observed data at 0000000010800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = ec8f424a42473611
	ldx	[%i1+0x048],%g3		! Observed data at 0000000010800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = ef3b8cde8aaf6feb
	ldx	[%i1+0x050],%g3		! Observed data at 0000000010800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i1+0x058],%g3		! Observed data at 0000000010800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i1+0x060],%g3		! Observed data at 0000000010800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i1+0x068],%g3		! Observed data at 0000000010800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 8694754f31619def
	ldx	[%i1+0x070],%g3		! Observed data at 0000000010800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 0000000000000000
	ldx	[%i1+0x078],%g3		! Observed data at 0000000010800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = bc00000000000000
	ldx	[%i1+0x080],%g3		! Observed data at 0000000010800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = ec8f424a42473611
	ldx	[%i1+0x088],%g3		! Observed data at 0000000010800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = ef3b8cde8aaf6feb
	ldx	[%i1+0x090],%g3		! Observed data at 0000000010800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i1+0x098],%g3		! Observed data at 0000000010800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i1+0x0a0],%g3		! Observed data at 00000000108000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i1+0x0a8],%g3		! Observed data at 00000000108000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 8694754f31619def
	ldx	[%i1+0x0b0],%g3		! Observed data at 00000000108000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 3a2565b77f5aedf0
	ldx	[%i1+0x0b8],%g3		! Observed data at 00000000108000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 00000000efa727db
	ldx	[%i1+0x0c0],%g3		! Observed data at 00000000108000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 113647424a428fec
	ldx	[%i1+0x0c8],%g3		! Observed data at 00000000108000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i1+0x0d0],%g3		! Observed data at 00000000108000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i1+0x0d8],%g3		! Observed data at 00000000108000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i1+0x0e0],%g3		! Observed data at 00000000108000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i1+0x0e8],%g3		! Observed data at 00000000108000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = ef9d61314f759486
	ldx	[%i1+0x0f0],%g3		! Observed data at 00000000108000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = f0ed5a7fb765253a
	ldx	[%i1+0x0f8],%g3		! Observed data at 00000000108000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f8,%g4

	set	p0_local2_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 00000000000000bc
	ldx	[%i2+0x000],%g3		! Observed data at 0000000011000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 113647424a428fec
	ldx	[%i2+0x008],%g3		! Observed data at 0000000011000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i2+0x010],%g3		! Observed data at 0000000011000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i2+0x018],%g3		! Observed data at 0000000011000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i2+0x020],%g3		! Observed data at 0000000011000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i2+0x028],%g3		! Observed data at 0000000011000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = ef9d61314f759486
	ldx	[%i2+0x030],%g3		! Observed data at 0000000011000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 0000000000000000
	ldx	[%i2+0x038],%g3		! Observed data at 0000000011000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 00000000000000bc
	ldx	[%i2+0x040],%g3		! Observed data at 0000000011000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 113647424a428fec
	ldx	[%i2+0x048],%g3		! Observed data at 0000000011000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i2+0x050],%g3		! Observed data at 0000000011000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i2+0x058],%g3		! Observed data at 0000000011000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i2+0x060],%g3		! Observed data at 0000000011000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i2+0x068],%g3		! Observed data at 0000000011000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = ef9d61314f759486
	ldx	[%i2+0x070],%g3		! Observed data at 0000000011000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 00779a0eb765253a
	ldx	[%i2+0x078],%g3		! Observed data at 0000000011000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 00000000efa727db
	ldx	[%i2+0x080],%g3		! Observed data at 0000000011000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 113647424a428fec
	ldx	[%i2+0x088],%g3		! Observed data at 0000000011000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i2+0x090],%g3		! Observed data at 0000000011000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i2+0x098],%g3		! Observed data at 0000000011000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i2+0x0a0],%g3		! Observed data at 00000000110000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i2+0x0a8],%g3		! Observed data at 00000000110000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = ef9d61314f759486
	ldx	[%i2+0x0b0],%g3		! Observed data at 00000000110000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = f0ed5a7fb76525a1
	ldx	[%i2+0x0b8],%g3		! Observed data at 00000000110000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 00000000000000bc
	ldx	[%i2+0x0c0],%g3		! Observed data at 00000000110000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 113647424a428fec
	ldx	[%i2+0x0c8],%g3		! Observed data at 00000000110000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i2+0x0d0],%g3		! Observed data at 00000000110000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i2+0x0d8],%g3		! Observed data at 00000000110000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i2+0x0e0],%g3		! Observed data at 00000000110000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = fff3f740f0000000
	ldx	[%i2+0x0e8],%g3		! Observed data at 00000000110000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = ef9d61314f759486
	ldx	[%i2+0x0f0],%g3		! Observed data at 00000000110000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 0000000000000000
	ldx	[%i2+0x0f8],%g3		! Observed data at 00000000110000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f8,%g4

	set	p0_local3_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 31619def000000bc
	ldx	[%i3+0x000],%g3		! Observed data at 0000000011800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 75f8fa0e4a428fec
	ldx	[%i3+0x008],%g3		! Observed data at 0000000011800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i3+0x010],%g3		! Observed data at 0000000011800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i3+0x018],%g3		! Observed data at 0000000011800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i3+0x020],%g3		! Observed data at 0000000011800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i3+0x028],%g3		! Observed data at 0000000011800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = ef9d61314f759486
	ldx	[%i3+0x030],%g3		! Observed data at 0000000011800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = f0ed5a7fb765253a
	ldx	[%i3+0x038],%g3		! Observed data at 0000000011800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = db27a7ef00000000
	ldx	[%i3+0x040],%g3		! Observed data at 0000000011800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = ec8f424a42473611
	ldx	[%i3+0x048],%g3		! Observed data at 0000000011800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = ef3b8cde8aaf6feb
	ldx	[%i3+0x050],%g3		! Observed data at 0000000011800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i3+0x058],%g3		! Observed data at 0000000011800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i3+0x060],%g3		! Observed data at 0000000011800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i3+0x068],%g3		! Observed data at 0000000011800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 8694754f31619def
	ldx	[%i3+0x070],%g3		! Observed data at 0000000011800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 5b27a7ef00000000
	ldx	[%i3+0x078],%g3		! Observed data at 0000000011800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 00000000efa727db
	ldx	[%i3+0x080],%g3		! Observed data at 0000000011800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 113647424a428fec
	ldx	[%i3+0x088],%g3		! Observed data at 0000000011800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 000000e0a98ed2b8
	ldx	[%i3+0x090],%g3		! Observed data at 0000000011800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i3+0x098],%g3		! Observed data at 0000000011800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i3+0x0a0],%g3		! Observed data at 00000000118000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i3+0x0a8],%g3		! Observed data at 00000000118000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = ef9d61314f759486
	ldx	[%i3+0x0b0],%g3		! Observed data at 00000000118000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 00000000efa7275b
	ldx	[%i3+0x0b8],%g3		! Observed data at 00000000118000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = db27a7ef00000000
	ldx	[%i3+0x0c0],%g3		! Observed data at 00000000118000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 0000000000000000
	ldx	[%i3+0x0c8],%g3		! Observed data at 00000000118000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = ef3b8cde8aaf6feb
	ldx	[%i3+0x0d0],%g3		! Observed data at 00000000118000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i3+0x0d8],%g3		! Observed data at 00000000118000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i3+0x0e0],%g3		! Observed data at 00000000118000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i3+0x0e8],%g3		! Observed data at 00000000118000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 8694754f31619def
	ldx	[%i3+0x0f0],%g3		! Observed data at 00000000118000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 3a2565b77f5aedf0
	ldx	[%i3+0x0f8],%g3		! Observed data at 00000000118000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0f8,%g4

	set	p0_local4_expect,%g1

!	Processor 0, local 4 is clean


	set	p0_local5_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 5c58d14bf1f0a1db
	ldx	[%i5+0x000],%g3		! Observed data at 0000000012800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = a9a7a91bd3398026
	ldx	[%i5+0x008],%g3		! Observed data at 0000000012800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 76fd123c161e942c
	ldx	[%i5+0x010],%g3		! Observed data at 0000000012800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 7c60467e702cfbce
	ldx	[%i5+0x018],%g3		! Observed data at 0000000012800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = be57b521804fdaea
	ldx	[%i5+0x020],%g3		! Observed data at 0000000012800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = b289a9f5617faf54
	ldx	[%i5+0x028],%g3		! Observed data at 0000000012800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = b28929f5e61e4204
	ldx	[%i5+0x030],%g3		! Observed data at 0000000012800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 28f2bcf33e2da712
	ldx	[%i5+0x038],%g3		! Observed data at 0000000012800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 00000000efa727db
	ldx	[%i5+0x040],%g3		! Observed data at 0000000012800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 113647424a428fec
	ldx	[%i5+0x048],%g3		! Observed data at 0000000012800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i5+0x050],%g3		! Observed data at 0000000012800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i5+0x058],%g3		! Observed data at 0000000012800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i5+0x060],%g3		! Observed data at 0000000012800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 33a355d10030a3fb
	ldx	[%i5+0x068],%g3		! Observed data at 0000000012800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = ef9d61314f759486
	ldx	[%i5+0x070],%g3		! Observed data at 0000000012800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = f0ed5a7fb765253a
	ldx	[%i5+0x078],%g3		! Observed data at 0000000012800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 4e3fc6f6a771d55e
	ldx	[%i5+0x080],%g3		! Observed data at 0000000012800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 9ab12eb2ac9dc3ea
	ldx	[%i5+0x088],%g3		! Observed data at 0000000012800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 356877b15f8401f5
	ldx	[%i5+0x090],%g3		! Observed data at 0000000012800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = e734181e316aacbc
	ldx	[%i5+0x098],%g3		! Observed data at 0000000012800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = c7182cd6f8cf7704
	ldx	[%i5+0x0a0],%g3		! Observed data at 00000000128000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 17d2979ee9372065
	ldx	[%i5+0x0a8],%g3		! Observed data at 00000000128000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = ea87daf8c4332c36
	ldx	[%i5+0x0b0],%g3		! Observed data at 00000000128000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 9c5031ee15ba9fc5
	ldx	[%i5+0x0b8],%g3		! Observed data at 00000000128000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b8,%g4

	set	p0_local6_expect,%g1
	ldx	[%g1+0x040],%g2		! Expect data = 00000000efa727db
	ldx	[%i6+0x040],%g3		! Observed data at 0000000013000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 113647424a428fec
	ldx	[%i6+0x048],%g3		! Observed data at 0000000013000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = eb6faf8ade8c3bef
	ldx	[%i6+0x050],%g3		! Observed data at 0000000013000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 3edd2478dd09e18d
	ldx	[%i6+0x058],%g3		! Observed data at 0000000013000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 1c34ef4a7201ef7f
	ldx	[%i6+0x060],%g3		! Observed data at 0000000013000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 33a355d1d9408bf1
	ldx	[%i6+0x068],%g3		! Observed data at 0000000013000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = ef9d61314f759486
	ldx	[%i6+0x070],%g3		! Observed data at 0000000013000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = f0ed5a7fb765253a
	ldx	[%i6+0x078],%g3		! Observed data at 0000000013000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = bc00000000000000
	ldx	[%i6+0x080],%g3		! Observed data at 0000000013000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = ec8f424a42473611
	ldx	[%i6+0x088],%g3		! Observed data at 0000000013000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = ef3b8cde8aaf6feb
	ldx	[%i6+0x090],%g3		! Observed data at 0000000013000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 8de109dd7824dd3e
	ldx	[%i6+0x098],%g3		! Observed data at 0000000013000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 7fef01724aef341c
	ldx	[%i6+0x0a0],%g3		! Observed data at 00000000130000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = f18b40d9d155a333
	ldx	[%i6+0x0a8],%g3		! Observed data at 00000000130000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 8694754f31619def
	ldx	[%i6+0x0b0],%g3		! Observed data at 00000000130000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 3a2565b77f5aedf0
	ldx	[%i6+0x0b8],%g3		! Observed data at 00000000130000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p0_local_failed
	mov	0x0b8,%g4


!	Check Shared Memory
	set	share0_expect,%g4
	set	p0_share_mask,%g5
	set	0x70000000,%g6	! Physical Addr of Share 0
p0_memcheck_share0:
	ldx	[%g4+0x00],%g2	! Expected value = fa331446ffc3f718
	ldx	[%o0+0x00],%g3	! Read value at Mem[0000000070000000]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x000,%g1
	ldx	[%g4+0x40],%g2	! Expected value = f67031eab765253a
	ldx	[%o0+0x40],%g3	! Read value at Mem[0000000070000040]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x040,%g1
	set	share1_expect,%g4
	set	0x70800000,%g6	! Physical Addr of Share 1
p0_memcheck_share1:
	ldx	[%g4+0x00],%g2	! Expected value = 2686ccaa356877b1
	ldx	[%o1+0x00],%g3	! Read value at Mem[0000000070800000]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x000,%g1
	ldx	[%g4+0x40],%g2	! Expected value = 00000000dba1f0f1
	ldx	[%o1+0x40],%g3	! Read value at Mem[0000000070800040]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x040,%g1
	set	share2_expect,%g4
	set	0x71000000,%g6	! Physical Addr of Share 2
p0_memcheck_share2:
	ldx	[%g4+0x00],%g2	! Expected value = 54af7f611abc27eb
	ldx	[%o2+0x00],%g3	! Read value at Mem[0000000071000000]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x000,%g1
	ldx	[%g4+0x40],%g2	! Expected value = bc00000000000000
	ldx	[%o2+0x40],%g3	! Read value at Mem[0000000071000040]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x040,%g1
	set	share3_expect,%g4
	set	0x71800000,%g6	! Physical Addr of Share 3
p0_memcheck_share3:
	ldx	[%g4+0x00],%g2	! Expected value = 0000000000007bf4
	ldx	[%o3+0x00],%g3	! Read value at Mem[0000000071800000]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x000,%g1
	ldx	[%g4+0x40],%g2	! Expected value = 27303ec39ba8c36b
	ldx	[%o3+0x40],%g3	! Read value at Mem[0000000071800040]
	cmp	%g2,%g3
	bne,pn	%xcc,p0_failed
	add	%g6,0x040,%g1

!	The test for processor 0 has passed

p0_passed:
	ta	GOOD_TRAP
	nop

p0_reg_l0_fail:
	or	%g0,0xbd0,%g1
	ba,a	p0_failed
p0_reg_l1_fail:
	or	%g0,0xbd1,%g1
	ba,a	p0_failed
p0_reg_l2_fail:
	or	%g0,0xbd2,%g1
	ba,a	p0_failed
p0_reg_l3_fail:
	or	%g0,0xbd3,%g1
	ba,a	p0_failed
p0_reg_l4_fail:
	or	%g0,0xbd4,%g1
	ba,a	p0_failed
p0_reg_l5_fail:
	or	%g0,0xbd5,%g1
	ba,a	p0_failed
p0_reg_l6_fail:
	or	%g0,0xbd6,%g1
	ba,a	p0_failed
p0_reg_l7_fail:
	or	%g0,0xbd7,%g1
	ba,a	p0_failed
p0_freg_fail:
	mov	%l0,%g3
	ba	p0_failed
	mov	%l1,%g2


!	The test for processor 0 failed

p0_failed:
	set	done_flags,%g1
	mov	3,%g5
	st	%g5,[%g1+0x000]		! Set processor 0 done flag

	set	p0_temp,%g6
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p0_freg_failed:
	ba,a	p0_failed

!	The local area data for processor 0 failed

p0_local_failed:
	set	done_flags,%g5
	mov	3,%g6
	st	%g5,[%g5+0x000]		! Set processor 0 done flag

	set	p0_temp,%g6
	add	%g1,%g4,%g1
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p0_dfill_failed:
	ba	p0_failed
	mov	0xddd,%g1

p0_selfmod_failed:
	ba	p0_failed
	mov	0xabc,%g1


p0_common_error:
	or	%g0,0xee0,%g1
	ba	p0_failed
	mov	%o5,%g3

p0_common_signature_error:
	set	p0_temp,%g1
	ba	p0_failed
	st	%g2,[%g1]			! Common Lock Number

p0_common_timeout:
	set	p0_temp,%g1
	ba	p0_failed
	st	%g2,[%g1]			! Common Lock Number

common_failed:
	ba	p0_failed
	nop
p0_branch_failed:
	mov	0xbbb,%g1
	rd	%ccr,%g2
	ba	p0_failed
	mov	0x0,%g3

p0_trap1e:
	lduw	[%i1+0x098],%l3		! Mem[0000000010800098]
	and	%l1,0x945,%l4
	done

p0_trap1o:
	lduw	[%o1+0x098],%l3		! Mem[0000000010800098]
	and	%l1,0x945,%l4
	done


p0_trap2e:
	ldsw	[%o2+0x000],%l0		! Mem[0000000071000000]
	smulcc	%l4,%l0,%l0
	lduw	[%o0+0x004],%l7		! Mem[0000000070000004]
	done

p0_trap2o:
	ldsw	[%i2+0x000],%l0		! Mem[0000000071000000]
	smulcc	%l4,%l0,%l0
	lduw	[%i0+0x004],%l7		! Mem[0000000070000004]
	done


p0_init_memory_pointers:
	set	p0_init_registers,%g1
	mov	%g0,%g4
	mov	%g0,%g5
	mov	%g0,%g6
	mov	%g0,%g7

!	Initialize memory pointers for window 0
	set	p0_local0_start,%i0
	set	p0_local1_start,%i1
	set	p0_local2_start,%i2
	set	p0_local3_start,%i3
	set	p0_local4_start,%i4
	set	p0_local5_start,%i5
	set	p0_local6_start,%i6
	mov	%g0,%i7
!	Init Local Registers in Window 0
	ldx	[%g1+0x000],%l0	! %l0 = 5e9d522444f0f93a
	ldx	[%g1+0x008],%l1	! %l1 = 9be9ee0832e53850
	ldx	[%g1+0x010],%l2	! %l2 = e81372800dab120e
	ldx	[%g1+0x018],%l3	! %l3 = d6fc58a2678e8718
	ldx	[%g1+0x020],%l4	! %l4 = b9540090918daa92
	ldx	[%g1+0x028],%l5	! %l5 = bb3f41da006c0efb
	ldx	[%g1+0x030],%l6	! %l6 = 36f47b16611c5881
	ldx	[%g1+0x038],%l7	! %l7 = 83cf5e9254012454

!	Initialize the output register of window 0
	set	share0_start,%o0
	set	share1_start,%o1
	set	share2_start,%o2
	set	share3_start,%o3
	set	unres0_start,%o4
	set	common_start,%o5
	mov	0x08,%o6

	retl
	nop

!	Random code for Processor 1

processor_1:
	ta	T_CHANGE_PRIV
	set	done_flags,%g1
	mov	1,%g2
	st	%g2,[%g1+0x04]		! Set the start flag
	wrpr	%g0,7,%cleanwin
	call	p1_init_memory_pointers
	wr	%g0,0x80,%asi		! Setting default asi to 80

!	Initialize the floating point registers for processor 1

	wr	%g0,0x4,%fprs		! Make sure fef is 1
	set	p1_init_freg,%g1
!	%f0  = 5b1ae570 a1b09d17 ed7ad203 0fda6e7d
!	%f4  = ddd7a166 6b6489bf abeb0a28 ce8be98e
!	%f8  = a4487c4d 6bec2525 445c63b4 613af1a9
!	%f12 = df5366b3 0d9d5a46 21b04e03 d7bde639
	ldda	[%g1]ASI_BLK_P,%f0
	add	%g1,64,%g1
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	ldda	[%g1]ASI_BLK_P,%f16
	add	%g1,64,%g1
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	ldda	[%g1]ASI_BLK_P,%f32
	xorcc	%g0,%g0,%g3		! init %g3 and set flags
	membar	#Sync			! Force the block loads to complete

!	Start of Random Code for processor 1

p1_label_1:
!	Mem[0000000015000008] = 432751c8, %l0 = 1996cf608d354b88
	ldswa	[%i2+%o6]0x80,%l0	! %l0 = 00000000432751c8
!	%l4 = 10862c7df5d22f06, immed = 000008df, %l5 = 2f4fe893db141a6d
	taddcc	%l4,0x8df,%l5		! %l5 = 10862c7df5d237e5, %ccr = 0a
!	%f0  = 5b1ae570 a1b09d17 ed7ad203 0fda6e7d
!	%f4  = ddd7a166 6b6489bf abeb0a28 ce8be98e
!	%f8  = a4487c4d 6bec2525 445c63b4 613af1a9
!	%f12 = df5366b3 0d9d5a46 21b04e03 d7bde639
	mov	0x080,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 0000000014800080
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[0000000014800100] = 844ed727 a6612a40 b70116f9 fa479b22
!	Mem[0000000014800110] = a3b95d5b 2914d2fd cc72639a d4f36584
!	Mem[0000000014800120] = d5cfa868 abaea779 e833f9ff 73d3d92a
!	Mem[0000000014800130] = 1452a62d 646d689a beda83f8 d61f0c18
	mov	0x100,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000014800100

p1_label_2:
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x1c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000158001c0
!	Mem[0000000014000008] = de46c45b, %l3 = 00c655b8fd87bc77
	lduwa	[%i0+%o6]0x80,%l3	! %l3 = 00000000de46c45b
!	Mem[000000007100000c] = 9aaa134e, %l4 = 10862c7df5d22f06
	ldsw	[%o2+0x00c],%l4		! %l4 = ffffffff9aaa134e
!	%f0  = 402a61a6, %f0  = 402a61a6 27d74e84
	fitod	%f0 ,%f0 		! %f0  = 41d00a98 69800000
!	Mem[00000000150001c8] = b9c80a02e95176cf, %l4 = ffffffff9aaa134e
	ldx	[%i2+0x1c8],%l4		! %l4 = b9c80a02e95176cf

p1_label_3:
!	Mem[0000000015800008] = 0d26ca18, %l5 = 10862c7df5d237e5
	ldsha	[%i3+%o6]0x80,%l5	! %l5 = 0000000000000d26
!	Mem[0000000070800008] = d073a5b5, %l4 = b9c80a02e95176cf
	ldsha	[%o1+0x00a]%asi,%l4	! %l4 = ffffffffffffa5b5
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x0c0,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000148000c0
!	Mem[0000000070800008] = d073a5b5, %l3 = 00000000de46c45b
	ldswa	[%o1+0x008]%asi,%l3	! %l3 = ffffffffd073a5b5
!	Mem[0000000072000030] = 790dd6f6d3242102, %l3 = ffffffffd073a5b5
	ldx	[%o4+0x030],%g2		! %g2 = 790dd6f6d3242102

p1_label_4:
!	Mem[0000000014000080] = 6bc0a4db 8eacfad6 fde26ca5 ce8e35ce
!	Mem[0000000014000090] = e763f0f5 eff3afea 023cea87 f4c0aed0
!	Mem[00000000140000a0] = 5641496e e09b03f2 51b6b499 4f368b00
!	Mem[00000000140000b0] = c917428c f1cd6608 534dc94a 53a7ec7b
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000014000080
!	Mem[0000000015000008] = 432751c808dabd8f, %l2 = 11ed888c7a3cfbb5
	ldxa	[%i2+%o6]0x80,%l2	! %l2 = 432751c808dabd8f
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000007080000c] = e7fbca1a, %l3 = ffffffffd073a5b5
	lduba	[%o1+0x00d]%asi,%l3	! %l3 = 00000000000000fb
!	%f16 = d6faac8e dba4c06b ce358ece a56ce2fd
!	%f20 = eaaff3ef f5f063e7 d0aec0f4 87ea3c02
!	%f24 = f2039be0 6e494156 008b364f 99b4b651
!	%f28 = 0866cdf1 8c4217c9 7beca753 4ac94d53
	mov	0x1c0,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000150001c0

p1_label_5:
!	Mem[00000000140001b0] = e12b93949847ba39, %l2 = 432751c808dabd8f
	ldx	[%i0+0x1b0],%l2		! %l2 = e12b93949847ba39
!	Mem[00000000150000c0] = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	Mem[00000000150000d0] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[00000000150000e0] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[00000000150000f0] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 00000000150000c0
	ba	p1_b1			! Branch Taken, %ccr = 0a, CWP = 0
!	Mem[0000000040a00018] = 1f1f3e1d0a242719, %l4 = ffffffffffffa5b5
	ldx	[%o5+0x018],%l4		! %l4 = 1f1f3e1d0a242719
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p1_branch_failed
	mov	0x001,%g2
p1_b1:
	membar	#Sync			! Added by membar checker (60)
!	Mem[000000007200003c] = fc5c1922, %l3 = 00000000000000fb
	lduw	[%o4+0x03c],%g2		! %g2 = 00000000000000fb

p1_label_6:
!	Mem[00000000148001ec] = ce91a4e8, %l2 = e12b93949847ba39
	ldsb	[%i1+0x1ed],%l2		! %l2 = ffffffffffffff91
!	Mem[000000001480007c] = 65297c15, %l0 = 00000000432751c8
	lduha	[%i1+0x07e]%asi,%l0	! %l0 = 0000000000007c15
!	%f0  = 41d00a98 69800000 229b47fa f91601b7
!	%f4  = fdd21429 5b5db9a3 8465f3d4 9a6372cc
!	%f8  = 79a7aeab 68a8cfd5 2ad9d373 fff933e8
!	%f12 = 9a686d64 2da65214 180c1fd6 f883dabe
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[00000000140001f4] = ed75cfdd, %l5 = 0000000000000d26
	ldsh	[%i0+0x1f4],%l5		! %l5 = ffffffffffffed75
!	Mem[0000000014800008] = 3c9b646d, %l4 = 1f1f3e1d0a242719
	lduba	[%i1+%o6]0x80,%l4	! %l4 = 000000000000003c

p1_label_7:
!	Mem[00000000140000c0] = 568d34e0 e8ea7110 1f2600fb 8b4adfb1
	prefetcha [%i0+0x0c0]%asi,3
	bcs	p1_not_taken_0		! Branch Not Taken, %ccr = 0a
!	Mem[0000000070800008] = d073a5b5, %l5 = ffffffffffffed75
	lduw	[%o1+0x008],%l5		! %l5 = 00000000d073a5b5
p1_b2:
!	%f0  = 41d00a98 69800000 229b47fa f91601b7
!	%f4  = fdd21429 5b5db9a3 8465f3d4 9a6372cc
!	%f8  = 79a7aeab 68a8cfd5 2ad9d373 fff933e8
!	%f12 = 9a686d64 2da65214 180c1fd6 f883dabe
	mov	0x140,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000015000140
!	%f16 = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	%f20 = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000015000180

p1_label_8:
!	%f16 = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	%f20 = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 0000000014000140
	membar	#Sync			! Added by membar checker (61)
!	%f0  = 41d00a98 69800000 229b47fa f91601b7
!	%f4  = fdd21429 5b5db9a3 8465f3d4 9a6372cc
!	%f8  = 79a7aeab 68a8cfd5 2ad9d373 fff933e8
!	%f12 = 9a686d64 2da65214 180c1fd6 f883dabe
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000015000180
!	Mem[0000000071000008] = 30fb933b9aaa134e, %l0 = 0000000000007c15
	ldx	[%o2+0x008],%l0		! %l0 = 30fb933b9aaa134e
!	Mem[0000000014800040] = c1d5b8cf 505b1665 535867d3 ae2f9f9a
!	Mem[0000000014800050] = 8eff8eaf 9412d179 d51f794d 8457edcd
!	Mem[0000000014800060] = 152ecec7 4baed4ef 2be8d2c2 22f096c2
!	Mem[0000000014800070] = 624713d4 e80fab7c 9971c7fa 65297c15
	mov	0x040,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014800040
	fblg	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0

p1_label_9:
!	Mem[000000001400011c] = ff12cafc, %l1 = e6cacca6882f6221
	ldub	[%i0+0x11f],%l1		! %l1 = 00000000000000fc
p1_b3:
!	Mem[0000000015000080] = b0337635 06b4bf27 42c07c57 1b2da691
!	Mem[0000000015000090] = 1be2a552 d765f5a0 740b1a66 bfc87f5a
!	Mem[00000000150000a0] = 0fa4fd56 04a359f2 a9092a47 3103e88c
!	Mem[00000000150000b0] = c63c5f92 883dbe1a 8997f496 2689635e
	mov	0x080,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000015000080
!	Mem[0000000071800008] = ec5183f86bb560e4, %l2 = ffffffffffffff91
	ldx	[%o3+0x008],%l2		! %l2 = ec5183f86bb560e4
!	Mem[0000000014800000] = 2c3de8f2, %l2 = ec5183f86bb560e4
	ldsha	[%i1+%g0]0x80,%l2	! %l2 = 0000000000002c3d
!	Mem[000000007100000c] = 9aaa134e, %l1 = 00000000000000fc
	lduba	[%o2+0x00c]%asi,%l1	! %l1 = 000000000000009a

p1_label_10:
!	Mem[0000000014000160] = 57e06ff3640f343c, %l0 = 30fb933b9aaa134e
	ldx	[%i0+0x160],%l0		! %l0 = 57e06ff3640f343c
!	%f16 = 27bfb406 357633b0 91a62d1b 577cc042
!	%f20 = a0f565d7 52a5e21b 5a7fc8bf 661a0b74
!	%f24 = f259a304 56fda40f 8ce80331 472a09a9
!	%f28 = 1abe3d88 925f3cc6 5e638926 96f49789
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000014000040
!	%f1  = 505b1665, %f12 = 624713d4 e80fab7c
	fitod	%f1 ,%f12		! %f12 = 41d416c5 99400000
!	%l7 = 500668c6301c0df2, immed = fffff000, %y  = 00000000
	udivcc	%l7,-0x1000,%l3		! %l3 = 0000000000000000, %ccr = 44
	mov	%l0,%y			! %y = 640f343c
!	%f16 = 27bfb406 357633b0 91a62d1b 577cc042
!	%f20 = a0f565d7 52a5e21b 5a7fc8bf 661a0b74
!	%f24 = f259a304 56fda40f 8ce80331 472a09a9
!	%f28 = 1abe3d88 925f3cc6 5e638926 96f49789
	mov	0x140,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000015000140

p1_label_11:
!	Mem[0000000015000100] = afb28154 65c01aa5 dcc3b844 e1bfb531
!	Mem[0000000015000110] = 67264812 6c743d02 7664f91c 42af8257
!	Mem[0000000015000120] = 6f000aeb 31d6310c 78a32a32 9d0bd8e4
!	Mem[0000000015000130] = 1e7410eb 285586d5 7bdb9203 ddc78455
	mov	0x100,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000015000100
!	%f0  = c1d5b8cf 505b1665 535867d3 ae2f9f9a
!	%f4  = 8eff8eaf 9412d179 d51f794d 8457edcd
!	%f8  = 152ecec7 4baed4ef 2be8d2c2 22f096c2
!	%f12 = 41d416c5 99400000 9971c7fa 65297c15
	mov	0x0c0,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000158000c0
	membar	#Sync
	bneg,a	p1_not_taken_0		! Branch Not Taken, %ccr = 44
!	Mem[0000000071000008] = 30fb933b9aaa134e, %l4 = 000000000000003c
	ldx	[%o2+0x008],%l4		! Annulled
p1_b4:
!	Mem[0000000015800098] = 6c00bc5be38dbf4c, %l2 = 0000000000002c3d
	ldxa	[%i3+0x098]%asi,%l2	! %l2 = 6c00bc5be38dbf4c

p1_label_12:
!	Mem[0000000014000008] = de46c45b, %l4 = 000000000000003c
	ldsba	[%i0+%o6]0x80,%l4	! %l4 = ffffffffffffffde
!	Mem[000000007200002c] = fff933e8, %l7 = 500668c6301c0df2
	lduw	[%o4+0x02c],%g2		! %g2 = 500668c6301c0df2
!	%l1 = 000000000000009a, %l6 = 11aa74b0b6fc1071, %l0 = 57e06ff3640f343c
	srax	%l1,%l6,%l0		! %l0 = 0000000000000000
!	Mem[00000000140000d8] = f814a3d50a1cc25d, %l5 = 00000000d073a5b5
	ldx	[%i0+0x0d8],%l5		! %l5 = f814a3d50a1cc25d
!	Mem[00000000150000cc] = 32bd6c16, %l2 = 6c00bc5be38dbf4c
	ldsba	[%i2+0x0cd]%asi,%l2	! %l2 = ffffffffffffffbd

p1_label_13:
!	Mem[0000000015800008] = 0d26ca18, %l6 = 11aa74b0b6fc1071
	lduwa	[%i3+%o6]0x80,%l6	! %l6 = 000000000d26ca18
	fbul,a,pn %fcc1,p1_branch_failed	! Branch Not Taken, %fcc1 = 0
!	Mem[0000000014000008] = de46c45ba278c8a3, %l1 = 000000000000009a
	ldxa	[%i0+%o6]0x80,%l1	! Annulled
p1_b5:
	bne	p1_not_taken_0		! Branch Not Taken, %ccr = 44
!	Mem[0000000014800008] = 3c9b646d, %l5 = f814a3d50a1cc25d
	lduha	[%i1+%o6]0x80,%l5	! %l5 = 0000000000003c9b
p1_b6:

p1_label_14:
	set	p1_b7,%o7
	fbue	p1_far_0_he		! Branch Taken, %fcc0 = 0
!	%l3 = 0000000000000000, immed = fffff5c4, %y  = 640f343c
	mulx	%l3,-0xa3c,%l2		! %l2 = 0000000000000000
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x007,%g2
p1_b7:
!	Registers modified during the branch to p1_far_0
!	%l3  = ffffffffc917428c
!	%l4  = 0000000000003c01
!	%l6  = 147e4bd6a3bab275
!	Mem[000000007000000c] = 6a3389dd, %l7 = 500668c6301c0df2
	lduw	[%o0+0x00c],%l7		! %l7 = 000000006a3389dd
!	%f0  = c1d5b8cf 505b1665 535867d3 ae2f9f9a
!	%f4  = 8eff8eaf 9412d179 d51f794d 8457edcd
!	%f8  = 152ecec7 4baed4ef 2be8d2c2 22f096c2
!	%f12 = 41d416c5 99400000 9971c7fa 65297c15
	stda	%f0,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000015000010] = 4d7d2c82, %l6 = 147e4bd6a3bab275
	ldsw	[%i2+0x010],%l6		! %l6 = 000000004d7d2c82

p1_label_15:
!	Mem[0000000015000000] = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	Mem[0000000015000010] = 4d7d2c82 0024061c ad511a45 c88e483c
!	Mem[0000000015000020] = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	Mem[0000000015000030] = 656579ae b04685b8 e5386ad3 4e7a987c
	ldda	[%i2]ASI_BLK_PL,%f16	! Block Load from 0000000015000000
!	%l7 = 000000006a3389dd, immed = 00000e1e, %y  = 640f343c
	sdivcc	%l7,0xe1e,%l2		! %l2 = 000000007fffffff, %ccr = 02
	mov	%l0,%y			! %y = 00000000
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
	membar	#Sync			! Added by membar checker (62)
!	Mem[0000000072000040] = 65165b50 cfb8d5c1 9a9f2fae d3675853
!	Mem[0000000072000050] = 79d11294 af8eff8e cded5784 4d791fd5
!	Mem[0000000072000060] = efd4ae4b c7ce2e15 c296f022 c2d2e82b
!	Mem[0000000072000070] = 00004099 c516d441 157c2965 fac77199
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%f16 = 15a1b990 b59f5a4e, Mem[0000000071800008] = ec5183f8 6bb560e4
	std	%f16,[%o3+0x008]	! Mem[0000000071800008] = 15a1b990 b59f5a4e

p1_label_16:
!	Mem[00000000158001a0] = 2939293e 7e0d6c1e, %l0 = 00000000, %l1 = 0000009a
	ldda	[%i3+0x1a0]%asi,%l0	! %l0 = 000000002939293e 000000007e0d6c1e
!	Mem[0000000071800008] = 15a1b990, %l7 = 000000006a3389dd
	ldsb	[%o3+0x00a],%l7		! %l7 = ffffffffffffffb9
!	Mem[000000007080000a] = d073a5b5, %l0 = 000000002939293e
	ldstuba	[%o1+0x00a]%asi,%l0	! %l0 = 00000000000000a5
!	%f16 = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	%f20 = 1c062400 822c7d4d 3c488ec8 451a51ad
!	%f24 = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	%f28 = b88546b0 ae796565 7c987a4e d36a38e5
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000015000000
	membar	#Sync			! Added by membar checker (63)
!	Mem[0000000015000000] = 4e5a9fb590b9a115, %l3 = ffffffffc917428c
	ldxa	[%i2+%g0]0x80,%l3	! %l3 = 4e5a9fb590b9a115

p1_label_17:
	set	p1_b8,%o7
	fble,a,pt %fcc2,p1_near_2_he	! Branch Taken, %fcc2 = 0
!	Mem[0000000070000008] = 3cb84dfe6a3389dd, %l3 = 4e5a9fb590b9a115
	ldx	[%o0+0x008],%l3		! %l3 = 3cb84dfe6a3389dd
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p1_branch_failed
	mov	0x008,%g2
p1_b8:
!	Registers modified during the branch to p1_near_2
!	%l0  = 1452a62d646d689a
!	%l2  = 01e5c26ff3519c4e
!	%l7  = 000000c2a166ca86
!	Mem[0000000015000000] = 4e5a9fb5, %l5 = 0000000000003c9b
	lduwa	[%i2+%g0]0x80,%l5	! %l5 = 000000004e5a9fb5
!	Mem[000000007100004c] = 3d7d8502, %l7 = 000000c2a166ca86
	ldsw	[%o2+0x04c],%l7		! %l7 = 000000003d7d8502
!	Mem[0000000070000048] = 37c024f2 a5b95976, %l2 = f3519c4e, %l3 = 6a3389dd
	ldd	[%o0+0x048],%l2		! %l2 = 0000000037c024f2 00000000a5b95976

p1_label_18:
!	%f16 = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	%f20 = 1c062400 822c7d4d 3c488ec8 451a51ad
!	%f24 = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	%f28 = b88546b0 ae796565 7c987a4e d36a38e5
	stda	%f16,[%i3]ASI_BLK_PL	! Block Store to 0000000015800000
!	Mem[000000007080004c] = 3f379ee8, %l1 = 000000007e0d6c1e
	lduh	[%o1+0x04c],%l1		! %l1 = 0000000000003f37
!	Mem[0000000014000010] = cc0032d3 9ebf9797, %l2 = 37c024f2, %l3 = a5b95976
	ldda	[%i0+0x010]%asi,%l2	! %l2 = 00000000cc0032d3 000000009ebf9797
!	Mem[0000000071800008] = 15a1b990, %l6 = 000000004d7d2c82
	ldub	[%o3+0x00b],%l6		! %l6 = 0000000000000090
!	Mem[0000000070800008] = d073ffb5, %l5 = 000000004e5a9fb5
	lduw	[%o1+0x008],%l5		! %l5 = 00000000d073ffb5

p1_label_19:
!	%f0  = c1d5b8cf 505b1665 535867d3 ae2f9f9a
!	%f4  = 8eff8eaf 9412d179 d51f794d 8457edcd
!	%f8  = 152ecec7 4baed4ef 2be8d2c2 22f096c2
!	%f12 = 41d416c5 99400000 9971c7fa 65297c15
	stda	%f0,[%i1+%g4]ASI_BLK_PL	! Block Store to 0000000014800100
	membar	#Sync			! Added by membar checker (64)
!	Mem[0000000015800000] = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	Mem[0000000015800010] = 4d7d2c82 0024061c ad511a45 c88e483c
!	Mem[0000000015800020] = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	Mem[0000000015800030] = 656579ae b04685b8 e5386ad3 4e7a987c
	ldda	[%i3]ASI_BLK_PL,%f0	! Block Load from 0000000015800000
!	Mem[0000000071800048] = f28e19f1b2d88fc6, %l5 = 00000000d073ffb5
	ldx	[%o3+0x048],%l5		! %l5 = f28e19f1b2d88fc6
!	%f0  = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	%f4  = 1c062400 822c7d4d 3c488ec8 451a51ad
!	%f8  = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	%f12 = b88546b0 ae796565 7c987a4e d36a38e5
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000148000c0
!	Mem[00000000158001c0] = de1e879c 8130392d 313478eb c55095ce
!	Mem[00000000158001d0] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000158001e0] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[00000000158001f0] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x1c0,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f0	! Block Load from 00000000158001c0

p1_label_20:
!	Mem[0000000014000008] = de46c45b, %l0 = 1452a62d646d689a
	lduwa	[%i0+%o6]0x80,%l0	! %l0 = 00000000de46c45b
!	Mem[000000007100000c] = 9aaa134e, %l1 = 0000000000003f37
	ldsh	[%o2+0x00c],%l1		! %l1 = ffffffffffff9aaa
!	Mem[0000000070000008] = 3cb84dfe6a3389dd, %l2 = 00000000cc0032d3
	ldx	[%o0+0x008],%l2		! %l2 = 3cb84dfe6a3389dd
!	Mem[00000000158000d0] = 8eff8eaf9412d179, %l7 = 000000003d7d8502
	ldx	[%i3+0x0d0],%l7		! %l7 = 8eff8eaf9412d179
	fbu,pt	%fcc1,p1_branch_failed	! Branch Not Taken, %fcc1 = 0

p1_label_21:
!	Mem[0000000014800000] = 2c3de8f2, %l4 = 0000000000003c01
	ldsha	[%i1+%g0]0x80,%l4	! %l4 = 0000000000002c3d
p1_b9:
!	Mem[0000000015000178] = 5e638926, %l0 = 00000000de46c45b
	ldsw	[%i2+0x178],%l0		! %l0 = 000000005e638926
!	%f0  = 2d393081 9c871ede ce9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 cc9ceb84 e3a56274 7cbc73e4
	stda	%f0,[%i0+%g4]ASI_BLK_PL	! Block Store to 0000000014000100
!	Mem[0000000071000048] = 1e1327613d7d8502, %l6 = 0000000000000090
	ldx	[%o2+0x048],%l6		! %l6 = 1e1327613d7d8502
!	Mem[0000000070000048] = 37c024f2a5b95976, %l2 = 3cb84dfe6a3389dd
	ldx	[%o0+0x048],%l2		! %l2 = 37c024f2a5b95976

p1_label_22:
	fbu	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%f22 = 3c488ec8 451a51ad, %f22 = 3c488ec8 451a51ad, %f22 = 3c488ec8 451a51ad
	fdivd	%f22,%f22,%f22		! %f22 = 3ff00000 00000000
p1_b10:
!	Mem[0000000015800008] = 432751c808dabd8f, %l5 = f28e19f1b2d88fc6
	ldxa	[%i3+%o6]0x80,%l5	! %l5 = 432751c808dabd8f
!	Mem[0000000014800180] = 6d60c8f2 15285670 d519d8cc e04318ee
!	Mem[0000000014800190] = 096b0547 5446b240 cf797b7c 4116f0bb
!	Mem[00000000148001a0] = c1205e43 7dd57111 a1a92967 ae03e6cb
!	Mem[00000000148001b0] = a4bf140e 5dd915e9 c68c6d06 83433a3c
	mov	0x180,%g4
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 0000000014800180
!	Mem[00000000150001c0] = d6faac8e dba4c06b ce358ece a56ce2fd
!	Mem[00000000150001d0] = eaaff3ef f5f063e7 d0aec0f4 87ea3c02
!	Mem[00000000150001e0] = f2039be0 6e494156 008b364f 99b4b651
!	Mem[00000000150001f0] = 0866cdf1 8c4217c9 7beca753 4ac94d53
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 00000000150001c0

p1_label_23:
!	Mem[0000000015000140] = 27bfb406 357633b0 91a62d1b 577cc042
!	Mem[0000000015000150] = a0f565d7 52a5e21b 5a7fc8bf 661a0b74
!	Mem[0000000015000160] = f259a304 56fda40f 8ce80331 472a09a9
!	Mem[0000000015000170] = 1abe3d88 925f3cc6 5e638926 96f49789
	mov	0x140,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000015000140
!	Mem[0000000070800008] = d073ffb5, %l0 = 000000005e638926
	lduh	[%o1+0x00a],%l0		! %l0 = 000000000000ffb5
!	%l6 = 1e1327613d7d8502, Mem[0000000071000049] = 1e132761
	stba	%l6,[%o2+0x049]%asi	! Mem[0000000071000048] = 1e022761
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	fbl	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0

p1_label_24:
!	Mem[0000000015800008] = 432751c8, %l2 = 37c024f2a5b95976
	lduwa	[%i3+%o6]0x80,%l2	! %l2 = 00000000432751c8
p1_b11:
!	%l3 = 000000009ebf9797
	setx	0x36453edd36453edd,%g7,%l3 ! %l3 = 36453edd36453edd
!	Mem[0000000014000008] = de46c45b, %l5 = 432751c808dabd8f
	ldsba	[%i0+%o6]0x80,%l5	! %l5 = ffffffffffffffde
!	Mem[0000000014000188] = 3e81331f829033e9, %l5 = ffffffffffffffde
	ldx	[%i0+0x188],%l5		! %l5 = 3e81331f829033e9
!	Mem[0000000014800008] = 3c9b646d 4b51b3f9, %l4 = 00002c3d, %l5 = 829033e9
	ldda	[%i1+%o6]0x80,%l4	! %l4 = 000000003c9b646d 000000004b51b3f9

p1_label_25:
!	Mem[0000000014800008] = 3c9b646d4b51b3f9, %l4 = 000000003c9b646d
	ldxa	[%i1+%o6]0x80,%l4	! %l4 = 3c9b646d4b51b3f9
!	Mem[0000000072000040] = 65165b50 cfb8d5c1 9a9f2fae d3675853
!	Mem[0000000072000050] = 79d11294 af8eff8e cded5784 4d791fd5
!	Mem[0000000072000060] = efd4ae4b c7ce2e15 c296f022 c2d2e82b
!	Mem[0000000072000070] = 00004099 c516d441 157c2965 fac77199
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f16 = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	%f20 = 1c062400 822c7d4d 3ff00000 00000000
!	%f24 = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	%f28 = b88546b0 ae796565 7c987a4e d36a38e5
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000015000000
!	%l0 = 000000000000ffb5, immed = ffffff8f, %l7 = 8eff8eaf9412d179
	subc	%l0,-0x071,%l7		! %l7 = 0000000000010026
!	Mem[00000000150000c0] = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	Mem[00000000150000d0] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[00000000150000e0] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[00000000150000f0] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 00000000150000c0

p1_label_26:
!	%l4 = 3c9b646d4b51b3f9, immed = 00000014, %l3 = 36453edd36453edd
	srax	%l4,0x014,%l3		! %l3 = 000003c9b646d4b5
!	%f16 = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	%f20 = 1c062400 822c7d4d 3ff00000 00000000
!	%f24 = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	%f28 = b88546b0 ae796565 7c987a4e d36a38e5
	stda	%f16,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
!	%f0  = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	%f4  = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f8  = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f12 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000014000180
	membar	#Sync
!	Branch On Register, %l1 = ffffffffffff9aaa
	brgez,pt %l1,p1_not_taken_0	! Branch Not Taken
!	Mem[0000000015000154] = 52a5e21b, %f1  = 53aad35d
	ld	[%i2+0x154],%f1 	! %f1 = 52a5e21b
p1_b12:

p1_label_27:
!	Mem[0000000015800180] = bd63f18e 6b0a798a 2014aeee 7b4c3ab2
!	Mem[0000000015800190] = 10da1e3f 4194c256 71f75027 db7bfa22
!	Mem[00000000158001a0] = 2939293e 7e0d6c1e e4d7766d 735e3e59
!	Mem[00000000158001b0] = 8855ac49 e6736552 1a1bf061 9d7c7302
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 0000000015800180
!	%f0  = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f4  = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f8  = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f12 = dcb0caf6 db746ed0 52db0aa1 753fa778
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 0000000014000140
!	Mem[0000000072000028] = 460926590b063a9b, %l4 = 3c9b646d4b51b3f9
	ldxa	[%o4+0x028]%asi,%g2	! %g2 = 460926590b063a9b
!	%f0  = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f4  = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f8  = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f12 = dcb0caf6 db746ed0 52db0aa1 753fa778
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000015000140
!	%l7 = 0000000000010026, immed = fffff4a1, %y  = 000000c2
	udiv	%l7,-0xb5f,%l5		! %l5 = 00000000000000c2
	mov	%l0,%y			! %y = 0000ffb5

p1_label_28:
!	%f16 = bd63f18e 6b0a798a 2014aeee 7b4c3ab2
!	%f20 = 10da1e3f 4194c256 71f75027 db7bfa22
!	%f24 = 2939293e 7e0d6c1e e4d7766d 735e3e59
!	%f28 = 8855ac49 e6736552 1a1bf061 9d7c7302
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 0000000014800040
!	Mem[0000000017000000] = a9569bee 6340ac83, %l6 = 3d7d8502, %l7 = 00010026
	ldda	[%i6+%g0]0x80,%l6	! %l6 = 00000000a9569bee 000000006340ac83
!	Mem[0000000014800008] = 3c9b646d, %l3 = 000003c9b646d4b5
	ldswa	[%i1+%o6]0x80,%l3	! %l3 = 000000003c9b646d
!	Mem[0000000015800040] = 5b6a4f0c abe35164 eb4431bd 539d0297
!	Mem[0000000015800050] = 5e8f188c 4788146b 8a1e6132 81c790e6
!	Mem[0000000015800060] = 32441f02 e348cf9f 772de819 6b7df7a2
!	Mem[0000000015800070] = 36a045a7 306b98b7 dedd9a53 82f1e511
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000015800040
!	Mem[0000000072000078] = 7c987a4ed36a38e5, %l3 = 000000003c9b646d
	ldx	[%o4+0x078],%g2		! %g2 = 7c987a4ed36a38e5

p1_label_29:
!	%l6 = 00000000a9569bee
	setx	0x06a0d46f06a0d46f,%g7,%l6 ! %l6 = 06a0d46f06a0d46f
!	Mem[0000000015000000] = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	Mem[0000000015000010] = 4d7d2c82 0024061c 00000000 0000f03f
!	Mem[0000000015000020] = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	Mem[0000000015000030] = 656579ae b04685b8 e5386ad3 4e7a987c
	ldda	[%i2]ASI_BLK_P,%f16	! Block Load from 0000000015000000
!	Mem[00000000170001d0] = 707aef67b39b333f, %l5 = 00000000000000c2
	ldx	[%i6+0x1d0],%l5		! %l5 = 707aef67b39b333f
!	Mem[00000000148000c0] = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	Mem[00000000148000d0] = 4d7d2c82 0024061c ad511a45 c88e483c
!	Mem[00000000148000e0] = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	Mem[00000000148000f0] = 656579ae b04685b8 e5386ad3 4e7a987c
	mov	0x0c0,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 00000000148000c0
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	mov	0x100,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_PL	! Block Store to 0000000014800100

p1_label_30:
!	Mem[0000000040a00018] = 1f1f3e1d, %l0 = 000000000000ffb5
	lduwa	[%o5+0x018]%asi,%l0	! %l0 = 000000001f1f3e1d
!	Mem[0000000015800160] = 593e20ce a5f1e933 039b2d45 445a1062
	prefetcha [%i3+0x160]%asi,20
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	%l6 = 06a0d46f06a0d46f, Mem[000000007100000c] = 9aaa134e
	stw	%l6,[%o2+0x00c]		! Mem[000000007100000c] = 06a0d46f
	membar	#Sync			! Added by membar checker (65)
	set	p1_b13,%o7
	fba	p1_far_3_le		! Branch Taken, %fcc0 = 0

p1_label_31:
!	Mem[0000000015000008] = 432751c8, %l6 = 06a0d46f06a0d46f
	ldswa	[%i2+%o6]0x80,%l6	! %l6 = 00000000432751c8
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x00d,%g2
p1_b13:
!	Registers modified during the branch to p1_far_3
!	%l5  = 0000000000000052
!	%l2 = 00000000432751c8
	sethi	%hi(0x0fabac00),%l2	! %l2 = 000000000fabac00
!	Mem[0000000014000100] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014000110] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014000120] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014000130] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000014000100
!	Mem[0000000015800000] = 4e5a9fb5, %l3 = 000000003c9b646d
	ldswa	[%i3+%g0]0x80,%l3	! %l3 = 000000004e5a9fb5
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p1_label_32:
!	Mem[0000000071800008] = 15a1b990, %l5 = 0000000000000052
	ldsha	[%o3+0x00a]%asi,%l5	! %l5 = ffffffffffffb990
!	%l5 = ffffffffffffb990, %l6 = 00000000432751c8, %y  = 0000ffb5
	umulcc	%l5,%l6,%l1		! %l1 = 43273f4dde6f8880, %ccr = 08
!	Mem[000000007000000c] = 6a3389dd, %l3 = 000000004e5a9fb5
	ldsha	[%o0+0x00c]%asi,%l3	! %l3 = 0000000000006a33
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000071800008] = 15a1b990 b59f5a4e, %l2 = 0fabac00, %l3 = 00006a33
	ldda	[%o3+0x008]%asi,%l2	! %l2 = 0000000015a1b990 00000000b59f5a4e

p1_label_33:
!	Mem[0000000015800000] = 4e5a9fb590b9a115, %l3 = 00000000b59f5a4e
	ldxa	[%i3+%g0]0x80,%l3	! %l3 = 4e5a9fb590b9a115
!	Mem[0000000071800048] = f28e19f1b2d88fc6, %l5 = ffffffffffffb990
	ldx	[%o3+0x048],%l5		! %l5 = f28e19f1b2d88fc6
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 0000000015800100
	bneg	p1_b14			! Branch Taken, %ccr = 08, CWP = 0
!	%l0 = 000000001f1f3e1d, immed = fffffebb, %l0 = 000000001f1f3e1d
	taddcc	%l0,-0x145,%l0		! %l0 = 000000001f1f3cd8, %ccr = 13
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x00e,%g2
p1_b14:

p1_label_34:
	membar	#Sync			! Added by membar checker (66)
!	Mem[0000000072000030] = e124ed32, %l6 = 00000000432751c8
	ldsh	[%o4+0x032],%g2		! %g2 = ffffffffffffe124
!	Mem[000000007080000c] = e7fbca1a, %l5 = f28e19f1b2d88fc6
	lduha	[%o1+0x00c]%asi,%l5	! %l5 = 000000000000e7fb
!	Mem[0000000072000040] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000072000050] = 1c062400 822c7d4d 3ff00000 00000000
!	Mem[0000000072000060] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000072000070] = b88546b0 ae796565 7c987a4e d36a38e5
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%l6 = 00000000432751c8
	setx	0x3e275c133e275c13,%g7,%l6 ! %l6 = 3e275c133e275c13
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000015800100

p1_label_35:
	membar	#Sync			! Added by membar checker (67)
	set	p1_b15,%o7
	fbule	p1_far_2_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000015800008] = 432751c8, %l6 = 3e275c133e275c13
	swapa	[%i3+%o6]0x80,%l6	! %l6 = 00000000432751c8
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x00f,%g2
p1_b15:
!	Registers modified during the branch to p1_far_2
!	%l0  = 000000000a242719
!	%l3  = 0000000000000089
!	%l4  = 00000000e763f0f5
!	%l5  = 00000000eff3afea
!	%l6  = 30fb933b06a0d46f
!	Mem[0000000014800000] = 2c3de8f2, %l1 = 43273f4dde6f8880
	ldsha	[%i1+%g0]0x80,%l1	! %l1 = 0000000000002c3d
!	%l7 = 000000006340ac83, Mem[0000000015000008] = 432751c808dabd8f
	stxa	%l7,[%i2+%o6]0x80	! Mem[0000000015000008] = 000000006340ac83
	fbl,pt	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0

p1_label_36:
!	Mem[0000000040a00018] = 1f1f3e1d, %l1 = 0000000000002c3d
	ldsb	[%o5+0x018],%l1		! %l1 = 000000000000001f
p1_b16:
!	Mem[0000000014800080] = 5b1ae570 a1b09d17 ed7ad203 0fda6e7d
!	Mem[0000000014800090] = ddd7a166 6b6489bf abeb0a28 ce8be98e
!	Mem[00000000148000a0] = a4487c4d 6bec2525 445c63b4 613af1a9
!	Mem[00000000148000b0] = df5366b3 0d9d5a46 21b04e03 d7bde639
	mov	0x080,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 0000000014800080
!	%l6 = 30fb933b06a0d46f, immed = fffffad1, %l0 = 000000000a242719
	andcc	%l6,-0x52f,%l0		! %l0 = 30fb933b06a0d041, %ccr = 00
!	%f16 = 5b1ae570 a1b09d17 ed7ad203 0fda6e7d
!	%f20 = ddd7a166 6b6489bf abeb0a28 ce8be98e
!	%f24 = a4487c4d 6bec2525 445c63b4 613af1a9
!	%f28 = df5366b3 0d9d5a46 21b04e03 d7bde639
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 0000000014800040
!	%l4 = 00000000e763f0f5, immed = fffff98c, %y  = 43273f4d
	udiv	%l4,-0x674,%l4		! %l4 = 00000000432740ff
	mov	%l0,%y			! %y = 06a0d041

p1_label_37:
	membar	#Sync			! Added by membar checker (68)
	set	p1_b17,%o7
	fbule	p1_far_3_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000014800000] = 2c3de8f2, %l2 = 0000000015a1b990
	lduha	[%i1+%g0]0x80,%l2	! %l2 = 0000000000002c3d
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p1_branch_failed
	mov	0x011,%g2
p1_b17:
!	Registers modified during the branch to p1_far_3
!	%l5  = 0000000000000052
!	Mem[000000007080004c] = 3f379ee8, %l2 = 0000000000002c3d
	lduwa	[%o1+0x04c]%asi,%l2	! %l2 = 000000003f379ee8
!	%l6 = 30fb933b06a0d46f, %l4 = 00000000432740ff, %l6 = 30fb933b06a0d46f
	xnorcc	%l6,%l4,%l6		! %l6 = cf046cc4ba786b6f, %ccr = 88
!	%f16 = 5b1ae570 a1b09d17 ed7ad203 0fda6e7d
!	%f20 = ddd7a166 6b6489bf abeb0a28 ce8be98e
!	%f24 = a4487c4d 6bec2525 445c63b4 613af1a9
!	%f28 = df5366b3 0d9d5a46 21b04e03 d7bde639
	mov	0x1c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000158001c0

p1_label_38:
!	Mem[0000000015800140] = ff1aaa52 bb9f8a7b 0b3a9545 049ce5b5
!	Mem[0000000015800150] = 2b3f581b bc79db9f ca475004 c16db11c
!	Mem[0000000015800160] = 593e20ce a5f1e933 039b2d45 445a1062
!	Mem[0000000015800170] = 88b63c94 3618117c 843ff973 ccc601da
	mov	0x140,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000015800140
	fbg,a,pn %fcc1,p1_branch_failed	! Branch Not Taken, %fcc1 = 0
!	Mem[0000000070000048] = 37c024f2, %l4 = 00000000432740ff
	ldsh	[%o0+0x048],%l4		! Annulled
p1_b18:
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x0c0,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000148000c0
!	%l0 = 30fb933b06a0d041, %l2 = 000000003f379ee8, %y  = 06a0d041
	smulcc	%l0,%l2,%l6		! %l6 = 01a303e9ff3bd8e8, %ccr = 08

p1_label_39:
!	Mem[0000000014000180] = 5dd3aa53 c6e0eb18 166cbd32 55cc3f88
!	Mem[0000000014000190] = d85d13e6 dcaf441a 0b87bcfa c73b6d59
!	Mem[00000000140001a0] = 57e06ff3 640f343c 32c4d014 03f917fa
!	Mem[00000000140001b0] = d06e74db f6cab0dc 78a73f75 a10adb52
	mov	0x180,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000014000180
!	Mem[000000007080004c] = 3f379ee8, %l3 = 0000000000000089
	ldsh	[%o1+0x04c],%l3		! %l3 = 0000000000003f37
!	Mem[0000000017000008] = b0320a8d, %l5 = 0000000000000052
	ldsba	[%i6+%o6]0x80,%l5	! %l5 = ffffffffffffffb0
!	Mem[0000000071000008] = 30fb933b, %l0 = 30fb933b06a0d041
	ldswa	[%o2+0x008]%asi,%l0	! %l0 = 0000000030fb933b
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x140,%g5
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 0000000014800140

p1_label_40:
!	%l6 = 01a303e9ff3bd8e8, immed = 00000a78, %y  = 01a303e9
	mulx	%l6,0xa78,%l7		! %l7 = 2290f9a7fa86bcc0
!	%l3 = 0000000000003f37, immed = 00000962, %y  = 01a303e9
	mulx	%l3,0x962,%l7		! %l7 = 000000000251220e
!	Mem[0000000072000040] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000072000050] = 1c062400 822c7d4d 3ff00000 00000000
!	Mem[0000000072000060] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000072000070] = b88546b0 ae796565 7c987a4e d36a38e5
	mov	0x040,%g4
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800008] = 15a1b990, %l4 = 00000000432740ff
	ldsh	[%o3+0x008],%l4		! %l4 = 00000000000015a1
!	%l4 = 00000000000015a1, %l2 = 000000003f379ee8, %y  = 01a303e9
	sdiv	%l4,%l2,%l3		! %l3 = 0000000006a0d03c
	mov	%l0,%y			! %y = 30fb933b

p1_label_41:
!	Mem[0000000040a0001c] = 0a242719, %l1 = 000000000000001f
	ldsh	[%o5+0x01e],%l1		! %l1 = 0000000000002719
!	Mem[0000000015000008] = 00000000, %l6 = 01a303e9ff3bd8e8
	ldsha	[%i2+%o6]0x80,%l6	! %l6 = 0000000000000000
!	Mem[0000000071800008] = 15a1b990, %l7 = 000000000251220e
	ldsh	[%o3+0x008],%l7		! %l7 = 00000000000015a1
!	Mem[0000000017000000] = a9569bee 6340ac83 b0320a8d a01b97aa
!	Mem[0000000017000010] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[0000000017000020] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000017000030] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i6]ASI_BLK_P,%f16	! Block Load from 0000000017000000
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x080,%g6
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000014800080

p1_label_42:
!	Mem[0000000071000008] = 30fb933b06a0d46f, %l0 = 0000000030fb933b
	ldx	[%o2+0x008],%l0		! %l0 = 30fb933b06a0d46f
!	%f16 = a9569bee 6340ac83 b0320a8d a01b97aa
!	%f20 = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f24 = e798b406 7c91fab2 47e10075 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f16,[%o4+%g4]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[000000001580005c] = 81c790e6, %l1 = 0000000000002719
	lduba	[%i3+0x05e]%asi,%l1	! %l1 = 0000000000000090
!	Mem[0000000071800008] = 15a1b990 b59f5a4e, %l2 = 3f379ee8, %l3 = 06a0d03c
	ldd	[%o3+0x008],%l2		! %l2 = 0000000015a1b990 00000000b59f5a4e
!	%l4 = 00000000000015a1, immed = fffffcaf, %y  = 30fb933b
	umul	%l4,-0x351,%l0		! %l0 = 000015a0ffb8450f

p1_label_43:
	membar	#Sync
	set	p1_b19,%o7
	fbule,pn %fcc3,p1_near_2_le	! Branch Taken, %fcc3 = 0
!	Mem[0000000071800008] = 15a1b990b59f5a4e, %l1 = 0000000000000090
	ldx	[%o3+0x008],%l1		! %l1 = 15a1b990b59f5a4e
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x013,%g2
p1_b19:
!	Registers modified during the branch to p1_near_2
!	%l1  = 0000000037c024f2
!	%l2  = 15a1b990b59f4f5c
!	%l3  = 166cbd3255cc3f88
!	%l5  = 3cb84dfe6a3389dd
!	%f16 = a9569bee 6340ac83 b0320a8d a01b97aa
!	%f20 = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f24 = e798b406 7c91fab2 47e10075 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x180,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000014000180
!	Mem[0000000072000040] = 83ac4063 ee9b56a9 aa971ba0 8d0a32b0
!	Mem[0000000072000050] = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	Mem[0000000072000060] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[0000000072000070] = 71e36938 106cc029 9e4463fe 27ae351c
	ldda	[%o4+%g4]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000015800180

p1_label_44:
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x080,%g5
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000015000080
!	%f24 = e798b406 7c91fab2, %f22 = 635f1c94 b22f98e0
	fnegd	%f24,%f22		! %f22 = 6798b406 7c91fab2
!	%l7 = 00000000000015a1, Mem[00000000158000d1] = 8eff8eaf
	stb	%l7,[%i3+0x0d1]		! Mem[00000000158000d0] = 8ea18eaf
!	%f26 = 47e10075 4f16fce4, %f26 = 47e10075 4f16fce4, %f18 = b0320a8d a01b97aa
	fsubd	%f26,%f26,%f18		! %f18 = 00000000 00000000
!	Mem[0000000015800008] = 3e275c13, %l4 = 00000000000015a1
	ldsha	[%i3+%o6]0x80,%l4	! %l4 = 0000000000003e27

p1_label_45:
!	%f16 = a9569bee 6340ac83 00000000 00000000
!	%f20 = d2ab9d9e 717c8390 6798b406 7c91fab2
!	%f24 = e798b406 7c91fab2 47e10075 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f16,[%i3]ASI_BLK_P	! Block Store to 0000000015800000
!	Mem[0000000070800008] = d073ffb5e7fbca1a, %l2 = 15a1b990b59f4f5c
	ldx	[%o1+0x008],%l2		! %l2 = d073ffb5e7fbca1a
!	Mem[0000000072000024] = a7b34609, %l6 = 0000000000000000
	lduha	[%o4+0x026]%asi,%g2	! %g2 = 000000000000a7b3
!	Mem[0000000016800000] = d42443ea, %l5 = 3cb84dfe6a3389dd
	lduha	[%i5+%g0]0x80,%l5	! %l5 = 000000000000d424
!	Mem[0000000071000048] = 1e022761, %l3 = 166cbd3255cc3f88
	ldub	[%o2+0x048],%l3		! %l3 = 000000000000001e

p1_label_46:
!	%f16 = a9569bee 6340ac83 00000000 00000000
!	%f20 = d2ab9d9e 717c8390 6798b406 7c91fab2
!	%f24 = e798b406 7c91fab2 47e10075 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000015800080
!	%l2 = d073ffb5e7fbca1a, %l2 = d073ffb5e7fbca1a, %y  = 000015a0
	udiv	%l2,%l2,%l6		! %l6 = 00000000000017de
	mov	%l0,%y			! %y = ffb8450f
!	Mem[0000000014000100] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014000110] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014000120] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014000130] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x100,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 0000000014000100
!	%f1  = 8130392d, %f12 = 84eb9ccc
	fnegs	%f1 ,%f12		! %f12 = 0130392d
!	Mem[0000000015000000] = 4e5a9fb5, %l5 = 000000000000d424
	lduwa	[%i2+%g0]0x80,%l5	! %l5 = 000000004e5a9fb5

p1_label_47:
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
	membar	#Sync			! Added by membar checker (69)
!	Mem[0000000015800000] = a9569bee 6340ac83 00000000 00000000
!	Mem[0000000015800010] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[0000000015800020] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000015800030] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000015800000
!	%l0 = ffb8450f, %l1 = 37c024f2, Mem[0000000071000048] = 1e022761 3d7d8502
	std	%l0,[%o2+0x048]	! Mem[0000000071000048] = ffb8450f 37c024f2
!	Mem[0000000014800080] = 2d3930819c871ede, %l5 = 000000004e5a9fb5
	ldx	[%i1+0x080],%l5		! %l5 = 2d3930819c871ede
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x0c0,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 00000000140000c0

p1_label_48:
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x1c0,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_PL	! Block Store to 00000000148001c0
!	Mem[0000000072000030] = e124ed32, %l3 = 000000000000001e
	ldsh	[%o4+0x032],%g2		! %g2 = ffffffffffffe124
!	Mem[0000000014800008] = 3c9b646d, %l1 = 0000000037c024f2
	ldsba	[%i1+%o6]0x80,%l1	! %l1 = 000000000000003c
!	Mem[0000000014800000] = 2c3de8f2, %l4 = 0000000000003e27
	ldsba	[%i1+%g0]0x80,%l4	! %l4 = 000000000000002c
!	%l5 = 2d3930819c871ede, %l5 = 2d3930819c871ede, %l4 = 000000000000002c
	orn	%l5,%l5,%l4		! %l4 = ffffffffffffffff

p1_label_49:
!	Mem[000000007200005c] = 63b2fa91, %l6 = 00000000000017de
	ldsba	[%o4+0x05f]%asi,%g2	! %g2 = 0000000000000063
!	Mem[000000007000004c] = a5b95976, %l7 = 00000000000015a1
	lduba	[%o0+0x04d]%asi,%l7	! %l7 = 00000000000000b9
!	Mem[0000000072000010] = 59ec7116757f06b3, %l6 = 00000000000017de
	ldx	[%o4+0x010],%g2		! %g2 = 59ec7116757f06b3
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 0130392d 101ccb52 e473bc7c 7462a5e3
	stda	%f0,[%i1]ASI_BLK_PL	! Block Store to 0000000014800000
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p1_label_50:
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x040,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000014000040
!	Mem[0000000071000008] = 30fb933b06a0d46f, %l2 = d073ffb5e7fbca1a
	ldx	[%o2+0x008],%l2		! %l2 = 30fb933b06a0d46f
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 0130392d 101ccb52 e473bc7c 7462a5e3
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000148000c0
!	Mem[0000000015000060] = d7e21883554aae37, %l1 = 000000000000003c
	ldx	[%i2+0x060],%l1		! %l1 = d7e21883554aae37
!	Mem[0000000072000030] = 867de124ed32762e, %l7 = 00000000000000b9
	ldx	[%o4+0x030],%g2		! %g2 = 867de124ed32762e

p1_label_51:
	membar	#Sync			! Added by membar checker (70)
!	Mem[0000000014800030] = 52cb1c10 2d393001, %l0 = ffb8450f, %l1 = 554aae37
	ldd	[%i1+0x030],%l0		! %l0 = 0000000052cb1c10 000000002d393001
!	Mem[0000000014800040] = 179db0a1 70e51a5b 7d6eda0f 03d27aed
!	Mem[0000000014800050] = bf89646b 66a1d7dd 8ee98bce 280aebab
!	Mem[0000000014800060] = 2525ec6b 4d7c48a4 a9f13a61 b4635c44
!	Mem[0000000014800070] = 465a9d0d b36653df 39e6bdd7 034eb021
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 0000000014800040
!	Mem[00000000150001c0] = d6faac8e dba4c06b ce358ece a56ce2fd
!	Mem[00000000150001d0] = eaaff3ef f5f063e7 d0aec0f4 87ea3c02
!	Mem[00000000150001e0] = f2039be0 6e494156 008b364f 99b4b651
!	Mem[00000000150001f0] = 0866cdf1 8c4217c9 7beca753 4ac94d53
	ldda	[%i2+%g4]ASI_BLK_P,%f0	! Block Load from 00000000150001c0
!	Mem[0000000014000118] = 668fed6d 83a114d9, %l6 = 000017de, %l7 = 000000b9
	ldd	[%i0+0x118],%l6		! %l6 = 00000000668fed6d 0000000083a114d9
!	Mem[0000000015000040] = f2209f7b 8c593f96 dabd9a3d db26a747
!	Mem[0000000015000050] = 6bf96be2 86d608dc 0f0de2de ceba5eb0
!	Mem[0000000015000060] = d7e21883 554aae37 cd84c683 52fc99f4
!	Mem[0000000015000070] = 3af23bc0 abf04647 66eba668 72cc31db
	ldda	[%i2+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000015000040

p1_label_52:
!	Mem[0000000040a00018] = 1f1f3e1d0a242719, %l4 = ffffffffffffffff, %l6 = 00000000668fed6d
	add	%o5,0x18,%g1
	casxa	[%g1]0x80,%l4,%l6	! %l6 = 1f1f3e1d0a242719
!	Mem[0000000015800008] = 00000000, %l3 = 000000000000001e
	ldswa	[%i3+%o6]0x80,%l3	! %l3 = 0000000000000000
!	Mem[0000000015800180] = 2d393081 9c871ede ce9550c5 eb783431
!	Mem[0000000015800190] = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	Mem[00000000158001a0] = 2264e959 22c92a24 d2bc5472 11c88d1f
!	Mem[00000000158001b0] = 52cb1c10 cc9ceb84 e3a56274 7cbc73e4
	mov	0x180,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000015800180
!	Mem[0000000070000048] = 37c024f2, %l4 = ffffffffffffffff
	ldub	[%o0+0x04a],%l4		! %l4 = 0000000000000024
!	Mem[0000000015000008] = 00000000, %l2 = 30fb933b06a0d46f
	lduba	[%i2+%o6]0x80,%l2	! %l2 = 0000000000000000

p1_label_53:
!	Mem[0000000015000130] = 1e7410eb285586d5, %l4 = 0000000000000024
	ldx	[%i2+0x130],%l4		! %l4 = 1e7410eb285586d5
!	%f6  = d0aec0f4 87ea3c02, %f6  = d0aec0f4 87ea3c02, %f12 = 0866cdf1 8c4217c9
	fdivd	%f6 ,%f6 ,%f12		! %f12 = 3ff00000 00000000
!	Mem[0000000014000038] = 7040f8ba, %l2 = 0000000000000000
	lduha	[%i0+0x038]%asi,%l2	! %l2 = 0000000000007040
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	Mem[000000001580006c] = 6b7df7a2, %l5 = 2d3930819c871ede
	ldsba	[%i3+0x06f]%asi,%l5	! %l5 = ffffffffffffffa2

p1_label_54:
!	Mem[0000000072000060] = b2fa917c06b498e7, %l0 = 0000000052cb1c10
	ldx	[%o4+0x060],%g2		! %g2 = b2fa917c06b498e7
!	Mem[0000000014000008] = de46c45b, %l7 = 0000000083a114d9
	ldsha	[%i0+%o6]0x80,%l7	! %l7 = ffffffffffffde46
!	Mem[00000000148000c0] = 2d393081, %l6 = 1f1f3e1d0a242719
	ldsh	[%i1+0x0c0],%l6		! %l6 = 0000000000002d39
!	Mem[0000000015800134] = 101ccb52, %l3 = 0000000000000000
	lduw	[%i3+0x134],%l3		! %l3 = 00000000101ccb52
!	Mem[0000000070000048] = 37c024f2, %l3 = 00000000101ccb52
	ldub	[%o0+0x04a],%l3		! %l3 = 0000000000000024

p1_label_55:
!	Mem[0000000015000000] = 4e5a9fb590b9a115, %l1 = 000000002d393001
	ldxa	[%i2+%g0]0x80,%l1	! %l1 = 4e5a9fb590b9a115
!	Mem[00000000140000f8] = e473bc7c7462a5e3, %l5 = ffffffffffffffa2
	ldx	[%i0+0x0f8],%l5		! %l5 = e473bc7c7462a5e3
!	Mem[0000000015000130] = 1e7410eb285586d5, %l6 = 0000000000002d39
	ldxa	[%i2+0x130]%asi,%l6	! %l6 = 1e7410eb285586d5
!	Mem[0000000014800008] = ce9550c5, %l4 = 1e7410eb285586d5
	swapa	[%i1+%o6]0x80,%l4	! %l4 = 00000000ce9550c5
!	Mem[000000001580007c] = 82f1e511, %l4 = 00000000ce9550c5
	lduwa	[%i3+0x07c]%asi,%l4	! %l4 = 0000000082f1e511

p1_label_56:
!	Mem[0000000016000008] = 3c8e153b, %l4 = 0000000082f1e511
	ldsha	[%i4+%o6]0x80,%l4	! %l4 = 0000000000003c8e
!	%l1 = 4e5a9fb590b9a115, immed = 00000d75, %l2 = 0000000000007040
	andn	%l1,0xd75,%l2		! %l2 = 4e5a9fb590b9a000
!	Mem[0000000014800008] = 285586d5, %l7 = ffffffffffffde46
	ldsha	[%i1+%o6]0x80,%l7	! %l7 = 0000000000002855
	membar	#Sync			! Added by membar checker (71)
	set	p1_b20,%o7
	fba	p1_far_3_he		! Branch Taken, %fcc0 = 0
!	Mem[00000000158000b4] = 3869e371, %l3 = 0000000000000024
	lduh	[%i3+0x0b6],%l3		! %l3 = 000000000000e371
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x014,%g2
p1_b20:
!	Registers modified during the branch to p1_far_3
!	%l0  = 000000007040f8ba
!	%l3  = 1f8dc8117254bcd2
!	%l6  = 0000000000002719

p1_label_57:
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x1c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000140001c0
!	%f11 = 99b4b651, %f13 = 00000000
	fcmps	%fcc2,%f11,%f13		! %fcc2 = 1
!	Mem[00000000140000c0] = de1e879c 8130392d 313478eb c55095ce
!	Mem[00000000140000d0] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000140000e0] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[00000000140000f0] = 0130392d 101ccb52 e473bc7c 7462a5e3
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 00000000140000c0
!	%l1 = 4e5a9fb590b9a115, Mem[00000000150001b4] = 646d689a
	stb	%l1,[%i2+0x1b4]		! Mem[00000000150001b4] = 156d689a
!	%f0  = 2d393081 9c871ede ce9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 2d393001 e3a56274 7cbc73e4
	mov	0x080,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000015000080

p1_label_58:
!	%f27 = 7254bcd2, %f27 = 7254bcd2, %f23 = 83a114d9
	fadds	%f27,%f27,%f23		! %f23 = 72d4bcd2
!	Mem[0000000014800018] = d914a183, %l2 = 4e5a9fb590b9a000
	ldswa	[%i1+0x018]%asi,%l2	! %l2 = ffffffffd914a183
!	Mem[0000000072000040] = 83ac4063 ee9b56a9 aa971ba0 8d0a32b0
!	Mem[0000000072000050] = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	Mem[0000000072000060] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[0000000072000070] = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800048] = f28e19f1, %l4 = 0000000000003c8e
	ldsb	[%o3+0x049],%l4		! %l4 = ffffffffffffff8e
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p1_label_59:
!	Mem[0000000014000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000014000150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000014000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000014000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000014000140
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 72d4bcd2
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x0c0,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_PL	! Block Store to 00000000148000c0
!	Mem[0000000014800040] = 179db0a1 70e51a5b 7d6eda0f 03d27aed
!	Mem[0000000014800050] = bf89646b 66a1d7dd 8ee98bce 280aebab
!	Mem[0000000014800060] = 2525ec6b 4d7c48a4 a9f13a61 b4635c44
!	Mem[0000000014800070] = 465a9d0d b36653df 39e6bdd7 034eb021
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014800040
!	Mem[0000000015800080] = a9569bee 6340ac83 00000000 00000000
!	Mem[0000000015800090] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[00000000158000a0] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[00000000158000b0] = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x080,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000015800080
!	Mem[0000000070800008] = d073ffb5, %l4 = ffffffffffffff8e
	ldub	[%o1+0x008],%l4		! %l4 = 00000000000000d0

p1_label_60:
!	Mem[0000000014800000] = 2d393081, %l5 = e473bc7c7462a5e3
	lduwa	[%i1+0x000]%asi,%l5	! %l5 = 000000002d393081
!	Mem[000000001580003c] = fe63449e, %l1 = 4e5a9fb590b9a115
	ldsb	[%i3+0x03e],%l1		! %l1 = 0000000000000044
	membar	#Sync			! Added by membar checker (72)
!	%f0  = 83ac4063 ee9b56a9 00000000 00000000
!	%f4  = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f8  = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x1c0,%g4
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000140001c0
!	Mem[0000000070800048] = 4677966b, %l3 = 1f8dc8117254bcd2
	lduba	[%o1+0x04a]%asi,%l3	! %l3 = 0000000000000096
!	Mem[00000000158000b0] = 29c06c10, %l0 = 000000007040f8ba
	ldsh	[%i3+0x0b2],%l0		! %l0 = 0000000000006c10

p1_label_61:
!	Mem[0000000015800000] = a9569bee 6340ac83 00000000 00000000
!	Mem[0000000015800010] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[0000000015800020] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000015800030] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000015800000
!	%l4 = 000000d0, %l5 = 2d393081, Mem[00000000148000e0] = 2264e959 22c92a24
	std	%l4,[%i1+0x0e0]	! Mem[00000000148000e0] = 000000d0 2d393081
!	Mem[0000000015000180] = 00008069 980ad041 b70116f9 fa479b22
!	Mem[0000000015000190] = a3b95d5b 2914d2fd cc72639a d4f36584
!	Mem[00000000150001a0] = d5cfa868 abaea779 e833f9ff 73d3d92a
!	Mem[00000000150001b0] = 1452a62d 156d689a beda83f8 d61f0c18
	mov	0x180,%g4
	ldda	[%i2+%g4]ASI_BLK_P,%f0	! Block Load from 0000000015000180
!	Mem[0000000071800008] = 15a1b990 b59f5a4e, %l2 = d914a183, %l3 = 00000096
	ldda	[%o3+0x008]%asi,%l2	! %l2 = 0000000015a1b990 00000000b59f5a4e
!	Mem[0000000014800008] = 285586d5, %l1 = 0000000000000044
	lduba	[%i1+%o6]0x80,%l1	! %l1 = 0000000000000028

p1_label_62:
!	Mem[0000000016800000] = d42443ea, %l1 = 0000000000000028
	ldswa	[%i5+%g0]0x80,%l1	! %l1 = ffffffffd42443ea
!	Mem[0000000014000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000014000150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000014000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000014000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g4
	ldda	[%i0+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000014000140
	fbul,a,pn %fcc3,p1_branch_failed	! Branch Not Taken, %fcc3 = 0
!	%f27 = 7500e147, %f27 = 7500e147, %f28 = 71e36938
	fdivs	%f27,%f27,%f28	! Annulled
p1_b21:
!	Mem[0000000015000000] = 4e5a9fb5 90b9a115 00000000 6340ac83
!	Mem[0000000015000010] = 4d7d2c82 0024061c 00000000 0000f03f
!	Mem[0000000015000020] = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	Mem[0000000015000030] = 656579ae b04685b8 e5386ad3 4e7a987c
	ldda	[%i2]ASI_BLK_PL,%f0	! Block Load from 0000000015000000

p1_label_63:
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 0000000014800000
!	Mem[0000000014000180] = a9569bee 6340ac83 b0320a8d a01b97aa
!	Mem[0000000014000190] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[00000000140001a0] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[00000000140001b0] = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x180,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000014000180
!	Mem[0000000015800000] = a9569bee 6340ac83 00000000 00000000
!	Mem[0000000015800010] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[0000000015800020] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000015800030] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000015800000
!	Mem[0000000014000000] = cb5b64db f1d391af, %l0 = 00006c10, %l1 = d42443ea
	ldda	[%i0+%g0]0x80,%l0	! %l0 = 00000000cb5b64db 00000000f1d391af

p1_label_64:
!	Mem[0000000015800008] = 00000000, %l4 = 00000000000000d0
	lduba	[%i3+%o6]0x80,%l4	! %l4 = 0000000000000000
!	%f0  = a9569bee 6340ac83 b0320a8d a01b97aa
!	%f4  = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
	membar	#Sync
	bpos	p1_not_taken_0		! Branch Not Taken, %ccr = 08
!	Mem[0000000014000008] = de46c45b a278c8a3, %l2 = 15a1b990, %l3 = b59f5a4e
	ldda	[%i0+%o6]0x80,%l2	! %l2 = 00000000de46c45b 00000000a278c8a3
p1_b22:
!	Mem[0000000015000008] = 00000000, %l1 = 00000000f1d391af
	ldstuba	[%i2+%o6]0x80,%l1	! %l1 = 0000000000000000

p1_label_65:
!	Mem[0000000015800000] = a9569bee, %l3 = 00000000a278c8a3
	ldswa	[%i3+%g0]0x80,%l3	! %l3 = ffffffffa9569bee
!	Mem[0000000072000040] = 83ac4063 ee9b56a9 aa971ba0 8d0a32b0
!	Mem[0000000072000050] = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	Mem[0000000072000060] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[0000000072000070] = 71e36938 106cc029 9e4463fe 27ae351c
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
	fbg,pt	%fcc2,p1_branch_failed	! Branch Not Taken, %fcc2 = 1
!	Mem[0000000015800000] = a9569bee, %l0 = 00000000cb5b64db
	ldswa	[%i3+%g0]0x80,%l0	! %l0 = ffffffffa9569bee
p1_b23:
!	Mem[00000000150000c4] = 53aad35d, %l6 = 0000000000002719
	ldsw	[%i2+0x0c4],%l6		! %l6 = 0000000053aad35d

p1_label_66:
!	Mem[00000000158000e4] = 4baed4ef, %l6 = 0000000053aad35d
	ldsb	[%i3+0x0e6],%l6		! %l6 = ffffffffffffffd4
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x140,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000140
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x040,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000040
!	Mem[0000000015800160] = 593e20cea5f1e933, %l6 = ffffffffffffffd4
	ldxa	[%i3+0x160]%asi,%l6	! %l6 = 593e20cea5f1e933
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x1c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 00000000158001c0

p1_label_67:
!	Mem[0000000070800008] = d073ffb5e7fbca1a, %l6 = 593e20cea5f1e933
	ldxa	[%o1+0x008]%asi,%l6	! %l6 = d073ffb5e7fbca1a
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 00000000140001c0
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x080,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_PL	! Block Store to 0000000014800080
!	%f0  = a9569bee 6340ac83 b0320a8d a01b97aa
!	%f4  = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000015800080
!	Mem[0000000071000048] = ffb8450f, %l2 = 00000000de46c45b
	lduba	[%o2+0x04a]%asi,%l2	! %l2 = 0000000000000045

p1_label_68:
!	Mem[0000000015800000] = a9569bee6340ac83, %l2 = 0000000000000045
	ldxa	[%i3+%g0]0x80,%l2	! %l2 = a9569bee6340ac83
!	Mem[0000000071000008] = 30fb933b06a0d46f, %l6 = d073ffb5e7fbca1a
	ldx	[%o2+0x008],%l6		! %l6 = 30fb933b06a0d46f
!	Mem[0000000015000008] = ff000000, %l4 = 0000000000000000
	ldsba	[%i2+%o6]0x80,%l4	! %l4 = ffffffffffffffff
!	Mem[0000000015800038] = 1c35ae27 fe63449e, %l0 = a9569bee, %l1 = 00000000
	ldd	[%i3+0x038],%l0		! %l0 = 000000001c35ae27 00000000fe63449e
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000

p1_label_69:
!	%f17 = ee9b56a9, %f17 = ee9b56a9, %f17 = ee9b56a9
	fdivs	%f17,%f17,%f17		! %f17 = 3f800000
	membar	#Sync			! Added by membar checker (73)
!	Mem[0000000015800084] = 6340ac83, %l2 = a9569bee6340ac83
	lduh	[%i3+0x086],%l2		! %l2 = 000000000000ac83
!	%f0  = a9569bee 6340ac83 b0320a8d a01b97aa
!	%f4  = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000015800040
!	Mem[00000000140000c0] = de1e879c 8130392d 313478eb c55095ce
!	Mem[00000000140000d0] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000140000e0] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[00000000140000f0] = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x0c0,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 00000000140000c0
!	Mem[000000007080004c] = 3f379ee8, %l1 = 00000000fe63449e
	ldub	[%o1+0x04c],%l1		! %l1 = 000000000000003f

p1_label_70:
!	Mem[00000000148001f8] = 1c35ae27, %l0 = 000000001c35ae27
	ldswa	[%i1+0x1f8]%asi,%l0	! %l0 = 000000001c35ae27
!	Mem[00000000140001b0] = 29c06c103869e371, %l1 = 000000000000003f
	ldx	[%i0+0x1b0],%l1		! %l1 = 29c06c103869e371
	bg,a	p1_not_taken_0		! Branch Not Taken, %ccr = 08
!	Mem[0000000015000000] = 4e5a9fb5, %l0 = 000000001c35ae27
	ldsba	[%i2+%g0]0x80,%l0	! Annulled
p1_b24:
!	Mem[00000000158001f0] = 29c06c10, %l0 = 000000001c35ae27
	lduwa	[%i3+0x1f0]%asi,%l0	! %l0 = 0000000029c06c10

p1_label_71:
!	%f10 = 47e10075, %f0  = a9569bee
	fabss	%f10,%f0 		! %f0  = 47e10075
!	Mem[0000000014800118] = 3c488ec8, %l4 = ffffffffffffffff
	ldub	[%i1+0x11b],%l4		! %l4 = 00000000000000c8
!	Mem[0000000040a0001c] = 0a242719, %l5 = 000000002d393081
	ldsb	[%o5+0x01c],%l5		! %l5 = 000000000000000a
!	Mem[0000000014800040] = 179db0a1, %l5 = 000000000000000a
	lduh	[%i1+0x040],%l5		! %l5 = 000000000000179d
!	%f16 = 2d393081 9c871ede ce9550c5 eb783431
!	%f20 = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f24 = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f28 = 52cb1c10 2d393001 e3a56274 7cbc73e4
	stda	%f16,[%i3]ASI_BLK_P	! Block Store to 0000000015800000

p1_label_72:
	bge	p1_not_taken_0		! Branch Not Taken, %ccr = 08
!	Mem[0000000071000048] = ffb8450f, %l0 = 0000000029c06c10
	ldsb	[%o2+0x049],%l0		! %l0 = ffffffffffffffb8
p1_b25:
!	Mem[0000000014800008] = 0000000000000000, %l2 = 000000000000ac83
	ldxa	[%i1+%o6]0x80,%l2	! %l2 = 0000000000000000
!	Mem[0000000015800098] = 635f1c94b22f98e0, %l6 = 30fb933b06a0d46f
	ldx	[%i3+0x098],%l6		! %l6 = 635f1c94b22f98e0
!	%f0  = 47e10075 6340ac83 b0320a8d a01b97aa
!	%f4  = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f0,[%i2]ASI_BLK_PL	! Block Store to 0000000015000000

p1_label_73:
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	mov	0x040,%g5
	stda	%f32,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[00000000150000c0] = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	Mem[00000000150000d0] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[00000000150000e0] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[00000000150000f0] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x0c0,%g4
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 00000000150000c0
!	Mem[0000000014000040] = a9569bee 6340ac83 00000000 00000000
!	Mem[0000000014000050] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[0000000014000060] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000014000070] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014000040
!	Mem[0000000015800100] = de1e879c8130392d, %l3 = ffffffffa9569bee
	ldx	[%i3+0x100],%l3		! %l3 = de1e879c8130392d
	membar	#Sync			! Added by membar checker (74)
!	Mem[0000000015800008] = ce9550c5 eb783431, %l6 = b22f98e0, %l7 = 00002855
	ldda	[%i3+%o6]0x80,%l6	! %l6 = 00000000ce9550c5 00000000eb783431

p1_label_74:
!	Mem[0000000014000008] = de46c45b, %l6 = 00000000ce9550c5
	ldsha	[%i0+%o6]0x80,%l6	! %l6 = ffffffffffffde46
!	Mem[0000000014000080] = 6bc0a4db 8eacfad6 fde26ca5 ce8e35ce
!	Mem[0000000014000090] = e763f0f5 eff3afea 023cea87 f4c0aed0
!	Mem[00000000140000a0] = 5641496e e09b03f2 51b6b499 4f368b00
!	Mem[00000000140000b0] = c917428c f1cd6608 534dc94a 53a7ec7b
	mov	0x080,%g4
	ldda	[%i0+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000014000080
!	%f16 = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	%f20 = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g4
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000015800140
!	Mem[0000000072000070] = 867de124ed32762e, %l3 = de1e879c8130392d
	ldxa	[%o4+0x070]%asi,%g2	! %g2 = 867de124ed32762e
!	Mem[00000000140000c0] = de1e879c 8130392d 313478eb c55095ce
!	Mem[00000000140000d0] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000140000e0] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[00000000140000f0] = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x0c0,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 00000000140000c0

p1_label_75:
!	%l3 = de1e879c8130392d, Mem[0000000070000008] = 3cb84dfe
	stwa	%l3,[%o0+0x008]%asi	! Mem[0000000070000008] = 8130392d
!	%l1 = 29c06c103869e371, %l6 = ffffffffffffde46, %y  = ffb8450f
	sdivcc	%l1,%l6,%l0		! %l0 = 000000007fffffff, %ccr = 02
	mov	%l0,%y			! %y = 7fffffff
!	%f0  = d6faac8e dba4c06b ce358ece a56ce2fd
!	%f4  = eaaff3ef f5f063e7 d0aec0f4 87ea3c02
!	%f8  = f2039be0 6e494156 008b364f 99b4b651
!	%f12 = 0866cdf1 8c4217c9 7beca753 4ac94d53
	mov	0x1c0,%g5
	stda	%f0,[%i1+%g5]ASI_BLK_PL	! Block Store to 00000000148001c0
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x180,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 0000000014800180
!	Mem[0000000071800048] = f28e19f1, %l0 = 000000007fffffff
	ldsh	[%o3+0x048],%l0		! %l0 = fffffffffffff28e

p1_label_76:
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x080,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000014000080
	membar	#Sync			! Added by membar checker (75)
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000014000080
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x040,%g4
	stda	%f16,[%o4+%g4]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000015800000] = 2d393081, %l6 = ffffffffffffde46
	ldsha	[%i3+%g0]0x80,%l6	! %l6 = 0000000000002d39
!	Mem[000000007000004c] = a5b95976, %l3 = de1e879c8130392d
	ldsha	[%o0+0x04e]%asi,%l3	! %l3 = 0000000000005976

p1_label_77:
!	Mem[0000000014000164] = f36fe057, %l3 = 0000000000005976
	ldsh	[%i0+0x166],%l3		! %l3 = ffffffffffffe057
!	Mem[00000000140000e0] = 242ac922, %l2 = 0000000000000000
	ldub	[%i0+0x0e2],%l2		! %l2 = 00000000000000c9
!	Mem[000000007200003c] = 1922de1e, %l4 = 00000000000000c8
	ldsba	[%o4+0x03e]%asi,%g2	! %g2 = 0000000000000019
	membar	#Sync			! Added by membar checker (76)
!	Mem[0000000072000040] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000072000050] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000072000060] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000072000070] = 0130392d 101ccb52 e473bc7c 7462a5e3
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000070800008] = d073ffb5, %l4 = 00000000000000c8
	ldsw	[%o1+0x008],%l4		! %l4 = ffffffffd073ffb5

p1_label_78:
!	%f0  = d6faac8e dba4c06b ce358ece a56ce2fd
!	%f4  = eaaff3ef f5f063e7 d0aec0f4 87ea3c02
!	%f8  = f2039be0 6e494156 008b364f 99b4b651
!	%f12 = 0866cdf1 8c4217c9 7beca753 4ac94d53
	stda	%f0,[%o4+%g4]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000071000048] = ffb8450f, %l5 = 000000000000179d
	ldsb	[%o2+0x04a],%l5		! %l5 = 0000000000000045
!	Mem[0000000070000048] = 37c024f2, %l1 = 29c06c103869e371
	ldub	[%o0+0x048],%l1		! %l1 = 0000000000000037
!	%f20 = 29b11beb, Mem[0000000014000180] = a9569bee
	st	%f20,[%i0+0x180]	! Mem[0000000014000180] = 29b11beb
	membar	#Sync			! Added by membar checker (77)
!	Mem[0000000072000040] = 6bc0a4db8eacfad6, %l4 = ffffffffd073ffb5
	ldx	[%o4+0x040],%g2		! %g2 = 6bc0a4db8eacfad6

p1_label_79:
	bcs,a	p1_not_taken_0		! Branch Not Taken, %ccr = 02
!	Mem[0000000014000008] = de46c45ba278c8a3, %l4 = ffffffffd073ffb5
	ldxa	[%i0+%o6]0x80,%l4	! Annulled
p1_b26:
!	Mem[0000000015800030] = 52cb1c102d393001, %l1 = 0000000000000037
	ldx	[%i3+0x030],%l1		! %l1 = 52cb1c102d393001
!	Mem[0000000014800000] = a9569bee, %l2 = 00000000000000c9
	ldsha	[%i1+%g0]0x80,%l2	! %l2 = ffffffffffffa956
!	Mem[0000000015800080] = a9569bee 6340ac83 b0320a8d a01b97aa
!	Mem[0000000015800090] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[00000000158000a0] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[00000000158000b0] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000015800080

p1_label_80:
!	Mem[0000000015800000] = 2d393081, %l1 = 52cb1c102d393001
	ldsba	[%i3+%g0]0x80,%l1	! %l1 = 000000000000002d
!	%f0  = 83ac4063 ee9b56a9 aa971ba0 8d0a32b0
!	%f4  = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	%f8  = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x0c0,%g4
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 00000000150000c0
!	Mem[0000000071000048] = ffb8450f37c024f2, %l2 = ffffffffffffa956
	ldx	[%o2+0x048],%l2		! %l2 = ffb8450f37c024f2
!	Mem[0000000014000008] = de46c45b, %l2 = ffb8450f37c024f2
	lduba	[%i0+%o6]0x80,%l2	! %l2 = 00000000000000de
!	%f16 = de1e879c 8130392d 313478eb c55095ce
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000

p1_label_81:
!	Mem[0000000017000000] = a9569bee 6340ac83 b0320a8d a01b97aa
!	Mem[0000000017000010] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[0000000017000020] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000017000030] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i6]ASI_BLK_PL,%f16	! Block Load from 0000000017000000
!	Mem[0000000015800118] = 668fed6d, %l5 = 0000000000000045
	ldsh	[%i3+0x118],%l5		! %l5 = 000000000000668f
!	Mem[0000000014800118] = 3c488ec8, %l4 = ffffffffd073ffb5
	lduw	[%i1+0x118],%l4		! %l4 = 000000003c488ec8
!	Mem[0000000016000088] = 7ea2cc6c, %l7 = 00000000eb783431
	ldsb	[%i4+0x088],%l7		! %l7 = 000000000000007e
!	%f0  = 83ac4063 ee9b56a9, %f0  = 83ac4063 ee9b56a9, %f0  = 83ac4063 ee9b56a9
	faddd	%f0 ,%f0 ,%f0 		! %f0  = 83bc4063 ee9b56a9

p1_label_82:
	membar	#Sync
!	Branch On Register, %l3 = ffffffffffffe057
	brz,pn	%l3,p1_not_taken_0	! Branch Not Taken
!	Mem[000000007200005c] = f4c0aed0, %l4 = 000000003c488ec8
	lduw	[%o4+0x05c],%g2		! %g2 = 000000003c488ec8
p1_b27:
!	Mem[000000007100000c] = 06a0d46f, %l5 = 000000000000668f
	ldsba	[%o2+0x00d]%asi,%l5	! %l5 = ffffffffffffffa0
!	Mem[0000000014800180] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014800190] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000148001a0] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[00000000148001b0] = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x180,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 0000000014800180
!	Mem[00000000160001c8] = 9c98fbd3 89041474, %l4 = 3c488ec8, %l5 = ffffffa0
	ldda	[%i4+0x1c8]%asi,%l4	! %l4 = 000000009c98fbd3 0000000089041474

p1_label_83:
!	Mem[0000000015000008] = aa971ba0, %l1 = 000000000000002d
	lduwa	[%i2+%o6]0x80,%l1	! %l1 = 00000000aa971ba0
!	Mem[0000000014000080] = 2d393081 9c871ede ce9550c5 eb783431
!	Mem[0000000014000090] = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	Mem[00000000140000a0] = 2264e959 22c92a24 d2bc5472 11c88d1f
!	Mem[00000000140000b0] = 52cb1c10 2d393001 e3a56274 7cbc73e4
	mov	0x080,%g4
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000014000080
!	Mem[00000000140001c0] = a9569bee 6340ac83 00000000 00000000
!	Mem[00000000140001d0] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[00000000140001e0] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[00000000140001f0] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 00000000140001c0
!	Mem[0000000014800008] = 0000000000000000, %l2 = 00000000000000de
	ldxa	[%i1+%o6]0x80,%l2	! %l2 = 0000000000000000
!	Mem[0000000015800128] = 1f8dc8117254bcd2, %l4 = 000000009c98fbd3, %l4 = 000000009c98fbd3
	add	%i3,0x128,%g1
	casxa	[%g1]0x80,%l4,%l4	! %l4 = 1f8dc8117254bcd2

p1_label_84:
!	Mem[00000000158001fc] = fe63449e, %l3 = ffffffffffffe057
	ldsba	[%i3+0x1fc]%asi,%l3	! %l3 = fffffffffffffffe
!	%f2  = aa971ba0 8d0a32b0, %f8  = b2fa917c 06b498e7
	fcmpd	%fcc2,%f2 ,%f8 		! %fcc2 = 2
!	Mem[0000000015000000] = 83ac4063 7500e147, %l0 = fffff28e, %l1 = aa971ba0
	ldda	[%i2+%g0]0x80,%l0	! %l0 = 0000000083ac4063 000000007500e147
!	Mem[0000000072000040] = 6bc0a4db 8eacfad6 fde26ca5 ce8e35ce
!	Mem[0000000072000050] = e763f0f5 eff3afea 023cea87 f4c0aed0
!	Mem[0000000072000060] = 5641496e e09b03f2 51b6b499 4f368b00
!	Mem[0000000072000070] = c917428c f1cd6608 534dc94a 53a7ec7b
	mov	0x040,%g4
	ldda	[%o4+%g4]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000015000008] = aa971ba0, %l2 = 0000000000000000
	ldswa	[%i2+%o6]0x80,%l2	! %l2 = ffffffffaa971ba0

p1_label_85:
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x0c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000140000c0
	fbe,pt	%fcc2,p1_branch_failed	! Branch Not Taken, %fcc2 = 2
!	Mem[0000000070000048] = 37c024f2a5b95976, %l7 = 000000000000007e
	ldx	[%o0+0x048],%l7		! %l7 = 37c024f2a5b95976
p1_b28:
!	%l5 = 0000000089041474, %l3 = fffffffffffffffe, %l1 = 000000007500e147
	addcc	%l5,%l3,%l1		! %l1 = 0000000089041472, %ccr = 19
	membar	#Sync			! Added by membar checker (78)
!	%f0  = 83bc4063 ee9b56a9 aa971ba0 8d0a32b0
!	%f4  = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	%f8  = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 00000000140000c0

p1_label_86:
!	%f0  = 83bc4063 ee9b56a9 aa971ba0 8d0a32b0
!	%f4  = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	%f8  = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x080,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000015800080
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x0c0,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000148000c0
!	Mem[0000000070000048] = 37c024f2, %l7 = 37c024f2a5b95976
	ldsb	[%o0+0x049],%l7		! %l7 = ffffffffffffffc0
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l5 = 0000000089041474, %l0 = 0000000083ac4063, %l2 = ffffffffaa971ba0
	andcc	%l5,%l0,%l2		! %l2 = 0000000081040060, %ccr = 08

p1_label_87:
!	Mem[0000000015000000] = 83ac4063, %l4 = 1f8dc8117254bcd2
	ldsha	[%i2+%g0]0x80,%l4	! %l4 = ffffffffffff83ac
	membar	#Sync			! Added by membar checker (79)
!	Mem[000000007200001c] = 52dcfdb3, %l3 = fffffffffffffffe
	ldub	[%o4+0x01d],%g2		! %g2 = 0000000000000052
!	Mem[0000000014000180] = 29b11beb, %l0 = 0000000083ac4063
	ldswa	[%i0+0x180]%asi,%l0	! %l0 = 0000000029b11beb
!	Mem[0000000040a00018] = 1f1f3e1d, %l1 = 0000000089041472
	ldub	[%o5+0x019],%l1		! %l1 = 000000000000001f
!	Mem[0000000070800048] = 4677966b, %l3 = fffffffffffffffe
	swap	[%o1+0x048],%l3		! %l3 = 000000004677966b

p1_label_88:
!	Mem[0000000015800164] = f36fe057, %l4 = ffffffffffff83ac
	lduba	[%i3+0x165]%asi,%l4	! %l4 = 000000000000006f
!	%f29 = 106cc029, Mem[0000000016800010] = 84e85aff
	st	%f29,[%i5+0x010]	! Mem[0000000016800010] = 106cc029
!	Mem[0000000015000000] = 83ac4063, %l7 = ffffffffffffffc0
	lduha	[%i2+%g0]0x80,%l7	! %l7 = 00000000000083ac
!	Mem[0000000072000008] = 2ef43f1a, %l5 = 0000000089041474
	ldsha	[%o4+0x008]%asi,%g2	! %g2 = 0000000000002ef4
	fbg	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0

p1_label_89:
!	Mem[0000000015000000] = 83ac4063, %l6 = 0000000000002d39
	ldswa	[%i2+%g0]0x80,%l6	! %l6 = ffffffff83ac4063
p1_b29:
!	Mem[000000007100000c] = 06a0d46f, %l7 = 00000000000083ac
	ldub	[%o2+0x00c],%l7		! %l7 = 0000000000000006
	fbl,a	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%f10 = e4fc164f 7500e147, %f16 = 83ac4063 ee9b56a9
	fcmped	%fcc1,%f10,%f16	! Annulled
p1_b30:
!	%l3 = 000000004677966b, Mem[0000000070800048] = fffffffe3f379ee8
	stx	%l3,[%o1+0x048]		! Mem[0000000070800048] = 000000004677966b

p1_label_90:
!	Mem[0000000071800048] = f28e19f1b2d88fc6, %l6 = ffffffff83ac4063
	ldx	[%o3+0x048],%l6		! %l6 = f28e19f1b2d88fc6
!	Mem[0000000072000060] = 41496ee0, %l3 = 000000004677966b
	lduba	[%o4+0x061]%asi,%g2	! %g2 = 0000000000000041
!	Jump to jmpl_3, CWP = 0
	set	p1_jmpl_3_he,%g1
	jmpl	%g1,%g6
!	Mem[0000000071000008] = 30fb933b06a0d46f, %l2 = 0000000081040060
	ldx	[%o2+0x008],%l2		! %l2 = 30fb933b06a0d46f
!	Registers modified during the branch to p1_jmpl_3
!	%l0  = 0000000037c024f2
!	%l2  = 000000008cef2cd6
!	%l6  = 0000000030fb933b
!	%l7  = ffffffffffb8450f
!	Mem[0000000071000008] = 30fb933b, %l0 = 0000000037c024f2
	ldsb	[%o2+0x009],%l0		! %l0 = fffffffffffffffb

p1_label_91:
!	Mem[0000000015000000] = 83ac4063 7500e147, %l6 = 30fb933b, %l7 = ffb8450f
	ldda	[%i2+%g0]0x80,%l6	! %l6 = 0000000083ac4063 000000007500e147
!	Mem[000000001480009c] = 7c91fab2, %l7 = 000000007500e147
	ldsba	[%i1+0x09d]%asi,%l7	! %l7 = ffffffffffffff91
!	Mem[00000000140000a0] = 2264e959 22c92a24, %l2 = 8cef2cd6, %l3 = 4677966b
	ldd	[%i0+0x0a0],%l2		! %l2 = 000000002264e959 0000000022c92a24
!	Mem[00000000158000a4] = 7c91fab2, %l3 = 0000000022c92a24
	ldsw	[%i3+0x0a4],%l3		! %l3 = 000000007c91fab2
!	Mem[00000000148001f0] = c917428c, %l0 = fffffffffffffffb
	lduba	[%i1+0x1f3]%asi,%l0	! %l0 = 000000000000008c

p1_label_92:
!	Mem[0000000015800008] = ce9550c5, %l4 = 000000000000006f
	ldstuba	[%i3+%o6]0x80,%l4	! %l4 = 00000000000000ce
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x040,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000014000040
!	%l2 = 000000002264e959, Mem[0000000014800000] = a9569bee6340ac83
	stxa	%l2,[%i1+%g0]0x80	! Mem[0000000014800000] = 000000002264e959
!	Mem[0000000071800008] = 15a1b990, %l1 = 000000000000001f
	swapa	[%o3+0x008]%asi,%l1	! %l1 = 0000000015a1b990
!	%f0  = 83bc4063 ee9b56a9 aa971ba0 8d0a32b0
!	%f4  = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	%f8  = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000015000040

p1_label_93:
!	%l6 = 0000000083ac4063, Mem[0000000072000074] = f1cd6608
	stw	%l6,[%o4+0x074]		! Mem[0000000072000074] = 83ac4063
!	Mem[0000000014800088] = 00000000, %l4 = 00000000000000ce
	ldub	[%i1+0x088],%l4		! %l4 = 0000000000000000
!	Mem[0000000015800008] = ff9550c5, %l5 = 0000000089041474
	ldsha	[%i3+%o6]0x80,%l5	! %l5 = ffffffffffffff95
!	Mem[0000000014800100] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000014800110] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000014800120] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000014800130] = b88546b0 ae796565 7c987a4e d36a38e5
	mov	0x100,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000014800100
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000015800080

p1_label_94:
!	Mem[00000000158000c0] = c1d5b8cf505b1665, %l7 = ffffffffffffff91
	ldxa	[%i3+0x0c0]%asi,%l7	! %l7 = c1d5b8cf505b1665
!	%l4 = 0000000000000000, %l0 = 000000000000008c, %l1 = 0000000015a1b990
	orn	%l4,%l0,%l1		! %l1 = ffffffffffffff73
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	mov	0x040,%g4
	stda	%f32,[%o4+%g4]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000014000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000014000150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000014000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000014000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 0000000014000140
!	Mem[0000000015000100] = afb28154 65c01aa5 dcc3b844 e1bfb531
!	Mem[0000000015000110] = 67264812 6c743d02 7664f91c 42af8257
!	Mem[0000000015000120] = 6f000aeb 31d6310c 78a32a32 9d0bd8e4
!	Mem[0000000015000130] = 1e7410eb 285586d5 7bdb9203 ddc78455
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000015000100

p1_label_95:
	membar	#Sync			! Added by membar checker (80)
!	Mem[000000007200007c] = 19220000, %l4 = 0000000000000000
	ldub	[%o4+0x07e],%g2		! %g2 = 0000000000000019
!	Mem[0000000015000060] = e798b4067c91fab2, %l3 = 000000007c91fab2
	ldx	[%i2+0x060],%l3		! %l3 = e798b4067c91fab2
!	Mem[0000000070000008] = 8130392d 6a3389dd, %l2 = 2264e959, %l3 = 7c91fab2
	ldd	[%o0+0x008],%l2		! %l2 = 000000008130392d 000000006a3389dd
!	Mem[0000000072000060] = b3a76970, %l3 = 000000006a3389dd
	ldsw	[%o4+0x060],%g2		! %g2 = 000000006a3389dd
	bneg	p1_b31			! Branch Taken, %ccr = 0a, CWP = 0

p1_label_96:
!	Mem[0000000014000130] = 84eb9ccc, %l5 = ffffffffffffff95
	lduh	[%i0+0x132],%l5		! %l5 = 0000000000009ccc
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p1_branch_failed
	mov	0x01f,%g2
p1_b31:
!	Mem[0000000072000028] = 9b3a060b59260946, %l2 = 000000008130392d
	ldx	[%o4+0x028],%g2		! %g2 = 9b3a060b59260946
!	Mem[00000000148001a5] = 59e96422, %l7 = c1d5b8cf505b1665
	ldstub	[%i1+0x1a5],%l7		! %l7 = 00000000000000e9
!	%l4 = 0000000000000000, immed = fffff2d0, %l5 = 0000000000009ccc
	orn	%l4,-0xd30,%l5		! %l5 = 0000000000000d2f
!	Mem[0000000071000048] = ffb8450f37c024f2, %l3 = 000000006a3389dd
	ldx	[%o2+0x048],%l3		! %l3 = ffb8450f37c024f2

p1_label_97:
!	Mem[0000000072000008] = 2ef43f1a7fb3a539, %l5 = 0000000000000d2f
	ldx	[%o4+0x008],%g2		! %g2 = 2ef43f1a7fb3a539
	bneg,a	p1_b32			! Branch Taken, %ccr = 0a, CWP = 0
!	Mem[0000000014000000] = cb5b64db, %l3 = ffb8450f37c024f2
	lduwa	[%i0+%g0]0x80,%l3	! %l3 = 00000000cb5b64db
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p1_branch_failed
	mov	0x020,%g2
p1_b32:
	fbug,pn	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%l4 = 0000000000000000, immed = fffff67c, %l3 = 00000000cb5b64db
	or	%l4,-0x984,%l3		! %l3 = fffffffffffff67c
p1_b33:

p1_label_98:
!	%l5 = 0000000000000d2f, %l6 = 0000000083ac4063, %y  = 7fffffff
	udivx	%l5,%l6,%l5		! %l5 = 0000000000000000
!	Mem[0000000015800000] = 2d393081, %l3 = fffffffffffff67c
	ldswa	[%i3+%g0]0x80,%l3	! %l3 = 000000002d393081
!	Mem[00000000148001a0] = 242ac92259ff6422, %l2 = 000000008130392d
	ldx	[%i1+0x1a0],%l2		! %l2 = 242ac92259ff6422
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	stda	%f0,[%i0]ASI_BLK_P	! Block Store to 0000000014000000
!	Mem[0000000014000100] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014000110] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014000120] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014000130] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	ldda	[%i0+%g6]ASI_BLK_P,%f0	! Block Load from 0000000014000100

p1_label_99:
!	%l6 = 0000000083ac4063, Mem[0000000014800008] = 00000000
	stwa	%l6,[%i1+%o6]0x80	! Mem[0000000014800008] = 83ac4063
	fbn,a,pn %fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000071800008] = 0000001fb59f5a4e, %l1 = ffffffffffffff73
	ldx	[%o3+0x008],%l1		! Annulled
p1_b34:
!	%l2 = 242ac92259ff6422, immed = 0000002e, %l6 = 0000000083ac4063
	srax	%l2,0x02e,%l6		! %l6 = 00000000000090ab
!	%f28 = d5865528, %f30 = 5584c7dd, %f19 = 44b8c3dc
	fadds	%f28,%f30,%f19		! %f19 = d246a580

p1_label_100:
!	%l7 = 00000000000000e9, immed = 00000e72, %l0 = 000000000000008c
	andcc	%l7,0xe72,%l0		! %l0 = 0000000000000060, %ccr = 00
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 eb0a006f e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	stda	%f16,[%o4+%g4]ASI_BLK_P	! Block Store to 0000000072000040
	membar	#Sync
	set	p1_b35,%o7
	fbe,pt	%fcc3,p1_near_1_le	! Branch Taken, %fcc3 = 0
!	Mem[0000000071800008] = 0000001f, %l7 = 00000000000000e9
	ldsb	[%o3+0x008],%l7		! %l7 = 0000000000000000
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p1_branch_failed
	mov	0x023,%g2
p1_b35:
!	Registers modified during the branch to p1_near_1
!	%l0  = dcb0caf6db746ed0
!	%l1  = d073ffb5e7fbca1a
!	%l4  = ffffffffffffffd6
!	Mem[0000000072000000] = ba171c5cb5b99af8, %l7 = 0000000000000000
	ldx	[%o4+0x000],%g2		! %g2 = ba171c5cb5b99af8

p1_label_101:
!	Mem[00000000150001f8] = 7beca753, %l6 = 00000000000090ab
	ldub	[%i2+0x1f8],%l6		! %l6 = 000000000000007b

	ba,a	p1_not_taken_0_end
p1_not_taken_0:
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba,a	p1_branch_failed
p1_not_taken_0_end:

!	Mem[0000000071000048] = ffb8450f, %l2 = 242ac92259ff6422
	lduwa	[%o2+0x048]%asi,%l2	! %l2 = 00000000ffb8450f
!	%f0  = de1e879c 8130392d 313478eb c55095ce
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000015000140
!	%l6 = 000000000000007b, immed = 00000f75, %l1 = d073ffb5e7fbca1a
	andcc	%l6,0xf75,%l1		! %l1 = 0000000000000071, %ccr = 00
!	Mem[0000000015000000] = 83ac4063, %l3 = 000000002d393081
	lduba	[%i2+%g0]0x80,%l3	! %l3 = 0000000000000083

p1_label_102:
!	Mem[0000000015000180] = 00008069 980ad041 b70116f9 fa479b22
!	Mem[0000000015000190] = a3b95d5b 2914d2fd cc72639a d4f36584
!	Mem[00000000150001a0] = d5cfa868 abaea779 e833f9ff 73d3d92a
!	Mem[00000000150001b0] = 1452a62d 156d689a beda83f8 d61f0c18
	mov	0x180,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000015000180
!	Mem[0000000014000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000014000150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000014000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000014000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014000140
!	Mem[00000000148001f8] = 534dc94a, %l2 = 00000000ffb8450f
	ldub	[%i1+0x1fa],%l2		! %l2 = 00000000000000c9
	membar	#Sync			! Added by membar checker (81)
	set	p1_b36,%o7
	fbuge	p1_far_0_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000014000000] = 4e5a9fb5, %l7 = 0000000000000000
	ldsba	[%i0+%g0]0x80,%l7	! %l7 = 000000000000004e
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x024,%g2
p1_b36:
!	Registers modified during the branch to p1_far_0
!	%l3  = 0000000052cb1c10
!	%l4  = ffffffffffffff8f
!	%l6  = 6798b4067c91fab2

p1_label_103:
!	Mem[000000001400012c] = 7254bcd2, %l1 = 0000000000000071
	ldub	[%i0+0x12d],%l1		! %l1 = 0000000000000054
!	Mem[0000000014000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000014000150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000014000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000014000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%i0+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000014000140
!	call to call_2, CWP = 0
	membar	#Sync			! Added by membar checker (82)
	call	p1_call_2_he
!	Mem[0000000015800170] = dcb0caf6db746ed0, %l6 = 6798b4067c91fab2
	ldx	[%i3+0x170],%l6		! %l6 = dcb0caf6db746ed0
!	Registers modified during the branch to p1_call_2
!	%l2  = 0000000037c024f2
	fbul,pn	%fcc3,p1_branch_failed	! Branch Not Taken, %fcc3 = 0

p1_label_104:
!	%l5 = 0000000000000000, %l6 = dcb0caf6db746ed0, %l3 = 0000000052cb1c10
	srlx	%l5,%l6,%l3		! %l3 = 0000000000000000
p1_b37:
!	%l5 = 0000000000000000, %l5 = 0000000000000000, %y  = 7fffffff
	smul	%l5,%l5,%l0		! %l0 = 0000000000000000
!	%f0  = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	%f4  = d85d13e6 dcaf441a 0b87bcfa c73b6d59
!	%f8  = 57e06ff3 640f343c 32c4d014 03f917fa
!	%f12 = d06e74db f6cab0dc 78a73f75 a10adb52
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000140
!	Mem[0000000014800000] = 00000000, %l6 = dcb0caf6db746ed0
	lduha	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000000
!	Mem[0000000040a00018] = 1f1f3e1d, %l7 = 000000000000004e
	lduha	[%o5+0x018]%asi,%l7	! %l7 = 0000000000001f1f

p1_label_105:
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 eb0a006f e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000015800180
	membar	#Sync
	set	p1_b38,%o7
	fba,a,pt %fcc0,p1_near_3_he	! Branch Taken, %fcc0 = 0
!	Mem[0000000072000000] = ba171c5cb5b99af8, %l5 = 0000000000000000
	ldx	[%o4+0x000],%g2		! Annulled
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x026,%g2
p1_b38:
!	Registers modified during the branch to p1_near_3
!	%l4  = ffb8450f37c024f2
!	%l6  = 000000000003b483
!	Mem[0000000015000008] = aa971ba0, %l2 = 0000000037c024f2
	ldsba	[%i2+%o6]0x80,%l2	! %l2 = ffffffffffffffaa
!	Mem[0000000015800008] = ff9550c5 eb783431, %l4 = 37c024f2, %l5 = 00000000
	ldda	[%i3+%o6]0x80,%l4	! %l4 = 00000000ff9550c5 00000000eb783431

p1_label_106:
!	Mem[00000000150000c4] = 6340ac83, %f25 = eb0a006f
	ld	[%i2+0x0c4],%f25	! %f25 = 6340ac83
!	%l4 = 00000000ff9550c5, immed = 000009dd, %l5 = 00000000eb783431
	andn	%l4,0x9dd,%l5		! %l5 = 00000000ff955000
!	Mem[0000000071000008] = 30fb933b06a0d46f, %l6 = 000000000003b483
	ldxa	[%o2+0x008]%asi,%l6	! %l6 = 30fb933b06a0d46f
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 6340ac83 e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	mov	0x080,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000014000080
!	Mem[0000000015800008] = ff9550c5 eb783431, %l2 = ffffffaa, %l3 = 00000000
	ldda	[%i3+%o6]0x80,%l2	! %l2 = 00000000ff9550c5 00000000eb783431

p1_label_107:
	fble,pn	%fcc2,p1_branch_failed	! Branch Not Taken, %fcc2 = 2
!	%f14 = 78a73f75 a10adb52, %f4  = d85d13e6 dcaf441a
	fabsd	%f14,%f4 		! %f4  = 78a73f75 a10adb52
p1_b39:
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 6340ac83 e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 0000000014000180
!	Mem[0000000070000048] = 37c024f2, %l4 = 00000000ff9550c5
	ldswa	[%o0+0x048]%asi,%l4	! %l4 = 0000000037c024f2
!	Mem[0000000015800000] = 2d3930819c871ede, %l3 = 00000000eb783431
	ldxa	[%i3+%g0]0x80,%l3	! %l3 = 2d3930819c871ede

p1_label_108:
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 6340ac83 e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	mov	0x100,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000015800100
!	%f0  = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	%f4  = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	%f8  = 57e06ff3 640f343c 32c4d014 03f917fa
!	%f12 = d06e74db f6cab0dc 78a73f75 a10adb52
	mov	0x040,%g6
	stda	%f0,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
	membar	#Sync			! Added by membar checker (83)
!	Mem[0000000072000060] = 3c340f64f36fe057, %l6 = 30fb933b06a0d46f
	ldx	[%o4+0x060],%g2		! %g2 = 3c340f64f36fe057
!	Mem[000000007080004c] = 4677966b, %l1 = 0000000000000054
	ldsb	[%o1+0x04f],%l1		! %l1 = 000000000000006b
!	Mem[0000000071000048] = ffb8450f, %l2 = 00000000ff9550c5
	lduw	[%o2+0x048],%l2		! %l2 = 00000000ffb8450f

p1_label_109:
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 6340ac83 e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	mov	0x080,%g4
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 0000000015800080
!	Mem[0000000070000008] = 8130392d6a3389dd, %l0 = 0000000000000000
	ldx	[%o0+0x008],%l0		! %l0 = 8130392d6a3389dd
!	%f0  = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	%f4  = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	%f8  = 57e06ff3 640f343c 32c4d014 03f917fa
!	%f12 = d06e74db f6cab0dc 78a73f75 a10adb52
	stda	%f0,[%i2]ASI_BLK_PL	! Block Store to 0000000015000000
	membar	#Sync			! Added by membar checker (84)
!	Mem[0000000015000008] = 883fcc5532bd6c16, %l0 = 8130392d6a3389dd
	ldxa	[%i2+%o6]0x80,%l0	! %l0 = 883fcc5532bd6c16
!	%l2 = 00000000ffb8450f, %l3 = 2d3930819c871ede, %l5 = 00000000ff955000
	sub	%l2,%l3,%l5		! %l5 = d2c6cf7f63312631

p1_label_110:
!	Mem[0000000014800180] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014800190] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000148001a0] = 242ac922 59ff6422 1f8dc811 7254bcd2
!	Mem[00000000148001b0] = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x180,%g4
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000014800180
!	Mem[00000000140000d0] = 90837c71, %l6 = 30fb933b06a0d46f
	ldswa	[%i0+0x0d0]%asi,%l6	! %l6 = ffffffff90837c71
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l5 = d2c6cf7f63312631, immed = fffff515, %l2 = 00000000ffb8450f
	xor	%l5,-0xaeb,%l2		! %l2 = 2d3930809cced324
!	%l5 = d2c6cf7f63312631, %l1 = 000000000000006b, %l6 = ffffffff90837c71
	subc	%l5,%l1,%l6		! %l6 = d2c6cf7f633125c6

p1_label_111:
!	%f0  = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	%f4  = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	%f8  = 57e06ff3 640f343c 32c4d014 03f917fa
!	%f12 = d06e74db f6cab0dc 78a73f75 a10adb52
	mov	0x140,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000015000140
!	Mem[0000000014000080] = afb28154 65c01aa5 80a546d2 e1bfb531
!	Mem[0000000014000090] = 67264812 6c743d02 7664f91c 42af8257
!	Mem[00000000140000a0] = 83ac4063 31d6310c 78a32a32 9d0bd8e4
!	Mem[00000000140000b0] = 1e7410eb 285586d5 7bdb9203 ddc78455
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000014000080
!	Mem[0000000014000008] = 432751c8, %l0 = 883fcc5532bd6c16
	ldsba	[%i0+%o6]0x80,%l0	! %l0 = 0000000000000043
!	Mem[0000000014000080] = afb28154 65c01aa5 80a546d2 e1bfb531
!	Mem[0000000014000090] = 67264812 6c743d02 7664f91c 42af8257
!	Mem[00000000140000a0] = 83ac4063 31d6310c 78a32a32 9d0bd8e4
!	Mem[00000000140000b0] = 1e7410eb 285586d5 7bdb9203 ddc78455
	ldda	[%i0+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000014000080
	fbl,a	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0

p1_label_112:
!	 Annulled
	ldda	[%i0+%o6]0x80,%l4
p1_b40:
	bl	p1_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[000000007080004c] = 4677966b, %l5 = d2c6cf7f63312631
	ldsw	[%o1+0x04c],%l5		! %l5 = 000000004677966b
p1_b41:
!	Mem[0000000071800008] = 0000001f, %l2 = 2d3930809cced324
	ldub	[%o3+0x00a],%l2		! %l2 = 0000000000000000
!	Mem[00000000170001a4] = 7850c7b3, %l2 = 0000000000000000
	ldsw	[%i6+0x1a4],%l2		! %l2 = 000000007850c7b3

p1_label_113:
!	Mem[0000000072000058] = 596d3bc7fabc870b, %l6 = d2c6cf7f633125c6
	ldx	[%o4+0x058],%g2		! %g2 = 596d3bc7fabc870b
!	%f0  = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	%f4  = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	%f8  = 57e06ff3 640f343c 32c4d014 03f917fa
!	%f12 = d06e74db f6cab0dc 78a73f75 a10adb52
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000015000180
	membar	#Sync
	fbn	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000014800168] = 1f8dc8117254bcd2, %l5 = 000000004677966b
	ldx	[%i1+0x168],%l5		! %l5 = 1f8dc8117254bcd2
p1_b42:
!	Mem[00000000140000c0] = 83bc4063 ee9b56a9 aa971ba0 8d0a32b0
!	Mem[00000000140000d0] = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	Mem[00000000140000e0] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[00000000140000f0] = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x0c0,%g4
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000140000c0

p1_label_114:
!	Mem[0000000070000008] = 8130392d, %l7 = 0000000000001f1f
	lduwa	[%o0+0x008]%asi,%l7	! %l7 = 000000008130392d
!	Mem[0000000015000180] = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	Mem[0000000015000190] = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	Mem[00000000150001a0] = 57e06ff3 640f343c 32c4d014 03f917fa
!	Mem[00000000150001b0] = d06e74db f6cab0dc 78a73f75 a10adb52
	mov	0x180,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000015000180
!	Mem[0000000072000040] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000072000050] = 52db0aa1 753fa778 596d3bc7 fabc870b
!	Mem[0000000072000060] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000072000070] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
	fbn,a	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000070000048] = 37c024f2a5b95976, %l0 = 0000000000000043
	ldx	[%o0+0x048],%l0		! Annulled
p1_b43:

p1_label_115:
!	Mem[00000000140001f0] = 29c06c103869e371, %l5 = 1f8dc8117254bcd2
	ldxa	[%i0+0x1f0]%asi,%l5	! %l5 = 29c06c103869e371
!	%l7 = 000000008130392d, %l5 = 29c06c103869e371, %l2 = 000000007850c7b3
	subc	%l7,%l5,%l2		! %l2 = d63f93f048c655bc
!	Mem[0000000014800110] = 1c062400 822c7d4d, %l2 = 48c655bc, %l3 = 9c871ede
	ldd	[%i1+0x110],%l2		! %l2 = 000000001c062400 00000000822c7d4d
!	%l5 = 29c06c103869e371, %l4 = 0000000037c024f2, %y  = 00000000
	umulcc	%l5,%l4,%l2		! %l2 = 0c49176c13d4e4d2, %ccr = 00
!	Mem[0000000015000058] = 635f1c94, %l3 = 00000000822c7d4d
	ldsw	[%i2+0x058],%l3		! %l3 = 00000000635f1c94

p1_label_116:
!	Mem[0000000072000030] = 2e7632ed24e17d86, %l7 = 000000008130392d
	ldx	[%o4+0x030],%g2		! %g2 = 2e7632ed24e17d86
!	%f14 = 78a73f75, %f4  = 78a73f75, %f5  = a10adb52
	fsubs	%f14,%f4 ,%f5 		! %f5  = 00000000
!	%f16 = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f20 = 52db0aa1 753fa778 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000014000040
!	%l6 = d2c6cf7f633125c6, %l4 = 0000000037c024f2, %y  = 0c49176c
	sdivcc	%l6,%l4,%l5		! %l5 = 000000003869e372, %ccr = 00
	mov	%l0,%y			! %y = 00000043
	fbg	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0

p1_label_117:
!	Mem[0000000015800150] = 1a44afdc, %l5 = 000000003869e372
	ldsh	[%i3+0x152],%l5		! %l5 = ffffffffffffafdc
p1_b44:
!	Mem[0000000072000040] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000072000050] = 52db0aa1 753fa778 596d3bc7 fabc870b
!	Mem[0000000072000060] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000072000070] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
	bneg,a	p1_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[0000000072000028] = 3a060b59, %l1 = 000000000000006b
	ldub	[%o4+0x029],%g2		! Annulled
p1_b45:
!	Mem[00000000150001bc] = a10adb52, %l6 = d2c6cf7f633125c6
	ldswa	[%i2+0x1bc]%asi,%l6	! %l6 = ffffffffa10adb52

p1_label_118:
!	Mem[0000000072000040] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000072000050] = 52db0aa1 753fa778 596d3bc7 fabc870b
!	Mem[0000000072000060] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000072000070] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[000000007180000c] = b59f5a4e, %l3 = 00000000635f1c94
	lduba	[%o3+0x00d]%asi,%l3	! %l3 = 000000000000009f
!	Mem[0000000015000000] = 18ebe0c652a5e21b, %l7 = 000000008130392d
	ldxa	[%i2+%g0]0x80,%l7	! %l7 = 18ebe0c652a5e21b
!	%l2 = 0c49176c13d4e4d2, %l5 = ffffffffffffafdc, %l6 = ffffffffa10adb52
	tsubcc	%l2,%l5,%l6		! %l6 = 0c49176c13d534f6, %ccr = 13
	bvc	p1_not_taken_0		! Branch Not Taken, %ccr = 13

p1_label_119:
!	Mem[0000000072000034] = e17d86f4, %l1 = 000000000000006b
	ldub	[%o4+0x035],%g2		! %g2 = 00000000000000e1
p1_b46:
!	Mem[0000000015000098] = 668fed6d 83a114d9, %l2 = 13d4e4d2, %l3 = 0000009f
	ldd	[%i2+0x098],%l2		! %l2 = 00000000668fed6d 0000000083a114d9
!	%f0  = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	%f4  = 78a73f75 00000000 0b87bcfa c73b6d59
!	%f8  = 57e06ff3 640f343c 32c4d014 03f917fa
!	%f12 = d06e74db f6cab0dc 78a73f75 a10adb52
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000015000180
!	Mem[0000000071800008] = 0000001f b59f5a4e, %l4 = 37c024f2, %l5 = ffffafdc
	ldd	[%o3+0x008],%l4		! %l4 = 000000000000001f 00000000b59f5a4e
!	Mem[0000000014000008] = 432751c8, %l3 = 0000000083a114d9
	lduwa	[%i0+%o6]0x80,%l3	! %l3 = 00000000432751c8

p1_label_120:
!	Mem[0000000015000040] = a9569bee 6340bc83 b0320a8d a01b97aa
!	Mem[0000000015000050] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[0000000015000060] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000015000070] = 29c06c10 3869e371 1c35ae27 fe63449e
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 0000000015000040
!	Mem[00000000170000c0] = 1af398de e293d127 f07de185 97068b09
!	Mem[00000000170000d0] = 49d315d9 92028b78 0debd125 23eb308c
!	Mem[00000000170000e0] = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	Mem[00000000170000f0] = c37c5407 0d319a2e 952d15d3 024fafd1
	ldda	[%i6+%g4]ASI_BLK_P,%f0	! Block Load from 00000000170000c0
!	%f16 = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f20 = 52db0aa1 753fa778 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000015000140
!	%l5 = 00000000b59f5a4e, %l2 = 00000000668fed6d, %y  = 00000043
	smulcc	%l5,%l2,%l1		! %l1 = e233ad036105a936, %ccr = 80
!	%f16 = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f20 = 52db0aa1 753fa778 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x1c0,%g5
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 00000000148001c0

p1_label_121:
!	Mem[0000000014000000] = 4e5a9fb5 90b9a115, %l4 = 0000001f, %l5 = b59f5a4e
	ldda	[%i0+%g0]0x80,%l4	! %l4 = 000000004e5a9fb5 0000000090b9a115
!	%f0  = 1af398de e293d127, %f0  = 1af398de e293d127
	fcmped	%fcc1,%f0 ,%f0 		! %fcc1 = 0
!	Mem[0000000040a0001c] = 0a242719, %l2 = 00000000668fed6d
	lduw	[%o5+0x01c],%l2		! %l2 = 000000000a242719
!	%l7 = 18ebe0c652a5e21b, Mem[0000000014800008] = 83ac4063
	stha	%l7,[%i1+%o6]0x80	! Mem[0000000014800008] = e21b4063
	membar	#Sync
	set	p1_b47,%o7
	fbule,a	p1_far_0_le		! Branch Taken, %fcc0 = 0

p1_label_122:
!	Mem[0000000014800008] = e21b4063, %l4 = 000000004e5a9fb5
	ldswa	[%i1+%o6]0x80,%l4	! %l4 = ffffffffe21b4063
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p1_branch_failed
	mov	0x02f,%g2
p1_b47:
!	Registers modified during the branch to p1_far_0
!	%l0  = 000000000000008f
!	%l1  = 0000000000000077
!	%l5  = 0000000000000075
!	Mem[0000000015800180] = a51ac065 5481b2af 31b5bfe1 d246a580
!	Mem[0000000015800190] = 023d746c 12482667 5782af42 1cf96476
!	Mem[00000000158001a0] = 0c31d631 eb0a006f e4d80b9d 322aa378
!	Mem[00000000158001b0] = d5865528 eb10741e 5584c7dd 0392db7b
	mov	0x180,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 0000000015800180
	membar	#Sync			! Added by membar checker (85)
	set	p1_b48,%o7
	fbuge,a	p1_far_1_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000014800008] = e21b4063, %l5 = 0000000000000075
	lduba	[%i1+%o6]0x80,%l5	! %l5 = 00000000000000e2
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p1_branch_failed
	mov	0x030,%g2
p1_b48:
!	Registers modified during the branch to p1_far_1
!	%l0  = a9569bee6340ac83
!	%l4  = e473bc7c7462a5e3
!	%f0  = 1af398de e293d127 f07de185 97068b09
!	%f4  = 49d315d9 92028b78 0debd125 23eb308c
!	%f8  = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	%f12 = c37c5407 0d319a2e 952d15d3 024fafd1
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 00000000150001c0

p1_label_123:
!	%l1 = 0000000000000077, Mem[0000000014800030] = 29c06c10
	sth	%l1,[%i1+0x030]		! Mem[0000000014800030] = 00776c10
!	Mem[0000000071800008] = 0000001fb59f5a4e, %l1 = 0000000000000077
	ldx	[%o3+0x008],%l1		! %l1 = 0000001fb59f5a4e
!	Mem[0000000015000008] = 883fcc55, %l3 = 00000000432751c8
	ldswa	[%i2+%o6]0x80,%l3	! %l3 = ffffffff883fcc55
!	%f16 = a51ac065 5481b2af 31b5bfe1 d246a580
!	%f20 = 023d746c 12482667 5782af42 1cf96476
!	%f24 = 0c31d631 eb0a006f e4d80b9d 322aa378
!	%f28 = d5865528 eb10741e 5584c7dd 0392db7b
	mov	0x080,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000014000080
!	Mem[0000000014800018] = 6798b406, %f1  = e293d127
	ld	[%i1+0x018],%f1 	! %f1 = 6798b406

p1_label_124:
!	Mem[0000000015000008] = 883fcc55, %l0 = a9569bee6340ac83
	ldsw	[%i2+0x008],%l0		! %l0 = ffffffff883fcc55
!	Mem[0000000071800048] = f28e19f1, %l0 = ffffffff883fcc55
	ldsh	[%o3+0x04a],%l0		! %l0 = 00000000000019f1
!	%f0  = 1af398de 6798b406 f07de185 97068b09
!	%f4  = 49d315d9 92028b78 0debd125 23eb308c
!	%f8  = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	%f12 = c37c5407 0d319a2e 952d15d3 024fafd1
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	%l1 = 0000001fb59f5a4e, %l1 = 0000001fb59f5a4e, %l4 = e473bc7c7462a5e3
	orcc	%l1,%l1,%l4		! %l4 = 0000001fb59f5a4e, %ccr = 08
	membar	#Sync
	bgu	p1_b49			! Branch Taken, %ccr = 08, CWP = 0

p1_label_125:
!	Mem[0000000014800008] = e21b4063, %l2 = 000000000a242719
	ldsba	[%i1+%o6]0x80,%l2	! %l2 = ffffffffffffffe2
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p1_branch_failed
	mov	0x031,%g2
p1_b49:
!	%l7 = 18ebe0c652a5e21b, immed = fffff0be, %y  = e233ad03
	sdiv	%l7,-0xf42,%l5		! %l5 = 000000007fffffff
	mov	%l0,%y			! %y = 000019f1
!	Mem[00000000140001c0] = a9569bee 6340ac83 00000000 00000000
!	Mem[00000000140001d0] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[00000000140001e0] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[00000000140001f0] = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x1c0,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 00000000140001c0
!	%f0  = 1af398de 6798b406 f07de185 97068b09
!	%f4  = 49d315d9 92028b78 0debd125 23eb308c
!	%f8  = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	%f12 = c37c5407 0d319a2e 952d15d3 024fafd1
	stda	%f0,[%i5+%g5]ASI_BLK_P	! Block Store to 00000000168001c0
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 9e4463fe 27ae351c
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000148000c0

p1_label_126:
!	Mem[0000000015000040] = a9569bee 6340bc83 b0320a8d a01b97aa
!	Mem[0000000015000050] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[0000000015000060] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000015000070] = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x040,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000015000040
!	%f20 = 90837c71 9e9dabd2, %f24 = b2fa917c 06b498e7
	fcmped	%fcc1,%f20,%f24		! %fcc1 = 2
!	%f24 = b2fa917c 06b498e7, %f30 = 9e4463fe 27ae351c
	fnegd	%f24,%f30		! %f30 = 32fa917c 06b498e7
!	Mem[0000000072000040] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000072000050] = 52db0aa1 753fa778 596d3bc7 fabc870b
!	Mem[0000000072000060] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000072000070] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800008] = 0000001fb59f5a4e, %l3 = ffffffff883fcc55
	ldxa	[%o3+0x008]%asi,%l3	! %l3 = 0000001fb59f5a4e

p1_label_127:
!	%l3 = 0000001fb59f5a4e, immed = fffff628, %l1 = 0000001fb59f5a4e
	andcc	%l3,-0x9d8,%l1		! %l1 = 0000001fb59f5208, %ccr = 08
!	Mem[0000000014800000] = 00000000, %l3 = 0000001fb59f5a4e
	ldsba	[%i1+%g0]0x80,%l3	! %l3 = 0000000000000000
!	%l0 = 00000000000019f1, immed = 00000fd3, %y  = 000019f1
	umul	%l0,0xfd3,%l1		! %l1 = 00000000019a80a3
!	%f20 = 90837c71, %f22 = b2fa917c, %f10 = e4fc164f 7500e147
	fsmuld	%f20,%f22,%f10		! %f10 = 38801647 f0c8f780
!	Mem[000000001500018c] = 55cc3f88, %l5 = 000000007fffffff
	lduha	[%i2+0x18e]%asi,%l5	! %l5 = 0000000000003f88

p1_label_128:
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 32fa917c 06b498e7
	stda	%f16,[%i1+%g5]ASI_BLK_P	! Block Store to 0000000014800040
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 32fa917c 06b498e7
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 0000000014800180
!	Mem[0000000014000084] = 5481b2af, %l2 = ffffffffffffffe2
	ldsha	[%i0+0x084]%asi,%l2	! %l2 = 0000000000005481
!	Mem[0000000014800008] = e21b4063, %l0 = 00000000000019f1
	lduba	[%i1+%o6]0x80,%l0	! %l0 = 00000000000000e2
!	Mem[0000000014800000] = 00000000 2264e959, %l6 = 13d534f6, %l7 = 52a5e21b
	ldda	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000000 000000002264e959

p1_label_129:
!	%l5 = 0000000000003f88, Mem[0000000071000008] = 30fb933b
	stw	%l5,[%o2+0x008]		! Mem[0000000071000008] = 00003f88
!	Mem[0000000015000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000015000150] = 52db0aa1 753fa778 596d3bc7 fabc870b
!	Mem[0000000015000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000015000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000015000140
!	Mem[0000000015000000] = 18ebe0c6, %l1 = 00000000019a80a3
	lduwa	[%i2+%g0]0x80,%l1	! %l1 = 0000000018ebe0c6
!	%l6 = 0000000000000000, immed = fffff4d5, %l5 = 0000000000003f88
	andn	%l6,-0xb2b,%l5		! %l5 = 0000000000000000
	membar	#Sync			! Added by membar checker (86)
!	%l4 = 0000001fb59f5a4e, Mem[0000000072000050] = 52db0aa1753fa778
	stxa	%l4,[%o4+0x050]%asi	! Mem[0000000072000050] = 0000001fb59f5a4e

p1_label_130:
!	Mem[0000000014000044] = c6e0eb18, %l3 = 0000000000000000
	ldsh	[%i0+0x044],%l3		! %l3 = ffffffffffffc6e0
	bcs,a	p1_not_taken_0		! Branch Not Taken, %ccr = 08
!	Mem[0000000071000048] = ffb8450f37c024f2, %l2 = 0000000000005481
	ldx	[%o2+0x048],%l2		! Annulled
p1_b50:
!	%f16 = 83ac4063 ee9b56a9 00000000 00000000
!	%f20 = 90837c71 9e9dabd2 b2fa917c 06b49867
!	%f24 = b2fa917c 06b498e7 e4fc164f 7500e147
!	%f28 = 71e36938 106cc029 32fa917c 06b498e7
	mov	0x040,%g5
	stda	%f16,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000015800000] = 2d393081 9c871ede, %l4 = b59f5a4e, %l5 = 00000000
	ldda	[%i3+%g0]0x80,%l4	! %l4 = 000000002d393081 000000009c871ede

p1_label_131:
!	Mem[0000000015800000] = 2d393081 9c871ede ff9550c5 eb783431
!	Mem[0000000015800010] = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	Mem[0000000015800020] = 2264e959 22c92a24 d2bc5472 11c88d1f
!	Mem[0000000015800030] = 52cb1c10 2d393001 e3a56274 7cbc73e4
	ldda	[%i3]ASI_BLK_PL,%f0	! Block Load from 0000000015800000
!	Mem[00000000140001d8] = 6798b406, %l2 = 0000000000005481
	lduwa	[%i0+0x1d8]%asi,%l2	! %l2 = 000000006798b406
!	%l6 = 00000000, %l7 = 2264e959, Mem[0000000014000018] = ad511a45 c88e483c
	stda	%l6,[%i0+0x018]%asi	! Mem[0000000014000018] = 00000000 2264e959
!	%l1 = 0000000018ebe0c6, Mem[00000000140001bc] = ddc78455
	stha	%l1,[%i0+0x1bc]%asi	! Mem[00000000140001bc] = e0c68455
!	Mem[0000000070000008] = 8130392d 6a3389dd, %l6 = 00000000, %l7 = 2264e959
	ldda	[%o0+0x008]%asi,%l6	! %l6 = 000000008130392d 000000006a3389dd

p1_label_132:
!	Mem[00000000158001d8] = 6798b4067c91fab2, %l1 = 0000000018ebe0c6
	ldx	[%i3+0x1d8],%l1		! %l1 = 6798b4067c91fab2
!	Mem[0000000071800048] = f28e19f1, %l7 = 000000006a3389dd
	ldsw	[%o3+0x048],%l7		! %l7 = fffffffff28e19f1
!	Mem[0000000071800048] = f28e19f1, %l2 = 000000006798b406
	ldsw	[%o3+0x048],%l2		! %l2 = fffffffff28e19f1
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
	membar	#Sync			! Added by membar checker (87)
!	Mem[0000000072000040] = 83ac4063 ee9b56a9 00000000 00000000
!	Mem[0000000072000050] = 90837c71 9e9dabd2 b2fa917c 06b49867
!	Mem[0000000072000060] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[0000000072000070] = 71e36938 106cc029 32fa917c 06b498e7
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040

p1_label_133:
!	Mem[0000000072000068] = e4fc164f7500e147, %l4 = 000000002d393081
	ldx	[%o4+0x068],%g2		! %g2 = e4fc164f7500e147
!	%l4 = 000000002d393081, immed = fffff181, %y  = 00000000
	sdivcc	%l4,-0xe7f,%l6		! %l6 = fffffffffffce15c, %ccr = 88
	mov	%l0,%y			! %y = 000000e2
!	Mem[0000000070800048] = 00000000, %l7 = fffffffff28e19f1
	ldub	[%o1+0x048],%l7		! %l7 = 0000000000000000
!	Mem[0000000015000000] = 18ebe0c6, %l6 = fffffffffffce15c
	ldswa	[%i2+%g0]0x80,%l6	! %l6 = 0000000018ebe0c6
!	%f0  = de1e879c 8130392d 313478eb c55095ff
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x100,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000015800100

p1_label_134:
!	call to call_3, CWP = 0
	membar	#Sync			! Added by membar checker (88)
	call	p1_call_3_he
!	Mem[0000000014800160] = 242ac922, %l4 = 000000002d393081
	ldsw	[%i1+0x160],%l4		! %l4 = 00000000242ac922
!	Registers modified during the branch to p1_call_3
!	%l5  = 0130392d101ccb52
!	%l6  = d5865528eb10741e
!	%f0  = de1e879c 8130392d 313478eb c55095ff
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x080,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000014000080
!	%f16 = 83ac4063 ee9b56a9, %f16 = 83ac4063 ee9b56a9
	fnegd	%f16,%f16		! %f16 = 03ac4063 ee9b56a9
	fbe,pn	%fcc2,p1_branch_failed	! Branch Not Taken, %fcc2 = 2

p1_label_135:
!	Mem[00000000148001f0] = d06e74dbf6cab0dc, %l6 = d5865528eb10741e
	ldx	[%i1+0x1f0],%l6		! %l6 = d06e74dbf6cab0dc
p1_b51:
!	Mem[0000000014800000] = 00000000, %l5 = 0130392d101ccb52
	ldsha	[%i1+%g0]0x80,%l5	! %l5 = 0000000000000000
!	Mem[0000000015800140] = 18ebe0c6 53aad35d 883fcc55 32bd6c16
!	Mem[0000000015800150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000015800160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000015800170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 0000000015800140
!	Mem[00000000158001a8] = e4d80b9d, %l0 = 00000000000000e2
	ldsh	[%i3+0x1a8],%l0		! %l0 = ffffffffffffe4d8
!	%f12 = 0130392d, %f2  = 313478eb c55095ff
	fitod	%f12,%f2 		! %f2  = 41730392 d0000000

p1_label_136:
!	%f0  = de1e879c 8130392d 41730392 d0000000
!	%f4  = 29b11beb e58af091 668fed6d 83a114d9
!	%f8  = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f12 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x1c0,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 00000000158001c0
!	%f17 = 53aad35d, %f17 = 53aad35d, %f16 = 18ebe0c6 53aad35d
	fsmuld	%f17,%f17,%f16		! %f16 = 44fc7f59 819bf240
!	Mem[0000000014800000] = 00000000, %l5 = 0000000000000000
	ldswa	[%i1+%g0]0x80,%l5	! %l5 = 0000000000000000
!	Mem[0000000071800048] = f28e19f1, %l3 = ffffffffffffc6e0
	ldsba	[%o3+0x04b]%asi,%l3	! %l3 = fffffffffffffff1
!	Mem[0000000014800140] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014800150] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014800160] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014800170] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000014800140

p1_label_137:
!	Mem[0000000070000048] = 37c024f2, %l2 = fffffffff28e19f1
	ldsh	[%o0+0x04a],%l2		! %l2 = 00000000000024f2
!	%l2 = 00000000000024f2, Mem[000000001500006a] = 47e10075
	sth	%l2,[%i2+0x06a]		! Mem[0000000015000068] = 47e124f2
	bl,a	p1_b52			! Branch Taken, %ccr = 88, CWP = 0
!	Mem[0000000014800008] = e21b406300000000, %l6 = d06e74dbf6cab0dc
	ldxa	[%i1+%o6]0x80,%l6	! %l6 = e21b406300000000
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p1_branch_failed
	mov	0x034,%g2
p1_b52:
!	Mem[0000000014800000] = 00000000, %l1 = 6798b4067c91fab2
	ldswa	[%i1+%g0]0x80,%l1	! %l1 = 0000000000000000

p1_label_138:
!	%l2 = 00000000000024f2, %l6 = e21b406300000000, %y  = 000000e2
	umul	%l2,%l6,%l3		! %l3 = 0000000000000000
!	%f16 = 44fc7f59 819bf240, %f20 = 1a44afdc e6135dd8
	fnegd	%f16,%f20		! %f20 = c4fc7f59 819bf240
!	Mem[0000000014000140] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000014000150] = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	Mem[0000000014000160] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000014000170] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014000140
!	Mem[0000000070800008] = d073ffb5e7fbca1a, %l7 = 0000000000000000
	ldx	[%o1+0x008],%l7		! %l7 = d073ffb5e7fbca1a
!	Mem[0000000014800008] = e21b4063, %l6 = e21b406300000000
	lduwa	[%i1+%o6]0x80,%l6	! %l6 = 00000000e21b4063

p1_label_139:
!	Mem[0000000016800180] = 637c4d04, %l7 = d073ffb5e7fbca1a
	ldsw	[%i5+0x180],%l7		! %l7 = 00000000637c4d04
!	%l3 = 0000000000000000, immed = fffff8a7, %l2 = 00000000000024f2
	or	%l3,-0x759,%l2		! %l2 = fffffffffffff8a7
!	Mem[0000000014800008] = e21b4063, %l0 = ffffffffffffe4d8
	swapa	[%i1+%o6]0x80,%l0	! %l0 = 00000000e21b4063
!	Mem[0000000072000000] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000010] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000020] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000030] = 867de124 ed32762e 22195cfc 247230f4
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	%f0  = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f4  = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f8  = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f12 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x040,%g6
	stda	%f0,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040

p1_label_140:
!	Mem[0000000014000008] = 432751c8, %l7 = 00000000637c4d04
	ldsba	[%i0+%o6]0x80,%l7	! %l7 = 0000000000000043
!	%f25 = f36fe057, %f22 = 596d3bc7 fabc870b
	fitod	%f25,%f22		! %f22 = c1a9203f 52000000
!	Mem[0000000070000048] = 37c024f2a5b95976, %l5 = 0000000000000000
	ldxa	[%o0+0x048]%asi,%l5	! %l5 = 37c024f2a5b95976
	membar	#Sync			! Added by membar checker (89)
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x0c0,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 00000000150000c0

p1_label_141:
!	Mem[0000000015000008] = 883fcc55, %l1 = 0000000000000000
	lduba	[%i2+%o6]0x80,%l1	! %l1 = 0000000000000088
!	%l6 = 00000000e21b4063, immed = 00000019, %l7 = 0000000000000043
	sra	%l6,0x019,%l7		! %l7 = fffffffffffffff1
!	Mem[0000000071000048] = ffb8450f 37c024f2, %l4 = 242ac922, %l5 = a5b95976
	ldd	[%o2+0x048],%l4		! %l4 = 00000000ffb8450f 0000000037c024f2
!	Mem[00000000140000f8] = 9e4463fe, %l3 = 0000000000000000
	ldub	[%i0+0x0fb],%l3		! %l3 = 00000000000000fe
	bcc,a	p1_b53			! Branch Taken, %ccr = 88, CWP = 0

p1_label_142:
!	Mem[0000000070800048] = 000000004677966b, %l6 = 00000000e21b4063
	ldx	[%o1+0x048],%l6		! %l6 = 000000004677966b
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p1_branch_failed
	mov	0x035,%g2
p1_b53:
!	Mem[0000000071800048] = f28e19f1, %l3 = 00000000000000fe
	ldsba	[%o3+0x04b]%asi,%l3	! %l3 = fffffffffffffff1
!	Mem[0000000015800068] = e4fc164f, %l0 = 00000000e21b4063
	lduwa	[%i3+0x068]%asi,%l0	! %l0 = 00000000e4fc164f
!	Mem[000000007000000c] = 6a3389dd, %l3 = fffffffffffffff1
	lduba	[%o0+0x00f]%asi,%l3	! %l3 = 00000000000000dd
!	%f0  = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f4  = 1a44afdc e6135dd8 596d3bc7 fabc870b
!	%f8  = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f12 = dcb0caf6 db746ed0 52db0aa1 753fa778
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000158001c0

p1_label_143:
!	Mem[00000000170001d0] = 707aef67b39b333f, %l0 = 00000000e4fc164f
	ldx	[%i6+0x1d0],%l0		! %l0 = 707aef67b39b333f
!	Mem[0000000072000014] = 757f06b3, %l2 = fffffffffffff8a7
	lduw	[%o4+0x014],%g2		! %g2 = fffffffffffff8a7
!	%f16 = 44fc7f59 819bf240, %f16 = 44fc7f59 819bf240
	fcmpd	%fcc3,%f16,%f16		! %fcc3 = 0
!	%f16 = 44fc7f59 819bf240, %f16 = 44fc7f59 819bf240
	fcmped	%fcc2,%f16,%f16		! %fcc2 = 0
!	Mem[000000007180004c] = b2d88fc6, %l7 = fffffffffffffff1
	ldsw	[%o3+0x04c],%l7		! %l7 = ffffffffb2d88fc6

p1_label_144:
!	Mem[0000000014800038] = 1c35ae27 fe63449e, %l4 = ffb8450f, %l5 = 37c024f2
	ldda	[%i1+0x038]%asi,%l4	! %l4 = 000000001c35ae27 00000000fe63449e
!	Mem[0000000071000008] = 00003f88, %l4 = 000000001c35ae27
	lduw	[%o2+0x008],%l4		! %l4 = 0000000000003f88
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000180
!	%l0 = 707aef67b39b333f, immed = fffff0d7, %l3 = 00000000000000dd
	addcc	%l0,-0xf29,%l3		! %l3 = 707aef67b39b2416, %ccr = 19
!	Mem[0000000071800048] = f28e19f1, %l2 = fffffffffffff8a7
	swapa	[%o3+0x048]%asi,%l2	! %l2 = 00000000f28e19f1

p1_label_145:
!	Mem[0000000015000000] = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	Mem[0000000015000010] = 52db0aa1 753fa778 596d3bc7 fabc870b
!	Mem[0000000015000020] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[0000000015000030] = dcb0caf6 db746ed0 52db0aa1 753fa778
	ldda	[%i2]ASI_BLK_PL,%f16	! Block Load from 0000000015000000
!	Mem[0000000015800100] = de1e879c8130392d, %l1 = 0000000000000088
	ldx	[%i3+0x100],%l1		! %l1 = de1e879c8130392d
!	Mem[0000000014000000] = 4e5a9fb5, %l2 = 00000000f28e19f1
	ldsba	[%i0+%g0]0x80,%l2	! %l2 = 000000000000004e
!	Mem[0000000014800020] = e798b406, %l3 = 707aef67b39b2416
	lduh	[%i1+0x020],%l3		! %l3 = 000000000000e798
!	Mem[0000000014800100] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000014800110] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000014800120] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000014800130] = b88546b0 ae796565 7c987a4e d36a38e5
	mov	0x100,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 0000000014800100

p1_label_146:
	fbg,a,pt %fcc2,p1_branch_failed	! Branch Not Taken, %fcc2 = 0
!	Mem[0000000015000000] = 18ebe0c6, %l1 = de1e879c8130392d
	lduba	[%i2+%g0]0x80,%l1	! Annulled
p1_b54:
!	%f16 = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	%f20 = 1c062400 822c7d4d 3c488ec8 451a51ad
!	%f24 = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	%f28 = b88546b0 ae796565 7c987a4e d36a38e5
	mov	0x080,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000015000080
!	%l4 = 0000000000003f88, %l4 = 0000000000003f88, %l1 = de1e879c8130392d
	orn	%l4,%l4,%l1		! %l1 = ffffffffffffffff
!	Mem[00000000158000c8] = 535867d3ae2f9f9a, %l4 = 0000000000003f88
	ldxa	[%i3+0x0c8]%asi,%l4	! %l4 = 535867d3ae2f9f9a

p1_label_147:
!	%l6 = 000000004677966b, %l1 = ffffffffffffffff, %l5 = 00000000fe63449e
	sll	%l6,%l1,%l5		! %l5 = 233bcb3580000000
	membar	#Sync			! Added by membar checker (90)
	set	p1_b55,%o7
	fble,pt	%fcc3,p1_near_2_le	! Branch Taken, %fcc3 = 0
!	Mem[0000000070000008] = 8130392d, %l3 = 000000000000e798
	lduh	[%o0+0x008],%l3		! %l3 = 0000000000008130
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p1_branch_failed
	mov	0x037,%g2
p1_b55:
!	Registers modified during the branch to p1_near_2
!	%l1  = 0000000037c024f2
!	%l2  = fffffffffffff50d
!	%l3  = 80a546d2e1bfb531
!	%l5  = 8130392d6a3389dd
!	%l2 = fffffffffffff50d, Mem[000000007200006c] = 0b063a9b
	stw	%l2,[%o4+0x06c]		! Mem[000000007200006c] = fffff50d
!	Mem[0000000015800008] = ff9550c5, %l7 = ffffffffb2d88fc6
	ldsba	[%i3+%o6]0x80,%l7	! %l7 = ffffffffffffffff

p1_label_148:
!	Mem[0000000070800048] = 000000004677966b, %l1 = 0000000037c024f2
	ldx	[%o1+0x048],%l1		! %l1 = 000000004677966b
!	Mem[0000000015800000] = 2d393081 9c871ede ff9550c5 eb783431
!	Mem[0000000015800010] = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	Mem[0000000015800020] = 2264e959 22c92a24 d2bc5472 11c88d1f
!	Mem[0000000015800030] = 52cb1c10 2d393001 e3a56274 7cbc73e4
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000015800000
!	Mem[0000000071800008] = 0000001f, %l2 = fffffffffffff50d
	ldub	[%o3+0x00b],%l2		! %l2 = 000000000000001f
	bvs	p1_not_taken_0		! Branch Not Taken, %ccr = 19
!	Mem[0000000014800008] = ffffe4d8, %l3 = 80a546d2e1bfb531
	ldsba	[%i1+%o6]0x80,%l3	! %l3 = ffffffffffffffff
p1_b56:

p1_label_149:
	nop
!	Mem[0000000014000100] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014000110] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014000120] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014000130] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x100,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000014000100
!	%f26 = 1f8dc811 7254bcd2, %f28 = 0130392d 101ccb52
	fmovd	%f26,%f28		! %f28 = 1f8dc811 7254bcd2
!	Mem[0000000015800008] = ff9550c5, %l2 = 000000000000001f
	ldsba	[%i3+%o6]0x80,%l2	! %l2 = ffffffffffffffff
!	%f16 = de1e879c 8130392d 313478eb c55095ff
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 1f8dc811 7254bcd2 e473bc7c 7462a5e3
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000

p1_label_150:
!	%f0  = 2d393081, %f1  = 9c871ede
	fcmps	%fcc1,%f0 ,%f1 		! %fcc1 = 2
!	%f0  = 2d393081 9c871ede ce9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 cc9ceb84 e3a56274 7cbc73e4
	mov	0x0c0,%g5
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000140000c0
!	Mem[0000000014800140] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014800150] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014800160] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014800170] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x140,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014800140
!	Mem[0000000015000008] = 883fcc55, %l5 = 8130392d6a3389dd
	ldsha	[%i2+%o6]0x80,%l5	! %l5 = ffffffffffff883f
!	Mem[00000000148001c0] = 1be2a552c6e0eb18, %l4 = 535867d3ae2f9f9a
	ldxa	[%i1+0x1c0]%asi,%l4	! %l4 = 1be2a552c6e0eb18

p1_label_151:
!	%f16 = de1e879c 8130392d 313478eb c55095ff
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 1f8dc811 7254bcd2 e473bc7c 7462a5e3
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000015000100
!	%f1  = 8130392d, %f1  = 8130392d
	fcmpes	%fcc3,%f1 ,%f1 		! %fcc3 = 0
!	Mem[0000000014000180] = afb28154 65c01aa5 80a546d2 e1bfb531
!	Mem[0000000014000190] = 67264812 6c743d02 7664f91c 42af8257
!	Mem[00000000140001a0] = 83ac4063 31d6310c 78a32a32 9d0bd8e4
!	Mem[00000000140001b0] = 1e7410eb 285586d5 7bdb9203 e0c68455
	mov	0x180,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000014000180
!	%f0  = afb28154 65c01aa5 80a546d2 e1bfb531
!	%f4  = 67264812 6c743d02 7664f91c 42af8257
!	%f8  = 83ac4063 31d6310c 78a32a32 9d0bd8e4
!	%f12 = 1e7410eb 285586d5 7bdb9203 e0c68455
	mov	0x040,%g6
	stda	%f0,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000015000024] = f36fe057, %l1 = 000000004677966b
	lduw	[%i2+0x024],%l1		! %l1 = 00000000f36fe057

p1_label_152:
!	Jump to jmpl_2, CWP = 0
	membar	#Sync			! Added by membar checker (91)
	set	p1_jmpl_2_he,%g1
	jmpl	%g1,%g6
!	Mem[0000000014800018] = 6798b4067c91fab2, %l1 = 00000000f36fe057
	ldx	[%i1+0x018],%l1		! %l1 = 6798b4067c91fab2
!	Registers modified during the branch to p1_jmpl_2
!	%l0  = 0000000000000003
!	%l4  = afb2815465c01aa5
!	%l7  = 0000000000000000
!	Mem[0000000015000000] = 18ebe0c6, %l4 = afb2815465c01aa5
	lduba	[%i2+%g0]0x80,%l4	! %l4 = 0000000000000018
!	Mem[0000000014800008] = ffffe4d8, %l4 = 0000000000000018
	lduha	[%i1+%o6]0x80,%l4	! %l4 = 000000000000ffff
!	Mem[0000000016800008] = ea7705f6, %l1 = 6798b4067c91fab2
	ldswa	[%i5+%o6]0x80,%l1	! %l1 = ffffffffea7705f6

p1_label_153:
!	Mem[00000000150000a8] = 1e8a235fe5e5fcc0, %l5 = ffffffffffff883f
	ldx	[%i2+0x0a8],%l5		! %l5 = 1e8a235fe5e5fcc0
!	Mem[0000000014800100] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000014800110] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000014800120] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000014800130] = b88546b0 ae796565 7c987a4e d36a38e5
	mov	0x100,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000014800100
	fbug	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000070000048] = 37c024f2a5b95976, %l4 = 000000000000ffff
	ldx	[%o0+0x048],%l4		! %l4 = 37c024f2a5b95976
p1_b57:
!	%f23 = 83a114d9, %f23 = 83a114d9, %f16 = de1e879c
	fsubs	%f23,%f23,%f16		! %f16 = 00000000

p1_label_154:
!	%l4 = 37c024f2a5b95976, %l3 = ffffffffffffffff, %y  = 00000000
	udivcc	%l4,%l3,%l2		! %l2 = 0000000000000000, %ccr = 44
	mov	%l0,%y			! %y = 00000003
!	Mem[00000000150000d8] = c1a9203f52000000, %l0 = 0000000000000003
	ldx	[%i2+0x0d8],%l0		! %l0 = c1a9203f52000000
	be,a	p1_b58			! Branch Taken, %ccr = 44, CWP = 0
!	Mem[000000007100004c] = 37c024f2, %l0 = c1a9203f52000000
	ldsb	[%o2+0x04e],%l0		! %l0 = 0000000000000024
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p1_branch_failed
	mov	0x03a,%g2
p1_b58:
!	Mem[0000000014000000] = 4e5a9fb590b9a115, %l6 = 000000004677966b
	ldxa	[%i0+%g0]0x80,%l6	! %l6 = 4e5a9fb590b9a115

p1_label_155:
!	Mem[00000000150001c0] = 1af398de e293d127 f07de185 97068b09
!	Mem[00000000150001d0] = 49d315d9 92028b78 0debd125 23eb308c
!	Mem[00000000150001e0] = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	Mem[00000000150001f0] = c37c5407 0d319a2e 952d15d3 024fafd1
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000150001c0
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000015800180
!	Mem[0000000015000058] = 635f1c94b22f98e0, %l5 = 1e8a235fe5e5fcc0
	ldx	[%i2+0x058],%l5		! %l5 = 635f1c94b22f98e0
!	Mem[000000007100000c] = 06a0d46f, %l1 = ffffffffea7705f6
	lduw	[%o2+0x00c],%l1		! %l1 = 0000000006a0d46f
!	Mem[0000000070800008] = d073ffb5 e7fbca1a, %l0 = 00000024, %l1 = 06a0d46f
	ldda	[%o1+0x008]%asi,%l0	! %l0 = 00000000d073ffb5 00000000e7fbca1a

p1_label_156:
!	Mem[00000000158000a8] = 78a32a329d0bd8e4, %l2 = 0000000000000000
	ldx	[%i3+0x0a8],%l2		! %l2 = 78a32a329d0bd8e4
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 0000000014000000
!	Mem[000000007100004c] = 37c024f2, %l3 = ffffffffffffffff
	lduwa	[%o2+0x04c]%asi,%l3	! %l3 = 0000000037c024f2
!	%f16 = 27d193e2 de98f31a, %f16 = 27d193e2 de98f31a
	fnegd	%f16,%f16		! %f16 = a7d193e2 de98f31a
	membar	#Sync			! Added by membar checker (92)
!	Mem[0000000014000000] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000014000010] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000014000020] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000014000030] = b88546b0 ae796565 7c987a4e d36a38e5
	ldda	[%i0]ASI_BLK_P,%f16	! Block Load from 0000000014000000

p1_label_157:
!	Mem[0000000072000040] = afb28154 65c01aa5 80a546d2 e1bfb531
!	Mem[0000000072000050] = 67264812 6c743d02 7664f91c 42af8257
!	Mem[0000000072000060] = 83ac4063 31d6310c 78a32a32 9d0bd8e4
!	Mem[0000000072000070] = 1e7410eb 285586d5 7bdb9203 e0c68455
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%f15 = 4e7a987c, %f4  = 4d7d2c82
	fcmps	%fcc3,%f15,%f4 		! %fcc3 = 2
!	Mem[0000000070800048] = 000000004677966b, %l5 = 635f1c94b22f98e0
	ldxa	[%o1+0x048]%asi,%l5	! %l5 = 000000004677966b
!	Mem[000000007000004c] = a5b95976, %l3 = 0000000037c024f2
	ldub	[%o0+0x04f],%l3		! %l3 = 0000000000000076
!	Mem[0000000015000100] = 2d393081 9c871ede ff9550c5 eb783431
!	Mem[0000000015000110] = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	Mem[0000000015000120] = 2264e959 22c92a24 d2bc5472 11c88d1f
!	Mem[0000000015000130] = d2bc5472 11c88d1f e3a56274 7cbc73e4
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000015000100

p1_label_158:
!	Mem[0000000015000000] = 18ebe0c652a5e21b, %l7 = 0000000000000000
	ldxa	[%i2+%g0]0x80,%l7	! %l7 = 18ebe0c652a5e21b
!	Mem[0000000014000040] = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	Mem[0000000014000050] = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	Mem[0000000014000060] = 57e06ff3 640f343c 32c4d014 03f917fa
!	Mem[0000000014000070] = d06e74db f6cab0dc 78a73f75 a10adb52
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 0000000014000040
!	%f8  = 0471df4b, %f8  = 0471df4b, %f9  = 75a72475
	fdivs	%f8 ,%f8 ,%f9 		! %f9  = 3f800000
!	Mem[0000000014000040] = 1be2a552 c6e0eb18 166cbd32 55cc3f88
!	Mem[0000000014000050] = 78a73f75 a10adb52 0b87bcfa c73b6d59
!	Mem[0000000014000060] = 57e06ff3 640f343c 32c4d014 03f917fa
!	Mem[0000000014000070] = d06e74db f6cab0dc 78a73f75 a10adb52
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000014000040
!	%f16 = 18ebe0c6 52a5e21b 883fcc55 32bd6c16
!	%f20 = 52db0aa1 753fa778 596d3bc7 fabc870b
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000180

p1_label_159:
!	Mem[0000000015000000] = 18ebe0c6, %l6 = 4e5a9fb590b9a115
	ldsha	[%i2+%g0]0x80,%l6	! %l6 = 00000000000018eb
!	Mem[000000007080004c] = 4677966b, %l6 = 00000000000018eb
	ldsba	[%o1+0x04f]%asi,%l6	! %l6 = 000000000000006b
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 3f800000 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[00000000150000c0] = 44fc7f59 819bf240 883fcc55 32bd6c16
!	Mem[00000000150000d0] = c4fc7f59 819bf240 c1a9203f 52000000
!	Mem[00000000150000e0] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[00000000150000f0] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x0c0,%g4
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 00000000150000c0
!	Mem[0000000015000088] = 8fbdda08 c8512743, %l0 = d073ffb5, %l1 = e7fbca1a
	ldd	[%i2+0x088],%l0		! %l0 = 000000008fbdda08 00000000c8512743

p1_label_160:
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x140,%g4
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000015800140
!	%l3 = 0000000000000076, %l5 = 000000004677966b, %l7 = 18ebe0c652a5e21b
	subc	%l3,%l5,%l7		! %l7 = ffffffffb9886a0b
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x0c0,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 00000000140000c0
!	Mem[0000000014800000] = 00000000, %l1 = 00000000c8512743
	ldsha	[%i1+%g0]0x80,%l1	! %l1 = 0000000000000000
!	Mem[0000000014000000] = 15a1b990, %l7 = ffffffffb9886a0b
	swapa	[%i0+%g0]0x80,%l7	! %l7 = 0000000015a1b990

p1_label_161:
!	Mem[00000000140001c0] = a9569bee, %l7 = 0000000015a1b990
	ldsh	[%i0+0x1c0],%l7		! %l7 = ffffffffffffa956
!	%l1 = 0000000000000000, Mem[000000007180000c] = b59f5a4e
	stha	%l1,[%o3+0x00c]%asi	! Mem[000000007180000c] = 00005a4e
!	Mem[0000000014000000] = b9886a0b, %l0 = 000000008fbdda08
	ldsba	[%i0+%g0]0x80,%l0	! %l0 = ffffffffffffffb9
!	Mem[0000000014000090] = 29b11bebe58af091, %l3 = 0000000000000076
	ldx	[%i0+0x090],%l3		! %l3 = 29b11bebe58af091
!	Mem[00000000158000b0] = 1e7410eb, %l6 = 000000000000006b
	ldsw	[%i3+0x0b0],%l6		! %l6 = 000000001e7410eb

p1_label_162:
!	Mem[0000000017000000] = a9569bee 6340ac83, %l0 = ffffffb9, %l1 = 00000000
	ldda	[%i6+%g0]0x80,%l0	! %l0 = 00000000a9569bee 000000006340ac83
	membar	#Sync			! Added by membar checker (93)
!	Mem[0000000072000018] = 3c488ec8, %l5 = 000000004677966b
	ldub	[%o4+0x018],%g2		! %g2 = 000000000000003c
!	Mem[0000000071800008] = 0000001f, %l4 = 37c024f2a5b95976
	lduh	[%o3+0x008],%l4		! %l4 = 0000000000000000
!	%f0  = 4e5a9fb5 90b9a115 432751c8 08dabd8f
!	%f4  = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f8  = 0471df4b 3f800000 c0fce5e5 5f238a1e
!	%f12 = 656579ae b04685b8 e5386ad3 4e7a987c
	mov	0x140,%g4
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 0000000015000140
!	Mem[0000000014800008] = ffffe4d8, %l3 = 29b11bebe58af091
	swapa	[%i1+%o6]0x80,%l3	! %l3 = 00000000ffffe4d8

p1_label_163:
!	Mem[0000000072000000] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000072000010] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000072000020] = 0000803f 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000072000030] = b88546b0 ae796565 7c987a4e d36a38e5
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	Mem[0000000015000008] = 883fcc55, %l7 = ffffffffffffa956
	lduha	[%i2+%o6]0x80,%l7	! %l7 = 000000000000883f
!	Mem[0000000014800008] = e58af091 00000000, %l6 = 1e7410eb, %l7 = 0000883f
	ldda	[%i1+%o6]0x80,%l6	! %l6 = 00000000e58af091 0000000000000000
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x040,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000014800040
!	Mem[0000000071000008] = 00003f88, %l2 = 78a32a329d0bd8e4
	lduh	[%o2+0x008],%l2		! %l2 = 0000000000000000

p1_label_164:
	membar	#Sync			! Added by membar checker (94)
!	Mem[0000000015000140] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000015000150] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000015000160] = 0000803f 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000015000170] = b88546b0 ae796565 7c987a4e d36a38e5
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000015000140
!	Mem[0000000015800168] = fa17f903 14d0c432, %l0 = a9569bee, %l1 = 6340ac83
	ldda	[%i3+0x168]%asi,%l0	! %l0 = 00000000fa17f903 0000000014d0c432
!	Mem[0000000014000008] = 8fbdda08, %l4 = 0000000000000000
	lduba	[%i0+%o6]0x80,%l4	! %l4 = 000000000000008f
!	Mem[0000000014800000] = 00000000 2264e959 e58af091 00000000
!	Mem[0000000014800010] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[0000000014800020] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[0000000014800030] = 00776c10 3869e371 1c35ae27 fe63449e
	ldda	[%i1]ASI_BLK_P,%f0	! Block Load from 0000000014800000
!	%f0  = 00000000 2264e959 e58af091 00000000
!	%f4  = d2ab9d9e 717c8390 6798b406 7c91fab2
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 00776c10 3869e371 1c35ae27 fe63449e
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000014000040

p1_label_165:
!	%l6 = e58af091, %l7 = 00000000, Mem[0000000016800008] = ea7705f6 976188b0
	stda	%l6,[%i5+%o6]0x80	! Mem[0000000016800008] = e58af091 00000000
!	Mem[0000000014000000] = b9886a0bb59f5a4e, %l2 = 0000000000000000
	ldxa	[%i0+%g0]0x80,%l2	! %l2 = b9886a0bb59f5a4e
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x080,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000015000080
	membar	#Sync
	fbug,a	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000015800008] = ff9550c5, %l0 = 00000000fa17f903
	ldswa	[%i3+%o6]0x80,%l0	! Annulled
p1_b59:

p1_label_166:
!	Mem[0000000070800008] = d073ffb5e7fbca1a, %l2 = b9886a0bb59f5a4e
	ldxa	[%o1+0x008]%asi,%l2	! %l2 = d073ffb5e7fbca1a
!	Mem[0000000071800008] = 0000001f00005a4e, %l4 = 000000000000008f
	ldx	[%o3+0x008],%l4		! %l4 = 0000001f00005a4e
!	Mem[0000000014000008] = 8fbdda08, %l5 = 000000004677966b
	lduha	[%i0+%o6]0x80,%l5	! %l5 = 0000000000008fbd
	set	p1_b60,%o7
	fbge,a	p1_far_2_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000015000000] = 18ebe0c6, %l2 = d073ffb5e7fbca1a
	ldsha	[%i2+%g0]0x80,%l2	! %l2 = 00000000000018eb
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p1_branch_failed
	mov	0x03c,%g2
p1_b60:
!	Registers modified during the branch to p1_far_2
!	%l0  = 000000000a242719
!	%l3  = 0000000000000089
!	%l4  = 0000000029b11beb
!	%l5  = 00000000e58af091
!	%l6  = 00003f8806a0d46f

p1_label_167:
!	Mem[0000000015800000] = 2d393081, %l4 = 0000000029b11beb
	lduba	[%i3+%g0]0x80,%l4	! %l4 = 000000000000002d
!	%l4 = 000000000000002d, immed = 0000041e, %l6 = 00003f8806a0d46f
	addcc	%l4,0x41e,%l6		! %l6 = 000000000000044b, %ccr = 00
!	Mem[0000000015800008] = ff9550c5, %l3 = 0000000000000089
	lduha	[%i3+%o6]0x80,%l3	! %l3 = 000000000000ff95
!	Mem[0000000014000000] = b9886a0b, %l6 = 000000000000044b
	lduba	[%i0+%g0]0x80,%l6	! %l6 = 00000000000000b9
!	%f0  = 00000000, %f9  = 7c91fab2
	fitos	%f0 ,%f9 		! %f9  = 00000000

p1_label_168:
!	Mem[0000000014800118] = 3c488ec8, %l6 = 00000000000000b9
	ldsw	[%i1+0x118],%l6		! %l6 = 000000003c488ec8
!	Mem[0000000015800040] = 83ac4063 ee9b56a9 aa971ba0 8d0a32b0
!	Mem[0000000015800050] = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	Mem[0000000015800060] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[0000000015800070] = 71e36938 106cc029 9e4463fe 27ae351c
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000015800040
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c4fc7f59 819bf240 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000180
!	Mem[0000000014800078] = 78a73f75, %l3 = 000000000000ff95
	ldswa	[%i1+0x078]%asi,%l3	! %l3 = 0000000078a73f75
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040

p1_label_169:
!	Mem[000000007000004f] = a5b95976, %l0 = 000000000a242719
	ldstub	[%o0+0x04f],%l0		! %l0 = 0000000000000076
!	Mem[0000000015000000] = 18ebe0c6, %l5 = 00000000e58af091
	ldsba	[%i2+%g0]0x80,%l5	! %l5 = 0000000000000018
!	Mem[000000007080000c] = e7fbca1a, %l2 = 00000000000018eb
	ldsw	[%o1+0x00c],%l2		! %l2 = ffffffffe7fbca1a
!	Mem[0000000015000000] = 18ebe0c6 52a5e21b, %l0 = 00000076, %l1 = 14d0c432
	ldda	[%i2+%g0]0x80,%l0	! %l0 = 0000000018ebe0c6 0000000052a5e21b
!	Mem[0000000014800100] = 15a1b990 b59f5a4e 8fbdda08 c8512743
!	Mem[0000000014800110] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000014800120] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000014800130] = b88546b0 ae796565 7c987a4e d36a38e5
	mov	0x100,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000014800100

p1_label_170:
!	Mem[0000000015000140] = 15a1b990, %l6 = 000000003c488ec8
	ldsb	[%i2+0x141],%l6		! %l6 = ffffffffffffffa1
!	Mem[0000000016000008] = 3c8e153b, %l4 = 000000000000002d
	lduwa	[%i4+%o6]0x80,%l4	! %l4 = 000000003c8e153b
!	Mem[0000000015000000] = 18ebe0c6, %l5 = 0000000000000018
	lduba	[%i2+%g0]0x80,%l5	! %l5 = 0000000000000018
!	Mem[0000000014800028] = 47e10075, %l7 = 0000000000000000
	ldsha	[%i1+0x02a]%asi,%l7	! %l7 = 0000000000000075
!	Mem[0000000017000024] = 7c91fab2, %l7 = 0000000000000075
	lduha	[%i6+0x026]%asi,%l7	! %l7 = 000000000000fab2

p1_label_171:
!	Mem[0000000016800000] = d42443ea4bcf8cd1, %l1 = 0000000052a5e21b
	ldxa	[%i5+%g0]0x80,%l1	! %l1 = d42443ea4bcf8cd1
!	Mem[0000000014800148] = 313478eb c55095ce, %l6 = ffffffa1, %l7 = 0000fab2
	ldda	[%i1+0x148]%asi,%l6	! %l6 = 00000000313478eb 00000000c55095ce
!	Mem[0000000016800000] = d42443ea4bcf8cd1, %l5 = 0000000000000018
	ldxa	[%i5+%g0]0x80,%l5	! %l5 = d42443ea4bcf8cd1
	membar	#Sync			! Added by membar checker (95)
	set	p1_b61,%o7
	fbue,pn	%fcc0,p1_near_1_he	! Branch Taken, %fcc0 = 0
!	%f22 = c1a9203f 52000000, %f20 = c4fc7f59 819bf240
	fmovd	%f22,%f20		! %f20 = c1a9203f 52000000
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p1_branch_failed
	mov	0x03d,%g2
p1_b61:
!	Registers modified during the branch to p1_near_1
!	%l5  = 0000001f00005a4e

p1_label_172:
!	%f16 = 44fc7f59 819bf240 883fcc55 32bd6c16
!	%f20 = c1a9203f 52000000 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x0c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000140000c0
	bg	p1_b62			! Branch Taken, %ccr = 00, CWP = 0
!	%l5 = 0000001f00005a4e, immed = 00000020, %l3 = 0000000078a73f75
	srlx	%l5,0x020,%l3		! %l3 = 000000000000001f
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p1_branch_failed
	mov	0x03e,%g2
p1_b62:
!	Mem[00000000150001f0] = c37c54070d319a2e, %l0 = 0000000018ebe0c6
	ldx	[%i2+0x1f0],%l0		! %l0 = c37c54070d319a2e
	membar	#Sync			! Added by membar checker (96)
	set	p1_b63,%o7
	fbue	p1_far_1_le		! Branch Taken, %fcc0 = 0

p1_label_173:
!	Mem[0000000015000030] = dcb0caf6db746ed0, %l4 = 000000003c8e153b
	ldx	[%i2+0x030],%l4		! %l4 = dcb0caf6db746ed0
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p1_branch_failed
	mov	0x03f,%g2
p1_b63:
!	Registers modified during the branch to p1_far_1
!	%l0  = a9569bee6340ac83
!	%l4  = e473bc7c7462a5e3
!	Mem[0000000015800008] = ff9550c5, %l0 = a9569bee6340ac83
	ldsba	[%i3+%o6]0x80,%l0	! %l0 = ffffffffffffffff
!	Mem[00000000158000c0] = c1d5b8cf 505b1665 535867d3 ae2f9f9a
!	Mem[00000000158000d0] = 8ea18eaf 9412d179 d51f794d 8457edcd
!	Mem[00000000158000e0] = 152ecec7 4baed4ef 2be8d2c2 22f096c2
!	Mem[00000000158000f0] = 41d416c5 99400000 9971c7fa 65297c15
	ldda	[%i3+%g5]ASI_BLK_P,%f0	! Block Load from 00000000158000c0
!	Mem[0000000015800100] = de1e879c 8130392d 313478eb c55095ff
!	Mem[0000000015800110] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000015800120] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000015800130] = 0130392d 101ccb52 e473bc7c 7462a5e3
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000015800100
!	Mem[0000000014800000] = 00000000, %l6 = 00000000313478eb
	ldswa	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000000

p1_label_174:
!	Mem[000000001400017c] = 753fa778, %l6 = 0000000000000000
	ldsba	[%i0+0x17d]%asi,%l6	! %l6 = 000000000000003f
!	%f16 = 44fc7f59 819bf240, %f18 = 883fcc55 32bd6c16
	fabsd	%f16,%f18		! %f18 = 44fc7f59 819bf240
!	Mem[0000000072000040] = f89ab9b5 5c1c17ba 39a5b37f 1a3ff42e
!	Mem[0000000072000050] = 59ec7116 757f06b3 fddc5232 aa2a621d
!	Mem[0000000072000060] = 822d6896 7069a7b3 46092659 0b063a9b
!	Mem[0000000072000070] = 867de124 ed32762e 22195cfc 247230f4
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000015000144] = b59f5a4e, %l2 = ffffffffe7fbca1a
	ldsh	[%i2+0x146],%l2		! %l2 = 0000000000005a4e
	membar	#Sync			! Added by membar checker (97)
	set	p1_b64,%o7
	fbge,a,pt %fcc0,p1_near_0_he	! Branch Taken, %fcc0 = 0

p1_label_175:
!	Mem[0000000015000008] = 883fcc55, %l1 = d42443ea4bcf8cd1
	ldswa	[%i2+%o6]0x80,%l1	! %l1 = ffffffff883fcc55
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p1_branch_failed
	mov	0x040,%g2
p1_b64:
!	Registers modified during the branch to p1_near_0
!	%l0  = e798b4067c91fab2
!	%l1  = 37c024f2a5b959ff
!	%l5  = 0000000000004bdf
!	%f0  = 2d393081 9c871ede ff9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 2d393001 e3a56274 7cbc73e4
	stda	%f0,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
!	%f16 = 44fc7f59 819bf240 44fc7f59 819bf240
!	%f20 = c1a9203f 52000000 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000015800180
!	%f16 = 44fc7f59 819bf240 44fc7f59 819bf240
!	%f20 = c1a9203f 52000000 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x0c0,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 00000000140000c0
!	%f16 = 44fc7f59 819bf240 44fc7f59 819bf240
!	%f20 = c1a9203f 52000000 c1a9203f 52000000
!	%f24 = 3c340f64 f36fe057 fa17f903 14d0c432
!	%f28 = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x1c0,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 00000000140001c0

p1_label_176:
!	Mem[0000000014000064] = 06b498e7, %l0 = e798b4067c91fab2
	lduwa	[%i0+0x064]%asi,%l0	! %l0 = 0000000006b498e7
!	%f0  = 2d393081 9c871ede ff9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 2d393001 e3a56274 7cbc73e4
	mov	0x080,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000015800080
!	%f0  = 2d393081 9c871ede ff9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 2d393001 e3a56274 7cbc73e4
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000148000c0
!	Mem[0000000015800008] = ff9550c5, %l7 = 00000000c55095ce
	ldsha	[%i3+%o6]0x80,%l7	! %l7 = ffffffffffffff95
!	Mem[0000000070000048] = 37c024f2a5b959ff, %l5 = 0000000000004bdf
	ldx	[%o0+0x048],%l5		! %l5 = 37c024f2a5b959ff

p1_label_177:
	membar	#Sync			! Added by membar checker (98)
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	mov	0x040,%g4
	stda	%f32,[%o4+%g4]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[000000007080000c] = e7fbca1a, %l7 = ffffffffffffff95
	ldsh	[%o1+0x00e],%l7		! %l7 = ffffffffffffca1a
!	Mem[0000000071000008] = 00003f88, %l5 = 37c024f2a5b959ff
	ldsw	[%o2+0x008],%l5		! %l5 = 0000000000003f88
!	Mem[0000000015800000] = 2d393081 9c871ede, %l2 = 00005a4e, %l3 = 0000001f
	ldda	[%i3+%g0]0x80,%l2	! %l2 = 000000002d393081 000000009c871ede
!	%l0 = 0000000006b498e7, %l3 = 000000009c871ede, %y  = 00000003
	umulcc	%l0,%l3,%l5		! %l5 = 041997386058aa52, %ccr = 00

p1_label_178:
!	%f0  = 2d393081 9c871ede ff9550c5 eb783431
!	%f4  = 91f08ae5 eb1bb129 d914a183 6ded8f66
!	%f8  = 2264e959 22c92a24 d2bc5472 11c88d1f
!	%f12 = 52cb1c10 2d393001 e3a56274 7cbc73e4
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000148001c0
	membar	#Sync			! Added by membar checker (99)
!	Mem[0000000072000040] = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	Mem[0000000072000050] = b3067f75 1671ec59 1d622aaa 3252dcfd
!	Mem[0000000072000060] = b3a76970 96682d82 9b3a060b 59260946
!	Mem[0000000072000070] = 2e7632ed 24e17d86 f4307224 fc5c1922
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000072000040] = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	Mem[0000000072000050] = b3067f75 1671ec59 1d622aaa 3252dcfd
!	Mem[0000000072000060] = b3a76970 96682d82 9b3a060b 59260946
!	Mem[0000000072000070] = 2e7632ed 24e17d86 f4307224 fc5c1922
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Branch On Register, %l5 = 041997386058aa52
	brlez,a,pt %l5,p1_not_taken_0	! Branch Not Taken
!	%l4 = e473bc7c7462a5e3, %l7 = ffffffffffffca1a, %l4 = e473bc7c7462a5e3
	addc	%l4,%l7,%l4		! Annulled
p1_b65:

p1_label_179:
!	Mem[0000000014800178] = e473bc7c, %l4 = e473bc7c7462a5e3
	ldsha	[%i1+0x17a]%asi,%l4	! %l4 = ffffffffffffbc7c
!	Mem[0000000015000000] = 18ebe0c6, %l1 = 37c024f2a5b959ff
	ldsha	[%i2+%g0]0x80,%l1	! %l1 = 00000000000018eb
!	Mem[0000000014800180] = 83ac4063 ee9b56a9 00000000 00000000
!	Mem[0000000014800190] = 90837c71 9e9dabd2 b2fa917c 06b49867
!	Mem[00000000148001a0] = b2fa917c 06b498e7 e4fc164f 7500e147
!	Mem[00000000148001b0] = 71e36938 106cc029 32fa917c 06b498e7
	mov	0x180,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000014800180
!	Mem[0000000014800008] = e58af09100000000, %l1 = 00000000000018eb
	ldxa	[%i1+%o6]0x80,%l1	! %l1 = e58af09100000000
!	Mem[0000000071800048] = fffff8a7 b2d88fc6, %l2 = 2d393081, %l3 = 9c871ede
	ldd	[%o3+0x048],%l2		! %l2 = 00000000fffff8a7 00000000b2d88fc6

p1_label_180:
!	%f16 = a9569bee 6340ac83 00000000 00000000
!	%f20 = d2ab9d9e 717c8390 6798b406 7c91fab2
!	%f24 = e798b406 7c91fab2 47e10075 4f16fce4
!	%f28 = 29c06c10 3869e371 e798b406 7c91fa32
	mov	0x0c0,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 00000000148000c0
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4+%g4]ASI_BLK_PL	! Block Store to 0000000072000040
	fbu,a,pt %fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000007080004c] = 4677966b, %l5 = 041997386058aa52
	lduh	[%o1+0x04e],%l5		! Annulled
p1_b66:
!	Mem[0000000071800008] = 0000001f, %l3 = 00000000b2d88fc6
	lduh	[%o3+0x00a],%l3		! %l3 = 000000000000001f

p1_label_181:
!	Mem[0000000015800080] = de1e879c 8130392d 313478eb c55095ff
!	Mem[0000000015800090] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[00000000158000a0] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[00000000158000b0] = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x080,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 0000000015800080
!	Mem[000000001480003c] = fe63449e, %l6 = 000000000000003f
	ldsw	[%i1+0x03c],%l6		! %l6 = fffffffffe63449e
!	%l2 = 00000000fffff8a7
	setx	0xfed24dabfed24dab,%g7,%l2 ! %l2 = fed24dabfed24dab
	ble,a	p1_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[0000000015800008] = ff9550c5, %l0 = 0000000006b498e7
	lduha	[%i3+%o6]0x80,%l0	! Annulled
p1_b67:

p1_label_182:
	membar	#Sync			! Added by membar checker (100)
	set	p1_b68,%o7
	fbue	p1_far_1_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000071800008] = 0000001f00005a4e, %l5 = 041997386058aa52
	ldx	[%o3+0x008],%l5		! %l5 = 0000001f00005a4e
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p1_branch_failed
	mov	0x044,%g2
p1_b68:
!	Registers modified during the branch to p1_far_1
!	%l0  = a9569bee6340ac83
!	%l4  = e473bc7c7462a5e3
!	%f16 = de1e879c 8130392d 313478eb c55095ff
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 59e96422 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	stda	%f16,[%o4+%g4]ASI_BLK_P	! Block Store to 0000000072000040
	fbug,a	%fcc0,p1_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000014000008] = 8fbdda08, %l7 = ffffffffffffca1a
	ldsba	[%i0+%o6]0x80,%l7	! Annulled
p1_b69:

p1_label_183:
!	Mem[00000000148001a4] = 06b498e7, %l2 = fed24dabfed24dab
	lduw	[%i1+0x1a4],%l2		! %l2 = 0000000006b498e7
!	%l7 = ffffffffffffca1a, %l6 = fffffffffe63449e, %y  = 04199738
	smulcc	%l7,%l6,%l6		! %l6 = 00000056e59ba40c, %ccr = 08
!	Mem[00000000148000c0] = a9569bee 6340ac83 00000000 00000000
!	Mem[00000000148000d0] = d2ab9d9e 717c8390 6798b406 7c91fab2
!	Mem[00000000148000e0] = e798b406 7c91fab2 47e10075 4f16fce4
!	Mem[00000000148000f0] = 29c06c10 3869e371 e798b406 7c91fa32
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 00000000148000c0
!	%f0  = a9569bee 6340ac83 00000000 00000000
!	%f4  = d2ab9d9e 717c8390 6798b406 7c91fab2
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 29c06c10 3869e371 e798b406 7c91fa32
	stda	%f0,[%i1+%g6]ASI_BLK_P	! Block Store to 00000000148000c0
!	Branch On Register, %l4 = e473bc7c7462a5e3
	brgz,pn	%l4,p1_not_taken_0	! Branch Not Taken

p1_label_184:
!	Mem[0000000015800008] = ff9550c5, %l6 = 00000056e59ba40c
	ldswa	[%i3+%o6]0x80,%l6	! %l6 = ffffffffff9550c5
p1_b70:
!	Mem[00000000140001d0] = c1a9203f52000000, %l1 = e58af09100000000
	ldx	[%i0+0x1d0],%l1		! %l1 = c1a9203f52000000
!	%f0  = a9569bee 6340ac83 00000000 00000000
!	%f4  = d2ab9d9e 717c8390 6798b406 7c91fab2
!	%f8  = e798b406 7c91fab2 47e10075 4f16fce4
!	%f12 = 29c06c10 3869e371 e798b406 7c91fa32
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000150000c0
!	Mem[0000000014000100] = de1e879c 8130392d 313478eb c55095ce
!	Mem[0000000014000110] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000014000120] = 242ac922 59e96422 1f8dc811 7254bcd2
!	Mem[0000000014000130] = 84eb9ccc 101ccb52 e473bc7c 7462a5e3
	mov	0x100,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000014000100
!	Mem[0000000014800008] = e58af09100000000, %l1 = c1a9203f52000000
	ldxa	[%i1+%o6]0x80,%l1	! %l1 = e58af09100000000

p1_label_185:
!	Mem[0000000014800094] = 717c8390, %l3 = 000000000000001f
	ldswa	[%i1+0x094]%asi,%l3	! %l3 = 00000000717c8390
!	%f21 = e58af091, %f25 = 59e96422
	fmovs	%f21,%f25		! %f25 = e58af091
!	Mem[00000000150001c0] = 1af398de e293d127 f07de185 97068b09
!	Mem[00000000150001d0] = 49d315d9 92028b78 0debd125 23eb308c
!	Mem[00000000150001e0] = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	Mem[00000000150001f0] = c37c5407 0d319a2e 952d15d3 024fafd1
	mov	0x1c0,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 00000000150001c0
!	%f18 = 313478eb c55095ff, %f18 = 313478eb c55095ff, %f18 = 313478eb c55095ff
	fdivd	%f18,%f18,%f18		! %f18 = 3ff00000 00000000
!	%l0 = a9569bee6340ac83, Mem[000000007200006c] = 7254bcd2
	stwa	%l0,[%o4+0x06c]%asi	! Mem[000000007200006c] = 6340ac83

p1_label_186:
	bl,a	p1_b71			! Branch Taken, %ccr = 08, CWP = 0
!	Mem[0000000014800000] = 00000000, %l6 = ffffffffff9550c5
	ldswa	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000000
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p1_branch_failed
	mov	0x047,%g2
p1_b71:
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[00000000140001dc] = 52000000, %l1 = e58af09100000000
	ldub	[%i0+0x1de],%l1		! %l1 = 0000000000000000
!	Mem[0000000014000188] = 80a546d2 e1bfb531, %l6 = 00000000, %l7 = ffffca1a
	ldd	[%i0+0x188],%l6		! %l6 = 0000000080a546d2 00000000e1bfb531

p1_label_187:
	membar	#Sync			! Added by membar checker (101)
!	%f16 = de1e879c 8130392d 3ff00000 00000000
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 e58af091 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000150000c0
!	%f0  = 27d193e2 de98f31a 098b0697 85e17df0
!	%f4  = 788b0292 d915d349 8c30eb23 25d1eb0d
!	%f8  = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	%f12 = 2e9a310d 07547cc3 d1af4f02 d3152d95
	stda	%f0,[%i1+%g4]ASI_BLK_PL	! Block Store to 00000000148001c0
!	%f17 = 8130392d, %f17 = 8130392d
	fcmps	%fcc0,%f17,%f17		! %fcc0 = 0
!	Mem[0000000014000000] = b9886a0b, %l0 = a9569bee6340ac83
	lduba	[%i0+%g0]0x80,%l0	! %l0 = 00000000000000b9
!	%f16 = de1e879c 8130392d 3ff00000 00000000
!	%f20 = 29b11beb e58af091 668fed6d 83a114d9
!	%f24 = 242ac922 e58af091 1f8dc811 7254bcd2
!	%f28 = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x140,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000140

p1_label_188:
!	Mem[0000000072000074] = 101ccb52, %l7 = 00000000e1bfb531
	lduwa	[%o4+0x074]%asi,%g2	! %g2 = 00000000e1bfb531
	membar	#Sync			! Added by membar checker (102)
!	%f0  = 27d193e2 de98f31a 098b0697 85e17df0
!	%f4  = 788b0292 d915d349 8c30eb23 25d1eb0d
!	%f8  = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	%f12 = 2e9a310d 07547cc3 d1af4f02 d3152d95
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000150000c0
!	Mem[0000000014800108] = 8fbdda08, %l4 = e473bc7c7462a5e3
	ldsw	[%i1+0x108],%l4		! %l4 = ffffffff8fbdda08
!	%f0  = 27d193e2 de98f31a 098b0697 85e17df0
!	%f4  = 788b0292 d915d349 8c30eb23 25d1eb0d
!	%f8  = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	%f12 = 2e9a310d 07547cc3 d1af4f02 d3152d95
	mov	0x080,%g6
	stda	%f0,[%i1+%g6]ASI_BLK_P	! Block Store to 0000000014800080
!	Mem[0000000015000008] = 883fcc55 32bd6c16, %l2 = 06b498e7, %l3 = 717c8390
	ldda	[%i2+%o6]0x80,%l2	! %l2 = 00000000883fcc55 0000000032bd6c16

p1_label_189:
!	Mem[0000000015000040] = a9569bee 6340bc83 b0320a8d a01b97aa
!	Mem[0000000015000050] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[0000000015000060] = e798b406 7c91fab2 47e124f2 4f16fce4
!	Mem[0000000015000070] = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x040,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000015000040
!	%f0  = 27d193e2 de98f31a 098b0697 85e17df0
!	%f4  = 788b0292 d915d349 8c30eb23 25d1eb0d
!	%f8  = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	%f12 = 2e9a310d 07547cc3 d1af4f02 d3152d95
	mov	0x100,%g5
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000015000100
!	Mem[0000000072000010] = 59ec7116757f06b3, %l3 = 0000000032bd6c16
	ldx	[%o4+0x010],%g2		! %g2 = 59ec7116757f06b3
!	%f16 = a9569bee 6340bc83 b0320a8d a01b97aa
!	%f20 = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f24 = e798b406 7c91fab2 47e124f2 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x0c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000140000c0
!	Mem[0000000072000000] = f89ab9b55c1c17ba, %l6 = 0000000080a546d2
	ldxa	[%o4+0x000]%asi,%g2	! %g2 = f89ab9b55c1c17ba

p1_label_190:
!	Mem[000000007080000c] = e7fbca1a, %l1 = 0000000000000000
	ldsba	[%o1+0x00d]%asi,%l1	! %l1 = fffffffffffffffb
!	Mem[00000000140000b4] = 101ccb52, %l4 = ffffffff8fbdda08
	ldsh	[%i0+0x0b6],%l4		! %l4 = ffffffffffffcb52
!	%l5 = 0000001f00005a4e, %l6 = 0000000080a546d2, %y  = 00000056
	umul	%l5,%l6,%l7		! %l7 = 00002d614d4167fc
!	%f0  = 27d193e2 de98f31a 098b0697 85e17df0
!	%f4  = 788b0292 d915d349 8c30eb23 25d1eb0d
!	%f8  = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	%f12 = 2e9a310d 07547cc3 d1af4f02 d3152d95
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
	membar	#Sync			! Added by membar checker (103)
!	Mem[00000000148000a8] = cd7bdbc2e2eda5e3, %l1 = fffffffffffffffb
	ldx	[%i1+0x0a8],%l1		! %l1 = cd7bdbc2e2eda5e3

p1_label_191:
!	%f0  = 27d193e2 de98f31a 098b0697 85e17df0
!	%f4  = 788b0292 d915d349 8c30eb23 25d1eb0d
!	%f8  = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	%f12 = 2e9a310d 07547cc3 d1af4f02 d3152d95
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000015800080
!	%f16 = a9569bee 6340bc83 b0320a8d a01b97aa
!	%f20 = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f24 = e798b406 7c91fab2 47e124f2 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x100,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000015800100
!	Mem[0000000015800048] = aa971ba0, %l3 = 0000000032bd6c16
	ldsha	[%i3+0x04a]%asi,%l3	! %l3 = 0000000000001ba0
!	Mem[0000000015000000] = 18ebe0c6, %l3 = 0000000000001ba0
	ldsha	[%i2+%g0]0x80,%l3	! %l3 = 00000000000018eb
!	%f16 = a9569bee 6340bc83 b0320a8d a01b97aa
!	%f20 = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	%f24 = e798b406 7c91fab2 47e124f2 4f16fce4
!	%f28 = 29c06c10 3869e371 1c35ae27 fe63449e
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 0000000014800000

p1_label_192:
!	Mem[00000000150001e0] = bcec952e, %l2 = 00000000883fcc55
	lduwa	[%i2+0x1e0]%asi,%l2	! %l2 = 00000000bcec952e
!	Mem[0000000072000050] = 29b11beb e58af091, %l6 = 80a546d2, %l7 = 4d4167fc
	ldda	[%o4+0x050]%asi,%g2	! %l6 = 0000000080a546d2 00002d614d4167fc
!	Mem[0000000071800048] = fffff8a7, %l5 = 0000001f00005a4e
	lduwa	[%o3+0x048]%asi,%l5	! %l5 = 00000000fffff8a7
!	Mem[000000007180000c] = 00005a4e, %l5 = 00000000fffff8a7
	ldsw	[%o3+0x00c],%l5		! %l5 = 0000000000005a4e
	membar	#Sync			! Added by membar checker (104)
!	Mem[0000000015800094] = 92028b78, %l2 = 00000000bcec952e
	lduwa	[%i3+0x094]%asi,%l2	! %l2 = 0000000092028b78

p1_label_193:
!	Mem[0000000015000040] = a9569bee 6340bc83 b0320a8d a01b97aa
!	Mem[0000000015000050] = d2ab9d9e 717c8390 635f1c94 b22f98e0
!	Mem[0000000015000060] = e798b406 7c91fab2 47e124f2 4f16fce4
!	Mem[0000000015000070] = 29c06c10 3869e371 1c35ae27 fe63449e
	mov	0x040,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000015000040
!	Mem[0000000071000008] = 00003f8806a0d46f, %l7 = 00002d614d4167fc
	ldx	[%o2+0x008],%l7		! %l7 = 00003f8806a0d46f
!	Mem[0000000015800180] = 44fc7f59 819bf240 44fc7f59 819bf240
!	Mem[0000000015800190] = c1a9203f 52000000 c1a9203f 52000000
!	Mem[00000000158001a0] = 3c340f64 f36fe057 fa17f903 14d0c432
!	Mem[00000000158001b0] = dcb0caf6 db746ed0 52db0aa1 753fa778
	mov	0x180,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 0000000015800180
!	%l6 = 80a546d2, %l7 = 06a0d46f, Mem[0000000014000128] = 1f8dc811 7254bcd2
	std	%l6,[%i0+0x128]	! Mem[0000000014000128] = 80a546d2 06a0d46f
!	Mem[0000000015800008] = ff9550c5eb783431, %l0 = 00000000000000b9
	ldxa	[%i3+%o6]0x80,%l0	! %l0 = ff9550c5eb783431

p1_label_194:
	membar	#Sync			! Added by membar checker (105)
	set	p1_b72,%o7
	fba,a	p1_far_3_le		! Branch Taken, %fcc0 = 0
!	Mem[000000007200001c] = 23eb308c, %l1 = cd7bdbc2e2eda5e3
	lduw	[%o4+0x01c],%g2		! Annulled
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p1_branch_failed
	mov	0x048,%g2
p1_b72:
!	Registers modified during the branch to p1_far_3
!	%l5  = 0000000000000059
!	%f0  = 83bc4063 ee9b56a9 aa971ba0 8d0a32b0
!	%f4  = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	%f8  = b2fa917c 06b498e7 e4fc164f f224e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000148001c0
!	%f0  = 83bc4063 ee9b56a9 aa971ba0 8d0a32b0
!	%f4  = 90837c71 9e9dabd2 e0982fb2 941c5f63
!	%f8  = b2fa917c 06b498e7 e4fc164f f224e147
!	%f12 = 71e36938 106cc029 9e4463fe 27ae351c
	mov	0x140,%g6
	stda	%f0,[%i6+%g6]ASI_BLK_P	! Block Store to 0000000017000140
!	Mem[000000001580013c] = fe63449e, %l2 = 0000000092028b78
	ldub	[%i3+0x13e],%l2		! %l2 = 0000000000000044

p1_label_195:
!	%l4 = ffffffffffffcb52, %l7 = 00003f8806a0d46f, %l0 = ff9550c5eb783431
	xnorcc	%l4,%l7,%l0		! %l0 = 00003f8806a0e0c2, %ccr = 00
!	Mem[0000000070800048] = 000000004677966b, %l7 = 00003f8806a0d46f
	ldx	[%o1+0x048],%l7		! %l7 = 000000004677966b
!	Mem[0000000014800028] = e4fc164f f224e147, %l0 = 06a0e0c2, %l1 = e2eda5e3
	ldda	[%i1+0x028]%asi,%l0	! %l0 = 00000000e4fc164f 00000000f224e147
!	%l5 = 0000000000000059, %l4 = ffffffffffffcb52, %l5 = 0000000000000059
	tsubcc	%l5,%l4,%l5		! %l5 = 0000000000003507, %ccr = 13
!	%l7 = 000000004677966b, immed = fffff3e1, %l0 = 00000000e4fc164f
	andn	%l7,-0xc1f,%l0		! %l0 = 000000000000040a

p1_label_196:
!	Mem[0000000015000000] = 18ebe0c6, %l6 = 0000000080a546d2
	lduha	[%i2+%g0]0x80,%l6	! %l6 = 00000000000018eb
!	Mem[0000000016800168] = d31ff59d12f7b26c, %l1 = 00000000f224e147
	ldx	[%i5+0x168],%l1		! %l1 = d31ff59d12f7b26c
!	%f26 = fa17f903, %f17 = 819bf240
	fnegs	%f26,%f17		! %f17 = 7a17f903
!	Mem[0000000015800000] = 2d393081, %l7 = 000000004677966b
	ldsba	[%i3+%g0]0x80,%l7	! %l7 = 000000000000002d
!	Mem[0000000040a0001c] = 0a242719, %l2 = 0000000000000044
	ldsha	[%o5+0x01e]%asi,%l2	! %l2 = 0000000000002719

p1_label_197:
!	Mem[0000000014000000] = b9886a0b b59f5a4e 8fbdda08 c8512743
!	Mem[0000000014000010] = 1c062400 822c7d4d 3c488ec8 451a51ad
!	Mem[0000000014000020] = 7524a775 4bdf7104 1e8a235f e5e5fcc0
!	Mem[0000000014000030] = b88546b0 ae796565 7c987a4e d36a38e5
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000014000000
!	Mem[00000000150000c0] = 1af398de e293d127 f07de185 97068b09
!	Mem[00000000150000d0] = 49d315d9 92028b78 0debd125 23eb308c
!	Mem[00000000150000e0] = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	Mem[00000000150000f0] = c37c5407 0d319a2e 952d15d3 024fafd1
	mov	0x0c0,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 00000000150000c0
!	%f0  = 1af398de e293d127 f07de185 97068b09
!	%f4  = 49d315d9 92028b78 0debd125 23eb308c
!	%f8  = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	%f12 = c37c5407 0d319a2e 952d15d3 024fafd1
	mov	0x140,%g5
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000014000140
!	Mem[0000000015000008] = 883fcc55, %l0 = 000000000000040a
	lduha	[%i2+%o6]0x80,%l0	! %l0 = 000000000000883f
!	%l0 = 000000000000883f, %l7 = 000000000000002d, %y  = 00002d61
	sdivx	%l0,%l7,%l1		! %l1 = 0000000000000307

p1_label_198:
!	Mem[0000000072000040] = de1e879c 8130392d 313478eb c55095ff
!	Mem[0000000072000050] = 29b11beb e58af091 668fed6d 83a114d9
!	Mem[0000000072000060] = 242ac922 59e96422 1f8dc811 6340ac83
!	Mem[0000000072000070] = 0130392d 101ccb52 e473bc7c 7462a5e3
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f16 = 4e5a9fb5 0b6a88b9 432751c8 08dabd8f
!	%f20 = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f24 = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f28 = 656579ae b04685b8 e5386ad3 4e7a987c
	mov	0x180,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000015000180
!	%f16 = 4e5a9fb5 0b6a88b9 432751c8 08dabd8f
!	%f20 = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f24 = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f28 = 656579ae b04685b8 e5386ad3 4e7a987c
	mov	0x1c0,%g4
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000158001c0
!	%f32 = ba171c5c b5b99af8 2ef43f1a 7fb3a539
!	%f36 = b3067f75 1671ec59 1d622aaa 3252dcfd
!	%f40 = b3a76970 96682d82 9b3a060b 59260946
!	%f44 = 2e7632ed 24e17d86 f4307224 fc5c1922
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l6 = 00000000000018eb, %l3 = 00000000000018eb, %y  = 00002d61
	umul	%l6,%l3,%l0		! %l0 = 00000000026ce7b9

p1_label_199:
	membar	#Sync
!	Branch On Register, %l3 = 00000000000018eb
	brz,a,pn %l3,p1_not_taken_0	! Branch Not Taken
!	%l4 = ffffffffffffcb52, immed = fffff957, %l2 = 0000000000002719
	orcc	%l4,-0x6a9,%l2		! Annulled
p1_b73:
!	%f16 = 4e5a9fb5 0b6a88b9 432751c8 08dabd8f
!	%f20 = 4d7d2c82 0024061c ad511a45 c88e483c
!	%f24 = 0471df4b 75a72475 c0fce5e5 5f238a1e
!	%f28 = 656579ae b04685b8 e5386ad3 4e7a987c
	stda	%f16,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f0  = 1af398de e293d127 f07de185 97068b09
!	%f4  = 49d315d9 92028b78 0debd125 23eb308c
!	%f8  = bcec952e c4a5f4de e3a5ede2 c2db7bcd
!	%f12 = c37c5407 0d319a2e 952d15d3 024fafd1
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[0000000014800138] = 7c987a4ed36a38e5, %l1 = 0000000000000307
	ldx	[%i1+0x138],%l1		! %l1 = 7c987a4ed36a38e5

p1_label_200:
!	Mem[0000000014800080] = 27d193e2 de98f31a 098b0697 85e17df0
!	Mem[0000000014800090] = 788b0292 d915d349 8c30eb23 25d1eb0d
!	Mem[00000000148000a0] = def4a5c4 2e95ecbc cd7bdbc2 e2eda5e3
!	Mem[00000000148000b0] = 2e9a310d 07547cc3 d1af4f02 d3152d95
	mov	0x080,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000014800080
!	Mem[000000007080004c] = 4677966b, %l5 = 0000000000003507
	ldub	[%o1+0x04e],%l5		! %l5 = 0000000000000096
	membar	#Sync			! Added by membar checker (106)
	set	p1_b74,%o7
	fble,a	p1_far_0_he		! Branch Taken, %fcc0 = 0
!	Mem[00000000140000c8] = aa971ba08d0a32b0, %l3 = 00000000000018eb
	ldx	[%i0+0x0c8],%l3		! %l3 = aa971ba08d0a32b0
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p1_branch_failed
	mov	0x04a,%g2
p1_b74:
!	Registers modified during the branch to p1_far_0
!	%l3  = 000000000130392d
!	%l4  = 836785b12c95c7b1
!	%l6  = c1a9203f52000000
!	%f13 = 0d319a2e, %f13 = 0d319a2e, %f26 = c0fce5e5
	fdivs	%f13,%f13,%f26		! %f26 = 3f800000
	nop

1:	membar	#Sync			! Force all stores to complete

!	End of Random Code for Processor 1

	mov	2,%g2
	set	done_flags,%g1
	st	%g2,[%g1+0x004]		! Set processor 1 done flag

!	Check Registers

p1_check_registers:
	set	p1_expected_registers,%g1
	ldx	[%g1+0x000],%g2
	cmp	%l0,%g2			! %l0 should be 00000000026ce7b9
	bne,a,pn %xcc,p1_reg_l0_fail
	mov	%l0,%g3
	ldx	[%g1+0x008],%g2
	cmp	%l1,%g2			! %l1 should be 7c987a4ed36a38e5
	bne,a,pn %xcc,p1_reg_l1_fail
	mov	%l1,%g3
	ldx	[%g1+0x010],%g2
	cmp	%l2,%g2			! %l2 should be 0000000000002719
	bne,a,pn %xcc,p1_reg_l2_fail
	mov	%l2,%g3
	ldx	[%g1+0x018],%g2
	cmp	%l3,%g2			! %l3 should be 000000000130392d
	bne,a,pn %xcc,p1_reg_l3_fail
	mov	%l3,%g3
	ldx	[%g1+0x020],%g2
	cmp	%l4,%g2			! %l4 should be 836785b12c95c7b1
	bne,a,pn %xcc,p1_reg_l4_fail
	mov	%l4,%g3
	ldx	[%g1+0x028],%g2
	cmp	%l5,%g2			! %l5 should be 0000000000000096
	bne,a,pn %xcc,p1_reg_l5_fail
	mov	%l5,%g3
	ldx	[%g1+0x030],%g2
	cmp	%l6,%g2			! %l6 should be c1a9203f52000000
	bne,a,pn %xcc,p1_reg_l6_fail
	mov	%l6,%g3
	ldx	[%g1+0x038],%g2
	cmp	%l7,%g2			! %l7 should be 000000000000002d
	bne,a,pn %xcc,p1_reg_l7_fail
	mov	%l7,%g3

!	Check Floating Point Registers

p1_check_fp_registers:
	set	p1_temp,%g1
	set	p1_expected_fp_regs,%g3
	std	%f0,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x00],%l0
	cmp	%l0,%l1			! %f0  should be 1af398de e293d127
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf00,%g1
	std	%f2,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x08],%l0
	cmp	%l0,%l1			! %f2  should be f07de185 97068b09
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf02,%g1
	std	%f4,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x10],%l0
	cmp	%l0,%l1			! %f4  should be 49d315d9 92028b78
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf04,%g1
	std	%f6,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x18],%l0
	cmp	%l0,%l1			! %f6  should be 0debd125 23eb308c
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf06,%g1
	std	%f8,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x20],%l0
	cmp	%l0,%l1			! %f8  should be bcec952e c4a5f4de
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf08,%g1
	std	%f10,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x28],%l0
	cmp	%l0,%l1			! %f10 should be e3a5ede2 c2db7bcd
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf10,%g1
	std	%f12,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x30],%l0
	cmp	%l0,%l1			! %f12 should be c37c5407 0d319a2e
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf12,%g1
	std	%f14,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x38],%l0
	cmp	%l0,%l1			! %f14 should be 952d15d3 024fafd1
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf14,%g1
	std	%f16,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x40],%l0
	cmp	%l0,%l1			! %f16 should be 4e5a9fb5 0b6a88b9
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf16,%g1
	std	%f18,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x48],%l0
	cmp	%l0,%l1			! %f18 should be 432751c8 08dabd8f
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf18,%g1
	std	%f20,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x50],%l0
	cmp	%l0,%l1			! %f20 should be 4d7d2c82 0024061c
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf20,%g1
	std	%f22,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x58],%l0
	cmp	%l0,%l1			! %f22 should be ad511a45 c88e483c
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf22,%g1
	std	%f24,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x60],%l0
	cmp	%l0,%l1			! %f24 should be 0471df4b 75a72475
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf24,%g1
	std	%f26,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x68],%l0
	cmp	%l0,%l1			! %f26 should be 3f800000 5f238a1e
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf26,%g1
	std	%f28,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x70],%l0
	cmp	%l0,%l1			! %f28 should be 656579ae b04685b8
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf28,%g1
	std	%f30,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x78],%l0
	cmp	%l0,%l1			! %f30 should be e5386ad3 4e7a987c
	bne,a,pn	%xcc,p1_freg_fail
	or	%g0,0xf30,%g1

!	Check Local Memory

	set	p1_local0_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = b9886a0bb59f5a4e
	ldx	[%i0+0x000],%g3		! Observed data at 0000000014000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 8fbdda08c8512743
	ldx	[%i0+0x008],%g3		! Observed data at 0000000014000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 1c062400822c7d4d
	ldx	[%i0+0x010],%g3		! Observed data at 0000000014000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 3c488ec8451a51ad
	ldx	[%i0+0x018],%g3		! Observed data at 0000000014000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 7524a7754bdf7104
	ldx	[%i0+0x020],%g3		! Observed data at 0000000014000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 1e8a235fe5e5fcc0
	ldx	[%i0+0x028],%g3		! Observed data at 0000000014000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = b88546b0ae796565
	ldx	[%i0+0x030],%g3		! Observed data at 0000000014000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 7c987a4ed36a38e5
	ldx	[%i0+0x038],%g3		! Observed data at 0000000014000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 59e9642200000000
	ldx	[%i0+0x040],%g3		! Observed data at 0000000014000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 0000000091f08ae5
	ldx	[%i0+0x048],%g3		! Observed data at 0000000014000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i0+0x050],%g3		! Observed data at 0000000014000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = b2fa917c06b49867
	ldx	[%i0+0x058],%g3		! Observed data at 0000000014000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i0+0x060],%g3		! Observed data at 0000000014000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = e4fc164f7500e147
	ldx	[%i0+0x068],%g3		! Observed data at 0000000014000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 71e36938106c7700
	ldx	[%i0+0x070],%g3		! Observed data at 0000000014000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 9e4463fe27ae351c
	ldx	[%i0+0x078],%g3		! Observed data at 0000000014000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = de1e879c8130392d
	ldx	[%i0+0x080],%g3		! Observed data at 0000000014000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 313478ebc55095ff
	ldx	[%i0+0x088],%g3		! Observed data at 0000000014000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 29b11bebe58af091
	ldx	[%i0+0x090],%g3		! Observed data at 0000000014000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 668fed6d83a114d9
	ldx	[%i0+0x098],%g3		! Observed data at 0000000014000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 242ac92259e96422
	ldx	[%i0+0x0a0],%g3		! Observed data at 00000000140000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 1f8dc8117254bcd2
	ldx	[%i0+0x0a8],%g3		! Observed data at 00000000140000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 0130392d101ccb52
	ldx	[%i0+0x0b0],%g3		! Observed data at 00000000140000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = e473bc7c7462a5e3
	ldx	[%i0+0x0b8],%g3		! Observed data at 00000000140000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 83bc4063ee9b56a9
	ldx	[%i0+0x0c0],%g3		! Observed data at 00000000140000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = aa971ba08d0a32b0
	ldx	[%i0+0x0c8],%g3		! Observed data at 00000000140000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i0+0x0d0],%g3		! Observed data at 00000000140000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = e0982fb2941c5f63
	ldx	[%i0+0x0d8],%g3		! Observed data at 00000000140000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i0+0x0e0],%g3		! Observed data at 00000000140000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = e4fc164ff224e147
	ldx	[%i0+0x0e8],%g3		! Observed data at 00000000140000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 71e36938106cc029
	ldx	[%i0+0x0f0],%g3		! Observed data at 00000000140000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 9e4463fe27ae351c
	ldx	[%i0+0x0f8],%g3		! Observed data at 00000000140000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = de1e879c8130392d
	ldx	[%i0+0x100],%g3		! Observed data at 0000000014000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 313478ebc55095ce
	ldx	[%i0+0x108],%g3		! Observed data at 0000000014000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 29b11bebe58af091
	ldx	[%i0+0x110],%g3		! Observed data at 0000000014000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 668fed6d83a114d9
	ldx	[%i0+0x118],%g3		! Observed data at 0000000014000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 242ac92259e96422
	ldx	[%i0+0x120],%g3		! Observed data at 0000000014000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 80a546d206a0d46f
	ldx	[%i0+0x128],%g3		! Observed data at 0000000014000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = 84eb9ccc101ccb52
	ldx	[%i0+0x130],%g3		! Observed data at 0000000014000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = e473bc7c7462a5e3
	ldx	[%i0+0x138],%g3		! Observed data at 0000000014000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 1af398dee293d127
	ldx	[%i0+0x140],%g3		! Observed data at 0000000014000140
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = f07de18597068b09
	ldx	[%i0+0x148],%g3		! Observed data at 0000000014000148
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 49d315d992028b78
	ldx	[%i0+0x150],%g3		! Observed data at 0000000014000150
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 0debd12523eb308c
	ldx	[%i0+0x158],%g3		! Observed data at 0000000014000158
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = bcec952ec4a5f4de
	ldx	[%i0+0x160],%g3		! Observed data at 0000000014000160
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = e3a5ede2c2db7bcd
	ldx	[%i0+0x168],%g3		! Observed data at 0000000014000168
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = c37c54070d319a2e
	ldx	[%i0+0x170],%g3		! Observed data at 0000000014000170
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 952d15d3024fafd1
	ldx	[%i0+0x178],%g3		! Observed data at 0000000014000178
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = afb2815465c01aa5
	ldx	[%i0+0x180],%g3		! Observed data at 0000000014000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 80a546d2e1bfb531
	ldx	[%i0+0x188],%g3		! Observed data at 0000000014000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 672648126c743d02
	ldx	[%i0+0x190],%g3		! Observed data at 0000000014000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = 7664f91c42af8257
	ldx	[%i0+0x198],%g3		! Observed data at 0000000014000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 83ac406331d6310c
	ldx	[%i0+0x1a0],%g3		! Observed data at 00000000140001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = 78a32a329d0bd8e4
	ldx	[%i0+0x1a8],%g3		! Observed data at 00000000140001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 1e7410eb285586d5
	ldx	[%i0+0x1b0],%g3		! Observed data at 00000000140001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 7bdb9203e0c68455
	ldx	[%i0+0x1b8],%g3		! Observed data at 00000000140001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 44fc7f59819bf240
	ldx	[%i0+0x1c0],%g3		! Observed data at 00000000140001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 44fc7f59819bf240
	ldx	[%i0+0x1c8],%g3		! Observed data at 00000000140001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = c1a9203f52000000
	ldx	[%i0+0x1d0],%g3		! Observed data at 00000000140001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = c1a9203f52000000
	ldx	[%i0+0x1d8],%g3		! Observed data at 00000000140001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = 3c340f64f36fe057
	ldx	[%i0+0x1e0],%g3		! Observed data at 00000000140001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = fa17f90314d0c432
	ldx	[%i0+0x1e8],%g3		! Observed data at 00000000140001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = dcb0caf6db746ed0
	ldx	[%i0+0x1f0],%g3		! Observed data at 00000000140001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 52db0aa1753fa778
	ldx	[%i0+0x1f8],%g3		! Observed data at 00000000140001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f8,%g4

	set	p1_local1_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 83bc4063ee9b56a9
	ldx	[%i1+0x000],%g3		! Observed data at 0000000014800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = aa971ba08d0a32b0
	ldx	[%i1+0x008],%g3		! Observed data at 0000000014800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i1+0x010],%g3		! Observed data at 0000000014800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = e0982fb2941c5f63
	ldx	[%i1+0x018],%g3		! Observed data at 0000000014800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i1+0x020],%g3		! Observed data at 0000000014800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = e4fc164ff224e147
	ldx	[%i1+0x028],%g3		! Observed data at 0000000014800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 71e36938106cc029
	ldx	[%i1+0x030],%g3		! Observed data at 0000000014800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 9e4463fe27ae351c
	ldx	[%i1+0x038],%g3		! Observed data at 0000000014800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 40f29b81597ffc44
	ldx	[%i1+0x040],%g3		! Observed data at 0000000014800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 166cbd3255cc3f88
	ldx	[%i1+0x048],%g3		! Observed data at 0000000014800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 40f29b81597ffcc4
	ldx	[%i1+0x050],%g3		! Observed data at 0000000014800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 000000523f20a9c1
	ldx	[%i1+0x058],%g3		! Observed data at 0000000014800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 57e06ff3640f343c
	ldx	[%i1+0x060],%g3		! Observed data at 0000000014800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 32c4d01403f917fa
	ldx	[%i1+0x068],%g3		! Observed data at 0000000014800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = d06e74dbf6cab0dc
	ldx	[%i1+0x070],%g3		! Observed data at 0000000014800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 78a73f75a10adb52
	ldx	[%i1+0x078],%g3		! Observed data at 0000000014800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 27d193e2de98f31a
	ldx	[%i1+0x080],%g3		! Observed data at 0000000014800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 098b069785e17df0
	ldx	[%i1+0x088],%g3		! Observed data at 0000000014800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 788b0292d915d349
	ldx	[%i1+0x090],%g3		! Observed data at 0000000014800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 8c30eb2325d1eb0d
	ldx	[%i1+0x098],%g3		! Observed data at 0000000014800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = def4a5c42e95ecbc
	ldx	[%i1+0x0a0],%g3		! Observed data at 00000000148000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = cd7bdbc2e2eda5e3
	ldx	[%i1+0x0a8],%g3		! Observed data at 00000000148000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 2e9a310d07547cc3
	ldx	[%i1+0x0b0],%g3		! Observed data at 00000000148000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = d1af4f02d3152d95
	ldx	[%i1+0x0b8],%g3		! Observed data at 00000000148000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = a9569bee6340ac83
	ldx	[%i1+0x0c0],%g3		! Observed data at 00000000148000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 0000000000000000
	ldx	[%i1+0x0c8],%g3		! Observed data at 00000000148000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = d2ab9d9e717c8390
	ldx	[%i1+0x0d0],%g3		! Observed data at 00000000148000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 6798b4067c91fab2
	ldx	[%i1+0x0d8],%g3		! Observed data at 00000000148000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = e798b4067c91fab2
	ldx	[%i1+0x0e0],%g3		! Observed data at 00000000148000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 47e100754f16fce4
	ldx	[%i1+0x0e8],%g3		! Observed data at 00000000148000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 29c06c103869e371
	ldx	[%i1+0x0f0],%g3		! Observed data at 00000000148000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = e798b4067c91fa32
	ldx	[%i1+0x0f8],%g3		! Observed data at 00000000148000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 15a1b990b59f5a4e
	ldx	[%i1+0x100],%g3		! Observed data at 0000000014800100
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 8fbdda08c8512743
	ldx	[%i1+0x108],%g3		! Observed data at 0000000014800108
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 1c062400822c7d4d
	ldx	[%i1+0x110],%g3		! Observed data at 0000000014800110
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 3c488ec8451a51ad
	ldx	[%i1+0x118],%g3		! Observed data at 0000000014800118
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 7524a7754bdf7104
	ldx	[%i1+0x120],%g3		! Observed data at 0000000014800120
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 1e8a235fe5e5fcc0
	ldx	[%i1+0x128],%g3		! Observed data at 0000000014800128
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = b88546b0ae796565
	ldx	[%i1+0x130],%g3		! Observed data at 0000000014800130
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 7c987a4ed36a38e5
	ldx	[%i1+0x138],%g3		! Observed data at 0000000014800138
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = de1e879c8130392d
	ldx	[%i1+0x140],%g3		! Observed data at 0000000014800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 313478ebc55095ce
	ldx	[%i1+0x148],%g3		! Observed data at 0000000014800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 29b11bebe58af091
	ldx	[%i1+0x150],%g3		! Observed data at 0000000014800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 668fed6d83a114d9
	ldx	[%i1+0x158],%g3		! Observed data at 0000000014800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 242ac92259e96422
	ldx	[%i1+0x160],%g3		! Observed data at 0000000014800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 1f8dc8117254bcd2
	ldx	[%i1+0x168],%g3		! Observed data at 0000000014800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 84eb9ccc101ccb52
	ldx	[%i1+0x170],%g3		! Observed data at 0000000014800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = e473bc7c7462a5e3
	ldx	[%i1+0x178],%g3		! Observed data at 0000000014800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 83ac4063ee9b56a9
	ldx	[%i1+0x180],%g3		! Observed data at 0000000014800180
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 0000000000000000
	ldx	[%i1+0x188],%g3		! Observed data at 0000000014800188
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i1+0x190],%g3		! Observed data at 0000000014800190
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = b2fa917c06b49867
	ldx	[%i1+0x198],%g3		! Observed data at 0000000014800198
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i1+0x1a0],%g3		! Observed data at 00000000148001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = e4fc164f7500e147
	ldx	[%i1+0x1a8],%g3		! Observed data at 00000000148001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 71e36938106cc029
	ldx	[%i1+0x1b0],%g3		! Observed data at 00000000148001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 32fa917c06b498e7
	ldx	[%i1+0x1b8],%g3		! Observed data at 00000000148001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 83bc4063ee9b56a9
	ldx	[%i1+0x1c0],%g3		! Observed data at 00000000148001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = aa971ba08d0a32b0
	ldx	[%i1+0x1c8],%g3		! Observed data at 00000000148001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i1+0x1d0],%g3		! Observed data at 00000000148001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = e0982fb2941c5f63
	ldx	[%i1+0x1d8],%g3		! Observed data at 00000000148001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i1+0x1e0],%g3		! Observed data at 00000000148001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = e4fc164ff224e147
	ldx	[%i1+0x1e8],%g3		! Observed data at 00000000148001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 71e36938106cc029
	ldx	[%i1+0x1f0],%g3		! Observed data at 00000000148001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 9e4463fe27ae351c
	ldx	[%i1+0x1f8],%g3		! Observed data at 00000000148001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f8,%g4

	set	p1_local2_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 18ebe0c652a5e21b
	ldx	[%i2+0x000],%g3		! Observed data at 0000000015000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 883fcc5532bd6c16
	ldx	[%i2+0x008],%g3		! Observed data at 0000000015000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 52db0aa1753fa778
	ldx	[%i2+0x010],%g3		! Observed data at 0000000015000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 596d3bc7fabc870b
	ldx	[%i2+0x018],%g3		! Observed data at 0000000015000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 3c340f64f36fe057
	ldx	[%i2+0x020],%g3		! Observed data at 0000000015000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = fa17f90314d0c432
	ldx	[%i2+0x028],%g3		! Observed data at 0000000015000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = dcb0caf6db746ed0
	ldx	[%i2+0x030],%g3		! Observed data at 0000000015000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 52db0aa1753fa778
	ldx	[%i2+0x038],%g3		! Observed data at 0000000015000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = a9569bee6340bc83
	ldx	[%i2+0x040],%g3		! Observed data at 0000000015000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = b0320a8da01b97aa
	ldx	[%i2+0x048],%g3		! Observed data at 0000000015000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = d2ab9d9e717c8390
	ldx	[%i2+0x050],%g3		! Observed data at 0000000015000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 635f1c94b22f98e0
	ldx	[%i2+0x058],%g3		! Observed data at 0000000015000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = e798b4067c91fab2
	ldx	[%i2+0x060],%g3		! Observed data at 0000000015000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 47e124f24f16fce4
	ldx	[%i2+0x068],%g3		! Observed data at 0000000015000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 29c06c103869e371
	ldx	[%i2+0x070],%g3		! Observed data at 0000000015000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 1c35ae27fe63449e
	ldx	[%i2+0x078],%g3		! Observed data at 0000000015000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 44fc7f59819bf240
	ldx	[%i2+0x080],%g3		! Observed data at 0000000015000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 883fcc5532bd6c16
	ldx	[%i2+0x088],%g3		! Observed data at 0000000015000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = c4fc7f59819bf240
	ldx	[%i2+0x090],%g3		! Observed data at 0000000015000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = c1a9203f52000000
	ldx	[%i2+0x098],%g3		! Observed data at 0000000015000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 3c340f64f36fe057
	ldx	[%i2+0x0a0],%g3		! Observed data at 00000000150000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = fa17f90314d0c432
	ldx	[%i2+0x0a8],%g3		! Observed data at 00000000150000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = dcb0caf6db746ed0
	ldx	[%i2+0x0b0],%g3		! Observed data at 00000000150000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 52db0aa1753fa778
	ldx	[%i2+0x0b8],%g3		! Observed data at 00000000150000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 1af398dee293d127
	ldx	[%i2+0x0c0],%g3		! Observed data at 00000000150000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = f07de18597068b09
	ldx	[%i2+0x0c8],%g3		! Observed data at 00000000150000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 49d315d992028b78
	ldx	[%i2+0x0d0],%g3		! Observed data at 00000000150000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 0debd12523eb308c
	ldx	[%i2+0x0d8],%g3		! Observed data at 00000000150000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = bcec952ec4a5f4de
	ldx	[%i2+0x0e0],%g3		! Observed data at 00000000150000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = e3a5ede2c2db7bcd
	ldx	[%i2+0x0e8],%g3		! Observed data at 00000000150000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = c37c54070d319a2e
	ldx	[%i2+0x0f0],%g3		! Observed data at 00000000150000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 952d15d3024fafd1
	ldx	[%i2+0x0f8],%g3		! Observed data at 00000000150000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 1af398dee293d127
	ldx	[%i2+0x100],%g3		! Observed data at 0000000015000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = f07de18597068b09
	ldx	[%i2+0x108],%g3		! Observed data at 0000000015000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 49d315d992028b78
	ldx	[%i2+0x110],%g3		! Observed data at 0000000015000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 0debd12523eb308c
	ldx	[%i2+0x118],%g3		! Observed data at 0000000015000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = bcec952ec4a5f4de
	ldx	[%i2+0x120],%g3		! Observed data at 0000000015000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = e3a5ede2c2db7bcd
	ldx	[%i2+0x128],%g3		! Observed data at 0000000015000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = c37c54070d319a2e
	ldx	[%i2+0x130],%g3		! Observed data at 0000000015000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 952d15d3024fafd1
	ldx	[%i2+0x138],%g3		! Observed data at 0000000015000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 2d3930819c871ede
	ldx	[%i2+0x140],%g3		! Observed data at 0000000015000140
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 000000000000f03f
	ldx	[%i2+0x148],%g3		! Observed data at 0000000015000148
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 91f08ae5eb1bb129
	ldx	[%i2+0x150],%g3		! Observed data at 0000000015000150
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = d914a1836ded8f66
	ldx	[%i2+0x158],%g3		! Observed data at 0000000015000158
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 91f08ae522c92a24
	ldx	[%i2+0x160],%g3		! Observed data at 0000000015000160
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = d2bc547211c88d1f
	ldx	[%i2+0x168],%g3		! Observed data at 0000000015000168
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 52cb1c102d393001
	ldx	[%i2+0x170],%g3		! Observed data at 0000000015000170
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = e3a562747cbc73e4
	ldx	[%i2+0x178],%g3		! Observed data at 0000000015000178
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 4e5a9fb50b6a88b9
	ldx	[%i2+0x180],%g3		! Observed data at 0000000015000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 432751c808dabd8f
	ldx	[%i2+0x188],%g3		! Observed data at 0000000015000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 4d7d2c820024061c
	ldx	[%i2+0x190],%g3		! Observed data at 0000000015000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = ad511a45c88e483c
	ldx	[%i2+0x198],%g3		! Observed data at 0000000015000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 0471df4b75a72475
	ldx	[%i2+0x1a0],%g3		! Observed data at 00000000150001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = c0fce5e55f238a1e
	ldx	[%i2+0x1a8],%g3		! Observed data at 00000000150001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 656579aeb04685b8
	ldx	[%i2+0x1b0],%g3		! Observed data at 00000000150001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = e5386ad34e7a987c
	ldx	[%i2+0x1b8],%g3		! Observed data at 00000000150001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 1af398dee293d127
	ldx	[%i2+0x1c0],%g3		! Observed data at 00000000150001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = f07de18597068b09
	ldx	[%i2+0x1c8],%g3		! Observed data at 00000000150001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 49d315d992028b78
	ldx	[%i2+0x1d0],%g3		! Observed data at 00000000150001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = 0debd12523eb308c
	ldx	[%i2+0x1d8],%g3		! Observed data at 00000000150001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = bcec952ec4a5f4de
	ldx	[%i2+0x1e0],%g3		! Observed data at 00000000150001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = e3a5ede2c2db7bcd
	ldx	[%i2+0x1e8],%g3		! Observed data at 00000000150001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = c37c54070d319a2e
	ldx	[%i2+0x1f0],%g3		! Observed data at 00000000150001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 952d15d3024fafd1
	ldx	[%i2+0x1f8],%g3		! Observed data at 00000000150001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f8,%g4

	set	p1_local3_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 2d3930819c871ede
	ldx	[%i3+0x000],%g3		! Observed data at 0000000015800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = ff9550c5eb783431
	ldx	[%i3+0x008],%g3		! Observed data at 0000000015800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 91f08ae5eb1bb129
	ldx	[%i3+0x010],%g3		! Observed data at 0000000015800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = d914a1836ded8f66
	ldx	[%i3+0x018],%g3		! Observed data at 0000000015800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 2264e95922c92a24
	ldx	[%i3+0x020],%g3		! Observed data at 0000000015800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = d2bc547211c88d1f
	ldx	[%i3+0x028],%g3		! Observed data at 0000000015800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 52cb1c102d393001
	ldx	[%i3+0x030],%g3		! Observed data at 0000000015800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = e3a562747cbc73e4
	ldx	[%i3+0x038],%g3		! Observed data at 0000000015800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 83ac4063ee9b56a9
	ldx	[%i3+0x040],%g3		! Observed data at 0000000015800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = aa971ba08d0a32b0
	ldx	[%i3+0x048],%g3		! Observed data at 0000000015800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i3+0x050],%g3		! Observed data at 0000000015800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = e0982fb2941c5f63
	ldx	[%i3+0x058],%g3		! Observed data at 0000000015800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i3+0x060],%g3		! Observed data at 0000000015800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = e4fc164f7500e147
	ldx	[%i3+0x068],%g3		! Observed data at 0000000015800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 71e36938106cc029
	ldx	[%i3+0x070],%g3		! Observed data at 0000000015800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 9e4463fe27ae351c
	ldx	[%i3+0x078],%g3		! Observed data at 0000000015800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 1af398dee293d127
	ldx	[%i3+0x080],%g3		! Observed data at 0000000015800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = f07de18597068b09
	ldx	[%i3+0x088],%g3		! Observed data at 0000000015800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 49d315d992028b78
	ldx	[%i3+0x090],%g3		! Observed data at 0000000015800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 0debd12523eb308c
	ldx	[%i3+0x098],%g3		! Observed data at 0000000015800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = bcec952ec4a5f4de
	ldx	[%i3+0x0a0],%g3		! Observed data at 00000000158000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = e3a5ede2c2db7bcd
	ldx	[%i3+0x0a8],%g3		! Observed data at 00000000158000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = c37c54070d319a2e
	ldx	[%i3+0x0b0],%g3		! Observed data at 00000000158000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 952d15d3024fafd1
	ldx	[%i3+0x0b8],%g3		! Observed data at 00000000158000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = c1d5b8cf505b1665
	ldx	[%i3+0x0c0],%g3		! Observed data at 00000000158000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 535867d3ae2f9f9a
	ldx	[%i3+0x0c8],%g3		! Observed data at 00000000158000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 8ea18eaf9412d179
	ldx	[%i3+0x0d0],%g3		! Observed data at 00000000158000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = d51f794d8457edcd
	ldx	[%i3+0x0d8],%g3		! Observed data at 00000000158000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 152ecec74baed4ef
	ldx	[%i3+0x0e0],%g3		! Observed data at 00000000158000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 2be8d2c222f096c2
	ldx	[%i3+0x0e8],%g3		! Observed data at 00000000158000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 41d416c599400000
	ldx	[%i3+0x0f0],%g3		! Observed data at 00000000158000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 9971c7fa65297c15
	ldx	[%i3+0x0f8],%g3		! Observed data at 00000000158000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = a9569bee6340bc83
	ldx	[%i3+0x100],%g3		! Observed data at 0000000015800100
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = b0320a8da01b97aa
	ldx	[%i3+0x108],%g3		! Observed data at 0000000015800108
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = d2ab9d9e717c8390
	ldx	[%i3+0x110],%g3		! Observed data at 0000000015800110
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 635f1c94b22f98e0
	ldx	[%i3+0x118],%g3		! Observed data at 0000000015800118
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = e798b4067c91fab2
	ldx	[%i3+0x120],%g3		! Observed data at 0000000015800120
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 47e124f24f16fce4
	ldx	[%i3+0x128],%g3		! Observed data at 0000000015800128
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = 29c06c103869e371
	ldx	[%i3+0x130],%g3		! Observed data at 0000000015800130
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 1c35ae27fe63449e
	ldx	[%i3+0x138],%g3		! Observed data at 0000000015800138
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 44fc7f59819bf240
	ldx	[%i3+0x140],%g3		! Observed data at 0000000015800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 883fcc5532bd6c16
	ldx	[%i3+0x148],%g3		! Observed data at 0000000015800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = c4fc7f59819bf240
	ldx	[%i3+0x150],%g3		! Observed data at 0000000015800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = c1a9203f52000000
	ldx	[%i3+0x158],%g3		! Observed data at 0000000015800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 3c340f64f36fe057
	ldx	[%i3+0x160],%g3		! Observed data at 0000000015800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = fa17f90314d0c432
	ldx	[%i3+0x168],%g3		! Observed data at 0000000015800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = dcb0caf6db746ed0
	ldx	[%i3+0x170],%g3		! Observed data at 0000000015800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 52db0aa1753fa778
	ldx	[%i3+0x178],%g3		! Observed data at 0000000015800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 44fc7f59819bf240
	ldx	[%i3+0x180],%g3		! Observed data at 0000000015800180
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 44fc7f59819bf240
	ldx	[%i3+0x188],%g3		! Observed data at 0000000015800188
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = c1a9203f52000000
	ldx	[%i3+0x190],%g3		! Observed data at 0000000015800190
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = c1a9203f52000000
	ldx	[%i3+0x198],%g3		! Observed data at 0000000015800198
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 3c340f64f36fe057
	ldx	[%i3+0x1a0],%g3		! Observed data at 00000000158001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = fa17f90314d0c432
	ldx	[%i3+0x1a8],%g3		! Observed data at 00000000158001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = dcb0caf6db746ed0
	ldx	[%i3+0x1b0],%g3		! Observed data at 00000000158001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 52db0aa1753fa778
	ldx	[%i3+0x1b8],%g3		! Observed data at 00000000158001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = b9886a0bb59f5a4e
	ldx	[%i3+0x1c0],%g3		! Observed data at 00000000158001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 8fbdda08c8512743
	ldx	[%i3+0x1c8],%g3		! Observed data at 00000000158001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 1c062400822c7d4d
	ldx	[%i3+0x1d0],%g3		! Observed data at 00000000158001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = 3c488ec8451a51ad
	ldx	[%i3+0x1d8],%g3		! Observed data at 00000000158001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = 7524a7754bdf7104
	ldx	[%i3+0x1e0],%g3		! Observed data at 00000000158001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 1e8a235fe5e5fcc0
	ldx	[%i3+0x1e8],%g3		! Observed data at 00000000158001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = b88546b0ae796565
	ldx	[%i3+0x1f0],%g3		! Observed data at 00000000158001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 7c987a4ed36a38e5
	ldx	[%i3+0x1f8],%g3		! Observed data at 00000000158001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f8,%g4

	set	p1_local4_expect,%g1

!	Processor 1, local 4 is clean


	set	p1_local5_expect,%g1
	ldx	[%g1+0x008],%g2		! Expect data = e58af09100000000
	ldx	[%i5+0x008],%g3		! Observed data at 0000000016800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 106cc029a8823a01
	ldx	[%i5+0x010],%g3		! Observed data at 0000000016800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 1af398de6798b406
	ldx	[%i5+0x1c0],%g3		! Observed data at 00000000168001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = f07de18597068b09
	ldx	[%i5+0x1c8],%g3		! Observed data at 00000000168001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 49d315d992028b78
	ldx	[%i5+0x1d0],%g3		! Observed data at 00000000168001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = 0debd12523eb308c
	ldx	[%i5+0x1d8],%g3		! Observed data at 00000000168001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = bcec952ec4a5f4de
	ldx	[%i5+0x1e0],%g3		! Observed data at 00000000168001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = e3a5ede2c2db7bcd
	ldx	[%i5+0x1e8],%g3		! Observed data at 00000000168001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = c37c54070d319a2e
	ldx	[%i5+0x1f0],%g3		! Observed data at 00000000168001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 952d15d3024fafd1
	ldx	[%i5+0x1f8],%g3		! Observed data at 00000000168001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x1f8,%g4

	set	p1_local6_expect,%g1
	ldx	[%g1+0x140],%g2		! Expect data = 83bc4063ee9b56a9
	ldx	[%i6+0x140],%g3		! Observed data at 0000000017000140
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = aa971ba08d0a32b0
	ldx	[%i6+0x148],%g3		! Observed data at 0000000017000148
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 90837c719e9dabd2
	ldx	[%i6+0x150],%g3		! Observed data at 0000000017000150
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = e0982fb2941c5f63
	ldx	[%i6+0x158],%g3		! Observed data at 0000000017000158
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = b2fa917c06b498e7
	ldx	[%i6+0x160],%g3		! Observed data at 0000000017000160
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = e4fc164ff224e147
	ldx	[%i6+0x168],%g3		! Observed data at 0000000017000168
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 71e36938106cc029
	ldx	[%i6+0x170],%g3		! Observed data at 0000000017000170
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 9e4463fe27ae351c
	ldx	[%i6+0x178],%g3		! Observed data at 0000000017000178
	cmp	%g2,%g3
	bne,a,pn %xcc,p1_local_failed
	mov	0x178,%g4


!	Check Shared Memory
	set	share0_expect,%g4
	set	p1_share_mask,%g5
	set	0x70000000,%g6	! Physical Addr of Share 0
p1_memcheck_share0:
	ldx	[%g4+0x08],%g2	! Expected value = 8130392d6a3389dd
	ldx	[%o0+0x08],%g3	! Read value at Mem[0000000070000008]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x008,%g1
	ldx	[%g4+0x48],%g2	! Expected value = 37c024f2a5b959ff
	ldx	[%o0+0x48],%g3	! Read value at Mem[0000000070000048]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x048,%g1
	set	share1_expect,%g4
	set	0x70800000,%g6	! Physical Addr of Share 1
p1_memcheck_share1:
	ldx	[%g4+0x08],%g2	! Expected value = d073ffb5e7fbca1a
	ldx	[%o1+0x08],%g3	! Read value at Mem[0000000070800008]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x008,%g1
	ldx	[%g4+0x48],%g2	! Expected value = 000000004677966b
	ldx	[%o1+0x48],%g3	! Read value at Mem[0000000070800048]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x048,%g1
	set	share2_expect,%g4
	set	0x71000000,%g6	! Physical Addr of Share 2
p1_memcheck_share2:
	ldx	[%g4+0x08],%g2	! Expected value = 00003f8806a0d46f
	ldx	[%o2+0x08],%g3	! Read value at Mem[0000000071000008]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x008,%g1
	ldx	[%g4+0x48],%g2	! Expected value = ffb8450f37c024f2
	ldx	[%o2+0x48],%g3	! Read value at Mem[0000000071000048]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x048,%g1
	set	share3_expect,%g4
	set	0x71800000,%g6	! Physical Addr of Share 3
p1_memcheck_share3:
	ldx	[%g4+0x08],%g2	! Expected value = 0000001f00005a4e
	ldx	[%o3+0x08],%g3	! Read value at Mem[0000000071800008]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x008,%g1
	ldx	[%g4+0x48],%g2	! Expected value = fffff8a7b2d88fc6
	ldx	[%o3+0x48],%g3	! Read value at Mem[0000000071800048]
	cmp	%g2,%g3
	bne,pn	%xcc,p1_failed
	add	%g6,0x048,%g1

!	The test for processor 1 has passed

p1_passed:
	ta	GOOD_TRAP
	nop

p1_reg_l0_fail:
	or	%g0,0xbd0,%g1
	ba,a	p1_failed
p1_reg_l1_fail:
	or	%g0,0xbd1,%g1
	ba,a	p1_failed
p1_reg_l2_fail:
	or	%g0,0xbd2,%g1
	ba,a	p1_failed
p1_reg_l3_fail:
	or	%g0,0xbd3,%g1
	ba,a	p1_failed
p1_reg_l4_fail:
	or	%g0,0xbd4,%g1
	ba,a	p1_failed
p1_reg_l5_fail:
	or	%g0,0xbd5,%g1
	ba,a	p1_failed
p1_reg_l6_fail:
	or	%g0,0xbd6,%g1
	ba,a	p1_failed
p1_reg_l7_fail:
	or	%g0,0xbd7,%g1
	ba,a	p1_failed
p1_freg_fail:
	mov	%l0,%g3
	ba	p1_failed
	mov	%l1,%g2


!	The test for processor 1 failed

p1_failed:
	set	done_flags,%g1
	mov	3,%g5
	st	%g5,[%g1+0x004]		! Set processor 1 done flag

	set	p1_temp,%g6
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p1_freg_failed:
	ba,a	p1_failed

!	The local area data for processor 1 failed

p1_local_failed:
	set	done_flags,%g5
	mov	3,%g6
	st	%g5,[%g5+0x004]		! Set processor 1 done flag

	set	p1_temp,%g6
	add	%g1,%g4,%g1
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p1_dfill_failed:
	ba	p1_failed
	mov	0xddd,%g1

p1_selfmod_failed:
	ba	p1_failed
	mov	0xabc,%g1


p1_common_error:
	or	%g0,0xee1,%g1
	ba	p1_failed
	mov	%o5,%g3

p1_common_signature_error:
	set	p1_temp,%g1
	ba	p1_failed
	st	%g2,[%g1]			! Common Lock Number

p1_common_timeout:
	set	p1_temp,%g1
	ba	p1_failed
	st	%g2,[%g1]			! Common Lock Number
p1_branch_failed:
	mov	0xbbb,%g1
	rd	%ccr,%g2
	ba	p1_failed
	mov	0x0,%g3

p1_trap1e:
	ldx	[%i0+0x020],%l1		! Mem[0000000014000020]
	done

p1_trap1o:
	ldx	[%o0+0x020],%l1		! Mem[0000000014000020]
	done


p1_trap2e:
	lduh	[%i1+0x124],%l5		! Mem[0000000014800124]
	ldx	[%o0+0x048],%l1		! Mem[0000000070000048]
	ldx	[%i2+0x060],%l0		! Mem[0000000015000060]
	done

p1_trap2o:
	lduh	[%o1+0x124],%l5		! Mem[0000000014800124]
	ldx	[%i0+0x048],%l1		! Mem[0000000070000048]
	ldx	[%o2+0x060],%l0		! Mem[0000000015000060]
	done


p1_init_memory_pointers:
	set	p1_init_registers,%g1
	mov	%g0,%g4
	mov	%g0,%g5
	mov	%g0,%g6
	mov	%g0,%g7

!	Initialize memory pointers for window 0
	set	p1_local0_start,%i0
	set	p1_local1_start,%i1
	set	p1_local2_start,%i2
	set	p1_local3_start,%i3
	set	p1_local4_start,%i4
	set	p1_local5_start,%i5
	set	p1_local6_start,%i6
	mov	%g0,%i7
!	Init Local Registers in Window 0
	ldx	[%g1+0x000],%l0	! %l0 = 1996cf608d354b88
	ldx	[%g1+0x008],%l1	! %l1 = e6cacca6882f6221
	ldx	[%g1+0x010],%l2	! %l2 = 11ed888c7a3cfbb5
	ldx	[%g1+0x018],%l3	! %l3 = 00c655b8fd87bc77
	ldx	[%g1+0x020],%l4	! %l4 = 10862c7df5d22f06
	ldx	[%g1+0x028],%l5	! %l5 = 2f4fe893db141a6d
	ldx	[%g1+0x030],%l6	! %l6 = 11aa74b0b6fc1071
	ldx	[%g1+0x038],%l7	! %l7 = 500668c6301c0df2

!	Initialize the output register of window 0
	set	share0_start,%o0
	set	share1_start,%o1
	set	share2_start,%o2
	set	share3_start,%o3
	set	unres0_start,%o4
	set	common_start,%o5
	mov	0x08,%o6

	retl
	nop

!	Random code for Processor 2

processor_2:
	ta	T_CHANGE_PRIV
	set	done_flags,%g1
	mov	1,%g2
	st	%g2,[%g1+0x08]		! Set the start flag
	wrpr	%g0,7,%cleanwin
	call	p2_init_memory_pointers
	wr	%g0,0x80,%asi		! Setting default asi to 80

!	Initialize the floating point registers for processor 2

	wr	%g0,0x4,%fprs		! Make sure fef is 1
	set	p2_init_freg,%g1
!	%f0  = 6c06cd8b 11317e17 36f1e6a5 749b8503
!	%f4  = 564efe67 930256c6 997c0172 785e6005
!	%f8  = 639fb66b 4a304b88 1aff3dff 072fe028
!	%f12 = 962a28fe 6bf81f74 eacbe868 a5871528
	ldda	[%g1]ASI_BLK_P,%f0
	add	%g1,64,%g1
!	%f16 = 4027e974 893d6b21 befd0f92 ba8e312a
!	%f20 = fe603021 21031147 9400e277 deddcebb
!	%f24 = e53a83cc 170eedc5 9750f6e4 5b13c882
!	%f28 = d1bd85e5 8ca23a28 5f099187 195ee6c2
	ldda	[%g1]ASI_BLK_P,%f16
	add	%g1,64,%g1
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	ldda	[%g1]ASI_BLK_P,%f32
	xorcc	%g0,%g0,%g3		! init %g3 and set flags
	membar	#Sync			! Force the block loads to complete

!	Start of Random Code for processor 2

p2_label_1:
!	Mem[00000000180001c0] = 700332f8 a569f230 490d118b b416244d
!	Mem[00000000180001d0] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[00000000180001e0] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[00000000180001f0] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x1c0,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 00000000180001c0
!	Mem[0000000019800008] = 47ba24b0, %l2 = aaa194b8b8101a0e
	ldsha	[%i3+%o6]0x80,%l2	! %l2 = 00000000000047ba
!	Mem[0000000018000008] = 5f470c0eaddca781, %l0 = 01b91f71df2547cf
	ldxa	[%i0+%o6]0x80,%l0	! %l0 = 5f470c0eaddca781
!	%f0  = 700332f8 a569f230 490d118b b416244d
!	%f4  = 127b3eef c5fb02fd 07270b5b c461673a
!	%f8  = f838593e 49929786 1b257c64 6a36b38a
!	%f12 = e5347cd8 82db4849 116dd82b 2b0563c6
	stda	%f0,[%i1]ASI_BLK_P	! Block Store to 0000000018800000
!	Mem[0000000072000040] = e52f81e7, %l6 = 6f159f4c085cca5a
	ldsw	[%o4+0x040],%g2		! %g2 = 6f159f4c085cca5a

p2_label_2:
	bvs	p2_not_taken_0		! Branch Not Taken, %ccr = 44
!	%l7 = 58f6efe1ae0bd466, %l6 = 6f159f4c085cca5a, %y  = 00000000
	udivx	%l7,%l6,%l1		! %l1 = 0000000000000000
p2_b1:
!	Mem[000000001880016c] = 85c70227, %l0 = 5f470c0eaddca781
	ldsha	[%i1+0x16c]%asi,%l0	! %l0 = ffffffffffff85c7
!	Mem[000000001880011c] = 3e7d1b41, %l1 = 0000000000000000
	lduw	[%i1+0x11c],%l1		! %l1 = 000000003e7d1b41
!	Mem[0000000072000040] = e52f81e7 7204d04f 2bf57d99 e8bcab63
!	Mem[0000000072000050] = 876a38ba 4684903e 4d87bc9b fb584d4b
!	Mem[0000000072000060] = 330289d1 834615f3 560b78a1 da01ee66
!	Mem[0000000072000070] = ea47ccfe 2b6b1536 b32a25dd 6960f59a
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p2_label_3:
!	Mem[0000000071000050] = f9dce001, %l6 = 6f159f4c085cca5a
	ldsh	[%o2+0x050],%l6		! %l6 = fffffffffffff9dc
	fbul,a	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000070000010] = 3110440ba5eb3d6d, %l2 = 00000000000047ba
	ldx	[%o0+0x010],%l2		! Annulled
p2_b2:
!	Mem[0000000070000054] = 989662c1, %l0 = ffffffffffff85c7
	ldsba	[%o0+0x057]%asi,%l0	! %l0 = ffffffffffffffc1
!	%f23 = deddcebb, %f30 = 5f099187 195ee6c2
	fitod	%f23,%f30		! %f30 = c1c09118 a2800000

p2_label_4:
!	Mem[00000000180001c0] = 700332f8 a569f230 490d118b b416244d
!	Mem[00000000180001d0] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[00000000180001e0] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[00000000180001f0] = e5347cd8 82db4849 116dd82b 2b0563c6
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 00000000180001c0
!	Mem[0000000018800080] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000018800090] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000188000a0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000188000b0] = d852663a 841fa94d 012e213e bb7139a6
	mov	0x080,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000018800080
!	Mem[0000000072000078] = b32a25dd, %l3 = 62ef3bd44c9f6765
	ldswa	[%o4+0x078]%asi,%g2	! %g2 = 62ef3bd44c9f6765
!	%f0  = 988b18bd d8289b24 6d64924c cb72efd9
!	%f4  = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	%f8  = 8e534add 4b60c30b bb0dfff8 27a27954
!	%f12 = 4da91f84 3a6652d8 a63971bb 3e212e01
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000019000040
!	Mem[0000000070800010] = c7fc652b96af8e92, %l2 = 00000000000047ba
	ldxa	[%o1+0x010]%asi,%l2	! %l2 = c7fc652b96af8e92

p2_label_5:
!	call to call_3, CWP = 0
	membar	#Sync			! Added by membar checker (107)
	call	p2_call_3_he
!	Mem[0000000019000008] = 3af102c4, %l1 = 000000003e7d1b41
	lduwa	[%i2+%o6]0x80,%l1	! %l1 = 000000003af102c4
!	Registers modified during the branch to p2_call_3
!	%l1  = 000000000000cab5
!	Mem[0000000018800060] = 5f3ad5a1, %l5 = db0b0246b81e38d1
	ldsb	[%i1+0x062],%l5		! %l5 = ffffffffffffffd5
!	Mem[00000000180000d0] = e75b79590f2d6601, %l3 = 62ef3bd44c9f6765
	ldx	[%i0+0x0d0],%l3		! %l3 = e75b79590f2d6601
!	Branch On Register, %l1 = 000000000000cab5
	brlez,a,pt %l1,p2_not_taken_0	! Branch Not Taken

p2_label_6:
!	Mem[0000000018000140] = 41663151, %l5 = ffffffffffffffd5
	ldub	[%i0+0x142],%l5		! Annulled
p2_b3:
!	Mem[0000000019000010] = 8001c1d3 2db7bc6d, %l2 = 96af8e92, %l3 = 0f2d6601
	ldda	[%i2+0x010]%asi,%l2	! %l2 = 000000008001c1d3 000000002db7bc6d
!	Mem[0000000019000180] = c7593c35 242c92fc db4650fd 34342b25
!	Mem[0000000019000190] = 0073df19 e9e8d2b2 9cfdbc32 852ecf29
!	Mem[00000000190001a0] = 45d2d661 809213f5 cec182b2 9bef15e5
!	Mem[00000000190001b0] = d9f809b1 6b844f61 8b52b5fa 9abf22c1
	mov	0x180,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000019000180
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	Mem[00000000190001f4] = bedc3150, %l4 = e18d5506262f384a
	lduw	[%i2+0x1f4],%l4		! %l4 = 00000000bedc3150

p2_label_7:
!	Mem[000000007200001c] = 5b1cfb88, %l4 = 00000000bedc3150
	ldsba	[%o4+0x01f]%asi,%g2	! %g2 = 000000000000005b
!	Mem[000000007200005c] = fb584d4b, %l3 = 000000002db7bc6d
	lduh	[%o4+0x05c],%g2		! %g2 = 000000000000fb58
!	Mem[0000000071000054] = 990e6573, %l0 = ffffffffffffffc1
	ldsh	[%o2+0x056],%l0		! %l0 = 0000000000006573
!	Mem[00000000180001a4] = 72b38e4d, %l1 = 000000000000cab5
	lduba	[%i0+0x1a7]%asi,%l1	! %l1 = 000000000000004d
!	%l7 = 58f6efe1ae0bd466, %l5 = ffffffffffffffd5, %l3 = 000000002db7bc6d
	sllx	%l7,%l5,%l3		! %l3 = fc35c17a8cc00000

p2_label_8:
!	Mem[00000000180000d8] = e7b5ce2f77503890, %l6 = fffffffffffff9dc
	ldxa	[%i0+0x0d8]%asi,%l6	! %l6 = e7b5ce2f77503890
	bgu,a	p2_not_taken_0		! Branch Not Taken, %ccr = 44
!	%f16 = 700332f8, %f16 = 700332f8, %f9  = 61d6d245
	fdivs	%f16,%f16,%f9 	! Annulled
p2_b4:
!	Mem[00000000180000f4] = 45e38fa0, %l0 = 0000000000006573
	ldsb	[%i0+0x0f7],%l0		! %l0 = ffffffffffffffa0
!	Mem[000000001a0000f0] = 439c38af 24e140ff, %l6 = 77503890, %l7 = ae0bd466
	ldd	[%i4+0x0f0],%l6		! %l6 = 00000000439c38af 0000000024e140ff

p2_label_9:
!	Mem[0000000071000050] = f9dce001990e6573, %l4 = 00000000bedc3150
	ldx	[%o2+0x050],%l4		! %l4 = f9dce001990e6573
!	%l2 = 8001c1d3, %l3 = 8cc00000, Mem[0000000070000010] = 3110440b a5eb3d6d
	stda	%l2,[%o0+0x010]%asi	! Mem[0000000070000010] = 8001c1d3 8cc00000
!	%l4 = f9dce001990e6573, %l1 = 000000000000004d, %l7 = 0000000024e140ff
	add	%l4,%l1,%l7		! %l7 = f9dce001990e65c0
!	Mem[0000000071000010] = 9d0d6da6cab52ecb, %l6 = 00000000439c38af
	ldx	[%o2+0x010],%l6		! %l6 = 9d0d6da6cab52ecb
!	Mem[00000000190001c8] = 8d5fe119eb6a7654, %l3 = fc35c17a8cc00000
	ldxa	[%i2+0x1c8]%asi,%l3	! %l3 = 8d5fe119eb6a7654

p2_label_10:
!	Mem[0000000071000054] = 990e6573, %l3 = 8d5fe119eb6a7654
	lduwa	[%o2+0x054]%asi,%l3	! %l3 = 00000000990e6573
!	Mem[0000000019800140] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[0000000019800150] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[0000000019800160] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[0000000019800170] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x140,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000019800140
!	Mem[0000000018000000] = 7e3be4e9, %l4 = f9dce001990e6573
	lduha	[%i0+%g0]0x80,%l4	! %l4 = 0000000000007e3b
!	%f16 = 700332f8 a569f230 490d118b b416244d
!	%f20 = 127b3eef c5fb02fd 07270b5b c461673a
!	%f24 = f838593e 49929786 1b257c64 6a36b38a
!	%f28 = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x100,%g5
	stda	%f16,[%i1+%g5]ASI_BLK_P	! Block Store to 0000000018800100
!	Mem[0000000018800180] = 8dff5460 49afbd2a, %l6 = cab52ecb, %l7 = 990e65c0
	ldd	[%i1+0x180],%l6		! %l6 = 000000008dff5460 0000000049afbd2a

p2_label_11:
	membar	#Sync
!	Branch On Register, %l1 = 000000000000004d
	brz,pt	%l1,p2_not_taken_0	! Branch Not Taken
!	%l1 = 000000000000004d, Mem[0000000070800010] = c7fc652b96af8e92
	stx	%l1,[%o1+0x010]		! Mem[0000000070800010] = 000000000000004d
p2_b5:
!	%l1 = 000000000000004d, %l7 = 0000000049afbd2a, %l3 = 00000000990e6573
	addc	%l1,%l7,%l3		! %l3 = 0000000049afbd77
	bcc,a	p2_b6			! Branch Taken, %ccr = 44, CWP = 0
!	Mem[0000000018800000] = 700332f8, %l1 = 000000000000004d
	ldsha	[%i1+%g0]0x80,%l1	! %l1 = 0000000000007003
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x006,%g2
p2_b6:

p2_label_12:
!	Mem[0000000070000054] = 989662c1, %l2 = 000000008001c1d3
	ldsh	[%o0+0x056],%l2		! %l2 = 00000000000062c1
!	%l1 = 0000000000007003, %l7 = 0000000049afbd2a, %l6 = 000000008dff5460
	orncc	%l1,%l7,%l6		! %l6 = ffffffffb65072d7, %ccr = 88
!	Mem[0000000019000064] = 4b60c30b, %l1 = 0000000000007003
	lduwa	[%i2+0x064]%asi,%l1	! %l1 = 000000004b60c30b
!	Mem[00000000180001f4] = 82db4849, %l4 = 0000000000007e3b
	lduw	[%i0+0x1f4],%l4		! %l4 = 0000000082db4849
!	Mem[0000000071800010] = d02d0810 0ca96db1, %l2 = 000062c1, %l3 = 49afbd77
	ldda	[%o3+0x010]%asi,%l2	! %l2 = 00000000d02d0810 000000000ca96db1

p2_label_13:
!	%f0  = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f4  = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f8  = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f12 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x040,%g4
	stda	%f0,[%o4+%g4]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000071800054] = 7f3d6c55, %l1 = 000000004b60c30b
	ldsw	[%o3+0x054],%l1		! %l1 = 000000007f3d6c55
!	Mem[0000000019800000] = 49e149af87fd80e3, %l4 = 0000000082db4849
	ldxa	[%i3+%g0]0x80,%l4	! %l4 = 49e149af87fd80e3
!	Mem[000000001b000088] = 40648d0a 9937c7be, %l6 = b65072d7, %l7 = 49afbd2a
	ldda	[%i6+0x088]%asi,%l6	! %l6 = 0000000040648d0a 000000009937c7be
!	Mem[0000000070000050] = dfe43fd7989662c1, %l1 = 000000007f3d6c55
	ldx	[%o0+0x050],%l1		! %l1 = dfe43fd7989662c1

p2_label_14:
!	Mem[0000000018000000] = 7e3be4e9, %l4 = 49e149af87fd80e3
	ldstuba	[%i0+%g0]0x80,%l4	! %l4 = 000000000000007e
!	%f17 = a569f230, %f16 = 700332f8
	fabss	%f17,%f16		! %f16 = 2569f230
!	Mem[0000000019000080] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000019000090] = ce7327c9 ea955931 9932a6be 5237261e
!	Mem[00000000190000a0] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[00000000190000b0] = b249411b b8b896fd 3c980de0 9b8764aa
	mov	0x080,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 0000000019000080
!	Mem[0000000071800000] = 00000000 00007bf4 0000001f 00005a4e
	prefetcha [%o3+0x000]%asi,16
!	%l6 = 0000000040648d0a, immed = fffff8a9, %l6 = 0000000040648d0a
	xorcc	%l6,-0x757,%l6		! %l6 = ffffffffbf9b75a3, %ccr = 88

p2_label_15:
!	%f0  = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	%f4  = ce7327c9 ea955931 9932a6be 5237261e
!	%f8  = ec49017c 7be5468a d6befb74 cab77127
!	%f12 = b249411b b8b896fd 3c980de0 9b8764aa
	mov	0x1c0,%g5
	stda	%f0,[%i1+%g5]ASI_BLK_PL	! Block Store to 00000000188001c0
!	Mem[0000000018800008] = 490d118bb416244d, %l7 = 000000009937c7be
	ldxa	[%i1+%o6]0x80,%l7	! %l7 = 490d118bb416244d
!	Mem[0000000018800118] = 07270b5b, %l7 = 490d118bb416244d
	ldsb	[%i1+0x11a],%l7		! %l7 = 000000000000000b
!	Mem[0000000019000098] = 9932a6be, %l4 = 000000000000007e
	lduba	[%i2+0x09b]%asi,%l4	! %l4 = 00000000000000be
!	Mem[000000001b0000c0] = 543ab646 658e9b09 25b9671a df184cf9
!	Mem[000000001b0000d0] = 942665e0 8cbc4fad a7f6477d e8e11d1c
!	Mem[000000001b0000e0] = a6f98ce7 0f87895e 240eba74 254308b3
!	Mem[000000001b0000f0] = d430de90 616c262d fe373340 fafa8a89
	mov	0x0c0,%g4
	ldda	[%i6+%g4]ASI_BLK_P,%f16	! Block Load from 000000001b0000c0

p2_label_16:
!	Mem[0000000019800040] = 468e4a30 ed64f947 573c16fc f8594ff9
!	Mem[0000000019800050] = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	Mem[0000000019800060] = 5892f840 1545e874 5322649d 502ee47f
!	Mem[0000000019800070] = 5f390a81 23cefe18 d353592b ce98ded1
	mov	0x040,%g4
	ldda	[%i3+%g4]ASI_BLK_P,%f16	! Block Load from 0000000019800040
!	Mem[0000000070800050] = f262ad6d, %l4 = 00000000000000be
	ldub	[%o1+0x052],%l4		! %l4 = 00000000000000ad
!	Mem[00000000198001c0] = 35780b64 e4f3346e, %l0 = ffffffa0, %l1 = 989662c1
	ldda	[%i3+0x1c0]%asi,%l0	! %l0 = 0000000035780b64 00000000e4f3346e
!	%l0 = 0000000035780b64, %l5 = ffffffffffffffd5, %l5 = ffffffffffffffd5
	subc	%l0,%l5,%l5		! %l5 = 0000000035780b8f
!	Mem[0000000071000014] = cab52ecb, %l4 = 00000000000000ad
	lduba	[%o2+0x016]%asi,%l4	! %l4 = 000000000000002e

p2_label_17:
	membar	#Sync			! Added by membar checker (108)
	set	p2_b7,%o7
	fbule	p2_far_3_le		! Branch Taken, %fcc0 = 0
!	Mem[000000007200003c] = 3369be9b, %l1 = 00000000e4f3346e
	ldsh	[%o4+0x03e],%g2		! %g2 = 0000000000003369
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x007,%g2
p2_b7:
!	Registers modified during the branch to p2_far_3
!	%l3  = 000000003150020e
!	%l4  = 0000000000000000
!	%l6  = 0000000000000000
!	%l7  = ffffffffffffff89
!	Mem[0000000018800140] = f8aa3707 2c193c11 b489971d 4bc87a61
!	Mem[0000000018800150] = 2259b9db 19a67bbd 15f863b3 0d9a9a48
!	Mem[0000000018800160] = 0bdcce09 49b64e0a 449e182b 85c70227
!	Mem[0000000018800170] = b2fc3988 f9e891e3 c0d8136e dd4522b8
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 0000000018800140
!	Mem[0000000018000090] = a5c041db5ee9fda9, %l0 = 0000000035780b64
	ldxa	[%i0+0x090]%asi,%l0	! %l0 = a5c041db5ee9fda9
!	Mem[0000000018800080] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000018800090] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000188000a0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000188000b0] = d852663a 841fa94d 012e213e bb7139a6
	mov	0x080,%g4
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 0000000018800080

p2_label_18:
!	Mem[0000000071000010] = 9d0d6da6cab52ecb, %l4 = 0000000000000000
	ldxa	[%o2+0x010]%asi,%l4	! %l4 = 9d0d6da6cab52ecb
!	%f0  = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	%f4  = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	%f8  = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	%f12 = d852663a 841fa94d 012e213e bb7139a6
	mov	0x0c0,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000198000c0
!	Mem[00000000190000a0] = ec49017c 7be5468a, %l4 = cab52ecb, %l5 = 35780b8f
	ldda	[%i2+0x0a0]%asi,%l4	! %l4 = 00000000ec49017c 000000007be5468a
!	%f24 = 5892f840 1545e874, Mem[0000000070800050] = f262ad6d 70852fa7
	std	%f24,[%o1+0x050]	! Mem[0000000070800050] = 5892f840 1545e874
!	%f16 = 468e4a30 ed64f947 573c16fc f8594ff9
!	%f20 = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f24 = 5892f840 1545e874 5322649d 502ee47f
!	%f28 = 5f390a81 23cefe18 d353592b ce98ded1
	mov	0x180,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000019800180

p2_label_19:
!	Mem[00000000190001c0] = a7a85772 dafc1653 8d5fe119 eb6a7654
!	Mem[00000000190001d0] = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	Mem[00000000190001e0] = 4260713d aa961a27 dc92015f 61faada2
!	Mem[00000000190001f0] = 1b0a271c bedc3150 24e9c881 a16ff7a5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 00000000190001c0
!	Mem[00000000188001a4] = 2389ad9c, %l0 = a5c041db5ee9fda9
	ldub	[%i1+0x1a4],%l0		! %l0 = 0000000000000023
!	%f0  = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	%f4  = 1c16487d c7407846 7bd5e73f a750d99c
!	%f8  = 271a96aa 3d716042 a2adfa61 5f0192dc
!	%f12 = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000180001c0
!	Mem[0000000071000050] = f9dce001990e6573, %l6 = 0000000000000000
	ldx	[%o2+0x050],%l6		! %l6 = f9dce001990e6573
	membar	#Sync			! Added by membar checker (109)
	set	p2_b8,%o7
	fbuge,a	p2_far_3_he		! Branch Taken, %fcc0 = 0

p2_label_20:
!	Mem[0000000018000000] = ff3be4e9 a0f4cb4a, %l6 = 990e6573, %l7 = ffffff89
	ldda	[%i0+%g0]0x80,%l6	! %l6 = 00000000ff3be4e9 00000000a0f4cb4a
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p2_branch_failed
	mov	0x008,%g2
p2_b8:
!	Registers modified during the branch to p2_far_3
!	%l6  = 8001c1d38cc00000
!	%l7  = ffffffffffffff9e
!	Mem[00000000190001e8] = dc92015f61faada2, %l0 = 0000000000000023
	ldx	[%i2+0x1e8],%l0		! %l0 = dc92015f61faada2
!	Mem[0000000070000010] = 8001c1d38cc00000, %l3 = 000000003150020e
	ldx	[%o0+0x010],%l3		! %l3 = 8001c1d38cc00000
!	Mem[0000000018800000] = 700332f8, %l2 = 00000000d02d0810
	ldsha	[%i1+%g0]0x80,%l2	! %l2 = 0000000000007003
!	Mem[0000000018800140] = f8aa3707 2c193c11 b489971d 4bc87a61
!	Mem[0000000018800150] = 2259b9db 19a67bbd 15f863b3 0d9a9a48
!	Mem[0000000018800160] = 0bdcce09 49b64e0a 449e182b 85c70227
!	Mem[0000000018800170] = b2fc3988 f9e891e3 c0d8136e dd4522b8
	mov	0x140,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000018800140

p2_label_21:
!	Mem[0000000019800148] = e2707d3d1773fce7, %l0 = dc92015f61faada2
	ldx	[%i3+0x148],%l0		! %l0 = e2707d3d1773fce7
!	Mem[0000000019800174] = 125f7337, %l2 = 0000000000007003
	ldsba	[%i3+0x176]%asi,%l2	! %l2 = 0000000000000073
	fbug,a	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000018800008] = 490d118b, %l3 = 8001c1d38cc00000
	lduha	[%i1+%o6]0x80,%l3	! Annulled
p2_b9:
	fbug	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0

p2_label_22:
!	Mem[0000000019800114] = f0efee78, %l0 = e2707d3d1773fce7
	ldub	[%i3+0x116],%l0		! %l0 = 00000000000000ee
p2_b10:
!	Mem[0000000072000020] = 8826b15b, %l7 = ffffffffffffff9e
	lduba	[%o4+0x022]%asi,%g2	! %g2 = 0000000000000088
!	Mem[00000000190000b8] = 3c980de0, %l0 = 00000000000000ee
	ldsha	[%i2+0x0ba]%asi,%l0	! %l0 = 0000000000000de0
!	Mem[0000000071800010] = d02d08100ca96db1, %l6 = 8001c1d38cc00000
	ldx	[%o3+0x010],%l6		! %l6 = d02d08100ca96db1
!	Mem[0000000018000008] = 5f470c0eaddca781, %l3 = 8001c1d38cc00000
	ldxa	[%i0+%o6]0x80,%l3	! %l3 = 5f470c0eaddca781

p2_label_23:
!	Mem[0000000018000100] = f1bb2efc d317983d b75223f0 cda66b12
!	Mem[0000000018000110] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000018000120] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000018000130] = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x100,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000018000100
!	%l6 = d02d08100ca96db1, Mem[0000000040a0003a] = 18151d10
	stba	%l6,[%o5+0x03a]%asi	! Mem[0000000040a00038] = 1815b110
!	%f0  = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x0c0,%g5
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000180000c0
!	Mem[000000001800016c] = f0e4d0cf, %l7 = ffffffffffffff9e
	lduh	[%i0+0x16e],%l7		! %l7 = 000000000000d0cf
!	Mem[0000000018800100] = 700332f8 a569f230
	flush	%i1+0x100

p2_label_24:
!	Mem[0000000018800008] = 490d118b, %l4 = 00000000ec49017c
	ldsha	[%i1+%o6]0x80,%l4	! %l4 = 000000000000490d
!	Mem[0000000071000014] = cab52ecb, %l1 = 00000000e4f3346e
	ldsh	[%o2+0x014],%l1		! %l1 = ffffffffffffcab5
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l6 = d02d08100ca96db1, immed = 0000000d, %l5 = 000000007be5468a
	sra	%l6,0x00d,%l5		! %l5 = 000000000000654b
!	%f0  = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000019800080

p2_label_25:
!	Mem[0000000018000188] = 602170cc 43e2d169, %l2 = 00000073, %l3 = addca781
	ldda	[%i0+0x188]%asi,%l2	! %l2 = 00000000602170cc 0000000043e2d169
!	Mem[000000001800005c] = 09deeb48, %l5 = 000000000000654b
	ldswa	[%i0+0x05c]%asi,%l5	! %l5 = 0000000009deeb48
!	%l7 = 000000000000d0cf, Mem[0000000019800000] = 49e149af
	stwa	%l7,[%i3+%g0]0x80	! Mem[0000000019800000] = 0000d0cf
!	Mem[0000000070800010] = 00000000 0000004d, %l6 = 0ca96db1, %l7 = 0000d0cf
	ldd	[%o1+0x010],%l6		! %l6 = 0000000000000000 000000000000004d
	membar	#Sync			! Added by membar checker (110)
!	Branch On Register, %l5 = 0000000009deeb48
	brnz,a,pn %l5,p2_b11		! Branch Taken

p2_label_26:
!	Mem[00000000180001b4] = 53d4170a, %l1 = ffffffffffffcab5
	lduh	[%i0+0x1b4],%l1		! %l1 = 00000000000053d4
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x00b,%g2
p2_b11:
!	Mem[0000000018800000] = 700332f8, %l5 = 0000000009deeb48
	lduwa	[%i1+%g0]0x80,%l5	! %l5 = 00000000700332f8
!	%l0 = 0000000000000de0, immed = fffff54a, %l0 = 0000000000000de0
	andncc	%l0,-0xab6,%l0		! %l0 = 00000000000008a0, %ccr = 00
!	%f16 = 468e4a30 ed64f947 573c16fc f8594ff9
!	%f20 = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f24 = 5892f840 1545e874 5322649d 502ee47f
!	%f28 = 5f390a81 23cefe18 d353592b ce98ded1
	mov	0x1c0,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 00000000198001c0
!	%f16 = 468e4a30 ed64f947 573c16fc f8594ff9
!	%f20 = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f24 = 5892f840 1545e874 5322649d 502ee47f
!	%f28 = 5f390a81 23cefe18 d353592b ce98ded1
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000018000180

p2_label_27:
!	%f0  = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%i0]ASI_BLK_P	! Block Store to 0000000018000000
!	Mem[0000000072000040] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[0000000072000050] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[0000000072000060] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[0000000072000070] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
	membar	#Sync			! Added by membar checker (111)
!	Mem[0000000018000008] = 126ba6cd, %l7 = 000000000000004d
	lduba	[%i0+%o6]0x80,%l7	! %l7 = 0000000000000012
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[0000000070000010] = 8001c1d3, %l5 = 00000000700332f8
	lduha	[%o0+0x012]%asi,%l5	! %l5 = 000000000000c1d3

p2_label_28:
!	Mem[0000000072000044] = 4170e270, %l0 = 00000000000008a0
	ldsba	[%o4+0x046]%asi,%g2	! %g2 = 0000000000000041
!	Mem[0000000070800014] = 0000004d, %l7 = 0000000000000012
	lduw	[%o1+0x014],%l7		! %l7 = 000000000000004d
!	%l0 = 00000000000008a0, %l3 = 0000000043e2d169, %l2 = 00000000602170cc
	srlx	%l0,%l3,%l2		! %l2 = 0000000000000000
!	%l4 = 000000000000490d, %l7 = 000000000000004d, %l7 = 000000000000004d
	subccc	%l4,%l7,%l7		! %l7 = 00000000000048c0, %ccr = 00
!	Mem[0000000018800000] = 700332f8a569f230, %l2 = 0000000000000000
	ldxa	[%i1+%g0]0x80,%l2	! %l2 = 700332f8a569f230

p2_label_29:
	bgu	p2_b12			! Branch Taken, %ccr = 00, CWP = 0
!	Mem[0000000018000000] = 3d9817d3, %l1 = 00000000000053d4
	lduba	[%i0+%g0]0x80,%l1	! %l1 = 000000000000003d
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p2_branch_failed
	mov	0x00c,%g2
p2_b12:
	membar	#Sync			! Added by membar checker (112)
	set	p2_b13,%o7
	fbe,a,pt %fcc1,p2_near_2_he	! Branch Taken, %fcc1 = 0
!	Mem[0000000019800090] = d14b3f696f8db8e1, %l7 = 00000000000048c0
	ldx	[%i3+0x090],%l7		! %l7 = d14b3f696f8db8e1
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x00d,%g2
p2_b13:
!	Registers modified during the branch to p2_near_2
!	%l0  = fffffffffffffde0
!	%l1  = dfe43fd7989662c1
!	%l2  = 0000000000000000
!	%l3  = c04617fb1b5aa8d6
!	%l5  = 000000000000002b
!	Mem[0000000070000014] = 8cc00000, %l2 = 0000000000000000
	lduwa	[%o0+0x014]%asi,%l2	! %l2 = 000000008cc00000

p2_label_30:
!	%l2 = 000000008cc00000, immed = fffff522, %l3 = c04617fb1b5aa8d6
	sub	%l2,-0xade,%l3		! %l3 = 000000008cc00ade
!	Mem[000000001a800060] = 65232085, %l6 = 0000000000000000
	ldsba	[%i5+0x061]%asi,%l6	! %l6 = 0000000000000023
!	%f16 = 468e4a30 ed64f947 573c16fc f8594ff9
!	%f20 = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f24 = 5892f840 1545e874 5322649d 502ee47f
!	%f28 = 5f390a81 23cefe18 d353592b ce98ded1
	mov	0x100,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000019000100
	membar	#Sync
!	Branch On Register, %l6 = 0000000000000023
	brz,pn	%l6,p2_not_taken_0	! Branch Not Taken
!	%l3 = 000000008cc00ade, immed = 00000644, %l2 = 000000008cc00000
	sub	%l3,0x644,%l2		! %l2 = 000000008cc0049a
p2_b14:

p2_label_31:
	bge	p2_not_taken_0		! Branch Not Taken, %ccr = 88
!	%f8  = 78f70e2e, %f16 = 468e4a30 ed64f947
	fitod	%f8 ,%f16		! %f16 = 41de3dc3 8b800000
p2_b15:
!	%f16 = 41de3dc3 8b800000 573c16fc f8594ff9
!	%f20 = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f24 = 5892f840 1545e874 5322649d 502ee47f
!	%f28 = 5f390a81 23cefe18 d353592b ce98ded1
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 0000000018800040
!	Mem[0000000019000000] = 6b7038f8, %l4 = 000000000000490d
	lduba	[%i2+%g0]0x80,%l4	! %l4 = 000000000000006b
!	Mem[0000000019800140] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[0000000019800150] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[0000000019800160] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[0000000019800170] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x140,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 0000000019800140

p2_label_32:
	membar	#Sync			! Added by membar checker (113)
	set	p2_b16,%o7
	fbge,pt	%fcc1,p2_near_3_le	! Branch Taken, %fcc1 = 0
!	Mem[0000000019000008] = 3af102c4 818665de, %l4 = 0000006b, %l5 = 0000002b
	ldda	[%i2+%o6]0x80,%l4	! %l4 = 000000003af102c4 00000000818665de
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x010,%g2
p2_b16:
!	Registers modified during the branch to p2_near_3
!	%l2  = ffffffffffffff83
!	%l3  = 000000000000004d
!	%l5  = 0000000000000000
!	%l7  = 22bf19dc308ce411
	bleu	p2_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[0000000018000008] = 126ba6cdf02352b7, %l6 = 0000000000000023
	ldxa	[%i0+%o6]0x80,%l6	! %l6 = 126ba6cdf02352b7
p2_b17:
!	%f16 = be9b9915 23fb4170 e2707d3d 1773fce7
!	%f20 = 856556e6 663f3851 a285d8b5 b53c47d4
!	%f24 = a87eaa9c 15f97043 127f51f2 6bd7502d
!	%f28 = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x1c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000198001c0

p2_label_33:
!	%l7 = 22bf19dc308ce411, immed = 00000a38, %l2 = ffffffffffffff83
	sub	%l7,0xa38,%l2		! %l2 = 22bf19dc308cd9d9
!	Mem[0000000071000050] = f9dce001990e6573, %l0 = fffffffffffffde0
	ldx	[%o2+0x050],%l0		! %l0 = f9dce001990e6573
!	Mem[0000000018800138] = 116dd82b, %l6 = 126ba6cdf02352b7
	ldub	[%i1+0x13a],%l6		! %l6 = 00000000000000d8
!	Mem[0000000071000014] = cab52ecb, %l2 = 22bf19dc308cd9d9
	lduh	[%o2+0x016],%l2		! %l2 = 0000000000002ecb
!	Mem[00000000198000d0] = e52ad4fe 967ebf7f, %l2 = 00002ecb, %l3 = 0000004d
	ldd	[%i3+0x0d0],%l2		! %l2 = 00000000e52ad4fe 00000000967ebf7f

p2_label_34:
!	Mem[0000000019800008] = 47ba24b0, %l3 = 00000000967ebf7f
	lduwa	[%i3+%o6]0x80,%l3	! %l3 = 0000000047ba24b0
!	%l0 = f9dce001990e6573, %l6 = 00000000000000d8, %l4 = 000000003af102c4
	orcc	%l0,%l6,%l4		! %l4 = f9dce001990e65fb, %ccr = 88
!	%f16 = be9b9915 23fb4170 e2707d3d 1773fce7
!	%f20 = 856556e6 663f3851 a285d8b5 b53c47d4
!	%f24 = a87eaa9c 15f97043 127f51f2 6bd7502d
!	%f28 = fe6dd9b1 125f7337 034fbe2c bcc4019b
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 0000000019000080
!	Mem[00000000188000c0] = 761d92b3 028f3797 05202aa5 fab49c43
!	Mem[00000000188000d0] = cdbf119e 32aac53d ac3a5839 1dd1ebde
!	Mem[00000000188000e0] = 7c74fa4f f0b0922a 0a3ef6ce af2ee4fa
!	Mem[00000000188000f0] = 8dd0221d f27f08e8 0227420b dccd78d3
	mov	0x0c0,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 00000000188000c0
!	%f4  = d14b3f69 6f8db8e1, %f0  = 3d9817d3 fc2ebbf1
	fnegd	%f4 ,%f0 		! %f0  = 514b3f69 6f8db8e1

p2_label_35:
!	Mem[00000000188001c0] = 928bcc5c a10c235f ba5db460 4809cf74
!	Mem[00000000188001d0] = 315995ea c92773ce 1e263752 bea63299
!	Mem[00000000188001e0] = 8a46e57b 7c0149ec 2771b7ca 74fbbed6
!	Mem[00000000188001f0] = fd96b8b8 1b4149b2 aa64879b e00d983c
	mov	0x1c0,%g4
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000188001c0
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l7 = 22bf19dc308ce411
	ldx	[%o3+0x050],%l7		! %l7 = 2ea7bc867f3d6c55
!	Mem[0000000018800180] = 8dff5460 49afbd2a 36a5cd51 60aaf97e
!	Mem[0000000018800190] = f1821167 343921d6 f973e999 6c9971d3
!	Mem[00000000188001a0] = db347a1a 2389ad9c 33adff83 13cec868
!	Mem[00000000188001b0] = bb96a0f5 74cc77a5 8073d2ef 40706d79
	mov	0x180,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000018800180
!	Mem[0000000019000008] = 3af102c4, %l7 = 2ea7bc867f3d6c55
	lduha	[%i2+%o6]0x80,%l7	! %l7 = 0000000000003af1
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000

p2_label_36:
	membar	#Sync			! Added by membar checker (114)
!	Mem[0000000072000018] = 3f76523c52ce9698, %l5 = 0000000000000000
	ldx	[%o4+0x018],%g2		! %g2 = 3f76523c52ce9698
!	Mem[0000000072000034] = fb7ec7bf, %l1 = dfe43fd7989662c1
	lduw	[%o4+0x034],%g2		! %g2 = dfe43fd7989662c1
!	%l6 = 00000000000000d8, %l1 = dfe43fd7989662c1, %y  = 00000000
	udivx	%l6,%l1,%l4		! %l4 = 0000000000000000
!	Mem[0000000018000008] = 126ba6cd, %l6 = 00000000000000d8
	ldsba	[%i0+%o6]0x80,%l6	! %l6 = 0000000000000012
!	Mem[0000000071000010] = 9d0d6da6cab52ecb, %l3 = 0000000047ba24b0
	ldx	[%o2+0x010],%l3		! %l3 = 9d0d6da6cab52ecb

p2_label_37:
!	Mem[0000000070000050] = dfe43fd7, %l4 = 0000000000000000
	lduba	[%o0+0x052]%asi,%l4	! %l4 = 000000000000003f
!	Mem[0000000070000010] = 8001c1d38cc00000, %l2 = 00000000e52ad4fe
	ldx	[%o0+0x010],%l2		! %l2 = 8001c1d38cc00000
!	Mem[0000000070000050] = dfe43fd7, %l0 = f9dce001990e6573
	ldub	[%o0+0x053],%l0		! %l0 = 00000000000000d7
!	Mem[0000000018000040] = 1191bd8a, %l4 = 000000000000003f
	ldsha	[%i0+0x040]%asi,%l4	! %l4 = 0000000000001191
!	Mem[00000000190000c0] = 60c76462 2df43525 34e61f64 c6a6da7c
!	Mem[00000000190000d0] = a005587c a017f1a9 ab9c8dd5 13376173
!	Mem[00000000190000e0] = 22bf19dc 308ce411 7ca23d80 347b2e8c
!	Mem[00000000190000f0] = 616b1fa2 84efc4dc 824764fc 3ce812c3
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 00000000190000c0

p2_label_38:
	fbu,a,pt %fcc3,p2_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[0000000018000008] = 126ba6cd, %l0 = 00000000000000d7
	ldsha	[%i0+%o6]0x80,%l0	! Annulled
p2_b18:
!	Mem[0000000019000008] = 3af102c4, %l5 = 0000000000000000
	ldsha	[%i2+%o6]0x80,%l5	! %l5 = 0000000000003af1
!	Mem[0000000018000100] = f1bb2efc d317983d b75223f0 cda66b12
!	Mem[0000000018000110] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000018000120] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000018000130] = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x100,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000018000100
!	%f16 = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	%f20 = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f24 = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	%f28 = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x040,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 0000000018000040

p2_label_39:
!	%f4  = d14b3f69, %f11 = c95c830e
	fnegs	%f4 ,%f11		! %f11 = 514b3f69
!	Mem[00000000180000c4] = d317983d, %l1 = dfe43fd7989662c1
	ldsb	[%i0+0x0c5],%l1		! %l1 = 0000000000000017
!	Mem[0000000018000030] = bfc77efb3644e412, %l6 = 0000000000000012
	ldx	[%i0+0x030],%l6		! %l6 = bfc77efb3644e412
!	%l2 = 8001c1d38cc00000
	setx	0x64403e9964403e99,%g7,%l2 ! %l2 = 64403e9964403e99
!	Mem[0000000019800140] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[0000000019800150] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[0000000019800160] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[0000000019800170] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x140,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000019800140

p2_label_40:
!	Mem[0000000071000014] = cab52ecb, %l7 = 0000000000003af1
	lduba	[%o2+0x017]%asi,%l7	! %l7 = 00000000000000cb
!	%l7 = 00000000000000cb, Mem[0000000018800008] = 490d118b
	stwa	%l7,[%i1+%o6]0x80	! Mem[0000000018800008] = 000000cb
!	Mem[00000000198001c0] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[00000000198001d0] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[00000000198001e0] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[00000000198001f0] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x1c0,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 00000000198001c0
!	Mem[0000000019000008] = 3af102c4, %l7 = 00000000000000cb
	ldswa	[%i2+%o6]0x80,%l7	! %l7 = 000000003af102c4
!	Mem[0000000071800010] = d02d0810 0ca96db1, %l0 = 000000d7, %l1 = 00000017
	ldd	[%o3+0x010],%l0		! %l0 = 00000000d02d0810 000000000ca96db1

p2_label_41:
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x040,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000019800040
!	%l7 = 000000003af102c4, %l1 = 000000000ca96db1, %l6 = bfc77efb3644e412
	orcc	%l7,%l1,%l6		! %l6 = 000000003ef96ff5, %ccr = 00
!	Mem[0000000018800008] = 000000cb, %l7 = 000000003af102c4
	lduwa	[%i1+%o6]0x80,%l7	! %l7 = 00000000000000cb
!	Mem[0000000019000008] = 3af102c4, %l1 = 000000000ca96db1
	ldswa	[%i2+%o6]0x80,%l1	! %l1 = 000000003af102c4
!	Mem[0000000019800138] = dc58c451, %l6 = 000000003ef96ff5
	ldsha	[%i3+0x13a]%asi,%l6	! %l6 = ffffffffffffc451

p2_label_42:
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000019000040
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000019000140
!	Mem[0000000018800020] = f838593e49929786, %l4 = 0000000000001191
	ldx	[%i1+0x020],%l4		! %l4 = f838593e49929786
!	Mem[0000000072000064] = 43127f51, %l1 = 000000003af102c4
	lduba	[%o4+0x067]%asi,%g2	! %g2 = 0000000000000043
!	Mem[0000000019000080] = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	Mem[0000000019000090] = 51383f66 e6566585 d4473cb5 b5d885a2
!	Mem[00000000190000a0] = 4370f915 9caa7ea8 2d50d76b f2517f12
!	Mem[00000000190000b0] = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x080,%g4
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 0000000019000080

p2_label_43:
!	Mem[0000000019800140] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[0000000019800150] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[0000000019800160] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[0000000019800170] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x140,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000019800140
!	Mem[0000000072000000] = e1b88d6f 693f4b51 b75223f0 cda66b12
!	Mem[0000000072000010] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000072000020] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000072000030] = 12e44436 fb7ec7bf 0d67e091 519781f0
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[0000000018800040] = 0000808bc33dde41, %l4 = f838593e49929786
	ldx	[%i1+0x040],%l4		! %l4 = 0000808bc33dde41
!	Mem[0000000018000000] = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	Mem[0000000018000010] = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	Mem[0000000018000020] = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	Mem[0000000018000030] = bfc77efb 3644e412 f0819751 91e0670d
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000018000000
!	%f8  = 78f70e2e fe2c8e3f, Mem[0000000071000050] = f9dce001 990e6573
	std	%f8 ,[%o2+0x050]	! Mem[0000000071000050] = 78f70e2e fe2c8e3f

p2_label_44:
!	%f16 = f1bb2efc d317983d b75223f0 cda66b12
!	%f20 = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	%f24 = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	%f28 = 12e44436 fb7ec7bf 0d67e091 519781f0
	stda	%f16,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	%l6 = ffffffffffffc451, %l3 = 9d0d6da6cab52ecb, %l7 = 00000000000000cb
	xnorcc	%l6,%l3,%l7		! %l7 = 9d0d6da6cab51565, %ccr = 88
!	Mem[0000000018000000] = 3d9817d3 fc2ebbf1, %l0 = d02d0810, %l1 = 3af102c4
	ldda	[%i0+%g0]0x80,%l0	! %l0 = 000000003d9817d3 00000000fc2ebbf1
!	Mem[0000000070800054] = 1545e874, %l3 = 9d0d6da6cab52ecb
	ldswa	[%o1+0x054]%asi,%l3	! %l3 = 000000001545e874
!	%f11 = 514b3f69, %f8  = 78f70e2e fe2c8e3f
	fstox	%f11,%f8 		! %f8  = 0000000c b3f69000

p2_label_45:
!	Mem[0000000019000000] = 6b7038f8, %l1 = 00000000fc2ebbf1
	ldswa	[%i2+%g0]0x80,%l1	! %l1 = 000000006b7038f8
	membar	#Sync			! Added by membar checker (115)
!	Mem[0000000072000040] = f1bb2efc d317983d b75223f0 cda66b12
!	Mem[0000000072000050] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000072000060] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000072000070] = 12e44436 fb7ec7bf 0d67e091 519781f0
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000070800050] = 5892f840 1545e874, %l0 = 3d9817d3, %l1 = 6b7038f8
	ldd	[%o1+0x050],%l0		! %l0 = 000000005892f840 000000001545e874
!	%f16 = f1bb2efc d317983d b75223f0 cda66b12
!	%f20 = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	%f24 = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	%f28 = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x180,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000018000180
	membar	#Sync
!	Branch On Register, %l7 = 9d0d6da6cab51565
	brlz,pn	%l7,p2_b19		! Branch Taken

p2_label_46:
!	%l1 = 000000001545e874, %l6 = ffffffffffffc451, %l0 = 000000005892f840
	orncc	%l1,%l6,%l0		! %l0 = 000000001545fbfe, %ccr = 00
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p2_branch_failed
	mov	0x013,%g2
p2_b19:
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x0c0,%g4
	stda	%f0,[%i0+%g4]ASI_BLK_PL	! Block Store to 00000000180000c0
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000190000c0
!	%f16 = f1bb2efc d317983d b75223f0 cda66b12
!	%f20 = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	%f24 = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	%f28 = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x140,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000019800140
!	Mem[0000000018000000] = 3d9817d3, %l2 = 64403e9964403e99
	ldswa	[%i0+%g0]0x80,%l2	! %l2 = 000000003d9817d3

p2_label_47:
	membar	#Sync
	fblg,a,pt %fcc3,p2_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[000000001a000150] = e7213bb653c1c76d, %l4 = 0000808bc33dde41
	ldx	[%i4+0x150],%l4		! Annulled
p2_b20:
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x100,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000019000100
!	Mem[0000000018000000] = 3d9817d3 fc2ebbf1, %l6 = ffffc451, %l7 = cab51565
	ldda	[%i0+%g0]0x80,%l6	! %l6 = 000000003d9817d3 00000000fc2ebbf1

p2_label_48:
!	Mem[00000000188001c0] = 928bcc5c a10c235f ba5db460 4809cf74
!	Mem[00000000188001d0] = 315995ea c92773ce 1e263752 bea63299
!	Mem[00000000188001e0] = 8a46e57b 7c0149ec 2771b7ca 74fbbed6
!	Mem[00000000188001f0] = fd96b8b8 1b4149b2 aa64879b e00d983c
	mov	0x1c0,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f16	! Block Load from 00000000188001c0
!	%l4 = 0000808bc33dde41, immed = 000007c0, %l6 = 000000003d9817d3
	orncc	%l4,0x7c0,%l6		! %l6 = fffffffffffffe7f, %ccr = 88
!	Mem[0000000018800008] = 000000cb, %l3 = 000000001545e874
	ldsba	[%i1+%o6]0x80,%l3	! %l3 = 0000000000000000
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x140,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000019800140
!	%f16 = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	%f20 = ce7327c9 ea955931 9932a6be 5237261e
!	%f24 = ec49017c 7be5468a d6befb74 cab77127
!	%f28 = b249411b b8b896fd 3c980de0 9b8764aa
	stda	%f16,[%i1+%g4]ASI_BLK_PL	! Block Store to 0000000018800140

p2_label_49:
!	Mem[0000000018000008] = 126ba6cd, %l5 = 0000000000003af1
	lduha	[%i0+%o6]0x80,%l5	! %l5 = 000000000000126b
!	%l2 = 000000003d9817d3, Mem[0000000018800008] = 000000cbb416244d
	stxa	%l2,[%i1+%o6]0x80	! Mem[0000000018800008] = 000000003d9817d3
!	Mem[0000000019000148] = e7fc73173d7d70e2, %l3 = 0000000000000000
	ldxa	[%i2+0x148]%asi,%l3	! %l3 = e7fc73173d7d70e2
!	%l0 = 000000001545fbfe, immed = 0000001f, %l0 = 000000001545fbfe
	sll	%l0,0x01f,%l0		! %l0 = 0aa2fdff00000000
	membar	#Sync
	fbug,a,pt %fcc2,p2_branch_failed	! Branch Not Taken, %fcc2 = 0

p2_label_50:
!	Mem[0000000019800000] = 0000d0cf, %l0 = 0aa2fdff00000000
	lduba	[%i3+%g0]0x80,%l0	! Annulled
p2_b21:
!	Mem[0000000019000174] = b1d96dfe, %l2 = 000000003d9817d3
	ldsba	[%i2+0x174]%asi,%l2	! %l2 = ffffffffffffffb1
!	Mem[0000000072000058] = 3f76523c52ce9698, %l2 = ffffffffffffffb1
	ldx	[%o4+0x058],%g2		! %g2 = 3f76523c52ce9698
	set	p2_b22,%o7
	fbule,a,pn %fcc0,p2_near_0_he	! Branch Taken, %fcc0 = 0
!	Mem[000000007200002c] = 3f69bfc7, %l3 = e7fc73173d7d70e2
	ldsh	[%o4+0x02e],%g2		! %g2 = 0000000000003f69
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x016,%g2
p2_b22:
!	Registers modified during the branch to p2_near_0
!	%l4  = 000000007f3d6c55
!	%l5  = 2771b7ca74fbbed6
!	%l6  = 0000000000000000
!	%l7  = 000000000000004d

p2_label_51:
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x0c0,%g6
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000188000c0
!	%f16 = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	%f20 = ce7327c9 ea955931 9932a6be 5237261e
!	%f24 = ec49017c 7be5468a d6befb74 cab77127
!	%f28 = b249411b b8b896fd 3c980de0 9b8764aa
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 0000000018800140
!	Mem[0000000019800170] = bfc77efb3644e412, %l4 = 000000007f3d6c55
	ldx	[%i3+0x170],%l4		! %l4 = bfc77efb3644e412
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%i6+%g5]ASI_BLK_PL	! Block Store to 000000001b000180
!	Mem[00000000180000b4] = edc1c7c7, %l0 = 0aa2fdff00000000
	lduwa	[%i0+0x0b4]%asi,%l0	! %l0 = 00000000edc1c7c7

p2_label_52:
!	%f0  = 514b3f69 6f8db8e1 126ba6cd f02352b7
!	%f4  = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	%f8  = 0000000c b3f69000 09258c43 514b3f69
!	%f12 = bfc77efb 3644e412 f0819751 91e0670d
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000019000180
!	Mem[0000000070800050] = 5892f8401545e874, %l3 = e7fc73173d7d70e2
	ldxa	[%o1+0x050]%asi,%l3	! %l3 = 5892f8401545e874
!	%l7 = 000000000000004d, %l3 = 5892f8401545e874, %l0 = 00000000edc1c7c7
	orcc	%l7,%l3,%l0		! %l0 = 5892f8401545e87d, %ccr = 00
!	Mem[0000000072000004] = 6f8db8e1, %l5 = 2771b7ca74fbbed6
	lduba	[%o4+0x004]%asi,%g2	! %g2 = 000000000000006f
!	%l3 = 5892f8401545e874, Mem[000000001a800008] = 59a38a8b5fc2657e
	stxa	%l3,[%i5+%o6]0x80	! Mem[000000001a800008] = 5892f8401545e874

p2_label_53:
!	Mem[0000000019800010] = 70192ade, %l0 = 5892f8401545e87d
	ldsh	[%i3+0x010],%l0		! %l0 = 0000000000007019
!	Mem[0000000071000054] = fe2c8e3f, %l1 = 000000001545e874
	lduw	[%o2+0x054],%l1		! %l1 = 00000000fe2c8e3f
!	Mem[0000000018000070] = bfc77efb3644e412, %l7 = 000000000000004d
	ldx	[%i0+0x070],%l7		! %l7 = bfc77efb3644e412
!	Mem[0000000018800000] = 700332f8 a569f230, %l0 = 00007019, %l1 = fe2c8e3f
	ldda	[%i1+%g0]0x80,%l0	! %l0 = 00000000700332f8 00000000a569f230
	membar	#Sync
	be,a	p2_not_taken_0		! Branch Not Taken, %ccr = 00

p2_label_54:
!	 Annulled
	ldd	[%i0+0x108],%l6
p2_b23:
!	%f23 = 5237261e, %f20 = ce7327c9, %f18 = 74cf0948 60b45dba
	fsmuld	%f23,%f20,%f18		! %f18 = c425beb4 a2aff1c0
!	Mem[00000000190001c0] = a7a85772 dafc1653 8d5fe119 eb6a7654
!	Mem[00000000190001d0] = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	Mem[00000000190001e0] = 4260713d aa961a27 dc92015f 61faada2
!	Mem[00000000190001f0] = 1b0a271c bedc3150 24e9c881 a16ff7a5
	mov	0x1c0,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 00000000190001c0
!	Mem[0000000018800000] = 700332f8, %l7 = bfc77efb3644e412
	lduha	[%i1+%g0]0x80,%l7	! %l7 = 0000000000007003
!	Mem[000000001a800080] = f618eaed 49881c80 c7dad5d5 ce2cf049
!	Mem[000000001a800090] = 94dceda1 4de083a1 20012b75 917b2c47
!	Mem[000000001a8000a0] = 3e2fec4c efd73079 f2d5da88 e3e92f58
!	Mem[000000001a8000b0] = b47d86a8 efa682d9 eb51b6e4 bc9e1d3a
	mov	0x080,%g5
	ldda	[%i5+%g5]ASI_BLK_P,%f16	! Block Load from 000000001a800080

p2_label_55:
!	%f16 = f618eaed 49881c80 c7dad5d5 ce2cf049
!	%f20 = 94dceda1 4de083a1 20012b75 917b2c47
!	%f24 = 3e2fec4c efd73079 f2d5da88 e3e92f58
!	%f28 = b47d86a8 efa682d9 eb51b6e4 bc9e1d3a
	mov	0x1c0,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000190001c0
!	%l6 = 0000000000000000, %l4 = bfc77efb3644e412, %l1 = 00000000a569f230
	tsubcc	%l6,%l4,%l1		! %l1 = 40388104c9bb1bee, %ccr = 1b
!	Mem[0000000070000010] = 8001c1d38cc00000, %l1 = 40388104c9bb1bee
	ldxa	[%o0+0x010]%asi,%l1	! %l1 = 8001c1d38cc00000
!	Mem[0000000019800008] = 47ba24b0, %l5 = 2771b7ca74fbbed6
	lduba	[%i3+%o6]0x80,%l5	! %l5 = 0000000000000047
!	Mem[0000000070000054] = 989662c1, %l7 = 0000000000007003
	lduw	[%o0+0x054],%l7		! %l7 = 00000000989662c1

p2_label_56:
!	Mem[0000000072000050] = e1b88d6f693f4bd1, %l3 = 5892f8401545e874
	ldx	[%o4+0x050],%g2		! %g2 = e1b88d6f693f4bd1
!	Mem[0000000019800070] = fe6dd9b1 125f7337, %l6 = 00000000, %l7 = 989662c1
	ldd	[%i3+0x070],%l6		! %l6 = 00000000fe6dd9b1 00000000125f7337
!	Mem[0000000072000010] = d14b3f696f8db8e1, %l1 = 8001c1d38cc00000
	ldxa	[%o4+0x010]%asi,%g2	! %g2 = d14b3f696f8db8e1
!	%f0  = a7a85772 dafc1653 8d5fe119 eb6a7654
!	%f4  = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	%f8  = 4260713d aa961a27 dc92015f 61faada2
!	%f12 = 1b0a271c bedc3150 24e9c881 a16ff7a5
	mov	0x100,%g5
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000019000100
!	Mem[00000000180000ec] = 438c2509, %l1 = 8001c1d38cc00000
	ldsh	[%i0+0x0ee],%l1		! %l1 = 0000000000002509

p2_label_57:
!	Mem[0000000070000050] = dfe43fd7, %l1 = 0000000000002509
	ldsha	[%o0+0x050]%asi,%l1	! %l1 = ffffffffffffdfe4
!	Mem[0000000070000010] = 8001c1d38cc00000, %l3 = 5892f8401545e874
	ldx	[%o0+0x010],%l3		! %l3 = 8001c1d38cc00000
!	Mem[0000000071000054] = fe2c8e3f, %l1 = ffffffffffffdfe4
	ldsba	[%o2+0x056]%asi,%l1	! %l1 = ffffffffffffff8e
!	Mem[0000000072000040] = f1bb2efc d317983d b75223f0 cda66b12
!	Mem[0000000072000050] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000072000060] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000072000070] = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x040,%g4
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
	fbl,a,pn %fcc3,p2_branch_failed	! Branch Not Taken, %fcc3 = 0

p2_label_58:
!	%f21 = 4de083a1, %f6  = 9cd950a7 3fe7d57b
	fitod	%f21,%f6 	! Annulled
p2_b24:
!	Mem[0000000019800010] = 70192ade78266912, %l6 = 00000000fe6dd9b1
	ldx	[%i3+0x010],%l6		! %l6 = 70192ade78266912
	bleu,a	p2_b25			! Branch Taken, %ccr = 1b, CWP = 0
!	Mem[0000000018000088] = 75097ae7 4e60f18f, %l0 = 700332f8, %l1 = ffffff8e
	ldd	[%i0+0x088],%l0		! %l0 = 0000000075097ae7 000000004e60f18f
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x019,%g2
p2_b25:
!	Mem[0000000018800000] = 700332f8 a569f230 00000000 3d9817d3
	prefetcha [%i1+0x000]%asi,21

p2_label_59:
!	Mem[0000000018800140] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000018800150] = ce7327c9 ea955931 9932a6be 5237261e
!	Mem[0000000018800160] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000018800170] = b249411b b8b896fd 3c980de0 9b8764aa
	mov	0x140,%g4
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018800140
	membar	#Sync			! Added by membar checker (116)
	set	p2_b26,%o7
	fbuge,pt %fcc2,p2_near_2_le	! Branch Taken, %fcc2 = 0
!	Mem[00000000198000d8] = c62e3c6f3a316bfe, %l0 = 0000000075097ae7
	ldx	[%i3+0x0d8],%l0		! %l0 = c62e3c6f3a316bfe
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x01a,%g2
p2_b26:
!	Registers modified during the branch to p2_near_2
!	%l2  = 000000000000004d
!	%l4  = fd96b8b81b4149b2
!	%l6  = 0000000000001545
!	%l7  = fffffffffffffffe
!	Mem[0000000071800010] = d02d08100ca96db1, %l2 = 000000000000004d
	ldx	[%o3+0x010],%l2		! %l2 = d02d08100ca96db1
!	%f16 = 928bcc5c a10c235f ba5db460 4809cf74
!	%f20 = 315995ea c92773ce 1e263752 bea63299
!	%f24 = 8a46e57b 7c0149ec 2771b7ca 74fbbed6
!	%f28 = fd96b8b8 1b4149b2 aa64879b e00d983c
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000190000c0

p2_label_60:
!	%f0  = a7a85772 dafc1653 8d5fe119 eb6a7654
!	%f4  = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	%f8  = 4260713d aa961a27 dc92015f 61faada2
!	%f12 = 1b0a271c bedc3150 24e9c881 a16ff7a5
	mov	0x180,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000019800180
!	Mem[0000000019800008] = 47ba24b0, %l7 = fffffffffffffffe
	lduwa	[%i3+%o6]0x80,%l7	! %l7 = 0000000047ba24b0
!	Mem[0000000019800000] = 0000d0cf, %l2 = d02d08100ca96db1
	lduha	[%i3+%g0]0x80,%l2	! %l2 = 0000000000000000
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l0 = c62e3c6f3a316bfe
	ldx	[%o3+0x050],%l0		! %l0 = 2ea7bc867f3d6c55
!	Mem[0000000018000180] = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	Mem[0000000018000190] = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	Mem[00000000180001a0] = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	Mem[00000000180001b0] = bfc77efb 3644e412 f0819751 91e0670d
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000018000180

p2_label_61:
!	%l2 = 0000000000000000, %l7 = 0000000047ba24b0, %y  = 00000187
	mulx	%l2,%l7,%l4		! %l4 = 0000000000000000
!	Mem[0000000071800054] = 7f3d6c55, %l5 = 0000000000000047
	lduh	[%o3+0x054],%l5		! %l5 = 0000000000007f3d
!	%l1 = 000000004e60f18f, Mem[0000000019000000] = 6b7038f8
	stha	%l1,[%i2+%g0]0x80	! Mem[0000000019000000] = f18f38f8
!	%f20 = 315995ea, Mem[0000000071800014] = 0ca96db1
	st	%f20,[%o3+0x014]	! Mem[0000000071800014] = 315995ea
!	%f28 = fd96b8b8, %f20 = 315995ea c92773ce
	fstod	%f28,%f20		! %f20 = c7b2d717 00000000

p2_label_62:
!	%l7 = 0000000047ba24b0, immed = 00000e7f, %l3 = 8001c1d38cc00000
	orcc	%l7,0xe7f,%l3		! %l3 = 0000000047ba2eff, %ccr = 00
!	Mem[0000000018800130] = e5347cd8, %l5 = 0000000000007f3d
	lduwa	[%i1+0x130]%asi,%l5	! %l5 = 00000000e5347cd8
!	Mem[0000000018800140] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000018800150] = ce7327c9 ea955931 9932a6be 5237261e
!	Mem[0000000018800160] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000018800170] = b249411b b8b896fd 3c980de0 9b8764aa
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 0000000018800140
!	%l0 = 2ea7bc867f3d6c55, immed = 000007a4, %l3 = 0000000047ba2eff
	xorcc	%l0,0x7a4,%l3		! %l3 = 2ea7bc867f3d6bf1, %ccr = 00
!	Mem[00000000198000c0] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[00000000198000d0] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000198000e0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000198000f0] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 00000000198000c0

p2_label_63:
	membar	#Sync			! Added by membar checker (117)
	set	p2_b27,%o7
	fbue,a	p2_far_1_he		! Branch Taken, %fcc0 = 0
!	%l1 = 000000004e60f18f, immed = 0000059e, %y  = 00000187
	sdivx	%l1,0x59e,%l1		! %l1 = 00000000000df40f
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x01b,%g2
p2_b27:
!	Registers modified during the branch to p2_far_1
!	%l2  = 9d0d6da6cab52ecb
!	%l3  = ffffffffffffffb7
!	Mem[00000000198000a0] = 78f70e2e fe2c8e3f, %l2 = cab52ecb, %l3 = ffffffb7
	ldda	[%i3+0x0a0]%asi,%l2	! %l2 = 0000000078f70e2e 00000000fe2c8e3f
!	Mem[00000000190000a8] = 2d50d76b f2517f12, %l6 = 00001545, %l7 = 47ba24b0
	ldda	[%i2+0x0a8]%asi,%l6	! %l6 = 000000002d50d76b 00000000f2517f12
!	Mem[0000000019800048] = e2707d3d, %l3 = 00000000fe2c8e3f
	lduh	[%i3+0x048],%l3		! %l3 = 000000000000e270

p2_label_64:
	ba	p2_b28			! Branch Taken, %ccr = 00, CWP = 0
!	Mem[0000000018000000] = 3d9817d3, %l2 = 0000000078f70e2e
	lduba	[%i0+%g0]0x80,%l2	! %l2 = 000000000000003d
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x01c,%g2
p2_b28:
!	Mem[0000000071800050] = 2ea7bc86, %l0 = 2ea7bc867f3d6c55
	ldsb	[%o3+0x053],%l0		! %l0 = ffffffffffffff86
!	Mem[00000000198001c0] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[00000000198001d0] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[00000000198001e0] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[00000000198001f0] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x1c0,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f0	! Block Load from 00000000198001c0
	fbg,a,pt %fcc2,p2_branch_failed	! Branch Not Taken, %fcc2 = 0

p2_label_65:
!	Mem[0000000019800108] = 30fdef990ef12f86, %l3 = 000000000000e270
	ldx	[%i3+0x108],%l3		! Annulled
p2_b29:
!	%f16 = 928bcc5c a10c235f ba5db460 4809cf74
!	%f20 = c7b2d717 00000000 1e263752 bea63299
!	%f24 = 8a46e57b 7c0149ec 2771b7ca 74fbbed6
!	%f28 = fd96b8b8 1b4149b2 aa64879b e00d983c
	mov	0x040,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000018000040
!	%f0  = be9b9915 23fb4170 e2707d3d 1773fce7
!	%f4  = 856556e6 663f3851 a285d8b5 b53c47d4
!	%f8  = a87eaa9c 15f97043 127f51f2 6bd7502d
!	%f12 = fe6dd9b1 125f7337 034fbe2c bcc4019b
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000019000040
!	%f16 = 928bcc5c a10c235f, %f16 = 928bcc5c a10c235f
	fmovd	%f16,%f16		! %f16 = 928bcc5c a10c235f
!	Mem[0000000018800000] = 700332f8, %l4 = 0000000000000000
	lduha	[%i1+%g0]0x80,%l4	! %l4 = 0000000000007003

p2_label_66:
!	Mem[0000000018800020] = f838593e49929786, %l2 = 000000000000003d
	ldx	[%i1+0x020],%l2		! %l2 = f838593e49929786
!	%f0  = be9b9915 23fb4170 e2707d3d 1773fce7
!	%f4  = 856556e6 663f3851 a285d8b5 b53c47d4
!	%f8  = a87eaa9c 15f97043 127f51f2 6bd7502d
!	%f12 = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x100,%g5
	stda	%f0,[%i6+%g5]ASI_BLK_P	! Block Store to 000000001b000100
	membar	#Sync			! Added by membar checker (118)
!	Mem[0000000018000058] = 9932a6be, %l2 = f838593e49929786
	ldswa	[%i0+0x058]%asi,%l2	! %l2 = ffffffff9932a6be
!	Mem[0000000018000080] = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	Mem[0000000018000090] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[00000000180000a0] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[00000000180000b0] = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x080,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 0000000018000080
!	Mem[000000001b000100] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[000000001b000110] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[000000001b000120] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[000000001b000130] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x100,%g5
	ldda	[%i6+%g5]ASI_BLK_P,%f16	! Block Load from 000000001b000100

p2_label_67:
!	Mem[0000000019000010] = 8001c1d3, %l5 = 00000000e5347cd8
	ldswa	[%i2+0x010]%asi,%l5	! %l5 = ffffffff8001c1d3
!	Mem[0000000018800000] = 700332f8, %l6 = 000000002d50d76b
	lduba	[%i1+%g0]0x80,%l6	! %l6 = 0000000000000070
!	%f3  = 4e60f18f, %f3  = 4e60f18f, %f13 = edc1c7c7
	fsubs	%f3 ,%f3 ,%f13		! %f13 = 00000000
!	%l1 = 00000000000df40f, %l5 = ffffffff8001c1d3, %l2 = ffffffff9932a6be
	andcc	%l1,%l5,%l2		! %l2 = 000000000001c003, %ccr = 00
!	%f0  = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	%f4  = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	%f8  = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	%f12 = 13748c4b 00000000 99ad8d85 40accca8
	mov	0x040,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000019800040

p2_label_68:
!	Mem[00000000180000c0] = e1b88d6f 693f4b51 b75223f0 cda66b12
!	Mem[00000000180000d0] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[00000000180000e0] = 0090f6b3 0c000000 693f4b51 438c2509
!	Mem[00000000180000f0] = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x0c0,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 00000000180000c0
!	%f20 = 856556e6 663f3851, %f20 = 856556e6 663f3851, %f30 = 034fbe2c bcc4019b
	faddd	%f20,%f20,%f30		! %f30 = 857556e6 663f3851
	membar	#Sync			! Added by membar checker (119)
	set	p2_b30,%o7
	fble	p2_far_1_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000018000000] = 3d9817d3 fc2ebbf1, %l0 = ffffff86, %l1 = 000df40f
	ldda	[%i0+%g0]0x80,%l0	! %l0 = 000000003d9817d3 00000000fc2ebbf1
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x01e,%g2
p2_b30:
!	Registers modified during the branch to p2_far_1
!	%l2  = 9d0d6da6cab52ecb
!	%l3  = ffffffffffffffb7
!	Mem[0000000019800008] = 47ba24b0, %l2 = 9d0d6da6cab52ecb
	lduba	[%i3+%o6]0x80,%l2	! %l2 = 0000000000000047

p2_label_69:
!	Mem[0000000072000070] = 12e44436, %l3 = ffffffffffffffb7
	ldsw	[%o4+0x070],%g2		! %g2 = ffffffffffffffb7
!	Mem[0000000071000010] = 9d0d6da6cab52ecb, %l5 = ffffffff8001c1d3
	ldx	[%o2+0x010],%l5		! %l5 = 9d0d6da6cab52ecb
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000071800014] = 315995ea, %l7 = 00000000f2517f12
	lduba	[%o3+0x017]%asi,%l7	! %l7 = 00000000000000ea
!	Mem[0000000070800010] = 00000000, %l7 = 00000000000000ea
	ldsha	[%o1+0x010]%asi,%l7	! %l7 = 0000000000000000

p2_label_70:
	fbug	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%l6 = 0000000000000070, %l4 = 0000000000007003, %l5 = 9d0d6da6cab52ecb
	andcc	%l6,%l4,%l5		! %l5 = 0000000000000000, %ccr = 44
p2_b31:
!	%l1 = 00000000fc2ebbf1, %l6 = 0000000000000070, %l1 = 00000000fc2ebbf1
	xor	%l1,%l6,%l1		! %l1 = 00000000fc2ebb81
!	Mem[0000000019000000] = f18f38f8887de454, %l6 = 0000000000000070
	ldxa	[%i2+%g0]0x80,%l6	! %l6 = f18f38f8887de454
!	Mem[0000000019800040] = 0cd48cac 4d21d980 8ff1604e e77a0975
!	Mem[0000000019800050] = a9fde95e db41c0a5 080fda8b eeaac6c7
!	Mem[0000000019800060] = 2d2517bf ca799dff 031df97c f6051aca
!	Mem[0000000019800070] = 00000000 4b8c7413 a8ccac40 858dad99
	mov	0x040,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 0000000019800040

p2_label_71:
!	Mem[0000000019800180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019800190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000198001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000198001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000019800180
	fbul,pn	%fcc2,p2_branch_failed	! Branch Not Taken, %fcc2 = 0
!	%l5 = 0000000000000000, %l2 = 0000000000000047, %l0 = 000000003d9817d3
	or	%l5,%l2,%l0		! %l0 = 0000000000000047
p2_b32:
!	Mem[0000000018000004] = fc2ebbf1, %l6 = f18f38f8887de454
	lduwa	[%i0+0x004]%asi,%l6	! %l6 = 00000000fc2ebbf1
!	Mem[0000000018800008] = 00000000, %l5 = 0000000000000000
	ldswa	[%i1+%o6]0x80,%l5	! %l5 = 0000000000000000

p2_label_72:
	membar	#Sync			! Added by membar checker (120)
	set	p2_b33,%o7
	fbule	p2_far_0_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000018000118] = 3f76523c52ce9698, %l0 = 0000000000000047
	ldx	[%i0+0x118],%l0		! %l0 = 3f76523c52ce9698
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x021,%g2
p2_b33:
!	Registers modified during the branch to p2_far_0
!	%l2  = ffffffffffffffbc
!	%l5  = 00000000fc2ebb81
!	%l6  = d02d0810315995ea
!	Mem[0000000018000198] = 9896ce52, %l2 = ffffffffffffffbc
	ldswa	[%i0+0x198]%asi,%l2	! %l2 = ffffffff9896ce52
!	Mem[0000000018000070] = b249411bb8b896fd, %l5 = 00000000fc2ebb81
	ldx	[%i0+0x070],%l5		! %l5 = b249411bb8b896fd
!	%l4 = 0000000000007003, Mem[0000000070000014] = 8cc00000
	stwa	%l4,[%o0+0x014]%asi	! Mem[0000000070000014] = 00007003

p2_label_73:
!	Mem[000000001880009c] = 3a316bfe, %l6 = d02d0810315995ea
	lduha	[%i1+0x09e]%asi,%l6	! %l6 = 0000000000006bfe
!	Mem[0000000018000000] = 3d9817d3 fc2ebbf1, %l4 = 00007003, %l5 = b8b896fd
	ldda	[%i0+%g0]0x80,%l4	! %l4 = 000000003d9817d3 00000000fc2ebbf1
!	%f16 = a7a85772 dafc1653 8d5fe119 eb6a7654
!	%f20 = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	%f24 = 4260713d aa961a27 dc92015f 61faada2
!	%f28 = 1b0a271c bedc3150 24e9c881 a16ff7a5
	mov	0x100,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000019000100
!	Mem[0000000072000060] = 3f8e2cfe2e0ef778, %l4 = 000000003d9817d3
	ldx	[%o4+0x060],%g2		! %g2 = 3f8e2cfe2e0ef778
!	Mem[00000000190000b8] = 9b01c4bc 2cbe4f03, %l2 = 9896ce52, %l3 = ffffffb7
	ldda	[%i2+0x0b8]%asi,%l2	! %l2 = 000000009b01c4bc 000000002cbe4f03

p2_label_74:
	bn	p2_not_taken_0		! Branch Not Taken, %ccr = 44
!	Mem[0000000018800000] = 700332f8, %l3 = 000000002cbe4f03
	ldsha	[%i1+%g0]0x80,%l3	! %l3 = 0000000000007003
p2_b34:
!	Mem[0000000072000040] = f1bb2efc d317983d b75223f0 cda66b12
!	Mem[0000000072000050] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000072000060] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000072000070] = 12e44436 fb7ec7bf 0d67e091 519781f0
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000070000010] = 8001c1d300007003, %l4 = 000000003d9817d3
	ldxa	[%o0+0x010]%asi,%l4	! %l4 = 8001c1d300007003
!	Mem[0000000072000000] = 55e7ff25 b002efcc 7c541d25 27b6bf86
!	Mem[0000000072000010] = 7c8c790f cff2a0d9 895d6632 d1cf14b5
!	Mem[0000000072000020] = 080aedab 3b546019 81795b2a fc9924cb
!	Mem[0000000072000030] = 30eb6c4b a17b4f79 2306f396 ba50e8b5
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000

p2_label_75:
!	Mem[0000000072000040] = f1bb2efc d317983d b75223f0 cda66b12
!	Mem[0000000072000050] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[0000000072000060] = 3f8e2cfe 2e0ef778 0e835cc9 438c2509
!	Mem[0000000072000070] = 12e44436 fb7ec7bf 0d67e091 519781f0
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l4 = 8001c1d300007003
	ldx	[%o3+0x050],%l4		! %l4 = 2ea7bc867f3d6c55
!	%f0  = 0cd48cac 4d21d980 8ff1604e e77a0975
!	%f4  = a9fde95e db41c0a5 080fda8b eeaac6c7
!	%f8  = 2d2517bf ca799dff 031df97c f6051aca
!	%f12 = 00000000 4b8c7413 a8ccac40 858dad99
	mov	0x0c0,%g5
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 00000000190000c0
!	Mem[0000000070800014] = 0000004d, %l4 = 2ea7bc867f3d6c55
	swap	[%o1+0x014],%l4		! %l4 = 000000000000004d
	membar	#Sync			! Added by membar checker (121)
!	Mem[0000000019800140] = 514b3f69 6f8db8e1 126ba681 f02352b7
!	Mem[0000000019800150] = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	Mem[0000000019800160] = 0000000c b3f69000 09258c43 514b3f69
!	Mem[0000000019800170] = bfc77efb 3644e412 f0819751 91e0670d
	ldda	[%i3+%g4]ASI_BLK_P,%f16	! Block Load from 0000000019800140

p2_label_76:
!	Mem[0000000018800008] = 000000003d9817d3, %l0 = 3f76523c52ce9698
	ldxa	[%i1+%o6]0x80,%l0	! %l0 = 000000003d9817d3
!	%f0  = 0cd48cac 4d21d980 8ff1604e e77a0975
!	%f4  = a9fde95e db41c0a5 080fda8b eeaac6c7
!	%f8  = 2d2517bf ca799dff 031df97c f6051aca
!	%f12 = 00000000 4b8c7413 a8ccac40 858dad99
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 0000000019000040
!	Mem[0000000071000050] = 78f70e2efe2c8e3f, %l5 = 00000000fc2ebbf1
	ldx	[%o2+0x050],%l5		! %l5 = 78f70e2efe2c8e3f
!	Mem[0000000019800180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019800190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000198001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000198001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 0000000019800180
!	Mem[0000000018800110] = 127b3eef, %l4 = 000000000000004d
	ldsh	[%i1+0x110],%l4		! %l4 = 000000000000127b

p2_label_77:
!	Mem[0000000019000000] = f18f38f8887de454, %l3 = 0000000000007003
	ldxa	[%i2+%g0]0x80,%l3	! %l3 = f18f38f8887de454
!	Mem[00000000190001c0] = f618eaed 49881c80 c7dad5d5 ce2cf049
!	Mem[00000000190001d0] = 94dceda1 4de083a1 20012b75 917b2c47
!	Mem[00000000190001e0] = 3e2fec4c efd73079 f2d5da88 e3e92f58
!	Mem[00000000190001f0] = b47d86a8 efa682d9 eb51b6e4 bc9e1d3a
	mov	0x1c0,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 00000000190001c0
!	%f16 = f618eaed 49881c80 c7dad5d5 ce2cf049
!	%f20 = 94dceda1 4de083a1 20012b75 917b2c47
!	%f24 = 3e2fec4c efd73079 f2d5da88 e3e92f58
!	%f28 = b47d86a8 efa682d9 eb51b6e4 bc9e1d3a
	mov	0x100,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 0000000018000100
!	Mem[00000000198001f4] = 125f7337, %l0 = 000000003d9817d3
	lduwa	[%i3+0x1f4]%asi,%l0	! %l0 = 00000000125f7337
!	Mem[0000000019800080] = 3d9817d3fc2ebbf1, %l5 = 78f70e2efe2c8e3f
	ldx	[%i3+0x080],%l5		! %l5 = 3d9817d3fc2ebbf1

p2_label_78:
!	Mem[0000000071800010] = d02d0810, %l2 = 000000009b01c4bc
	ldsb	[%o3+0x010],%l2		! %l2 = ffffffffffffffd0
!	%l2 = ffffffffffffffd0, immed = 00000eb7, %l4 = 000000000000127b
	xorcc	%l2,0xeb7,%l4		! %l4 = fffffffffffff167, %ccr = 88
	membar	#Sync			! Added by membar checker (122)
!	Mem[0000000019000040] = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	Mem[0000000019000050] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[0000000019000060] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[0000000019000070] = 13748c4b 00000000 99ad8d85 40accca8
	mov	0x040,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000019000040
!	Mem[00000000198000c0] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[00000000198000d0] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000198000e0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000198000f0] = d852663a 841fa94d 012e213e bb7139a6
	mov	0x0c0,%g4
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 00000000198000c0
!	%l4 = fffffffffffff167, immed = 00000a6d, %l5 = 3d9817d3fc2ebbf1
	addcc	%l4,0xa6d,%l5		! %l5 = fffffffffffffbd4, %ccr = 88

p2_label_79:
!	Mem[0000000018800040] = 0000808b c33dde41 f94f59f8 fc163c57
!	Mem[0000000018800050] = 1f17d764 d83c1332 0c595bec b83bd987
!	Mem[0000000018800060] = 74e84515 40f89258 7fe42e50 9d642253
!	Mem[0000000018800070] = 18fece23 810a395f d1de98ce 2b5953d3
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 0000000018800040
!	%f0  = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	%f4  = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	%f8  = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	%f12 = d852663a 841fa94d 012e213e bb7139a6
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000019800040
	membar	#Sync
!	Branch On Register, %l5 = fffffffffffffbd4
	brlz,pt	%l5,p2_b35		! Branch Taken
!	%l2 = ffffffffffffffd0, immed = 00000c23, %l2 = ffffffffffffffd0
	xnor	%l2,0xc23,%l2		! %l2 = 0000000000000c0c
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p2_branch_failed
	mov	0x023,%g2
p2_b35:
!	%f0  = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	%f4  = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	%f8  = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	%f12 = d852663a 841fa94d 012e213e bb7139a6
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 0000000018000000

p2_label_80:
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l1 = 00000000fc2ebb81
	ldx	[%o3+0x050],%l1		! %l1 = 2ea7bc867f3d6c55
!	Mem[0000000019000000] = f18f38f8887de454, %l4 = fffffffffffff167
	ldxa	[%i2+%g0]0x80,%l4	! %l4 = f18f38f8887de454
	membar	#Sync			! Added by membar checker (123)
	set	p2_b36,%o7
	fbule,a,pt %fcc1,p2_near_0_he	! Branch Taken, %fcc1 = 0
!	Mem[0000000070000010] = 8001c1d300007003, %l7 = 0000000000000000
	ldx	[%o0+0x010],%l7		! %l7 = 8001c1d300007003
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p2_branch_failed
	mov	0x024,%g2
p2_b36:
!	Registers modified during the branch to p2_near_0
!	%l4  = 000000007f3d6c55
!	%l5  = d6befb74cab77127
!	%l6  = 0000000000000000
!	%l7  = 000000007f3d6c55
!	Mem[0000000018000188] = 126ba6cd, %l0 = 00000000125f7337
	ldswa	[%i0+0x188]%asi,%l0	! %l0 = 00000000126ba6cd

p2_label_81:
!	Mem[0000000019800008] = 47ba24b0, %l3 = f18f38f8887de454
	ldsha	[%i3+%o6]0x80,%l3	! %l3 = 00000000000047ba
!	Mem[0000000019000000] = f18f38f8, %l3 = 00000000000047ba
	lduwa	[%i2+%g0]0x80,%l3	! %l3 = 00000000f18f38f8
!	%f0  = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	%f4  = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	%f8  = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	%f12 = d852663a 841fa94d 012e213e bb7139a6
	stda	%f0,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
!	%l4 = 000000007f3d6c55, %l7 = 000000007f3d6c55, %l3 = 00000000f18f38f8
	subc	%l4,%l7,%l3		! %l3 = 0000000000000000
!	%f16 = 0000808b c33dde41 f94f59f8 fc163c57
!	%f20 = 1f17d764 d83c1332 0c595bec b83bd987
!	%f24 = 74e84515 40f89258 7fe42e50 9d642253
!	%f28 = 18fece23 810a395f d1de98ce 2b5953d3
	mov	0x140,%g4
	stda	%f16,[%i5+%g4]ASI_BLK_P	! Block Store to 000000001a800140

p2_label_82:
!	Mem[0000000019000018] = 682500b5 40f69cdf, %l6 = 00000000, %l7 = 7f3d6c55
	ldd	[%i2+0x018],%l6		! %l6 = 00000000682500b5 0000000040f69cdf
!	Mem[00000000190000c0] = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	Mem[00000000190000d0] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[00000000190000e0] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[00000000190000f0] = 13748c4b 00000000 99ad8d85 40accca8
	mov	0x0c0,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 00000000190000c0
	membar	#Sync			! Added by membar checker (124)
	set	p2_b37,%o7
	fbo,a	p2_far_1_le		! Branch Taken, %fcc0 = 0
!	%l4 = 000000007f3d6c55, immed = fffffb88, %l3 = 0000000000000000
	orn	%l4,-0x478,%l3		! %l3 = 000000007f3d6c77
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x025,%g2
p2_b37:
!	Registers modified during the branch to p2_far_1
!	%l0  = 000000009d0d6da6
!	%l4 = 000000007f3d6c55, %l1 = 2ea7bc867f3d6c55, %y  = fffffded
	umul	%l4,%l1,%l7		! %l7 = 3f3e00392459d439

p2_label_83:
!	Mem[0000000018000184] = fc2ebbf1, %l0 = 000000009d0d6da6
	ldsw	[%i0+0x184],%l0		! %l0 = fffffffffc2ebbf1
!	%l2 = 0000000000000c0c, %l2 = 0000000000000c0c, %l4 = 000000007f3d6c55
	subccc	%l2,%l2,%l4		! %l4 = 0000000000000000, %ccr = 44
!	Mem[0000000018800000] = 700332f8, %l0 = fffffffffc2ebbf1
	lduwa	[%i1+%g0]0x80,%l0	! %l0 = 00000000700332f8
	fblg,a,pn %fcc2,p2_branch_failed	! Branch Not Taken, %fcc2 = 0
!	Mem[0000000071800010] = d02d0810315995ea, %l6 = 00000000682500b5
	ldx	[%o3+0x010],%l6		! Annulled
p2_b38:

p2_label_84:
!	Mem[0000000018800038] = 116dd82b2b0563c6, %l2 = 0000000000000c0c
	ldx	[%i1+0x038],%l2		! %l2 = 116dd82b2b0563c6
!	Mem[0000000019800000] = 0000d0cf 87fd80e3, %l2 = 2b0563c6, %l3 = 7f3d6c77
	ldda	[%i3+%g0]0x80,%l2	! %l2 = 000000000000d0cf 0000000087fd80e3
!	Mem[00000000190001c0] = f618eaed 49881c80 c7dad5d5 ce2cf049
!	Mem[00000000190001d0] = 94dceda1 4de083a1 20012b75 917b2c47
!	Mem[00000000190001e0] = 3e2fec4c efd73079 f2d5da88 e3e92f58
!	Mem[00000000190001f0] = b47d86a8 efa682d9 eb51b6e4 bc9e1d3a
	mov	0x1c0,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 00000000190001c0
!	Mem[0000000019800000] = 0000d0cf, %l6 = 00000000682500b5
	lduha	[%i3+%g0]0x80,%l6	! %l6 = 0000000000000000
!	Mem[0000000072000040] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000072000050] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[0000000072000060] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[0000000072000070] = d852663a 841fa94d 012e213e bb7139a6
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040

p2_label_85:
!	%l6 = 00000000, %l7 = 2459d439, Mem[0000000071800010] = d02d0810 315995ea
	std	%l6,[%o3+0x010]	! Mem[0000000071800010] = 00000000 2459d439
!	Mem[0000000018800008] = 00000000, %l1 = 2ea7bc867f3d6c55
	ldsha	[%i1+%o6]0x80,%l1	! %l1 = 0000000000000000
!	%f21 = 5ee9fda9, %f20 = a5c041db 5ee9fda9
	fstod	%f21,%f20		! %f20 = 43dd3fb5 20000000
!	%l0 = 00000000700332f8, %l5 = d6befb74cab77127, %l2 = 000000000000d0cf
	xnorcc	%l0,%l5,%l2		! %l2 = 2941048b454bbc20, %ccr = 00
!	Mem[0000000019800028] = e3779be1, %l2 = 2941048b454bbc20
	ldub	[%i3+0x029],%l2		! %l2 = 0000000000000077

p2_label_86:
!	Mem[0000000070800010] = 000000007f3d6c55, %l5 = d6befb74cab77127
	ldx	[%o1+0x010],%l5		! %l5 = 000000007f3d6c55
	nop
!	Branch On Register, %l6 = 0000000000000000
	brgz,a,pt %l6,p2_not_taken_0	! Branch Not Taken
!	Mem[0000000019800028] = e3779be19aa508ee, %l3 = 0000000087fd80e3
	ldx	[%i3+0x028],%l3		! Annulled
p2_b39:
	ba	p2_b40			! Branch Taken, %ccr = 00, CWP = 0

p2_label_87:
!	Mem[0000000019000020] = 28fa54f0, %l5 = 000000007f3d6c55
	ldsh	[%i2+0x020],%l5		! %l5 = 00000000000028fa
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x028,%g2
p2_b40:
!	Mem[000000007200002c] = fc9924cb, %l3 = 0000000087fd80e3
	lduha	[%o4+0x02c]%asi,%g2	! %g2 = 000000000000fc99
!	Mem[0000000019800088] = 126ba6cdf02352b7, %l1 = 0000000000000000
	ldx	[%i3+0x088],%l1		! %l1 = 126ba6cdf02352b7
!	%f28 = 13748c4b 00000000, %f20 = 43dd3fb5 20000000, %f4  = a183e04d a1eddc94
	fmuld	%f28,%f20,%f4 		! %f4  = 1762c80c 79bc8300
!	Mem[0000000018000104] = edea18f6, %l4 = 0000000000000000
	ldsw	[%i0+0x104],%l4		! %l4 = ffffffffedea18f6

p2_label_88:
!	Mem[0000000019000000] = f18f38f8, %l3 = 0000000087fd80e3
	lduba	[%i2+%g0]0x80,%l3	! %l3 = 00000000000000f1
!	Mem[00000000198001e0] = a87eaa9c15f97043, %l5 = 00000000000028fa
	ldx	[%i3+0x1e0],%l5		! %l5 = a87eaa9c15f97043
!	Mem[0000000019000000] = f18f38f8, %l7 = 3f3e00392459d439
	lduwa	[%i2+%g0]0x80,%l7	! %l7 = 00000000f18f38f8
	membar	#Sync			! Added by membar checker (125)
	set	p2_b41,%o7
	fbo,a,pt %fcc1,p2_near_3_le	! Branch Taken, %fcc1 = 0
!	Mem[00000000198001a8] = a2adfa61, %l5 = a87eaa9c15f97043
	ldsw	[%i3+0x1a8],%l5		! %l5 = ffffffffa2adfa61
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x029,%g2
p2_b41:
!	Registers modified during the branch to p2_near_3
!	%l2  = 0000000000000079
!	%l3  = 000000007f3d6c55
!	%l5  = 0000000000000000
!	%l7  = ff9d79cabf17252d

p2_label_89:
!	Mem[0000000018000008] = 6d64924ccb72efd9, %l3 = 000000007f3d6c55
	ldxa	[%i0+%o6]0x80,%l3	! %l3 = 6d64924ccb72efd9
!	Mem[00000000180000c0] = e1b88d6f 693f4b51 b75223f0 cda66b12
!	Mem[00000000180000d0] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[00000000180000e0] = 0090f6b3 0c000000 693f4b51 438c2509
!	Mem[00000000180000f0] = 12e44436 fb7ec7bf 0d67e091 519781f0
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 00000000180000c0
!	Mem[0000000072000028] = 81795b2a, %l3 = 6d64924ccb72efd9
	ldsb	[%o4+0x028],%g2		! %g2 = ffffffffffffff81
!	Mem[0000000018000100] = 801c8849 edea18f6 49f02cce d5d5dac7
!	Mem[0000000018000110] = a183e04d a1eddc94 472c7b91 752b0120
!	Mem[0000000018000120] = 7930d7ef 4cec2f3e 582fe9e3 88dad5f2
!	Mem[0000000018000130] = d982a6ef a8867db4 3a1d9ebc e4b651eb
	mov	0x100,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 0000000018000100
	membar	#Sync			! Added by membar checker (126)
	set	p2_b42,%o7
	fbule,a,pn %fcc0,p2_near_2_le	! Branch Taken, %fcc0 = 0

p2_label_90:
!	Mem[0000000070000014] = 00007003, %l1 = 126ba6cdf02352b7
	ldsh	[%o0+0x014],%l1		! %l1 = 0000000000000000
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x02a,%g2
p2_b42:
!	Registers modified during the branch to p2_near_2
!	%l2  = 000000007f3d6c55
!	%l4  = fd96b8b81b4149b2
!	%l6  = 0000000000001545
!	%l7  = fffffffffffffef8
!	Mem[0000000018800008] = 00000000, %l4 = fd96b8b81b4149b2
	lduha	[%i1+%o6]0x80,%l4	! %l4 = 0000000000000000
!	%f16 = 801c8849 edea18f6 49f02cce d5d5dac7
!	%f20 = a183e04d a1eddc94 472c7b91 752b0120
!	%f24 = 7930d7ef 4cec2f3e 582fe9e3 88dad5f2
!	%f28 = d982a6ef a8867db4 3a1d9ebc e4b651eb
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 0000000018000100
!	%f16 = 801c8849 edea18f6 49f02cce d5d5dac7
!	%f20 = a183e04d a1eddc94 472c7b91 752b0120
!	%f24 = 7930d7ef 4cec2f3e 582fe9e3 88dad5f2
!	%f28 = d982a6ef a8867db4 3a1d9ebc e4b651eb
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000188000c0
!	Mem[0000000072000024] = 3b546019, %l2 = 000000007f3d6c55
	ldsw	[%o4+0x024],%g2		! %g2 = 000000007f3d6c55

p2_label_91:
!	Mem[0000000072000040] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000072000050] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[0000000072000060] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[0000000072000070] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f0  = 801c8849 edea18f6 49f02cce d5d5dac7
!	%f4  = 1762c80c 79bc8300 472c7b91 752b0120
!	%f8  = 7930d7ef 4cec2f3e 582fe9e3 88dad5f2
!	%f12 = d982a6ef a8867db4 3a1d9ebc e4b651eb
	mov	0x140,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000019800140
!	%l5 = 0000000000000000, immed = 0000097a, %l4 = 0000000000000000
	xor	%l5,0x97a,%l4		! %l4 = 000000000000097a
!	Mem[0000000019000120] = 4260713d, %l1 = 0000000000000000
	lduba	[%i2+0x121]%asi,%l1	! %l1 = 0000000000000060
!	Mem[0000000072000030] = 30eb6c4b, %l0 = 00000000700332f8
	lduwa	[%o4+0x030]%asi,%g2	! %g2 = 00000000700332f8

p2_label_92:
!	%l1 = 0000000000000060, %l1 = 0000000000000060, %l2 = 000000007f3d6c55
	andcc	%l1,%l1,%l2		! %l2 = 0000000000000060, %ccr = 00
!	Mem[0000000072000000] = 55e7ff25 b002efcc 7c541d25 27b6bf86
!	Mem[0000000072000010] = 7c8c790f cff2a0d9 895d6632 d1cf14b5
!	Mem[0000000072000020] = 080aedab 3b546019 81795b2a fc9924cb
!	Mem[0000000072000030] = 30eb6c4b a17b4f79 2306f396 ba50e8b5
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	Mem[0000000019800080] = 3d9817d3 fc2ebbf1 126ba6cd f02352b7
!	Mem[0000000019800090] = d14b3f69 6f8db8e1 9896ce52 3c52763f
!	Mem[00000000198000a0] = 78f70e2e fe2c8e3f 09258c43 c95c830e
!	Mem[00000000198000b0] = bfc77efb 3644e412 f0819751 91e0670d
	mov	0x080,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000019800080
!	Mem[00000000180001fc] = a16ff7a5, %l1 = 0000000000000060
	lduwa	[%i0+0x1fc]%asi,%l1	! %l1 = 00000000a16ff7a5
!	%f12 = d982a6ef a8867db4, %f12 = d982a6ef a8867db4
	fcmpd	%fcc3,%f12,%f12		! %fcc3 = 0

p2_label_93:
!	Mem[000000001a8000c0] = 083bf817 3a435067 31f9a9c9 78c07a2b
!	Mem[000000001a8000d0] = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	Mem[000000001a8000e0] = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	Mem[000000001a8000f0] = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	mov	0x0c0,%g6
	ldda	[%i5+%g6]ASI_BLK_P,%f0	! Block Load from 000000001a8000c0
!	%l1 = 00000000a16ff7a5, %l2 = 0000000000000060, %y  = 3f3e0039
	mulx	%l1,%l2,%l2		! %l2 = 0000003c89fcdde0
!	Mem[0000000070800014] = 7f3d6c55, %l7 = fffffffffffffef8
	ldub	[%o1+0x017],%l7		! %l7 = 0000000000000055
!	%f0  = 083bf817 3a435067 31f9a9c9 78c07a2b
!	%f4  = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	%f8  = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	%f12 = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	mov	0x1c0,%g4
	stda	%f0,[%i0+%g4]ASI_BLK_PL	! Block Store to 00000000180001c0
!	Mem[000000001a000044] = 54bf93dc, %l3 = 6d64924ccb72efd9
	ldub	[%i4+0x047],%l3		! %l3 = 00000000000000dc

p2_label_94:
	ble,a	p2_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[0000000019800008] = 47ba24b0, %l7 = 0000000000000055
	lduba	[%i3+%o6]0x80,%l7	! Annulled
p2_b43:
!	Mem[00000000190001b0] = 12e44436fb7ec7bf, %l5 = 0000000000000000
	ldx	[%i2+0x1b0],%l5		! %l5 = 12e44436fb7ec7bf
!	%l0 = 700332f8, %l1 = a16ff7a5, Mem[0000000019000000] = f18f38f8 887de454
	stda	%l0,[%i2+%g0]0x80	! Mem[0000000019000000] = 700332f8 a16ff7a5
!	%f0  = 083bf817 3a435067 31f9a9c9 78c07a2b
!	%f4  = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	%f8  = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	%f12 = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	mov	0x040,%g6
	stda	%f0,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040

p2_label_95:
!	Mem[0000000019800040] = 988b18bd d8289b24 6d64924c cb72efd9
!	Mem[0000000019800050] = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	Mem[0000000019800060] = 8e534add 4b60c30b bb0dfff8 27a27954
!	Mem[0000000019800070] = 4da91f84 3a6652d8 a63971bb 3e212e01
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 0000000019800040
!	Mem[0000000018800008] = 00000000, %l0 = 00000000700332f8
	ldswa	[%i1+%o6]0x80,%l0	! %l0 = 0000000000000000
	fbn,a	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000070000050] = dfe43fd7, %l7 = 0000000000000055
	ldsb	[%o0+0x051],%l7		! Annulled
p2_b44:
	membar	#Sync			! Added by membar checker (127)
!	Branch On Register, %l6 = 0000000000001545
	brgez,a,pt %l6,p2_b45		! Branch Taken

p2_label_96:
!	Mem[0000000019800000] = 0000d0cf, %l7 = 0000000000000055
	ldsha	[%i3+%g0]0x80,%l7	! %l7 = 0000000000000000
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p2_branch_failed
	mov	0x02d,%g2
p2_b45:
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[00000000180000c0] = e1b88d6f 693f4b51 b75223f0 cda66b12
!	Mem[00000000180000d0] = e1b88d6f 693f4bd1 3f76523c 52ce9698
!	Mem[00000000180000e0] = 0090f6b3 0c000000 693f4b51 438c2509
!	Mem[00000000180000f0] = 12e44436 fb7ec7bf 0d67e091 519781f0
	mov	0x0c0,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 00000000180000c0
	fbn,a,pn %fcc3,p2_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[0000000070000050] = dfe43fd7989662c1, %l0 = 0000000000000000
	ldx	[%o0+0x050],%l0		! Annulled
p2_b46:

p2_label_97:
!	%f16 = 988b18bd d8289b24 6d64924c cb72efd9
!	%f20 = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	%f24 = 8e534add 4b60c30b bb0dfff8 27a27954
!	%f28 = 4da91f84 3a6652d8 a63971bb 3e212e01
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000019800140
!	Mem[0000000071000010] = 9d0d6da6, %l4 = 000000000000097a
	lduba	[%o2+0x012]%asi,%l4	! %l4 = 000000000000006d
	membar	#Sync			! Added by membar checker (128)
!	Mem[0000000072000078] = b5e850ba96f30623, %l1 = 00000000a16ff7a5
	ldx	[%o4+0x078],%g2		! %g2 = b5e850ba96f30623
!	%f16 = 988b18bd d8289b24 6d64924c cb72efd9
!	%f20 = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	%f24 = 8e534add 4b60c30b bb0dfff8 27a27954
!	%f28 = 4da91f84 3a6652d8 a63971bb 3e212e01
	stda	%f16,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000018800180] = 8dff5460 49afbd2a 36a5cd51 60aaf97e
!	Mem[0000000018800190] = f1821167 343921d6 f973e999 6c9971d3
!	Mem[00000000188001a0] = db347a1a 2389ad9c 33adff83 13cec868
!	Mem[00000000188001b0] = bb96a0f5 74cc77a5 8073d2ef 40706d79
	mov	0x180,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000018800180

p2_label_98:
!	%f16 = 2abdaf49 6054ff8d 7ef9aa60 51cda536
!	%f20 = d6213934 671182f1 d371996c 99e973f9
!	%f24 = 9cad8923 1a7a34db 68c8ce13 83ffad33
!	%f28 = a577cc74 f5a096bb 796d7040 efd27380
	mov	0x1c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 00000000180001c0
!	Mem[0000000018000080] = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	Mem[0000000018000090] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[00000000180000a0] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[00000000180000b0] = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 0000000018000080
!	%f16 = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	%f20 = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	%f24 = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	%f28 = 13748c4b edc1c7c7 99ad8d85 40accca8
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 00000000190001c0
!	Mem[0000000019800180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019800190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000198001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000198001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000019800180
	membar	#Sync			! Added by membar checker (129)
!	Mem[0000000072000000] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000072000010] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[0000000072000020] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[0000000072000030] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000

p2_label_99:
!	%f0  = a7a85772 dafc1653, %f16 = 80d9214d ac8cd40c
	fabsd	%f0 ,%f16		! %f16 = 27a85772 dafc1653
!	Mem[0000000019800000] = 0000d0cf, %l6 = 0000000000001545
	ldswa	[%i3+%g0]0x80,%l6	! %l6 = 000000000000d0cf
!	Mem[0000000019000104] = dafc1653, %l6 = 000000000000d0cf
	ldsh	[%i2+0x104],%l6		! %l6 = ffffffffffffdafc
!	Mem[0000000018000128] = 582fe9e388dad5f2, %l7 = 0000000000000000
	ldx	[%i0+0x128],%l7		! %l7 = 582fe9e388dad5f2
!	%f0  = a7a85772 dafc1653 8d5fe119 eb6a7654
!	%f4  = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	%f8  = 4260713d aa961a27 dc92015f 61faada2
!	%f12 = 1b0a271c bedc3150 24e9c881 a16ff7a5
	mov	0x0c0,%g6
	stda	%f0,[%i1+%g6]ASI_BLK_P	! Block Store to 00000000188000c0

p2_label_100:
!	%l4 = 000000000000006d, immed = 00000cd4, %l0 = 0000000000000000
	andncc	%l4,0xcd4,%l0		! %l0 = 0000000000000029, %ccr = 00
!	Mem[000000001880001c] = c461673a, %l1 = 00000000a16ff7a5
	ldsw	[%i1+0x01c],%l1		! %l1 = ffffffffc461673a
!	Mem[0000000018000048] = 74cf0948, %l1 = ffffffffc461673a
	lduha	[%i0+0x048]%asi,%l1	! %l1 = 00000000000074cf
!	%l1 = 00000000000074cf, %l2 = 0000003c89fcdde0, %y  = 3f3e0039
	sdiv	%l1,%l2,%l5		! %l5 = ffffffff80000000
	mov	%l0,%y			! %y = 00000029
!	%f16 = 27a85772 dafc1653 75097ae7 4e60f18f
!	%f20 = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	%f24 = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	%f28 = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x040,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 0000000019000040

p2_label_101:
!	Mem[0000000070800010] = 00000000 7f3d6c55, %l2 = 89fcdde0, %l3 = 000000dc
	ldd	[%o1+0x010],%l2		! %l2 = 0000000000000000 000000007f3d6c55

	ba,a	p2_not_taken_0_end
p2_not_taken_0:
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba,a	p2_branch_failed
p2_not_taken_0_end:

!	Mem[0000000071000010] = 9d0d6da6cab52ecb, %l6 = ffffffffffffdafc
	ldx	[%o2+0x010],%l6		! %l6 = 9d0d6da6cab52ecb
!	Mem[0000000018800080] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000018800090] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000188000a0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000188000b0] = d852663a 841fa94d 012e213e bb7139a6
	mov	0x080,%g4
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 0000000018800080
!	%l0 = 0000000000000029, %l4 = 000000000000006d, %l1 = 00000000000074cf
	orn	%l0,%l4,%l1		! %l1 = ffffffffffffffbb
!	Mem[0000000019800070] = 4da91f84, %l0 = 0000000000000029
	lduh	[%i3+0x072],%l0		! %l0 = 0000000000001f84

p2_label_102:
!	Mem[0000000070000054] = 989662c1, %l5 = ffffffff80000000
	lduwa	[%o0+0x054]%asi,%l5	! %l5 = 00000000989662c1
!	Mem[0000000019000100] = a7a85772 dafc1653 8d5fe119 eb6a7654
!	Mem[0000000019000110] = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	Mem[0000000019000120] = 4260713d aa961a27 dc92015f 61faada2
!	Mem[0000000019000130] = 1b0a271c bedc3150 24e9c881 a16ff7a5
	mov	0x100,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000019000100
!	%f0  = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	%f4  = 1c16487d c7407846 7bd5e73f a750d99c
!	%f8  = 271a96aa 3d716042 a2adfa61 5f0192dc
!	%f12 = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 00000000180000c0
!	Mem[00000000188001a0] = db347a1a2389ad9c, %l0 = 0000000000001f84
	ldx	[%i1+0x1a0],%l0		! %l0 = db347a1a2389ad9c
	bn	p2_not_taken_0		! Branch Not Taken, %ccr = 00

p2_label_103:
!	Mem[0000000019800000] = 0000d0cf, %l2 = 0000000000000000
	lduha	[%i3+%g0]0x80,%l2	! %l2 = 0000000000000000
p2_b47:
!	%l4 = 000000000000006d, Mem[0000000019000008] = 3af102c4
	stwa	%l4,[%i2+%o6]0x80	! Mem[0000000019000008] = 0000006d
	membar	#Sync			! Added by membar checker (130)
	set	p2_b48,%o7
	fble,a	p2_far_0_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000019800008] = 47ba24b0, %l5 = 00000000989662c1
	ldswa	[%i3+%o6]0x80,%l5	! %l5 = 0000000047ba24b0
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x030,%g2
p2_b48:
!	Registers modified during the branch to p2_far_0
!	%l3  = 5892f8401545e874
!	%l7  = 00000000f5a096bb
!	Mem[0000000018000000] = 988b18bd, %l4 = 000000000000006d
	ldsba	[%i0+%g0]0x80,%l4	! %l4 = ffffffffffffff98

p2_label_104:
!	%f8  = 271a96aa, %f6  = 7bd5e73f
	fcmpes	%fcc2,%f8 ,%f6 		! %fcc2 = 1
!	Mem[0000000018000008] = 6d64924c cb72efd9, %l4 = ffffff98, %l5 = 47ba24b0
	ldda	[%i0+%o6]0x80,%l4	! %l4 = 000000006d64924c 00000000cb72efd9
!	%f16 = 27a85772 dafc1653 75097ae7 4e60f18f
!	%f20 = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	%f24 = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	%f28 = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x180,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000019800180
!	Mem[0000000018000100] = 801c8849 edea18f6 49f02cce d5d5dac7
!	Mem[0000000018000110] = a183e04d a1eddc94 472c7b91 752b0120
!	Mem[0000000018000120] = 7930d7ef 4cec2f3e 582fe9e3 88dad5f2
!	Mem[0000000018000130] = d982a6ef a8867db4 3a1d9ebc e4b651eb
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018000100
	membar	#Sync			! Added by membar checker (131)
!	Mem[0000000019800180] = 5316fcda 7257a827 8ff1604e e77a0975
!	Mem[0000000019800190] = a9fde95e db41c0a5 080fda8b eeaac6c7
!	Mem[00000000198001a0] = 2d2517bf ca799dff 031df97c f6051aca
!	Mem[00000000198001b0] = c7c7c1ed 4b8c7413 a8ccac40 858dad99
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000019800180

p2_label_105:
!	%l4 = 000000006d64924c, %l3 = 5892f8401545e874, %l4 = 000000006d64924c
	addccc	%l4,%l3,%l4		! %l4 = 5892f84082aa7ac0, %ccr = 0a
!	Mem[00000000198001c0] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[00000000198001d0] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[00000000198001e0] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[00000000198001f0] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x1c0,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 00000000198001c0
!	%l5 = 00000000cb72efd9, %l4 = 5892f84082aa7ac0, %l1 = ffffffffffffffbb
	addccc	%l5,%l4,%l1		! %l1 = 5892f8414e1d6a99, %ccr = 03
!	%f0  = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	%f4  = 1c16487d c7407846 7bd5e73f a750d99c
!	%f8  = 271a96aa 3d716042 a2adfa61 5f0192dc
!	%f12 = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000019000180
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 0000000019800180

p2_label_106:
!	Mem[0000000019800008] = 47ba24b0, %l0 = db347a1a2389ad9c
	lduwa	[%i3+%o6]0x80,%l0	! %l0 = 0000000047ba24b0
!	Mem[0000000072000000] = 249b28d8bd188b98, %l6 = 9d0d6da6cab52ecb
	ldx	[%o4+0x000],%g2		! %g2 = 249b28d8bd188b98
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x080,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000019000080
!	Mem[0000000018000120] = 7930d7ef 4cec2f3e, %l4 = 82aa7ac0, %l5 = cb72efd9
	ldd	[%i0+0x120],%l4		! %l4 = 000000007930d7ef 000000004cec2f3e
!	Mem[00000000190000f8] = 99ad8d85, %l7 = 00000000f5a096bb
	ldswa	[%i2+0x0f8]%asi,%l7	! %l7 = ffffffff99ad8d85

p2_label_107:
	membar	#Sync
	set	p2_b49,%o7
	fbge,a	p2_far_0_he		! Branch Taken, %fcc0 = 0
!	Mem[00000000190001d0] = a5c041db, %l2 = 0000000000000000
	lduw	[%i2+0x1d0],%l2		! %l2 = 00000000a5c041db
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x031,%g2
p2_b49:
!	Registers modified during the branch to p2_far_0
!	%l3  = 5892f8401545e874
!	%l7  = 00000000f5a096bb
!	Mem[0000000072000070] = 794f7ba14b6ceb30, %l6 = 9d0d6da6cab52ecb
	ldx	[%o4+0x070],%g2		! %g2 = 794f7ba14b6ceb30
!	Mem[0000000070000050] = dfe43fd7989662c1, %f14 = a5f76fa1 81c8e924
	ldd	[%o0+0x050],%f14	! %f14 = dfe43fd7 989662c1
!	%f24 = 4370f915, %f4  = 1c16487d
	fcmpes	%fcc1,%f24,%f4 		! %fcc1 = 2

p2_label_108:
!	Mem[0000000071800010] = 00000000, %l0 = 0000000047ba24b0
	lduba	[%o3+0x011]%asi,%l0	! %l0 = 0000000000000000
!	Mem[0000000072000050] = d9a0f2cf0f798c7c, %l7 = 00000000f5a096bb
	ldx	[%o4+0x050],%g2		! %g2 = d9a0f2cf0f798c7c
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x0c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000198000c0
!	Mem[0000000019800100] = e4ee3648 dacb6815 30fdef99 0ef12f86
!	Mem[0000000019800110] = 4bb1e062 f0efee78 c8d537a8 ba8077a7
!	Mem[0000000019800120] = 48b7e1d6 bd621d89 3495e22f 10b8f52c
!	Mem[0000000019800130] = 5dd8b95a 1df5b4b6 dc58c451 5f495260
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000019800100
!	Mem[0000000018800048] = f94f59f8fc163c57, %l2 = 00000000a5c041db
	ldxa	[%i1+0x048]%asi,%l2	! %l2 = f94f59f8fc163c57

p2_label_109:
	membar	#Sync			! Added by membar checker (132)
!	%f0  = 1568cbda 4836eee4 862ff10e 99effd30
!	%f4  = 78eeeff0 62e0b14b a77780ba a837d5c8
!	%f8  = 891d62bd d6e1b748 2cf5b810 2fe29534
!	%f12 = b6b4f51d 5ab9d85d 6052495f 51c458dc
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 00000000198000c0
!	Mem[0000000018800000] = 700332f8 a569f230 00000000 3d9817d3
!	Mem[0000000018800010] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800020] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800030] = e5347cd8 82db4849 116dd82b 2b0563c6
	ldda	[%i1]ASI_BLK_PL,%f0	! Block Load from 0000000018800000
!	Mem[0000000019000028] = 8e66f0f93bb2830b, %l1 = 5892f8414e1d6a99
	ldx	[%i2+0x028],%l1		! %l1 = 8e66f0f93bb2830b
!	Mem[0000000019000188] = 54766aeb19e15f8d, %l6 = 9d0d6da6cab52ecb
	ldxa	[%i2+0x188]%asi,%l6	! %l6 = 54766aeb19e15f8d
!	Mem[0000000070800050] = 5892f8401545e874, %l6 = 54766aeb19e15f8d
	ldx	[%o1+0x050],%l6		! %l6 = 5892f8401545e874

p2_label_110:
	membar	#Sync			! Added by membar checker (133)
	set	p2_b50,%o7
	fbue,a,pn %fcc0,p2_near_0_he	! Branch Taken, %fcc0 = 0
!	Mem[0000000019000064] = ca799dff, %l4 = 000000007930d7ef
	lduw	[%i2+0x064],%l4		! %l4 = 00000000ca799dff
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p2_branch_failed
	mov	0x032,%g2
p2_b50:
!	Registers modified during the branch to p2_near_0
!	%l4  = 000000007f3d6c55
!	%l5  = d6befb74cab77127
!	%l6  = 0000000000000000
!	%l7  = 000000007f3d6c55
!	Mem[0000000018000014] = fed42ae5, %l3 = 5892f8401545e874
	ldsba	[%i0+0x014]%asi,%l3	! %l3 = fffffffffffffffe
	bne,a	p2_b51			! Branch Taken, %ccr = 00, CWP = 0
!	%l3 = fffffffffffffffe, immed = fffff3a4, %y  = 11f0127c
	umulcc	%l3,-0xc5c,%l4		! %l4 = fffff3a2000018b8, %ccr = 80
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x033,%g2
p2_b51:

p2_label_111:
!	Mem[0000000018800148] = 74cf0948, %l5 = d6befb74cab77127
	lduha	[%i1+0x148]%asi,%l5	! %l5 = 00000000000074cf
	fbul,a,pn %fcc1,p2_branch_failed	! Branch Not Taken, %fcc1 = 2
!	%l5 = 00000000000074cf, immed = 0000001d, %l4 = fffff3a2000018b8
	srl	%l5,0x01d,%l4		! Annulled
p2_b52:
!	Mem[0000000071000014] = cab52ecb, %l5 = 00000000000074cf
	ldsb	[%o2+0x017],%l5		! %l5 = ffffffffffffffcb
!	%l5 = ffffffffffffffcb, immed = 00000003, %l2 = f94f59f8fc163c57
	sll	%l5,0x003,%l2		! %l2 = fffffffffffffe58

p2_label_112:
!	Mem[0000000019800048] = 6d64924ccb72efd9, %l4 = fffff3a2000018b8
	ldxa	[%i3+0x048]%asi,%l4	! %l4 = 6d64924ccb72efd9
!	Mem[0000000072000020] = 4bdd4a53, %l3 = fffffffffffffffe
	ldub	[%o4+0x023],%g2		! %g2 = 000000000000004b
!	Mem[0000000018000140] = 41663151 83f03e37 1beb59be 8d6dda2b
!	Mem[0000000018000150] = e4d0de7d 3edbfaed c20a673d 52a43808
!	Mem[0000000018000160] = c084dd34 af077279 c6c96134 f0e4d0cf
!	Mem[0000000018000170] = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x140,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000018000140
!	%l6 = 0000000000000000, immed = fffff74a, %l1 = 8e66f0f93bb2830b
	andn	%l6,-0x8b6,%l1		! %l1 = 0000000000000000
!	%l6 = 0000000000000000, %l7 = 000000007f3d6c55, %y  = fffff3a2
	mulx	%l6,%l7,%l0		! %l0 = 0000000000000000

p2_label_113:
!	%f0  = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f4  = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f8  = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f12 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x040,%g4
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000019000040
!	Mem[0000000018000008] = 6d64924c cb72efd9, %l0 = 00000000, %l1 = 00000000
	ldda	[%i0+%o6]0x80,%l0	! %l0 = 000000006d64924c 00000000cb72efd9
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x140,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 0000000018800140
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x100,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000018000100
!	%f1  = 83f03e37, %f1  = 83f03e37
	fmovs	%f1 ,%f1 		! %f1  = 83f03e37

p2_label_114:
!	Mem[0000000019800140] = 988b18bd, %l0 = 000000006d64924c
	ldswa	[%i3+0x140]%asi,%l0	! %l0 = ffffffff988b18bd
!	Mem[0000000071800054] = 7f3d6c55, %l2 = fffffffffffffe58
	lduba	[%o3+0x057]%asi,%l2	! %l2 = 0000000000000055
!	Mem[0000000019000000] = 700332f8, %l2 = 0000000000000055
	ldsba	[%i2+%g0]0x80,%l2	! %l2 = 0000000000000070
!	Mem[0000000071800010] = 000000002459d439, %l7 = 000000007f3d6c55
	ldx	[%o3+0x010],%l7		! %l7 = 000000002459d439
!	%f16 = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	%f20 = 51383f66 e6566585 d4473cb5 b5d885a2
!	%f24 = 4370f915 9caa7ea8 2d50d76b f2517f12
!	%f28 = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x080,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 0000000019000080

p2_label_115:
!	Mem[0000000019800000] = 0000d0cf, %l7 = 000000002459d439
	ldsba	[%i3+%g0]0x80,%l7	! %l7 = 0000000000000000
!	Mem[0000000019800000] = 0000d0cf, %l1 = 00000000cb72efd9
	lduha	[%i3+%g0]0x80,%l1	! %l1 = 0000000000000000
!	Mem[0000000019000028] = 8e66f0f93bb2830b, %l5 = ffffffffffffffcb
	ldxa	[%i2+0x028]%asi,%l5	! %l5 = 8e66f0f93bb2830b
!	Mem[0000000072000070] = 794f7ba14b6ceb30, %l6 = 0000000000000000
	ldx	[%o4+0x070],%g2		! %g2 = 794f7ba14b6ceb30
!	%f0  = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f4  = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f8  = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f12 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x0c0,%g4
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 00000000190000c0

p2_label_116:
!	Mem[0000000072000040] = ccef02b0 25ffe755 86bfb627 251d547c
!	Mem[0000000072000050] = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	Mem[0000000072000060] = 1960543b abed0a08 cb2499fc 2a5b7981
!	Mem[0000000072000070] = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	mov	0x040,%g6
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000019000008] = 0000006d, %l0 = ffffffff988b18bd
	lduha	[%i2+%o6]0x80,%l0	! %l0 = 0000000000000000
	membar	#Sync			! Added by membar checker (134)
!	Mem[0000000019000040] = 41663151, %l1 = 0000000000000000
	lduha	[%i2+0x042]%asi,%l1	! %l1 = 0000000000003151
!	%f0  = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f4  = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f8  = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f12 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000019000100
!	%l1 = 0000000000003151
	sethi	%hi(0x35549c00),%l1	! %l1 = 0000000035549c00

p2_label_117:
	fbu,a	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000070800014] = 7f3d6c55, %l1 = 0000000035549c00
	ldub	[%o1+0x017],%l1		! Annulled
p2_b53:
!	Mem[0000000018000120] = a87eaa9c 15f97043, %l4 = cb72efd9, %l5 = 3bb2830b
	ldda	[%i0+0x120]%asi,%l4	! %l4 = 00000000a87eaa9c 0000000015f97043
!	Mem[0000000071000050] = 78f70e2e fe2c8e3f, %l6 = 00000000, %l7 = 00000000
	ldd	[%o2+0x050],%l6		! %l6 = 0000000078f70e2e 00000000fe2c8e3f
!	Mem[0000000018800080] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000018800090] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000188000a0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000188000b0] = d852663a 841fa94d 012e213e bb7139a6
	mov	0x080,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000018800080

p2_label_118:
!	Mem[00000000190000dc] = 52a43808, %l3 = fffffffffffffffe
	lduha	[%i2+0x0dc]%asi,%l3	! %l3 = 00000000000052a4
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l7 = 00000000fe2c8e3f
	ldx	[%o3+0x050],%l7		! %l7 = 2ea7bc867f3d6c55
!	%l4 = a87eaa9c, %l5 = 15f97043, Mem[00000000188001a8] = 33adff83 13cec868
	stda	%l4,[%i1+0x1a8]%asi	! Mem[00000000188001a8] = a87eaa9c 15f97043
!	Mem[0000000070000014] = 00007003, %l4 = 00000000a87eaa9c
	ldswa	[%o0+0x014]%asi,%l4	! %l4 = 0000000000007003
!	Mem[000000001b000080] = bb047f13 67662de2 40648d0a 9937c7be
!	Mem[000000001b000090] = 2b17aae1 86ecc438 d442e01c 54769034
!	Mem[000000001b0000a0] = 693a6d58 5d2f58af 52d5dff0 b53fc22b
!	Mem[000000001b0000b0] = 7259ccb3 d41dbfd3 f5276932 2b28c901
	ldda	[%i6+%g5]ASI_BLK_P,%f16	! Block Load from 000000001b000080

p2_label_119:
!	%f14 = 5531acaf f0fc6eab, %f14 = 5531acaf f0fc6eab, %f6  = c20a673d 52a43808
	fdivd	%f14,%f14,%f6 		! %f6  = 3ff00000 00000000
!	Mem[00000000190001b4] = 1c270a1b, %f2  = 1beb59be
	ld	[%i2+0x1b4],%f2 	! %f2 = 1c270a1b
!	Mem[000000001a8000c0] = 083bf817 3a435067 31f9a9c9 78c07a2b
!	Mem[000000001a8000d0] = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	Mem[000000001a8000e0] = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	Mem[000000001a8000f0] = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	ldda	[%i5+%g4]ASI_BLK_PL,%f0	! Block Load from 000000001a8000c0
!	Mem[0000000019800000] = 0000d0cf, %l2 = 0000000000000070
	lduwa	[%i3+%g0]0x80,%l2	! %l2 = 000000000000d0cf
!	Mem[00000000198000c0] = e4ee3648 dacb6815 30fdef99 0ef12f86
!	Mem[00000000198000d0] = 4bb1e062 f0efee78 c8d537a8 ba8077a7
!	Mem[00000000198000e0] = 48b7e1d6 bd621d89 3495e22f 10b8f52c
!	Mem[00000000198000f0] = 5dd8b95a 1df5b4b6 dc58c451 5f495260
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000198000c0

p2_label_120:
!	Mem[00000000188001b4] = 74cc77a5, %l7 = 2ea7bc867f3d6c55
	ldsh	[%i1+0x1b4],%l7		! %l7 = 00000000000074cc
!	%l1 = 0000000035549c00, Mem[0000000071000050] = 78f70e2e
	stha	%l1,[%o2+0x050]%asi	! Mem[0000000071000050] = 9c000e2e
!	Mem[00000000188001b8] = 8073d2ef40706d79, %l3 = 00000000000052a4
	ldxa	[%i1+0x1b8]%asi,%l3	! %l3 = 8073d2ef40706d79
!	Mem[00000000190000b8] = 9b01c4bc2cbe4f03, %l1 = 0000000035549c00
	ldx	[%i2+0x0b8],%l1		! %l1 = 9b01c4bc2cbe4f03
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i1+%g6]ASI_BLK_P	! Block Store to 0000000018800040

p2_label_121:
!	Mem[0000000019800140] = 988b18bd d8289b24 6d64924c cb72efd9
!	Mem[0000000019800150] = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	Mem[0000000019800160] = 8e534add 4b60c30b bb0dfff8 27a27954
!	Mem[0000000019800170] = 4da91f84 3a6652d8 a63971bb 3e212e01
	mov	0x140,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000019800140
!	Mem[00000000188000b0] = d852663a841fa94d, %l5 = 0000000015f97043
	ldx	[%i1+0x0b0],%l5		! %l5 = d852663a841fa94d
!	%f16 = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	%f20 = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	%f24 = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	%f28 = d852663a 841fa94d 012e213e bb7139a6
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000188000c0
!	%l3 = 8073d2ef40706d79, immed = 000007eb, %l1 = 9b01c4bc2cbe4f03
	and	%l3,0x7eb,%l1		! %l1 = 0000000000000569
	membar	#Sync			! Added by membar checker (135)
	set	p2_b54,%o7
	fbo,a,pn %fcc0,p2_near_2_le	! Branch Taken, %fcc0 = 0

p2_label_122:
!	Mem[0000000018800000] = 700332f8, %l4 = 0000000000007003
	lduwa	[%i1+%g0]0x80,%l4	! %l4 = 00000000700332f8
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p2_branch_failed
	mov	0x036,%g2
p2_b54:
!	Registers modified during the branch to p2_near_2
!	%l2  = 000000007f3d6c55
!	%l4  = fd96b8b81b4149b2
!	%l6  = 0000000000001545
!	%l7  = fffffffffffffc80
!	Mem[0000000072000000] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000072000010] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[0000000072000020] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[0000000072000030] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x180,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000019800180
!	Mem[0000000070800010] = 00000000, %l2 = 000000007f3d6c55
	lduwa	[%o1+0x010]%asi,%l2	! %l2 = 0000000000000000
!	Mem[0000000018800100] = 700332f8 a569f230 490d118b b416244d
!	Mem[0000000018800110] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800120] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800130] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x100,%g4
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018800100

p2_label_123:
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x1c0,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 00000000198001c0
!	Mem[0000000070000050] = dfe43fd7989662c1, %l6 = 0000000000001545
	ldx	[%o0+0x050],%l6		! %l6 = dfe43fd7989662c1
!	Mem[0000000018000110] = 856556e6, %l5 = d852663a841fa94d
	lduha	[%i0+0x110]%asi,%l5	! %l5 = 0000000000008565
!	Mem[0000000019800000] = 0000d0cf, %l4 = fd96b8b81b4149b2
	ldsha	[%i3+%g0]0x80,%l4	! %l4 = 0000000000000000
!	Mem[00000000180001c0] = 2abdaf49 6054ff8d 7ef9aa60 51cda536
!	Mem[00000000180001d0] = d6213934 671182f1 d371996c 99e973f9
!	Mem[00000000180001e0] = 9cad8923 1a7a34db 68c8ce13 83ffad33
!	Mem[00000000180001f0] = a577cc74 f5a096bb 796d7040 efd27380
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 00000000180001c0

p2_label_124:
!	Mem[000000001a000008] = bbba0528, %l3 = 8073d2ef40706d79
	ldsba	[%i4+%o6]0x80,%l3	! %l3 = ffffffffffffffbb
!	Mem[0000000019000118] = 0838a452, %l4 = 0000000000000000
	ldsw	[%i2+0x118],%l4		! %l4 = 000000000838a452
!	Mem[000000001800009c] = 8bda0f08, %l0 = 0000000000000000
	ldsw	[%i0+0x09c],%l0		! %l0 = ffffffff8bda0f08
!	Mem[00000000188000c8] = d9ef72cb4c92646d, %l2 = 0000000000000000
	ldx	[%i1+0x0c8],%l2		! %l2 = d9ef72cb4c92646d
!	Mem[00000000198000c0] = e4ee3648 dacb6815 30fdef99 0ef12f86
!	Mem[00000000198000d0] = 4bb1e062 f0efee78 c8d537a8 ba8077a7
!	Mem[00000000198000e0] = 48b7e1d6 bd621d89 3495e22f 10b8f52c
!	Mem[00000000198000f0] = 5dd8b95a 1df5b4b6 dc58c451 5f495260
	mov	0x0c0,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f0	! Block Load from 00000000198000c0

p2_label_125:
!	Mem[000000001800005c] = 5237261e, %l4 = 000000000838a452
	lduh	[%i0+0x05c],%l4		! %l4 = 0000000000005237
!	%f0  = e4ee3648 dacb6815 30fdef99 0ef12f86
!	%f4  = 4bb1e062 f0efee78 c8d537a8 ba8077a7
!	%f8  = 48b7e1d6 bd621d89 3495e22f 10b8f52c
!	%f12 = 5dd8b95a 1df5b4b6 dc58c451 5f495260
	mov	0x180,%g5
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000018000180
!	Mem[0000000019800000] = 0000d0cf, %l3 = ffffffffffffffbb
	ldsba	[%i3+%g0]0x80,%l3	! %l3 = 0000000000000000
!	Mem[0000000072000040] = ccef02b0 25ffe755, %l2 = 4c92646d, %l3 = 00000000
	ldd	[%o4+0x040],%g2		! %l2 = d9ef72cb4c92646d 0000000000000000
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040

p2_label_126:
!	Mem[0000000070000014] = 00007003, %l4 = 0000000000005237
	ldswa	[%o0+0x014]%asi,%l4	! %l4 = 0000000000007003
!	%l4 = 0000000000007003, Mem[0000000019800008] = 47ba24b0
	stba	%l4,[%i3+%o6]0x80	! Mem[0000000019800008] = 03ba24b0
!	Mem[0000000018000008] = 6d64924c, %l6 = dfe43fd7989662c1
	lduwa	[%i0+%o6]0x80,%l6	! %l6 = 000000006d64924c
!	%f16 = 30f269a5 f8320370 4d2416b4 8b110d49
!	%f20 = fd02fbc5 ef3e7b12 3a6761c4 5b0b2707
!	%f24 = 86979249 3e5938f8 8ab3366a 647c251b
!	%f28 = 4948db82 d87c34e5 c663052b 2bd86d11
	stda	%f16,[%i2]ASI_BLK_P	! Block Store to 0000000019000000
!	Mem[0000000019800000] = 0000d0cf, %l3 = 0000000000000000
	ldsba	[%i3+%g0]0x80,%l3	! %l3 = 0000000000000000

p2_label_127:
!	%f16 = 30f269a5 f8320370 4d2416b4 8b110d49
!	%f20 = fd02fbc5 ef3e7b12 3a6761c4 5b0b2707
!	%f24 = 86979249 3e5938f8 8ab3366a 647c251b
!	%f28 = 4948db82 d87c34e5 c663052b 2bd86d11
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 00000000180001c0
!	Mem[0000000070000010] = 8001c1d300007003, %l2 = d9ef72cb4c92646d
	ldx	[%o0+0x010],%l2		! %l2 = 8001c1d300007003
!	Mem[0000000019000180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019000190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000190001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000190001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 0000000019000180
!	%f22 = 3a6761c4 5b0b2707, %f18 = 4d2416b4 8b110d49
	fmovd	%f22,%f18		! %f18 = 3a6761c4 5b0b2707
!	Mem[0000000070000010] = 8001c1d300007003, %l4 = 0000000000007003
	ldx	[%o0+0x010],%l4		! %l4 = 8001c1d300007003

p2_label_128:
!	Mem[0000000071800010] = 00000000 2459d439, %l6 = 6d64924c, %l7 = fffffc80
	ldd	[%o3+0x010],%l6		! %l6 = 0000000000000000 000000002459d439
!	Mem[0000000019800000] = 0000d0cf87fd80e3, %l1 = 0000000000000569
	ldxa	[%i3+%g0]0x80,%l1	! %l1 = 0000d0cf87fd80e3
	membar	#Sync			! Added by membar checker (136)
!	Mem[0000000019000000] = 30f269a5, %l5 = 0000000000008565
	ldsha	[%i2+%g0]0x80,%l5	! %l5 = 00000000000030f2
!	Mem[0000000070800050] = 5892f840, %l6 = 0000000000000000
	ldsb	[%o1+0x050],%l6		! %l6 = 0000000000000058
!	Mem[00000000190001f8] = 99ad8d85, %l2 = 8001c1d300007003
	ldsh	[%i2+0x1f8],%l2		! %l2 = ffffffffffff99ad

p2_label_129:
!	Mem[000000001800010e] = 1773fce7, %l1 = 0000d0cf87fd80e3
	ldstuba	[%i0+0x10e]%asi,%l1	! %l1 = 00000000000000fc
!	Mem[000000001a800040] = 72b09652 7797f305 879ed048 4d38a9ee
!	Mem[000000001a800050] = 72b42dc9 13ed30d9 5dcad371 69f5e679
!	Mem[000000001a800060] = 65232085 59b7d121 6c83f5d9 f96839a0
!	Mem[000000001a800070] = c66cacf9 04a4d6f6 b177f670 a7fa552c
	ldda	[%i5+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001a800040
!	%f0  = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	%f4  = 1c16487d c7407846 7bd5e73f a750d99c
!	%f8  = 271a96aa 3d716042 a2adfa61 5f0192dc
!	%f12 = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x0c0,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 00000000198000c0
!	Mem[0000000070800014] = 7f3d6c55, %l1 = 00000000000000fc
	lduba	[%o1+0x015]%asi,%l1	! %l1 = 000000000000003d
!	Mem[0000000071000050] = 9c000e2e fe2c8e3f, %l6 = 00000058, %l7 = 2459d439
	ldda	[%o2+0x050]%asi,%l6	! %l6 = 000000009c000e2e 00000000fe2c8e3f

p2_label_130:
!	Mem[000000001a000084] = 2fe904b1, %l2 = ffffffffffff99ad
	lduw	[%i4+0x084],%l2		! %l2 = 000000002fe904b1
!	%l0 = ffffffff8bda0f08, %l3 = 0000000000000000, %l4 = 8001c1d300007003
	srax	%l0,%l3,%l4		! %l4 = ffffffff8bda0f08
!	Mem[0000000072000018] = c62e3c6f3a316bfe, %l6 = 000000009c000e2e
	ldx	[%o4+0x018],%g2		! %g2 = c62e3c6f3a316bfe
!	Mem[0000000019000154] = e6566585, %l2 = 000000002fe904b1
	lduba	[%i2+0x155]%asi,%l2	! %l2 = 0000000000000056
!	%l2 = 0000000000000056, Mem[0000000019000000] = 30f269a5f8320370
	stxa	%l2,[%i2+%g0]0x80	! Mem[0000000019000000] = 0000000000000056

p2_label_131:
!	Mem[0000000071800010] = 00000000, %l6 = 000000009c000e2e
	ldsba	[%o3+0x010]%asi,%l6	! %l6 = 0000000000000000
!	Mem[0000000018800154] = 663f3851, %l7 = 00000000fe2c8e3f
	lduw	[%i1+0x154],%l7		! %l7 = 00000000663f3851
!	Mem[00000000188000c0] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[00000000188000d0] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[00000000188000e0] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[00000000188000f0] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 00000000188000c0
!	Mem[0000000071000010] = 9d0d6da6, %l0 = ffffffff8bda0f08
	ldsha	[%o2+0x012]%asi,%l0	! %l0 = 0000000000006da6
	bn	p2_not_taken_0		! Branch Not Taken, %ccr = 80

p2_label_132:
!	Mem[0000000019800020] = 3e99377e 98b942a7, %l0 = 00006da6, %l1 = 0000003d
	ldd	[%i3+0x020],%l0		! %l0 = 000000003e99377e 0000000098b942a7
p2_b55:
!	%f0  = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	%f4  = 1c16487d c7407846 7bd5e73f a750d99c
!	%f8  = 271a96aa 3d716042 a2adfa61 5f0192dc
!	%f12 = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	stda	%f0,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[0000000070800010] = 000000007f3d6c55, %l4 = ffffffff8bda0f08
	ldxa	[%o1+0x010]%asi,%l4	! %l4 = 000000007f3d6c55
!	Mem[000000001b000040] = 60950f4a 1eff4407 70ef5070 b21561d5
!	Mem[000000001b000050] = 02d595fe 9cc7a51a 7e2e4d51 6a74b614
!	Mem[000000001b000060] = 4c8f3244 4e9820d2 1a199d71 eabe4a1a
!	Mem[000000001b000070] = 285d71eb df58c47c 2a09cab1 75e8ee45
	ldda	[%i6+%g6]ASI_BLK_P,%f0	! Block Load from 000000001b000040
	membar	#Sync			! Added by membar checker (137)
	set	p2_b56,%o7
	fba,pt	%fcc3,p2_near_2_he	! Branch Taken, %fcc3 = 0

p2_label_133:
!	Mem[0000000018000000] = 988b18bd, %l3 = 0000000000000000
	lduwa	[%i0+%g0]0x80,%l3	! %l3 = 00000000988b18bd
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x038,%g2
p2_b56:
!	Registers modified during the branch to p2_near_2
!	%l0  = 0000000098b94042
!	%l1  = dfe43fd7989662c1
!	%l2  = 0000000000000000
!	%l3  = c04617fb1b5aa8d6
!	%l5  = ffffffffffffffbb
!	Mem[00000000180000c0] = a7a85772 dafc1653 8d5fe119 eb6a7654
!	Mem[00000000180000d0] = 467840c7 7d48161c 9cd950a7 3fe7d57b
!	Mem[00000000180000e0] = 4260713d aa961a27 dc92015f 61faada2
!	Mem[00000000180000f0] = 1b0a271c bedc3150 24e9c881 a16ff7a5
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 00000000180000c0
!	Mem[0000000018800064] = 4d1bc7c8, %l1 = dfe43fd7989662c1
	ldsw	[%i1+0x064],%l1		! %l1 = 000000004d1bc7c8
!	Mem[00000000198001c0] = 6750433a 17f83b08 2b7ac078 c9a9f931
!	Mem[00000000198001d0] = 9d11695d b4e11403 a43513e0 e73ebd66
!	Mem[00000000198001e0] = b80f8558 4d1bc7c8 161afbec f7847f06
!	Mem[00000000198001f0] = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x1c0,%g4
	ldda	[%i3+%g4]ASI_BLK_P,%f16	! Block Load from 00000000198001c0
!	Mem[0000000019000040] = 41663151 83f03e37 1beb59be 8d6dda2b
!	Mem[0000000019000050] = e4d0de7d 3edbfaed c20a673d 52a43808
!	Mem[0000000019000060] = c084dd34 af077279 c6c96134 f0e4d0cf
!	Mem[0000000019000070] = 1e6c046c a2ef179f 5531acaf f0fc6eab
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 0000000019000040

p2_label_134:
!	%f16 = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f20 = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f24 = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f28 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x100,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000018000100
!	%l4 = 000000007f3d6c55, %l1 = 000000004d1bc7c8, %l1 = 000000004d1bc7c8
	andn	%l4,%l1,%l1		! %l1 = 0000000032242815
!	call to call_3, CWP = 0
	membar	#Sync			! Added by membar checker (138)
	call	p2_call_3_le
!	Mem[0000000019800048] = 6d64924c, %l0 = 0000000098b94042
	ldsb	[%i3+0x049],%l0		! %l0 = 0000000000000064
!	Registers modified during the branch to p2_call_3
!	%l0  = 00000000dfe43fd7
!	%l1  = 00000000989662c1
!	%f16 = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f20 = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f24 = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f28 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x040,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 0000000019000040

p2_label_135:
	membar	#Sync
!	Branch On Register, %l7 = 00000000663f3851
	brz,pn	%l7,p2_not_taken_0	! Branch Not Taken
!	%f11 = 61faada2, %f3  = eb6a7654
	fnegs	%f11,%f3 		! %f3  = e1faada2
p2_b57:
	set	p2_b58,%o7
	fbe	p2_far_0_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000019000008] = 4d2416b4 8b110d49, %l4 = 7f3d6c55, %l5 = ffffffbb
	ldda	[%i2+%o6]0x80,%l4	! %l4 = 000000004d2416b4 000000008b110d49
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x03a,%g2
p2_b58:
!	Registers modified during the branch to p2_far_0
!	%l3  = 5892f8401545e874
!	%l7  = 0000000082db4849
!	Mem[0000000018000140] = 41663151 83f03e37 1beb59be 8d6dda2b
!	Mem[0000000018000150] = e4d0de7d 3edbfaed c20a673d 52a43808
!	Mem[0000000018000160] = c084dd34 af077279 c6c96134 f0e4d0cf
!	Mem[0000000018000170] = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x140,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000018000140

p2_label_136:
!	Mem[0000000070800010] = 00000000, %l6 = 0000000000000000
	lduha	[%o1+0x012]%asi,%l6	! %l6 = 0000000000000000
!	Mem[0000000018800000] = 700332f8 a569f230 00000000 3d9817d3
!	Mem[0000000018800010] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800020] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800030] = e5347cd8 82db4849 116dd82b 2b0563c6
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000018800000
!	Mem[00000000188001c4] = a10c235f, %l7 = 0000000082db4849
	ldswa	[%i1+0x1c4]%asi,%l7	! %l7 = ffffffffa10c235f
!	Mem[0000000018800170] = fe6dd9b1 125f7337, %l2 = 00000000, %l3 = 1545e874
	ldd	[%i1+0x170],%l2		! %l2 = 00000000fe6dd9b1 00000000125f7337
!	Mem[000000001880019c] = 6c9971d3, %l4 = 000000004d2416b4
	lduwa	[%i1+0x19c]%asi,%l4	! %l4 = 000000006c9971d3

p2_label_137:
!	Mem[0000000019800068] = bb0dfff8, %l2 = 00000000fe6dd9b1
	ldsha	[%i3+0x06a]%asi,%l2	! %l2 = fffffffffffffff8
!	Mem[0000000019000000] = 00000000 00000056 4d2416b4 8b110d49
!	Mem[0000000019000010] = fd02fbc5 ef3e7b12 3a6761c4 5b0b2707
!	Mem[0000000019000020] = 86979249 3e5938f8 8ab3366a 647c251b
!	Mem[0000000019000030] = 4948db82 d87c34e5 c663052b 2bd86d11
	ldda	[%i2]ASI_BLK_P,%f16	! Block Load from 0000000019000000
!	Mem[0000000018000040] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000018000050] = 00000000 17d7b2c7 9932a6be 5237261e
!	Mem[0000000018000060] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000018000070] = b249411b b8b896fd 3c980de0 9b8764aa
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018000040
!	Mem[00000000180001c0] = 700332f8 a569f230 490d118b b416244d
!	Mem[00000000180001d0] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[00000000180001e0] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[00000000180001f0] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x1c0,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 00000000180001c0
!	Mem[0000000019000000] = 00000000 00000056, %l4 = 6c9971d3, %l5 = 8b110d49
	ldda	[%i2+%g0]0x80,%l4	! %l4 = 0000000000000000 0000000000000056

p2_label_138:
!	Mem[0000000019000008] = 4d2416b48b110d49, %l7 = ffffffffa10c235f
	ldxa	[%i2+%o6]0x80,%l7	! %l7 = 4d2416b48b110d49
!	Mem[000000001980003c] = 6b171ec1, %l5 = 0000000000000056
	lduba	[%i3+0x03f]%asi,%l5	! %l5 = 00000000000000c1
!	Mem[0000000019000110] = edfadb3e7dded0e4, %l2 = fffffffffffffff8
	ldx	[%i2+0x110],%l2		! %l2 = edfadb3e7dded0e4
!	Mem[0000000018000120] = 797207af 34dd84c0, %l6 = 00000000, %l7 = 8b110d49
	ldd	[%i0+0x120],%l6		! %l6 = 00000000797207af 0000000034dd84c0
!	Mem[0000000019000180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019000190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000190001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000190001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 0000000019000180

p2_label_139:
!	Mem[000000001a0001a8] = 7142c906, %l7 = 0000000034dd84c0
	ldsba	[%i4+0x1a8]%asi,%l7	! %l7 = 0000000000000071
!	Mem[00000000180001a8] = 2cf5b810, %l3 = 00000000125f7337
	ldswa	[%i0+0x1a8]%asi,%l3	! %l3 = 000000002cf5b810
!	Mem[0000000072000040] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000072000050] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[0000000072000060] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[0000000072000070] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	ldda	[%o4+%g4]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000019800008] = 03ba24b0, %l0 = 00000000dfe43fd7
	ldswa	[%i3+%o6]0x80,%l0	! %l0 = 0000000003ba24b0
!	%f16 = 928bcc5c a10c235f ba5db460 4809cf74
!	%f20 = c7b2d717 00000000 1e263752 bea63299
!	%f24 = 8a46e57b 7c0149ec 2771b7ca 74fbbed6
!	%f28 = fd96b8b8 1b4149b2 aa64879b e00d983c
	stda	%f16,[%o4+%g4]ASI_BLK_PL	! Block Store to 0000000072000040

p2_label_140:
!	Mem[0000000070000050] = dfe43fd7 989662c1, %l6 = 797207af, %l7 = 00000071
	ldda	[%o0+0x050]%asi,%l6	! %l6 = 00000000dfe43fd7 00000000989662c1
!	Mem[0000000019000040] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000019000050] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000019000060] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000019000070] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000019000040
!	Mem[000000001900005c] = 3d670ac2, %l1 = 00000000989662c1
	ldsb	[%i2+0x05c],%l1		! %l1 = 000000000000003d
!	Mem[0000000019000080] = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	Mem[0000000019000090] = 51383f66 e6566585 d4473cb5 b5d885a2
!	Mem[00000000190000a0] = 4370f915 9caa7ea8 2d50d76b f2517f12
!	Mem[00000000190000b0] = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x080,%g4
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000019000080
!	%f16 = 928bcc5c a10c235f ba5db460 4809cf74
!	%f20 = c7b2d717 00000000 1e263752 bea63299
!	%f24 = 8a46e57b 7c0149ec 2771b7ca 74fbbed6
!	%f28 = fd96b8b8 1b4149b2 aa64879b e00d983c
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 0000000018000180

p2_label_141:
!	Mem[0000000071000054] = fe2c8e3f, %l4 = 0000000000000000
	ldsw	[%o2+0x054],%l4		! %l4 = fffffffffe2c8e3f
	membar	#Sync			! Added by membar checker (139)
!	Mem[0000000072000040] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000072000050] = 00000000 17d7b2c7 9932a6be 5237261e
!	Mem[0000000072000060] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000072000070] = b249411b b8b896fd 3c980de0 9b8764aa
	mov	0x040,%g6
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%l3 = 000000002cf5b810, immed = ffffff3c, %l7 = 00000000989662c1
	andncc	%l3,-0x0c4,%l7		! %l7 = 0000000000000000, %ccr = 44
!	%f0  = be9b9915 23fb4170 e2707d3d 1773fce7
!	%f4  = 856556e6 663f3851 a285d8b5 b53c47d4
!	%f8  = a87eaa9c 15f97043 127f51f2 6bd7502d
!	%f12 = fe6dd9b1 125f7337 034fbe2c bcc4019b
	stda	%f0,[%i5+%g5]ASI_BLK_PL	! Block Store to 000000001a8001c0
!	Mem[0000000071800014] = 2459d439, %l6 = 00000000dfe43fd7
	ldsba	[%o3+0x016]%asi,%l6	! %l6 = ffffffffffffffd4

p2_label_142:
!	Mem[0000000072000000] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000072000010] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[0000000072000020] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[0000000072000030] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
	bcc	p2_b59			! Branch Taken, %ccr = 44, CWP = 0
!	Mem[0000000071000010] = 9d0d6da6 cab52ecb, %l6 = ffffffd4, %l7 = 00000000
	ldd	[%o2+0x010],%l6		! %l6 = 000000009d0d6da6 00000000cab52ecb
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x03b,%g2
p2_b59:
!	Mem[0000000018000100] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000018000110] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000018000120] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000018000130] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	mov	0x100,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000018000100
!	Mem[0000000070000050] = dfe43fd7, %l0 = 0000000003ba24b0
	lduh	[%o0+0x050],%l0		! %l0 = 000000000000dfe4

p2_label_143:
!	Mem[0000000019800070] = 4da91f84, %l0 = 000000000000dfe4
	lduw	[%i3+0x070],%l0		! %l0 = 000000004da91f84
!	Mem[0000000019800100] = e4ee3648 dacb6815 30fdef99 0ef12f86
!	Mem[0000000019800110] = 4bb1e062 f0efee78 c8d537a8 ba8077a7
!	Mem[0000000019800120] = 48b7e1d6 bd621d89 3495e22f 10b8f52c
!	Mem[0000000019800130] = 5dd8b95a 1df5b4b6 dc58c451 5f495260
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000019800100
!	Mem[0000000071000050] = 9c000e2e fe2c8e3f, %l4 = fe2c8e3f, %l5 = 000000c1
	ldd	[%o2+0x050],%l4		! %l4 = 000000009c000e2e 00000000fe2c8e3f
	ba	p2_b60			! Branch Taken, %ccr = 44, CWP = 0
!	Mem[0000000019800000] = 0000d0cf, %l5 = 00000000fe2c8e3f
	ldsha	[%i3+%g0]0x80,%l5	! %l5 = 0000000000000000
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p2_branch_failed
	mov	0x03c,%g2
p2_b60:

p2_label_144:
!	Mem[0000000072000000] = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	Mem[0000000072000010] = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	Mem[0000000072000020] = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	Mem[0000000072000030] = d852663a 841fa94d 012e213e bb7139a6
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[0000000019000000] = 00000000, %l0 = 000000004da91f84
	lduwa	[%i2+%g0]0x80,%l0	! %l0 = 0000000000000000
!	Mem[0000000018800140] = be9b9915 23fb4170 e2707d3d 1773fce7
!	Mem[0000000018800150] = 856556e6 663f3851 a285d8b5 b53c47d4
!	Mem[0000000018800160] = a87eaa9c 15f97043 127f51f2 6bd7502d
!	Mem[0000000018800170] = fe6dd9b1 125f7337 034fbe2c bcc4019b
	mov	0x140,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 0000000018800140
!	Mem[00000000198001b8] = b4c33deeb5d524f7, %l3 = 000000002cf5b810
	ldx	[%i3+0x1b8],%l3		! %l3 = b4c33deeb5d524f7
	fblg,a	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0

p2_label_145:
!	Mem[0000000071800010] = 000000002459d439, %l7 = 00000000cab52ecb
	ldx	[%o3+0x010],%l7		! Annulled
p2_b61:
!	Mem[0000000019000000] = 00000000, %l4 = 000000009c000e2e
	ldswa	[%i2+%g0]0x80,%l4	! %l4 = 0000000000000000
	membar	#Sync			! Added by membar checker (140)
!	Branch On Register, %l2 = edfadb3e7dded0e4
	brnz,pt	%l2,p2_b62		! Branch Taken
!	Mem[0000000071000010] = 9d0d6da6cab52ecb, %l3 = b4c33deeb5d524f7
	ldx	[%o2+0x010],%l3		! %l3 = 9d0d6da6cab52ecb
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x03e,%g2
p2_b62:
!	Branch On Register, %l1 = 000000000000003d
	brgz,pt	%l1,p2_b63		! Branch Taken

p2_label_146:
!	Mem[0000000019000000] = 00000000, %l4 = 0000000000000000
	lduwa	[%i2+%g0]0x80,%l4	! %l4 = 0000000000000000
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x03f,%g2
p2_b63:
!	%l4 = 0000000000000000, Mem[0000000018800008] = 000000003d9817d3
	stxa	%l4,[%i1+%o6]0x80	! Mem[0000000018800008] = 0000000000000000
!	Mem[0000000019000040] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000019000050] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000019000060] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000019000070] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	mov	0x040,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000019000040
!	Mem[0000000018800040] = 6750433a 17f83b08 2b7ac078 c9a9f931
!	Mem[0000000018800050] = 9d11695d b4e11403 a43513e0 e73ebd66
!	Mem[0000000018800060] = b80f8558 4d1bc7c8 161afbec f7847f06
!	Mem[0000000018800070] = 370df286 9f00911f b4c33dee b5d524f7
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000018800040
!	Mem[0000000018000084] = ac8cd40c, %l5 = 0000000000000000
	ldstuba	[%i0+0x084]%asi,%l5	! %l5 = 00000000000000ac

p2_label_147:
!	Mem[0000000070000010] = 8001c1d3, %f31 = 51c458dc
	ld	[%o0+0x010],%f31	! %f31 = 8001c1d3
	membar	#Sync			! Added by membar checker (141)
!	Branch On Register, %l6 = 000000009d0d6da6
	brgez,pt %l6,p2_b64		! Branch Taken
!	Mem[0000000018800060] = b80f8558, %l1 = 000000000000003d
	lduh	[%i1+0x062],%l1		! %l1 = 0000000000008558
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p2_branch_failed
	mov	0x040,%g2
p2_b64:
!	%f0  = 083bf817 3a435067 31f9a9c9 78c07a2b
!	%f4  = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	%f8  = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	%f12 = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	%l4 = 0000000000000000, %l6 = 000000009d0d6da6, %l7 = 00000000cab52ecb
	taddcc	%l4,%l6,%l7		! %l7 = 000000009d0d6da6, %ccr = 0a

p2_label_148:
!	%f16 = 1568cbda 4836eee4 862ff10e 99effd30
!	%f20 = 78eeeff0 62e0b14b a77780ba a837d5c8
!	%f24 = 891d62bd d6e1b748 2cf5b810 2fe29534
!	%f28 = b6b4f51d 5ab9d85d 6052495f 8001c1d3
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 0000000019000000
	membar	#Sync			! Added by membar checker (142)
!	Mem[0000000019000000] = e4ee3648, %l3 = 9d0d6da6cab52ecb
	ldsha	[%i2+%g0]0x80,%l3	! %l3 = ffffffffffffe4ee
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000071800010] = 00000000, %l1 = 0000000000008558
	lduwa	[%o3+0x010]%asi,%l1	! %l1 = 0000000000000000
!	Mem[0000000071000054] = fe2c8e3f, %l2 = edfadb3e7dded0e4
	lduba	[%o2+0x057]%asi,%l2	! %l2 = 000000000000003f

p2_label_149:
!	%f16 = 1568cbda 4836eee4 862ff10e 99effd30
!	%f20 = 78eeeff0 62e0b14b a77780ba a837d5c8
!	%f24 = 891d62bd d6e1b748 2cf5b810 2fe29534
!	%f28 = b6b4f51d 5ab9d85d 6052495f 8001c1d3
	mov	0x1c0,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 00000000188001c0
!	Mem[0000000070800014] = 7f3d6c55, %l2 = 000000000000003f
	swapa	[%o1+0x014]%asi,%l2	! %l2 = 000000007f3d6c55
!	%f0  = 083bf817 3a435067 31f9a9c9 78c07a2b
!	%f4  = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	%f8  = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	%f12 = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 0000000019800140
!	Mem[0000000018800098] = c62e3c6f3a316bfe, %l0 = 0000000000000000
	ldx	[%i1+0x098],%l0		! %l0 = c62e3c6f3a316bfe
!	Mem[0000000018000000] = 988b18bd d8289b24 6d64924c cb72efd9
!	Mem[0000000018000010] = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	Mem[0000000018000020] = 8e534add 4b60c30b bb0dfff8 27a27954
!	Mem[0000000018000030] = 4da91f84 3a6652d8 a63971bb 3e212e01
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000018000000

p2_label_150:
!	Mem[000000001800019c] = bea63299, %l5 = 00000000000000ac
	lduwa	[%i0+0x19c]%asi,%l5	! %l5 = 00000000bea63299
!	Mem[0000000070000010] = 8001c1d3, %l1 = 0000000000000000
	lduha	[%o0+0x012]%asi,%l1	! %l1 = 000000000000c1d3
	membar	#Sync			! Added by membar checker (143)
!	%f16 = 249b28d8 bd188b98 d9ef72cb 4c92646d
!	%f20 = e52ad4fe 967ebf7f c62e3c6f 3a316bfe
!	%f24 = 0bc3604b dd4a538e 5479a227 f8ff0dbb
!	%f28 = d852663a 841fa94d 012e213e bb7139a6
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l6 = 000000009d0d6da6, immed = fffff0a4, %y  = fffff3a2
	sdiv	%l6,-0xf5c,%l0		! %l0 = 000000007fffffff
	mov	%l0,%y			! %y = 7fffffff
	fbne	%fcc0,p2_branch_failed	! Branch Not Taken, %fcc0 = 0

p2_label_151:
!	Mem[0000000070800014] = 0000003f, %l0 = 000000007fffffff
	lduw	[%o1+0x014],%l0		! %l0 = 000000000000003f
p2_b65:
!	%f0  = 083bf817 3a435067 31f9a9c9 78c07a2b
!	%f4  = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	%f8  = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	%f12 = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	stda	%f0,[%i1]ASI_BLK_P	! Block Store to 0000000018800000
!	Mem[0000000018000080] = 80d9214d ff8cd40c 75097ae7 4e60f18f
!	Mem[0000000018000090] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[00000000180000a0] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[00000000180000b0] = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000018000080
!	Mem[0000000019000000] = e4ee3648, %l7 = 000000009d0d6da6
	lduwa	[%i2+%g0]0x80,%l7	! %l7 = 00000000e4ee3648
!	Mem[0000000070000010] = 8001c1d3, %l2 = 000000007f3d6c55
	ldswa	[%o0+0x010]%asi,%l2	! %l2 = ffffffff8001c1d3

p2_label_152:
!	%f0  = 083bf817 3a435067 31f9a9c9 78c07a2b
!	%f4  = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	%f8  = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	%f12 = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	stda	%f0,[%i1+%g4]ASI_BLK_PL	! Block Store to 00000000188001c0
	membar	#Sync
	bvs,a	p2_b66			! Branch Taken, %ccr = 0a, CWP = 0
!	Mem[00000000198000f8] = a5f76fa181c8e924, %l1 = 000000000000c1d3
	ldx	[%i3+0x0f8],%l1		! %l1 = a5f76fa181c8e924
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p2_branch_failed
	mov	0x042,%g2
p2_b66:
!	%f16 = 0cd48cff 4d21d980 8ff1604e e77a0975
!	%f20 = a9fde95e db41c0a5 080fda8b eeaac6c7
!	%f24 = 2d2517bf ca799dff 031df97c f6051aca
!	%f28 = c7c7c1ed 4b8c7413 a8ccac40 858dad99
	mov	0x0c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000180000c0
!	Mem[0000000018000008] = 6d64924c, %l6 = 000000009d0d6da6
	ldsha	[%i0+%o6]0x80,%l6	! %l6 = 0000000000006d64

p2_label_153:
!	Mem[0000000018000080] = 80d9214dff8cd40c, %l0 = 000000000000003f
	ldx	[%i0+0x080],%l0		! %l0 = 80d9214dff8cd40c
!	Mem[00000000190001cc] = 4e60f18f, %l0 = 80d9214dff8cd40c
	ldsb	[%i2+0x1ce],%l0		! %l0 = fffffffffffffff1
	bne,a	p2_b67			! Branch Taken, %ccr = 0a, CWP = 0
!	Mem[0000000070000054] = 989662c1, %l4 = 0000000000000000
	ldub	[%o0+0x056],%l4		! %l4 = 0000000000000062
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p2_branch_failed
	mov	0x043,%g2
p2_b67:
!	%f12 = 1f91009f 86f20d37, %f10 = 067f84f7 ecfb1a16
	fmovd	%f12,%f10		! %f10 = 1f91009f 86f20d37

p2_label_154:
	membar	#Sync			! Added by membar checker (144)
	set	p2_b68,%o7
	fbue,pt	%fcc3,p2_near_0_le	! Branch Taken, %fcc3 = 0
!	Mem[000000001a000008] = bbba0528, %l0 = fffffffffffffff1
	ldsba	[%i4+%o6]0x80,%l0	! %l0 = ffffffffffffffbb
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p2_branch_failed
	mov	0x044,%g2
p2_b68:
!	Registers modified during the branch to p2_near_0
!	%l4  = ffffffffd6befb74
!	%l5  = 2771b7ca74fbbed6
!	Mem[0000000019000008] = 30fdef99 0ef12f86, %l4 = d6befb74, %l5 = 74fbbed6
	ldda	[%i2+%o6]0x80,%l4	! %l4 = 0000000030fdef99 000000000ef12f86
!	Mem[0000000019800008] = 03ba24b0, %l2 = ffffffff8001c1d3
	ldswa	[%i3+%o6]0x80,%l2	! %l2 = 0000000003ba24b0
!	Mem[00000000190000c0] = 41663151 83f03e37 1beb59be 8d6dda2b
!	Mem[00000000190000d0] = e4d0de7d 3edbfaed c20a673d 52a43808
!	Mem[00000000190000e0] = c084dd34 af077279 c6c96134 f0e4d0cf
!	Mem[00000000190000f0] = 1e6c046c a2ef179f 5531acaf f0fc6eab
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 00000000190000c0

p2_label_155:
!	%f22 = 080fda8b eeaac6c7, %f16 = 0cd48cff 4d21d980
	fcmpd	%fcc3,%f22,%f16		! %fcc3 = 1
!	Mem[0000000070800014] = 0000003f, %l6 = 0000000000006d64
	lduha	[%o1+0x016]%asi,%l6	! %l6 = 000000000000003f
!	Mem[0000000018000198] = 1e263752, %l7 = 00000000e4ee3648
	lduw	[%i0+0x198],%l7		! %l7 = 000000001e263752
!	Mem[0000000070000050] = dfe43fd7989662c1, %l7 = 000000001e263752
	ldx	[%o0+0x050],%l7		! %l7 = dfe43fd7989662c1
!	Mem[00000000190001f0] = 13748c4bedc1c7c7, %l1 = a5f76fa181c8e924
	ldx	[%i2+0x1f0],%l1		! %l1 = 13748c4bedc1c7c7

p2_label_156:
!	Mem[0000000019800100] = e4ee3648 dacb6815 30fdef99 0ef12f86
!	Mem[0000000019800110] = 4bb1e062 f0efee78 c8d537a8 ba8077a7
!	Mem[0000000019800120] = 48b7e1d6 bd621d89 3495e22f 10b8f52c
!	Mem[0000000019800130] = 5dd8b95a 1df5b4b6 dc58c451 5f495260
	mov	0x100,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000019800100
!	%f16 = 1568cbda 4836eee4 862ff10e 99effd30
!	%f20 = 78eeeff0 62e0b14b a77780ba a837d5c8
!	%f24 = 891d62bd d6e1b748 2cf5b810 2fe29534
!	%f28 = b6b4f51d 5ab9d85d 6052495f 51c458dc
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 00000000188000c0
!	Mem[0000000018000198] = 1e263752bea63299, %l2 = 0000000003ba24b0
	ldx	[%i0+0x198],%l2		! %l2 = 1e263752bea63299
!	Mem[0000000071000054] = fe2c8e3f, %l2 = 1e263752bea63299
	ldsh	[%o2+0x056],%l2		! %l2 = ffffffffffff8e3f
!	Mem[00000000180001c0] = 700332f8 a569f230 490d118b b416244d
!	Mem[00000000180001d0] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[00000000180001e0] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[00000000180001f0] = e5347cd8 82db4849 116dd82b 2b0563c6
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 00000000180001c0

p2_label_157:
	membar	#Sync			! Added by membar checker (145)
!	%f16 = 1568cbda 4836eee4 862ff10e 99effd30
!	%f20 = 78eeeff0 62e0b14b a77780ba a837d5c8
!	%f24 = 891d62bd d6e1b748 2cf5b810 2fe29534
!	%f28 = b6b4f51d 5ab9d85d 6052495f 51c458dc
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 00000000188000c0
!	Mem[0000000018000100] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000018000110] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000018000120] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000018000130] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000018000100
!	%l1 = 13748c4bedc1c7c7, Mem[0000000018000064] = 7be5468a
	stba	%l1,[%i0+0x064]%asi	! Mem[0000000018000064] = c7e5468a
!	%l6 = 000000000000003f, %l3 = ffffffffffffe4ee, %y  = 7fffffff
	sdivx	%l6,%l3,%l4		! %l4 = 0000000000000000
!	%l7 = dfe43fd7989662c1, Mem[0000000070000052] = dfe43fd7
	sth	%l7,[%o0+0x052]		! Mem[0000000070000050] = dfe462c1

p2_label_158:
	bpos	p2_not_taken_0		! Branch Not Taken, %ccr = 0a
!	%l6 = 000000000000003f, immed = 00000b96, %l6 = 000000000000003f
	and	%l6,0xb96,%l6		! %l6 = 0000000000000016
p2_b69:
!	Mem[0000000072000040] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000072000050] = 00000000 17d7b2c7 9932a6be 5237261e
!	Mem[0000000072000060] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000072000070] = b249411b b8b896fd 3c980de0 9b8764aa
	mov	0x040,%g4
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000072000078] = 3c980de0, %l1 = 13748c4bedc1c7c7
	lduw	[%o4+0x078],%g2		! %g2 = 13748c4bedc1c7c7
!	Mem[00000000180001c0] = 700332f8 a569f230, %l2 = ffff8e3f, %l3 = ffffe4ee
	ldd	[%i0+0x1c0],%l2		! %l2 = 00000000700332f8 00000000a569f230

p2_label_159:
!	Mem[0000000072000040] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000072000050] = 00000000 17d7b2c7 9932a6be 5237261e
!	Mem[0000000072000060] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000072000070] = b249411b b8b896fd 3c980de0 9b8764aa
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%l0 = ffffffffffffffbb, %l0 = ffffffffffffffbb, %y  = 7fffffff
	sdiv	%l0,%l0,%l6		! %l6 = ffffffff80000000
	mov	%l0,%y			! %y = ffffffbb
!	Mem[000000001800008c] = 4e60f18f, %l2 = 00000000700332f8
	lduha	[%i0+0x08e]%asi,%l2	! %l2 = 000000000000f18f
!	Mem[0000000018800180] = 8dff5460 49afbd2a 36a5cd51 60aaf97e
!	Mem[0000000018800190] = f1821167 343921d6 f973e999 6c9971d3
!	Mem[00000000188001a0] = db347a1a 2389ad9c a87eaa9c 15f97043
!	Mem[00000000188001b0] = bb96a0f5 74cc77a5 8073d2ef 40706d79
	mov	0x180,%g4
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018800180
!	%f0  = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f4  = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f8  = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f12 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x140,%g5
	stda	%f0,[%i1+%g5]ASI_BLK_PL	! Block Store to 0000000018800140

p2_label_160:
!	Mem[0000000071000010] = 9d0d6da6 cab52ecb, %l0 = ffffffbb, %l1 = edc1c7c7
	ldd	[%o2+0x010],%l0		! %l0 = 000000009d0d6da6 00000000cab52ecb
!	%f0  = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f4  = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f8  = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f12 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x0c0,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000198000c0
!	Mem[0000000018800000] = 083bf817, %l7 = dfe43fd7989662c1
	ldsha	[%i1+%g0]0x80,%l7	! %l7 = 000000000000083b
!	Mem[0000000019800140] = 083bf817 3a435067 31f9a9c9 78c07a2b
!	Mem[0000000019800150] = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	Mem[0000000019800160] = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	Mem[0000000019800170] = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	ldda	[%i3+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000019800140
!	Mem[0000000018000008] = 6d64924c, %l7 = 000000000000083b
	lduha	[%i0+%o6]0x80,%l7	! %l7 = 0000000000006d64

p2_label_161:
!	Mem[0000000072000040] = 5f230ca1 5ccc8b92 74cf0948 60b45dba
!	Mem[0000000072000050] = 00000000 17d7b2c7 9932a6be 5237261e
!	Mem[0000000072000060] = ec49017c 7be5468a d6befb74 cab77127
!	Mem[0000000072000070] = b249411b b8b896fd 3c980de0 9b8764aa
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[00000000180001c0] = 700332f8 a569f230 490d118b b416244d
!	Mem[00000000180001d0] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[00000000180001e0] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[00000000180001f0] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x1c0,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f16	! Block Load from 00000000180001c0
!	Mem[0000000071800010] = 000000002459d439, %l2 = 000000000000f18f
	ldx	[%o3+0x010],%l2		! %l2 = 000000002459d439
	membar	#Sync			! Added by membar checker (146)
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000198000c0
!	Mem[00000000180001d0] = 127b3eefc5fb02fd, %l3 = 00000000a569f230
	ldx	[%i0+0x1d0],%l3		! %l3 = 127b3eefc5fb02fd

p2_label_162:
!	%l7 = 0000000000006d64, immed = 0000001e, %l7 = 0000000000006d64
	srax	%l7,0x01e,%l7		! %l7 = 0000000000000000
	bgu	p2_b70			! Branch Taken, %ccr = 0a, CWP = 0
!	%f24 = 86979249 3e5938f8, %f24 = 86979249 3e5938f8, %f16 = 30f269a5 f8320370
	fdivd	%f24,%f24,%f16		! %f16 = 3ff00000 00000000
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p2_branch_failed
	mov	0x046,%g2
p2_b70:
	bvc,a	p2_not_taken_0		! Branch Not Taken, %ccr = 0a
!	Mem[0000000071800010] = 000000002459d439, %l3 = 127b3eefc5fb02fd
	ldx	[%o3+0x010],%l3		! Annulled
p2_b71:

p2_label_163:
!	%l3 = 127b3eefc5fb02fd, immed = 00000faa, %y  = ffffffbb
	umul	%l3,0xfaa,%l0		! %l0 = 00000c1d2ddccf02
!	Mem[00000000190001c0] = 80d9214dac8cd40c, %l5 = 000000000ef12f86
	ldxa	[%i2+0x1c0]%asi,%l5	! %l5 = 80d9214dac8cd40c
	membar	#Sync			! Added by membar checker (147)
!	%f16 = 3ff00000 00000000 4d2416b4 8b110d49
!	%f20 = fd02fbc5 ef3e7b12 3a6761c4 5b0b2707
!	%f24 = 86979249 3e5938f8 8ab3366a 647c251b
!	%f28 = 4948db82 d87c34e5 c663052b 2bd86d11
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 00000000198000c0
	ba,a	p2_b72			! Branch Taken, %ccr = 0a, CWP = 0
!	Mem[0000000019000128] = cfd0e4f03461c9c6, %l1 = 00000000cab52ecb
	ldx	[%i2+0x128],%l1		! Annulled
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p2_branch_failed
	mov	0x048,%g2
p2_b72:

p2_label_164:
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 00000000188001c0
!	Mem[0000000018800000] = 083bf817, %l4 = 0000000000000000
	lduha	[%i1+%g0]0x80,%l4	! %l4 = 000000000000083b
!	Mem[0000000018800000] = 083bf8173a435067, %l1 = 00000000cab52ecb
	ldxa	[%i1+%g0]0x80,%l1	! %l1 = 083bf8173a435067
!	Mem[0000000018000148] = 1beb59be8d6dda2b, %l0 = 00000c1d2ddccf02
	ldx	[%i0+0x148],%l0		! %l0 = 1beb59be8d6dda2b
!	Mem[0000000018800100] = 700332f8 a569f230 490d118b b416244d
!	Mem[0000000018800110] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800120] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800130] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x100,%g4
	ldda	[%i1+%g4]ASI_BLK_P,%f16	! Block Load from 0000000018800100

p2_label_165:
!	Mem[0000000070800014] = 0000003f, %l5 = 80d9214dac8cd40c
	lduba	[%o1+0x015]%asi,%l5	! %l5 = 0000000000000000
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000040a00038] = 1815b110, %l3 = 127b3eefc5fb02fd
	lduha	[%o5+0x038]%asi,%l3	! %l3 = 0000000000001815
!	Mem[0000000019800128] = 3495e22f10b8f52c, %l2 = 000000002459d439
	ldxa	[%i3+0x128]%asi,%l2	! %l2 = 3495e22f10b8f52c
!	%f17 = a569f230, Mem[0000000071000054] = fe2c8e3f
	st	%f17,[%o2+0x054]	! Mem[0000000071000054] = a569f230

p2_label_166:
!	Mem[0000000070800010] = 00000000, %l6 = ffffffff80000000
	ldub	[%o1+0x010],%l6		! %l6 = 0000000000000000
	membar	#Sync
	bl,a	p2_not_taken_0		! Branch Not Taken, %ccr = 0a
!	Mem[0000000018800128] = 1b257c64, %l1 = 083bf8173a435067
	lduw	[%i1+0x128],%l1		! Annulled
p2_b73:
!	Mem[0000000019000008] = 30fdef99, %l7 = 0000000000000000
	ldsha	[%i2+%o6]0x80,%l7	! %l7 = 00000000000030fd
!	Mem[0000000018800000] = 083bf817, %l7 = 00000000000030fd
	lduha	[%i1+%g0]0x80,%l7	! %l7 = 000000000000083b

p2_label_167:
	ble	p2_not_taken_0		! Branch Not Taken, %ccr = 0a
!	%l7 = 000000000000083b, %l0 = 1beb59be8d6dda2b, %l2 = 3495e22f10b8f52c
	xnorcc	%l7,%l0,%l2		! %l2 = e414a64172922def, %ccr = 80
p2_b74:
!	Mem[0000000018800008] = 31f9a9c978c07a2b, %l6 = 0000000000000000
	ldxa	[%i1+%o6]0x80,%l6	! %l6 = 31f9a9c978c07a2b
!	Mem[0000000019000180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019000190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000190001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000190001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000019000180
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	mov	0x040,%g4
	stda	%f32,[%o4+%g4]ASI_BLK_P	! Block Store to 0000000072000040

p2_label_168:
!	Mem[0000000071800014] = 2459d439, %l5 = 0000000000000000
	lduw	[%o3+0x014],%l5		! %l5 = 000000002459d439
!	Mem[00000000188001c0] = 6750433a 17f83b08 2b7ac078 c9a9f931
!	Mem[00000000188001d0] = 9d11695d b4e11403 a43513e0 e73ebd66
!	Mem[00000000188001e0] = b80f8558 4d1bc7c8 161afbec f7847f06
!	Mem[00000000188001f0] = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x1c0,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 00000000188001c0
!	Mem[0000000019000020] = 48b7e1d6bd621d89, %l4 = 000000000000083b
	ldxa	[%i2+0x020]%asi,%l4	! %l4 = 48b7e1d6bd621d89
!	Mem[0000000018800000] = 083bf817, %l2 = e414a64172922def
	ldswa	[%i1+%g0]0x80,%l2	! %l2 = 00000000083bf817
!	%f23 = c461673a, %f24 = f838593e 49929786
	fstod	%f23,%f24		! %f24 = c08c2ce7 40000000

p2_label_169:
!	%f16 = 700332f8 a569f230 490d118b b416244d
!	%f20 = 127b3eef c5fb02fd 07270b5b c461673a
!	%f24 = c08c2ce7 40000000 1b257c64 6a36b38a
!	%f28 = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x100,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 0000000019800100
!	Mem[0000000019000008] = 30fdef99, %l7 = 000000000000083b
	lduha	[%i2+%o6]0x80,%l7	! %l7 = 00000000000030fd
!	%f1  = 17f83b08, Mem[0000000070000050] = dfe462c1
	st	%f1 ,[%o0+0x050]	! Mem[0000000070000050] = 17f83b08
!	Mem[0000000040a00038] = 1815b110, %l1 = 083bf8173a435067
	lduw	[%o5+0x038],%l1		! %l1 = 000000001815b110
!	Mem[0000000018800008] = 31f9a9c9 78c07a2b, %l6 = 78c07a2b, %l7 = 000030fd
	ldda	[%i1+%o6]0x80,%l6	! %l6 = 0000000031f9a9c9 0000000078c07a2b

p2_label_170:
!	Mem[000000001a800140] = 0000808b c33dde41 f94f59f8 fc163c57
!	Mem[000000001a800150] = 1f17d764 d83c1332 0c595bec b83bd987
!	Mem[000000001a800160] = 74e84515 40f89258 7fe42e50 9d642253
!	Mem[000000001a800170] = 18fece23 810a395f d1de98ce 2b5953d3
	mov	0x140,%g5
	ldda	[%i5+%g5]ASI_BLK_PL,%f16	! Block Load from 000000001a800140
!	Mem[0000000071800010] = 000000002459d439, %l4 = 48b7e1d6bd621d89
	ldx	[%o3+0x010],%l4		! %l4 = 000000002459d439
!	%f16 = 41de3dc3 8b800000 573c16fc f8594ff9
!	%f20 = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f24 = 5892f840 1545e874 5322649d 502ee47f
!	%f28 = 5f390a81 23cefe18 d353592b ce98ded1
	mov	0x180,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000019800180
!	Mem[0000000070000014] = 00007003, %l2 = 00000000083bf817
	lduwa	[%o0+0x014]%asi,%l2	! %l2 = 0000000000007003
!	Mem[0000000071800054] = 7f3d6c55, %l2 = 0000000000007003
	ldsw	[%o3+0x054],%l2		! %l2 = 000000007f3d6c55

p2_label_171:
!	Mem[0000000019800000] = 0000d0cf, %l5 = 000000002459d439
	lduwa	[%i3+%g0]0x80,%l5	! %l5 = 000000000000d0cf
!	Mem[0000000071000014] = cab52ecb, %l7 = 0000000078c07a2b
	lduba	[%o2+0x015]%asi,%l7	! %l7 = 00000000000000b5
!	Mem[0000000072000000] = 083bf817 3a435067 31f9a9c9 78c07a2b
!	Mem[0000000072000010] = 0314e1b4 5d69119d 66bd3ee7 e01335a4
!	Mem[0000000072000020] = c8c71b4d 58850fb8 067f84f7 ecfb1a16
!	Mem[0000000072000030] = 1f91009f 86f20d37 f724d5b5 ee3dc3b4
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	%f14 = b4c33dee b5d524f7, %f18 = 573c16fc f8594ff9
	fnegd	%f14,%f18		! %f18 = 34c33dee b5d524f7
!	Mem[0000000018000008] = 6d64924ccb72efd9, %l7 = 00000000000000b5
	ldxa	[%i0+%o6]0x80,%l7	! %l7 = 6d64924ccb72efd9

p2_label_172:
!	%l0 = 1beb59be8d6dda2b, Mem[0000000019800000] = 0000d0cf
	stwa	%l0,[%i3+%g0]0x80	! Mem[0000000019800000] = 8d6dda2b
!	Mem[0000000019800008] = 03ba24b0 ddb1cb9a, %l4 = 2459d439, %l5 = 0000d0cf
	ldda	[%i3+%o6]0x80,%l4	! %l4 = 0000000003ba24b0 00000000ddb1cb9a
!	%l3 = 0000000000001815, immed = fffffdcc, %l5 = 00000000ddb1cb9a
	andncc	%l3,-0x234,%l5		! %l5 = 0000000000000011, %ccr = 00
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l6 = 0000000031f9a9c9
	ldx	[%o3+0x050],%l6		! %l6 = 2ea7bc867f3d6c55
!	Mem[0000000071800050] = 2ea7bc86 7f3d6c55, %l2 = 7f3d6c55, %l3 = 00001815
	ldd	[%o3+0x050],%l2		! %l2 = 000000002ea7bc86 000000007f3d6c55

p2_label_173:
!	Mem[0000000040a00038] = 1815b110, %l2 = 000000002ea7bc86
	lduba	[%o5+0x038]%asi,%l2	! %l2 = 0000000000000018
!	Mem[0000000019000008] = 30fdef99 0ef12f86, %l0 = 8d6dda2b, %l1 = 1815b110
	ldda	[%i2+%o6]0x80,%l0	! %l0 = 0000000030fdef99 000000000ef12f86
!	Mem[00000000190001e8] = ca1a05f6, %l0 = 0000000030fdef99
	ldub	[%i2+0x1ea],%l0		! %l0 = 0000000000000005
!	Mem[0000000071800010] = 000000002459d439, %l7 = 6d64924ccb72efd9
	ldxa	[%o3+0x010]%asi,%l7	! %l7 = 000000002459d439
!	Mem[000000001a800008] = 5892f840, %l0 = 0000000000000005
	ldsba	[%i5+%o6]0x80,%l0	! %l0 = 0000000000000058

p2_label_174:
!	%l1 = 000000000ef12f86, immed = fffff327, %l6 = 2ea7bc867f3d6c55
	andncc	%l1,-0xcd9,%l6		! %l6 = 0000000000000c80, %ccr = 00
!	Mem[00000000190001a8] = a2adfa61, %l1 = 000000000ef12f86
	ldswa	[%i2+0x1a8]%asi,%l1	! %l1 = ffffffffa2adfa61
!	Mem[0000000019000008] = 30fdef99, %l1 = ffffffffa2adfa61
	lduha	[%i2+%o6]0x80,%l1	! %l1 = 00000000000030fd
!	Mem[00000000180001c0] = 700332f8 a569f230, %l6 = 00000c80, %l7 = 2459d439
	ldd	[%i0+0x1c0],%l6		! %l6 = 00000000700332f8 00000000a569f230
!	Mem[00000000190000e0] = c084dd34, %l5 = 0000000000000011
	ldsw	[%i2+0x0e0],%l5		! %l5 = ffffffffc084dd34

p2_label_175:
!	Mem[0000000018000000] = 988b18bd, %l3 = 000000007f3d6c55
	lduba	[%i0+%g0]0x80,%l3	! %l3 = 0000000000000098
!	Mem[0000000018800064] = 4d1bc7c8, %l5 = ffffffffc084dd34
	ldsh	[%i1+0x064],%l5		! %l5 = 0000000000004d1b
	be,a	p2_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[0000000019000000] = e4ee3648, %l4 = 0000000003ba24b0
	ldswa	[%i2+%g0]0x80,%l4	! Annulled
p2_b75:
	membar	#Sync			! Added by membar checker (148)
!	Mem[0000000019800180] = 41de3dc3, %l2 = 0000000000000018
	ldsba	[%i3+0x181]%asi,%l2	! %l2 = ffffffffffffffde

p2_label_176:
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l3 = 0000000000000098
	ldx	[%o3+0x050],%l3		! %l3 = 2ea7bc867f3d6c55
!	%f32 = ccef02b0 25ffe755 86bfb627 251d547c
!	%f36 = d9a0f2cf 0f798c7c b514cfd1 32665d89
!	%f40 = 1960543b abed0a08 cb2499fc 2a5b7981
!	%f44 = 794f7ba1 4b6ceb30 b5e850ba 96f30623
	stda	%f32,[%o4+%g4]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i2]ASI_BLK_P	! Block Store to 0000000019000000
!	Mem[0000000018800018] = 66bd3ee7, %l1 = 00000000000030fd
	ldub	[%i1+0x018],%l1		! %l1 = 0000000000000066
!	Mem[0000000018000080] = 80d9214d ff8cd40c 75097ae7 4e60f18f
!	Mem[0000000018000090] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[00000000180000a0] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[00000000180000b0] = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 0000000018000080

p2_label_177:
!	%f16 = 80d9214d ff8cd40c 75097ae7 4e60f18f
!	%f20 = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	%f24 = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	%f28 = 13748c4b edc1c7c7 99ad8d85 40accca8
	stda	%f16,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	%f0  = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000018000180
!	%f16 = 80d9214d ff8cd40c 75097ae7 4e60f18f
!	%f20 = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	%f24 = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	%f28 = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x0c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 00000000180000c0
!	Mem[0000000071000010] = 9d0d6da6, %l0 = 0000000000000058
	ldsb	[%o2+0x010],%l0		! %l0 = ffffffffffffff9d
!	%f0  = 6750433a 17f83b08, %f0  = 6750433a 17f83b08, %f0  = 6750433a 17f83b08
	faddd	%f0 ,%f0 ,%f0 		! %f0  = 6760433a 17f83b08

p2_label_178:
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l3 = 2ea7bc867f3d6c55
	ldxa	[%o3+0x050]%asi,%l3	! %l3 = 2ea7bc867f3d6c55
	membar	#Sync			! Added by membar checker (149)
!	Mem[00000000180000d0] = a9fde95e, %l2 = ffffffffffffffde
	ldsb	[%i0+0x0d2],%l2		! %l2 = ffffffffffffffe9
!	Mem[0000000071000014] = cab52ecb, %l7 = 00000000a569f230
	ldub	[%o2+0x017],%l7		! %l7 = 00000000000000cb
!	%l6 = 00000000700332f8, Mem[0000000018800000] = 083bf817
	stha	%l6,[%i1+%g0]0x80	! Mem[0000000018800000] = 32f8f817
	fble,a,pt %fcc1,p2_branch_failed	! Branch Not Taken, %fcc1 = 2

p2_label_179:
!	Mem[0000000018000000] = 988b18bd, %l2 = ffffffffffffffe9
	swapa	[%i0+%g0]0x80,%l2	! Annulled
p2_b76:
!	Mem[00000000190001ac] = 5f0192dc, %l6 = 00000000700332f8
	ldswa	[%i2+0x1ac]%asi,%l6	! %l6 = 000000005f0192dc
!	%l0 = ffffffffffffff9d, %l4 = 0000000003ba24b0, %y  = 00000c1d
	smulcc	%l0,%l4,%l2		! %l2 = fffffffe8f03cff0, %ccr = 88
!	Mem[0000000071800000] = 00000000 00007bf4 0000001f 00005a4e
	prefetcha [%o3+0x000]%asi,2
!	Mem[0000000018800000] = 32f8f817, %l4 = 0000000003ba24b0
	lduba	[%i1+%g0]0x80,%l4	! %l4 = 0000000000000032

p2_label_180:
!	Mem[00000000190001c0] = 80d9214d ac8cd40c 75097ae7 4e60f18f
!	Mem[00000000190001d0] = a5c041db 5ee9fda9 c7c6aaee 8bda0f08
!	Mem[00000000190001e0] = ff9d79ca bf17252d ca1a05f6 7cf91d03
!	Mem[00000000190001f0] = 13748c4b edc1c7c7 99ad8d85 40accca8
	mov	0x1c0,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 00000000190001c0
!	Mem[0000000070800010] = 000000000000003f, %l3 = 2ea7bc867f3d6c55
	ldx	[%o1+0x010],%l3		! %l3 = 000000000000003f
!	%f0  = 6760433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i2+%g5]ASI_BLK_P	! Block Store to 00000000190000c0
!	Mem[0000000018800100] = 700332f8 a569f230 490d118b b416244d
!	Mem[0000000018800110] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800120] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800130] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x100,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 0000000018800100
!	Mem[0000000019800090] = d14b3f696f8db8e1, %l5 = 0000000000004d1b
	ldx	[%i3+0x090],%l5		! %l5 = d14b3f696f8db8e1

p2_label_181:
!	%l0 = ffffffffffffff9d, immed = fffff7db, %l2 = fffffffe8f03cff0
	orncc	%l0,-0x825,%l2		! %l2 = ffffffffffffffbd, %ccr = 88
	fble,a,pt %fcc1,p2_branch_failed	! Branch Not Taken, %fcc1 = 2
!	Mem[00000000198001e8] = 161afbecf7847f06, %f18 = 8ff1604e e77a0975
!	 Annulled
	ldd	[%i3+0x1e8],%f18
p2_b77:
!	Mem[0000000019000140] = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	Mem[0000000019000150] = 51383f66 e6566585 d4473cb5 b5d885a2
!	Mem[0000000019000160] = 4370f915 9caa7ea8 2d50d76b f2517f12
!	Mem[0000000019000170] = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	mov	0x140,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000019000140
!	%l3 = 000000000000003f, Mem[0000000019000078] = ab6efcf0afac3155
	stxa	%l3,[%i2+0x078]%asi	! Mem[0000000019000078] = 000000000000003f

p2_label_182:
!	Mem[0000000018000008] = 6d64924ccb72efd9, %l7 = 00000000000000cb
	ldxa	[%i0+%o6]0x80,%l7	! %l7 = 6d64924ccb72efd9
!	Mem[0000000019000008] = 2b7ac078, %l3 = 000000000000003f
	ldsha	[%i2+%o6]0x80,%l3	! %l3 = 0000000000002b7a
!	Mem[0000000019000140] = 7041fb23 15999bbe e7fc7317 3d7d70e2
!	Mem[0000000019000150] = 51383f66 e6566585 d4473cb5 b5d885a2
!	Mem[0000000019000160] = 4370f915 9caa7ea8 2d50d76b f2517f12
!	Mem[0000000019000170] = 37735f12 b1d96dfe 9b01c4bc 2cbe4f03
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 0000000019000140
!	Mem[0000000071000050] = 9c000e2e a569f230, %l0 = ffffff9d, %l1 = 00000066
	ldd	[%o2+0x050],%l0		! %l0 = 000000009c000e2e 00000000a569f230
	membar	#Sync			! Added by membar checker (150)
	set	p2_b78,%o7
	fbo,a	p2_far_3_he		! Branch Taken, %fcc0 = 0

p2_label_183:
!	Mem[0000000070800054] = 1545e874, %l3 = 0000000000002b7a
	lduw	[%o1+0x054],%l3		! %l3 = 000000001545e874
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p2_branch_failed
	mov	0x04e,%g2
p2_b78:
!	Registers modified during the branch to p2_far_3
!	%l6  = 8001c1d300007003
!	%l7  = ffffffffffffffd0
!	Mem[0000000019000100] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000019000110] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000019000120] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000019000130] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 0000000019000100
!	Mem[0000000071000054] = a569f230, %l6 = 8001c1d300007003
	ldsh	[%o2+0x056],%l6		! %l6 = fffffffffffff230
!	Mem[0000000072000000] = 0cd48cff 4d21d980 8ff1604e e77a0975
!	Mem[0000000072000010] = a9fde95e db41c0a5 080fda8b eeaac6c7
!	Mem[0000000072000020] = 2d2517bf ca799dff 031df97c f6051aca
!	Mem[0000000072000030] = c7c7c1ed 4b8c7413 a8ccac40 858dad99
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	%f0  = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f4  = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f8  = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f12 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x180,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000018000180

p2_label_184:
!	Mem[0000000019800000] = 8d6dda2b 87fd80e3 03ba24b0 ddb1cb9a
!	Mem[0000000019800010] = 70192ade 78266912 ce3f22fb cc08264d
!	Mem[0000000019800020] = 3e99377e 98b942a7 e3779be1 9aa508ee
!	Mem[0000000019800030] = a95ed10c 5e729333 3fb038f0 6b171ec1
	ldda	[%i3]ASI_BLK_P,%f0	! Block Load from 0000000019800000
!	%f0  = 8d6dda2b 87fd80e3 03ba24b0 ddb1cb9a
!	%f4  = 70192ade 78266912 ce3f22fb cc08264d
!	%f8  = 3e99377e 98b942a7 e3779be1 9aa508ee
!	%f12 = a95ed10c 5e729333 3fb038f0 6b171ec1
	mov	0x100,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000019800100
!	Mem[0000000018800008] = 31f9a9c978c07a2b, %l5 = d14b3f696f8db8e1
	ldxa	[%i1+%o6]0x80,%l5	! %l5 = 31f9a9c978c07a2b
!	Mem[0000000070800010] = 000000000000003f, %l2 = ffffffffffffffbd
	ldx	[%o1+0x010],%l2		! %l2 = 000000000000003f
!	Mem[0000000019800180] = 41de3dc3 8b800000 573c16fc f8594ff9
!	Mem[0000000019800190] = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	Mem[00000000198001a0] = 5892f840 1545e874 5322649d 502ee47f
!	Mem[00000000198001b0] = 5f390a81 23cefe18 d353592b ce98ded1
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 0000000019800180

p2_label_185:
!	Mem[0000000070800010] = 00000000, %l7 = ffffffffffffffd0
	lduh	[%o1+0x012],%l7		! %l7 = 0000000000000000
!	Mem[0000000070800050] = 5892f8401545e874, %l7 = 0000000000000000
	ldx	[%o1+0x050],%l7		! %l7 = 5892f8401545e874
!	Mem[0000000019000190] = 1c16487d, %l5 = 31f9a9c978c07a2b
	lduh	[%i2+0x192],%l5		! %l5 = 000000000000487d
!	Mem[0000000071800050] = 2ea7bc86 7f3d6c55, %l6 = fffff230, %l7 = 1545e874
	ldda	[%o3+0x050]%asi,%l6	! %l6 = 000000002ea7bc86 000000007f3d6c55
!	Mem[0000000019800008] = 03ba24b0, %l5 = 000000000000487d
	lduwa	[%i3+%o6]0x80,%l5	! %l5 = 0000000003ba24b0

p2_label_186:
!	Mem[00000000180000d8] = 080fda8b eeaac6c7, %l4 = 00000032, %l5 = 03ba24b0
	ldda	[%i0+0x0d8]%asi,%l4	! %l4 = 00000000080fda8b 00000000eeaac6c7
	bcs	p2_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[0000000019800008] = 03ba24b0, %l3 = 000000001545e874
	ldsha	[%i3+%o6]0x80,%l3	! %l3 = 00000000000003ba
p2_b79:
!	Mem[00000000180001c0] = 700332f8 a569f230 490d118b b416244d
!	Mem[00000000180001d0] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[00000000180001e0] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[00000000180001f0] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x1c0,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 00000000180001c0
!	Mem[0000000018800100] = 700332f8 a569f230 490d118b b416244d
!	Mem[0000000018800110] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800120] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800130] = e5347cd8 82db4849 116dd82b 2b0563c6
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018800100

p2_label_187:
!	Mem[000000001900013c] = afac3155, %l5 = 00000000eeaac6c7
	ldsba	[%i2+0x13f]%asi,%l5	! %l5 = 0000000000000055
!	%f0  = 41de3dc3 8b800000 573c16fc f8594ff9
!	%f4  = 32133cd8 64d7171f 87d93bb8 ec5b590c
!	%f8  = 5892f840 1545e874 5322649d 502ee47f
!	%f12 = 5f390a81 23cefe18 d353592b ce98ded1
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000190001c0
!	Mem[0000000072000000] = 0cd48cff 4d21d980 8ff1604e e77a0975
!	Mem[0000000072000010] = a9fde95e db41c0a5 080fda8b eeaac6c7
!	Mem[0000000072000020] = 2d2517bf ca799dff 031df97c f6051aca
!	Mem[0000000072000030] = c7c7c1ed 4b8c7413 a8ccac40 858dad99
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[00000000190000c0] = 6760433a 17f83b08 2b7ac078 c9a9f931
!	Mem[00000000190000d0] = 9d11695d b4e11403 a43513e0 e73ebd66
!	Mem[00000000190000e0] = b80f8558 4d1bc7c8 161afbec f7847f06
!	Mem[00000000190000f0] = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x0c0,%g4
	ldda	[%i2+%g4]ASI_BLK_P,%f0	! Block Load from 00000000190000c0
!	Mem[0000000019800040] = 988b18bd d8289b24 6d64924c cb72efd9
!	Mem[0000000019800050] = 7fbf7e96 fed42ae5 fe6b313a 6f3c2ec6
!	Mem[0000000019800060] = 8e534add 4b60c30b bb0dfff8 27a27954
!	Mem[0000000019800070] = 4da91f84 3a6652d8 a63971bb 3e212e01
	mov	0x040,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 0000000019800040

p2_label_188:
	membar	#Sync
!	Branch On Register, %l7 = 000000007f3d6c55
	brgez,pn %l7,p2_b80		! Branch Taken
!	Mem[0000000019000008] = 2b7ac078, %l5 = 0000000000000055
	ldsba	[%i2+%o6]0x80,%l5	! %l5 = 000000000000002b
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p2_branch_failed
	mov	0x050,%g2
p2_b80:
!	Mem[0000000019000000] = 6750433a, %l6 = 000000002ea7bc86
	ldsha	[%i2+%g0]0x80,%l6	! %l6 = 0000000000006750
!	Mem[0000000071000050] = 9c000e2e, %l3 = 00000000000003ba
	ldsha	[%o2+0x052]%asi,%l3	! %l3 = 0000000000000e2e
!	Mem[0000000018800008] = 31f9a9c9, %l6 = 0000000000006750
	lduha	[%i1+%o6]0x80,%l6	! %l6 = 00000000000031f9

p2_label_189:
!	Mem[0000000018800140] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000018800150] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000018800160] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000018800170] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	ldda	[%i1+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000018800140
!	Mem[0000000072000040] = 55e7ff25 b002efcc 7c541d25 27b6bf86
!	Mem[0000000072000050] = 7c8c790f cff2a0d9 895d6632 d1cf14b5
!	Mem[0000000072000060] = 080aedab 3b546019 81795b2a fc9924cb
!	Mem[0000000072000070] = 30eb6c4b a17b4f79 2306f396 ba50e8b5
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[000000001a8001c8] = e7fc7317, %l6 = 00000000000031f9
	ldsw	[%i5+0x1c8],%l6		! %l6 = ffffffffe7fc7317
!	%f0  = 6760433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 9f00911f b4c33dee b5d524f7
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 00000000198000c0
!	Mem[0000000071800054] = 7f3d6c55, %l1 = 00000000a569f230
	lduw	[%o3+0x054],%l1		! %l1 = 000000007f3d6c55

p2_label_190:
	bvs,a	p2_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[0000000070000010] = 8001c1d300007003, %l7 = 000000007f3d6c55
	ldx	[%o0+0x010],%l7		! Annulled
p2_b81:
!	Branch On Register, %l0 = 000000009c000e2e
	brlz,pt	%l0,p2_not_taken_0	! Branch Not Taken
!	Mem[0000000019800070] = 4da91f843a6652d8, %l7 = 000000007f3d6c55
	ldx	[%i3+0x070],%l7		! %l7 = 4da91f843a6652d8
p2_b82:
!	Mem[00000000198001c0] = 6750433a 17f83b08 2b7ac078 c9a9f931
!	Mem[00000000198001d0] = 9d11695d b4e11403 a43513e0 e73ebd66
!	Mem[00000000198001e0] = b80f8558 4d1bc7c8 161afbec f7847f06
!	Mem[00000000198001f0] = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x1c0,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 00000000198001c0

p2_label_191:
!	%f16 = 6750433a 17f83b08 2b7ac078 c9a9f931
!	%f20 = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f24 = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f28 = 370df286 9f00911f b4c33dee b5d524f7
	mov	0x080,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 0000000018000080
!	%f12 = 370df286, %f12 = 370df286, %f13 = 9f00911f
	fdivs	%f12,%f12,%f13		! %f13 = 3f800000
!	Mem[0000000018000140] = 41663151 83f03e37 1beb59be 8d6dda2b
!	Mem[0000000018000150] = e4d0de7d 3edbfaed c20a673d 52a43808
!	Mem[0000000018000160] = c084dd34 af077279 c6c96134 f0e4d0cf
!	Mem[0000000018000170] = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x140,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 0000000018000140
!	%f0  = 6760433a 17f83b08 2b7ac078 c9a9f931
!	%f4  = 9d11695d b4e11403 a43513e0 e73ebd66
!	%f8  = b80f8558 4d1bc7c8 161afbec f7847f06
!	%f12 = 370df286 3f800000 b4c33dee b5d524f7
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000018000140] = 4166315183f03e37, %l4 = 00000000080fda8b
	ldx	[%i0+0x140],%l4		! %l4 = 4166315183f03e37

p2_label_192:
!	Mem[0000000071800010] = 000000002459d439, %l4 = 4166315183f03e37
	ldx	[%o3+0x010],%l4		! %l4 = 000000002459d439
!	Mem[0000000018800008] = 31f9a9c9, %l0 = 000000009c000e2e
	ldswa	[%i1+%o6]0x80,%l0	! %l0 = 0000000031f9a9c9
!	Mem[0000000071000014] = cab52ecb, %l0 = 0000000031f9a9c9
	ldsb	[%o2+0x016],%l0		! %l0 = 000000000000002e
!	Mem[0000000071800050] = 2ea7bc867f3d6c55, %l0 = 000000000000002e
	ldx	[%o3+0x050],%l0		! %l0 = 2ea7bc867f3d6c55
	membar	#Sync			! Added by membar checker (151)
!	Mem[000000007200000c] = 78c07a2b, %l0 = 2ea7bc867f3d6c55
	ldsha	[%o4+0x00c]%asi,%g2	! %g2 = 00000000000078c0

p2_label_193:
!	Mem[0000000018800100] = 700332f8 a569f230 490d118b b416244d
!	Mem[0000000018800110] = 127b3eef c5fb02fd 07270b5b c461673a
!	Mem[0000000018800120] = f838593e 49929786 1b257c64 6a36b38a
!	Mem[0000000018800130] = e5347cd8 82db4849 116dd82b 2b0563c6
	mov	0x100,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 0000000018800100
!	%l5 = 000000000000002b, immed = 0000087d, %l1 = 000000007f3d6c55
	orncc	%l5,0x87d,%l1		! %l1 = fffffffffffff7ab, %ccr = 88
!	Mem[0000000019000000] = 6750433a, %l5 = 000000000000002b
	lduwa	[%i2+%g0]0x80,%l5	! %l5 = 000000006750433a
!	Mem[0000000019800000] = 8d6dda2b, %l2 = 000000000000003f
	lduha	[%i3+%g0]0x80,%l2	! %l2 = 0000000000008d6d
!	Mem[0000000071800014] = 2459d439, %l4 = 000000002459d439
	lduh	[%o3+0x016],%l4		! %l4 = 000000000000d439

p2_label_194:
!	Mem[0000000018000000] = 988b18bd, %l6 = ffffffffe7fc7317
	ldsha	[%i0+%g0]0x80,%l6	! %l6 = ffffffffffff988b
!	Mem[00000000190001e8] = 7fe42e50, %l3 = 0000000000000e2e
	ldswa	[%i2+0x1e8]%asi,%l3	! %l3 = 000000007fe42e50
!	Mem[0000000072000020] = c8c71b4d58850fb8, %l7 = 4da91f843a6652d8
	ldx	[%o4+0x020],%g2		! %g2 = c8c71b4d58850fb8
!	%f18 = 1beb59be, %f16 = 41663151, %f26 = c6c96134 f0e4d0cf
	fsmuld	%f18,%f16,%f26		! %f26 = 3bba73fe eb1863c0
!	%f16 = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f20 = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f24 = c084dd34 af077279 3bba73fe eb1863c0
!	%f28 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000018000100

p2_label_195:
!	Mem[0000000018000180] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000018000190] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[00000000180001a0] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[00000000180001b0] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	mov	0x180,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 0000000018000180
!	Mem[0000000071000014] = cab52ecb, %l4 = 000000000000d439
	ldsb	[%o2+0x014],%l4		! %l4 = ffffffffffffffca
!	Mem[0000000018800140] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000018800150] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000018800160] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000018800170] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000018800140
!	%l2 = 00008d6d, %l3 = 7fe42e50, Mem[0000000072000020] = c8c71b4d 58850fb8
	std	%l2,[%o4+0x020]	! Mem[0000000072000020] = 00008d6d 7fe42e50
!	%l6 = ffffffffffff988b, %l6 = ffffffffffff988b, %l5 = 000000006750433a
	addc	%l6,%l6,%l5		! %l5 = ffffffffffff3116

p2_label_196:
!	call to call_1, CWP = 0
	membar	#Sync			! Added by membar checker (152)
	call	p2_call_1_le
!	Mem[0000000019800000] = 8d6dda2b, %l5 = ffffffffffff3116
	ldsba	[%i3+%g0]0x80,%l5	! %l5 = ffffffffffffff8d
!	Registers modified during the branch to p2_call_1
!	%l4  = 000000005f230ca1
!	%l5  = 000000005ccc8b92
!	%l6  = 0000000000008d6d
!	%l7  = fffffffffffff775
!	Mem[0000000018800000] = 32f8f817, %l2 = 0000000000008d6d
	lduba	[%i1+%g0]0x80,%l2	! %l2 = 0000000000000032
!	Mem[0000000072000048] = 7c541d2527b6bf86, %l1 = fffffffffffff7ab
	ldx	[%o4+0x048],%g2		! %g2 = 7c541d2527b6bf86
!	Mem[0000000018000030] = 4da91f84, %l3 = 000000007fe42e50
	lduwa	[%i0+0x030]%asi,%l3	! %l3 = 000000004da91f84

p2_label_197:
!	%f0  = 700332f8 a569f230 490d118b b416244d
!	%f4  = 127b3eef c5fb02fd 07270b5b c461673a
!	%f8  = f838593e 49929786 1b257c64 6a36b38a
!	%f12 = e5347cd8 82db4849 116dd82b 2b0563c6
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 0000000018000000
!	Mem[0000000018000140] = 41663151 83f03e37 1beb59be 8d6dda2b
!	Mem[0000000018000150] = e4d0de7d 3edbfaed c20a673d 52a43808
!	Mem[0000000018000160] = c084dd34 af077279 c6c96134 f0e4d0cf
!	Mem[0000000018000170] = 1e6c046c a2ef179f 5531acaf f0fc6eab
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 0000000018000140
!	%f16 = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f20 = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f24 = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f28 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x0c0,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 00000000180000c0
!	%f16 = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f20 = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f24 = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f28 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 0000000018800000
	membar	#Sync			! Added by membar checker (153)
!	Mem[0000000018000000] = 30f269a5f8320370, %l5 = 000000005ccc8b92
	ldxa	[%i0+%g0]0x80,%l5	! %l5 = 30f269a5f8320370

p2_label_198:
!	%f5  = c5fb02fd, %f2  = 490d118b, %f14 = 116dd82b 2b0563c6
	fsmuld	%f5 ,%f2 ,%f14		! %f14 = c1f14a3b 1acd8be0
!	Mem[00000000180000cc] = be59eb1b, %l6 = 0000000000008d6d
	ldsba	[%i0+0x0cd]%asi,%l6	! %l6 = 0000000000000059
!	%f0  = 700332f8 a569f230 490d118b b416244d
!	%f4  = 127b3eef c5fb02fd 07270b5b c461673a
!	%f8  = f838593e 49929786 1b257c64 6a36b38a
!	%f12 = e5347cd8 82db4849 c1f14a3b 1acd8be0
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000188000c0
	membar	#Sync			! Added by membar checker (154)
!	%f0  = 700332f8 a569f230 490d118b b416244d
!	%f4  = 127b3eef c5fb02fd 07270b5b c461673a
!	%f8  = f838593e 49929786 1b257c64 6a36b38a
!	%f12 = e5347cd8 82db4849 c1f14a3b 1acd8be0
	stda	%f0,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000188000c0
!	Mem[0000000072000054] = cff2a0d9, %l2 = 0000000000000032
	lduh	[%o4+0x054],%g2		! %g2 = 000000000000cff2

p2_label_199:
!	Mem[0000000071800010] = 00000000, %l0 = 2ea7bc867f3d6c55
	ldsh	[%o3+0x010],%l0		! %l0 = 0000000000000000
!	Mem[0000000019000180] = 5316fcda 7257a8a7 54766aeb 19e15f8d
!	Mem[0000000019000190] = 1c16487d c7407846 7bd5e73f a750d99c
!	Mem[00000000190001a0] = 271a96aa 3d716042 a2adfa61 5f0192dc
!	Mem[00000000190001b0] = 5031dcbe 1c270a1b a5f76fa1 81c8e924
	mov	0x180,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000019000180
!	Mem[0000000019000008] = 2b7ac078c9a9f931, %l0 = 0000000000000000
	ldxa	[%i2+%o6]0x80,%l0	! %l0 = 2b7ac078c9a9f931
!	Mem[0000000070800014] = 0000003f, %l6 = 0000000000000059
	ldsh	[%o1+0x014],%l6		! %l6 = 0000000000000000
!	Mem[0000000019000100] = 373ef083 51316641 2bda6d8d be59eb1b
!	Mem[0000000019000110] = edfadb3e 7dded0e4 0838a452 3d670ac2
!	Mem[0000000019000120] = 797207af 34dd84c0 cfd0e4f0 3461c9c6
!	Mem[0000000019000130] = 9f17efa2 6c046c1e ab6efcf0 afac3155
	mov	0x100,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f16	! Block Load from 0000000019000100

p2_label_200:
!	%f16 = 41663151 83f03e37 1beb59be 8d6dda2b
!	%f20 = e4d0de7d 3edbfaed c20a673d 52a43808
!	%f24 = c084dd34 af077279 c6c96134 f0e4d0cf
!	%f28 = 1e6c046c a2ef179f 5531acaf f0fc6eab
	mov	0x1c0,%g5
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 00000000190001c0
	membar	#Sync			! Added by membar checker (155)
!	Mem[00000000188000c0] = 30f269a5 f8320370, %l2 = 00000032, %l3 = 4da91f84
	ldda	[%i1+0x0c0]%asi,%l2	! %l2 = 0000000030f269a5 00000000f8320370
!	Mem[0000000070800054] = 1545e874, %l0 = c9a9f931, %l7 = fffff775
	add	%o1,0x54,%g1
	casa	[%g1]0x80,%l0,%l7	! %l7 = 000000001545e874
!	Mem[0000000019000008] = 2b7ac078, %l4 = 000000005f230ca1
	ldswa	[%i2+%o6]0x80,%l4	! %l4 = 000000002b7ac078
!	Mem[000000001a800000] = 830a26d4, %l0 = 2b7ac078c9a9f931
	ldsha	[%i5+%g0]0x80,%l0	! %l0 = ffffffffffff830a
	nop

1:	membar	#Sync			! Force all stores to complete

!	End of Random Code for Processor 2

	mov	2,%g2
	set	done_flags,%g1
	st	%g2,[%g1+0x008]		! Set processor 2 done flag

!	Check Registers

p2_check_registers:
	set	p2_expected_registers,%g1
	ldx	[%g1+0x000],%g2
	cmp	%l0,%g2			! %l0 should be ffffffffffff830a
	bne,a,pn %xcc,p2_reg_l0_fail
	mov	%l0,%g3
	ldx	[%g1+0x008],%g2
	cmp	%l1,%g2			! %l1 should be fffffffffffff7ab
	bne,a,pn %xcc,p2_reg_l1_fail
	mov	%l1,%g3
	ldx	[%g1+0x010],%g2
	cmp	%l2,%g2			! %l2 should be 0000000030f269a5
	bne,a,pn %xcc,p2_reg_l2_fail
	mov	%l2,%g3
	ldx	[%g1+0x018],%g2
	cmp	%l3,%g2			! %l3 should be 00000000f8320370
	bne,a,pn %xcc,p2_reg_l3_fail
	mov	%l3,%g3
	ldx	[%g1+0x020],%g2
	cmp	%l4,%g2			! %l4 should be 000000002b7ac078
	bne,a,pn %xcc,p2_reg_l4_fail
	mov	%l4,%g3
	ldx	[%g1+0x028],%g2
	cmp	%l5,%g2			! %l5 should be 30f269a5f8320370
	bne,a,pn %xcc,p2_reg_l5_fail
	mov	%l5,%g3
	ldx	[%g1+0x030],%g2
	cmp	%l6,%g2			! %l6 should be 0000000000000000
	bne,a,pn %xcc,p2_reg_l6_fail
	mov	%l6,%g3
	ldx	[%g1+0x038],%g2
	cmp	%l7,%g2			! %l7 should be 000000001545e874
	bne,a,pn %xcc,p2_reg_l7_fail
	mov	%l7,%g3

!	Check %y register

	set	0xfffffffe,%g2
	rd	%y,%g3
	cmp	%g2,%g3
	bne,a	p2_failed
	mov	0x111,%g1

!	Check Floating Point Registers

p2_check_fp_registers:
	set	p2_temp,%g1
	set	p2_expected_fp_regs,%g3
	std	%f0,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x00],%l0
	cmp	%l0,%l1			! %f0  should be 700332f8 a569f230
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf00,%g1
	std	%f2,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x08],%l0
	cmp	%l0,%l1			! %f2  should be 490d118b b416244d
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf02,%g1
	std	%f4,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x10],%l0
	cmp	%l0,%l1			! %f4  should be 127b3eef c5fb02fd
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf04,%g1
	std	%f6,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x18],%l0
	cmp	%l0,%l1			! %f6  should be 07270b5b c461673a
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf06,%g1
	std	%f8,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x20],%l0
	cmp	%l0,%l1			! %f8  should be f838593e 49929786
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf08,%g1
	std	%f10,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x28],%l0
	cmp	%l0,%l1			! %f10 should be 1b257c64 6a36b38a
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf10,%g1
	std	%f12,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x30],%l0
	cmp	%l0,%l1			! %f12 should be e5347cd8 82db4849
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf12,%g1
	std	%f14,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x38],%l0
	cmp	%l0,%l1			! %f14 should be c1f14a3b 1acd8be0
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf14,%g1
	std	%f16,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x40],%l0
	cmp	%l0,%l1			! %f16 should be 41663151 83f03e37
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf16,%g1
	std	%f18,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x48],%l0
	cmp	%l0,%l1			! %f18 should be 1beb59be 8d6dda2b
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf18,%g1
	std	%f20,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x50],%l0
	cmp	%l0,%l1			! %f20 should be e4d0de7d 3edbfaed
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf20,%g1
	std	%f22,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x58],%l0
	cmp	%l0,%l1			! %f22 should be c20a673d 52a43808
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf22,%g1
	std	%f24,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x60],%l0
	cmp	%l0,%l1			! %f24 should be c084dd34 af077279
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf24,%g1
	std	%f26,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x68],%l0
	cmp	%l0,%l1			! %f26 should be c6c96134 f0e4d0cf
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf26,%g1
	std	%f28,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x70],%l0
	cmp	%l0,%l1			! %f28 should be 1e6c046c a2ef179f
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf28,%g1
	std	%f30,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x78],%l0
	cmp	%l0,%l1			! %f30 should be 5531acaf f0fc6eab
	bne,a,pn	%xcc,p2_freg_fail
	or	%g0,0xf30,%g1

!	Check Local Memory

	set	p2_local0_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 30f269a5f8320370
	ldx	[%i0+0x000],%g3		! Observed data at 0000000018000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 4d2416b48b110d49
	ldx	[%i0+0x008],%g3		! Observed data at 0000000018000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = fd02fbc5ef3e7b12
	ldx	[%i0+0x010],%g3		! Observed data at 0000000018000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 3a6761c45b0b2707
	ldx	[%i0+0x018],%g3		! Observed data at 0000000018000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 869792493e5938f8
	ldx	[%i0+0x020],%g3		! Observed data at 0000000018000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 8ab3366a647c251b
	ldx	[%i0+0x028],%g3		! Observed data at 0000000018000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 4948db82d87c34e5
	ldx	[%i0+0x030],%g3		! Observed data at 0000000018000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = c663052b2bd86d11
	ldx	[%i0+0x038],%g3		! Observed data at 0000000018000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 5f230ca15ccc8b92
	ldx	[%i0+0x040],%g3		! Observed data at 0000000018000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 74cf094860b45dba
	ldx	[%i0+0x048],%g3		! Observed data at 0000000018000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 0000000017d7b2c7
	ldx	[%i0+0x050],%g3		! Observed data at 0000000018000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 9932a6be5237261e
	ldx	[%i0+0x058],%g3		! Observed data at 0000000018000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = ec49017cc7e5468a
	ldx	[%i0+0x060],%g3		! Observed data at 0000000018000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = d6befb74cab77127
	ldx	[%i0+0x068],%g3		! Observed data at 0000000018000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = b249411bb8b896fd
	ldx	[%i0+0x070],%g3		! Observed data at 0000000018000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 3c980de09b8764aa
	ldx	[%i0+0x078],%g3		! Observed data at 0000000018000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 083bf8173a435067
	ldx	[%i0+0x080],%g3		! Observed data at 0000000018000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 31f9a9c978c07a2b
	ldx	[%i0+0x088],%g3		! Observed data at 0000000018000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 0314e1b45d69119d
	ldx	[%i0+0x090],%g3		! Observed data at 0000000018000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 66bd3ee7e01335a4
	ldx	[%i0+0x098],%g3		! Observed data at 0000000018000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = c8c71b4d58850fb8
	ldx	[%i0+0x0a0],%g3		! Observed data at 00000000180000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 067f84f7ecfb1a16
	ldx	[%i0+0x0a8],%g3		! Observed data at 00000000180000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 1f91009f86f20d37
	ldx	[%i0+0x0b0],%g3		! Observed data at 00000000180000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = f724d5b5ee3dc3b4
	ldx	[%i0+0x0b8],%g3		! Observed data at 00000000180000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 373ef08351316641
	ldx	[%i0+0x0c0],%g3		! Observed data at 00000000180000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i0+0x0c8],%g3		! Observed data at 00000000180000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i0+0x0d0],%g3		! Observed data at 00000000180000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i0+0x0d8],%g3		! Observed data at 00000000180000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i0+0x0e0],%g3		! Observed data at 00000000180000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = cfd0e4f03461c9c6
	ldx	[%i0+0x0e8],%g3		! Observed data at 00000000180000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i0+0x0f0],%g3		! Observed data at 00000000180000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = ab6efcf0afac3155
	ldx	[%i0+0x0f8],%g3		! Observed data at 00000000180000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 373ef08351316641
	ldx	[%i0+0x100],%g3		! Observed data at 0000000018000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i0+0x108],%g3		! Observed data at 0000000018000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i0+0x110],%g3		! Observed data at 0000000018000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i0+0x118],%g3		! Observed data at 0000000018000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i0+0x120],%g3		! Observed data at 0000000018000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = c06318ebfe73ba3b
	ldx	[%i0+0x128],%g3		! Observed data at 0000000018000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i0+0x130],%g3		! Observed data at 0000000018000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = ab6efcf0afac3155
	ldx	[%i0+0x138],%g3		! Observed data at 0000000018000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 373ef08351316641
	ldx	[%i0+0x180],%g3		! Observed data at 0000000018000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i0+0x188],%g3		! Observed data at 0000000018000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i0+0x190],%g3		! Observed data at 0000000018000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i0+0x198],%g3		! Observed data at 0000000018000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i0+0x1a0],%g3		! Observed data at 00000000180001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = cfd0e4f03461c9c6
	ldx	[%i0+0x1a8],%g3		! Observed data at 00000000180001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i0+0x1b0],%g3		! Observed data at 00000000180001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = ab6efcf0afac3155
	ldx	[%i0+0x1b8],%g3		! Observed data at 00000000180001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 700332f8a569f230
	ldx	[%i0+0x1c0],%g3		! Observed data at 00000000180001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 490d118bb416244d
	ldx	[%i0+0x1c8],%g3		! Observed data at 00000000180001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 127b3eefc5fb02fd
	ldx	[%i0+0x1d0],%g3		! Observed data at 00000000180001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = 07270b5bc461673a
	ldx	[%i0+0x1d8],%g3		! Observed data at 00000000180001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = f838593e49929786
	ldx	[%i0+0x1e0],%g3		! Observed data at 00000000180001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 1b257c646a36b38a
	ldx	[%i0+0x1e8],%g3		! Observed data at 00000000180001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = e5347cd882db4849
	ldx	[%i0+0x1f0],%g3		! Observed data at 00000000180001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 116dd82b2b0563c6
	ldx	[%i0+0x1f8],%g3		! Observed data at 00000000180001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f8,%g4

	set	p2_local1_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 373ef08351316641
	ldx	[%i1+0x000],%g3		! Observed data at 0000000018800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i1+0x008],%g3		! Observed data at 0000000018800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i1+0x010],%g3		! Observed data at 0000000018800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i1+0x018],%g3		! Observed data at 0000000018800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i1+0x020],%g3		! Observed data at 0000000018800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = cfd0e4f03461c9c6
	ldx	[%i1+0x028],%g3		! Observed data at 0000000018800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i1+0x030],%g3		! Observed data at 0000000018800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = ab6efcf0afac3155
	ldx	[%i1+0x038],%g3		! Observed data at 0000000018800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 6750433a17f83b08
	ldx	[%i1+0x040],%g3		! Observed data at 0000000018800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 2b7ac078c9a9f931
	ldx	[%i1+0x048],%g3		! Observed data at 0000000018800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 9d11695db4e11403
	ldx	[%i1+0x050],%g3		! Observed data at 0000000018800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = a43513e0e73ebd66
	ldx	[%i1+0x058],%g3		! Observed data at 0000000018800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = b80f85584d1bc7c8
	ldx	[%i1+0x060],%g3		! Observed data at 0000000018800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 161afbecf7847f06
	ldx	[%i1+0x068],%g3		! Observed data at 0000000018800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 370df2869f00911f
	ldx	[%i1+0x070],%g3		! Observed data at 0000000018800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = b4c33deeb5d524f7
	ldx	[%i1+0x078],%g3		! Observed data at 0000000018800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 30f269a5f8320370
	ldx	[%i1+0x0c0],%g3		! Observed data at 00000000188000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 4d2416b48b110d49
	ldx	[%i1+0x0c8],%g3		! Observed data at 00000000188000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = fd02fbc5ef3e7b12
	ldx	[%i1+0x0d0],%g3		! Observed data at 00000000188000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 3a6761c45b0b2707
	ldx	[%i1+0x0d8],%g3		! Observed data at 00000000188000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 869792493e5938f8
	ldx	[%i1+0x0e0],%g3		! Observed data at 00000000188000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 8ab3366a647c251b
	ldx	[%i1+0x0e8],%g3		! Observed data at 00000000188000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 4948db82d87c34e5
	ldx	[%i1+0x0f0],%g3		! Observed data at 00000000188000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = e08bcd1a3b4af1c1
	ldx	[%i1+0x0f8],%g3		! Observed data at 00000000188000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 700332f8a569f230
	ldx	[%i1+0x100],%g3		! Observed data at 0000000018800100
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 490d118bb416244d
	ldx	[%i1+0x108],%g3		! Observed data at 0000000018800108
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 127b3eefc5fb02fd
	ldx	[%i1+0x110],%g3		! Observed data at 0000000018800110
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 07270b5bc461673a
	ldx	[%i1+0x118],%g3		! Observed data at 0000000018800118
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = f838593e49929786
	ldx	[%i1+0x120],%g3		! Observed data at 0000000018800120
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 1b257c646a36b38a
	ldx	[%i1+0x128],%g3		! Observed data at 0000000018800128
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = e5347cd882db4849
	ldx	[%i1+0x130],%g3		! Observed data at 0000000018800130
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 116dd82b2b0563c6
	ldx	[%i1+0x138],%g3		! Observed data at 0000000018800138
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 373ef08351316641
	ldx	[%i1+0x140],%g3		! Observed data at 0000000018800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i1+0x148],%g3		! Observed data at 0000000018800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i1+0x150],%g3		! Observed data at 0000000018800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i1+0x158],%g3		! Observed data at 0000000018800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i1+0x160],%g3		! Observed data at 0000000018800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = cfd0e4f03461c9c6
	ldx	[%i1+0x168],%g3		! Observed data at 0000000018800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i1+0x170],%g3		! Observed data at 0000000018800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = ab6efcf0afac3155
	ldx	[%i1+0x178],%g3		! Observed data at 0000000018800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = a87eaa9c15f97043
	ldx	[%i1+0x1a8],%g3		! Observed data at 00000000188001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 6750433a17f83b08
	ldx	[%i1+0x1c0],%g3		! Observed data at 00000000188001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 2b7ac078c9a9f931
	ldx	[%i1+0x1c8],%g3		! Observed data at 00000000188001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 9d11695db4e11403
	ldx	[%i1+0x1d0],%g3		! Observed data at 00000000188001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = a43513e0e73ebd66
	ldx	[%i1+0x1d8],%g3		! Observed data at 00000000188001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = b80f85584d1bc7c8
	ldx	[%i1+0x1e0],%g3		! Observed data at 00000000188001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 161afbecf7847f06
	ldx	[%i1+0x1e8],%g3		! Observed data at 00000000188001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 370df2869f00911f
	ldx	[%i1+0x1f0],%g3		! Observed data at 00000000188001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = b4c33deeb5d524f7
	ldx	[%i1+0x1f8],%g3		! Observed data at 00000000188001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f8,%g4

	set	p2_local2_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 6750433a17f83b08
	ldx	[%i2+0x000],%g3		! Observed data at 0000000019000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 2b7ac078c9a9f931
	ldx	[%i2+0x008],%g3		! Observed data at 0000000019000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 9d11695db4e11403
	ldx	[%i2+0x010],%g3		! Observed data at 0000000019000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = a43513e0e73ebd66
	ldx	[%i2+0x018],%g3		! Observed data at 0000000019000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = b80f85584d1bc7c8
	ldx	[%i2+0x020],%g3		! Observed data at 0000000019000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 161afbecf7847f06
	ldx	[%i2+0x028],%g3		! Observed data at 0000000019000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 370df2869f00911f
	ldx	[%i2+0x030],%g3		! Observed data at 0000000019000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = b4c33deeb5d524f7
	ldx	[%i2+0x038],%g3		! Observed data at 0000000019000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 373ef08351316641
	ldx	[%i2+0x040],%g3		! Observed data at 0000000019000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i2+0x048],%g3		! Observed data at 0000000019000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i2+0x050],%g3		! Observed data at 0000000019000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i2+0x058],%g3		! Observed data at 0000000019000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i2+0x060],%g3		! Observed data at 0000000019000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = cfd0e4f03461c9c6
	ldx	[%i2+0x068],%g3		! Observed data at 0000000019000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i2+0x070],%g3		! Observed data at 0000000019000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 858dad990000003f
	ldx	[%i2+0x078],%g3		! Observed data at 0000000019000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 7041fb2315999bbe
	ldx	[%i2+0x080],%g3		! Observed data at 0000000019000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = e7fc73173d7d70e2
	ldx	[%i2+0x088],%g3		! Observed data at 0000000019000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 51383f66e6566585
	ldx	[%i2+0x090],%g3		! Observed data at 0000000019000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = d4473cb5b5d885a2
	ldx	[%i2+0x098],%g3		! Observed data at 0000000019000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 4370f9159caa7ea8
	ldx	[%i2+0x0a0],%g3		! Observed data at 00000000190000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 2d50d76bf2517f12
	ldx	[%i2+0x0a8],%g3		! Observed data at 00000000190000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 37735f12b1d96dfe
	ldx	[%i2+0x0b0],%g3		! Observed data at 00000000190000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 9b01c4bc2cbe4f03
	ldx	[%i2+0x0b8],%g3		! Observed data at 00000000190000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 6760433a17f83b08
	ldx	[%i2+0x0c0],%g3		! Observed data at 00000000190000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 2b7ac078c9a9f931
	ldx	[%i2+0x0c8],%g3		! Observed data at 00000000190000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 9d11695db4e11403
	ldx	[%i2+0x0d0],%g3		! Observed data at 00000000190000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = a43513e0e73ebd66
	ldx	[%i2+0x0d8],%g3		! Observed data at 00000000190000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = b80f85584d1bc7c8
	ldx	[%i2+0x0e0],%g3		! Observed data at 00000000190000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 161afbecf7847f06
	ldx	[%i2+0x0e8],%g3		! Observed data at 00000000190000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 370df2869f00911f
	ldx	[%i2+0x0f0],%g3		! Observed data at 00000000190000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = b4c33deeb5d524f7
	ldx	[%i2+0x0f8],%g3		! Observed data at 00000000190000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 373ef08351316641
	ldx	[%i2+0x100],%g3		! Observed data at 0000000019000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 2bda6d8dbe59eb1b
	ldx	[%i2+0x108],%g3		! Observed data at 0000000019000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = edfadb3e7dded0e4
	ldx	[%i2+0x110],%g3		! Observed data at 0000000019000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 0838a4523d670ac2
	ldx	[%i2+0x118],%g3		! Observed data at 0000000019000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 797207af34dd84c0
	ldx	[%i2+0x120],%g3		! Observed data at 0000000019000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = cfd0e4f03461c9c6
	ldx	[%i2+0x128],%g3		! Observed data at 0000000019000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = 9f17efa26c046c1e
	ldx	[%i2+0x130],%g3		! Observed data at 0000000019000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = ab6efcf0afac3155
	ldx	[%i2+0x138],%g3		! Observed data at 0000000019000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 7041fb2315999bbe
	ldx	[%i2+0x140],%g3		! Observed data at 0000000019000140
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = e7fc73173d7d70e2
	ldx	[%i2+0x148],%g3		! Observed data at 0000000019000148
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 51383f66e6566585
	ldx	[%i2+0x150],%g3		! Observed data at 0000000019000150
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = d4473cb5b5d885a2
	ldx	[%i2+0x158],%g3		! Observed data at 0000000019000158
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 4370f9159caa7ea8
	ldx	[%i2+0x160],%g3		! Observed data at 0000000019000160
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 2d50d76bf2517f12
	ldx	[%i2+0x168],%g3		! Observed data at 0000000019000168
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 37735f12b1d96dfe
	ldx	[%i2+0x170],%g3		! Observed data at 0000000019000170
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 9b01c4bc2cbe4f03
	ldx	[%i2+0x178],%g3		! Observed data at 0000000019000178
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 5316fcda7257a8a7
	ldx	[%i2+0x180],%g3		! Observed data at 0000000019000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 54766aeb19e15f8d
	ldx	[%i2+0x188],%g3		! Observed data at 0000000019000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 1c16487dc7407846
	ldx	[%i2+0x190],%g3		! Observed data at 0000000019000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = 7bd5e73fa750d99c
	ldx	[%i2+0x198],%g3		! Observed data at 0000000019000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 271a96aa3d716042
	ldx	[%i2+0x1a0],%g3		! Observed data at 00000000190001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = a2adfa615f0192dc
	ldx	[%i2+0x1a8],%g3		! Observed data at 00000000190001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 5031dcbe1c270a1b
	ldx	[%i2+0x1b0],%g3		! Observed data at 00000000190001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = a5f76fa181c8e924
	ldx	[%i2+0x1b8],%g3		! Observed data at 00000000190001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 4166315183f03e37
	ldx	[%i2+0x1c0],%g3		! Observed data at 00000000190001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 1beb59be8d6dda2b
	ldx	[%i2+0x1c8],%g3		! Observed data at 00000000190001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = e4d0de7d3edbfaed
	ldx	[%i2+0x1d0],%g3		! Observed data at 00000000190001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = c20a673d52a43808
	ldx	[%i2+0x1d8],%g3		! Observed data at 00000000190001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = c084dd34af077279
	ldx	[%i2+0x1e0],%g3		! Observed data at 00000000190001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = c6c96134f0e4d0cf
	ldx	[%i2+0x1e8],%g3		! Observed data at 00000000190001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 1e6c046ca2ef179f
	ldx	[%i2+0x1f0],%g3		! Observed data at 00000000190001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 5531acaff0fc6eab
	ldx	[%i2+0x1f8],%g3		! Observed data at 00000000190001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f8,%g4

	set	p2_local3_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 8d6dda2b87fd80e3
	ldx	[%i3+0x000],%g3		! Observed data at 0000000019800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 03ba24b0ddb1cb9a
	ldx	[%i3+0x008],%g3		! Observed data at 0000000019800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 988b18bdd8289b24
	ldx	[%i3+0x040],%g3		! Observed data at 0000000019800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 6d64924ccb72efd9
	ldx	[%i3+0x048],%g3		! Observed data at 0000000019800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 7fbf7e96fed42ae5
	ldx	[%i3+0x050],%g3		! Observed data at 0000000019800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = fe6b313a6f3c2ec6
	ldx	[%i3+0x058],%g3		! Observed data at 0000000019800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 8e534add4b60c30b
	ldx	[%i3+0x060],%g3		! Observed data at 0000000019800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = bb0dfff827a27954
	ldx	[%i3+0x068],%g3		! Observed data at 0000000019800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 4da91f843a6652d8
	ldx	[%i3+0x070],%g3		! Observed data at 0000000019800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = a63971bb3e212e01
	ldx	[%i3+0x078],%g3		! Observed data at 0000000019800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 3d9817d3fc2ebbf1
	ldx	[%i3+0x080],%g3		! Observed data at 0000000019800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 126ba6cdf02352b7
	ldx	[%i3+0x088],%g3		! Observed data at 0000000019800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = d14b3f696f8db8e1
	ldx	[%i3+0x090],%g3		! Observed data at 0000000019800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 9896ce523c52763f
	ldx	[%i3+0x098],%g3		! Observed data at 0000000019800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 78f70e2efe2c8e3f
	ldx	[%i3+0x0a0],%g3		! Observed data at 00000000198000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 09258c43c95c830e
	ldx	[%i3+0x0a8],%g3		! Observed data at 00000000198000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = bfc77efb3644e412
	ldx	[%i3+0x0b0],%g3		! Observed data at 00000000198000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = f081975191e0670d
	ldx	[%i3+0x0b8],%g3		! Observed data at 00000000198000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 083bf8173a436067
	ldx	[%i3+0x0c0],%g3		! Observed data at 00000000198000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 31f9a9c978c07a2b
	ldx	[%i3+0x0c8],%g3		! Observed data at 00000000198000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 0314e1b45d69119d
	ldx	[%i3+0x0d0],%g3		! Observed data at 00000000198000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 66bd3ee7e01335a4
	ldx	[%i3+0x0d8],%g3		! Observed data at 00000000198000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = c8c71b4d58850fb8
	ldx	[%i3+0x0e0],%g3		! Observed data at 00000000198000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 067f84f7ecfb1a16
	ldx	[%i3+0x0e8],%g3		! Observed data at 00000000198000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 1f91009f86f20d37
	ldx	[%i3+0x0f0],%g3		! Observed data at 00000000198000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = f724d5b5ee3dc3b4
	ldx	[%i3+0x0f8],%g3		! Observed data at 00000000198000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 8d6dda2b87fd80e3
	ldx	[%i3+0x100],%g3		! Observed data at 0000000019800100
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 03ba24b0ddb1cb9a
	ldx	[%i3+0x108],%g3		! Observed data at 0000000019800108
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 70192ade78266912
	ldx	[%i3+0x110],%g3		! Observed data at 0000000019800110
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = ce3f22fbcc08264d
	ldx	[%i3+0x118],%g3		! Observed data at 0000000019800118
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 3e99377e98b942a7
	ldx	[%i3+0x120],%g3		! Observed data at 0000000019800120
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = e3779be19aa508ee
	ldx	[%i3+0x128],%g3		! Observed data at 0000000019800128
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = a95ed10c5e729333
	ldx	[%i3+0x130],%g3		! Observed data at 0000000019800130
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 3fb038f06b171ec1
	ldx	[%i3+0x138],%g3		! Observed data at 0000000019800138
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 083bf8173a435067
	ldx	[%i3+0x140],%g3		! Observed data at 0000000019800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 31f9a9c978c07a2b
	ldx	[%i3+0x148],%g3		! Observed data at 0000000019800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 0314e1b45d69119d
	ldx	[%i3+0x150],%g3		! Observed data at 0000000019800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 66bd3ee7e01335a4
	ldx	[%i3+0x158],%g3		! Observed data at 0000000019800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = c8c71b4d58850fb8
	ldx	[%i3+0x160],%g3		! Observed data at 0000000019800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 067f84f7ecfb1a16
	ldx	[%i3+0x168],%g3		! Observed data at 0000000019800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 1f91009f86f20d37
	ldx	[%i3+0x170],%g3		! Observed data at 0000000019800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = f724d5b5ee3dc3b4
	ldx	[%i3+0x178],%g3		! Observed data at 0000000019800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 41de3dc38b800000
	ldx	[%i3+0x180],%g3		! Observed data at 0000000019800180
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 573c16fcf8594ff9
	ldx	[%i3+0x188],%g3		! Observed data at 0000000019800188
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 32133cd864d7171f
	ldx	[%i3+0x190],%g3		! Observed data at 0000000019800190
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = 87d93bb8ec5b590c
	ldx	[%i3+0x198],%g3		! Observed data at 0000000019800198
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 5892f8401545e874
	ldx	[%i3+0x1a0],%g3		! Observed data at 00000000198001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = 5322649d502ee47f
	ldx	[%i3+0x1a8],%g3		! Observed data at 00000000198001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 5f390a8123cefe18
	ldx	[%i3+0x1b0],%g3		! Observed data at 00000000198001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = d353592bce98ded1
	ldx	[%i3+0x1b8],%g3		! Observed data at 00000000198001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 6750433a17f83b08
	ldx	[%i3+0x1c0],%g3		! Observed data at 00000000198001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 2b7ac078c9a9f931
	ldx	[%i3+0x1c8],%g3		! Observed data at 00000000198001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 9d11695db4e11403
	ldx	[%i3+0x1d0],%g3		! Observed data at 00000000198001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = a43513e0e73ebd66
	ldx	[%i3+0x1d8],%g3		! Observed data at 00000000198001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = b80f85584d1bc7c8
	ldx	[%i3+0x1e0],%g3		! Observed data at 00000000198001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 161afbecf7847f06
	ldx	[%i3+0x1e8],%g3		! Observed data at 00000000198001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 370df2869f00911f
	ldx	[%i3+0x1f0],%g3		! Observed data at 00000000198001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = b4c33deeb5d524f7
	ldx	[%i3+0x1f8],%g3		! Observed data at 00000000198001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f8,%g4

	set	p2_local4_expect,%g1

!	Processor 2, local 4 is clean


	set	p2_local5_expect,%g1
	ldx	[%g1+0x008],%g2		! Expect data = 5892f8401545e874
	ldx	[%i5+0x008],%g3		! Observed data at 000000001a800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 0000808bc33dde41
	ldx	[%i5+0x140],%g3		! Observed data at 000000001a800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = f94f59f8fc163c57
	ldx	[%i5+0x148],%g3		! Observed data at 000000001a800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 1f17d764d83c1332
	ldx	[%i5+0x150],%g3		! Observed data at 000000001a800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 0c595becb83bd987
	ldx	[%i5+0x158],%g3		! Observed data at 000000001a800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 74e8451540f89258
	ldx	[%i5+0x160],%g3		! Observed data at 000000001a800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 7fe42e509d642253
	ldx	[%i5+0x168],%g3		! Observed data at 000000001a800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 18fece23810a395f
	ldx	[%i5+0x170],%g3		! Observed data at 000000001a800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = d1de98ce2b5953d3
	ldx	[%i5+0x178],%g3		! Observed data at 000000001a800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 7041fb2315999bbe
	ldx	[%i5+0x1c0],%g3		! Observed data at 000000001a8001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = e7fc73173d7d70e2
	ldx	[%i5+0x1c8],%g3		! Observed data at 000000001a8001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 51383f66e6566585
	ldx	[%i5+0x1d0],%g3		! Observed data at 000000001a8001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = d4473cb5b5d885a2
	ldx	[%i5+0x1d8],%g3		! Observed data at 000000001a8001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = 4370f9159caa7ea8
	ldx	[%i5+0x1e0],%g3		! Observed data at 000000001a8001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 2d50d76bf2517f12
	ldx	[%i5+0x1e8],%g3		! Observed data at 000000001a8001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 37735f12b1d96dfe
	ldx	[%i5+0x1f0],%g3		! Observed data at 000000001a8001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 9b01c4bc2cbe4f03
	ldx	[%i5+0x1f8],%g3		! Observed data at 000000001a8001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1f8,%g4

	set	p2_local6_expect,%g1
	ldx	[%g1+0x100],%g2		! Expect data = be9b991523fb4170
	ldx	[%i6+0x100],%g3		! Observed data at 000000001b000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = e2707d3d1773fce7
	ldx	[%i6+0x108],%g3		! Observed data at 000000001b000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 856556e6663f3851
	ldx	[%i6+0x110],%g3		! Observed data at 000000001b000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = a285d8b5b53c47d4
	ldx	[%i6+0x118],%g3		! Observed data at 000000001b000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = a87eaa9c15f97043
	ldx	[%i6+0x120],%g3		! Observed data at 000000001b000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 127f51f26bd7502d
	ldx	[%i6+0x128],%g3		! Observed data at 000000001b000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = fe6dd9b1125f7337
	ldx	[%i6+0x130],%g3		! Observed data at 000000001b000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 034fbe2cbcc4019b
	ldx	[%i6+0x138],%g3		! Observed data at 000000001b000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x180],%g2		! Expect data = e1b88d6f693f4b51
	ldx	[%i6+0x180],%g3		! Observed data at 000000001b000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = b75223f0cda66b12
	ldx	[%i6+0x188],%g3		! Observed data at 000000001b000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = e1b88d6f693f4bd1
	ldx	[%i6+0x190],%g3		! Observed data at 000000001b000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = 3f76523c52ce9698
	ldx	[%i6+0x198],%g3		! Observed data at 000000001b000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 0090f6b30c000000
	ldx	[%i6+0x1a0],%g3		! Observed data at 000000001b0001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = 693f4b51438c2509
	ldx	[%i6+0x1a8],%g3		! Observed data at 000000001b0001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 12e44436fb7ec7bf
	ldx	[%i6+0x1b0],%g3		! Observed data at 000000001b0001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 0d67e091519781f0
	ldx	[%i6+0x1b8],%g3		! Observed data at 000000001b0001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p2_local_failed
	mov	0x1b8,%g4


!	Check Shared Memory
	set	share0_expect,%g4
	set	p2_share_mask,%g5
	set	0x70000000,%g6	! Physical Addr of Share 0
p2_memcheck_share0:
	ldx	[%g4+0x10],%g2	! Expected value = 8001c1d300007003
	ldx	[%o0+0x10],%g3	! Read value at Mem[0000000070000010]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x010,%g1
	ldx	[%g4+0x50],%g2	! Expected value = 17f83b08989662c1
	ldx	[%o0+0x50],%g3	! Read value at Mem[0000000070000050]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x050,%g1
	set	share1_expect,%g4
	set	0x70800000,%g6	! Physical Addr of Share 1
p2_memcheck_share1:
	ldx	[%g4+0x10],%g2	! Expected value = 000000000000003f
	ldx	[%o1+0x10],%g3	! Read value at Mem[0000000070800010]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x010,%g1
	ldx	[%g4+0x50],%g2	! Expected value = 5892f8401545e874
	ldx	[%o1+0x50],%g3	! Read value at Mem[0000000070800050]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x050,%g1
	set	share2_expect,%g4
	set	0x71000000,%g6	! Physical Addr of Share 2
p2_memcheck_share2:
	ldx	[%g4+0x10],%g2	! Expected value = 9d0d6da6cab52ecb
	ldx	[%o2+0x10],%g3	! Read value at Mem[0000000071000010]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x010,%g1
	ldx	[%g4+0x50],%g2	! Expected value = 9c000e2ea569f230
	ldx	[%o2+0x50],%g3	! Read value at Mem[0000000071000050]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x050,%g1
	set	share3_expect,%g4
	set	0x71800000,%g6	! Physical Addr of Share 3
p2_memcheck_share3:
	ldx	[%g4+0x10],%g2	! Expected value = 000000002459d439
	ldx	[%o3+0x10],%g3	! Read value at Mem[0000000071800010]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x010,%g1
	ldx	[%g4+0x50],%g2	! Expected value = 2ea7bc867f3d6c55
	ldx	[%o3+0x50],%g3	! Read value at Mem[0000000071800050]
	cmp	%g2,%g3
	bne,pn	%xcc,p2_failed
	add	%g6,0x050,%g1

!	The test for processor 2 has passed

p2_passed:
	ta	GOOD_TRAP
	nop

p2_reg_l0_fail:
	or	%g0,0xbd0,%g1
	ba,a	p2_failed
p2_reg_l1_fail:
	or	%g0,0xbd1,%g1
	ba,a	p2_failed
p2_reg_l2_fail:
	or	%g0,0xbd2,%g1
	ba,a	p2_failed
p2_reg_l3_fail:
	or	%g0,0xbd3,%g1
	ba,a	p2_failed
p2_reg_l4_fail:
	or	%g0,0xbd4,%g1
	ba,a	p2_failed
p2_reg_l5_fail:
	or	%g0,0xbd5,%g1
	ba,a	p2_failed
p2_reg_l6_fail:
	or	%g0,0xbd6,%g1
	ba,a	p2_failed
p2_reg_l7_fail:
	or	%g0,0xbd7,%g1
	ba,a	p2_failed
p2_freg_fail:
	mov	%l0,%g3
	ba	p2_failed
	mov	%l1,%g2


!	The test for processor 2 failed

p2_failed:
	set	done_flags,%g1
	mov	3,%g5
	st	%g5,[%g1+0x008]		! Set processor 2 done flag

	set	p2_temp,%g6
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p2_freg_failed:
	ba,a	p2_failed

!	The local area data for processor 2 failed

p2_local_failed:
	set	done_flags,%g5
	mov	3,%g6
	st	%g5,[%g5+0x008]		! Set processor 2 done flag

	set	p2_temp,%g6
	add	%g1,%g4,%g1
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p2_dfill_failed:
	ba	p2_failed
	mov	0xddd,%g1

p2_selfmod_failed:
	ba	p2_failed
	mov	0xabc,%g1


p2_common_error:
	or	%g0,0xee2,%g1
	ba	p2_failed
	mov	%o5,%g3

p2_common_signature_error:
	set	p2_temp,%g1
	ba	p2_failed
	st	%g2,[%g1]			! Common Lock Number

p2_common_timeout:
	set	p2_temp,%g1
	ba	p2_failed
	st	%g2,[%g1]			! Common Lock Number
p2_branch_failed:
	mov	0xbbb,%g1
	rd	%ccr,%g2
	ba	p2_failed
	mov	0x0,%g3

p2_trap1e:
	ldsw	[%i0+0x068],%l4		! Mem[0000000018000068]
	ldx	[%i0+0x1a8],%l5		! Mem[00000000180001a8]
	done

p2_trap1o:
	ldsw	[%o0+0x068],%l4		! Mem[0000000018000068]
	ldx	[%o0+0x1a8],%l5		! Mem[00000000180001a8]
	done


p2_trap2e:
	smul	%l1,%l5,%l6
	andncc	%l3,0xdd9,%l7
	lduw	[%o5+0x038],%l7		! Mem[0000000040a00038]
	lduw	[%o3+0x054],%l4		! Mem[0000000071800054]
	ldx	[%i1+0x168],%l5		! Mem[0000000018800168]
	ldsw	[%o3+0x010],%l6		! Mem[0000000071800010]
	ldd	[%o1+0x010],%l6		! Mem[0000000070800010]
	done

p2_trap2o:
	smul	%l1,%l5,%l6
	andncc	%l3,0xdd9,%l7
	lduw	[%i5+0x038],%l7		! Mem[0000000040a00038]
	lduw	[%i3+0x054],%l4		! Mem[0000000071800054]
	ldx	[%o1+0x168],%l5		! Mem[0000000018800168]
	ldsw	[%i3+0x010],%l6		! Mem[0000000071800010]
	ldd	[%i1+0x010],%l6		! Mem[0000000070800010]
	done


p2_init_memory_pointers:
	set	p2_init_registers,%g1
	mov	%g0,%g4
	mov	%g0,%g5
	mov	%g0,%g6
	mov	%g0,%g7

!	Initialize memory pointers for window 0
	set	p2_local0_start,%i0
	set	p2_local1_start,%i1
	set	p2_local2_start,%i2
	set	p2_local3_start,%i3
	set	p2_local4_start,%i4
	set	p2_local5_start,%i5
	set	p2_local6_start,%i6
	mov	%g0,%i7
!	Init Local Registers in Window 0
	ldx	[%g1+0x000],%l0	! %l0 = 01b91f71df2547cf
	ldx	[%g1+0x008],%l1	! %l1 = 50a2d1aa04228467
	ldx	[%g1+0x010],%l2	! %l2 = aaa194b8b8101a0e
	ldx	[%g1+0x018],%l3	! %l3 = 62ef3bd44c9f6765
	ldx	[%g1+0x020],%l4	! %l4 = e18d5506262f384a
	ldx	[%g1+0x028],%l5	! %l5 = db0b0246b81e38d1
	ldx	[%g1+0x030],%l6	! %l6 = 6f159f4c085cca5a
	ldx	[%g1+0x038],%l7	! %l7 = 58f6efe1ae0bd466

!	Initialize the output register of window 0
	set	share0_start,%o0
	set	share1_start,%o1
	set	share2_start,%o2
	set	share3_start,%o3
	set	unres0_start,%o4
	set	common_start,%o5
	mov	0x08,%o6

	retl
	nop

!	Random code for Processor 3

processor_3:
	ta	T_CHANGE_PRIV
	set	done_flags,%g1
	mov	1,%g2
	st	%g2,[%g1+0x0c]		! Set the start flag
	wrpr	%g0,7,%cleanwin
	call	p3_init_memory_pointers
	wr	%g0,0x80,%asi		! Setting default asi to 80

!	Initialize the floating point registers for processor 3

	wr	%g0,0x4,%fprs		! Make sure fef is 1
	set	p3_init_freg,%g1
!	%f0  = 70d86453 2b4ea0b6 e7e4d01a ec0cd0b1
!	%f4  = d001213c 16a76a67 48e21534 1a568ae9
!	%f8  = 56cb52c7 f67841ba 5707bdb1 77cfe045
!	%f12 = 749a1290 7265ad88 e02934d8 4fb7182f
	ldda	[%g1]ASI_BLK_P,%f0
	add	%g1,64,%g1
!	%f16 = a7afcedc 9a847db6 ce5c53c1 e19ffe3f
!	%f20 = 115edf46 0eb0e012 051087aa e85b6b34
!	%f24 = 0acac5d8 cacb2a67 85446fcb b691e6f9
!	%f28 = fff13dea f3316b50 9dabc92d 2144b96d
	ldda	[%g1]ASI_BLK_P,%f16
	add	%g1,64,%g1
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%g1]ASI_BLK_P,%f32
	xorcc	%g0,%g0,%g3		! init %g3 and set flags
	membar	#Sync			! Force the block loads to complete

!	Start of Random Code for processor 3

p3_label_1:
!	Mem[000000001f000108] = 6e4fd894d4452d7c, %l0 = d8438028785bff0d
	ldxa	[%i6+0x108]%asi,%l0	! %l0 = 6e4fd894d4452d7c
!	Mem[0000000072000040] = e52f81e7 7204d04f 2bf57d99 e8bcab63
!	Mem[0000000072000050] = 876a38ba 4684903e 4d87bc9b fb584d4b
!	Mem[0000000072000060] = 330289d1 834615f3 560b78a1 da01ee66
!	Mem[0000000072000070] = ea47ccfe 2b6b1536 b32a25dd 6960f59a
	mov	0x040,%g4
	ldda	[%o4+%g4]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[000000001d000040] = 68c4dfe5 58fcfb38 669cc43b df5edf13
!	Mem[000000001d000050] = c99fa2bb 7932f6ef 0ae51970 1cdf6c91
!	Mem[000000001d000060] = b93fd0f7 93c7ad07 16c1dd3f e1807b68
!	Mem[000000001d000070] = cd88da0e 592e803b 541f9352 7d0c3b60
	ldda	[%i2+%g4]ASI_BLK_PL,%f0	! Block Load from 000000001d000040
!	Mem[000000001d800000] = 5d3994ed9ac2e4c4, %l1 = 2d612268b4e86568
	ldxa	[%i3+%g0]0x80,%l1	! %l1 = 5d3994ed9ac2e4c4
!	Mem[000000001e000038] = f47f695e d5388592, %l4 = a5b45a43, %l5 = 065d2ad4
	ldd	[%i4+0x038],%l4		! %l4 = 00000000f47f695e 00000000d5388592

p3_label_2:
!	Mem[000000001d000100] = 3423d7f5 f63ebe1f 60c1a979 616e8b90
!	Mem[000000001d000110] = 9de3fe38 4a2ad3f5 25436b47 b5e29898
!	Mem[000000001d000120] = dd9196be 51a0d417 d730181e f0d935ff
!	Mem[000000001d000130] = 8ca6bed2 447719ef ee8c363b d0ec8b3c
	mov	0x100,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 000000001d000100
!	Mem[0000000071000058] = 66eb43a4, %l5 = 00000000d5388592
	lduw	[%o2+0x058],%l5		! %l5 = 0000000066eb43a4
!	Mem[000000001d800000] = 5d3994ed, %l4 = 00000000f47f695e
	lduba	[%i3+%g0]0x80,%l4	! %l4 = 000000000000005d
!	%f24 = 0acac5d8, Mem[000000001d000010] = 3eb6f4ea
	st	%f24,[%i2+0x010]	! Mem[000000001d000010] = 0acac5d8
!	Mem[000000001f000008] = ff5e0603, %l2 = 0595c7dded844bb3
	lduba	[%i6+%o6]0x80,%l2	! %l2 = 00000000000000ff

p3_label_3:
!	Mem[000000001d800000] = 5d3994ed, %l6 = 7af6563a382e7efd
	lduwa	[%i3+%g0]0x80,%l6	! %l6 = 000000005d3994ed
!	%l7 = f206291c2997c25c, Mem[000000001c000000] = bec65b27
	stwa	%l7,[%i0+%g0]0x80	! Mem[000000001c000000] = 2997c25c
!	Mem[000000007000001c] = a1d31b99, %l3 = 3fafdaee05479dae
	lduh	[%o0+0x01e],%l3		! %l3 = 0000000000001b99
!	Mem[0000000072000050] = ba468490, %l1 = 5d3994ed9ac2e4c4
	ldsba	[%o4+0x053]%asi,%g2	! %g2 = ffffffffffffffba
!	Mem[000000001c000080] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001c000090] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001c0000a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001c0000b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f0	! Block Load from 000000001c000080

p3_label_4:
	fbug,pn	%fcc1,p3_branch_failed	! Branch Not Taken, %fcc1 = 0
!	Mem[0000000071000018] = 9460d876, %l2 = 00000000000000ff
	ldsb	[%o2+0x018],%l2		! %l2 = ffffffffffffff94
p3_b1:
!	Mem[000000001c800000] = 58f0aa8f, %l3 = 0000000000001b99
	lduwa	[%i1+%g0]0x80,%l3	! %l3 = 0000000058f0aa8f
!	Mem[000000001c800008] = 5e61cc78, %l3 = 0000000058f0aa8f
	lduha	[%i1+%o6]0x80,%l3	! %l3 = 0000000000005e61
!	Mem[000000007000005c] = 73e79db9, %l3 = 0000000000005e61
	lduha	[%o0+0x05e]%asi,%l3	! %l3 = 0000000000009db9

p3_label_5:
	ba	p3_b2			! Branch Taken, %ccr = 44, CWP = 0
!	Mem[0000000072000028] = 672805f9 c6c2069f, %l4 = 0000005d, %l5 = 66eb43a4
	ldd	[%o4+0x028],%g2		! %l4 = 000000000000005d 0000000066eb43a4
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x002,%g2
p3_b2:
!	%f30 = 9dabc92d, %f23 = e85b6b34
	fabss	%f30,%f23		! %f23 = 1dabc92d
!	Mem[000000001d800098] = d7a8e94d63e43408, %l0 = 6e4fd894d4452d7c
	ldx	[%i3+0x098],%l0		! %l0 = d7a8e94d63e43408
!	%l7 = f206291c2997c25c, Mem[000000001c800000] = 58f0aa8fc43d8a40
	stxa	%l7,[%i1+%g0]0x80	! Mem[000000001c800000] = f206291c2997c25c

p3_label_6:
!	Mem[000000001c800080] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c800090] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c8000a0] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c8000b0] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%i1+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001c800080
!	%l5 = 0000000066eb43a4, immed = fffff0f7, %y  = 00000000
	udivx	%l5,-0xf09,%l6		! %l6 = 0000000000000000
	be	p3_b3			! Branch Taken, %ccr = 44, CWP = 0
!	Mem[000000001d000180] = a8d6b6a3 b1ac315e, %l6 = 00000000, %l7 = 2997c25c
	ldd	[%i2+0x180],%l6		! %l6 = 00000000a8d6b6a3 00000000b1ac315e
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x003,%g2
p3_b3:
!	%l3 = 0000000000009db9, %l4 = 000000000000005d, %l0 = d7a8e94d63e43408
	sllx	%l3,%l4,%l0		! %l0 = 000013b720000000

p3_label_7:
!	Mem[000000007080001c] = 3270ad19, %l5 = 0000000066eb43a4
	ldub	[%o1+0x01d],%l5		! %l5 = 0000000000000070
!	Mem[0000000071800058] = 79c52bb5, %l7 = 00000000b1ac315e
	lduha	[%o3+0x058]%asi,%l7	! %l7 = 00000000000079c5
!	Mem[0000000072000000] = 83b01c70, %l5 = 0000000000000070
	lduw	[%o4+0x000],%g2		! %g2 = 0000000000000070
	fbug,pt	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%l6 = 00000000a8d6b6a3, Mem[000000001d800000] = 5d3994ed
	stha	%l6,[%i3+%g0]0x80	! Mem[000000001d800000] = b6a394ed
p3_b4:

p3_label_8:
!	Mem[000000001d000138] = ee8c363bd0ec8b3c, %l4 = 000000000000005d
	ldxa	[%i2+0x138]%asi,%l4	! %l4 = ee8c363bd0ec8b3c
!	Mem[000000001c800000] = f206291c, %l0 = 000013b720000000
	lduwa	[%i1+%g0]0x80,%l0	! %l0 = 00000000f206291c
!	Mem[0000000071800018] = d0183f9e08e6b927, %l0 = 00000000f206291c
	ldxa	[%o3+0x018]%asi,%l0	! %l0 = d0183f9e08e6b927
!	Mem[000000001d000000] = 03bbdca6, %l7 = 00000000000079c5
	ldsha	[%i2+%g0]0x80,%l7	! %l7 = 00000000000003bb
!	Mem[000000001c8000b8] = ab224f7c42717296, %l7 = 00000000000003bb
	ldx	[%i1+0x0b8],%l7		! %l7 = ab224f7c42717296

p3_label_9:
!	Mem[0000000070000058] = d31b1a2573e79db9, %l4 = ee8c363bd0ec8b3c
	ldxa	[%o0+0x058]%asi,%l4	! %l4 = d31b1a2573e79db9
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000070800018] = 52cf8915 3270ad19, %l0 = 08e6b927, %l1 = 9ac2e4c4
	ldd	[%o1+0x018],%l0		! %l0 = 0000000052cf8915 000000003270ad19
!	Mem[000000001c000080] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001c000090] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001c0000a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001c0000b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 000000001c000080
	membar	#Sync			! Added by membar checker (156)
!	Mem[0000000072000020] = 32b332eceff13f4c, %l2 = ffffffffffffff94
	ldxa	[%o4+0x020]%asi,%g2	! %g2 = 32b332eceff13f4c

p3_label_10:
!	Mem[000000001d8001f0] = 074654270e13c145, %l4 = d31b1a2573e79db9
	ldx	[%i3+0x1f0],%l4		! %l4 = 074654270e13c145
!	Mem[000000001e800090] = 0628f3dd 6aff7734, %l0 = 52cf8915, %l1 = 3270ad19
	ldda	[%i5+0x090]%asi,%l0	! %l0 = 000000000628f3dd 000000006aff7734
!	%f16 = e064cced 2de9875e 3e51673d 31776a93
!	%f20 = 2f467805 e8922323 ae103a64 0e1430c3
!	%f24 = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f28 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000001e8000f0] = 52dbc52b, %l1 = 000000006aff7734
	ldsb	[%i5+0x0f0],%l1		! %l1 = 0000000000000052
!	%l1 = 0000000000000052, %l4 = 074654270e13c145, %l4 = 074654270e13c145
	srlx	%l1,%l4,%l4		! %l4 = 0000000000000002

p3_label_11:
!	Mem[000000001d000130] = 8ca6bed2, %l6 = 00000000a8d6b6a3
	lduh	[%i2+0x130],%l6		! %l6 = 0000000000008ca6
!	Mem[000000001d800180] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d800190] = d24e37b8 d7343a59 b2162a2e f2814628
!	Mem[000000001d8001a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d8001b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x180,%g4
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 000000001d800180
!	%l1 = 0000000000000052, %l1 = 0000000000000052, %y  = 00000000
	udivcc	%l1,%l1,%l0		! %l0 = 0000000000000001, %ccr = 00
	mov	%l0,%y			! %y = 00000001
!	Mem[000000001c8000c0] = 771bcb80, %l1 = 0000000000000052
	lduha	[%i1+0x0c0]%asi,%l1	! %l1 = 000000000000771b
	bneg	p3_not_taken_0		! Branch Not Taken, %ccr = 00

p3_label_12:
!	Mem[000000001c800000] = f206291c, %l7 = ab224f7c42717296
	lduwa	[%i1+%g0]0x80,%l7	! %l7 = 00000000f206291c
p3_b5:
!	%f16 = e064cced 2de9875e 3e51673d 31776a93
!	%f20 = 2f467805 e8922323 ae103a64 0e1430c3
!	%f24 = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f28 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 000000001d800180
!	%f0  = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e f2814628
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x040,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 000000001c000040
!	Mem[000000001c800008] = 5e61cc78, %l7 = 00000000f206291c
	lduwa	[%i1+%o6]0x80,%l7	! %l7 = 000000005e61cc78
!	Mem[000000001d000008] = 98c024db, %l2 = ffffffffffffff94
	lduha	[%i2+%o6]0x80,%l2	! %l2 = 00000000000098c0

p3_label_13:
!	Mem[000000001c800058] = 7da25b15, %l0 = 0000000000000001
	ldsb	[%i1+0x059],%l0		! %l0 = ffffffffffffffa2
!	%l2 = 00000000000098c0, Mem[000000001d800008] = 0a676ecc
	stha	%l2,[%i3+%o6]0x80	! Mem[000000001d800008] = 98c06ecc
!	Mem[000000001c800000] = f206291c, %l2 = 00000000000098c0
	ldswa	[%i1+%g0]0x80,%l2	! %l2 = fffffffff206291c
	membar	#Sync
	fblg,a,pt %fcc2,p3_branch_failed	! Branch Not Taken, %fcc2 = 0
!	%f27 = d6ac30a4, %f12 = c89763f6 66926f10
	fstox	%f27,%f12	! Annulled
p3_b6:

p3_label_14:
!	Mem[000000001d000008] = 98c024db768a8374, %l5 = 0000000000000070
	ldxa	[%i2+%o6]0x80,%l5	! %l5 = 98c024db768a8374
!	%f0  = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e f2814628
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x1c0,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d8001c0
!	Mem[000000001c000030] = 874940a3, %l7 = 000000005e61cc78
	ldsh	[%i0+0x032],%l7		! %l7 = 00000000000040a3
!	%f28 = eab0f286 9053fabb, %f28 = eab0f286 9053fabb, %f20 = 2f467805 e8922323
	fsubd	%f28,%f28,%f20		! %f20 = 00000000 00000000
!	%f0  = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e f2814628
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 000000001c000100

p3_label_15:
	membar	#Sync			! Added by membar checker (157)
!	Mem[000000001c000100] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000110] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c000120] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c000130] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i0+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c000100
!	Mem[000000001f000008] = ff5e0603, %l3 = 0000000000009db9
	lduwa	[%i6+%o6]0x80,%l3	! %l3 = 00000000ff5e0603
	ba	p3_b7			! Branch Taken, %ccr = 00, CWP = 0
!	Mem[000000001d000008] = 98c024db, %l0 = ffffffffffffffa2
	lduha	[%i2+%o6]0x80,%l0	! %l0 = 00000000000098c0
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p3_branch_failed
	mov	0x007,%g2
p3_b7:
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000

p3_label_16:
!	Mem[000000007100005c] = 451ad68b, %l2 = fffffffff206291c
	ldswa	[%o2+0x05c]%asi,%l2	! %l2 = 00000000451ad68b
!	Mem[000000001c0000c4] = 2f8a6397, %l7 = 00000000000040a3
	lduw	[%i0+0x0c4],%l7		! %l7 = 000000002f8a6397
!	Mem[000000001d800140] = 428060ec 0d219974 02cd58ca 49920f54
!	Mem[000000001d800150] = 6c3d133e 0ea51a73 5fa20221 872231f3
!	Mem[000000001d800160] = a2ff2d95 6b290eab 0f3282de 996fa6f6
!	Mem[000000001d800170] = 3e9bc816 a0a79717 bb4553f0 83cd6ebd
	mov	0x140,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d800140
!	Mem[0000000071800058] = 79c52bb5, %l7 = 000000002f8a6397
	ldsb	[%o3+0x059],%l7		! %l7 = ffffffffffffffc5
!	%f0  = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e f2814628
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x080,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d800080

p3_label_17:
!	%f16 = 428060ec, Mem[0000000071000058] = 66eb43a4
	st	%f16,[%o2+0x058]	! Mem[0000000071000058] = 428060ec
!	%l4 = 0000000000000002, immed = 00000d58, %y  = 00000001
	udiv	%l4,0xd58,%l0		! %l0 = 0000000000132f5c
	mov	%l0,%y			! %y = 00132f5c
!	%f0  = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e f2814628
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 000000001d000080
!	%f0  = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e f2814628
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x180,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 000000001c000180
!	Mem[000000001c000008] = 7bb1f8f4 a7adcde1, %l6 = 00008ca6, %l7 = ffffffc5
	ldda	[%i0+%o6]0x80,%l6	! %l6 = 000000007bb1f8f4 00000000a7adcde1

p3_label_18:
!	Mem[000000001c8000a4] = f4c1a9ac, %l1 = 000000000000771b
	ldub	[%i1+0x0a4],%l1		! %l1 = 00000000000000f4
!	Mem[000000001d8001c0] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d8001d0] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001d8001e0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8001f0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x1c0,%g4
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 000000001d8001c0
!	Mem[0000000070800018] = 52cf8915, %l0 = 0000000000132f5c
	ldub	[%o1+0x01b],%l0		! %l0 = 0000000000000015
!	Mem[000000001d800140] = 428060ec 0d219974 02cd58ca 49920f54
!	Mem[000000001d800150] = 6c3d133e 0ea51a73 5fa20221 872231f3
!	Mem[000000001d800160] = a2ff2d95 6b290eab 0f3282de 996fa6f6
!	Mem[000000001d800170] = 3e9bc816 a0a79717 bb4553f0 83cd6ebd
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d800140
!	Mem[0000000071000058] = 428060ec 451ad68b, %l6 = 7bb1f8f4, %l7 = a7adcde1
	ldd	[%o2+0x058],%l6		! %l6 = 00000000428060ec 00000000451ad68b

p3_label_19:
!	Mem[000000001c000040] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000050] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c000060] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c000070] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x040,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 000000001c000040
!	Mem[000000001f000000] = f04054f6, %l1 = 00000000000000f4
	lduba	[%i6+%g0]0x80,%l1	! %l1 = 00000000000000f0
!	Mem[000000001f000038] = eecca164, %l2 = 00000000451ad68b
	ldswa	[%i6+0x038]%asi,%l2	! %l2 = ffffffffeecca164
!	Mem[000000007000001c] = a1d31b99, %l6 = 00000000428060ec
	lduh	[%o0+0x01c],%l6		! %l6 = 000000000000a1d3
!	Mem[000000001c8001c4] = c7e8c9e7, %l4 = 0000000000000002
	ldsha	[%i1+0x1c6]%asi,%l4	! %l4 = ffffffffffffc9e7

p3_label_20:
!	Mem[000000007100001c] = fa88dc14, %l2 = ffffffffeecca164
	lduh	[%o2+0x01c],%l2		! %l2 = 000000000000fa88
	membar	#Sync			! Added by membar checker (158)
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	%l0 = 0000000000000015, immed = fffffd08, %l2 = 000000000000fa88
	or	%l0,-0x2f8,%l2		! %l2 = fffffffffffffd1d
!	%f28 = 106f9266 f66397c8, %f28 = 106f9266 f66397c8, %f20 = 593a34d7 b8374ed2
	fdivd	%f28,%f28,%f20		! %f20 = 3ff00000 00000000
!	Mem[000000001c0000b0] = eab0f2869053fabb, %l3 = 00000000ff5e0603
	ldx	[%i0+0x0b0],%l3		! %l3 = eab0f2869053fabb

p3_label_21:
	nop
!	Mem[000000001d000000] = 03bbdca6, %l7 = 00000000451ad68b
	ldsba	[%i2+%g0]0x80,%l7	! %l7 = 0000000000000003
!	%l7 = 0000000000000003, immed = 0000043c, %l3 = eab0f2869053fabb
	subccc	%l7,0x43c,%l3		! %l3 = fffffffffffffbc7, %ccr = 99
!	Mem[000000007080005c] = b0d9076b, %l5 = 98c024db768a8374
	ldsw	[%o1+0x05c],%l5		! %l5 = ffffffffb0d9076b
!	%l4 = ffffffffffffc9e7, Mem[000000001d800008] = 98c06ecc
	stha	%l4,[%i3+%o6]0x80	! Mem[000000001d800008] = c9e76ecc

p3_label_22:
!	Mem[000000007080001c] = 3270ad19, %l6 = 000000000000a1d3
	lduh	[%o1+0x01e],%l6		! %l6 = 000000000000ad19
!	Mem[0000000071000058] = 428060ec, %l4 = ffffffffffffc9e7
	lduwa	[%o2+0x058]%asi,%l4	! %l4 = 00000000428060ec
!	Mem[000000001c000080] = e064cced2de9875e, %l4 = 00000000428060ec
	ldx	[%i0+0x080],%l4		! %l4 = e064cced2de9875e
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 3ff00000 00000000 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 000000001d000180
!	Mem[0000000072000040] = e52f81e7 7204d04f 2bf57d99 e8bcab63
!	Mem[0000000072000050] = 876a38ba 4684903e 4d87bc9b fb584d4b
!	Mem[0000000072000060] = 330289d1 834615f3 560b78a1 da01ee66
!	Mem[0000000072000070] = ea47ccfe 2b6b1536 b32a25dd 6960f59a
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p3_label_23:
	fbl,a,pn %fcc2,p3_branch_failed	! Branch Not Taken, %fcc2 = 0
!	Mem[000000001d8000d0] = cd42a490c1cff966, %l3 = fffffffffffffbc7
	ldx	[%i3+0x0d0],%l3		! Annulled
p3_b8:
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x100,%g6
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 000000001c000100
!	%f20 = 3ff00000 00000000, %f22 = 284681f2
	fdtoi	%f20,%f22		! %f22 = 00000001
!	Mem[0000000071800058] = 79c52bb5 917208b8, %l0 = 00000015, %l1 = 000000f0
	ldd	[%o3+0x058],%l0		! %l0 = 0000000079c52bb5 00000000917208b8

p3_label_24:
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x140,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d800140
!	Mem[000000001c8001f4] = 5662b939, %l7 = 0000000000000003
	ldsb	[%i1+0x1f4],%l7		! %l7 = 0000000000000056
!	Mem[000000001d000140] = 23a86afc 0b931a1e 3f115eed 716586a0
!	Mem[000000001d000150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001d000160] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[000000001d000170] = 59c320fe e6321e0b 71743dcd ba241389
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 000000001d000140
	fbg	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000001c800128] = a353d4acd1cc55a9, %l3 = fffffffffffffbc7
	ldx	[%i1+0x128],%l3		! %l3 = a353d4acd1cc55a9
p3_b9:

p3_label_25:
!	%l1 = 00000000917208b8, Mem[000000001d000008] = 98c024db768a8374
	stxa	%l1,[%i2+%o6]0x80	! Mem[000000001d000008] = 00000000917208b8
!	Mem[000000001d8001c0] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d8001d0] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001d8001e0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8001f0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x1c0,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001d8001c0
!	Mem[000000001c800008] = 5e61cc78, %l6 = 000000000000ad19
	ldsba	[%i1+%o6]0x80,%l6	! %l6 = 000000000000005e
!	Mem[0000000071000018] = 9460d876 fa88dc14, %l6 = 0000005e, %l7 = 00000056
	ldda	[%o2+0x018]%asi,%l6	! %l6 = 000000009460d876 00000000fa88dc14
!	Mem[000000007080005c] = b0d9076b, %l4 = e064cced2de9875e
	ldsh	[%o1+0x05e],%l4		! %l4 = 000000000000076b

p3_label_26:
!	Mem[000000007000001c] = a1d31b99, %l5 = ffffffffb0d9076b
	lduha	[%o0+0x01e]%asi,%l5	! %l5 = 0000000000001b99
	membar	#Sync			! Added by membar checker (159)
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[000000001d800000] = b6a394ed, %l4 = 000000000000076b
	ldswa	[%i3+%g0]0x80,%l4	! %l4 = ffffffffb6a394ed
!	Mem[000000001e0000d0] = 42c6f53d, %l0 = 0000000079c52bb5
	ldswa	[%i4+0x0d0]%asi,%l0	! %l0 = 0000000042c6f53d
!	Mem[000000001d800000] = b6a394ed, %l2 = fffffffffffffd1d
	ldswa	[%i3+%g0]0x80,%l2	! %l2 = ffffffffb6a394ed

p3_label_27:
	membar	#Sync			! Added by membar checker (160)
!	Mem[0000000072000000] = e07e1e74 44a56aef 4379fcbb 2c50b10f
!	Mem[0000000072000010] = 4d3b072a c5c8540e 21ea56eb 31d3c4fc
!	Mem[0000000072000020] = 32b332ec eff13f4c b5aaae0a 75726cd8
!	Mem[0000000072000030] = 6138680a eed07ee3 4590c6e7 c4b998ec
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[000000001d8000c8] = 903ba418, %l2 = ffffffffb6a394ed
	ldsha	[%i3+0x0ca]%asi,%l2	! %l2 = ffffffffffffa418
!	%l6 = 000000009460d876, Mem[000000001d000148] = 3f115eed716586a0
	stx	%l6,[%i2+0x148]		! Mem[000000001d000148] = 000000009460d876
	set	p3_b10,%o7
	fble	p3_far_0_le		! Branch Taken, %fcc0 = 0
!	Mem[000000007100005c] = 451ad68b, %l5 = 0000000000001b99
	ldsh	[%o2+0x05c],%l5		! %l5 = 000000000000451a
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p3_branch_failed
	mov	0x00a,%g2
p3_b10:
!	Registers modified during the branch to p3_far_0
!	%l1  = 00000000917208b8
!	%l2  = fffffffffeabdcfd
!	%l5  = d0183f9e08e6b927

p3_label_28:
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x0c0,%g6
	stda	%f0,[%i5+%g6]ASI_BLK_P	! Block Store to 000000001e8000c0
!	%f16 = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e f2814628
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i3]ASI_BLK_PL	! Block Store to 000000001d800000
!	Mem[000000001d00000c] = 917208b8, %l6 = 000000009460d876
	ldsw	[%i2+0x00c],%l6		! %l6 = ffffffff917208b8
!	Mem[0000000072000048] = 7d99e8bc, %l6 = ffffffff917208b8
	lduh	[%o4+0x04a],%g2		! %g2 = 0000000000007d99
!	Mem[000000001c00004c] = 17e0a64b, %l6 = ffffffff917208b8
	lduwa	[%i0+0x04c]%asi,%l6	! %l6 = 0000000017e0a64b

p3_label_29:
!	Mem[0000000070000018] = 3b25e6ae a1d31b99, %l0 = 42c6f53d, %l1 = 917208b8
	ldd	[%o0+0x018],%l0		! %l0 = 000000003b25e6ae 00000000a1d31b99
	membar	#Sync			! Added by membar checker (161)
!	Mem[000000001d800000] = 34cb72f2, %l6 = 0000000017e0a64b
	lduba	[%i3+%g0]0x80,%l6	! %l6 = 0000000000000034
!	Mem[000000001c800008] = 5e61cc78, %l0 = 000000003b25e6ae
	ldsha	[%i1+%o6]0x80,%l0	! %l0 = 0000000000005e61
!	Mem[000000001d000160] = 5c8ccd98ee68008c, %l2 = fffffffffeabdcfd
	ldx	[%i2+0x160],%l2		! %l2 = 5c8ccd98ee68008c
!	%f16 = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e f2814628
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x100,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 000000001d800100

p3_label_30:
!	Mem[0000000070000058] = d31b1a2573e79db9, %l2 = 5c8ccd98ee68008c
	ldx	[%o0+0x058],%l2		! %l2 = d31b1a2573e79db9
!	Mem[0000000072000014] = 540e21ea, %l4 = ffffffffb6a394ed
	lduha	[%o4+0x016]%asi,%g2	! %g2 = 000000000000540e
!	Mem[000000001e800000] = 097f71f4, %l3 = a353d4acd1cc55a9
	ldsba	[%i5+%g0]0x80,%l3	! %l3 = 0000000000000009
!	Mem[000000001d000008] = 00000000, %l2 = d31b1a2573e79db9
	lduba	[%i2+%o6]0x80,%l2	! %l2 = 0000000000000000
	membar	#Sync			! Added by membar checker (162)
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 000000001d800100

p3_label_31:
!	%l4 = ffffffffb6a394ed, %l2 = 0000000000000000, %l2 = 0000000000000000
	orn	%l4,%l2,%l2		! %l2 = ffffffffffffffff
	fbul,pt	%fcc2,p3_branch_failed	! Branch Not Taken, %fcc2 = 0
!	%f30 = aea36c79 10bfa683, %f30 = aea36c79 10bfa683, %f20 = d24e37b8 d7343a59
	faddd	%f30,%f30,%f20		! %f20 = aeb36c79 10bfa683
p3_b11:
!	Mem[000000001c000180] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000190] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c0001a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c0001b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x180,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 000000001c000180
!	Mem[000000001d000058] = 0ae519701cdf6c91, %l7 = 00000000fa88dc14
	ldx	[%i2+0x058],%l7		! %l7 = 0ae519701cdf6c91

p3_label_32:
!	Mem[000000001c00005c] = 2e2a16b2, %l1 = 00000000a1d31b99
	lduba	[%i0+0x05d]%asi,%l1	! %l1 = 000000000000002a
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	mov	0x040,%g6
	stda	%f32,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[000000001c800194] = 9f50420a, %l7 = 0ae519701cdf6c91
	ldsha	[%i1+0x196]%asi,%l7	! %l7 = 000000000000420a
!	Mem[000000001c800008] = 5e61cc78, %l5 = d0183f9e08e6b927
	lduba	[%i1+%o6]0x80,%l5	! %l5 = 000000000000005e
!	Mem[000000007080005c] = b0d9076b, %l5 = 000000000000005e
	lduha	[%o1+0x05e]%asi,%l5	! %l5 = 000000000000076b

p3_label_33:
!	Mem[000000001d0001e8] = 64377c5e8f18b3d7, %f6  = 284681f2 2e2a16b2
	ldd	[%i2+0x1e8],%f6 	! %f6  = 64377c5e 8f18b3d7
!	%l5 = 000000000000076b, %l5 = 000000000000076b, %l4 = ffffffffb6a394ed
	orn	%l5,%l5,%l4		! %l4 = ffffffffffffffff
!	Mem[000000001e800000] = 097f71f4 6a030220, %l0 = 00005e61, %l1 = 0000002a
	ldda	[%i5+%g0]0x80,%l0	! %l0 = 00000000097f71f4 000000006a030220
!	Mem[0000000071000058] = 428060ec, %l3 = 0000000000000009
	ldsw	[%o2+0x058],%l3		! %l3 = 00000000428060ec
!	%l1 = 000000006a030220, Mem[0000000070000018] = 3b25e6ae
	stwa	%l1,[%o0+0x018]%asi	! Mem[0000000070000018] = 6a030220

p3_label_34:
!	Mem[0000000070000018] = 6a030220, %l7 = 000000000000420a
	ldsw	[%o0+0x018],%l7		! %l7 = 000000006a030220
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 64377c5e 8f18b3d7
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 000000001d0001c0
!	Mem[000000001c8000c0] = 771bcb80 205858e9 4c9a5fb5 dc958bd5
!	Mem[000000001c8000d0] = e649c680 8955509f e08d1644 da919a29
!	Mem[000000001c8000e0] = 2e333e7a c2c45a90 a77d4ec7 6a625f78
!	Mem[000000001c8000f0] = 6e4b9712 89fc85b4 5bcd6083 c964e0dc
	mov	0x0c0,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c8000c0
!	Mem[000000001c000000] = 2997c25c, %l0 = 00000000097f71f4
	ldswa	[%i0+%g0]0x80,%l0	! %l0 = 000000002997c25c
	membar	#Sync			! Added by membar checker (163)
	set	p3_b12,%o7
	fbue	p3_far_0_he		! Branch Taken, %fcc0 = 0

p3_label_35:
!	Mem[000000001c8001a8] = b1e095b3, %l0 = 000000002997c25c
	ldsw	[%i1+0x1a8],%l0		! %l0 = ffffffffb1e095b3
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x00c,%g2
p3_b12:
!	Registers modified during the branch to p3_far_0
!	%l0  = fffffffffffff206
!	%l1  = 79c52bb5523e4c31
!	%l3  = dd9196be51a0d417
!	%l7  = 000000000000076f
!	Mem[000000001c000000] = 2997c25c, %l6 = 0000000000000034
	ldsha	[%i0+%g0]0x80,%l6	! %l6 = 0000000000002997
!	Mem[0000000071000058] = 6a030220, %l2 = ffffffffffffffff
	ldsw	[%o2+0x058],%l2		! %l2 = 000000006a030220
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x140,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 000000001d800140
!	%f0  = 771bcb80 205858e9 4c9a5fb5 dc958bd5
!	%f4  = e649c680 8955509f e08d1644 da919a29
!	%f8  = 2e333e7a c2c45a90 a77d4ec7 6a625f78
!	%f12 = 6e4b9712 89fc85b4 5bcd6083 c964e0dc
	stda	%f0,[%i2]ASI_BLK_P	! Block Store to 000000001d000000

p3_label_36:
!	Mem[0000000072000040] = e07e1e74 44a56aef 4379fcbb 2c50b10f
!	Mem[0000000072000050] = 4d3b072a c5c8540e 21ea56eb 31d3c4fc
!	Mem[0000000072000060] = 32b332ec eff13f4c b5aaae0a 75726cd8
!	Mem[0000000072000070] = 6138680a eed07ee3 4590c6e7 c4b998ec
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[000000001c000080] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001c000090] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001c0000a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001c0000b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x080,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 000000001c000080
!	Mem[000000001d800180] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d800190] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d8001a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d8001b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x180,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 000000001d800180
!	Branch On Register, %l4 = ffffffffffffffff
	brgez,a,pn %l4,p3_not_taken_0	! Branch Not Taken
!	 Annulled
	ldd	[%o0+0x018],%l0
p3_b13:

p3_label_37:
!	%f18 = 3e51673d 31776a93, %f24 = 720eb292 1664ae9c
	fmovd	%f18,%f24		! %f24 = 3e51673d 31776a93
!	%l6 = 0000000000002997, %l3 = dd9196be51a0d417, %l0 = fffffffffffff206
	orcc	%l6,%l3,%l0		! %l0 = dd9196be51a0fd97, %ccr = 80
!	Mem[000000001d800040] = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	Mem[000000001d800050] = d632f1ea 3ac27463 a4d59e16 764da52e
!	Mem[000000001d800060] = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	Mem[000000001d800070] = c4e1cb6d 040550b0 30c62485 fcb21a92
	mov	0x040,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d800040
!	Mem[000000001d800040] = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	Mem[000000001d800050] = d632f1ea 3ac27463 a4d59e16 764da52e
!	Mem[000000001d800060] = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	Mem[000000001d800070] = c4e1cb6d 040550b0 30c62485 fcb21a92
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 000000001d800040
!	%f12 = b0500504 6dcbe1c4, %f12 = b0500504 6dcbe1c4, %f0  = 179a4bf9 e37a08a0
	fdivd	%f12,%f12,%f0 		! %f0  = 3ff00000 00000000

p3_label_38:
!	Mem[000000001c000100] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c000110] = d24e37b8 d7343a59 b2162a2e f2814628
!	Mem[000000001c000120] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c000130] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x100,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 000000001c000100
!	Mem[000000001c000080] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001c000090] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001c0000a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001c0000b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x080,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c000080
!	%l0 = dd9196be51a0fd97, immed = fffff62c, %y  = 00000375
	udivx	%l0,-0x9d4,%l5		! %l5 = 0000000000000000
!	Mem[0000000070000018] = 6a030220, %l1 = 79c52bb5523e4c31
	ldsba	[%o0+0x019]%asi,%l1	! %l1 = 0000000000000003
!	Mem[0000000071000058] = 6a0302206a030220, %l3 = dd9196be51a0d417
	ldx	[%o2+0x058],%l3		! %l3 = 6a0302206a030220

p3_label_39:
	membar	#Sync			! Added by membar checker (164)
!	Branch On Register, %l7 = 000000000000076f
	brnz,pn	%l7,p3_b14		! Branch Taken
!	Mem[000000001d000078] = 541f93527d0c3b60, %l6 = 0000000000002997
	ldx	[%i2+0x078],%l6		! %l6 = 541f93527d0c3b60
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p3_branch_failed
	mov	0x00e,%g2
p3_b14:
!	%f16 = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e f2814628
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 000000001c800000
!	Mem[000000001c8001c0] = cffd5522 c7e8c9e7 027af906 5b33d55b
!	Mem[000000001c8001d0] = e1836997 bc71149a cc550cc0 27c3d444
!	Mem[000000001c8001e0] = ac4e13c6 e88950b1 9ebde432 6feb3480
!	Mem[000000001c8001f0] = 603a1b99 5662b939 839268e8 9dec4bfb
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c8001c0
!	Mem[0000000071000058] = 6a030220 6a030220, %l4 = ffffffff, %l5 = 00000000
	ldd	[%o2+0x058],%l4		! %l4 = 000000006a030220 000000006a030220

p3_label_40:
!	%l3 = 6a0302206a030220, %l1 = 0000000000000003, %l5 = 000000006a030220
	taddcc	%l3,%l1,%l5		! %l5 = 6a0302206a030223, %ccr = 02
!	Mem[000000001e000008] = 1e4c4e47, %l5 = 6a0302206a030223
	ldswa	[%i4+%o6]0x80,%l5	! %l5 = 000000001e4c4e47
!	Mem[000000001c0000a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
	prefetch [%i0+0x0a0],2
!	Mem[0000000072000040] = e07e1e74 44a56aef 4379fcbb 2c50b10f
!	Mem[0000000072000050] = 4d3b072a c5c8540e 21ea56eb 31d3c4fc
!	Mem[0000000072000060] = 32b332ec eff13f4c b5aaae0a 75726cd8
!	Mem[0000000072000070] = 6138680a eed07ee3 4590c6e7 c4b998ec
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
	membar	#Sync			! Added by membar checker (165)
!	Mem[000000001c800000] = 34cb72f2 fee06d1a, %l6 = 7d0c3b60, %l7 = 0000076f
	ldda	[%i1+%g0]0x80,%l6	! %l6 = 0000000034cb72f2 00000000fee06d1a

p3_label_41:
	fbu,a,pn %fcc3,p3_branch_failed	! Branch Not Taken, %fcc3 = 0
!	%l1 = 0000000000000003, Mem[000000001e000008] = 1e4c4e470f0701fb
	stxa	%l1,[%i4+%o6]0x80	! Annulled
p3_b15:
!	Mem[000000001d000000] = 771bcb80205858e9, %l2 = 000000006a030220
	ldxa	[%i2+%g0]0x80,%l2	! %l2 = 771bcb80205858e9
!	Mem[000000001c0000a8] = d375d3b5 d6ac30a4, %l2 = 205858e9, %l3 = 6a030220
	ldda	[%i0+0x0a8]%asi,%l2	! %l2 = 00000000d375d3b5 00000000d6ac30a4
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 000000001d000040

p3_label_42:
!	%l1 = 0000000000000003, %l3 = 00000000d6ac30a4, %l0 = dd9196be51a0fd97
	srlx	%l1,%l3,%l0		! %l0 = 0000000000000000
!	%l4 = 000000006a030220, immed = 00000718, %y  = 00000375
	mulx	%l4,0x718,%l0		! %l0 = 000002f005571300
!	%l2 = 00000000d375d3b5, %l0 = 000002f005571300, %y  = 00000375
	umul	%l2,%l0,%l4		! %l4 = 046939df3a396f00
!	Mem[000000001d800040] = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	Mem[000000001d800050] = d632f1ea 3ac27463 a4d59e16 764da52e
!	Mem[000000001d800060] = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	Mem[000000001d800070] = c4e1cb6d 040550b0 30c62485 fcb21a92
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001d800040
!	%f16 = 179a4bf9 e37a08a0 342c3656 bf384a0e
!	%f20 = 6374c23a eaf132d6 2ea54d76 169ed5a4
!	%f24 = b34a5ae5 ec5f9f35 5108830a c5a9545d
!	%f28 = b0500504 6dcbe1c4 921ab2fc 8524c630
	mov	0x100,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 000000001c000100

p3_label_43:
!	Mem[000000001d80002c] = 934b097b, %l1 = 0000000000000003
	ldsw	[%i3+0x02c],%l1		! %l1 = ffffffff934b097b
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x0c0,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 000000001d0000c0
!	Mem[000000001c800118] = eb8e20ea809a9394, %l6 = 0000000034cb72f2
	ldx	[%i1+0x118],%l6		! %l6 = eb8e20ea809a9394
!	Mem[000000001d000180] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000190] = 00000000 0000f03f b2162a2e f2814628
!	Mem[000000001d0001a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d0001b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x180,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f0	! Block Load from 000000001d000180
!	Mem[000000001e0000a8] = 708745c6609bfd3e, %l2 = 00000000d375d3b5
	ldx	[%i4+0x0a8],%l2		! %l2 = 708745c6609bfd3e

p3_label_44:
!	Mem[0000000070800018] = 52cf89153270ad19, %l3 = 00000000d6ac30a4
	ldx	[%o1+0x018],%l3		! %l3 = 52cf89153270ad19
!	Mem[000000001c000170] = fbe9966cf3106ea7, %l7 = 00000000fee06d1a
	ldx	[%i0+0x170],%l7		! %l7 = fbe9966cf3106ea7
!	%f16 = 179a4bf9 e37a08a0 342c3656 bf384a0e
!	%f20 = 6374c23a eaf132d6 2ea54d76 169ed5a4
!	%f24 = b34a5ae5 ec5f9f35 5108830a c5a9545d
!	%f28 = b0500504 6dcbe1c4 921ab2fc 8524c630
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 000000001d0001c0
!	Mem[000000001c000040] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000050] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c000060] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c000070] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x040,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 000000001c000040
!	Mem[000000001d800018] = 284681f22e2a16b2, %l3 = 52cf89153270ad19
	ldx	[%i3+0x018],%l3		! %l3 = 284681f22e2a16b2

p3_label_45:
	membar	#Sync			! Added by membar checker (166)
!	Mem[000000001d0000c0] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d0000d0] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d0000e0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d0000f0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d0000c0
	bcc,a	p3_b16			! Branch Taken, %ccr = 02, CWP = 0
!	Mem[000000001c800008] = 8ffb0fa0, %l4 = 046939df3a396f00
	ldswa	[%i1+%o6]0x80,%l4	! %l4 = ffffffff8ffb0fa0
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x010,%g2
p3_b16:
!	Mem[000000001c000050] = 593a34d7, %l6 = eb8e20ea809a9394
	ldsh	[%i0+0x050],%l6		! %l6 = 000000000000593a
	ble	p3_b17			! Branch Taken, %ccr = 02, CWP = 0

p3_label_46:
!	Mem[0000000072000064] = eff13f4c, %l6 = 000000000000593a
	ldsh	[%o4+0x064],%g2		! %g2 = ffffffffffffeff1
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p3_branch_failed
	mov	0x011,%g2
p3_b17:
!	Mem[0000000070800018] = 52cf8915 3270ad19, %l6 = 0000593a, %l7 = f3106ea7
	ldda	[%o1+0x018]%asi,%l6	! %l6 = 0000000052cf8915 000000003270ad19
!	Mem[000000001c000000] = 2997c25c, %l3 = 284681f22e2a16b2
	lduba	[%i0+%g0]0x80,%l3	! %l3 = 0000000000000029
!	Mem[000000007080001c] = 3270ad19, %l3 = 0000000000000029
	lduba	[%o1+0x01d]%asi,%l3	! %l3 = 0000000000000070
!	Mem[000000001c8001c4] = c7e8c9e7, %l2 = 708745c6609bfd3e
	lduh	[%i1+0x1c6],%l2		! %l2 = 000000000000c9e7

p3_label_47:
!	%f20 = 6374c23a eaf132d6, %f20 = 6374c23a eaf132d6, %f16 = 179a4bf9 e37a08a0
	fdivd	%f20,%f20,%f16		! %f16 = 3ff00000 00000000
!	Mem[0000000071800058] = 79c52bb5, %l5 = 000000001e4c4e47
	ldswa	[%o3+0x058]%asi,%l5	! %l5 = 0000000079c52bb5
!	Jump to jmpl_0, CWP = 0
	membar	#Sync			! Added by membar checker (167)
	set	p3_jmpl_0_he,%g1
	jmpl	%g1,%g6
!	%f22 = 2ea54d76 169ed5a4, %f22 = 2ea54d76 169ed5a4, %f6  = c330140e 643a10ae
	fsubd	%f22,%f22,%f6 		! %f6  = 00000000 00000000
!	Registers modified during the branch to p3_jmpl_0
!	%l0  = 000000002de9875e
!	%l1  = 000000000000006a
!	%l5  = 000000000000603a
!	%l6  = 000000006a030220
!	%l7  = 00000000a1d31b99
!	Mem[0000000070000018] = 6a030220a1d31b99, %l3 = 0000000000000070
	ldxa	[%o0+0x018]%asi,%l3	! %l3 = 6a030220a1d31b99

p3_label_48:
!	Mem[000000001c000008] = 7bb1f8f4, %l4 = ffffffff8ffb0fa0
	lduwa	[%i0+%o6]0x80,%l4	! %l4 = 000000007bb1f8f4
!	Mem[000000001d800008] = 8ffb0fa0, %l1 = 000000000000006a
	ldsha	[%i3+%o6]0x80,%l1	! %l1 = ffffffffffff8ffb
!	Mem[000000001d800080] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800090] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001d8000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 000000001d800080
!	Mem[000000007100005c] = 6a030220, %l1 = ffffffffffff8ffb
	ldsba	[%o2+0x05e]%asi,%l1	! %l1 = 0000000000000002
!	%f0  = 5e87e92d edcc64e0 936a7731 3d67513e
!	%f4  = 232392e8 0578462f 00000000 00000000
!	%f8  = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f12 = bbfa5390 86f2b0ea 832a55b7 d3a9c668
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 000000001d800000

p3_label_49:
!	Mem[000000007200007c] = c4b998ec, %l4 = 000000007bb1f8f4
	lduha	[%o4+0x07c]%asi,%g2	! %g2 = 000000000000c4b9
!	Mem[000000001c000008] = 7bb1f8f4, %l5 = 000000000000603a
	lduha	[%i0+%o6]0x80,%l5	! %l5 = 0000000000007bb1
!	%f0  = 5e87e92d edcc64e0 936a7731 3d67513e
!	%f4  = 232392e8 0578462f 00000000 00000000
!	%f8  = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f12 = bbfa5390 86f2b0ea 832a55b7 d3a9c668
	mov	0x100,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d800100
!	Mem[0000000071800058] = 79c52bb5523e4c31, %l1 = 0000000000000002
	ldx	[%o3+0x058],%l1		! %l1 = 79c52bb5523e4c31
!	Mem[000000007180005c] = 523e4c31, %l4 = 000000007bb1f8f4
	lduba	[%o3+0x05f]%asi,%l4	! %l4 = 0000000000000031

p3_label_50:
!	%l4 = 0000000000000031, %l4 = 0000000000000031, %l4 = 0000000000000031
	andcc	%l4,%l4,%l4		! %l4 = 0000000000000031, %ccr = 00
	membar	#Sync			! Added by membar checker (168)
!	Mem[000000001d80003c] = d3a9c668, %l6 = 000000006a030220
	lduha	[%i3+0x03e]%asi,%l6	! %l6 = 000000000000c668
!	Mem[000000001d000008] = 4c9a5fb5, %l2 = 000000000000c9e7
	swapa	[%i2+%o6]0x80,%l2	! %l2 = 000000004c9a5fb5
!	Mem[000000001d0000dc] = 0e1430c3, %l3 = 6a030220a1d31b99
	ldsha	[%i2+0x0dc]%asi,%l3	! %l3 = 0000000000000e14
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i2]ASI_BLK_PL	! Block Store to 000000001d000000

p3_label_51:
!	Mem[000000001c000000] = 2997c25c, %l2 = 000000004c9a5fb5
	ldsba	[%i0+%g0]0x80,%l2	! %l2 = 0000000000000029
!	%f0  = 5e87e92d edcc64e0 936a7731 3d67513e
!	%f4  = 232392e8 0578462f 00000000 00000000
!	%f8  = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f12 = bbfa5390 86f2b0ea 832a55b7 d3a9c668
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[000000001c80017c] = 4a0f6ea2, %l5 = 0000000000007bb1
	ldswa	[%i1+0x17c]%asi,%l5	! %l5 = 000000004a0f6ea2
!	Mem[000000007000005c] = 73e79db9, %l4 = 0000000000000031
	ldsha	[%o0+0x05c]%asi,%l4	! %l4 = 00000000000073e7
!	Mem[0000000070000018] = 6a030220a1d31b99, %l5 = 000000004a0f6ea2
	ldx	[%o0+0x018],%l5		! %l5 = 6a030220a1d31b99

p3_label_52:
!	%f0  = 5e87e92d edcc64e0 936a7731 3d67513e
!	%f4  = 232392e8 0578462f 00000000 00000000
!	%f8  = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f12 = bbfa5390 86f2b0ea 832a55b7 d3a9c668
	mov	0x040,%g6
	stda	%f0,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[000000001c8001fc] = 9dec4bfb, %l1 = 79c52bb5523e4c31
	ldsha	[%i1+0x1fe]%asi,%l1	! %l1 = 0000000000004bfb
	membar	#Sync			! Added by membar checker (169)
!	Mem[0000000072000000] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[0000000072000010] = 2f467805 e8922323 00000000 00000000
!	Mem[0000000072000020] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[0000000072000030] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	%l6 = 000000000000c668, %l0 = 000000002de9875e, %l5 = 6a030220a1d31b99
	xnorcc	%l6,%l0,%l5		! %l5 = ffffffffd216bec9, %ccr = 88
	be	p3_not_taken_0		! Branch Not Taken, %ccr = 88

p3_label_53:
!	Mem[000000001d8000d0] = cd42a490c1cff966, %l1 = 0000000000004bfb
	ldx	[%i3+0x0d0],%l1		! %l1 = cd42a490c1cff966
p3_b18:
!	Mem[000000001d000008] = 4ba6e017, %l1 = cd42a490c1cff966
	lduha	[%i2+%o6]0x80,%l1	! %l1 = 0000000000004ba6
!	Mem[000000007200000c] = 31776a93, %l2 = 0000000000000029
	lduh	[%o4+0x00c],%g2		! %g2 = 0000000000003177
!	Mem[000000001c800140] = 4ee3a42e 4905201a 907b6bdb d034c6d0
!	Mem[000000001c800150] = f92e1762 080cbd4f 3dae15b1 4fe8bd31
!	Mem[000000001c800160] = 4c6c0ae7 e87f32cd 7f7d0891 68796eb2
!	Mem[000000001c800170] = 525613d4 93ab60ac 7b306f27 4a0f6ea2
	mov	0x140,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c800140
!	%l4 = 00000000000073e7, immed = fffffa7f, %l1 = 0000000000004ba6
	orn	%l4,-0x581,%l1		! %l1 = 00000000000077e7

p3_label_54:
!	Mem[000000001d800008] = 936a7731, %l4 = 00000000000073e7
	lduha	[%i3+%o6]0x80,%l4	! %l4 = 000000000000936a
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000001c800140] = 4ee3a42e 4905201a 907b6bdb d034c6d0
!	Mem[000000001c800150] = f92e1762 080cbd4f 3dae15b1 4fe8bd31
!	Mem[000000001c800160] = 4c6c0ae7 e87f32cd 7f7d0891 68796eb2
!	Mem[000000001c800170] = 525613d4 93ab60ac 7b306f27 4a0f6ea2
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c800140
!	%l2 = 0000000000000029, Mem[0000000071000058] = 6a0302206a030220
	stxa	%l2,[%o2+0x058]%asi	! Mem[0000000071000058] = 0000000000000029
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 000000001c800040

p3_label_55:
	membar	#Sync
	fbg,pn	%fcc3,p3_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[000000001c000008] = 7bb1f8f4, %l5 = ffffffffd216bec9
	lduha	[%i0+%o6]0x80,%l5	! %l5 = 0000000000007bb1
p3_b19:
!	Mem[000000007180005c] = 523e4c31, %l5 = 0000000000007bb1
	lduba	[%o3+0x05d]%asi,%l5	! %l5 = 000000000000003e
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f26 = 1f1e56b9, %f26 = 1f1e56b9, %f8  = cd327fe8
	fdivs	%f26,%f26,%f8 		! %f8  = 3f800000

p3_label_56:
!	Mem[000000001f0001a8] = ac0ca485, %l3 = 0000000000000e14
	ldsb	[%i6+0x1a8],%l3		! %l3 = ffffffffffffffac
!	%f8  = 3f800000, %f1  = 2ea4e34e, %f22 = 284681f2
	fmuls	%f8 ,%f1 ,%f22		! %f22 = 2ea4e34e
!	%l5 = 000000000000003e, %l0 = 000000002de9875e, %l0 = 000000002de9875e
	tsubcc	%l5,%l0,%l0		! %l0 = ffffffffd21678e0, %ccr = 9b
!	Mem[0000000070800058] = f92f1bc5, %l7 = 00000000a1d31b99
	ldsw	[%o1+0x058],%l7		! %l7 = fffffffff92f1bc5
!	Mem[000000001d0001e0] = 359f5fec e55a4ab3
	flush	%i2+0x1e0

p3_label_57:
!	%f1  = 2ea4e34e, %f23 = 2e2a16b2, %f13 = d4135652
	fsubs	%f1 ,%f23,%f13		! %f13 = 2e1fafea
!	%f22 = 2ea4e34e 2e2a16b2, Mem[0000000071800018] = d0183f9e 08e6b927
	std	%f22,[%o3+0x018]	! Mem[0000000071800018] = 2ea4e34e 2e2a16b2
	membar	#Sync			! Added by membar checker (170)
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000071000018] = 9460d876fa88dc14, %l4 = 000000000000936a, %l5 = 000000000000003e
	add	%o2,0x18,%g1
	casxa	[%g1]0x80,%l4,%l5	! %l5 = 9460d876fa88dc14
!	Mem[000000007180001c] = 2e2a16b2, %l0 = ffffffffd21678e0
	ldswa	[%o3+0x01c]%asi,%l0	! %l0 = 000000002e2a16b2

p3_label_58:
	fblg	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000001c000008] = 7bb1f8f4, %l4 = 000000000000936a
	lduba	[%i0+%o6]0x80,%l4	! %l4 = 000000000000007b
p3_b20:
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x1c0,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 000000001c0001c0
!	Mem[0000000070800018] = 52cf8915 3270ad19, %l2 = 00000029, %l3 = ffffffac
	ldda	[%o1+0x018]%asi,%l2	! %l2 = 0000000052cf8915 000000003270ad19
!	%l4 = 0000007b, %l5 = fa88dc14, Mem[0000000072000060] = 1b5d8c91 05b69986
	std	%l4,[%o4+0x060]	! Mem[0000000072000060] = 0000007b fa88dc14

p3_label_59:
!	%f0  = 1a200549 2ea4e34e d0c634d0 db6b7b90
!	%f4  = 4fbd0c08 62172ef9 31bde84f b115ae3d
!	%f8  = 3f800000 e70a6c4c b26e7968 91087d7f
!	%f12 = ac60ab93 2e1fafea a26e0f4a 276f307b
	mov	0x180,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c800180
!	%l1 = 00000000000077e7, immed = 000004ff, %l5 = 9460d876fa88dc14
	andn	%l1,0x4ff,%l5		! %l5 = 0000000000007300
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x100,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 000000001d000100
!	Mem[000000001c8000c0] = 771bcb80 205858e9 4c9a5fb5 dc958bd5
!	Mem[000000001c8000d0] = e649c680 8955509f e08d1644 da919a29
!	Mem[000000001c8000e0] = 2e333e7a c2c45a90 a77d4ec7 6a625f78
!	Mem[000000001c8000f0] = 6e4b9712 89fc85b4 5bcd6083 c964e0dc
	mov	0x0c0,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c8000c0
!	Mem[000000007100005c] = 00000029, %l6 = 000000000000c668
	ldsw	[%o2+0x05c],%l6		! %l6 = 0000000000000029

p3_label_60:
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x1c0,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 000000001d8001c0
!	Mem[000000001c000180] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000190] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c0001a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c0001b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x180,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 000000001c000180
!	Mem[000000001c800028] = 1f1e56b9934b097b, %l5 = 0000000000007300
	ldx	[%i1+0x028],%l5		! %l5 = 1f1e56b9934b097b
!	%f30 = 83a6bf10 796ca3ae, %f30 = 83a6bf10 796ca3ae
	fcmpd	%fcc3,%f30,%f30		! %fcc3 = 0
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i2]ASI_BLK_P	! Block Store to 000000001d000000

p3_label_61:
	membar	#Sync			! Added by membar checker (171)
!	Mem[0000000072000040] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[0000000072000050] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[0000000072000060] = 0000007b fa88dc14 7b094b93 b9561e1f
!	Mem[0000000072000070] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
	fbn,pt	%fcc2,p3_branch_failed	! Branch Not Taken, %fcc2 = 0
!	Mem[000000001d8001c0] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
	prefetch [%i3+0x1c0],0
p3_b21:
	membar	#Sync			! Added by membar checker (172)
	set	p3_b22,%o7
	fbe,a,pn %fcc3,p3_near_1_le	! Branch Taken, %fcc3 = 0

p3_label_62:
!	%l3 = 000000003270ad19, %l1 = 00000000000077e7, %l0 = 000000002e2a16b2
	andn	%l3,%l1,%l0		! %l0 = 0000000032708818
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x016,%g2
p3_b22:
!	Registers modified during the branch to p3_near_1
!	%l0  = 0000000000000029
!	%l7  = 1f1e56b9934b0bfb
!	Mem[000000001d000000] = 34cb72f2, %l6 = 0000000000000029
	ldsha	[%i2+%g0]0x80,%l6	! %l6 = 00000000000034cb
!	Mem[000000001c000008] = 7bb1f8f4, %l4 = 000000000000007b
	lduha	[%i0+%o6]0x80,%l4	! %l4 = 0000000000007bb1
!	Mem[000000001d000180] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000190] = 00000000 0000f03f b2162a2e f2814628
!	Mem[000000001d0001a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d0001b0] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i2+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001d000180
!	Mem[0000000070000018] = 6a030220 a1d31b99, %l6 = 000034cb, %l7 = 934b0bfb
	ldda	[%o0+0x018]%asi,%l6	! %l6 = 000000006a030220 00000000a1d31b99

p3_label_63:
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x140,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c800140
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 3ff00000 00000000 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x180,%g4
	stda	%f16,[%i5+%g4]ASI_BLK_PL	! Block Store to 000000001e800180
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 3ff00000 00000000 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c800180
!	Mem[000000001c800048] = 4ba6e017 a00ffb8f, %l6 = 6a030220, %l7 = a1d31b99
	ldd	[%i1+0x048],%l6		! %l6 = 000000004ba6e017 00000000a00ffb8f
!	Mem[000000001f00010c] = d4452d7c, %l4 = 0000000000007bb1
	ldsha	[%i6+0x10c]%asi,%l4	! %l4 = ffffffffffffd445

p3_label_64:
!	%f0  = 34cb72f2, %f0  = 34cb72f2 fee06d1a
	fitod	%f0 ,%f0 		! %f0  = 41ca65b9 79000000
!	%f0  = 41ca65b9 79000000, %f0  = 41ca65b9 79000000
	fcmpd	%fcc1,%f0 ,%f0 		! %fcc1 = 0
!	Mem[000000001c800008] = 8ffb0fa0 17e0a64b, %l6 = 4ba6e017, %l7 = a00ffb8f
	ldda	[%i1+%o6]0x80,%l6	! %l6 = 000000008ffb0fa0 0000000017e0a64b
!	Mem[000000001c000140] = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	Mem[000000001c000150] = 86c97e82 33248e7e 4865594a 1ff03e71
!	Mem[000000001c000160] = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	Mem[000000001c000170] = fbe9966c f3106ea7 3fd26283 316033d2
	mov	0x140,%g5
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c000140
!	%f17 = fee06d1a, %f22 = 284681f2
	fcmps	%fcc2,%f17,%f22		! %fcc2 = 1

p3_label_65:
!	Mem[000000001e800000] = 097f71f4, %l4 = ffffffffffffd445
	ldsha	[%i5+%g0]0x80,%l4	! %l4 = 000000000000097f
!	%f0  = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	%f4  = 86c97e82 33248e7e 4865594a 1ff03e71
!	%f8  = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	%f12 = fbe9966c f3106ea7 3fd26283 316033d2
	mov	0x1c0,%g4
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d8001c0
!	%f20 = 3ff00000 00000000, %f30 = 83a6bf10 796ca3ae
	fcmpd	%fcc1,%f20,%f30		! %fcc1 = 2
!	%l1 = 00000000000077e7, Mem[000000001d000008] = 8ffb0fa017e0a64b
	stxa	%l1,[%i2+%o6]0x80	! Mem[000000001d000008] = 00000000000077e7
!	Mem[000000001d00019c] = f2814628, %l1 = 00000000000077e7
	ldsb	[%i2+0x19d],%l1		! %l1 = ffffffffffffff81

p3_label_66:
!	Mem[0000000071800058] = 79c52bb5523e4c31, %l5 = 1f1e56b9934b097b
	ldx	[%o3+0x058],%l5		! %l5 = 79c52bb5523e4c31
!	%f21 = 00000000, %f19 = 17e0a64b, %f26 = 1f1e56b9
	fmuls	%f21,%f19,%f26		! %f26 = 00000000
	membar	#Sync			! Added by membar checker (173)
!	%f0  = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	%f4  = 86c97e82 33248e7e 4865594a 1ff03e71
!	%f8  = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	%f12 = fbe9966c f3106ea7 3fd26283 316033d2
	stda	%f0,[%i1+%g5]ASI_BLK_PL	! Block Store to 000000001c800140
!	Mem[000000001d8001d4] = 827ec986, %l4 = 000000000000097f
	ldsw	[%i3+0x1d4],%l4		! %l4 = ffffffff827ec986
!	Mem[000000001d000000] = 34cb72f2, %l6 = 000000008ffb0fa0
	lduha	[%i2+0x002]%asi,%l6	! %l6 = 00000000000072f2

p3_label_67:
!	%l5 = 79c52bb5523e4c31, %l6 = 00000000000072f2, %y  = 046939df
	sdivcc	%l5,%l6,%l3		! %l3 = 000000007fffffff, %ccr = 02
	mov	%l0,%y			! %y = 00000029
!	Mem[000000001c000008] = 7bb1f8f4, %l4 = ffffffff827ec986
	ldsha	[%i0+%o6]0x80,%l4	! %l4 = 0000000000007bb1
!	%f25 = 918c5d1b, %f24 = 8699b605
	fmovs	%f25,%f24		! %f24 = 918c5d1b
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 3ff00000 00000000 284681f2 2e2a16b2
!	%f24 = 918c5d1b 918c5d1b 00000000 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x0c0,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 000000001c8000c0
	membar	#Sync
	bgu	p3_b23			! Branch Taken, %ccr = 02, CWP = 0

p3_label_68:
!	Mem[000000001c000008] = 7bb1f8f4, %l5 = 79c52bb5523e4c31
	ldsba	[%i0+%o6]0x80,%l5	! %l5 = 000000000000007b
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x017,%g2
p3_b23:
!	%f0  = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	%f4  = 86c97e82 33248e7e 4865594a 1ff03e71
!	%f8  = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	%f12 = fbe9966c f3106ea7 3fd26283 316033d2
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 000000001c800140
!	Mem[0000000070800018] = 52cf8915, %l6 = 00000000000072f2
	ldswa	[%o1+0x018]%asi,%l6	! %l6 = 0000000052cf8915
!	Mem[0000000072000048] = e017a00f, %l5 = 000000000000007b
	ldsba	[%o4+0x04a]%asi,%g2	! %g2 = ffffffffffffffe0
!	Mem[000000001c8000ac] = 997df6d7, %l5 = 000000000000007b
	ldswa	[%i1+0x0ac]%asi,%l5	! %l5 = ffffffff997df6d7

p3_label_69:
!	Mem[000000001d000180] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000190] = 00000000 0000f03f b2162a2e f2814628
!	Mem[000000001d0001a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d0001b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x180,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d000180
!	%l1 = ffffffffffffff81, %l4 = 0000000000007bb1, %l4 = 0000000000007bb1
	orncc	%l1,%l4,%l4		! %l4 = ffffffffffffffcf, %ccr = 88
!	Mem[000000007000005c] = 73e79db9, %l0 = 0000000000000029
	lduba	[%o0+0x05c]%asi,%l0	! %l0 = 0000000000000073
!	Mem[0000000070000018] = 6a030220a1d31b99, %l0 = 0000000000000073
	ldx	[%o0+0x018],%l0		! %l0 = 6a030220a1d31b99
!	Mem[000000001e0001a8] = c6a92981, %l1 = ffffffffffffff81
	ldsb	[%i4+0x1a8],%l1		! %l1 = ffffffffffffffc6

p3_label_70:
!	Mem[0000000070800058] = f92f1bc5b0d9076b, %l4 = ffffffffffffffcf
	ldx	[%o1+0x058],%l4		! %l4 = f92f1bc5b0d9076b
!	%l6 = 0000000052cf8915, immed = fffff6e9, %l1 = ffffffffffffffc6
	add	%l6,-0x917,%l1		! %l1 = 0000000052cf7ffe
!	Mem[000000001d000040] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d000050] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d000060] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d000070] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x040,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d000040
!	Mem[000000001d0001c0] = a0087ae3f94b9a17, %l4 = f92f1bc5b0d9076b
	ldx	[%i2+0x1c0],%l4		! %l4 = a0087ae3f94b9a17
!	Mem[0000000071000058] = 00000000, %l7 = 0000000017e0a64b
	lduh	[%o2+0x058],%l7		! %l7 = 0000000000000000

p3_label_71:
!	Mem[000000001c0000e8] = d3d55b70, %l7 = 0000000000000000
	lduh	[%i0+0x0ea],%l7		! %l7 = 0000000000005b70
!	Mem[000000001c800008] = 8ffb0fa017e0a64b, %l7 = 0000000000005b70
	ldxa	[%i1+%o6]0x80,%l7	! %l7 = 8ffb0fa017e0a64b
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 3ff00000 00000000 284681f2 2e2a16b2
!	%f24 = 918c5d1b 918c5d1b 00000000 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x100,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 000000001c800100
!	Mem[000000001c800000] = 34cb72f2, %l2 = 0000000052cf8915
	swapa	[%i1+%g0]0x80,%l2	! %l2 = 0000000034cb72f2
!	Mem[000000001c000000] = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	Mem[000000001c000010] = b9d037f4 199d4350 89105059 9fba8e01
!	Mem[000000001c000020] = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	Mem[000000001c000030] = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	ldda	[%i0]ASI_BLK_PL,%f0	! Block Load from 000000001c000000

p3_label_72:
!	Mem[0000000072000048] = e017a00f, %l0 = 6a030220a1d31b99
	ldsba	[%o4+0x04a]%asi,%g2	! %g2 = ffffffffffffffe0
!	Mem[0000000072000050] = d24e37b8d7343a59, %l2 = 0000000034cb72f2
	ldx	[%o4+0x050],%g2		! %g2 = d24e37b8d7343a59
!	Mem[0000000071000018] = 9460d876, %l4 = a0087ae3f94b9a17
	ldsha	[%o2+0x01a]%asi,%l4	! %l4 = ffffffffffffd876
!	Mem[000000001d800040] = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	Mem[000000001d800050] = d632f1ea 3ac27463 a4d59e16 764da52e
!	Mem[000000001d800060] = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	Mem[000000001d800070] = c4e1cb6d 040550b0 30c62485 fcb21a92
	mov	0x040,%g6
	ldda	[%i3+%g6]ASI_BLK_P,%f16	! Block Load from 000000001d800040
!	%l3 = 000000007fffffff, %l4 = ffffffffffffd876, %l3 = 000000007fffffff
	andncc	%l3,%l4,%l3		! %l3 = 0000000000002789, %ccr = 00

p3_label_73:
	bcc,a	p3_b24			! Branch Taken, %ccr = 00, CWP = 0
!	Mem[0000000071800018] = 2ea4e34e2e2a16b2, %l2 = 0000000034cb72f2
	ldx	[%o3+0x018],%l2		! %l2 = 2ea4e34e2e2a16b2
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p3_branch_failed
	mov	0x018,%g2
p3_b24:
!	Mem[000000007100005c] = 00000029, %l6 = 0000000052cf8915
	ldsh	[%o2+0x05c],%l6		! %l6 = 0000000000000000
!	Mem[000000001d800000] = 5e87e92d, %l0 = 6a030220a1d31b99
	lduba	[%i3+%g0]0x80,%l0	! %l0 = 000000000000005e
!	%f16 = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	%f20 = d632f1ea 3ac27463 a4d59e16 764da52e
!	%f24 = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	%f28 = c4e1cb6d 040550b0 30c62485 fcb21a92
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 000000001c800040

p3_label_74:
!	Mem[000000007180005c] = 523e4c31, %l5 = ffffffff997df6d7
	lduwa	[%o3+0x05c]%asi,%l5	! %l5 = 00000000523e4c31
!	Mem[000000001c800008] = 8ffb0fa0 17e0a64b, %l2 = 2e2a16b2, %l3 = 00002789
	ldda	[%i1+%o6]0x80,%l2	! %l2 = 000000008ffb0fa0 0000000017e0a64b
!	Mem[000000001c0000a0] = 720eb292, %l3 = 0000000017e0a64b
	lduha	[%i0+0x0a2]%asi,%l3	! %l3 = 000000000000b292
!	Mem[000000001c000008] = 7bb1f8f4, %l1 = 0000000052cf7ffe
	lduha	[%i0+%o6]0x80,%l1	! %l1 = 0000000000007bb1
!	Mem[000000007000001c] = a1d31b99, %l2 = 000000008ffb0fa0
	ldsw	[%o0+0x01c],%l2		! %l2 = ffffffffa1d31b99

p3_label_75:
!	%f16 = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	%f20 = d632f1ea 3ac27463 a4d59e16 764da52e
!	%f24 = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	%f28 = c4e1cb6d 040550b0 30c62485 fcb21a92
	mov	0x0c0,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 000000001c0000c0
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4+%g6]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[000000001d800020] = 9cae641692b20e72, %l3 = 000000000000b292
	ldx	[%i3+0x020],%l3		! %l3 = 9cae641692b20e72
!	Mem[000000001d800008] = 936a7731 3d67513e, %l6 = 00000000, %l7 = 17e0a64b
	ldda	[%i3+%o6]0x80,%l6	! %l6 = 00000000936a7731 000000003d67513e
!	Mem[000000001c800008] = 8ffb0fa0, %l3 = 9cae641692b20e72
	lduha	[%i1+%o6]0x80,%l3	! %l3 = 0000000000008ffb

p3_label_76:
!	%l0 = 000000000000005e, %l5 = 00000000523e4c31, %y  = 00000029
	sdiv	%l0,%l5,%l0		! %l0 = 000000000000007f
	mov	%l0,%y			! %y = 0000007f
!	%l3 = 0000000000008ffb, %l6 = 00000000936a7731, %l2 = ffffffffa1d31b99
	orncc	%l3,%l6,%l2		! %l2 = ffffffff6c958fff, %ccr = 80
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 000000001d800000
!	Mem[000000001c000040] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000050] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c000060] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c000070] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i0+%g6]ASI_BLK_P,%f0	! Block Load from 000000001c000040
!	%l5 = 00000000523e4c31, Mem[0000000071000019] = 9460d876
	stb	%l5,[%o2+0x019]		! Mem[0000000071000018] = 9431d876

p3_label_77:
!	%l3 = 0000000000008ffb, immed = 00000616, %y  = 0000007f
	udivx	%l3,0x616,%l5		! %l5 = 0000000000000017
!	%f16 = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	%f20 = d632f1ea 3ac27463 a4d59e16 764da52e
!	%f24 = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	%f28 = c4e1cb6d 040550b0 30c62485 fcb21a92
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 000000001c000140
!	Mem[000000007100005c] = 00000029, %l6 = 00000000936a7731
	lduwa	[%o2+0x05c]%asi,%l6	! %l6 = 0000000000000029
!	Mem[000000001d000188] = 4ba6e017, %l1 = 0000000000007bb1
	lduh	[%i2+0x188],%l1		! %l1 = 0000000000004ba6
!	Mem[000000001d0000c0] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d0000d0] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d0000e0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d0000f0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 000000001d0000c0

p3_label_78:
!	Mem[000000001c800094] = 6fee7c5a, %l5 = 0000000000000017
	lduha	[%i1+0x094]%asi,%l5	! %l5 = 0000000000006fee
	membar	#Sync			! Added by membar checker (174)
!	Mem[0000000072000040] = ef6aa544741e7ee0, %l7 = 000000003d67513e
	ldx	[%o4+0x040],%g2		! %g2 = ef6aa544741e7ee0
!	Mem[0000000072000020] = 4c3ff1efec32b332, %l7 = 000000003d67513e
	ldx	[%o4+0x020],%g2		! %g2 = 4c3ff1efec32b332
!	Mem[000000001d000100] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000110] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001d000120] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d000130] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x100,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 000000001d000100
!	%l6 = 0000000000000029, immed = 00000005, %l1 = 0000000000004ba6
	sll	%l6,0x005,%l1		! %l1 = 0000000000000520

p3_label_79:
!	Mem[000000001e0000c0] = 47f6ca0b 35b0fffb, %l0 = 0000007f, %l1 = 00000520
	ldda	[%i4+0x0c0]%asi,%l0	! %l0 = 0000000047f6ca0b 0000000035b0fffb
!	%f25 = 1664ae9c, %f16 = e064cced
	fcmpes	%fcc1,%f25,%f16		! %fcc1 = 2
!	%l0 = 0000000047f6ca0b, %l6 = 0000000000000029, %l0 = 0000000047f6ca0b
	and	%l0,%l6,%l0		! %l0 = 0000000000000009
!	Mem[000000001c000000] = 2997c25c e453116a, %l0 = 00000009, %l1 = 35b0fffb
	ldda	[%i0+%g0]0x80,%l0	! %l0 = 000000002997c25c 00000000e453116a
!	Mem[000000001c800000] = 52cf8915, %l3 = 0000000000008ffb
	lduha	[%i1+%g0]0x80,%l3	! %l3 = 00000000000052cf

p3_label_80:
!	%f16 = e064cced 2de9875e 3e51673d 31776a93
!	%f20 = 2f467805 e8922323 ae103a64 0e1430c3
!	%f24 = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f28 = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x180,%g5
	stda	%f16,[%i1+%g5]ASI_BLK_P	! Block Store to 000000001c800180
!	%f16 = e064cced 2de9875e 3e51673d 31776a93
!	%f20 = 2f467805 e8922323 ae103a64 0e1430c3
!	%f24 = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f28 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 000000001c800100
!	%f0  = 1a6de0fe f272cb34, %f0  = 1a6de0fe f272cb34, %f0  = 1a6de0fe f272cb34
	fdivd	%f0 ,%f0 ,%f0 		! %f0  = 3ff00000 00000000
!	Mem[000000001c8001c0] = cffd5522 c7e8c9e7 027af906 5b33d55b
!	Mem[000000001c8001d0] = e1836997 bc71149a cc550cc0 27c3d444
!	Mem[000000001c8001e0] = ac4e13c6 e88950b1 9ebde432 6feb3480
!	Mem[000000001c8001f0] = 603a1b99 5662b939 839268e8 9dec4bfb
	mov	0x1c0,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f16	! Block Load from 000000001c8001c0
!	Mem[000000001c800020] = 8699b605918c5d1b, %l3 = 00000000000052cf
	ldx	[%i1+0x020],%l3		! %l3 = 8699b605918c5d1b

p3_label_81:
!	Mem[000000001d000100] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000110] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001d000120] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d000130] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 000000001d000100
!	Mem[000000007080001c] = 3270ad19, %l7 = 000000003d67513e
	ldsha	[%o1+0x01e]%asi,%l7	! %l7 = ffffffffffffad19
!	%f16 = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 000000001d8001c0
!	Mem[000000001d800008] = e1cdada7f4f8b17b, %l2 = ffffffff6c958fff
	ldxa	[%i3+%o6]0x80,%l2	! %l2 = e1cdada7f4f8b17b
!	Mem[000000001c000008] = 7bb1f8f4 a7adcde1, %l4 = ffffd876, %l5 = 00006fee
	ldda	[%i0+%o6]0x80,%l4	! %l4 = 000000007bb1f8f4 00000000a7adcde1

p3_label_82:
!	%f0  = 3ff00000 00000000 4ba6e017 a00ffb8f
!	%f4  = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f8  = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f12 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 000000001c8001c0
	membar	#Sync
	fblg,pn	%fcc3,p3_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[000000007100001c] = fa88dc14, %f21 = d7343a59
	ld	[%o2+0x01c],%f21	! %f21 = fa88dc14
p3_b25:
!	%f23 = 4ee3a42e, %f23 = 4ee3a42e
	fnegs	%f23,%f23		! %f23 = cee3a42e
!	Mem[000000001c800180] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001c800190] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001c8001a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001c8001b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x180,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001c800180

p3_label_83:
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	mov	0x040,%g5
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%l6 = 0000000000000029, immed = ffffffd5, %y  = 0000007f
	smul	%l6,-0x02b,%l1		! %l1 = fffffffffffff91d
!	%l6 = 0000000000000029, immed = 00000df9, %y  = ffffffff
	umulcc	%l6,0xdf9,%l0		! %l0 = 0000000000023ce1, %ccr = 00
!	%l0 = 0000000000023ce1, %l5 = 00000000a7adcde1, %l3 = 8699b605918c5d1b
	xnorcc	%l0,%l5,%l3		! %l3 = ffffffff58500eff, %ccr = 80
!	Mem[000000001e800040] = f4066eae 69adae6c d0a5e612 eec4ebdf
!	Mem[000000001e800050] = cb18f264 ce940932 e5de1eb4 3484b561
!	Mem[000000001e800060] = 3eb2b819 086562ea 24dfb939 63889fbf
!	Mem[000000001e800070] = 30cca2ca 0ce53ba0 ade6d422 5d0061ba
	ldda	[%i5+%g5]ASI_BLK_P,%f16	! Block Load from 000000001e800040

p3_label_84:
!	Mem[000000001d0000f4] = 9053fabb, %l4 = 000000007bb1f8f4
	lduba	[%i2+0x0f6]%asi,%l4	! %l4 = 00000000000000fa
!	Mem[000000007000005c] = 73e79db9, %l4 = 00000000000000fa
	lduw	[%o0+0x05c],%l4		! %l4 = 0000000073e79db9
	membar	#Sync
!	Branch On Register, %l2 = e1cdada7f4f8b17b
	brnz,pn	%l2,p3_b26		! Branch Taken
!	Mem[000000001d000000] = 34cb72f2 fee06d1a, %l2 = f4f8b17b, %l3 = 58500eff
	ldda	[%i2+%g0]0x80,%l2	! %l2 = 0000000034cb72f2 00000000fee06d1a
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p3_branch_failed
	mov	0x01a,%g2
p3_b26:
!	Mem[000000001c000000] = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	Mem[000000001c000010] = b9d037f4 199d4350 89105059 9fba8e01
!	Mem[000000001c000020] = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	Mem[000000001c000030] = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	ldda	[%i0]ASI_BLK_PL,%f0	! Block Load from 000000001c000000

p3_label_85:
!	Mem[000000001c800008] = 8ffb0fa017e0a64b, %l3 = 00000000fee06d1a
	ldxa	[%i1+%o6]0x80,%l3	! %l3 = 8ffb0fa017e0a64b
!	Mem[000000001f000070] = c08250934f9d15dc, %l2 = 0000000034cb72f2
	ldx	[%i6+0x070],%l2		! %l2 = c08250934f9d15dc
!	Mem[000000001d800028] = d4d274c1 8ded4d6c, %l2 = 4f9d15dc, %l3 = 17e0a64b
	ldda	[%i3+0x028]%asi,%l2	! %l2 = 00000000d4d274c1 000000008ded4d6c
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	stda	%f0,[%i1]ASI_BLK_PL	! Block Store to 000000001c800000
!	%f19 = eec4ebdf, %f20 = cb18f264 ce940932
	fstod	%f19,%f20		! %f20 = c5d89d7b e0000000

p3_label_86:
!	Mem[000000007000001c] = a1d31b99, %l1 = fffffffffffff91d
	ldsba	[%o0+0x01f]%asi,%l1	! %l1 = ffffffffffffff99
!	Mem[000000007000005c] = 73e79db9, %l2 = 00000000d4d274c1
	ldswa	[%o0+0x05c]%asi,%l2	! %l2 = 0000000073e79db9
!	%l1 = ffffffffffffff99, Mem[000000001d800116] = e8922323
	stha	%l1,[%i3+0x116]%asi	! Mem[000000001d800114] = e892ff99
!	%f16 = f4066eae 69adae6c d0a5e612 eec4ebdf
!	%f20 = c5d89d7b e0000000 e5de1eb4 3484b561
!	%f24 = 3eb2b819 086562ea 24dfb939 63889fbf
!	%f28 = 30cca2ca 0ce53ba0 ade6d422 5d0061ba
	mov	0x1c0,%g6
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 000000001c8001c0
!	%l6 = 0000000000000029, Mem[000000007180001e] = 2e2a16b2
	stha	%l6,[%o3+0x01e]%asi	! Mem[000000007180001c] = 2e2a0029

p3_label_87:
	membar	#Sync			! Added by membar checker (175)
!	%f16 = f4066eae 69adae6c d0a5e612 eec4ebdf
!	%f20 = c5d89d7b e0000000 e5de1eb4 3484b561
!	%f24 = 3eb2b819 086562ea 24dfb939 63889fbf
!	%f28 = 30cca2ca 0ce53ba0 ade6d422 5d0061ba
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 000000001c8001c0
!	%f16 = f4066eae 69adae6c d0a5e612 eec4ebdf
!	%f20 = c5d89d7b e0000000 e5de1eb4 3484b561
!	%f24 = 3eb2b819 086562ea 24dfb939 63889fbf
!	%f28 = 30cca2ca 0ce53ba0 ade6d422 5d0061ba
	mov	0x140,%g6
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 000000001c000140
!	Mem[000000001d000180] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000190] = 00000000 0000f03f b2162a2e f2814628
!	Mem[000000001d0001a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d0001b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x180,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f16	! Block Load from 000000001d000180
!	Mem[000000001c000030] = 874940a3e5ddc3e0, %l3 = 000000008ded4d6c
	ldx	[%i0+0x030],%l3		! %l3 = 874940a3e5ddc3e0
!	Mem[0000000072000000] = ef6aa544741e7ee0, %l6 = 0000000000000029
	ldx	[%o4+0x000],%g2		! %g2 = ef6aa544741e7ee0

p3_label_88:
!	Mem[000000001c0000b8] = 68c6a9d3b7552a83, %l1 = ffffffffffffff99
	ldx	[%i0+0x0b8],%l1		! %l1 = 68c6a9d3b7552a83
!	%l5 = 00000000a7adcde1, %l2 = 0000000073e79db9, %l5 = 00000000a7adcde1
	addc	%l5,%l2,%l5		! %l5 = 000000011b956b9a
!	Mem[000000001d8001d8] = b2162a2e4ee3a42e, %l5 = 000000011b956b9a
	ldxa	[%i3+0x1d8]%asi,%l5	! %l5 = b2162a2e4ee3a42e
!	Mem[000000001e000008] = 1e4c4e47, %l7 = ffffffffffffad19
	lduba	[%i4+%o6]0x80,%l7	! %l7 = 000000000000001e
!	Mem[0000000072000028] = d86c72750aaeaab5, %l2 = 0000000073e79db9
	ldx	[%o4+0x028],%g2		! %g2 = d86c72750aaeaab5

p3_label_89:
!	Mem[000000007180001c] = 2e2a0029, %l0 = 0000000000023ce1
	ldsha	[%o3+0x01c]%asi,%l0	! %l0 = 0000000000002e2a
!	Mem[0000000072000014] = 2a073b4d, %l1 = 68c6a9d3b7552a83
	lduw	[%o4+0x014],%g2		! %g2 = 68c6a9d3b7552a83
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x1c0,%g4
	stda	%f0,[%i2+%g4]ASI_BLK_PL	! Block Store to 000000001d0001c0
!	%l2 = 0000000073e79db9, immed = 00000fa6, %y  = 00000000
	sdiv	%l2,0xfa6,%l7		! %l7 = 0000000000076823
	mov	%l0,%y			! %y = 00002e2a
!	Mem[000000001f000000] = f04054f6, %l0 = 0000000000002e2a
	ldsha	[%i6+%g0]0x80,%l0	! %l0 = fffffffffffff040

p3_label_90:
!	Mem[000000001d000008] = 00000000, %l5 = b2162a2e4ee3a42e
	ldsha	[%i2+%o6]0x80,%l5	! %l5 = 0000000000000000
!	Mem[000000001d800180] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d800190] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d8001a0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d8001b0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 000000001d800180
!	Mem[000000001c800098] = d257f6ba 7cf18cc7, %l0 = fffff040, %l1 = b7552a83
	ldda	[%i1+0x098]%asi,%l0	! %l0 = 00000000d257f6ba 000000007cf18cc7
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	mov	0x040,%g6
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000071800018] = 2ea4e34e, %l2 = 0000000073e79db9
	ldsba	[%o3+0x01b]%asi,%l2	! %l2 = 000000000000004e

p3_label_91:
!	Mem[0000000070000018] = 6a030220, %f8  = 3cea7be3
	ld	[%o0+0x018],%f8 	! %f8 = 6a030220
!	Mem[0000000072000000] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000010] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000020] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000030] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[000000001c000040] = 34cb72f2fee06d1a, %l0 = 00000000d257f6ba
	ldx	[%i0+0x040],%l0		! %l0 = 34cb72f2fee06d1a
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 6a030220 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x100,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 000000001d000100
!	Mem[000000001c000008] = 7bb1f8f4, %l6 = 0000000000000029
	ldsha	[%i0+%o6]0x80,%l6	! %l6 = 0000000000007bb1

p3_label_92:
!	Mem[000000001d800008] = e1cdada7 f4f8b17b, %l4 = 73e79db9, %l5 = 00000000
	ldda	[%i3+%o6]0x80,%l4	! %l4 = 00000000e1cdada7 00000000f4f8b17b
!	Mem[000000001d800080] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800090] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001d8000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f0	! Block Load from 000000001d800080
!	Mem[000000007000001c] = a1d31b99, %l6 = 0000000000007bb1
	lduwa	[%o0+0x01c]%asi,%l6	! %l6 = 00000000a1d31b99
	membar	#Sync			! Added by membar checker (176)
	set	p3_b27,%o7
	fba,a	p3_far_1_he		! Branch Taken, %fcc0 = 0
!	Mem[000000007200000c] = bbfc7943, %l1 = 000000007cf18cc7
	lduh	[%o4+0x00c],%g2		! Annulled
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p3_branch_failed
	mov	0x01b,%g2
p3_b27:
!	Registers modified during the branch to p3_far_1
!	%l1  = 0000000000000002
!	%l5  = 00000000040550b0
!	%l7  = 0000000000000029

p3_label_93:
!	%l0 = fee06d1a, %l1 = 00000002, Mem[0000000072000050] = 0e54c8c5 2a073b4d
	stda	%l0,[%o4+0x050]%asi	! Mem[0000000072000050] = fee06d1a 00000002
!	Mem[000000001d0000cc] = 31776a93, %l6 = 00000000a1d31b99
	lduw	[%i2+0x0cc],%l6		! %l6 = 0000000031776a93
!	Mem[0000000071800018] = 2ea4e34e2e2a0029, %l1 = 0000000000000002
	ldx	[%o3+0x018],%l1		! %l1 = 2ea4e34e2e2a0029
!	Mem[000000001d000000] = 34cb72f2 fee06d1a 00000000 000077e7
!	Mem[000000001d000010] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001d000020] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d000030] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i2]ASI_BLK_PL,%f0	! Block Load from 000000001d000000
!	Mem[000000007100005c] = 00000029, %l4 = 00000000e1cdada7
	lduw	[%o2+0x05c],%l4		! %l4 = 0000000000000029

p3_label_94:
!	%f29 = 86f2b0ea, %f16 = 5e87e92d
	fnegs	%f29,%f16		! %f16 = 06f2b0ea
!	Mem[0000000071800058] = 79c52bb5, %l1 = 2ea4e34e2e2a0029
	ldsw	[%o3+0x058],%l1		! %l1 = 0000000079c52bb5
!	Mem[000000001d800000] = 6a1153e4, %l1 = 0000000079c52bb5
	lduha	[%i3+%g0]0x80,%l1	! %l1 = 0000000000006a11
!	Mem[0000000070800018] = 52cf89153270ad19, %l4 = 0000000000000029
	ldx	[%o1+0x018],%l4		! %l4 = 52cf89153270ad19
!	Mem[000000001c800000] = 2997c25c, %l3 = 874940a3e5ddc3e0
	ldsba	[%i1+%g0]0x80,%l3	! %l3 = 0000000000000029

p3_label_95:
!	Mem[0000000071800018] = 2ea4e34e2e2a0029, %l4 = 52cf89153270ad19
	ldxa	[%o3+0x018]%asi,%l4	! %l4 = 2ea4e34e2e2a0029
!	Mem[000000007180001c] = 2e2a0029, %l6 = 0000000031776a93
	ldsba	[%o3+0x01f]%asi,%l6	! %l6 = 0000000000000029
!	%l4 = 2ea4e34e2e2a0029, %l4 = 2ea4e34e2e2a0029, %l6 = 0000000000000029
	xor	%l4,%l4,%l6		! %l6 = 0000000000000000
!	Mem[000000001d800100] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d800110] = 2f467805 e892ff99 00000000 00000000
!	Mem[000000001d800120] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d800130] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 000000001d800100
!	Mem[000000001d000008] = 00000000, %l7 = 0000000000000029
	ldsha	[%i2+%o6]0x80,%l7	! %l7 = 0000000000000000

p3_label_96:
!	Mem[000000001c800180] = e064cced 2de9875e
	flush	%i1+0x180
!	Mem[0000000071000058] = 0000000000000029, %l5 = 00000000040550b0
	ldx	[%o2+0x058],%l5		! %l5 = 0000000000000029
!	Mem[000000001c0000f0] = b05005046dcbe1c4, %l6 = 0000000000000000
	ldx	[%i0+0x0f0],%l6		! %l6 = b05005046dcbe1c4
	fbne,a	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000001d800010] = 50439d19, %l4 = 2ea4e34e2e2a0029
	ldub	[%i3+0x012],%l4		! Annulled
p3_b28:

p3_label_97:
!	%f23 = 643a10ae, %f23 = 643a10ae
	fcmps	%fcc0,%f23,%f23		! %fcc0 = 0
!	Mem[000000001d000008] = 00000000, %l5 = 0000000000000029
	lduba	[%i2+%o6]0x80,%l5	! %l5 = 0000000000000000
!	Mem[000000001c000114] = eaf132d6, %l0 = 34cb72f2fee06d1a
	ldub	[%i0+0x115],%l0		! %l0 = 00000000000000f1
!	Mem[000000001c000000] = 2997c25c, %l5 = 0000000000000000
	ldsba	[%i0+%g0]0x80,%l5	! %l5 = 0000000000000029
!	Mem[000000007000001c] = a1d31b99, %l2 = 000000000000004e
	ldsb	[%o0+0x01c],%l2		! %l2 = ffffffffffffffa1

p3_label_98:
!	%f27 = b5d375d3, %f29 = 86f2b0ea
	fmovs	%f27,%f29		! %f29 = b5d375d3
!	%f26 = a430acd6 b5d375d3, %f20 = 232392e8 0578462f
	fabsd	%f26,%f20		! %f20 = 2430acd6 b5d375d3
	membar	#Sync			! Added by membar checker (177)
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = fee06d1a 00000002 fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	mov	0x040,%g6
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000072000000] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000010] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000020] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000030] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	bg	p3_b29			! Branch Taken, %ccr = 80, CWP = 0

p3_label_99:
!	%l2 = ffffffffffffffa1, %l2 = ffffffffffffffa1, %l0 = 00000000000000f1
	orn	%l2,%l2,%l0		! %l0 = ffffffffffffffff
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p3_branch_failed
	mov	0x01d,%g2
p3_b29:
!	%f16 = 06f2b0ea edcc64e0 936a7731 3d67513e
!	%f20 = 2430acd6 b5d375d3 c330140e 643a10ae
!	%f24 = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f28 = bbfa5390 b5d375d3 832a55b7 d3a9c668
	mov	0x0c0,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 000000001d8000c0
!	Mem[0000000070000058] = d31b1a25, %l7 = 0000000000000000
	ldub	[%o0+0x05b],%l7		! %l7 = 0000000000000025
	membar	#Sync
!	Branch On Register, %l1 = 0000000000006a11
	brlez,pt %l1,p3_not_taken_0	! Branch Not Taken
!	Mem[000000001d000008] = 00000000 000077e7, %l6 = 6dcbe1c4, %l7 = 00000025
	ldda	[%i2+%o6]0x80,%l6	! %l6 = 0000000000000000 00000000000077e7
p3_b30:

p3_label_100:
!	Mem[000000001d000040] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d000050] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d000060] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d000070] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001d000040
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = fee06d1a 00000002 fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[000000001e000004] = 4d8ca3bd, %l1 = 0000000000006a11
	ldub	[%i4+0x007],%l1		! %l1 = 00000000000000bd
	be,a	p3_not_taken_0		! Branch Not Taken, %ccr = 80
!	Mem[000000001d000008] = 00000000, %l5 = 0000000000000029
	ldsha	[%i2+%o6]0x80,%l5	! Annulled
p3_b31:

p3_label_101:
!	Mem[0000000071000058] = 00000000, %l6 = 0000000000000000
	lduh	[%o2+0x058],%l6		! %l6 = 0000000000000000

	ba,a	p3_not_taken_0_end
p3_not_taken_0:
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba,a	p3_branch_failed
p3_not_taken_0_end:

!	Mem[000000001d000000] = 34cb72f2, %l0 = ffffffffffffffff
	lduha	[%i2+%g0]0x80,%l0	! %l0 = 00000000000034cb
!	Mem[000000001d000000] = 34cb72f2 fee06d1a, %l2 = ffffffa1, %l3 = 00000029
	ldda	[%i2+%g0]0x80,%l2	! %l2 = 0000000034cb72f2 00000000fee06d1a
!	Mem[000000001d8001d0] = d24e37b8d7343a59, %l3 = 00000000fee06d1a
	ldx	[%i3+0x1d0],%l3		! %l3 = d24e37b8d7343a59
!	Mem[000000001e800028] = c1411e7c, %l4 = 2ea4e34e2e2a0029
	lduw	[%i5+0x028],%l4		! %l4 = 00000000c1411e7c

p3_label_102:
!	Mem[000000001d800000] = 6a1153e4, %l6 = 0000000000000000
	lduha	[%i3+%g0]0x80,%l6	! %l6 = 0000000000006a11
!	Mem[000000001d800118] = 00000000 00000000, %l6 = 00006a11, %l7 = 000077e7
	ldda	[%i3+0x118]%asi,%l6	! %l6 = 0000000000000000 0000000000000000
!	Mem[000000001c000000] = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	Mem[000000001c000010] = b9d037f4 199d4350 89105059 9fba8e01
!	Mem[000000001c000020] = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	Mem[000000001c000030] = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	ldda	[%i0]ASI_BLK_P,%f0	! Block Load from 000000001c000000
!	Mem[000000001c0001c0] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c0001d0] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c0001e0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c0001f0] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c0001c0
!	Mem[000000001c0001c0] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c0001d0] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c0001e0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c0001f0] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i0+%g4]ASI_BLK_PL,%f0	! Block Load from 000000001c0001c0

p3_label_103:
!	Mem[0000000072000000] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000010] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000020] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000030] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[000000001c8001c0] = 6caead69 ae6e06f4 dfebc4ee 12e6a5d0
!	Mem[000000001c8001d0] = 000000e0 7b9dd8c5 61b58434 b41edee5
!	Mem[000000001c8001e0] = ea626508 19b8b23e bf9f8863 39b9df24
!	Mem[000000001c8001f0] = a03be50c caa2cc30 ba61005d 22d4e6ad
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c8001c0
!	Mem[000000001d800160] = 1b5d8c9105b69986, %l2 = 0000000034cb72f2
	ldx	[%i3+0x160],%l2		! %l2 = 1b5d8c9105b69986
	bleu,a	p3_not_taken_0		! Branch Not Taken, %ccr = 80
!	%f13 = f66397c8, %f1  = fee06d1a
	fabss	%f13,%f1 	! Annulled
p3_b32:

p3_label_104:
!	Mem[000000001c000000] = 2997c25c, %l5 = 0000000000000029
	ldswa	[%i0+%g0]0x80,%l5	! %l5 = 000000002997c25c
!	Mem[000000001d000000] = 34cb72f2, %l3 = d24e37b8d7343a59
	lduwa	[%i2+%g0]0x80,%l3	! %l3 = 0000000034cb72f2
!	Mem[000000001c000008] = 7bb1f8f4, %l4 = 00000000c1411e7c
	lduha	[%i0+%o6]0x80,%l4	! %l4 = 0000000000007bb1
!	Mem[0000000072000028] = d86c72750aaeaab5, %l6 = 0000000000000000
	ldx	[%o4+0x028],%g2		! %g2 = d86c72750aaeaab5
!	Mem[0000000072000078] = ec98b9c4e7c69045, %l2 = 1b5d8c9105b69986
	ldx	[%o4+0x078],%g2		! %g2 = ec98b9c4e7c69045

p3_label_105:
	membar	#Sync			! Added by membar checker (178)
!	%l3 = 0000000034cb72f2, Mem[000000007200006c] = 0aaeaab5
	sth	%l3,[%o4+0x06c]		! Mem[000000007200006c] = 72f2aab5
!	Mem[000000001c800000] = 2997c25c e453116a, %l0 = 000034cb, %l1 = 000000bd
	ldda	[%i1+%g0]0x80,%l0	! %l0 = 000000002997c25c 00000000e453116a
!	Mem[000000001c0000f0] = b0500504, %l0 = 000000002997c25c
	ldsh	[%i0+0x0f2],%l0		! %l0 = 0000000000000504
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
	membar	#Sync			! Added by membar checker (179)
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = fee06d1a 00000002 fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 72f2aab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p3_label_106:
!	%f9  = 918c5d1b, %f2  = 8ffb0fa0, %f19 = eec4ebdf
	fsubs	%f9 ,%f2 ,%f19		! %f19 = 91795842
!	Mem[0000000071800058] = 79c52bb5523e4c31, %l1 = 00000000e453116a
	ldx	[%o3+0x058],%l1		! %l1 = 79c52bb5523e4c31
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i1]ASI_BLK_P	! Block Store to 000000001c800000
!	Mem[0000000071000058] = 00000000, %l4 = 0000000000007bb1
	ldsh	[%o2+0x05a],%l4		! %l4 = 0000000000000000
!	Mem[000000001e800008] = a755a393, %l4 = 0000000000000000
	lduwa	[%i5+%o6]0x80,%l4	! %l4 = 00000000a755a393

p3_label_107:
!	Mem[0000000070800058] = f92f1bc5, %l5 = 000000002997c25c
	lduh	[%o1+0x058],%l5		! %l5 = 000000000000f92f
!	%f32 = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	%f36 = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	%f40 = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	%f44 = e37ed0ee 0a683861 ec98b9c4 e7c69045
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l5 = 000000000000f92f, immed = fffffd87, %l6 = 0000000000000000
	xnorcc	%l5,-0x279,%l6		! %l6 = 000000000000fb57, %ccr = 00
!	Mem[000000001d8001c0] = 1a6de0fef272cb34, %l1 = 79c52bb5523e4c31
	ldxa	[%i3+0x1c0]%asi,%l1	! %l1 = 1a6de0fef272cb34
!	Mem[0000000071800018] = 2ea4e34e 2e2a0029, %l0 = 00000504, %l1 = f272cb34
	ldd	[%o3+0x018],%l0		! %l0 = 000000002ea4e34e 000000002e2a0029

p3_label_108:
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i0]ASI_BLK_PL	! Block Store to 000000001c000000
	membar	#Sync			! Added by membar checker (180)
!	Mem[000000001c000000] = 1a6de0fe f272cb34, %l2 = 05b69986, %l3 = 34cb72f2
	ldda	[%i0+%g0]0x80,%l2	! %l2 = 000000001a6de0fe 00000000f272cb34
!	Mem[000000007180005c] = 523e4c31, %l4 = 00000000a755a393
	lduh	[%o3+0x05e],%l4		! %l4 = 0000000000004c31
!	Mem[0000000071000018] = 9431d876 fa88dc14, %l2 = 1a6de0fe, %l3 = f272cb34
	ldda	[%o2+0x018]%asi,%l2	! %l2 = 000000009431d876 00000000fa88dc14
!	%f8  = 8699b605, %f8  = 8699b605
	fcmps	%fcc2,%f8 ,%f8 		! %fcc2 = 0

p3_label_109:
!	Mem[000000001d00004c] = 31776a93, %l4 = 0000000000004c31
	ldsb	[%i2+0x04c],%l4		! %l4 = 0000000000000031
!	Mem[000000001c8001a0] = 720eb292, %l2 = 000000009431d876
	ldub	[%i1+0x1a3],%l2		! %l2 = 0000000000000092
!	Mem[000000001d000040] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d000050] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d000060] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d000070] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001d000040
!	Mem[000000001d0000b8] = 83a6bf10, %l2 = 0000000000000092
	ldsba	[%i2+0x0b9]%asi,%l2	! %l2 = ffffffffffffffa6
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i2+%g6]ASI_BLK_P	! Block Store to 000000001d000040

p3_label_110:
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = fee06d1a 00000002 fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 72f2aab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4+%g6]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i2]ASI_BLK_P	! Block Store to 000000001d000000
!	Mem[0000000070000058] = d31b1a2573e79db9, %l3 = 00000000fa88dc14
	ldxa	[%o0+0x058]%asi,%l3	! %l3 = d31b1a2573e79db9
	fbl,pt	%fcc1,p3_branch_failed	! Branch Not Taken, %fcc1 = 2
!	%f26 = a430acd6 b5d375d3, %f26 = a430acd6 b5d375d3, %f30 = 832a55b7 d3a9c668
	fdivd	%f26,%f26,%f30		! %f30 = 3ff00000 00000000
p3_b33:

p3_label_111:
!	Mem[0000000070000058] = d31b1a2573e79db9, %l0 = 000000002ea4e34e
	ldxa	[%o0+0x058]%asi,%l0	! %l0 = d31b1a2573e79db9
!	Mem[0000000071000018] = 9431d876, %l2 = ffffffffffffffa6
	lduwa	[%o2+0x018]%asi,%l2	! %l2 = 000000009431d876
!	Mem[000000007080001c] = 3270ad19, %l2 = 000000009431d876
	ldsba	[%o1+0x01d]%asi,%l2	! %l2 = 0000000000000070
!	%l6 = 000000000000fb57, Mem[000000001d000000] = 34cb72f2
	stha	%l6,[%i2+%g0]0x80	! Mem[000000001d000000] = fb5772f2
!	Mem[000000001d000098] = 284681f22e2a16b2, %l2 = 0000000000000070
	ldxa	[%i2+0x098]%asi,%l2	! %l2 = 284681f22e2a16b2

p3_label_112:
!	Mem[000000001c800140] = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	Mem[000000001c800150] = 86c97e82 33248e7e 4865594a 1ff03e71
!	Mem[000000001c800160] = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	Mem[000000001c800170] = fbe9966c f3106ea7 3fd26283 316033d2
	mov	0x140,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c800140
!	Mem[0000000072000000] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000010] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000020] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000030] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	bcs	p3_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[000000001c800000] = 34cb72f2, %l6 = 000000000000fb57
	lduha	[%i1+%g0]0x80,%l6	! %l6 = 00000000000034cb
p3_b34:
!	%f0  = eadeca9d b9fec9b5 24c3869f 20f1e4e2
!	%f4  = 7e8e2433 827ec986 713ef01f 4a596548
!	%f8  = 310d9818 1e7ca47f 09486ae0 a2a1f0c0
!	%f12 = a76e10f3 6c96e9fb d2336031 8362d23f
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 000000001c000140

p3_label_113:
!	Mem[000000007080001c] = 3270ad19, %l7 = 0000000000000000
	ldswa	[%o1+0x01c]%asi,%l7	! %l7 = 000000003270ad19
!	%f16 = 5e87e92d edcc64e0 936a7731 3d67513e
!	%f20 = 232392e8 0578462f c330140e 643a10ae
!	%f24 = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f28 = bbfa5390 86f2b0ea 3ff00000 00000000
	mov	0x180,%g5
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 000000001d800180
!	Mem[0000000071000058] = 00000000 00000029, %l4 = 00000031, %l5 = 0000f92f
	ldd	[%o2+0x058],%l4		! %l4 = 0000000000000000 0000000000000029
!	Mem[000000001c000000] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c000010] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c000020] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c000030] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i0]ASI_BLK_PL,%f0	! Block Load from 000000001c000000
!	Mem[000000001f0000b0] = 1132670a, %l7 = 000000003270ad19
	lduba	[%i6+0x0b0]%asi,%l7	! %l7 = 0000000000000011

p3_label_114:
!	%l7 = 0000000000000011, immed = 00000eb9, %l5 = 0000000000000029
	andncc	%l7,0xeb9,%l5		! %l5 = 0000000000000000, %ccr = 44
!	%l6 = 00000000000034cb, %l6 = 00000000000034cb, %l0 = d31b1a2573e79db9
	addccc	%l6,%l6,%l0		! %l0 = 0000000000006996, %ccr = 00
!	%l3 = d31b1a2573e79db9, %l5 = 0000000000000000, %l0 = 0000000000006996
	orn	%l3,%l5,%l0		! %l0 = ffffffffffffffff
!	%f16 = 5e87e92d edcc64e0 936a7731 3d67513e
!	%f20 = 232392e8 0578462f c330140e 643a10ae
!	%f24 = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f28 = bbfa5390 86f2b0ea 3ff00000 00000000
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d8001c0
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 000000001c000180

p3_label_115:
!	Mem[000000001c000040] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c000050] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001c000060] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c000070] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 000000001c000040
!	Mem[000000001d800008] = e1cdada7, %l7 = 0000000000000011
	lduha	[%i3+%o6]0x80,%l7	! %l7 = 000000000000e1cd
!	Mem[000000001d000140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001d000150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001d000160] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[000000001d000170] = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x140,%g5
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d000140
!	Mem[0000000040a0003c] = 2e2b3508, %l0 = ffffffffffffffff
	lduha	[%o5+0x03c]%asi,%l0	! %l0 = 0000000000002e2b
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g4
	stda	%f0,[%i0+%g4]ASI_BLK_PL	! Block Store to 000000001c000080

p3_label_116:
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x180,%g5
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 000000001c800180
!	Mem[0000000072000000] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000010] = 0e54c8c5 2a073b4d fcc4d331 eb56ea21
!	Mem[0000000072000020] = 4c3ff1ef ec32b332 d86c7275 0aaeaab5
!	Mem[0000000072000030] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	membar	#Sync			! Added by membar checker (181)
!	Mem[000000001d000000] = fb5772f2fee06d1a, %l1 = 000000002e2a0029
	ldxa	[%i2+%g0]0x80,%l1	! %l1 = fb5772f2fee06d1a
!	Mem[0000000070000058] = d31b1a25 73e79db9, %l6 = 000034cb, %l7 = 0000e1cd
	ldda	[%o0+0x058]%asi,%l6	! %l6 = 00000000d31b1a25 0000000073e79db9
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = fee06d1a 00000002 fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 72f2aab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040

p3_label_117:
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000001d000140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001d000150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001d000160] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[000000001d000170] = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x140,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 000000001d000140
	membar	#Sync
!	Branch On Register, %l4 = 0000000000000000
	brnz,a,pn %l4,p3_not_taken_0	! Branch Not Taken
!	Mem[000000001d000008] = 8ffb0fa0, %l4 = 0000000000000000
	lduha	[%i2+%o6]0x80,%l4	! Annulled
p3_b35:
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 000000001d000140

p3_label_118:
!	Mem[000000001c000100] = 179a4bf9 e37a08a0 342c3656 bf384a0e
!	Mem[000000001c000110] = 6374c23a eaf132d6 2ea54d76 169ed5a4
!	Mem[000000001c000120] = b34a5ae5 ec5f9f35 5108830a c5a9545d
!	Mem[000000001c000130] = b0500504 6dcbe1c4 921ab2fc 8524c630
	mov	0x100,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c000100
!	Mem[000000001c0001a0] = 1b5d8c9105b69986, %l5 = 0000000000000000
	ldx	[%i0+0x1a0],%l5		! %l5 = 1b5d8c9105b69986
	be	p3_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[000000001d000000] = fb5772f2, %l3 = d31b1a2573e79db9
	lduwa	[%i2+%g0]0x80,%l3	! %l3 = 00000000fb5772f2
p3_b36:
!	Mem[0000000071000058] = 00000000, %l4 = 0000000000000000
	lduha	[%o2+0x05a]%asi,%l4	! %l4 = 0000000000000000

p3_label_119:
!	Mem[000000001c800008] = 8ffb0fa0, %l1 = fb5772f2fee06d1a
	lduwa	[%i1+%o6]0x80,%l1	! %l1 = 000000008ffb0fa0
!	Mem[0000000072000050] = fee06d1a, %l1 = 000000008ffb0fa0
	ldsb	[%o4+0x050],%g2		! %g2 = fffffffffffffffe
!	%f0  = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	%f4  = d632f1ea 3ac27463 a4d59e16 764da52e
!	%f8  = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	%f12 = c4e1cb6d 040550b0 30c62485 fcb21a92
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 000000001c000100
!	Mem[000000007100005c] = 00000029, %l6 = 00000000d31b1a25
	ldsw	[%o2+0x05c],%l6		! %l6 = 0000000000000029
!	%f18 = 00000000 9460d876, %f24 = 5c8ccd98 ee68008c
	fxtod	%f18,%f24		! %f24 = 41e28c1b 0ec00000

p3_label_120:
!	Mem[000000001d8001fc] = 0000f03f, %l7 = 0000000073e79db9
	lduba	[%i3+0x1fd]%asi,%l7	! %l7 = 0000000000000000
!	Mem[000000001c000040] = 34cb72f2, %l1 = 000000008ffb0fa0
	ldsw	[%i0+0x040],%l1		! %l1 = 0000000034cb72f2
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x1c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 000000001d8001c0
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 000000001c800100
!	Mem[000000007080001c] = 3270ad19, %l2 = 284681f22e2a16b2
	lduha	[%o1+0x01e]%asi,%l2	! %l2 = 000000000000ad19

p3_label_121:
	membar	#Sync
	fbl	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%f6  = a4d59e16 764da52e, %f14 = 30c62485 fcb21a92
	fmovd	%f6 ,%f14		! %f14 = a4d59e16 764da52e
p3_b37:
!	%l0 = 0000000000002e2b, Mem[000000001d8001bf] = 00000000
	stb	%l0,[%i3+0x1bf]		! Mem[000000001d8001bc] = 0000002b
!	%l7 = 0000000000000000, Mem[000000001c800000] = 34cb72f2
	stba	%l7,[%i1+%g0]0x80	! Mem[000000001c800000] = 00cb72f2
!	Mem[000000001d800000] = 6a1153e4, %l0 = 0000000000002e2b
	ldswa	[%i3+%g0]0x80,%l0	! %l0 = 000000006a1153e4

p3_label_122:
!	Mem[000000001c000068] = 1f1e56b9934b097b, %l6 = 0000000000000029
	ldx	[%i0+0x068],%l6		! %l6 = 1f1e56b9934b097b
!	Mem[000000001d000040] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d000050] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001d000060] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d000070] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x040,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f16	! Block Load from 000000001d000040
!	Mem[000000001d000008] = 8ffb0fa017e0a64b, %l3 = 00000000fb5772f2
	ldxa	[%i2+%o6]0x80,%l3	! %l3 = 8ffb0fa017e0a64b
!	Mem[000000001d000140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001d000150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001d000160] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[000000001d000170] = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x140,%g5
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001d000140
!	Mem[000000001d8001c0] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001d8001d0] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001d8001e0] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001d8001f0] = 0b1e32e6 fe20c359 891324ba cd3d7471
	mov	0x1c0,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d8001c0

p3_label_123:
!	Mem[000000007180001c] = 2e2a0029, %l3 = 8ffb0fa017e0a64b
	lduh	[%o3+0x01e],%l3		! %l3 = 0000000000000029
!	Mem[000000001d8000b8] = 83a6bf10796ca3ae, %l0 = 000000006a1153e4
	ldx	[%i3+0x0b8],%l0		! %l0 = 83a6bf10796ca3ae
!	Mem[000000001e800100] = 81c58cc1 ccc1f194 0ae6787a b3d66098
!	Mem[000000001e800110] = 43e7d6df 4036ff4b 33079be6 97648b24
!	Mem[000000001e800120] = 8f44f65c 43c28244 08dbdd98 56f7bea5
!	Mem[000000001e800130] = d726c634 a24e5d3a 48385f3b 4b0244ec
	mov	0x100,%g6
	ldda	[%i5+%g6]ASI_BLK_P,%f0	! Block Load from 000000001e800100
!	Mem[000000001c000090] = d24e37b8 d7343a59, %l2 = 0000ad19, %l3 = 00000029
	ldda	[%i0+0x090]%asi,%l2	! %l2 = 00000000d24e37b8 00000000d7343a59
	nop

p3_label_124:
!	Mem[000000007100005c] = 00000029, %l2 = 00000000d24e37b8
	lduh	[%o2+0x05c],%l2		! %l2 = 0000000000000000
!	Mem[000000001d000008] = 8ffb0fa0, %l2 = 0000000000000000
	ldswa	[%i2+%o6]0x80,%l2	! %l2 = ffffffff8ffb0fa0
!	Mem[000000001d8000c0] = e064cced eab0f206 3e51673d 31776a93
!	Mem[000000001d8000d0] = d375d3b5 d6ac3024 ae103a64 0e1430c3
!	Mem[000000001d8000e0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d8000f0] = d375d3b5 9053fabb 68c6a9d3 b7552a83
	mov	0x0c0,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 000000001d8000c0
!	Mem[0000000071000058] = 0000000000000029, %l6 = 1f1e56b9934b097b
	ldx	[%o2+0x058],%l6		! %l6 = 0000000000000029
!	Mem[000000001d000008] = 8ffb0fa0, %l0 = 83a6bf10796ca3ae
	ldsba	[%i2+%o6]0x80,%l0	! %l0 = ffffffffffffff8f

p3_label_125:
!	Mem[0000000040a0003c] = 2e2b3508, %l7 = 0000000000000000
	ldub	[%o5+0x03c],%l7		! %l7 = 000000000000002e
!	Mem[000000001d8000c8] = 3e51673d, %l1 = 0000000034cb72f2
	lduw	[%i3+0x0c8],%l1		! %l1 = 000000003e51673d
!	%f0  = 81c58cc1 ccc1f194 0ae6787a b3d66098
!	%f4  = 43e7d6df 4036ff4b 33079be6 97648b24
!	%f8  = 8f44f65c 43c28244 08dbdd98 56f7bea5
!	%f12 = d726c634 a24e5d3a 48385f3b 4b0244ec
	mov	0x180,%g4
	stda	%f0,[%i0+%g4]ASI_BLK_PL	! Block Store to 000000001c000180
!	Mem[000000001c800000] = 00cb72f2fee06d1a, %l3 = 00000000d7343a59
	ldxa	[%i1+%g0]0x80,%l3	! %l3 = 00cb72f2fee06d1a
!	Mem[000000007180001c] = 2e2a0029, %l4 = 0000000000000000
	ldub	[%o3+0x01d],%l4		! %l4 = 000000000000002a

p3_label_126:
!	Mem[000000001c000008] = 4ba6e017, %l6 = 0000000000000029
	swapa	[%i0+%o6]0x80,%l6	! %l6 = 000000004ba6e017
!	Mem[000000001c800080] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c800090] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c8000a0] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c8000b0] = 54778150 c252c6a8 ab224f7c 42717296
	mov	0x080,%g4
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c800080
!	Mem[000000001d000080] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d000090] = 593a34d7 b8374ed2 284681f2 2e2a16b2
!	Mem[000000001d0000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d0000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i2+%g4]ASI_BLK_P,%f0	! Block Load from 000000001d000080
!	Mem[000000001c000000] = 1a6de0fe f272cb34, %l4 = 0000002a, %l5 = 05b69986
	ldda	[%i0+%g0]0x80,%l4	! %l4 = 000000001a6de0fe 00000000f272cb34
!	%l1 = 000000003e51673d, %l6 = 000000004ba6e017, %l1 = 000000003e51673d
	xnorcc	%l1,%l6,%l1		! %l1 = ffffffff8a0878d5, %ccr = 88

p3_label_127:
!	Mem[0000000072000074] = 0a683861, %l7 = 000000000000002e
	ldsh	[%o4+0x074],%g2		! %g2 = 0000000000000a68
!	Mem[0000000072000030] = 59c320fee6321e0b, %l3 = 00cb72f2fee06d1a
	ldx	[%o4+0x030],%g2		! %g2 = 59c320fee6321e0b
!	Mem[0000000072000000] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[0000000072000010] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[0000000072000020] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[0000000072000030] = 59c320fe e6321e0b 71743dcd ba241389
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[000000001c000100] = a0087ae3 f94b9a17 0e4a38bf 56362c34
!	Mem[000000001c000110] = d632f1ea 3ac27463 a4d59e16 764da52e
!	Mem[000000001c000120] = 359f5fec e55a4ab3 5d54a9c5 0a830851
!	Mem[000000001c000130] = c4e1cb6d 040550b0 30c62485 fcb21a92
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001c000100
!	%f0  = 179a4bf9 e37a08a0 342c3656 bf384a0e
!	%f4  = 6374c23a eaf132d6 2ea54d76 169ed5a4
!	%f8  = b34a5ae5 ec5f9f35 5108830a c5a9545d
!	%f12 = b0500504 6dcbe1c4 921ab2fc 8524c630
	mov	0x180,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_PL	! Block Store to 000000001d800180

p3_label_128:
!	%f0  = 179a4bf9 e37a08a0 342c3656 bf384a0e
!	%f4  = 6374c23a eaf132d6 2ea54d76 169ed5a4
!	%f8  = b34a5ae5 ec5f9f35 5108830a c5a9545d
!	%f12 = b0500504 6dcbe1c4 921ab2fc 8524c630
	mov	0x0c0,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_PL	! Block Store to 000000001c8000c0
!	%f16 = 9ecfd7df d2fe6998 422142ea ff19867c
!	%f20 = 5a7cee6f 9aab2801 c78cf17c baf657d2
!	%f24 = aca9c1f4 a30762dc d7f67d99 c547e873
!	%f28 = a8c652c2 50817754 96727142 7c4f22ab
	stda	%f16,[%i1]ASI_BLK_PL	! Block Store to 000000001c800000
!	Mem[000000001c000050] = 593a34d7b8374ed2, %l0 = ffffffffffffff8f
	ldx	[%i0+0x050],%l0		! %l0 = 593a34d7b8374ed2
!	Mem[0000000070000058] = d31b1a2573e79db9, %l0 = 593a34d7b8374ed2, %l1 = ffffffff8a0878d5
	add	%o0,0x58,%g1
	casxa	[%g1]0x80,%l0,%l1	! %l1 = d31b1a2573e79db9
!	Mem[000000001c80009c] = 7cf18cc7, %l7 = 000000000000002e
	lduw	[%i1+0x09c],%l7		! %l7 = 000000007cf18cc7

p3_label_129:
	membar	#Sync			! Added by membar checker (182)
!	%f16 = 9ecfd7df d2fe6998 422142ea ff19867c
!	%f20 = 5a7cee6f 9aab2801 c78cf17c baf657d2
!	%f24 = aca9c1f4 a30762dc d7f67d99 c547e873
!	%f28 = a8c652c2 50817754 96727142 7c4f22ab
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 000000001d800180
!	Mem[000000001c800140] = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	Mem[000000001c800150] = 86c97e82 33248e7e 4865594a 1ff03e71
!	Mem[000000001c800160] = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	Mem[000000001c800170] = fbe9966c f3106ea7 3fd26283 316033d2
	mov	0x140,%g6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001c800140
!	%f28 = a8c652c2, %f28 = a8c652c2, %f22 = c78cf17c
	fdivs	%f28,%f28,%f22		! %f22 = 3f800000
!	%f0  = eadeca9d b9fec9b5 24c3869f 20f1e4e2
!	%f4  = 7e8e2433 827ec986 713ef01f 4a596548
!	%f8  = 310d9818 1e7ca47f 09486ae0 a2a1f0c0
!	%f12 = a76e10f3 6c96e9fb d2336031 8362d23f
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 000000001d800140
!	Mem[000000001d8000c0] = e064cced eab0f206 3e51673d 31776a93
!	Mem[000000001d8000d0] = d375d3b5 d6ac3024 ae103a64 0e1430c3
!	Mem[000000001d8000e0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d8000f0] = d375d3b5 9053fabb 68c6a9d3 b7552a83
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 000000001d8000c0

p3_label_130:
	fbne,a,pt %fcc3,p3_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[000000001e800008] = a755a393, %l6 = 000000004ba6e017
	ldsba	[%i5+%o6]0x80,%l6	! Annulled
p3_b38:
!	Mem[000000001c000180] = 94f1c1cc c18cc581 9860d6b3 7a78e60a
!	Mem[000000001c000190] = 4bff3640 dfd6e743 248b6497 e69b0733
!	Mem[000000001c0001a0] = 4482c243 5cf6448f a5bef756 98dddb08
!	Mem[000000001c0001b0] = 3a5d4ea2 34c626d7 ec44024b 3b5f3848
	ldda	[%i0+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c000180
!	%f16 = 9ecfd7df d2fe6998 422142ea ff19867c
!	%f20 = 5a7cee6f 9aab2801 3f800000 baf657d2
!	%f24 = aca9c1f4 a30762dc d7f67d99 c547e873
!	%f28 = a8c652c2 50817754 96727142 7c4f22ab
	mov	0x100,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 000000001d000100
!	Mem[000000001c000120] = 359f5fec, %l2 = ffffffff8ffb0fa0
	lduha	[%i0+0x120]%asi,%l2	! %l2 = 000000000000359f

p3_label_131:
!	%f0  = 94f1c1cc c18cc581 9860d6b3 7a78e60a
!	%f4  = 4bff3640 dfd6e743 248b6497 e69b0733
!	%f8  = 4482c243 5cf6448f a5bef756 98dddb08
!	%f12 = 3a5d4ea2 34c626d7 ec44024b 3b5f3848
	mov	0x040,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 000000001d000040
!	Mem[000000001e000008] = 1e4c4e47, %l6 = 000000004ba6e017
	ldswa	[%i4+%o6]0x80,%l6	! %l6 = 000000001e4c4e47
!	Mem[000000001c800000] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c800010] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c800020] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c800030] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%i1]ASI_BLK_P,%f16	! Block Load from 000000001c800000
!	%f16 = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	%f20 = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	%f24 = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	%f28 = 54778150 c252c6a8 ab224f7c 42717296
	mov	0x1c0,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c8001c0
!	Mem[000000001c000000] = 1a6de0fe f272cb34, %l2 = 0000359f, %l3 = fee06d1a
	ldda	[%i0+%g0]0x80,%l2	! %l2 = 000000001a6de0fe 00000000f272cb34

p3_label_132:
	membar	#Sync			! Added by membar checker (183)
!	Mem[000000001d800140] = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	Mem[000000001d800150] = 86c97e82 33248e7e 4865594a 1ff03e71
!	Mem[000000001d800160] = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	Mem[000000001d800170] = fbe9966c f3106ea7 3fd26283 316033d2
	mov	0x140,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001d800140
!	Mem[0000000070800018] = 52cf8915, %l7 = 000000007cf18cc7
	lduh	[%o1+0x018],%l7		! %l7 = 00000000000052cf
	membar	#Sync
!	Branch On Register, %l0 = 593a34d7b8374ed2
	brgz,pn	%l0,p3_b39		! Branch Taken
!	%f2  = 9860d6b3 7a78e60a, %f8  = 4482c243 5cf6448f
	fabsd	%f2 ,%f8 		! %f8  = 1860d6b3 7a78e60a
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p3_branch_failed
	mov	0x027,%g2
p3_b39:
!	Branch On Register, %l4 = 000000001a6de0fe
	brgez,pt %l4,p3_b40		! Branch Taken

p3_label_133:
!	Mem[000000001c800160] = 7fa47c1e18980d31, %l2 = 000000001a6de0fe
	ldx	[%i1+0x160],%l2		! %l2 = 7fa47c1e18980d31
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p3_branch_failed
	mov	0x028,%g2
p3_b40:
!	Mem[000000001d000100] = 9869fed2dfd7cf9e, %l0 = 593a34d7b8374ed2
	ldx	[%i2+0x100],%l0		! %l0 = 9869fed2dfd7cf9e
	fblg,a	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000001d800000] = 6a1153e4, %l0 = 9869fed2dfd7cf9e
	ldsba	[%i3+%g0]0x80,%l0	! Annulled
p3_b41:
!	%f16 = eadeca9d b9fec9b5 24c3869f 20f1e4e2
!	%f20 = 7e8e2433 827ec986 713ef01f 4a596548
!	%f24 = 310d9818 1e7ca47f 09486ae0 a2a1f0c0
!	%f28 = a76e10f3 6c96e9fb d2336031 8362d23f
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 000000001d800140

p3_label_134:
	membar	#Sync			! Added by membar checker (184)
!	%f16 = eadeca9d b9fec9b5 24c3869f 20f1e4e2
!	%f20 = 7e8e2433 827ec986 713ef01f 4a596548
!	%f24 = 310d9818 1e7ca47f 09486ae0 a2a1f0c0
!	%f28 = a76e10f3 6c96e9fb d2336031 8362d23f
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 000000001d800140
!	Mem[0000000070800018] = 52cf89153270ad19, %l2 = 7fa47c1e18980d31
	ldx	[%o1+0x018],%l2		! %l2 = 52cf89153270ad19
!	Mem[000000001c000080] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c000090] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c0000a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c0000b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 000000001c000080
!	Mem[000000001c8001e0] = dc6207a3f4c1a9ac, %l5 = 00000000f272cb34
	ldx	[%i1+0x1e0],%l5		! %l5 = dc6207a3f4c1a9ac
!	Mem[000000007100001c] = fa88dc14, %l7 = 00000000000052cf
	ldswa	[%o2+0x01c]%asi,%l7	! %l7 = fffffffffa88dc14

p3_label_135:
	membar	#Sync			! Added by membar checker (185)
	set	p3_b42,%o7
	fble,a	p3_far_3_le		! Branch Taken, %fcc0 = 0
!	Mem[000000001d000110] = 0128ab9a6fee7c5a, %l1 = d31b1a2573e79db9
	ldx	[%i2+0x110],%l1		! %l1 = 0128ab9a6fee7c5a
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x02a,%g2
p3_b42:
!	Registers modified during the branch to p3_far_3
!	%l0  = 179a4bf9e37a08a0
!	%l3  = fa13263f4d20a048
!	%l6  = 0000000000000008
!	Mem[0000000072000040] = ef6aa544 741e7ee0 0fb1502c bbfc7943
!	Mem[0000000072000050] = fee06d1a 00000002 fcc4d331 eb56ea21
!	Mem[0000000072000060] = 4c3ff1ef ec32b332 d86c7275 72f2aab5
!	Mem[0000000072000070] = e37ed0ee 0a683861 ec98b9c4 e7c69045
	mov	0x040,%g6
	ldda	[%o4+%g6]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000072000040] = a544741e, %l7 = fffffffffa88dc14
	ldsba	[%o4+0x042]%asi,%g2	! %g2 = ffffffffffffffa5
!	%l0 = 179a4bf9e37a08a0
	sethi	%hi(0x94f39000),%l0	! %l0 = 0000000094f39000

p3_label_136:
!	%f23 = 4ee3a42e, %f4  = 4bff3640 dfd6e743
	fstox	%f23,%f4 		! %f4  = 00000000 71d21700
!	%f16 = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x0c0,%g4
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 000000001c0000c0
	membar	#Sync
!	Branch On Register, %l0 = 0000000094f39000
	brgez,pt %l0,p3_b43		! Branch Taken
!	%f22 = b2162a2e 4ee3a42e, %f0  = 94f1c1cc c18cc581
	fcmpd	%fcc3,%f22,%f0 		! %fcc3 = 1
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p3_branch_failed
	mov	0x02b,%g2
p3_b43:
!	%f16 = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c8000c0

p3_label_137:
!	Mem[0000000072000050] = fee06d1a00000002, %l4 = 000000001a6de0fe
	ldx	[%o4+0x050],%g2		! %g2 = fee06d1a00000002
!	Mem[0000000072000000] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[0000000072000010] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[0000000072000020] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[0000000072000030] = 59c320fe e6321e0b 71743dcd ba241389
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[0000000070800018] = 52cf89153270ad19, %l0 = 0000000094f39000
	ldx	[%o1+0x018],%l0		! %l0 = 52cf89153270ad19
!	Mem[0000000071000058] = 0000000000000029, %l5 = dc6207a3f4c1a9ac
	ldx	[%o2+0x058],%l5		! %l5 = 0000000000000029
!	%l3 = fa13263f4d20a048, %l5 = 0000000000000029, %l3 = fa13263f4d20a048
	xor	%l3,%l5,%l3		! %l3 = fa13263f4d20a061

p3_label_138:
!	Mem[000000001d000000] = fb5772f2, %l5 = 0000000000000029
	lduha	[%i2+%g0]0x80,%l5	! %l5 = 000000000000fb57
!	Mem[000000001c800000] = 9869fed2 dfd7cf9e, %l6 = 00000008, %l7 = fa88dc14
	ldda	[%i1+%g0]0x80,%l6	! %l6 = 000000009869fed2 00000000dfd7cf9e
!	%f5  = 71d21700, %f1  = c18cc581
	fnegs	%f5 ,%f1 		! %f1  = f1d21700
!	Mem[000000001c0001a8] = a5bef756 98dddb08, %l0 = 3270ad19, %l1 = 6fee7c5a
	ldd	[%i0+0x1a8],%l0		! %l0 = 00000000a5bef756 0000000098dddb08
!	Mem[000000001c800008] = 7c8619ff, %l3 = fa13263f4d20a061
	lduba	[%i1+%o6]0x80,%l3	! %l3 = 000000000000007c

p3_label_139:
!	Mem[000000001d8001f0] = 0b1e32e6, %l0 = 00000000a5bef756
	lduw	[%i3+0x1f0],%l0		! %l0 = 000000000b1e32e6
!	Mem[000000001d800100] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d800110] = 2f467805 e892ff99 00000000 00000000
!	Mem[000000001d800120] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d800130] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x100,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 000000001d800100
	bpos,a	p3_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[0000000071000058] = 00000000, %l4 = 000000001a6de0fe
	ldsb	[%o2+0x058],%l4		! Annulled
p3_b44:
!	Mem[000000001c800080] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c800090] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c8000a0] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c8000b0] = 54778150 c252c6a8 ab224f7c 42717296
	mov	0x080,%g4
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 000000001c800080

p3_label_140:
!	Mem[000000001d000114] = 6fee7c5a, %l4 = 000000001a6de0fe
	ldsba	[%i2+0x117]%asi,%l4	! %l4 = 000000000000005a
!	Mem[000000001d0001b8] = aea36c79, %f23 = 4ee3a42e
	ld	[%i2+0x1b8],%f23	! %f23 = aea36c79
!	Mem[0000000071000058] = 0000000000000029, %l3 = 000000000000007c
	ldx	[%o2+0x058],%l3		! %l3 = 0000000000000029
!	Mem[000000001d000064] = 43c28244, %l1 = 0000000098dddb08
	ldswa	[%i2+0x064]%asi,%l1	! %l1 = 0000000043c28244
!	%f24 = 1b5d8c91 05b69986, %f24 = 1b5d8c91 05b69986, %f16 = 1a6de0fe f272cb34
	faddd	%f24,%f24,%f16		! %f16 = 1b6d8c91 05b69986

p3_label_141:
!	Mem[000000001d8001c0] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001d8001d0] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001d8001e0] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001d8001f0] = 0b1e32e6 fe20c359 891324ba cd3d7471
	mov	0x1c0,%g5
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d8001c0
!	Mem[000000001d80007c] = fcb21a92, %l4 = 000000000000005a
	ldsba	[%i3+0x07e]%asi,%l4	! %l4 = 000000000000001a
!	%f15 = 42717296, %f15 = 42717296, %f14 = ab224f7c
	fsubs	%f15,%f15,%f14		! %f14 = 00000000
!	Mem[000000001d8001c0] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001d8001d0] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001d8001e0] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001d8001f0] = 0b1e32e6 fe20c359 891324ba cd3d7471
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d8001c0
!	Mem[0000000071000058] = 0000000000000029, %l2 = 52cf89153270ad19
	ldx	[%o2+0x058],%l2		! %l2 = 0000000000000029

p3_label_142:
!	Mem[0000000070800018] = 52cf8915, %l4 = 000000000000001a
	ldsba	[%o1+0x018]%asi,%l4	! %l4 = 0000000000000052
!	%f0  = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	%f4  = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	%f8  = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	%f12 = 54778150 c252c6a8 00000000 42717296
	stda	%f0,[%i3]ASI_BLK_PL	! Block Store to 000000001d800000
!	Mem[000000001c800008] = 7c8619ff, %l7 = 00000000dfd7cf9e
	ldstuba	[%i1+%o6]0x80,%l7	! %l7 = 000000000000007c
	membar	#Sync			! Added by membar checker (186)
!	%f0  = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	%f4  = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	%f8  = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	%f12 = 54778150 c252c6a8 00000000 42717296
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 000000001d800000
!	Mem[000000001c800048] = 0e4a38bf, %l2 = 0000000000000029
	lduba	[%i1+0x049]%asi,%l2	! %l2 = 000000000000004a

p3_label_143:
	membar	#Sync			! Added by membar checker (187)
	set	p3_b45,%o7
	fbul,a,pn %fcc3,p3_near_3_he	! Branch Taken, %fcc3 = 1
!	Mem[000000001c800084] = dfd7cf9e, %l7 = 000000000000007c
	lduw	[%i1+0x084],%l7		! %l7 = 00000000dfd7cf9e
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p3_branch_failed
	mov	0x02d,%g2
p3_b45:
!	Registers modified during the branch to p3_near_3
!	%l0  = ffffffffffffffb0
!	%l2  = 891050599fba8e01
!	%l4  = 0000000000000000
!	%l5  = 9431d876fa88dc14
!	%l6  = 891050599fba8064
!	%l7  = e2e4f1209f86c324
!	Mem[000000001c800180] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001c800190] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001c8001a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001c8001b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x180,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c800180
!	%f20 = e7cc40d0 7b352292, %f26 = 79d5e01a a8e9507a
	fcmpd	%fcc3,%f20,%f26		! %fcc3 = 1
!	Mem[0000000070800058] = f92f1bc5b0d9076b, %l4 = 0000000000000000
	ldx	[%o1+0x058],%l4		! %l4 = f92f1bc5b0d9076b

p3_label_144:
!	Mem[0000000071800018] = 2ea4e34e, %l4 = f92f1bc5b0d9076b
	lduw	[%o3+0x018],%l4		! %l4 = 000000002ea4e34e
!	Mem[000000001f0000c0] = 5a07b363 7bfcc498 cf327d51 5809edfe
!	Mem[000000001f0000d0] = 1539cfd3 5db07b00 0affdcf4 f2947be2
!	Mem[000000001f0000e0] = f976e8ef 985940be 1f5436a0 0b878429
!	Mem[000000001f0000f0] = 13073cec 3107506a 60c13a78 9616755f
	mov	0x0c0,%g4
	ldda	[%i6+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001f0000c0
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g5
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 000000001d000080
!	Mem[0000000071800058] = 79c52bb5523e4c31, %l2 = 891050599fba8e01
	ldx	[%o3+0x058],%l2		! %l2 = 79c52bb5523e4c31

p3_label_145:
!	Mem[000000001c800080] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c800090] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c8000a0] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c8000b0] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c800080
!	%l3 = 0000000000000029, immed = 00000487, %y  = fa13263f
	mulx	%l3,0x487,%l7		! %l7 = 000000000000b99f
!	Mem[000000001d000000] = fb5772f2fee06d1a, %l2 = 79c52bb5523e4c31
	ldxa	[%i2+%g0]0x80,%l2	! %l2 = fb5772f2fee06d1a
!	Mem[000000001d000148] = 00000000, %l7 = 000000000000b99f
	lduw	[%i2+0x148],%l7		! %l7 = 0000000000000000
!	%f16 = 98c4fc7b 63b3075a feed0958 517d32cf
!	%f20 = 007bb05d d3cf3915 e27b94f2 f4dcff0a
!	%f24 = be405998 efe876f9 2984870b a036541f
!	%f28 = 6a500731 ec3c0713 5f751696 783ac160
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 000000001c800040

p3_label_146:
!	Mem[000000001d8001c0] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001d8001d0] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001d8001e0] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001d8001f0] = 0b1e32e6 fe20c359 891324ba cd3d7471
	mov	0x1c0,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d8001c0
!	Mem[0000000072000000] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[0000000072000010] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[0000000072000020] = 5c8ccd98 ee68008c 7a50e9a8 1ae0d579
!	Mem[0000000072000030] = 59c320fe e6321e0b 71743dcd ba241389
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	membar	#Sync			! Added by membar checker (188)
!	Mem[000000001d000080] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000090] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001d0000a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d0000b0] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001d000080
!	%f16 = 98c4fc7b 63b3075a, %f26 = 2984870b a036541f
	fabsd	%f16,%f26		! %f26 = 18c4fc7b 63b3075a
!	Mem[000000007200000c] = 76922235, %l6 = 891050599fba8064
	ldub	[%o4+0x00f],%g2		! %g2 = 0000000000000076

p3_label_147:
!	Mem[000000001d0000fc] = b7552a83, %l4 = 000000002ea4e34e
	lduba	[%i2+0x0ff]%asi,%l4	! %l4 = 0000000000000083
!	%f16 = 98c4fc7b 63b3075a feed0958 517d32cf
!	%f20 = 007bb05d d3cf3915 e27b94f2 f4dcff0a
!	%f24 = be405998 efe876f9 18c4fc7b 63b3075a
!	%f28 = 6a500731 ec3c0713 5f751696 783ac160
	mov	0x100,%g4
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 000000001d800100
!	%f16 = 98c4fc7b 63b3075a feed0958 517d32cf
!	%f20 = 007bb05d d3cf3915 e27b94f2 f4dcff0a
!	%f24 = be405998 efe876f9 18c4fc7b 63b3075a
!	%f28 = 6a500731 ec3c0713 5f751696 783ac160
	mov	0x180,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 000000001c000180
!	Mem[000000001c800100] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001c800110] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001c800120] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001c800130] = 0b1e32e6 fe20c359 891324ba cd3d7471
	ldda	[%i1+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c800100
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 000000001c000100

p3_label_148:
!	Mem[000000001d0000c0] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d0000d0] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d0000e0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d0000f0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x0c0,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 000000001d0000c0
	membar	#Sync			! Added by membar checker (189)
	set	p3_b46,%o7
	fble,a	p3_far_3_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000072000010] = 9222357b, %l3 = 0000000000000029
	lduh	[%o4+0x010],%g2		! %g2 = 0000000000009222
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p3_branch_failed
	mov	0x02e,%g2
p3_b46:
!	Registers modified during the branch to p3_far_3
!	%l6  = 6a030220a1d31b99
!	Mem[000000007000005c] = 73e79db9, %l3 = 0000000000000029
	ldsw	[%o0+0x05c],%l3		! %l3 = 0000000073e79db9
!	Mem[000000001c000080] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c000090] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c0000a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c0000b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x080,%g6
	ldda	[%i0+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001c000080

p3_label_149:
!	Mem[000000001c000008] = 00000029, %l4 = 0000000000000083
	ldsha	[%i0+%o6]0x80,%l4	! %l4 = 0000000000000000
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x140,%g4
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 000000001d800140
!	%l5 = 9431d876fa88dc14, %l0 = ffffffffffffffb0, %l0 = ffffffffffffffb0
	or	%l5,%l0,%l0		! %l0 = ffffffffffffffb4
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	stda	%f16,[%i6]ASI_BLK_P	! Block Store to 000000001f000000
!	Mem[000000001c000064] = 918c5d1b, %l3 = 0000000073e79db9
	ldsw	[%i0+0x064],%l3		! %l3 = ffffffff918c5d1b

p3_label_150:
!	%l4 = 0000000000000000, %l0 = ffffffffffffffb4, %l6 = 6a030220a1d31b99
	taddcc	%l4,%l0,%l6		! %l6 = ffffffffffffffb4, %ccr = 88
!	Mem[000000001c000008] = 00000029, %l1 = 0000000043c28244
	lduwa	[%i0+%o6]0x80,%l1	! %l1 = 0000000000000029
!	Mem[000000001d8000c8] = 3e51673d 31776a93, %l4 = 00000000, %l5 = fa88dc14
	ldd	[%i3+0x0c8],%l4		! %l4 = 000000003e51673d 0000000031776a93
!	%f0  = 34cb72f2, %f0  = 34cb72f2, %f0  = 34cb72f2
	fsubs	%f0 ,%f0 ,%f0 		! %f0  = 00000000
!	%l6 = ffffffffffffffb4, %l2 = fb5772f2fee06d1a, %l7 = 0000000000000000
	addccc	%l6,%l2,%l7		! %l7 = fb5772f2fee06cce, %ccr = 99

p3_label_151:
!	Mem[000000001c800040] = 5a07b363, %l1 = 0000000000000029
	lduha	[%i1+0x042]%asi,%l1	! %l1 = 000000000000b363
!	%l5 = 0000000031776a93, %l7 = fb5772f2fee06cce, %y  = fa13263f
	umul	%l5,%l7,%l6		! %l6 = 313fd94149adc64a
!	Mem[0000000070800018] = 52cf8915, %l7 = fb5772f2fee06cce
	ldsba	[%o1+0x019]%asi,%l7	! %l7 = ffffffffffffffcf
!	%f16 = 23a86afc 0b931a1e 00000000 9460d876
!	%f20 = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f24 = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f28 = 59c320fe e6321e0b 71743dcd ba241389
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 000000001c000140
!	%f0  = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x040,%g6
	stda	%f0,[%i6+%g6]ASI_BLK_PL	! Block Store to 000000001f000040

p3_label_152:
!	Mem[0000000070800058] = f92f1bc5, %l6 = 313fd94149adc64a
	ldswa	[%o1+0x058]%asi,%l6	! %l6 = fffffffff92f1bc5
!	Mem[000000001d0001f0] = 874940a3e5ddc3e0, %l4 = 000000003e51673d
	ldx	[%i2+0x1f0],%l4		! %l4 = 874940a3e5ddc3e0
!	Mem[0000000070800018] = 52cf8915, %l5 = 0000000031776a93
	lduw	[%o1+0x018],%l5		! %l5 = 0000000052cf8915
	membar	#Sync
	fbul	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000001c800000] = 9869fed2, %l0 = ffffffffffffffb4
	lduba	[%i1+%g0]0x80,%l0	! %l0 = 0000000000000098
p3_b47:

p3_label_153:
!	%f0  = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i0+%g6]ASI_BLK_PL	! Block Store to 000000001c000040
!	Mem[0000000071800058] = 79c52bb5 523e4c31, %l6 = f92f1bc5, %l7 = ffffffcf
	ldda	[%o3+0x058]%asi,%l6	! %l6 = 0000000079c52bb5 00000000523e4c31
!	Mem[000000007080001c] = 3270ad19, %l2 = fb5772f2fee06d1a
	lduwa	[%o1+0x01c]%asi,%l2	! %l2 = 000000003270ad19
!	Mem[000000001c800008] = ff8619ff, %l5 = 0000000052cf8915
	ldswa	[%i1+%o6]0x80,%l5	! %l5 = ffffffffff8619ff
!	Mem[000000007000001c] = a1d31b99, %l0 = 0000000000000098
	lduha	[%o0+0x01e]%asi,%l0	! %l0 = 0000000000001b99

p3_label_154:
!	Mem[0000000070800058] = f92f1bc5, %l4 = 874940a3e5ddc3e0
	lduh	[%o1+0x05a],%l4		! %l4 = 0000000000001bc5
!	Mem[000000001c000008] = 00000029, %l6 = 0000000079c52bb5
	ldsba	[%i0+%o6]0x80,%l6	! %l6 = 0000000000000000
!	Mem[000000001e000008] = 1e4c4e47, %l1 = 000000000000b363
	lduwa	[%i4+%o6]0x80,%l1	! %l1 = 000000001e4c4e47
!	Mem[0000000070800058] = f92f1bc5b0d9076b, %l7 = 00000000523e4c31
	ldxa	[%o1+0x058]%asi,%l7	! %l7 = f92f1bc5b0d9076b
!	Mem[000000001c000140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001c000150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001c000160] = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	Mem[000000001c000170] = 59c320fe e6321e0b 71743dcd ba241389
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c000140

p3_label_155:
!	%l7 = f92f1bc5b0d9076b, immed = fffff266, %l1 = 000000001e4c4e47
	xnor	%l7,-0xd9a,%l1		! %l1 = f92f1bc5b0d90af2
!	%f0  = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x1c0,%g5
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 000000001c0001c0
!	Mem[000000001d000008] = 8ffb0fa0, %l3 = ffffffff918c5d1b
	ldswa	[%i2+%o6]0x80,%l3	! %l3 = ffffffff8ffb0fa0
!	Mem[000000001d000168] = 7a50e9a8, %l7 = f92f1bc5b0d9076b
	ldsha	[%i2+0x16a]%asi,%l7	! %l7 = ffffffffffffe9a8
!	%f0  = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 000000001d800080

p3_label_156:
!	%f0  = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x180,%g6
	stda	%f0,[%i1+%g6]ASI_BLK_P	! Block Store to 000000001c800180
	membar	#Sync			! Added by membar checker (190)
!	Mem[000000001d800080] = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800090] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001d8000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g6
	ldda	[%i3+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d800080
!	Mem[000000001d800140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001d800150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001d800160] = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	Mem[000000001d800170] = 59c320fe e6321e0b 71743dcd ba241389
	ldda	[%i3+%g4]ASI_BLK_P,%f16	! Block Load from 000000001d800140
!	Mem[000000007180005c] = 523e4c31, %l1 = f92f1bc5b0d90af2
	ldsw	[%o3+0x05c],%l1		! %l1 = 00000000523e4c31
!	Mem[000000001e0001e8] = 57440ef6c6b6d86f, %l2 = 000000003270ad19
	ldxa	[%i4+0x1e8]%asi,%l2	! %l2 = 57440ef6c6b6d86f

p3_label_157:
!	Mem[0000000072000040] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[0000000072000050] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[0000000072000060] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[0000000072000070] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x040,%g4
	ldda	[%o4+%g4]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	Mem[0000000071000058] = 00000000, %l1 = 00000000523e4c31
	ldub	[%o2+0x05b],%l1		! %l1 = 0000000000000000
!	Mem[0000000072000040] = 1a6de0fef272cb34, %l7 = ffffffffffffe9a8
	ldx	[%o4+0x040],%g2		! %g2 = 1a6de0fef272cb34
!	Mem[000000001d800080] = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800090] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001d8000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 000000001d800080
!	Mem[0000000072000030] = 59c320fe, %l1 = 0000000000000000
	lduwa	[%o4+0x030]%asi,%g2	! %g2 = 0000000000000000

p3_label_158:
!	%l1 = 0000000000000000, %l0 = 0000000000001b99, %y  = 313fd941
	sdiv	%l1,%l0,%l7		! %l7 = 000000007fffffff
	mov	%l0,%y			! %y = 00001b99
!	Mem[000000001c800100] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001c800110] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001c800120] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001c800130] = 0b1e32e6 fe20c359 891324ba cd3d7471
	mov	0x100,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c800100
!	Mem[000000001d0001b0] = c89763f6, %l7 = 000000007fffffff
	lduba	[%i2+0x1b2]%asi,%l7	! %l7 = 0000000000000063
!	Mem[000000001c8001a0] = 8699b605918c5d1b, %l7 = 0000000000000063
	ldxa	[%i1+0x1a0]%asi,%l7	! %l7 = 8699b605918c5d1b
!	Mem[000000001c8000bc] = 42717296, %l7 = 8699b605918c5d1b
	lduha	[%i1+0x0bc]%asi,%l7	! %l7 = 0000000000004271

p3_label_159:
!	Mem[000000001c000008] = 00000029, %l2 = 57440ef6c6b6d86f
	ldsha	[%i0+%o6]0x80,%l2	! %l2 = 0000000000000000
!	Mem[000000001c800140] = b5c9feb9 9dcadeea, %l4 = 00001bc5, %l5 = ff8619ff
	ldda	[%i1+0x140]%asi,%l4	! %l4 = 00000000b5c9feb9 000000009dcadeea
!	Mem[000000001c800140] = b5c9feb9 9dcadeea, %l6 = 00000000, %l7 = 00004271
	ldd	[%i1+0x140],%l6		! %l6 = 00000000b5c9feb9 000000009dcadeea
!	Mem[000000001d000000] = fb5772f2, %l0 = 0000000000001b99
	ldsba	[%i2+%g0]0x80,%l0	! %l0 = fffffffffffffffb
!	Mem[000000001c800180] = 00000000fee06d1a, %l2 = 0000000000000000
	ldx	[%i1+0x180],%l2		! %l2 = 00000000fee06d1a

p3_label_160:
!	Mem[000000001d800008] = 7c8619ffea422142, %l1 = 0000000000000000
	ldxa	[%i3+%o6]0x80,%l1	! %l1 = 7c8619ffea422142
!	Mem[000000001d8000ec] = d6ac30a4, %l5 = 000000009dcadeea
	lduha	[%i3+0x0ec]%asi,%l5	! %l5 = 000000000000d6ac
!	Mem[000000001d000100] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001d000110] = 0128ab9a 6fee7c5a d257f6ba 0000803f
!	Mem[000000001d000120] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001d000130] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d000100
!	%f16 = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	%f20 = 0128ab9a 6fee7c5a d257f6ba 0000803f
!	%f24 = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	%f28 = 54778150 c252c6a8 ab224f7c 42717296
	stda	%f16,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000001d8001f8] = 891324ba, %l3 = ffffffff8ffb0fa0
	ldsb	[%i3+0x1f8],%l3		! %l3 = ffffffffffffff89

p3_label_161:
!	Mem[000000001d000000] = fb5772f2, %l0 = fffffffffffffffb
	ldsba	[%i2+%g0]0x80,%l0	! %l0 = fffffffffffffffb
!	%l0 = fffffffffffffffb
	sethi	%hi(0xe2481000),%l0	! %l0 = 00000000e2481000
!	Mem[000000001c800000] = 9869fed2 dfd7cf9e ff8619ff ea422142
!	Mem[000000001c800010] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c800020] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c800030] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 000000001c800000
!	Mem[0000000072000040] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[0000000072000050] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[0000000072000060] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[0000000072000070] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%o4+%g4]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%l4 = b5c9feb9, %l5 = 0000d6ac, Mem[0000000070800018] = 52cf8915 3270ad19
	std	%l4,[%o1+0x018]	! Mem[0000000070800018] = b5c9feb9 0000d6ac

p3_label_162:
!	Mem[0000000070000058] = d31b1a25, %l6 = 00000000b5c9feb9
	ldsh	[%o0+0x05a],%l6		! %l6 = 0000000000001a25
!	%f16 = 9ecfd7df d2fe6998, %f2  = 76d86094 00000000
	fmovd	%f16,%f2 		! %f2  = 9ecfd7df d2fe6998
!	Mem[000000001d800098] = 2ea4e34e, %l3 = ffffffffffffff89
	lduh	[%i3+0x09a],%l3		! %l3 = 000000000000e34e
!	Mem[000000001c800188] = 8ffb0fa0, %l0 = 00000000e2481000
	ldsb	[%i1+0x18b],%l0		! %l0 = ffffffffffffffa0
!	Mem[000000001c8001c0] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c8001d0] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c8001e0] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c8001f0] = 54778150 c252c6a8 ab224f7c 42717296
	mov	0x1c0,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 000000001c8001c0

p3_label_163:
!	Mem[0000000070800058] = f92f1bc5b0d9076b, %l2 = 00000000fee06d1a
	ldx	[%o1+0x058],%l2		! %l2 = f92f1bc5b0d9076b
	bgu,a	p3_not_taken_0		! Branch Not Taken, %ccr = 99
!	Mem[000000001c000000] = 1a6de0fe, %l7 = 000000009dcadeea
	lduha	[%i0+%g0]0x80,%l7	! Annulled
p3_b48:
!	Mem[000000001c800140] = b5c9feb9 9dcadeea e2e4f120 9f86c324
!	Mem[000000001c800150] = 86c97e82 33248e7e 4865594a 1ff03e71
!	Mem[000000001c800160] = 7fa47c1e 18980d31 c0f0a1a2 e06a4809
!	Mem[000000001c800170] = fbe9966c f3106ea7 3fd26283 316033d2
	mov	0x140,%g5
	ldda	[%i1+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c800140
	membar	#Sync			! Added by membar checker (191)
!	Mem[0000000072000030] = 8150c252, %l4 = 00000000b5c9feb9
	lduh	[%o4+0x032],%g2		! %g2 = 0000000000008150

p3_label_164:
!	Mem[000000007180001c] = 2e2a0029, %l4 = 00000000b5c9feb9
	lduha	[%o3+0x01e]%asi,%l4	! %l4 = 0000000000000029
!	Mem[000000001c800100] = 1e1a930b fc6aa823 76d86094 00000000
!	Mem[000000001c800110] = e7cc40d0 7b352292 c76b6ee1 e5291e4a
!	Mem[000000001c800120] = 0000c00e 1b8ce241 79d5e01a a8e9507a
!	Mem[000000001c800130] = 0b1e32e6 fe20c359 891324ba cd3d7471
	mov	0x100,%g5
	ldda	[%i1+%g5]ASI_BLK_P,%f0	! Block Load from 000000001c800100
!	Mem[000000001c8001c0] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[000000001c8001d0] = 0128ab9a 6fee7c5a d257f6ba 7cf18cc7
!	Mem[000000001c8001e0] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[000000001c8001f0] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 000000001c8001c0
!	Mem[000000007000005c] = 73e79db9, %l2 = f92f1bc5b0d9076b
	lduba	[%o0+0x05c]%asi,%l2	! %l2 = 0000000000000073
!	Mem[000000001d800080] = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800090] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001d8000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 000000001d800080

p3_label_165:
!	Mem[000000001d000000] = fb5772f2, %l0 = ffffffffffffffa0
	ldsha	[%i2+%g0]0x80,%l0	! %l0 = fffffffffffffb57
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 000000001c000080
!	Mem[0000000072000038] = ab224f7c42717296, %l4 = 0000000000000029
	ldx	[%o4+0x038],%g2		! %g2 = ab224f7c42717296
	bne,a	p3_b49			! Branch Taken, %ccr = 99, CWP = 0
!	%l7 = 000000009dcadeea, Mem[000000007000001f] = a1d31b99
	stb	%l7,[%o0+0x01f]		! Mem[000000007000001c] = a1d31bea
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x031,%g2
p3_b49:

p3_label_166:
!	Mem[000000001c800178] = 3fd26283316033d2, %l0 = fffffffffffffb57
	ldx	[%i1+0x178],%l0		! %l0 = 3fd26283316033d2
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i6+%g4]ASI_BLK_P	! Block Store to 000000001f000040
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x0c0,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 000000001d8000c0
!	%l2 = 0000000000000073, %l1 = 7c8619ffea422142, %l1 = 7c8619ffea422142
	andn	%l2,%l1,%l1		! %l1 = 0000000000000031
	membar	#Sync			! Added by membar checker (192)
!	Mem[000000001c000088] = 8ffb0fa017e0a64b, %l4 = 0000000000000029
	ldx	[%i0+0x088],%l4		! %l4 = 8ffb0fa017e0a64b

p3_label_167:
!	Mem[000000001c80003c] = 42717296, %l1 = 0000000000000031
	ldsba	[%i1+0x03f]%asi,%l1	! %l1 = ffffffffffffff96
!	Mem[0000000070800018] = b5c9feb9 0000d6ac, %l2 = 00000073, %l3 = 0000e34e
	ldda	[%o1+0x018]%asi,%l2	! %l2 = 00000000b5c9feb9 000000000000d6ac
	fbu,a	%fcc0,p3_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%l5 = 000000000000d6ac, %l5 = 000000000000d6ac, %l0 = 3fd26283316033d2
	andcc	%l5,%l5,%l0		! Annulled
p3_b50:
!	%f4  = e7cc40d0, %f22 = b2162a2e
	fcmps	%fcc3,%f4 ,%f22		! %fcc3 = 1

p3_label_168:
!	%l3 = 000000000000d6ac, %l5 = 000000000000d6ac, %l2 = 00000000b5c9feb9
	srlx	%l3,%l5,%l2		! %l2 = 0000000000000000
!	Mem[000000001d800140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001d800150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001d800160] = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	Mem[000000001d800170] = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x140,%g4
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 000000001d800140
	be	p3_not_taken_0		! Branch Not Taken, %ccr = 99
!	%l7 = 000000009dcadeea, %l4 = 8ffb0fa017e0a64b, %l1 = ffffffffffffff96
	and	%l7,%l4,%l1		! %l1 = 0000000015c0864a
p3_b51:
!	%f0  = 23a86afc 0b931a1e 00000000 9460d876
!	%f4  = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	%f8  = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	%f12 = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x1c0,%g4
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 000000001c0001c0

p3_label_169:
!	Mem[0000000071000058] = 0000000000000029, %l1 = 0000000015c0864a
	ldx	[%o2+0x058],%l1		! %l1 = 0000000000000029
!	Mem[000000001d000008] = 8ffb0fa0, %l6 = 0000000000001a25
	lduwa	[%i2+%o6]0x80,%l6	! %l6 = 000000008ffb0fa0
!	%f18 = 4ba6e017 a00ffb8f, Mem[0000000070000018] = 6a030220 a1d31bea
	std	%f18,[%o0+0x018]	! Mem[0000000070000018] = 4ba6e017 a00ffb8f
!	Mem[0000000072000014] = 6fee7c5a, %l2 = 0000000000000000
	ldsha	[%o4+0x014]%asi,%g2	! %g2 = 0000000000006fee
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x100,%g5
	stda	%f16,[%i1+%g5]ASI_BLK_PL	! Block Store to 000000001c800100

p3_label_170:
!	Mem[0000000071800058] = 79c52bb5523e4c31, %l0 = 3fd26283316033d2
	ldx	[%o3+0x058],%l0		! %l0 = 79c52bb5523e4c31
	membar	#Sync			! Added by membar checker (193)
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 000000001c0001c0
	membar	#Sync			! Added by membar checker (194)
	set	p3_b52,%o7
	fbule	p3_far_0_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000070000058] = d31b1a25 73e79db9, %l0 = 523e4c31, %l1 = 00000029
	ldd	[%o0+0x058],%l0		! %l0 = 00000000d31b1a25 0000000073e79db9
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p3_branch_failed
	mov	0x034,%g2
p3_b52:
!	Registers modified during the branch to p3_far_0
!	%l1  = 00000000523e4c31
!	%l2  = 8ffb0fa09feafeeb
!	%l5  = 2ea4e34e2e2a0029
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x040,%g6
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 000000001d000040

p3_label_171:
!	Mem[0000000072000020] = dc6207a3f4c1a9ac, %l3 = 000000000000d6ac
	ldxa	[%o4+0x020]%asi,%g2	! %g2 = dc6207a3f4c1a9ac
	bne	p3_b53			! Branch Taken, %ccr = 88, CWP = 0
!	Mem[000000001d800000] = 9869fed2, %l1 = 00000000523e4c31
	ldsba	[%i3+%g0]0x80,%l1	! %l1 = ffffffffffffff98
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p3_branch_failed
	mov	0x035,%g2
p3_b53:
!	Mem[000000001c000000] = 1a6de0fe f272cb34 00000029 a00ffb8f
!	Mem[000000001c000010] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c000020] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c000030] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i0]ASI_BLK_P,%f0	! Block Load from 000000001c000000
!	Mem[000000001c800040] = 5a07b363 7bfcc498 cf327d51 5809edfe
!	Mem[000000001c800050] = 1539cfd3 5db07b00 0affdcf4 f2947be2
!	Mem[000000001c800060] = f976e8ef 985940be 1f5436a0 0b878429
!	Mem[000000001c800070] = 13073cec 3107506a 60c13a78 9616755f
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001c800040

p3_label_172:
!	Mem[000000001d0001c0] = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	Mem[000000001d0001d0] = b9d037f4 199d4350 89105059 9fba8e01
!	Mem[000000001d0001e0] = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	Mem[000000001d0001f0] = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 000000001d0001c0
	membar	#Sync			! Added by membar checker (195)
	set	p3_b54,%o7
	fbg,a,pn %fcc1,p3_near_2_le	! Branch Taken, %fcc1 = 2
!	Mem[000000001c000000] = 1a6de0fef272cb34, %l6 = 000000008ffb0fa0
	ldxa	[%i0+%g0]0x80,%l6	! %l6 = 1a6de0fef272cb34
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p3_branch_failed
	mov	0x036,%g2
p3_b54:
!	Registers modified during the branch to p3_near_2
!	%l2  = 00000000000029e5
!	%l5  = ab224f7c42717296
!	%l6  = 000000000000d31b
!	%l7  = 000000000000009e
!	%f0  = 98c4fc7b 63b3075a feed0958 517d32cf
!	%f4  = 007bb05d d3cf3915 e27b94f2 f4dcff0a
!	%f8  = be405998 efe876f9 2984870b a036541f
!	%f12 = 6a500731 ec3c0713 5f751696 783ac160
	mov	0x140,%g5
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 000000001c800140
!	%f16 = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	%f20 = b9d037f4 199d4350 89105059 9fba8e01
!	%f24 = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	%f28 = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	stda	%f16,[%i3+%g5]ASI_BLK_PL	! Block Store to 000000001d800140

p3_label_173:
!	Mem[000000001c0000c0] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c0000d0] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c0000e0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c0000f0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x0c0,%g4
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 000000001c0000c0
!	%l3 = 000000000000d6ac, immed = 00000562, %y  = 00000073
	smul	%l3,0x562,%l2		! %l2 = 00000000048389d8
!	Mem[000000001d00000c] = 17e0a64b, %l6 = 000000000000d31b
	ldsw	[%i2+0x00c],%l6		! %l6 = 0000000017e0a64b
!	Mem[0000000070800018] = b5c9feb9, %l3 = 000000000000d6ac
	lduba	[%o1+0x01a]%asi,%l3	! %l3 = 00000000000000fe
	bn,a	p3_not_taken_0		! Branch Not Taken, %ccr = 88

p3_label_174:
!	Mem[0000000070000058] = d31b1a2573e79db9, %l0 = 00000000d31b1a25
	ldx	[%o0+0x058],%l0		! Annulled
p3_b55:
!	Mem[0000000071000058] = 00000000, %l7 = 000000000000009e
	ldsw	[%o2+0x058],%l7		! %l7 = 0000000000000000
!	Mem[000000001c800078] = 60c13a78, %l7 = 0000000000000000
	ldswa	[%i1+0x078]%asi,%l7	! %l7 = 0000000060c13a78
!	Mem[000000001d800080] = 00000000 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800090] = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	Mem[000000001d8000a0] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d8000b0] = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x080,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f16	! Block Load from 000000001d800080
!	Mem[000000001e800008] = a755a393, %l2 = 00000000048389d8
	ldsha	[%i5+%o6]0x80,%l2	! %l2 = ffffffffffffa755

p3_label_175:
!	Mem[0000000071800058] = 79c52bb5, %l5 = ab224f7c42717296
	lduha	[%o3+0x058]%asi,%l5	! %l5 = 00000000000079c5
!	%f16 = 1a6de0fe 00000000 4ba6e017 a00ffb8f
!	%f20 = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	%f24 = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	%f28 = c89763f6 66926f10 aea36c79 10bfa683
	stda	%f16,[%i3]ASI_BLK_P	! Block Store to 000000001d800000
	bvs	p3_not_taken_0		! Branch Not Taken, %ccr = 88
!	%l3 = 00000000000000fe, immed = 00000f2f, %l0 = 00000000d31b1a25
	xor	%l3,0xf2f,%l0		! %l0 = 0000000000000fd1
p3_b56:
!	Mem[000000001c000140] = 23a86afc 0b931a1e 00000000 9460d876
!	Mem[000000001c000150] = 9222357b d040cce7 4a1e29e5 e16e6bc7
!	Mem[000000001c000160] = 41e28c1b 0ec00000 7a50e9a8 1ae0d579
!	Mem[000000001c000170] = 59c320fe e6321e0b 71743dcd ba241389
	mov	0x140,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c000140

p3_label_176:
!	%f23 = 4ee3a42e, %f17 = 00000000, %f29 = 66926f10
	fsubs	%f23,%f17,%f29		! %f29 = 4ee3a42e
!	Mem[000000001c000188] = feed0958517d32cf, %l6 = 0000000017e0a64b
	ldx	[%i0+0x188],%l6		! %l6 = feed0958517d32cf
	membar	#Sync			! Added by membar checker (196)
!	Branch On Register, %l3 = 00000000000000fe
	brgez,a,pn %l3,p3_b57		! Branch Taken
!	Mem[000000001c000018] = b2162a2e4ee3a42e, %l6 = feed0958517d32cf
	ldx	[%i0+0x018],%l6		! %l6 = b2162a2e4ee3a42e
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p3_branch_failed
	mov	0x039,%g2
p3_b57:
!	Mem[000000001d000158] = 4a1e29e5e16e6bc7, %l5 = 00000000000079c5
	ldx	[%i2+0x158],%l5		! %l5 = 4a1e29e5e16e6bc7

p3_label_177:
!	Mem[0000000072000074] = 66926f10, %l7 = 0000000060c13a78
	lduha	[%o4+0x074]%asi,%g2	! %g2 = 0000000000006692
!	Mem[0000000071000058] = 0000000000000029, %l2 = ffffffffffffa755
	ldx	[%o2+0x058],%l2		! %l2 = 0000000000000029
!	Mem[0000000071000058] = 00000000, %l6 = b2162a2e4ee3a42e
	ldsw	[%o2+0x058],%l6		! %l6 = 0000000000000000
!	Mem[000000001d800140] = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	Mem[000000001d800150] = 50439d19 f437d0b9 018eba9f 59501089
!	Mem[000000001d800160] = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	Mem[000000001d800170] = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	ldda	[%i3+%g5]ASI_BLK_P,%f0	! Block Load from 000000001d800140
!	Mem[000000001d800000] = 1a6de0fe, %l6 = 0000000000000000
	lduwa	[%i3+%g0]0x80,%l6	! %l6 = 000000001a6de0fe

p3_label_178:
!	Mem[000000001d800140] = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	Mem[000000001d800150] = 50439d19 f437d0b9 018eba9f 59501089
!	Mem[000000001d800160] = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	Mem[000000001d800170] = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 000000001d800140
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	stda	%f0,[%i3+%g4]ASI_BLK_P	! Block Store to 000000001d8000c0
	membar	#Sync
	bcs	p3_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[000000001c000008] = 00000029, %l6 = 000000001a6de0fe
	lduwa	[%i0+%o6]0x80,%l6	! %l6 = 0000000000000029
p3_b58:
	set	p3_b59,%o7
	fbule	p3_far_2_le		! Branch Taken, %fcc0 = 0

p3_label_179:
!	Mem[000000001d0001fc] = a4a9e63d, %l1 = ffffffffffffff98
	ldsh	[%i2+0x1fe],%l1		! %l1 = ffffffffffffe63d
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p3_branch_failed
	mov	0x03b,%g2
p3_b59:
!	Registers modified during the branch to p3_far_2
!	%l4  = 0000000000006d1a
!	%f16 = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f20 = 50439d19 f437d0b9 018eba9f 59501089
!	%f24 = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f28 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x100,%g5
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 000000001c000100
!	call to call_0, CWP = 0
	membar	#Sync			! Added by membar checker (197)
	call	p3_call_0_le
!	%l6 = 0000000000000029, %l4 = 0000000000006d1a, %l4 = 0000000000006d1a
	andcc	%l6,%l4,%l4		! %l4 = 0000000000000008, %ccr = 00
!	Registers modified during the branch to p3_call_0
!	%l4  = 5d54a9c50a830851
!	%l5  = 000000000000002a
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x080,%g5
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 000000001d000080

p3_label_180:
!	Mem[0000000072000020] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
	prefetcha [%o4+0x020]%asi,16
!	Mem[000000001d000008] = 8ffb0fa017e0a64b, %l3 = 00000000000000fe
	ldxa	[%i2+%o6]0x80,%l3	! %l3 = 8ffb0fa017e0a64b
!	Mem[000000001c000100] = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	Mem[000000001c000110] = b9d037f4 199d4350 89105059 9fba8e01
!	Mem[000000001c000120] = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	Mem[000000001c000130] = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	mov	0x100,%g5
	ldda	[%i0+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001c000100
	bpos	p3_b60			! Branch Taken, %ccr = 00, CWP = 0
!	%f31 = cba38ddc, %f16 = 6a1153e4
	fstoi	%f31,%f16		! %f16 = feb8e448
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p3_branch_failed
	mov	0x03c,%g2
p3_b60:

p3_label_181:
!	Mem[000000001c000000] = 1a6de0fe f272cb34, %l4 = 0a830851, %l5 = 0000002a
	ldda	[%i0+%g0]0x80,%l4	! %l4 = 000000001a6de0fe 00000000f272cb34
!	Mem[000000001d80017c] = cba38ddc, %l4 = 000000001a6de0fe
	lduw	[%i3+0x17c],%l4		! %l4 = 00000000cba38ddc
	membar	#Sync			! Added by membar checker (198)
!	%f16 = feb8e448 5cc29729 e1cdada7 f4f8b17b
!	%f20 = 50439d19 f437d0b9 018eba9f 59501089
!	%f24 = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f28 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x080,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 000000001d000080
!	Mem[0000000070000018] = 4ba6e017, %l2 = 00000029, %l4 = cba38ddc
	add	%o0,0x18,%g1
	casa	[%g1]0x80,%l2,%l4	! %l4 = 000000004ba6e017
!	%f0  = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	%f4  = 50439d19 f437d0b9 018eba9f 59501089
!	%f8  = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f12 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x180,%g4
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c800180

p3_label_182:
!	Mem[0000000072000008] = 7c8619ff, %l5 = 00000000f272cb34
	ldswa	[%o4+0x008]%asi,%g2	! %g2 = 00000000f272cb34
!	%f16 = feb8e448 5cc29729 e1cdada7 f4f8b17b
!	%f20 = 50439d19 f437d0b9 018eba9f 59501089
!	%f24 = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f28 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	stda	%f16,[%o4+%g6]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000070800018] = b5c9feb9 0000d6ac, %l6 = 00000029, %l7 = 60c13a78
	ldd	[%o1+0x018],%l6		! %l6 = 00000000b5c9feb9 000000000000d6ac
!	Mem[000000007180001c] = 2e2a0029, %l7 = 000000000000d6ac
	ldub	[%o3+0x01c],%l7		! %l7 = 000000000000002e
!	Mem[000000001c800130] = 106f9266, %l3 = 8ffb0fa017e0a64b
	ldub	[%i1+0x130],%l3		! %l3 = 0000000000000010

p3_label_183:
!	Mem[000000001d0000c0] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d0000d0] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d0000e0] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d0000f0] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x0c0,%g6
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 000000001d0000c0
!	%f16 = feb8e448 5cc29729 e1cdada7 f4f8b17b
!	%f20 = 50439d19 f437d0b9 018eba9f 59501089
!	%f24 = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	%f28 = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x080,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 000000001d800080
!	Mem[000000001d800000] = 1a6de0fe, %l6 = 00000000b5c9feb9
	ldsba	[%i3+%g0]0x80,%l6	! %l6 = 000000000000001a
!	%l4 = 000000004ba6e017, %l5 = 00000000f272cb34, %l1 = ffffffffffffe63d
	andcc	%l4,%l5,%l1		! %l1 = 000000004222c014, %ccr = 00
	membar	#Sync
	set	p3_b61,%o7
	fblg,pn	%fcc1,p3_near_2_le	! Branch Taken, %fcc1 = 2

p3_label_184:
!	Mem[000000007100005c] = 00000029, %l2 = 0000000000000029
	lduh	[%o2+0x05e],%l2		! %l2 = 0000000000000029
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p3_branch_failed
	mov	0x03d,%g2
p3_b61:
!	Registers modified during the branch to p3_near_2
!	%l2  = 00000000000029e5
!	%l5  = ab224f7c42717296
!	%l6  = 000000000000d31b
!	%l7  = 0000000000000000
!	Mem[000000001c800040] = 5a07b363 7bfcc498 cf327d51 5809edfe
!	Mem[000000001c800050] = 1539cfd3 5db07b00 0affdcf4 f2947be2
!	Mem[000000001c800060] = f976e8ef 985940be 1f5436a0 0b878429
!	Mem[000000001c800070] = 13073cec 3107506a 60c13a78 9616755f
	mov	0x040,%g6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 000000001c800040
!	Mem[000000001c000170] = 59c320fe, %l3 = 0000000000000010
	ldsha	[%i0+0x170]%asi,%l3	! %l3 = 00000000000059c3
!	Mem[000000001d8000c0] = 6a1153e4 5cc29729 e1cdada7 f4f8b17b
!	Mem[000000001d8000d0] = 50439d19 f437d0b9 018eba9f 59501089
!	Mem[000000001d8000e0] = 3cea7be3 0565d61b d4d274c1 8ded4d6c
!	Mem[000000001d8000f0] = e0c3dde5 a3404987 3de6a9a4 cba38ddc
	mov	0x0c0,%g4
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001d8000c0
!	Mem[0000000071000058] = 0000000000000029, %l2 = 00000000000029e5
	ldx	[%o2+0x058],%l2		! %l2 = 0000000000000029

p3_label_185:
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 000000001c000040
	membar	#Sync
!	Branch On Register, %l5 = ab224f7c42717296
	brgz,a,pt %l5,p3_not_taken_0	! Branch Not Taken
!	Mem[000000007200002c] = f6d75477, %l4 = 000000004ba6e017
	lduh	[%o4+0x02e],%g2		! Annulled
p3_b62:
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f0,[%i1+%g5]ASI_BLK_P	! Block Store to 000000001c800100
!	Mem[0000000071000058] = 00000000 00000029, %l2 = 00000029, %l3 = 000059c3
	ldda	[%o2+0x058]%asi,%l2	! %l2 = 0000000000000000 0000000000000029

p3_label_186:
!	Mem[0000000072000000] = 9869fed2 dfd7cf9e 7c8619ff ea422142
!	Mem[0000000072000010] = 0128ab9a 6fee7c5a d257f6ba 0000803f
!	Mem[0000000072000020] = dc6207a3 f4c1a9ac 73e847c5 997df6d7
!	Mem[0000000072000030] = 54778150 c252c6a8 ab224f7c 42717296
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[000000007080001c] = 0000d6ac, %l1 = 000000004222c014
	ldsw	[%o1+0x01c],%l1		! %l1 = 000000000000d6ac
!	%l0 = 0000000000000fd1, immed = fffffcdf, %y  = 00000000
	umulcc	%l0,-0x321,%l6		! %l6 = 00000fd0ffce830f, %ccr = 08
!	Mem[000000007000005c] = 73e79db9, %l6 = 00000fd0ffce830f
	ldsw	[%o0+0x05c],%l6		! %l6 = 0000000073e79db9
!	Mem[000000001c000008] = 00000029, %l6 = 0000000073e79db9
	lduba	[%i0+%o6]0x80,%l6	! %l6 = 0000000000000000

p3_label_187:
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000001d000000] = fb5772f2, %l2 = 0000000000000000
	ldswa	[%i2+%g0]0x80,%l2	! %l2 = fffffffffb5772f2
!	Mem[000000001c800000] = 9869fed2, %l2 = fffffffffb5772f2
	lduha	[%i1+%g0]0x80,%l2	! %l2 = 0000000000009869
!	Mem[0000000071800018] = 2ea4e34e 2e2a0029, %l6 = 00000000, %l7 = 00000000
	ldd	[%o3+0x018],%l6		! %l6 = 000000002ea4e34e 000000002e2a0029
!	Mem[000000007100005c] = 00000029, %l7 = 000000002e2a0029
	lduw	[%o2+0x05c],%l7		! %l7 = 0000000000000029

p3_label_188:
!	Mem[000000001c00009c] = 2e2a16b2, %l2 = 0000000000009869
	ldsw	[%i0+0x09c],%l2		! %l2 = 000000002e2a16b2
!	%l0 = 0000000000000fd1
	setx	0xa4ed8dc9a4ed8dc9,%g7,%l0 ! %l0 = a4ed8dc9a4ed8dc9
!	Mem[0000000070800058] = f92f1bc5 b0d9076b, %l4 = 4ba6e017, %l5 = 42717296
	ldda	[%o1+0x058]%asi,%l4	! %l4 = 00000000f92f1bc5 00000000b0d9076b
!	Mem[000000007100001c] = fa88dc14, %l0 = a4ed8dc9a4ed8dc9
	ldub	[%o2+0x01d],%l0		! %l0 = 0000000000000088
!	%f16 = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	%f20 = b9d037f4 199d4350 89105059 9fba8e01
!	%f24 = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	%f28 = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	mov	0x080,%g6
	stda	%f16,[%i3+%g6]ASI_BLK_PL	! Block Store to 000000001d800080

p3_label_189:
!	%f16 = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	%f20 = b9d037f4 199d4350 89105059 9fba8e01
!	%f24 = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	%f28 = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 000000001d000080
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x040,%g6
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 000000001d800040
!	%l6 = 000000002ea4e34e, %l4 = 00000000f92f1bc5, %y  = 00000fd0
	sdiv	%l6,%l4,%l3		! %l3 = fffffffffffdae14
	mov	%l0,%y			! %y = 00000088
	membar	#Sync
	set	p3_b63,%o7
	fbuge	p3_far_3_he		! Branch Taken, %fcc0 = 0
!	Mem[000000001d0001dc] = 9fba8e01, %l5 = 00000000b0d9076b
	ldsh	[%i2+0x1dc],%l5		! %l5 = ffffffffffff9fba
!	The following code should not be executed
	fdtos	%f12,%f4
	stda	%f32,[%i4]ASI_BLK_PL
	lduba	[%i3+0x0e3]%asi,%l1
	ldda	[%o2+0x000]%asi,%l0
	stda	%f16,[%i3]ASI_BLK_PL
	lduwa	[%i3+0x0d0]%asi,%l2
	ldda	[%i6]ASI_BLK_P,%f32
	ba	p3_branch_failed
	mov	0x03f,%g2
p3_b63:
!	Registers modified during the branch to p3_far_3
!	%l6  = 4ba6e017a00ffb8f

p3_label_190:
!	%f0  = e064cced 2de9875e 3e51673d 31776a93
!	%f4  = 2f467805 e8922323 ae103a64 0e1430c3
!	%f8  = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	%f12 = eab0f286 9053fabb 68c6a9d3 b7552a83
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[000000001d800008] = 4ba6e017, %l0 = 0000000000000088
	lduha	[%i3+%o6]0x80,%l0	! %l0 = 0000000000004ba6
!	%f16 = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	%f20 = b9d037f4 199d4350 89105059 9fba8e01
!	%f24 = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	%f28 = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	mov	0x080,%g4
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 000000001c800080
!	Mem[000000001d000180] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001d000190] = 00000000 0000f03f b2162a2e f2814628
!	Mem[000000001d0001a0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001d0001b0] = c89763f6 66926f10 aea36c79 10bfa683
	mov	0x180,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 000000001d000180
!	%l3 = fffffffffffdae14, immed = fffffd4e, %l7 = 0000000000000029
	or	%l3,-0x2b2,%l7		! %l7 = ffffffffffffff5e

p3_label_191:
!	Mem[000000001c000178] = 71743dcdba241389, %l6 = 4ba6e017a00ffb8f
	ldx	[%i0+0x178],%l6		! %l6 = 71743dcdba241389
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 3ff00000 00000000 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	mov	0x1c0,%g5
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 000000001c0001c0
!	%f16 = 2997c25c e453116a 7bb1f8f4 a7adcde1
!	%f20 = b9d037f4 199d4350 89105059 9fba8e01
!	%f24 = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	%f28 = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	mov	0x0c0,%g4
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 000000001d0000c0
!	%f0  = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f4  = 3ff00000 00000000 284681f2 2e2a16b2
!	%f8  = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f12 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 000000001d800000
	membar	#Sync			! Added by membar checker (199)
!	Mem[000000001d800000] = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	Mem[000000001d800010] = 3ff00000 00000000 284681f2 2e2a16b2
!	Mem[000000001d800020] = 8699b605 918c5d1b 1f1e56b9 934b097b
!	Mem[000000001d800030] = 106f9266 f66397c8 83a6bf10 796ca3ae
	ldda	[%i3]ASI_BLK_P,%f16	! Block Load from 000000001d800000

p3_label_192:
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 3ff00000 00000000 284681f2 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i1+%g4]ASI_BLK_PL	! Block Store to 000000001c8000c0
!	Mem[0000000071000058] = 00000000, %l7 = ffffffffffffff5e
	lduha	[%o2+0x05a]%asi,%l7	! %l7 = 0000000000000000
	membar	#Sync			! Added by membar checker (200)
!	Mem[000000001c8000d4] = 0000f03f, %l6 = 71743dcdba241389
	ldsba	[%i1+0x0d5]%asi,%l6	! %l6 = 0000000000000000
!	Mem[000000001d800040] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[000000001d800050] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[000000001d800060] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[000000001d800070] = eab0f286 9053fabb 68c6a9d3 b7552a83
	mov	0x040,%g5
	ldda	[%i3+%g5]ASI_BLK_PL,%f0	! Block Load from 000000001d800040
!	Mem[000000001c0000c0] = 1a6de0fe f272cb34 4ba6e017 a00ffb8f
!	Mem[000000001c0000d0] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c0000e0] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c0000f0] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 000000001c0000c0

p3_label_193:
!	Mem[000000001d000090] = 50439d19, %l5 = ffffffffffff9fba
	ldswa	[%i2+0x090]%asi,%l5	! %l5 = 0000000050439d19
!	Mem[0000000070800058] = f92f1bc5, %l2 = 000000002e2a16b2
	lduha	[%o1+0x058]%asi,%l2	! %l2 = 000000000000f92f
!	Mem[0000000071800058] = 79c52bb5985940be, %l6 = 0000000000000000
	ldxa	[%o3+0x058]%asi,%l6	! %l6 = 79c52bb5985940be
!	%f0  = 5e87e92d, %f1  = edcc64e0, %f0  = 5e87e92d edcc64e0
	fsmuld	%f0 ,%f1 ,%f0 		! %f0  = c99b20d7 7766d800
!	%f10 = a430acd6 b5d375d3, %f10 = a430acd6 b5d375d3, %f6  = c330140e 643a10ae
	faddd	%f10,%f10,%f6 		! %f6  = a440acd6 b5d375d3

p3_label_194:
	be	p3_not_taken_0		! Branch Not Taken, %ccr = 00
!	Mem[0000000071000018] = 9431d876fa88dc14, %l3 = fffffffffffdae14
	ldx	[%o2+0x018],%l3		! %l3 = 9431d876fa88dc14
p3_b64:
!	Mem[000000001d80014c] = f4f8b17b, %l3 = 9431d876fa88dc14
	ldsh	[%i3+0x14c],%l3		! %l3 = fffffffffffff4f8
	membar	#Sync			! Added by membar checker (201)
	set	p3_b65,%o7
	fbe	p3_far_0_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000071800018] = 2ea4e34e2e2a0029, %l2 = 000000000000f92f
	ldx	[%o3+0x018],%l2		! %l2 = 2ea4e34e2e2a0029
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p3_branch_failed
	mov	0x041,%g2
p3_b65:
!	Registers modified during the branch to p3_far_0
!	%l1  = 00000000985940be
!	%l2  = 00000000f92f1bc5
!	%l5  = 2ea4e34e2e2a0029

p3_label_195:
!	Mem[0000000072000040] = 2997c25c 48e4b8fe 7bb1f8f4 a7adcde1
!	Mem[0000000072000050] = b9d037f4 199d4350 89105059 9fba8e01
!	Mem[0000000072000060] = 1bd66505 e37bea3c 6c4ded8d c174d2d4
!	Mem[0000000072000070] = 874940a3 e5ddc3e0 dc8da3cb a4a9e63d
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	%f0  = c99b20d7 7766d800 936a7731 3d67513e
!	%f4  = 232392e8 0578462f a440acd6 b5d375d3
!	%f8  = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f12 = bbfa5390 86f2b0ea 832a55b7 d3a9c668
	stda	%f0,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
	membar	#Sync			! Added by membar checker (202)
!	Mem[000000007200007c] = 552a8300, %l7 = 0000000000000000
	ldsb	[%o4+0x07d],%g2		! %g2 = 0000000000000055
!	Mem[0000000072000000] = e064cced 2de9875e 3e51673d 31776a93
!	Mem[0000000072000010] = 2f467805 e8922323 ae103a64 0e1430c3
!	Mem[0000000072000020] = 720eb292 1664ae9c d375d3b5 d6ac30a4
!	Mem[0000000072000030] = eab0f286 9053fabb 68c6a9d3 b7552a83
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	Mem[000000001d000008] = 8ffb0fa0, %l1 = 00000000985940be
	lduha	[%i2+%o6]0x80,%l1	! %l1 = 0000000000008ffb

p3_label_196:
!	%l2 = 00000000f92f1bc5, Mem[000000001d000096] = f437d0b9
	sth	%l2,[%i2+0x096]		! Mem[000000001d000094] = f4371bc5
!	%l4 = 00000000f92f1bc5, %l6 = 79c52bb5985940be, %l5 = 2ea4e34e2e2a0029
	xnor	%l4,%l6,%l5		! %l5 = 863ad44a9e89a484
!	Mem[0000000071000018] = 9431d876, %l0 = 0000000000004ba6
	lduha	[%o2+0x018]%asi,%l0	! %l0 = 0000000000009431
	bvc	p3_b66			! Branch Taken, %ccr = 08, CWP = 0
!	%f26 = 1f1e56b9 934b097b, Mem[0000000070800018] = b5c9feb9 0000d6ac
	std	%f26,[%o1+0x018]	! Mem[0000000070800018] = 1f1e56b9 934b097b
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p3_branch_failed
	mov	0x042,%g2
p3_b66:

p3_label_197:
!	%f20 = 593a34d7 b8374ed2, %f4  = 232392e8 0578462f
	fabsd	%f20,%f4 		! %f4  = 593a34d7 b8374ed2
	fbug,pt	%fcc2,p3_branch_failed	! Branch Not Taken, %fcc2 = 0
!	%l7 = 0000000000000000, immed = 00000546, %l1 = 0000000000008ffb
	orncc	%l7,0x546,%l1		! %l1 = fffffffffffffab9, %ccr = 88
p3_b67:
!	%f16 = 34cb72f2 fee06d1a 8ffb0fa0 17e0a64b
!	%f20 = 593a34d7 b8374ed2 2ea4e34e 2e2a16b2
!	%f24 = 8699b605 918c5d1b 1f1e56b9 934b097b
!	%f28 = 106f9266 f66397c8 83a6bf10 796ca3ae
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 000000001c000040
!	%f0  = c99b20d7 7766d800 936a7731 3d67513e
!	%f4  = 593a34d7 b8374ed2 a440acd6 b5d375d3
!	%f8  = 9cae6416 92b20e72 a430acd6 b5d375d3
!	%f12 = bbfa5390 86f2b0ea 832a55b7 d3a9c668
	mov	0x100,%g5
	stda	%f0,[%i3+%g5]ASI_BLK_P	! Block Store to 000000001d800100

p3_label_198:
!	%l3 = fffffffffffff4f8, immed = 00000c52, %l1 = fffffffffffffab9
	and	%l3,0xc52,%l1		! %l1 = 0000000000000450
!	%l0 = 0000000000009431, %l5 = 863ad44a9e89a484, %l0 = 0000000000009431
	and	%l0,%l5,%l0		! %l0 = 0000000000008400
	membar	#Sync
!	Branch On Register, %l7 = 0000000000000000
	brgez,pt %l7,p3_b68		! Branch Taken
!	Mem[0000000071000058] = 00000000, %l3 = fffffffffffff4f8
	lduh	[%o2+0x058],%l3		! %l3 = 0000000000000000
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p3_branch_failed
	mov	0x044,%g2
p3_b68:
!	Mem[000000001d000000] = fb5772f2 fee06d1a, %l0 = 00008400, %l1 = 00000450
	ldda	[%i2+%g0]0x80,%l0	! %l0 = 00000000fb5772f2 00000000fee06d1a

p3_label_199:
	fbuge,pn %fcc3,p3_branch_failed	! Branch Not Taken, %fcc3 = 1
!	Mem[000000001d0001e0] = 1bd66505e37bea3c, %l0 = 00000000fb5772f2
	ldx	[%i2+0x1e0],%l0		! %l0 = 1bd66505e37bea3c
p3_b69:
!	Mem[0000000070000058] = d31b1a2573e79db9, %l3 = 0000000000000000
	ldx	[%o0+0x058],%l3		! %l3 = d31b1a2573e79db9
!	Mem[0000000072000064] = 1664ae9c, %l5 = 863ad44a9e89a484
	ldsw	[%o4+0x064],%g2		! %g2 = 863ad44a9e89a484
!	Mem[000000007080005c] = b0d9076b, %l6 = 79c52bb5985940be
	lduwa	[%o1+0x05c]%asi,%l6	! %l6 = 00000000b0d9076b

p3_label_200:
!	Mem[0000000070800058] = f92f1bc5b0d9076b, %l2 = 00000000f92f1bc5
	ldx	[%o1+0x058],%l2		! %l2 = f92f1bc5b0d9076b
!	Mem[000000001c000000] = 1a6de0fe f272cb34 00000029 a00ffb8f
!	Mem[000000001c000010] = d24e37b8 d7343a59 b2162a2e 4ee3a42e
!	Mem[000000001c000020] = 1b5d8c91 05b69986 7b094b93 b9561e1f
!	Mem[000000001c000030] = c89763f6 66926f10 aea36c79 10bfa683
	ldda	[%i0]ASI_BLK_PL,%f0	! Block Load from 000000001c000000
!	%l7 = 0000000000000000, immed = 00000043, %l2 = f92f1bc5b0d9076b
	addccc	%l7,0x043,%l2		! %l2 = 0000000000000043, %ccr = 00
	bcs,a	p3_not_taken_0		! Branch Not Taken, %ccr = 00
!	%l1 = 00000000fee06d1a, %l4 = 00000000f92f1bc5, %l6 = 00000000b0d9076b
	addcc	%l1,%l4,%l6		! Annulled
	nop
p3_b70:
	nop
	nop

1:	membar	#Sync			! Force all stores to complete

!	End of Random Code for Processor 3

	mov	2,%g2
	set	done_flags,%g1
	st	%g2,[%g1+0x00c]		! Set processor 3 done flag

!	Check Registers

p3_check_registers:
	set	p3_expected_registers,%g1
	ldx	[%g1+0x000],%g2
	cmp	%l0,%g2			! %l0 should be 1bd66505e37bea3c
	bne,a,pn %xcc,p3_reg_l0_fail
	mov	%l0,%g3
	ldx	[%g1+0x008],%g2
	cmp	%l1,%g2			! %l1 should be 00000000fee06d1a
	bne,a,pn %xcc,p3_reg_l1_fail
	mov	%l1,%g3
	ldx	[%g1+0x010],%g2
	cmp	%l2,%g2			! %l2 should be 0000000000000043
	bne,a,pn %xcc,p3_reg_l2_fail
	mov	%l2,%g3
	ldx	[%g1+0x018],%g2
	cmp	%l3,%g2			! %l3 should be d31b1a2573e79db9
	bne,a,pn %xcc,p3_reg_l3_fail
	mov	%l3,%g3
	ldx	[%g1+0x020],%g2
	cmp	%l4,%g2			! %l4 should be 00000000f92f1bc5
	bne,a,pn %xcc,p3_reg_l4_fail
	mov	%l4,%g3
	ldx	[%g1+0x028],%g2
	cmp	%l5,%g2			! %l5 should be 863ad44a9e89a484
	bne,a,pn %xcc,p3_reg_l5_fail
	mov	%l5,%g3
	ldx	[%g1+0x030],%g2
	cmp	%l6,%g2			! %l6 should be 00000000b0d9076b
	bne,a,pn %xcc,p3_reg_l6_fail
	mov	%l6,%g3
	ldx	[%g1+0x038],%g2
	cmp	%l7,%g2			! %l7 should be 0000000000000000
	bne,a,pn %xcc,p3_reg_l7_fail
	mov	%l7,%g3

!	Check %y register

	set	0x000004b7,%g2
	rd	%y,%g3
	cmp	%g2,%g3
	bne,a	p3_failed
	mov	0x111,%g1

!	Check Floating Point Registers

p3_check_fp_registers:
	set	p3_temp,%g1
	set	p3_expected_fp_regs,%g3
	std	%f0,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x00],%l0
	cmp	%l0,%l1			! %f0  should be 34cb72f2 fee06d1a
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf00,%g1
	std	%f2,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x08],%l0
	cmp	%l0,%l1			! %f2  should be 8ffb0fa0 29000000
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf02,%g1
	std	%f4,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x10],%l0
	cmp	%l0,%l1			! %f4  should be 593a34d7 b8374ed2
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf04,%g1
	std	%f6,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x18],%l0
	cmp	%l0,%l1			! %f6  should be 2ea4e34e 2e2a16b2
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf06,%g1
	std	%f8,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x20],%l0
	cmp	%l0,%l1			! %f8  should be 8699b605 918c5d1b
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf08,%g1
	std	%f10,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x28],%l0
	cmp	%l0,%l1			! %f10 should be 1f1e56b9 934b097b
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf10,%g1
	std	%f12,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x30],%l0
	cmp	%l0,%l1			! %f12 should be 106f9266 f66397c8
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf12,%g1
	std	%f14,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x38],%l0
	cmp	%l0,%l1			! %f14 should be 83a6bf10 796ca3ae
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf14,%g1
	std	%f16,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x40],%l0
	cmp	%l0,%l1			! %f16 should be 34cb72f2 fee06d1a
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf16,%g1
	std	%f18,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x48],%l0
	cmp	%l0,%l1			! %f18 should be 8ffb0fa0 17e0a64b
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf18,%g1
	std	%f20,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x50],%l0
	cmp	%l0,%l1			! %f20 should be 593a34d7 b8374ed2
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf20,%g1
	std	%f22,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x58],%l0
	cmp	%l0,%l1			! %f22 should be 2ea4e34e 2e2a16b2
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf22,%g1
	std	%f24,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x60],%l0
	cmp	%l0,%l1			! %f24 should be 8699b605 918c5d1b
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf24,%g1
	std	%f26,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x68],%l0
	cmp	%l0,%l1			! %f26 should be 1f1e56b9 934b097b
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf26,%g1
	std	%f28,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x70],%l0
	cmp	%l0,%l1			! %f28 should be 106f9266 f66397c8
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf28,%g1
	std	%f30,[%g1]
	ldx	[%g1],%l1
	ldx	[%g3+0x78],%l0
	cmp	%l0,%l1			! %f30 should be 83a6bf10 796ca3ae
	bne,a,pn	%xcc,p3_freg_fail
	or	%g0,0xf30,%g1

!	Check Local Memory

	set	p3_local0_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 1a6de0fef272cb34
	ldx	[%i0+0x000],%g3		! Observed data at 000000001c000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 00000029a00ffb8f
	ldx	[%i0+0x008],%g3		! Observed data at 000000001c000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = d24e37b8d7343a59
	ldx	[%i0+0x010],%g3		! Observed data at 000000001c000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = b2162a2e4ee3a42e
	ldx	[%i0+0x018],%g3		! Observed data at 000000001c000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 1b5d8c9105b69986
	ldx	[%i0+0x020],%g3		! Observed data at 000000001c000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 7b094b93b9561e1f
	ldx	[%i0+0x028],%g3		! Observed data at 000000001c000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = c89763f666926f10
	ldx	[%i0+0x030],%g3		! Observed data at 000000001c000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = aea36c7910bfa683
	ldx	[%i0+0x038],%g3		! Observed data at 000000001c000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 34cb72f2fee06d1a
	ldx	[%i0+0x040],%g3		! Observed data at 000000001c000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i0+0x048],%g3		! Observed data at 000000001c000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 593a34d7b8374ed2
	ldx	[%i0+0x050],%g3		! Observed data at 000000001c000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 2ea4e34e2e2a16b2
	ldx	[%i0+0x058],%g3		! Observed data at 000000001c000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i0+0x060],%g3		! Observed data at 000000001c000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i0+0x068],%g3		! Observed data at 000000001c000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i0+0x070],%g3		! Observed data at 000000001c000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i0+0x078],%g3		! Observed data at 000000001c000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 00000000fee06d1a
	ldx	[%i0+0x080],%g3		! Observed data at 000000001c000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i0+0x088],%g3		! Observed data at 000000001c000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 593a34d7b8374ed2
	ldx	[%i0+0x090],%g3		! Observed data at 000000001c000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 2ea4e34e2e2a16b2
	ldx	[%i0+0x098],%g3		! Observed data at 000000001c000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i0+0x0a0],%g3		! Observed data at 000000001c0000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i0+0x0a8],%g3		! Observed data at 000000001c0000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i0+0x0b0],%g3		! Observed data at 000000001c0000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i0+0x0b8],%g3		! Observed data at 000000001c0000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 1a6de0fef272cb34
	ldx	[%i0+0x0c0],%g3		! Observed data at 000000001c0000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 4ba6e017a00ffb8f
	ldx	[%i0+0x0c8],%g3		! Observed data at 000000001c0000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = d24e37b8d7343a59
	ldx	[%i0+0x0d0],%g3		! Observed data at 000000001c0000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = b2162a2e4ee3a42e
	ldx	[%i0+0x0d8],%g3		! Observed data at 000000001c0000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 1b5d8c9105b69986
	ldx	[%i0+0x0e0],%g3		! Observed data at 000000001c0000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 7b094b93b9561e1f
	ldx	[%i0+0x0e8],%g3		! Observed data at 000000001c0000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = c89763f666926f10
	ldx	[%i0+0x0f0],%g3		! Observed data at 000000001c0000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = aea36c7910bfa683
	ldx	[%i0+0x0f8],%g3		! Observed data at 000000001c0000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 2997c25ce453116a
	ldx	[%i0+0x100],%g3		! Observed data at 000000001c000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 7bb1f8f4a7adcde1
	ldx	[%i0+0x108],%g3		! Observed data at 000000001c000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = b9d037f4199d4350
	ldx	[%i0+0x110],%g3		! Observed data at 000000001c000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = 891050599fba8e01
	ldx	[%i0+0x118],%g3		! Observed data at 000000001c000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 1bd66505e37bea3c
	ldx	[%i0+0x120],%g3		! Observed data at 000000001c000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 6c4ded8dc174d2d4
	ldx	[%i0+0x128],%g3		! Observed data at 000000001c000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = 874940a3e5ddc3e0
	ldx	[%i0+0x130],%g3		! Observed data at 000000001c000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = dc8da3cba4a9e63d
	ldx	[%i0+0x138],%g3		! Observed data at 000000001c000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 23a86afc0b931a1e
	ldx	[%i0+0x140],%g3		! Observed data at 000000001c000140
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 000000009460d876
	ldx	[%i0+0x148],%g3		! Observed data at 000000001c000148
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 9222357bd040cce7
	ldx	[%i0+0x150],%g3		! Observed data at 000000001c000150
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 4a1e29e5e16e6bc7
	ldx	[%i0+0x158],%g3		! Observed data at 000000001c000158
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 41e28c1b0ec00000
	ldx	[%i0+0x160],%g3		! Observed data at 000000001c000160
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 7a50e9a81ae0d579
	ldx	[%i0+0x168],%g3		! Observed data at 000000001c000168
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 59c320fee6321e0b
	ldx	[%i0+0x170],%g3		! Observed data at 000000001c000170
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 71743dcdba241389
	ldx	[%i0+0x178],%g3		! Observed data at 000000001c000178
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 98c4fc7b63b3075a
	ldx	[%i0+0x180],%g3		! Observed data at 000000001c000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = feed0958517d32cf
	ldx	[%i0+0x188],%g3		! Observed data at 000000001c000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 007bb05dd3cf3915
	ldx	[%i0+0x190],%g3		! Observed data at 000000001c000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = e27b94f2f4dcff0a
	ldx	[%i0+0x198],%g3		! Observed data at 000000001c000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = be405998efe876f9
	ldx	[%i0+0x1a0],%g3		! Observed data at 000000001c0001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = 18c4fc7b63b3075a
	ldx	[%i0+0x1a8],%g3		! Observed data at 000000001c0001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = 6a500731ec3c0713
	ldx	[%i0+0x1b0],%g3		! Observed data at 000000001c0001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 5f751696783ac160
	ldx	[%i0+0x1b8],%g3		! Observed data at 000000001c0001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 34cb72f2fee06d1a
	ldx	[%i0+0x1c0],%g3		! Observed data at 000000001c0001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i0+0x1c8],%g3		! Observed data at 000000001c0001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 3ff0000000000000
	ldx	[%i0+0x1d0],%g3		! Observed data at 000000001c0001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = 284681f22e2a16b2
	ldx	[%i0+0x1d8],%g3		! Observed data at 000000001c0001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i0+0x1e0],%g3		! Observed data at 000000001c0001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i0+0x1e8],%g3		! Observed data at 000000001c0001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i0+0x1f0],%g3		! Observed data at 000000001c0001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i0+0x1f8],%g3		! Observed data at 000000001c0001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f8,%g4

	set	p3_local1_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 9869fed2dfd7cf9e
	ldx	[%i1+0x000],%g3		! Observed data at 000000001c800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = ff8619ffea422142
	ldx	[%i1+0x008],%g3		! Observed data at 000000001c800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 0128ab9a6fee7c5a
	ldx	[%i1+0x010],%g3		! Observed data at 000000001c800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = d257f6ba7cf18cc7
	ldx	[%i1+0x018],%g3		! Observed data at 000000001c800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = dc6207a3f4c1a9ac
	ldx	[%i1+0x020],%g3		! Observed data at 000000001c800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 73e847c5997df6d7
	ldx	[%i1+0x028],%g3		! Observed data at 000000001c800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 54778150c252c6a8
	ldx	[%i1+0x030],%g3		! Observed data at 000000001c800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = ab224f7c42717296
	ldx	[%i1+0x038],%g3		! Observed data at 000000001c800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 5a07b3637bfcc498
	ldx	[%i1+0x040],%g3		! Observed data at 000000001c800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = cf327d515809edfe
	ldx	[%i1+0x048],%g3		! Observed data at 000000001c800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 1539cfd35db07b00
	ldx	[%i1+0x050],%g3		! Observed data at 000000001c800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 0affdcf4f2947be2
	ldx	[%i1+0x058],%g3		! Observed data at 000000001c800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = f976e8ef985940be
	ldx	[%i1+0x060],%g3		! Observed data at 000000001c800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 1f5436a00b878429
	ldx	[%i1+0x068],%g3		! Observed data at 000000001c800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 13073cec3107506a
	ldx	[%i1+0x070],%g3		! Observed data at 000000001c800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 60c13a789616755f
	ldx	[%i1+0x078],%g3		! Observed data at 000000001c800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 2997c25ce453116a
	ldx	[%i1+0x080],%g3		! Observed data at 000000001c800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = 7bb1f8f4a7adcde1
	ldx	[%i1+0x088],%g3		! Observed data at 000000001c800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = b9d037f4199d4350
	ldx	[%i1+0x090],%g3		! Observed data at 000000001c800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 891050599fba8e01
	ldx	[%i1+0x098],%g3		! Observed data at 000000001c800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 1bd66505e37bea3c
	ldx	[%i1+0x0a0],%g3		! Observed data at 000000001c8000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = 6c4ded8dc174d2d4
	ldx	[%i1+0x0a8],%g3		! Observed data at 000000001c8000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = 874940a3e5ddc3e0
	ldx	[%i1+0x0b0],%g3		! Observed data at 000000001c8000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = dc8da3cba4a9e63d
	ldx	[%i1+0x0b8],%g3		! Observed data at 000000001c8000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 1a6de0fef272cb34
	ldx	[%i1+0x0c0],%g3		! Observed data at 000000001c8000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 4ba6e017a00ffb8f
	ldx	[%i1+0x0c8],%g3		! Observed data at 000000001c8000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 000000000000f03f
	ldx	[%i1+0x0d0],%g3		! Observed data at 000000001c8000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = b2162a2ef2814628
	ldx	[%i1+0x0d8],%g3		! Observed data at 000000001c8000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 1b5d8c9105b69986
	ldx	[%i1+0x0e0],%g3		! Observed data at 000000001c8000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 7b094b93b9561e1f
	ldx	[%i1+0x0e8],%g3		! Observed data at 000000001c8000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = c89763f666926f10
	ldx	[%i1+0x0f0],%g3		! Observed data at 000000001c8000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = aea36c7910bfa683
	ldx	[%i1+0x0f8],%g3		! Observed data at 000000001c8000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = e064cced2de9875e
	ldx	[%i1+0x100],%g3		! Observed data at 000000001c800100
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 3e51673d31776a93
	ldx	[%i1+0x108],%g3		! Observed data at 000000001c800108
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 2f467805e8922323
	ldx	[%i1+0x110],%g3		! Observed data at 000000001c800110
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = ae103a640e1430c3
	ldx	[%i1+0x118],%g3		! Observed data at 000000001c800118
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 720eb2921664ae9c
	ldx	[%i1+0x120],%g3		! Observed data at 000000001c800120
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = d375d3b5d6ac30a4
	ldx	[%i1+0x128],%g3		! Observed data at 000000001c800128
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = eab0f2869053fabb
	ldx	[%i1+0x130],%g3		! Observed data at 000000001c800130
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 68c6a9d3b7552a83
	ldx	[%i1+0x138],%g3		! Observed data at 000000001c800138
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 98c4fc7b63b3075a
	ldx	[%i1+0x140],%g3		! Observed data at 000000001c800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = feed0958517d32cf
	ldx	[%i1+0x148],%g3		! Observed data at 000000001c800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 007bb05dd3cf3915
	ldx	[%i1+0x150],%g3		! Observed data at 000000001c800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = e27b94f2f4dcff0a
	ldx	[%i1+0x158],%g3		! Observed data at 000000001c800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = be405998efe876f9
	ldx	[%i1+0x160],%g3		! Observed data at 000000001c800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 2984870ba036541f
	ldx	[%i1+0x168],%g3		! Observed data at 000000001c800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 6a500731ec3c0713
	ldx	[%i1+0x170],%g3		! Observed data at 000000001c800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 5f751696783ac160
	ldx	[%i1+0x178],%g3		! Observed data at 000000001c800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 6a1153e45cc29729
	ldx	[%i1+0x180],%g3		! Observed data at 000000001c800180
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = e1cdada7f4f8b17b
	ldx	[%i1+0x188],%g3		! Observed data at 000000001c800188
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 50439d19f437d0b9
	ldx	[%i1+0x190],%g3		! Observed data at 000000001c800190
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = 018eba9f59501089
	ldx	[%i1+0x198],%g3		! Observed data at 000000001c800198
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 3cea7be30565d61b
	ldx	[%i1+0x1a0],%g3		! Observed data at 000000001c8001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = d4d274c18ded4d6c
	ldx	[%i1+0x1a8],%g3		! Observed data at 000000001c8001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = e0c3dde5a3404987
	ldx	[%i1+0x1b0],%g3		! Observed data at 000000001c8001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 3de6a9a4cba38ddc
	ldx	[%i1+0x1b8],%g3		! Observed data at 000000001c8001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 9869fed2dfd7cf9e
	ldx	[%i1+0x1c0],%g3		! Observed data at 000000001c8001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 7c8619ffea422142
	ldx	[%i1+0x1c8],%g3		! Observed data at 000000001c8001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = 0128ab9a6fee7c5a
	ldx	[%i1+0x1d0],%g3		! Observed data at 000000001c8001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = d257f6ba7cf18cc7
	ldx	[%i1+0x1d8],%g3		! Observed data at 000000001c8001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = dc6207a3f4c1a9ac
	ldx	[%i1+0x1e0],%g3		! Observed data at 000000001c8001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 73e847c5997df6d7
	ldx	[%i1+0x1e8],%g3		! Observed data at 000000001c8001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 54778150c252c6a8
	ldx	[%i1+0x1f0],%g3		! Observed data at 000000001c8001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = ab224f7c42717296
	ldx	[%i1+0x1f8],%g3		! Observed data at 000000001c8001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f8,%g4

	set	p3_local2_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = fb5772f2fee06d1a
	ldx	[%i2+0x000],%g3		! Observed data at 000000001d000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i2+0x008],%g3		! Observed data at 000000001d000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 593a34d7b8374ed2
	ldx	[%i2+0x010],%g3		! Observed data at 000000001d000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 2ea4e34e2e2a16b2
	ldx	[%i2+0x018],%g3		! Observed data at 000000001d000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i2+0x020],%g3		! Observed data at 000000001d000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i2+0x028],%g3		! Observed data at 000000001d000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i2+0x030],%g3		! Observed data at 000000001d000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i2+0x038],%g3		! Observed data at 000000001d000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 00000000fee06d1a
	ldx	[%i2+0x040],%g3		! Observed data at 000000001d000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i2+0x048],%g3		! Observed data at 000000001d000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 593a34d7b8374ed2
	ldx	[%i2+0x050],%g3		! Observed data at 000000001d000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = 2ea4e34e2e2a16b2
	ldx	[%i2+0x058],%g3		! Observed data at 000000001d000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i2+0x060],%g3		! Observed data at 000000001d000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i2+0x068],%g3		! Observed data at 000000001d000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i2+0x070],%g3		! Observed data at 000000001d000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i2+0x078],%g3		! Observed data at 000000001d000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 6a1153e45cc29729
	ldx	[%i2+0x080],%g3		! Observed data at 000000001d000080
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = e1cdada7f4f8b17b
	ldx	[%i2+0x088],%g3		! Observed data at 000000001d000088
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 50439d19f4371bc5
	ldx	[%i2+0x090],%g3		! Observed data at 000000001d000090
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 018eba9f59501089
	ldx	[%i2+0x098],%g3		! Observed data at 000000001d000098
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 3cea7be30565d61b
	ldx	[%i2+0x0a0],%g3		! Observed data at 000000001d0000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = d4d274c18ded4d6c
	ldx	[%i2+0x0a8],%g3		! Observed data at 000000001d0000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = e0c3dde5a3404987
	ldx	[%i2+0x0b0],%g3		! Observed data at 000000001d0000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 3de6a9a4cba38ddc
	ldx	[%i2+0x0b8],%g3		! Observed data at 000000001d0000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 2997c25ce453116a
	ldx	[%i2+0x0c0],%g3		! Observed data at 000000001d0000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 7bb1f8f4a7adcde1
	ldx	[%i2+0x0c8],%g3		! Observed data at 000000001d0000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = b9d037f4199d4350
	ldx	[%i2+0x0d0],%g3		! Observed data at 000000001d0000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 891050599fba8e01
	ldx	[%i2+0x0d8],%g3		! Observed data at 000000001d0000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 1bd66505e37bea3c
	ldx	[%i2+0x0e0],%g3		! Observed data at 000000001d0000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 6c4ded8dc174d2d4
	ldx	[%i2+0x0e8],%g3		! Observed data at 000000001d0000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 874940a3e5ddc3e0
	ldx	[%i2+0x0f0],%g3		! Observed data at 000000001d0000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = dc8da3cba4a9e63d
	ldx	[%i2+0x0f8],%g3		! Observed data at 000000001d0000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = 9869fed2dfd7cf9e
	ldx	[%i2+0x100],%g3		! Observed data at 000000001d000100
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 7c8619ffea422142
	ldx	[%i2+0x108],%g3		! Observed data at 000000001d000108
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 0128ab9a6fee7c5a
	ldx	[%i2+0x110],%g3		! Observed data at 000000001d000110
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = d257f6ba0000803f
	ldx	[%i2+0x118],%g3		! Observed data at 000000001d000118
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = dc6207a3f4c1a9ac
	ldx	[%i2+0x120],%g3		! Observed data at 000000001d000120
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = 73e847c5997df6d7
	ldx	[%i2+0x128],%g3		! Observed data at 000000001d000128
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = 54778150c252c6a8
	ldx	[%i2+0x130],%g3		! Observed data at 000000001d000130
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = ab224f7c42717296
	ldx	[%i2+0x138],%g3		! Observed data at 000000001d000138
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 23a86afc0b931a1e
	ldx	[%i2+0x140],%g3		! Observed data at 000000001d000140
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = 000000009460d876
	ldx	[%i2+0x148],%g3		! Observed data at 000000001d000148
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 9222357bd040cce7
	ldx	[%i2+0x150],%g3		! Observed data at 000000001d000150
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 4a1e29e5e16e6bc7
	ldx	[%i2+0x158],%g3		! Observed data at 000000001d000158
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 5c8ccd98ee68008c
	ldx	[%i2+0x160],%g3		! Observed data at 000000001d000160
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = 7a50e9a81ae0d579
	ldx	[%i2+0x168],%g3		! Observed data at 000000001d000168
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = 59c320fee6321e0b
	ldx	[%i2+0x170],%g3		! Observed data at 000000001d000170
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 71743dcdba241389
	ldx	[%i2+0x178],%g3		! Observed data at 000000001d000178
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 1a6de0fef272cb34
	ldx	[%i2+0x180],%g3		! Observed data at 000000001d000180
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 4ba6e017a00ffb8f
	ldx	[%i2+0x188],%g3		! Observed data at 000000001d000188
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 000000000000f03f
	ldx	[%i2+0x190],%g3		! Observed data at 000000001d000190
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = b2162a2ef2814628
	ldx	[%i2+0x198],%g3		! Observed data at 000000001d000198
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 1b5d8c9105b69986
	ldx	[%i2+0x1a0],%g3		! Observed data at 000000001d0001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = 7b094b93b9561e1f
	ldx	[%i2+0x1a8],%g3		! Observed data at 000000001d0001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = c89763f666926f10
	ldx	[%i2+0x1b0],%g3		! Observed data at 000000001d0001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = aea36c7910bfa683
	ldx	[%i2+0x1b8],%g3		! Observed data at 000000001d0001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 2997c25ce453116a
	ldx	[%i2+0x1c0],%g3		! Observed data at 000000001d0001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 7bb1f8f4a7adcde1
	ldx	[%i2+0x1c8],%g3		! Observed data at 000000001d0001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = b9d037f4199d4350
	ldx	[%i2+0x1d0],%g3		! Observed data at 000000001d0001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = 891050599fba8e01
	ldx	[%i2+0x1d8],%g3		! Observed data at 000000001d0001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = 1bd66505e37bea3c
	ldx	[%i2+0x1e0],%g3		! Observed data at 000000001d0001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 6c4ded8dc174d2d4
	ldx	[%i2+0x1e8],%g3		! Observed data at 000000001d0001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 874940a3e5ddc3e0
	ldx	[%i2+0x1f0],%g3		! Observed data at 000000001d0001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = dc8da3cba4a9e63d
	ldx	[%i2+0x1f8],%g3		! Observed data at 000000001d0001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f8,%g4

	set	p3_local3_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 34cb72f2fee06d1a
	ldx	[%i3+0x000],%g3		! Observed data at 000000001d800000
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i3+0x008],%g3		! Observed data at 000000001d800008
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 3ff0000000000000
	ldx	[%i3+0x010],%g3		! Observed data at 000000001d800010
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 284681f22e2a16b2
	ldx	[%i3+0x018],%g3		! Observed data at 000000001d800018
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i3+0x020],%g3		! Observed data at 000000001d800020
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i3+0x028],%g3		! Observed data at 000000001d800028
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i3+0x030],%g3		! Observed data at 000000001d800030
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i3+0x038],%g3		! Observed data at 000000001d800038
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = e064cced2de9875e
	ldx	[%i3+0x040],%g3		! Observed data at 000000001d800040
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 3e51673d31776a93
	ldx	[%i3+0x048],%g3		! Observed data at 000000001d800048
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = 2f467805e8922323
	ldx	[%i3+0x050],%g3		! Observed data at 000000001d800050
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = ae103a640e1430c3
	ldx	[%i3+0x058],%g3		! Observed data at 000000001d800058
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 720eb2921664ae9c
	ldx	[%i3+0x060],%g3		! Observed data at 000000001d800060
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = d375d3b5d6ac30a4
	ldx	[%i3+0x068],%g3		! Observed data at 000000001d800068
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = eab0f2869053fabb
	ldx	[%i3+0x070],%g3		! Observed data at 000000001d800070
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = 68c6a9d3b7552a83
	ldx	[%i3+0x078],%g3		! Observed data at 000000001d800078
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x078,%g4
	ldx	[%g1+0x080],%g2		! Expect data = 6a1153e45cc29729
	ldx	[%i3+0x080],%g3		! Observed data at 000000001d800080
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x080,%g4
	ldx	[%g1+0x088],%g2		! Expect data = e1cdada7f4f8b17b
	ldx	[%i3+0x088],%g3		! Observed data at 000000001d800088
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x088,%g4
	ldx	[%g1+0x090],%g2		! Expect data = 50439d19f437d0b9
	ldx	[%i3+0x090],%g3		! Observed data at 000000001d800090
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x090,%g4
	ldx	[%g1+0x098],%g2		! Expect data = 018eba9f59501089
	ldx	[%i3+0x098],%g3		! Observed data at 000000001d800098
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x098,%g4
	ldx	[%g1+0x0a0],%g2		! Expect data = 3cea7be30565d61b
	ldx	[%i3+0x0a0],%g3		! Observed data at 000000001d8000a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a0,%g4
	ldx	[%g1+0x0a8],%g2		! Expect data = d4d274c18ded4d6c
	ldx	[%i3+0x0a8],%g3		! Observed data at 000000001d8000a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0a8,%g4
	ldx	[%g1+0x0b0],%g2		! Expect data = e0c3dde5a3404987
	ldx	[%i3+0x0b0],%g3		! Observed data at 000000001d8000b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b0,%g4
	ldx	[%g1+0x0b8],%g2		! Expect data = 3de6a9a4cba38ddc
	ldx	[%i3+0x0b8],%g3		! Observed data at 000000001d8000b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0b8,%g4
	ldx	[%g1+0x0c0],%g2		! Expect data = 6a1153e45cc29729
	ldx	[%i3+0x0c0],%g3		! Observed data at 000000001d8000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = e1cdada7f4f8b17b
	ldx	[%i3+0x0c8],%g3		! Observed data at 000000001d8000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 50439d19f437d0b9
	ldx	[%i3+0x0d0],%g3		! Observed data at 000000001d8000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 018eba9f59501089
	ldx	[%i3+0x0d8],%g3		! Observed data at 000000001d8000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 3cea7be30565d61b
	ldx	[%i3+0x0e0],%g3		! Observed data at 000000001d8000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = d4d274c18ded4d6c
	ldx	[%i3+0x0e8],%g3		! Observed data at 000000001d8000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = e0c3dde5a3404987
	ldx	[%i3+0x0f0],%g3		! Observed data at 000000001d8000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 3de6a9a4cba38ddc
	ldx	[%i3+0x0f8],%g3		! Observed data at 000000001d8000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x100],%g2		! Expect data = c99b20d77766d800
	ldx	[%i3+0x100],%g3		! Observed data at 000000001d800100
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x100,%g4
	ldx	[%g1+0x108],%g2		! Expect data = 936a77313d67513e
	ldx	[%i3+0x108],%g3		! Observed data at 000000001d800108
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x108,%g4
	ldx	[%g1+0x110],%g2		! Expect data = 593a34d7b8374ed2
	ldx	[%i3+0x110],%g3		! Observed data at 000000001d800110
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x110,%g4
	ldx	[%g1+0x118],%g2		! Expect data = a440acd6b5d375d3
	ldx	[%i3+0x118],%g3		! Observed data at 000000001d800118
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x118,%g4
	ldx	[%g1+0x120],%g2		! Expect data = 9cae641692b20e72
	ldx	[%i3+0x120],%g3		! Observed data at 000000001d800120
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x120,%g4
	ldx	[%g1+0x128],%g2		! Expect data = a430acd6b5d375d3
	ldx	[%i3+0x128],%g3		! Observed data at 000000001d800128
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x128,%g4
	ldx	[%g1+0x130],%g2		! Expect data = bbfa539086f2b0ea
	ldx	[%i3+0x130],%g3		! Observed data at 000000001d800130
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x130,%g4
	ldx	[%g1+0x138],%g2		! Expect data = 832a55b7d3a9c668
	ldx	[%i3+0x138],%g3		! Observed data at 000000001d800138
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x138,%g4
	ldx	[%g1+0x140],%g2		! Expect data = 6a1153e45cc29729
	ldx	[%i3+0x140],%g3		! Observed data at 000000001d800140
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x140,%g4
	ldx	[%g1+0x148],%g2		! Expect data = e1cdada7f4f8b17b
	ldx	[%i3+0x148],%g3		! Observed data at 000000001d800148
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x148,%g4
	ldx	[%g1+0x150],%g2		! Expect data = 50439d19f437d0b9
	ldx	[%i3+0x150],%g3		! Observed data at 000000001d800150
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x150,%g4
	ldx	[%g1+0x158],%g2		! Expect data = 018eba9f59501089
	ldx	[%i3+0x158],%g3		! Observed data at 000000001d800158
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x158,%g4
	ldx	[%g1+0x160],%g2		! Expect data = 3cea7be30565d61b
	ldx	[%i3+0x160],%g3		! Observed data at 000000001d800160
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x160,%g4
	ldx	[%g1+0x168],%g2		! Expect data = d4d274c18ded4d6c
	ldx	[%i3+0x168],%g3		! Observed data at 000000001d800168
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x168,%g4
	ldx	[%g1+0x170],%g2		! Expect data = e0c3dde5a3404987
	ldx	[%i3+0x170],%g3		! Observed data at 000000001d800170
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x170,%g4
	ldx	[%g1+0x178],%g2		! Expect data = 3de6a9a4cba38ddc
	ldx	[%i3+0x178],%g3		! Observed data at 000000001d800178
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x178,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 9ecfd7dfd2fe6998
	ldx	[%i3+0x180],%g3		! Observed data at 000000001d800180
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 422142eaff19867c
	ldx	[%i3+0x188],%g3		! Observed data at 000000001d800188
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 5a7cee6f9aab2801
	ldx	[%i3+0x190],%g3		! Observed data at 000000001d800190
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = c78cf17cbaf657d2
	ldx	[%i3+0x198],%g3		! Observed data at 000000001d800198
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = aca9c1f4a30762dc
	ldx	[%i3+0x1a0],%g3		! Observed data at 000000001d8001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = d7f67d99c547e873
	ldx	[%i3+0x1a8],%g3		! Observed data at 000000001d8001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = a8c652c250817754
	ldx	[%i3+0x1b0],%g3		! Observed data at 000000001d8001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = 967271427c4f22ab
	ldx	[%i3+0x1b8],%g3		! Observed data at 000000001d8001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b8,%g4
	ldx	[%g1+0x1c0],%g2		! Expect data = 1e1a930bfc6aa823
	ldx	[%i3+0x1c0],%g3		! Observed data at 000000001d8001c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c0,%g4
	ldx	[%g1+0x1c8],%g2		! Expect data = 76d8609400000000
	ldx	[%i3+0x1c8],%g3		! Observed data at 000000001d8001c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1c8,%g4
	ldx	[%g1+0x1d0],%g2		! Expect data = e7cc40d07b352292
	ldx	[%i3+0x1d0],%g3		! Observed data at 000000001d8001d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d0,%g4
	ldx	[%g1+0x1d8],%g2		! Expect data = c76b6ee1e5291e4a
	ldx	[%i3+0x1d8],%g3		! Observed data at 000000001d8001d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1d8,%g4
	ldx	[%g1+0x1e0],%g2		! Expect data = 0000c00e1b8ce241
	ldx	[%i3+0x1e0],%g3		! Observed data at 000000001d8001e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e0,%g4
	ldx	[%g1+0x1e8],%g2		! Expect data = 79d5e01aa8e9507a
	ldx	[%i3+0x1e8],%g3		! Observed data at 000000001d8001e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1e8,%g4
	ldx	[%g1+0x1f0],%g2		! Expect data = 0b1e32e6fe20c359
	ldx	[%i3+0x1f0],%g3		! Observed data at 000000001d8001f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f0,%g4
	ldx	[%g1+0x1f8],%g2		! Expect data = 891324bacd3d7471
	ldx	[%i3+0x1f8],%g3		! Observed data at 000000001d8001f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1f8,%g4

	set	p3_local4_expect,%g1

!	Processor 3, local 4 is clean


	set	p3_local5_expect,%g1
	ldx	[%g1+0x0c0],%g2		! Expect data = 34cb72f2fee06d1a
	ldx	[%i5+0x0c0],%g3		! Observed data at 000000001e8000c0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c0,%g4
	ldx	[%g1+0x0c8],%g2		! Expect data = 8ffb0fa017e0a64b
	ldx	[%i5+0x0c8],%g3		! Observed data at 000000001e8000c8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0c8,%g4
	ldx	[%g1+0x0d0],%g2		! Expect data = 593a34d7b8374ed2
	ldx	[%i5+0x0d0],%g3		! Observed data at 000000001e8000d0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d0,%g4
	ldx	[%g1+0x0d8],%g2		! Expect data = 284681f22e2a16b2
	ldx	[%i5+0x0d8],%g3		! Observed data at 000000001e8000d8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0d8,%g4
	ldx	[%g1+0x0e0],%g2		! Expect data = 8699b605918c5d1b
	ldx	[%i5+0x0e0],%g3		! Observed data at 000000001e8000e0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e0,%g4
	ldx	[%g1+0x0e8],%g2		! Expect data = 1f1e56b9934b097b
	ldx	[%i5+0x0e8],%g3		! Observed data at 000000001e8000e8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0e8,%g4
	ldx	[%g1+0x0f0],%g2		! Expect data = 106f9266f66397c8
	ldx	[%i5+0x0f0],%g3		! Observed data at 000000001e8000f0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f0,%g4
	ldx	[%g1+0x0f8],%g2		! Expect data = 83a6bf10796ca3ae
	ldx	[%i5+0x0f8],%g3		! Observed data at 000000001e8000f8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x0f8,%g4
	ldx	[%g1+0x180],%g2		! Expect data = 1a6de0fef272cb34
	ldx	[%i5+0x180],%g3		! Observed data at 000000001e800180
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x180,%g4
	ldx	[%g1+0x188],%g2		! Expect data = 4ba6e017a00ffb8f
	ldx	[%i5+0x188],%g3		! Observed data at 000000001e800188
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x188,%g4
	ldx	[%g1+0x190],%g2		! Expect data = 000000000000f03f
	ldx	[%i5+0x190],%g3		! Observed data at 000000001e800190
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x190,%g4
	ldx	[%g1+0x198],%g2		! Expect data = b2162a2ef2814628
	ldx	[%i5+0x198],%g3		! Observed data at 000000001e800198
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x198,%g4
	ldx	[%g1+0x1a0],%g2		! Expect data = 1b5d8c9105b69986
	ldx	[%i5+0x1a0],%g3		! Observed data at 000000001e8001a0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a0,%g4
	ldx	[%g1+0x1a8],%g2		! Expect data = 7b094b93b9561e1f
	ldx	[%i5+0x1a8],%g3		! Observed data at 000000001e8001a8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1a8,%g4
	ldx	[%g1+0x1b0],%g2		! Expect data = c89763f666926f10
	ldx	[%i5+0x1b0],%g3		! Observed data at 000000001e8001b0
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b0,%g4
	ldx	[%g1+0x1b8],%g2		! Expect data = aea36c7910bfa683
	ldx	[%i5+0x1b8],%g3		! Observed data at 000000001e8001b8
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x1b8,%g4

	set	p3_local6_expect,%g1
	ldx	[%g1+0x000],%g2		! Expect data = 23a86afc0b931a1e
	ldx	[%i6+0x000],%g3		! Observed data at 000000001f000000
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x000,%g4
	ldx	[%g1+0x008],%g2		! Expect data = 000000009460d876
	ldx	[%i6+0x008],%g3		! Observed data at 000000001f000008
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x008,%g4
	ldx	[%g1+0x010],%g2		! Expect data = 9222357bd040cce7
	ldx	[%i6+0x010],%g3		! Observed data at 000000001f000010
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x010,%g4
	ldx	[%g1+0x018],%g2		! Expect data = 4a1e29e5e16e6bc7
	ldx	[%i6+0x018],%g3		! Observed data at 000000001f000018
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x018,%g4
	ldx	[%g1+0x020],%g2		! Expect data = 41e28c1b0ec00000
	ldx	[%i6+0x020],%g3		! Observed data at 000000001f000020
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x020,%g4
	ldx	[%g1+0x028],%g2		! Expect data = 7a50e9a81ae0d579
	ldx	[%i6+0x028],%g3		! Observed data at 000000001f000028
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x028,%g4
	ldx	[%g1+0x030],%g2		! Expect data = 59c320fee6321e0b
	ldx	[%i6+0x030],%g3		! Observed data at 000000001f000030
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x030,%g4
	ldx	[%g1+0x038],%g2		! Expect data = 71743dcdba241389
	ldx	[%i6+0x038],%g3		! Observed data at 000000001f000038
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x038,%g4
	ldx	[%g1+0x040],%g2		! Expect data = 1a6de0fe00000000
	ldx	[%i6+0x040],%g3		! Observed data at 000000001f000040
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x040,%g4
	ldx	[%g1+0x048],%g2		! Expect data = 4ba6e017a00ffb8f
	ldx	[%i6+0x048],%g3		! Observed data at 000000001f000048
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x048,%g4
	ldx	[%g1+0x050],%g2		! Expect data = d24e37b8d7343a59
	ldx	[%i6+0x050],%g3		! Observed data at 000000001f000050
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x050,%g4
	ldx	[%g1+0x058],%g2		! Expect data = b2162a2e4ee3a42e
	ldx	[%i6+0x058],%g3		! Observed data at 000000001f000058
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x058,%g4
	ldx	[%g1+0x060],%g2		! Expect data = 1b5d8c9105b69986
	ldx	[%i6+0x060],%g3		! Observed data at 000000001f000060
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x060,%g4
	ldx	[%g1+0x068],%g2		! Expect data = 7b094b93b9561e1f
	ldx	[%i6+0x068],%g3		! Observed data at 000000001f000068
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x068,%g4
	ldx	[%g1+0x070],%g2		! Expect data = c89763f666926f10
	ldx	[%i6+0x070],%g3		! Observed data at 000000001f000070
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x070,%g4
	ldx	[%g1+0x078],%g2		! Expect data = aea36c7910bfa683
	ldx	[%i6+0x078],%g3		! Observed data at 000000001f000078
	cmp	%g2,%g3
	bne,a,pn %xcc,p3_local_failed
	mov	0x078,%g4


!	Check Shared Memory
	set	share0_expect,%g4
	set	p3_share_mask,%g5
	set	0x70000000,%g6	! Physical Addr of Share 0
p3_memcheck_share0:
	ldx	[%g4+0x18],%g2	! Expected value = 4ba6e017a00ffb8f
	ldx	[%o0+0x18],%g3	! Read value at Mem[0000000070000018]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x018,%g1
	ldx	[%g4+0x58],%g2	! Expected value = d31b1a2573e79db9
	ldx	[%o0+0x58],%g3	! Read value at Mem[0000000070000058]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x058,%g1
	set	share1_expect,%g4
	set	0x70800000,%g6	! Physical Addr of Share 1
p3_memcheck_share1:
	ldx	[%g4+0x18],%g2	! Expected value = 1f1e56b9934b097b
	ldx	[%o1+0x18],%g3	! Read value at Mem[0000000070800018]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x018,%g1
	ldx	[%g4+0x58],%g2	! Expected value = f92f1bc5b0d9076b
	ldx	[%o1+0x58],%g3	! Read value at Mem[0000000070800058]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x058,%g1
	set	share2_expect,%g4
	set	0x71000000,%g6	! Physical Addr of Share 2
p3_memcheck_share2:
	ldx	[%g4+0x18],%g2	! Expected value = 9431d876fa88dc14
	ldx	[%o2+0x18],%g3	! Read value at Mem[0000000071000018]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x018,%g1
	ldx	[%g4+0x58],%g2	! Expected value = 0000000000000029
	ldx	[%o2+0x58],%g3	! Read value at Mem[0000000071000058]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x058,%g1
	set	share3_expect,%g4
	set	0x71800000,%g6	! Physical Addr of Share 3
p3_memcheck_share3:
	ldx	[%g4+0x18],%g2	! Expected value = 2ea4e34e2e2a0029
	ldx	[%o3+0x18],%g3	! Read value at Mem[0000000071800018]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x018,%g1
	ldx	[%g4+0x58],%g2	! Expected value = 79c52bb5985940be
	ldx	[%o3+0x58],%g3	! Read value at Mem[0000000071800058]
	cmp	%g2,%g3
	bne,pn	%xcc,p3_failed
	add	%g6,0x058,%g1

!	The test for processor 3 has passed

p3_passed:
	ta	GOOD_TRAP
	nop

p3_reg_l0_fail:
	or	%g0,0xbd0,%g1
	ba,a	p3_failed
p3_reg_l1_fail:
	or	%g0,0xbd1,%g1
	ba,a	p3_failed
p3_reg_l2_fail:
	or	%g0,0xbd2,%g1
	ba,a	p3_failed
p3_reg_l3_fail:
	or	%g0,0xbd3,%g1
	ba,a	p3_failed
p3_reg_l4_fail:
	or	%g0,0xbd4,%g1
	ba,a	p3_failed
p3_reg_l5_fail:
	or	%g0,0xbd5,%g1
	ba,a	p3_failed
p3_reg_l6_fail:
	or	%g0,0xbd6,%g1
	ba,a	p3_failed
p3_reg_l7_fail:
	or	%g0,0xbd7,%g1
	ba,a	p3_failed
p3_freg_fail:
	mov	%l0,%g3
	ba	p3_failed
	mov	%l1,%g2


!	The test for processor 3 failed

p3_failed:
	set	done_flags,%g1
	mov	3,%g5
	st	%g5,[%g1+0x00c]		! Set processor 3 done flag

	set	p3_temp,%g6
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p3_freg_failed:
	ba,a	p3_failed

!	The local area data for processor 3 failed

p3_local_failed:
	set	done_flags,%g5
	mov	3,%g6
	st	%g5,[%g5+0x00c]		! Set processor 3 done flag

	set	p3_temp,%g6
	add	%g1,%g4,%g1
	stx	%g1,[%g6]
	stx	%g2,[%g6+8]
	stx	%g3,[%g6+16]
	ta	BAD_TRAP
	nop

p3_dfill_failed:
	ba	p3_failed
	mov	0xddd,%g1

p3_selfmod_failed:
	ba	p3_failed
	mov	0xabc,%g1


p3_common_error:
	or	%g0,0xee3,%g1
	ba	p3_failed
	mov	%o5,%g3

p3_common_signature_error:
	set	p3_temp,%g1
	ba	p3_failed
	st	%g2,[%g1]			! Common Lock Number

p3_common_timeout:
	set	p3_temp,%g1
	ba	p3_failed
	st	%g2,[%g1]			! Common Lock Number
p3_branch_failed:
	mov	0xbbb,%g1
	rd	%ccr,%g2
	ba	p3_failed
	mov	0x0,%g3

p3_trap1e:
	stw	%l5,[%i0+0x014]		! Mem[000000001c000014]
	done

p3_trap1o:
	stw	%l5,[%o0+0x014]		! Mem[000000001c000014]
	done


p3_trap2e:
	lduh	[%i1+0x1dc],%l6		! Mem[000000001c8001dc]
	sub	%l0,%l1,%l4
	ldx	[%o0+0x018],%l0		! Mem[0000000070000018]
	std	%l2,[%o1+0x018]		! Mem[0000000070800018]
	subccc	%l3,%l6,%l4
	ldx	[%i1+0x158],%l0		! Mem[000000001c800158]
	done

p3_trap2o:
	lduh	[%o1+0x1dc],%l6		! Mem[000000001c8001dc]
	sub	%l0,%l1,%l4
	ldx	[%i0+0x018],%l0		! Mem[0000000070000018]
	std	%l2,[%i1+0x018]		! Mem[0000000070800018]
	subccc	%l3,%l6,%l4
	ldx	[%o1+0x158],%l0		! Mem[000000001c800158]
	done


p3_init_memory_pointers:
	set	p3_init_registers,%g1
	mov	%g0,%g4
	mov	%g0,%g5
	mov	%g0,%g6
	mov	%g0,%g7

!	Initialize memory pointers for window 0
	set	p3_local0_start,%i0
	set	p3_local1_start,%i1
	set	p3_local2_start,%i2
	set	p3_local3_start,%i3
	set	p3_local4_start,%i4
	set	p3_local5_start,%i5
	set	p3_local6_start,%i6
	mov	%g0,%i7
!	Init Local Registers in Window 0
	ldx	[%g1+0x000],%l0	! %l0 = d8438028785bff0d
	ldx	[%g1+0x008],%l1	! %l1 = 2d612268b4e86568
	ldx	[%g1+0x010],%l2	! %l2 = 0595c7dded844bb3
	ldx	[%g1+0x018],%l3	! %l3 = 3fafdaee05479dae
	ldx	[%g1+0x020],%l4	! %l4 = 8c2217a4a5b45a43
	ldx	[%g1+0x028],%l5	! %l5 = eb0ede0a065d2ad4
	ldx	[%g1+0x030],%l6	! %l6 = 7af6563a382e7efd
	ldx	[%g1+0x038],%l7	! %l7 = f206291c2997c25c

!	Initialize the output register of window 0
	set	share0_start,%o0
	set	share1_start,%o1
	set	share2_start,%o2
	set	share3_start,%o3
	set	unres0_start,%o4
	set	common_start,%o5
	mov	0x08,%o6

	retl
	nop

!	Random code for Processor 4

processor_4:
	ta	T_CHANGE_PRIV
	set	done_flags,%g1
	mov	1,%g2
	st	%g2,[%g1+0x10]		! Set the start flag
	wrpr	%g0,7,%cleanwin
	call	p4_init_memory_pointers
	wr	%g0,0x80,%asi		! Setting default asi to 80

!	Initialize the floating point registers for processor 4

	wr	%g0,0x4,%fprs		! Make sure fef is 1
	set	p4_init_freg,%g1
!	%f0  = 925fc273 7de0b2ba fcb03eb3 5fda1b80
!	%f4  = ee54212a e2e16b12 3beceab3 345e0f1b
!	%f8  = 1a25e866 a018cbee a08dfcc5 fb2fd9d3
!	%f12 = ca9d0d5e f2e80b75 2ba6f92a 0ede9281
	ldda	[%g1]ASI_BLK_P,%f0
	add	%g1,64,%g1
!	%f16 = 466f18a9 d4706ad4 67074e27 914ac496
!	%f20 = e87a44ce 13a4469c db0706fb 0f3f2758
!	%f24 = 6dc7f07d 5b641728 0b3bc02b bb75a00d
!	%f28 = 2ad55378 96391d50 d00df66a 6fd84160
	ldda	[%g1]ASI_BLK_P,%f16
	add	%g1,64,%g1
!	%f32 = f2f6a42d c1d7f210 44061be9 c3501086
!	%f36 = 838b3e2f 519bbb5a f58d987a b4d0b30d
!	%f40 = 4b64df38 eb686f39 17dc06f0 04b54e0d
!	%f44 = e245e869 f9f2af2b e1154e10 003e9da8
	ldda	[%g1]ASI_BLK_P,%f32
	xorcc	%g0,%g0,%g3		! init %g3 and set flags
	membar	#Sync			! Force the block loads to complete

!	Start of Random Code for processor 4

p4_label_1:
	set	p4_b1,%o7
	fba,a,pt %fcc3,p4_near_3_he	! Branch Taken, %fcc3 = 0
!	%f1  = 7de0b2ba, %f1  = 7de0b2ba, %f29 = 96391d50
	fadds	%f1 ,%f1 ,%f29	! Annulled
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p4_branch_failed
	mov	0x001,%g2
p4_b1:
!	Registers modified during the branch to p4_near_3
!	%l5  = 80369602c3cd4d03
!	Mem[0000000070000020] = 36266c437e3b287e, %l2 = 5ad299f85ac51963
	ldx	[%o0+0x020],%l2		! %l2 = 36266c437e3b287e
!	%l4 = 811df4f66a51b8e7, immed = 00000854, %l1 = b35788f3ee6d9db5
	andn	%l4,0x854,%l1		! %l1 = 811df4f66a51b0a3
!	Mem[0000000070000060] = 7eca9833ea0cd282, %l7 = 92ae8d5ffd873d21
	ldx	[%o0+0x060],%l7		! %l7 = 7eca9833ea0cd282

p4_label_2:
!	%l3 = c9c1b590740880df, %l1 = 811df4f66a51b0a3, %y  = 00000000
	sdivx	%l3,%l1,%l1		! %l1 = 0000000000000000
!	Mem[0000000021000080] = e5d9b6ae cfcefb8a 25b83584 5ca4b516
!	Mem[0000000021000090] = a6239df9 a71d548e f84e04a2 923b8e7b
!	Mem[00000000210000a0] = e2e7c999 7a20e100 f3c542d8 c61aff1c
!	Mem[00000000210000b0] = 2877fac7 167bd0f3 03bc1218 32c08efd
	mov	0x080,%g4
	ldda	[%i2+%g4]ASI_BLK_P,%f0	! Block Load from 0000000021000080
!	%l2 = 36266c437e3b287e, %l4 = 811df4f66a51b8e7, %l1 = 0000000000000000
	add	%l2,%l4,%l1		! %l1 = b7446139e88ce165
!	%f16 = 466f18a9 d4706ad4 67074e27 914ac496
!	%f20 = e87a44ce 13a4469c db0706fb 0f3f2758
!	%f24 = 6dc7f07d 5b641728 0b3bc02b bb75a00d
!	%f28 = 2ad55378 96391d50 d00df66a 6fd84160
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 0000000020000080
!	%f0  = e5d9b6ae cfcefb8a 25b83584 5ca4b516
!	%f4  = a6239df9 a71d548e f84e04a2 923b8e7b
!	%f8  = e2e7c999 7a20e100 f3c542d8 c61aff1c
!	%f12 = 2877fac7 167bd0f3 03bc1218 32c08efd
	mov	0x040,%g5
	stda	%f0,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040

p4_label_3:
!	Mem[00000000210000c0] = 5f3bed1a a651a1ca 5b899d9d 3082d955
!	Mem[00000000210000d0] = 32897ce3 5a3528e9 4a8d5107 3866d323
!	Mem[00000000210000e0] = 2bfe4da1 e48812b9 70833136 27ac39b0
!	Mem[00000000210000f0] = cd5ea6c2 b621a652 d6f7e85a 3f28f402
	mov	0x0c0,%g6
	ldda	[%i2+%g6]ASI_BLK_PL,%f0	! Block Load from 00000000210000c0
!	Mem[00000000218000c0] = 02e76026 06d350ae 4e3e81aa dbf577bc
!	Mem[00000000218000d0] = 86aae551 254df75e 3d1a3a9a 82b0a675
!	Mem[00000000218000e0] = 07cb67a4 b0d28b20 2f67491f 1f52fde8
!	Mem[00000000218000f0] = 5aa6345c c85d4d20 ffd0a989 056617f7
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 00000000218000c0
!	%l7 = 7eca9833ea0cd282, %l3 = c9c1b590740880df, %l5 = 80369602c3cd4d03
	addccc	%l7,%l3,%l5		! %l5 = 488c4dc45e155361, %ccr = 11
!	Mem[0000000020000038] = 9c36e0f276a843ed, %l4 = 811df4f66a51b8e7
	ldx	[%i0+0x038],%l4		! %l4 = 9c36e0f276a843ed
!	%f0  = caa151a6 1aed3b5f 55d98230 9d9d895b
!	%f4  = e928355a e37c8932 23d36638 07518d4a
!	%f8  = b91288e4 a14dfe2b b039ac27 36318370
!	%f12 = 52a621b6 c2a65ecd 02f4283f 5ae8f7d6
	stda	%f0,[%i0]ASI_BLK_P	! Block Store to 0000000020000000

p4_label_4:
!	Mem[00000000208000c0] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[00000000208000d0] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000208000e0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000208000f0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i1+%g6]ASI_BLK_PL,%f16	! Block Load from 00000000208000c0
	fbu	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000021000000] = 09d41ea95a0fab6a, %l2 = 36266c437e3b287e
	ldxa	[%i2+%g0]0x80,%l2	! %l2 = 09d41ea95a0fab6a
p4_b2:
!	Mem[0000000020800000] = 979e8607 13b08edb abfd2116 b17d9219
!	Mem[0000000020800010] = 1acd971f 204681da b080bf4f a04bf89b
!	Mem[0000000020800020] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[0000000020800030] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%i1]ASI_BLK_P,%f0	! Block Load from 0000000020800000
!	Mem[00000000218000f0] = 5aa6345c, %l1 = b7446139e88ce165
	lduwa	[%i3+0x0f0]%asi,%l1	! %l1 = 000000005aa6345c

p4_label_5:
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
!	%l4 = 9c36e0f276a843ed, Mem[0000000070000020] = 36266c43
	stwa	%l4,[%o0+0x020]%asi	! Mem[0000000070000020] = 76a843ed
!	%f19 = ce5523bc, %f7  = a04bf89b
	fstoi	%f19,%f7 		! %f7  = cab71100
!	Mem[0000000070000020] = 76a843ed7e3b287e, %l4 = 9c36e0f276a843ed
	ldx	[%o0+0x020],%l4		! %l4 = 76a843ed7e3b287e
!	Mem[0000000071000024] = 7adcc322, %l3 = c9c1b590740880df
	ldsb	[%o2+0x024],%l3		! %l3 = 000000000000007a

p4_label_6:
	membar	#Sync			! Added by membar checker (203)
!	%f16 = eccfd358 a1bdf36e 078e9309 ce5523bc
!	%f20 = 2ede155e c4efc00a 408678c1 1d7d5515
!	%f24 = 2adf9862 f81dae65 e9ec7863 ebc614da
!	%f28 = 088e96f6 8885ccf4 d62eb665 aa546b8c
	stda	%f16,[%i0+%g4]ASI_BLK_P	! Block Store to 0000000020000080
!	%l0 = 7913514a54b513d3, %l3 = 000000000000007a, %l1 = 000000005aa6345c
	sra	%l0,%l3,%l1		! %l1 = 0000000000000015
	membar	#Sync			! Added by membar checker (204)
	set	p4_b3,%o7
	fbuge,a	p4_far_0_le		! Branch Taken, %fcc0 = 0
!	Mem[0000000070800024] = e4a37c8e, %l3 = 000000000000007a
	ldsb	[%o1+0x026],%l3		! %l3 = 000000000000007c
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p4_branch_failed
	mov	0x003,%g2
p4_b3:
!	Registers modified during the branch to p4_far_0
!	%l2  = b3e8dd6d78bc26a4
!	%l4  = 00000000000076a8
!	%l6  = 0000000000000060
!	%l7  = 00000000000007fd
!	Mem[0000000020000000] = caa151a6, %l3 = 000000000000007c
	lduba	[%i0+%g0]0x80,%l3	! %l3 = 00000000000000ca

p4_label_7:
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f cab71100
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000021000080
!	Mem[00000000208000c0] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[00000000208000d0] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000208000e0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000208000f0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i1+%g6]ASI_BLK_P,%f16	! Block Load from 00000000208000c0
!	Mem[0000000023000080] = 4e4daada 852aa4b3 dcf5e2d2 35b26024
!	Mem[0000000023000090] = 7b5c2795 ca9b5b9b 5505f5ab a303db5f
!	Mem[00000000230000a0] = 32899c55 7e460030 22120bca 86e385aa
!	Mem[00000000230000b0] = 15951ebd 747f0f0c 4e6e8189 fada32d2
	ldda	[%i6+%g4]ASI_BLK_P,%f16	! Block Load from 0000000023000080
!	Mem[0000000070800060] = 528fae7df8c7c699, %l4 = 00000000000076a8
	ldx	[%o1+0x060],%l4		! %l4 = 528fae7df8c7c699
!	Mem[0000000071800060] = 199e44064cdf3caf, %l6 = 0000000000000060
	ldx	[%o3+0x060],%l6		! %l6 = 199e44064cdf3caf

p4_label_8:
	fbg,a	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000070000064] = ea0cd282, %l1 = 0000000000000015
	lduw	[%o0+0x064],%l1		! Annulled
p4_b4:
!	Mem[0000000020800000] = 979e860713b08edb, %l6 = 199e44064cdf3caf
	ldxa	[%i1+%g0]0x80,%l6	! %l6 = 979e860713b08edb
!	Mem[0000000021000008] = 7ad70106b5fd6f02, %l6 = 979e860713b08edb
	ldxa	[%i2+%o6]0x80,%l6	! %l6 = 7ad70106b5fd6f02
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f cab71100
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000210000c0

p4_label_9:
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f cab71100
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i1+%g5]ASI_BLK_PL	! Block Store to 0000000020800040
	membar	#Sync
	fbn,a,pt %fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000021000000] = 09d41ea9, %l7 = 00000000000007fd
	lduwa	[%i2+%g0]0x80,%l7	! Annulled
p4_b5:
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f cab71100
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 00000000218000c0
	fbul	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0

p4_label_10:
!	Mem[00000000208000a8] = eccac82ad84dc940, %l0 = 7913514a54b513d3
	ldx	[%i1+0x0a8],%l0		! %l0 = eccac82ad84dc940
p4_b6:
!	Mem[0000000021800000] = a33ed4d6, %l7 = 00000000000007fd
	lduha	[%i3+%g0]0x80,%l7	! %l7 = 000000000000a33e
!	%l5 = 488c4dc45e155361, immed = 00000c6f, %l7 = 000000000000a33e
	or	%l5,0xc6f,%l7		! %l7 = 488c4dc45e155f6f
!	Mem[0000000072000050] = 8e541da7f99d23a6, %l5 = 488c4dc45e155361
	ldx	[%o4+0x050],%g2		! %g2 = 8e541da7f99d23a6
	bcs,a	p4_not_taken_0		! Branch Not Taken, %ccr = 00

p4_label_11:
!	 Annulled
	ldd	[%o0+0x060],%l6
p4_b7:
!	Mem[0000000071000020] = 83a9fc6f, %l4 = 528fae7df8c7c699
	ldsb	[%o2+0x023],%l4		! %l4 = 000000000000006f
!	Mem[0000000072000040] = 8afbcecf aeb6d9e5 16b5a45c 8435b825
!	Mem[0000000072000050] = 8e541da7 f99d23a6 7b8e3b92 a2044ef8
!	Mem[0000000072000060] = 00e1207a 99c9e7e2 1cff1ac6 d842c5f3
!	Mem[0000000072000070] = f3d07b16 c7fa7728 fd8ec032 1812bc03
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000021000008] = 7ad70106, %l5 = 488c4dc45e155361
	ldswa	[%i2+%o6]0x80,%l5	! %l5 = 000000007ad70106
!	Mem[00000000210000c0] = db8eb013 07869e97 19927db1 1621fdab
!	Mem[00000000210000d0] = da814620 1f97cd1a 0011b7ca 4fbf80b0
!	Mem[00000000210000e0] = 3d1a4960 fb9db09c 479425fe 1531a644
!	Mem[00000000210000f0] = e0daa36a 959eadc1 31a1f6eb ae91be61
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 00000000210000c0

p4_label_12:
!	Mem[0000000072000040] = 8afbcecf aeb6d9e5 16b5a45c 8435b825
!	Mem[0000000072000050] = 8e541da7 f99d23a6 7b8e3b92 a2044ef8
!	Mem[0000000072000060] = 00e1207a 99c9e7e2 1cff1ac6 d842c5f3
!	Mem[0000000072000070] = f3d07b16 c7fa7728 fd8ec032 1812bc03
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000020800008] = abfd2116b17d9219, %l3 = 00000000000000ca
	ldxa	[%i1+%o6]0x80,%l3	! %l3 = abfd2116b17d9219
!	Mem[0000000021000000] = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	Mem[0000000021000010] = 228154fd c4007477 483d8ca5 c7db1ab2
!	Mem[0000000021000020] = 295958ed 2d2183e0 51e70b27 33081cfa
!	Mem[0000000021000030] = 576c7424 963b3a02 493a0e3e 0b46e7b9
	ldda	[%i2]ASI_BLK_P,%f0	! Block Load from 0000000021000000
!	Mem[0000000021800000] = a33ed4d6, %l5 = 000000007ad70106
	lduba	[%i3+%g0]0x80,%l5	! %l5 = 00000000000000a3
!	Mem[0000000021000068] = 1540acdfac2782f2, %l0 = eccac82ad84dc940
	ldx	[%i2+0x068],%l0		! %l0 = 1540acdfac2782f2

p4_label_13:
!	Mem[00000000200000b0] = 088e96f68885ccf4, %l4 = 000000000000006f
	ldxa	[%i0+0x0b0]%asi,%l4	! %l4 = 088e96f68885ccf4
!	%l5 = 00000000000000a3, %l5 = 00000000000000a3, %l1 = 0000000000000015
	addccc	%l5,%l5,%l1		! %l1 = 0000000000000146, %ccr = 00
!	Mem[00000000200000ac] = ebc614da, %l7 = 488c4dc45e155f6f
	ldsh	[%i0+0x0ae],%l7		! %l7 = 00000000000014da
!	Mem[0000000021000004] = 5a0fab6a, %l3 = abfd2116b17d9219
	lduw	[%i2+0x004],%l3		! %l3 = 000000005a0fab6a
	membar	#Sync			! Added by membar checker (205)
	set	p4_b8,%o7
	fbge,a,pt %fcc1,p4_near_2_he	! Branch Taken, %fcc1 = 0

p4_label_14:
!	Mem[0000000020000008] = 55d98230, %l6 = 7ad70106b5fd6f02
	ldsba	[%i0+%o6]0x80,%l6	! %l6 = 0000000000000055
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x008,%g2
p4_b8:
!	Registers modified during the branch to p4_near_2
!	%l1  = 000000000000007a
!	%l3  = 00000000ea0cd282
!	%l5  = 00000000dc3069b1
!	%l7  = fb83e6ee53f607eb
!	Mem[0000000071800060] = 199e4406, %l0 = 1540acdfac2782f2
	lduha	[%o3+0x062]%asi,%l0	! %l0 = 0000000000004406
!	%f0  = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f4  = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f8  = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f12 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 0000000021800080
!	%l4 = 088e96f68885ccf4, immed = 0000001f, %l7 = fb83e6ee53f607eb
	sll	%l4,0x01f,%l7		! %l7 = 4442e67a00000000
!	%l5 = 00000000dc3069b1, immed = 000009a5, %l3 = 00000000ea0cd282
	xor	%l5,0x9a5,%l3		! %l3 = 00000000dc306014

p4_label_15:
!	Mem[00000000218000f8] = 31a1f6eb, %l5 = 00000000dc3069b1
	ldsb	[%i3+0x0f9],%l5		! %l5 = ffffffffffffffa1
!	Mem[0000000021800008] = 2beb966d, %l1 = 000000000000007a
	ldstuba	[%i3+%o6]0x80,%l1	! %l1 = 000000000000002b
	fbul	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	%f16 = 4e4daada, %f20 = 7b5c2795
	fnegs	%f16,%f20		! %f20 = ce4daada
p4_b9:
!	%f0  = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f4  = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f8  = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f12 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f0,[%i1+%g4]ASI_BLK_P	! Block Store to 0000000020800080

p4_label_16:
!	Mem[00000000218000d0] = da8146201f97cd1a, %l4 = 088e96f68885ccf4
	ldx	[%i3+0x0d0],%l4		! %l4 = da8146201f97cd1a
!	Mem[000000007200001c] = 67ee565b, %l7 = 4442e67a00000000
	lduwa	[%o4+0x01c]%asi,%g2	! %g2 = 4442e67a00000000
!	Mem[0000000070800024] = e4a37c8e, %l4 = da8146201f97cd1a
	ldsha	[%o1+0x024]%asi,%l4	! %l4 = ffffffffffffe4a3
!	Mem[0000000020000000] = caa151a6, %l3 = 00000000dc306014
	lduha	[%i0+%g0]0x80,%l3	! %l3 = 000000000000caa1
!	Mem[0000000020000008] = 55d98230, %l6 = 0000000000000055
	ldstuba	[%i0+%o6]0x80,%l6	! %l6 = 0000000000000055

p4_label_17:
!	Mem[0000000020000008] = ffd98230, %l0 = 0000000000004406
	ldsba	[%i0+%o6]0x80,%l0	! %l0 = ffffffffffffffff
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
!	Mem[00000000210000bc] = ebf6a131, %l5 = ffffffffffffffa1
	ldub	[%i2+0x0be],%l5		! %l5 = 00000000000000a1
	fbn,pt	%fcc1,p4_branch_failed	! Branch Not Taken, %fcc1 = 0
!	Mem[0000000020800000] = 979e8607, %l7 = 4442e67a00000000
	lduwa	[%i1+%g0]0x80,%l7	! %l7 = 00000000979e8607
p4_b10:

p4_label_18:
!	Branch On Register, %l7 = 00000000979e8607
	brlez,pn %l7,p4_not_taken_0	! Branch Not Taken
!	Mem[0000000021000008] = 7ad70106b5fd6f02, %l0 = ffffffffffffffff
	ldxa	[%i2+%o6]0x80,%l0	! %l0 = 7ad70106b5fd6f02
p4_b11:
!	%l1 = 000000000000002b, immed = fffff614, %l6 = 0000000000000055
	addcc	%l1,-0x9ec,%l6		! %l6 = fffffffffffff63f, %ccr = 88
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
	fbul,a,pn %fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0

p4_label_19:
!	Mem[00000000210000b8] = 61be91ae, %l6 = fffffffffffff63f
	ldsw	[%i2+0x0b8],%l6		! Annulled
p4_b12:
!	%f0  = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f4  = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f8  = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f12 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f0,[%i3+%g6]ASI_BLK_PL	! Block Store to 00000000218000c0
!	Mem[0000000021000000] = 09d41ea9, %l4 = ffffffffffffe4a3
	lduha	[%i2+%g0]0x80,%l4	! %l4 = 00000000000009d4
!	Mem[0000000021000008] = 7ad70106, %l4 = 00000000000009d4
	lduwa	[%i2+%o6]0x80,%l4	! %l4 = 000000007ad70106
!	Mem[0000000021800000] = a33ed4d6, %l3 = 000000000000caa1
	ldsba	[%i3+%g0]0x80,%l3	! %l3 = ffffffffffffffa3

p4_label_20:
!	Mem[0000000072000010] = f8c1c7ce7bfedd14, %l4 = 000000007ad70106
	ldx	[%o4+0x010],%g2		! %g2 = f8c1c7ce7bfedd14
	membar	#Sync			! Added by membar checker (206)
!	Branch On Register, %l7 = 00000000979e8607
	brgez,a,pt %l7,p4_b13		! Branch Taken
!	Mem[0000000070800024] = e4a37c8e, %l2 = b3e8dd6d78bc26a4
	ldub	[%o1+0x025],%l2		! %l2 = 00000000000000a3
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p4_branch_failed
	mov	0x00d,%g2
p4_b13:
!	Mem[0000000021800008] = ffeb966d, %l7 = 00000000979e8607
	ldsha	[%i3+%o6]0x80,%l7	! %l7 = ffffffffffffffeb
!	Mem[0000000071800024] = 0b1a7096, %l6 = fffffffffffff63f
	lduw	[%o3+0x024],%l6		! %l6 = 000000000b1a7096

p4_label_21:
!	Mem[0000000071000064] = 0fe80262, %l1 = 000000000000002b
	lduw	[%o2+0x064],%l1		! %l1 = 000000000fe80262
!	Mem[0000000072000044] = d9e516b5, %l4 = 000000007ad70106
	lduh	[%o4+0x046],%g2		! %g2 = 000000000000d9e5
!	Mem[0000000021000000] = 09d41ea95a0fab6a, %l0 = 7ad70106b5fd6f02
	ldxa	[%i2+%g0]0x80,%l0	! %l0 = 09d41ea95a0fab6a
!	Mem[0000000020000008] = ffd98230, %l0 = 09d41ea95a0fab6a
	ldswa	[%i0+%o6]0x80,%l0	! %l0 = ffffffffffd98230
!	Mem[0000000021000040] = bb30ab1b 47bf1dff 26b2dd15 782a8a4c
!	Mem[0000000021000050] = e44961d2 e48d292d 41e27d3a d07fc195
!	Mem[0000000021000060] = 87e51edb 480c57a1 1540acdf ac2782f2
!	Mem[0000000021000070] = 636115de dc3069b1 5a008b8d 9fbfe0e4
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000021000040

p4_label_22:
!	%f0  = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f4  = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f8  = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f12 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 0000000021800000
!	Mem[0000000071000060] = 53410a550fe80262, %l4 = 000000007ad70106
	ldx	[%o2+0x060],%l4		! %l4 = 53410a550fe80262
!	Mem[0000000070000020] = 76a843ed, %l1 = 000000000fe80262
	lduw	[%o0+0x020],%l1		! %l1 = 0000000076a843ed
!	Mem[0000000021800068] = 4eb1e641, %l5 = 00000000000000a1
	ldub	[%i3+0x068],%l5		! %l5 = 000000000000004e
!	Mem[0000000072000028] = 672805f9c6c2069f, %l0 = ffffffffffd98230
	ldxa	[%o4+0x028]%asi,%g2	! %g2 = 672805f9c6c2069f

p4_label_23:
!	Mem[0000000021000008] = 7ad70106, %l6 = 000000000b1a7096
	lduha	[%i2+%o6]0x80,%l6	! %l6 = 0000000000007ad7
!	Mem[0000000070000060] = 7eca9833, %l0 = ffffffffffd98230
	ldub	[%o0+0x061],%l0		! %l0 = 00000000000000ca
!	Mem[00000000200000c0] = d22e3da8 cc46a1da e0b2eb55 d83cdd48
!	Mem[00000000200000d0] = 4aa05b1d 58ef64c7 f66bbe7e 976a3eaf
!	Mem[00000000200000e0] = 0b6ba8c1 941875ca bbcc7441 630764f2
!	Mem[00000000200000f0] = e4bccce9 fb7a252f cdc292fa 45b45ff0
	ldda	[%i0+%g6]ASI_BLK_P,%f16	! Block Load from 00000000200000c0
!	Mem[0000000021000058] = 41e27d3ad07fc195, %l3 = ffffffffffffffa3
	ldx	[%i2+0x058],%l3		! %l3 = 41e27d3ad07fc195
!	Mem[0000000021000000] = 09d41ea9, %l2 = 00000000000000a3
	lduha	[%i2+%g0]0x80,%l2	! %l2 = 00000000000009d4

p4_label_24:
!	Mem[0000000070000020] = 76a843ed7e3b287e, %l5 = 000000000000004e
	ldx	[%o0+0x020],%l5		! %l5 = 76a843ed7e3b287e
!	Mem[0000000072000040] = 8afbcecf aeb6d9e5 16b5a45c 8435b825
!	Mem[0000000072000050] = 8e541da7 f99d23a6 7b8e3b92 a2044ef8
!	Mem[0000000072000060] = 00e1207a 99c9e7e2 1cff1ac6 d842c5f3
!	Mem[0000000072000070] = f3d07b16 c7fa7728 fd8ec032 1812bc03
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040
!	Mem[0000000021000088] = abfd2116b17d9219, %l3 = 41e27d3ad07fc195
	ldx	[%i2+0x088],%l3		! %l3 = abfd2116b17d9219
!	Mem[0000000071800060] = 199e44064cdf3caf, %l2 = 00000000000009d4
	ldx	[%o3+0x060],%l2		! %l2 = 199e44064cdf3caf
!	Mem[0000000021000008] = 7ad70106, %l3 = abfd2116b17d9219
	ldstuba	[%i2+%o6]0x80,%l3	! %l3 = 000000000000007a

p4_label_25:
!	%f16 = d22e3da8 cc46a1da e0b2eb55 d83cdd48
!	%f20 = 4aa05b1d 58ef64c7 f66bbe7e 976a3eaf
!	%f24 = 0b6ba8c1 941875ca bbcc7441 630764f2
!	%f28 = e4bccce9 fb7a252f cdc292fa 45b45ff0
	stda	%f16,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000021000080
!	Mem[0000000021800040] = 3ec9f1ce cae2249d fb83e6ee 53f607eb
!	Mem[0000000021800050] = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	Mem[0000000021800060] = a41d792f 54b32bea 4eb1e641 99ed48f5
!	Mem[0000000021800070] = a38b4b1e 876cec47 6c15cf56 c54b779b
	ldda	[%i3+%g5]ASI_BLK_P,%f16	! Block Load from 0000000021800040
	membar	#Sync			! Added by membar checker (207)
!	Mem[0000000021800038] = 493a0e3e, %l4 = 53410a550fe80262
	lduwa	[%i3+0x038]%asi,%l4	! %l4 = 00000000493a0e3e
!	%f0  = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f4  = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f8  = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f12 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f0,[%i3+%g4]ASI_BLK_PL	! Block Store to 0000000021800080
!	Mem[0000000071800060] = 199e4406 4cdf3caf, %l2 = 4cdf3caf, %l3 = 0000007a
	ldda	[%o3+0x060]%asi,%l2	! %l2 = 00000000199e4406 000000004cdf3caf

p4_label_26:
!	%l5 = 76a843ed7e3b287e
	setx	0xf7cb2ed4f7cb2ed4,%g7,%l5 ! %l5 = f7cb2ed4f7cb2ed4
!	%f16 = 3ec9f1ce cae2249d fb83e6ee 53f607eb
!	%f20 = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f24 = a41d792f 54b32bea 4eb1e641 99ed48f5
!	%f28 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 0000000020000080
!	Mem[0000000071000020] = 83a9fc6f, %l7 = ffffffffffffffeb
	lduw	[%o2+0x020],%l7		! %l7 = 0000000083a9fc6f
!	Mem[0000000021000000] = 09d41ea9, %l0 = 00000000000000ca
	lduwa	[%i2+%g0]0x80,%l0	! %l0 = 0000000009d41ea9
	membar	#Sync
	bn,a	p4_not_taken_0		! Branch Not Taken, %ccr = 88

p4_label_27:
!	Mem[0000000070000064] = ea0cd282, %l4 = 00000000493a0e3e
	ldsh	[%o0+0x064],%l4		! Annulled
p4_b14:
!	Mem[0000000020000000] = caa151a6, %l4 = 00000000493a0e3e
	lduha	[%i0+%g0]0x80,%l4	! %l4 = 000000000000caa1
!	%f16 = 3ec9f1ce cae2249d fb83e6ee 53f607eb
!	%f20 = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f24 = a41d792f 54b32bea 4eb1e641 99ed48f5
!	%f28 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000218000c0
!	Mem[0000000020000080] = 9d24e2ca cef1c93e eb07f653 eee683fb
!	Mem[0000000020000090] = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	Mem[00000000200000a0] = ea2bb354 2f791da4 f548ed99 41e6b14e
!	Mem[00000000200000b0] = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	ldda	[%i0+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000020000080
	membar	#Sync			! Added by membar checker (208)
	set	p4_b15,%o7
	fbuge,pt %fcc2,p4_near_1_he	! Branch Taken, %fcc2 = 0

p4_label_28:
!	Mem[00000000208000c8] = bc2355ce, %l7 = 0000000083a9fc6f
	ldsh	[%i1+0x0c8],%l7		! %l7 = ffffffffffffbc23
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p4_branch_failed
	mov	0x00f,%g2
p4_b15:
!	Registers modified during the branch to p4_near_1
!	%l4  = ffffffffd22e3da8
!	%f16 = 3ec9f1ce cae2249d fb83e6ee 53f607eb
!	%f20 = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f24 = a41d792f 54b32bea 4eb1e641 99ed48f5
!	%f28 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f16,[%i0]ASI_BLK_P	! Block Store to 0000000020000000
	bneg	p4_b16			! Branch Taken, %ccr = 88, CWP = 0
!	%f10 = 4eb1e641, %f8  = a41d792f
	fstoi	%f10,%f8 		! %f8  = 58f32080
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x010,%g2
p4_b16:
!	Mem[0000000072000000] = 83b01c70 8df87f7c b31464d8 d92aa2db
!	Mem[0000000072000010] = f8c1c7ce 7bfedd14 b5705fd5 67ee565b
!	Mem[0000000072000020] = 1cfb8826 b15bd8a5 672805f9 c6c2069f
!	Mem[0000000072000030] = 790dd6f6 d3242102 388ca041 0f0f3369
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000

p4_label_29:
!	Mem[0000000072000020] = 1cfb8826b15bd8a5, %l5 = f7cb2ed4f7cb2ed4
	ldx	[%o4+0x020],%g2		! %g2 = 1cfb8826b15bd8a5
!	Mem[0000000070000024] = 7e3b287e, %l1 = 0000000076a843ed
	ldsb	[%o0+0x025],%l1		! %l1 = 000000000000003b
!	Mem[0000000072000028] = 672805f9c6c2069f, %l0 = 0000000009d41ea9
	ldxa	[%o4+0x028]%asi,%g2	! %g2 = 672805f9c6c2069f
!	Mem[0000000071800024] = 0b1a7096, %l0 = 0000000009d41ea9
	ldub	[%o3+0x027],%l0		! %l0 = 0000000000000096
!	%f26 = 4eb1e641, %f0  = 3ec9f1ce
	fstoi	%f26,%f0 		! %f0  = 58f32080

p4_label_30:
!	Mem[0000000020800008] = abfd2116b17d9219, %l5 = f7cb2ed4f7cb2ed4
	ldxa	[%i1+%o6]0x80,%l5	! %l5 = abfd2116b17d9219
!	%f30 = 6c15cf56 c54b779b, %f16 = 3ec9f1ce cae2249d
	fnegd	%f30,%f16		! %f16 = ec15cf56 c54b779b
!	Mem[0000000021000020] = 295958ed2d2183e0, %l1 = 000000000000003b
	ldx	[%i2+0x020],%l1		! %l1 = 295958ed2d2183e0
!	Mem[0000000020800050] = da814620 1f97cd1a, %l6 = 00007ad7, %l7 = ffffbc23
	ldda	[%i1+0x050]%asi,%l6	! %l6 = 00000000da814620 000000001f97cd1a
!	%l7 = 000000001f97cd1a, %l2 = 00000000199e4406, %l3 = 000000004cdf3caf
	and	%l7,%l2,%l3		! %l3 = 0000000019964402

p4_label_31:
!	Mem[0000000070800060] = 528fae7d, %l7 = 000000001f97cd1a
	lduba	[%o1+0x062]%asi,%l7	! %l7 = 00000000000000ae
!	%f0  = 58f32080 cae2249d fb83e6ee 53f607eb
!	%f4  = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f8  = 58f32080 54b32bea 4eb1e641 99ed48f5
!	%f12 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f0,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000218000c0
!	%f0  = 58f32080 cae2249d fb83e6ee 53f607eb
!	%f4  = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f8  = 58f32080 54b32bea 4eb1e641 99ed48f5
!	%f12 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f0,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000020000040
	fblg	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[000000002180005c] = d68eb8ab, %l7 = 00000000000000ae
	ldub	[%i3+0x05f],%l7		! %l7 = 00000000000000ab
p4_b17:

p4_label_32:
!	%f28 = a38b4b1e, %f28 = a38b4b1e
	fcmpes	%fcc2,%f28,%f28		! %fcc2 = 0
	membar	#Sync			! Added by membar checker (209)
!	%f0  = 58f32080 cae2249d fb83e6ee 53f607eb
!	%f4  = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f8  = 58f32080 54b32bea 4eb1e641 99ed48f5
!	%f12 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f0,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000020000040
!	%f16 = ec15cf56 c54b779b fb83e6ee 53f607eb
!	%f20 = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f24 = a41d792f 54b32bea 4eb1e641 99ed48f5
!	%f28 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000021800080
!	Mem[00000000208000c0] = 6ef3bda158d3cfec, %l3 = 0000000019964402
	ldx	[%i1+0x0c0],%l3		! %l3 = 6ef3bda158d3cfec
!	%l3 = 6ef3bda158d3cfec
	sethi	%hi(0x0466a400),%l3	! %l3 = 000000000466a400

p4_label_33:
!	Mem[0000000021000000] = 09d41ea95a0fab6a, %l5 = abfd2116b17d9219
	ldxa	[%i2+%g0]0x80,%l5	! %l5 = 09d41ea95a0fab6a
	membar	#Sync			! Added by membar checker (210)
!	%f16 = ec15cf56 c54b779b fb83e6ee 53f607eb
!	%f20 = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	%f24 = a41d792f 54b32bea 4eb1e641 99ed48f5
!	%f28 = a38b4b1e 876cec47 6c15cf56 c54b779b
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 0000000021800080
!	Mem[00000000210000c0] = db8eb013 07869e97 19927db1 1621fdab
!	Mem[00000000210000d0] = da814620 1f97cd1a 0011b7ca 4fbf80b0
!	Mem[00000000210000e0] = 3d1a4960 fb9db09c 479425fe 1531a644
!	Mem[00000000210000f0] = e0daa36a 959eadc1 31a1f6eb ae91be61
	ldda	[%i2+%g6]ASI_BLK_PL,%f16	! Block Load from 00000000210000c0
!	Mem[0000000020800008] = abfd2116, %l7 = 00000000000000ab
	ldsha	[%i1+%o6]0x80,%l7	! %l7 = ffffffffffffabfd
!	%l4 = d22e3da8, %l5 = 5a0fab6a, Mem[0000000070000060] = 7eca9833 ea0cd282
	stda	%l4,[%o0+0x060]%asi	! Mem[0000000070000060] = d22e3da8 5a0fab6a

p4_label_34:
!	Mem[0000000020000008] = fb83e6ee 53f607eb, %l6 = da814620, %l7 = ffffabfd
	ldda	[%i0+%o6]0x80,%l6	! %l6 = 00000000fb83e6ee 0000000053f607eb
!	%f1  = cae2249d, %f1  = cae2249d, %f12 = a38b4b1e
	fadds	%f1 ,%f1 ,%f12		! %f12 = cb62249d
!	Mem[0000000021000060] = 87e51edb 480c57a1 1540acdf ac2782f2
	prefetcha [%i2+0x060]%asi,1
!	%l6 = 00000000fb83e6ee, Mem[0000000072000034] = d3242102
	stwa	%l6,[%o4+0x034]%asi	! Mem[0000000072000034] = fb83e6ee
!	Mem[0000000070800020] = ad733243, %l1 = 295958ed2d2183e0
	ldswa	[%o1+0x020]%asi,%l1	! %l1 = ffffffffad733243

p4_label_35:
	membar	#Sync			! Added by membar checker (211)
!	%f16 = 979e8607 13b08edb abfd2116 b17d9219
!	%f20 = 1acd971f 204681da b080bf4f cab71100
!	%f24 = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f28 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f16,[%i3+%g4]ASI_BLK_P	! Block Store to 0000000021800080
!	%l0 = 0000000000000096, %l4 = ffffffffd22e3da8, %y  = 00000000
	sdiv	%l0,%l4,%l1		! %l1 = 0000000000000000
	mov	%l0,%y			! %y = 00000096
!	%l6 = fb83e6ee, %l7 = 53f607eb, Mem[00000000200000d8] = f66bbe7e 976a3eaf
	stda	%l6,[%i0+0x0d8]%asi	! Mem[00000000200000d8] = fb83e6ee 53f607eb
!	Mem[00000000200000bc] = 56cf156c, %l5 = 09d41ea95a0fab6a
	ldsha	[%i0+0x0bc]%asi,%l5	! %l5 = 00000000000056cf
!	Mem[0000000021800000] = 09d41ea9, %l1 = 0000000000000000
	lduha	[%i3+%g0]0x80,%l1	! %l1 = 00000000000009d4

p4_label_36:
!	Mem[0000000020000000] = 3ec9f1ce cae2249d fb83e6ee 53f607eb
!	Mem[0000000020000010] = 5ac8c259 ee9978ae d8959efa d68eb8ab
!	Mem[0000000020000020] = a41d792f 54b32bea 4eb1e641 99ed48f5
!	Mem[0000000020000030] = a38b4b1e 876cec47 6c15cf56 c54b779b
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000020000000
!	Mem[0000000071800064] = 4cdf3caf, %l0 = 0000000000000096
	ldsb	[%o3+0x064],%l0		! %l0 = 000000000000004c
!	Mem[0000000020800008] = abfd2116, %l6 = 00000000fb83e6ee
	ldsha	[%i1+%o6]0x80,%l6	! %l6 = ffffffffffffabfd
	ble	p4_b18			! Branch Taken, %ccr = 88, CWP = 0
!	Mem[00000000208000b8] = 493a0e3e0b46e7b9, %l1 = 00000000000009d4
	ldx	[%i1+0x0b8],%l1		! %l1 = 493a0e3e0b46e7b9
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p4_branch_failed
	mov	0x012,%g2
p4_b18:

p4_label_37:
	membar	#Sync			! Added by membar checker (212)
	set	p4_b19,%o7
	fbue,a,pt %fcc2,p4_near_1_le	! Branch Taken, %fcc2 = 0
!	Mem[0000000070000060] = d22e3da8 5a0fab6a, %l0 = 0000004c, %l1 = 0b46e7b9
	ldd	[%o0+0x060],%l0		! %l0 = 00000000d22e3da8 000000005a0fab6a
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x013,%g2
p4_b19:
!	Registers modified during the branch to p4_near_1
!	%l0  = 000000000000589d
!	%l3  = fffffffffffffc21
	set	p4_b20,%o7
	fbuge,pn %fcc1,p4_near_3_le	! Branch Taken, %fcc1 = 0
!	Mem[000000007200005c] = f800e120, %l4 = ffffffffd22e3da8
	ldsb	[%o4+0x05f],%g2		! %g2 = fffffffffffffff8
!	The following code should not be executed
	lduha	[%i1+0x0a8]%asi,%l4
	ldsba	[%o2+0x047]%asi,%l3
	stda	%f16,[%i0]ASI_BLK_PL
	stda	%f0,[%i4]ASI_BLK_PL
	stda	%f32,[%i1]ASI_BLK_PL
	ba	p4_branch_failed
	mov	0x014,%g2
p4_b20:
!	Registers modified during the branch to p4_near_3
!	%l0  = 000000000000004b
!	%l1  = 000000000000003c
!	Mem[0000000072000060] = 00e1207a 99c9e7e2, %l6 = ffffabfd, %l7 = 53f607eb
	ldda	[%o4+0x060]%asi,%g2	! %l6 = ffffffffffffabfd 0000000053f607eb

p4_label_38:
!	Mem[0000000020000030] = a38b4b1e, %l0 = 000000000000004b
	ldsh	[%i0+0x032],%l0		! %l0 = 0000000000004b1e
!	%l2 = 199e4406, %l3 = fffffc21, Mem[0000000071800060] = 199e4406 4cdf3caf
	std	%l2,[%o3+0x060]	! Mem[0000000071800060] = 199e4406 fffffc21
!	Mem[0000000071800064] = fffffc21, %l0 = 0000000000004b1e
	ldsb	[%o3+0x067],%l0		! %l0 = 0000000000000021
!	Mem[0000000020800008] = abfd2116, %l2 = 00000000199e4406
	ldswa	[%i1+%o6]0x80,%l2	! %l2 = ffffffffabfd2116
	fbg,pt	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0

p4_label_39:
!	%l5 = 00000000000056cf, immed = fffffe49, %l0 = 0000000000000021
	addcc	%l5,-0x1b7,%l0		! %l0 = 0000000000005518, %ccr = 11
p4_b21:
!	Mem[0000000020800080] = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	Mem[0000000020800090] = 228154fd c4007477 483d8ca5 c7db1ab2
!	Mem[00000000208000a0] = 295958ed 2d2183e0 51e70b27 33081cfa
!	Mem[00000000208000b0] = 576c7424 963b3a02 493a0e3e 0b46e7b9
	ldda	[%i1+%g4]ASI_BLK_P,%f0	! Block Load from 0000000020800080
!	Mem[0000000071000060] = 53410a550fe80262, %l4 = ffffffffd22e3da8
	ldx	[%o2+0x060],%l4		! %l4 = 53410a550fe80262
!	Mem[0000000021000000] = 09d41ea9, %l0 = 0000000000005518
	ldsba	[%i2+%g0]0x80,%l0	! %l0 = 0000000000000009
!	Mem[0000000021800080] = 979e8607 13b08edb abfd2116 b17d9219
!	Mem[0000000021800090] = 1acd971f 204681da b080bf4f cab71100
!	Mem[00000000218000a0] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[00000000218000b0] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%i3+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000021800080

p4_label_40:
!	%l6 = ffffffffffffabfd
	setx	0xbc8b0635bc8b0635,%g7,%l6 ! %l6 = bc8b0635bc8b0635
!	Mem[00000000200000f0] = e4bccce956cf252f, %l5 = 00000000000056cf
	ldx	[%i0+0x0f0],%l5		! %l5 = e4bccce956cf252f
!	Mem[0000000022800000] = c0d03bc2, %l7 = 0000000053f607eb
	lduha	[%i5+%g0]0x80,%l7	! %l7 = 000000000000c0d0
	membar	#Sync			! Added by membar checker (213)
	set	p4_b22,%o7
	fbge,pn	%fcc2,p4_near_2_le	! Branch Taken, %fcc2 = 0
!	Mem[0000000021800008] = 7ad70106, %l3 = fffffffffffffc21
	lduha	[%i3+%o6]0x80,%l3	! %l3 = 0000000000007ad7
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x016,%g2
p4_b22:
!	Registers modified during the branch to p4_near_2
!	%l1  = abb88ed6fa9e95d8
!	%l3  = d22e3da85a0fab6a
!	%l6  = 00000000000000ee

p4_label_41:
!	Mem[00000000200000a8] = f548ed9941e6b14e, %l0 = 0000000000000009
	ldx	[%i0+0x0a8],%l0		! %l0 = f548ed9941e6b14e
!	Mem[00000000200000d4] = 58ef64c7, %l5 = e4bccce956cf252f
	ldsb	[%i0+0x0d5],%l5		! %l5 = ffffffffffffffef
!	Mem[0000000022800040] = ce6129ec 28c3c056 347ff39f 0b170dac
!	Mem[0000000022800050] = dee1eaa3 d9a493dc 9ecd4aa3 80a677f9
!	Mem[0000000022800060] = e2708c20 37562d6d fcc94f2c 10574c4d
!	Mem[0000000022800070] = 0ce98d9f cbaf0e49 056ce0a3 4f97cf80
	ldda	[%i5+%g5]ASI_BLK_P,%f16	! Block Load from 0000000022800040
!	%l7 = 000000000000c0d0, %l6 = 00000000000000ee, %y  = 00000096
	smulcc	%l7,%l6,%l3		! %l3 = 0000000000b34160, %ccr = 00
!	Mem[0000000070000020] = 76a843ed7e3b287e, %l3 = 0000000000b34160, %l4 = 53410a550fe80262
	add	%o0,0x20,%g1
	casxa	[%g1]0x80,%l3,%l4	! %l4 = 76a843ed7e3b287e

p4_label_42:
	nop
!	Mem[0000000020000080] = 9d24e2ca cef1c93e eb07f653 eee683fb
!	Mem[0000000020000090] = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	Mem[00000000200000a0] = ea2bb354 2f791da4 f548ed99 41e6b14e
!	Mem[00000000200000b0] = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000020000080
!	%f16 = ce6129ec 28c3c056 347ff39f 0b170dac
!	%f20 = dee1eaa3 d9a493dc 9ecd4aa3 80a677f9
!	%f24 = e2708c20 37562d6d fcc94f2c 10574c4d
!	%f28 = 0ce98d9f cbaf0e49 056ce0a3 4f97cf80
	stda	%f16,[%i0+%g6]ASI_BLK_P	! Block Store to 00000000200000c0
!	Mem[0000000071800060] = 199e4406 fffffc21, %l2 = abfd2116, %l3 = 00b34160
	ldd	[%o3+0x060],%l2		! %l2 = 00000000199e4406 00000000fffffc21
	membar	#Sync
	fbn,a,pt %fcc3,p4_branch_failed	! Branch Not Taken, %fcc3 = 0

p4_label_43:
!	Mem[00000000230000c0] = 97429938f8187324, %l0 = f548ed9941e6b14e
	ldx	[%i6+0x0c0],%l0		! Annulled
p4_b23:
!	Mem[0000000021000040] = bb30ab1b 47bf1dff 26b2dd15 782a8a4c
!	Mem[0000000021000050] = e44961d2 e48d292d 41e27d3a d07fc195
!	Mem[0000000021000060] = 87e51edb 480c57a1 1540acdf ac2782f2
!	Mem[0000000021000070] = 636115de dc3069b1 5a008b8d 9fbfe0e4
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000021000040
!	Mem[00000000210000c0] = db8eb01307869e97, %l6 = 00000000000000ee
	ldx	[%i2+0x0c0],%l6		! %l6 = db8eb01307869e97
!	Mem[000000002180007c] = c54b779b, %l0 = f548ed9941e6b14e
	ldsha	[%i3+0x07e]%asi,%l0	! %l0 = 000000000000779b
!	%f5  = 59c2c85a, %f9  = 2f791da4
	fcmps	%fcc1,%f5 ,%f9 		! %fcc1 = 2

p4_label_44:
!	%f0  = 9d24e2ca cef1c93e eb07f653 eee683fb
!	%f4  = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	%f8  = ea2bb354 2f791da4 f548ed99 41e6b14e
!	%f12 = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	stda	%f0,[%i2+%g4]ASI_BLK_P	! Block Store to 0000000021000080
!	Mem[0000000071000060] = 53410a550fe80262, %l5 = ffffffffffffffef
	ldx	[%o2+0x060],%l5		! %l5 = 53410a550fe80262
!	Mem[00000000200000cc] = 0b170dac, %l1 = abb88ed6fa9e95d8
	ldsba	[%i0+0x0cf]%asi,%l1	! %l1 = ffffffffffffffac
!	%f16 = bb30ab1b 47bf1dff 26b2dd15 782a8a4c
!	%f20 = e44961d2 e48d292d 41e27d3a d07fc195
!	%f24 = 87e51edb 480c57a1 1540acdf ac2782f2
!	%f28 = 636115de dc3069b1 5a008b8d 9fbfe0e4
	stda	%f16,[%i0]ASI_BLK_P	! Block Store to 0000000020000000
!	Mem[000000002180001c] = c7db1ab2, %l3 = 00000000fffffc21
	ldsh	[%i3+0x01c],%l3		! %l3 = ffffffffffffc7db

p4_label_45:
	membar	#Sync
	fbug,pn	%fcc3,p4_branch_failed	! Branch Not Taken, %fcc3 = 0
!	%l0 = 000000000000779b, immed = fffffa5c, %y  = 00000000
	mulx	%l0,-0x5a4,%l7		! %l7 = fffffffffd5d59b4
p4_b24:
!	Mem[00000000208000c0] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[00000000208000d0] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000208000e0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000208000f0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 00000000208000c0
	membar	#Sync			! Added by membar checker (214)
	set	p4_b25,%o7
	fble,pt	%fcc0,p4_near_2_he	! Branch Taken, %fcc0 = 0
!	Mem[0000000021800048] = fb83e6ee, %l2 = 00000000199e4406
	ldsh	[%i3+0x04a],%l2		! %l2 = ffffffffffffe6ee
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x019,%g2
p4_b25:
!	Registers modified during the branch to p4_near_2
!	%l1  = 000000000000007a
!	%l3  = 000000005a0fab6a
!	%l5  = 00000000dc3069b1
!	%l7  = fb83e6ee53f607eb

p4_label_46:
!	Mem[0000000021800080] = 979e8607 13b08edb abfd2116 b17d9219
!	Mem[0000000021800090] = 1acd971f 204681da b080bf4f cab71100
!	Mem[00000000218000a0] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[00000000218000b0] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%i3+%g4]ASI_BLK_PL,%f0	! Block Load from 0000000021800080
!	Mem[000000002180005e] = d68eb8ab, %l0 = 000000000000779b
	ldstuba	[%i3+0x05e]%asi,%l0	! %l0 = 00000000000000b8
!	%f0  = db8eb013 07869e97 19927db1 1621fdab
!	%f4  = da814620 1f97cd1a 0011b7ca 4fbf80b0
!	%f8  = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f12 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f0,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
	membar	#Sync			! Added by membar checker (215)
	set	p4_b26,%o7
	fba,a,pt %fcc1,p4_near_3_he	! Branch Taken, %fcc1 = 2
!	Mem[000000002000007c] = 56cf156c, %l0 = 00000000000000b8
	ldsh	[%i0+0x07c],%l0		! Annulled
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x01a,%g2
p4_b26:
!	Registers modified during the branch to p4_near_3
!	%l5  = 80369602c3cd4d03

p4_label_47:
!	Mem[0000000020000044] = 8020f358, %l0 = 00000000000000b8
	lduba	[%i0+0x045]%asi,%l0	! %l0 = 0000000000000020
!	Mem[000000002180002c] = 33081cfa, %l0 = 0000000000000020
	ldsba	[%i3+0x02f]%asi,%l0	! %l0 = fffffffffffffffa
!	%f0  = db8eb013 07869e97 19927db1 1621fdab
!	%f4  = da814620 1f97cd1a 0011b7ca 4fbf80b0
!	%f8  = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f12 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f0,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
!	Mem[00000000218000b8] = 61be91ae, %l5 = 80369602c3cd4d03
	ldswa	[%i3+0x0b8]%asi,%l5	! %l5 = 0000000061be91ae
!	Mem[0000000021000070] = 636115de, %l2 = ffffffffffffe6ee
	ldub	[%i2+0x070],%l2		! %l2 = 0000000000000063

p4_label_48:
!	Mem[0000000070800064] = f8c7c699, %l7 = fb83e6ee53f607eb
	ldsw	[%o1+0x064],%l7		! %l7 = fffffffff8c7c699
!	%l6 = db8eb01307869e97, immed = 00000b0d, %y  = 00000000
	udivx	%l6,0xb0d,%l5		! %l5 = 0013de37ee2d0593
!	Mem[0000000071800060] = 199e4406 fffffc21, %l2 = 00000063, %l3 = 5a0fab6a
	ldd	[%o3+0x060],%l2		! %l2 = 00000000199e4406 00000000fffffc21
!	%f16 = bb30ab1b 47bf1dff 26b2dd15 782a8a4c
!	%f20 = e44961d2 e48d292d 41e27d3a d07fc195
!	%f24 = 87e51edb 480c57a1 1540acdf ac2782f2
!	%f28 = 636115de dc3069b1 5a008b8d 9fbfe0e4
	stda	%f16,[%i0+%g6]ASI_BLK_PL	! Block Store to 00000000200000c0
!	Mem[00000000210000d8] = 0011b7ca, %l6 = db8eb01307869e97
	lduw	[%i2+0x0d8],%l6		! %l6 = 000000000011b7ca

p4_label_49:
!	Mem[0000000072000004] = 8df87f7c, %l6 = 000000000011b7ca
	lduha	[%o4+0x004]%asi,%g2	! %g2 = 0000000000008df8
!	Mem[0000000020000080] = 9d24e2ca cef1c93e eb07f653 eee683fb
!	Mem[0000000020000090] = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	Mem[00000000200000a0] = ea2bb354 2f791da4 f548ed99 41e6b14e
!	Mem[00000000200000b0] = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000020000080
!	Mem[00000000208000c0] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[00000000208000d0] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000208000e0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000208000f0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i1+%g6]ASI_BLK_P,%f0	! Block Load from 00000000208000c0
!	Mem[0000000020000008] = 26b2dd15, %l6 = 000000000011b7ca
	swapa	[%i0+%o6]0x80,%l6	! %l6 = 0000000026b2dd15
!	Mem[0000000071800020] = acf2718b, %l0 = fffffffffffffffa
	lduw	[%o3+0x020],%l0		! %l0 = 00000000acf2718b

p4_label_50:
!	Jump to jmpl_2, CWP = 0
	membar	#Sync			! Added by membar checker (216)
	set	p4_jmpl_2_he,%g1
	jmpl	%g1,%g6
!	Mem[0000000020000000] = bb30ab1b, %l5 = 0013de37ee2d0593
	lduwa	[%i0+%g0]0x80,%l5	! %l5 = 00000000bb30ab1b
!	Registers modified during the branch to p4_jmpl_2
!	%l0  = 528fae7df8c7c699
!	%l4  = 000000005a008b8d
!	%l7  = 000000000000fc6f
!	Mem[0000000020000040] = 9d24e2ca 8020f358 eb07f653 eee683fb
!	Mem[0000000020000050] = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	Mem[0000000020000060] = ea2bb354 8020f358 f548ed99 41e6b14e
!	Mem[0000000020000070] = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 0000000020000040
!	%f0  = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	%f4  = 0ac0efc4 5e15de2e 15557d1d c1788640
!	%f8  = 65ae1df8 6298df2a da14c6eb 6378ece9
!	%f12 = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	mov	0x0c0,%g6
	stda	%f0,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000210000c0
!	Mem[0000000071800000] = 00000000 00007bf4 0000001f 00005a4e
	prefetcha [%o3+0x000]%asi,21

p4_label_51:
!	%f0  = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	%f4  = 0ac0efc4 5e15de2e 15557d1d c1788640
!	%f8  = 65ae1df8 6298df2a da14c6eb 6378ece9
!	%f12 = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	stda	%f0,[%i6+%g5]ASI_BLK_P	! Block Store to 0000000023000040
!	%f0  = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	%f4  = 0ac0efc4 5e15de2e 15557d1d c1788640
!	%f8  = 65ae1df8 6298df2a da14c6eb 6378ece9
!	%f12 = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	stda	%f0,[%i0+%g4]ASI_BLK_P	! Block Store to 0000000020000080
!	%f0  = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	%f4  = 0ac0efc4 5e15de2e 15557d1d c1788640
!	%f8  = 65ae1df8 6298df2a da14c6eb 6378ece9
!	%f12 = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	stda	%f0,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	Mem[0000000020000040] = 9d24e2ca 8020f358 eb07f653 eee683fb
!	Mem[0000000020000050] = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	Mem[0000000020000060] = ea2bb354 8020f358 f548ed99 41e6b14e
!	Mem[0000000020000070] = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	ldda	[%i0+%g5]ASI_BLK_P,%f16	! Block Load from 0000000020000040
	membar	#Sync			! Added by membar checker (217)
!	Mem[0000000072000038] = 8c6b54aa65b62ed6, %l0 = 528fae7df8c7c699
	ldx	[%o4+0x038],%g2		! %g2 = 8c6b54aa65b62ed6

p4_label_52:
!	Mem[0000000020000080] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[0000000020000090] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000200000a0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000200000b0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000020000080
!	Mem[00000000200000bc] = 65b62ed6, %l7 = 000000000000fc6f
	lduwa	[%i0+0x0bc]%asi,%l7	! %l7 = 0000000065b62ed6
!	%l4 = 000000005a008b8d, Mem[0000000071800020] = acf2718b0b1a7096
	stxa	%l4,[%o3+0x020]%asi	! Mem[0000000071800020] = 000000005a008b8d
!	Mem[0000000021000080] = 9d24e2ca cef1c93e eb07f653 eee683fb
!	Mem[0000000021000090] = ae7899ee 59c2c85a abb88ed6 fa9e95d8
!	Mem[00000000210000a0] = ea2bb354 2f791da4 f548ed99 41e6b14e
!	Mem[00000000210000b0] = 47ec6c87 1e4b8ba3 9b774bc5 56cf156c
	ldda	[%i2+%g4]ASI_BLK_P,%f16	! Block Load from 0000000021000080
!	Mem[00000000208000b8] = 493a0e3e 0b46e7b9, %l6 = 26b2dd15, %l7 = 65b62ed6
	ldd	[%i1+0x0b8],%l6		! %l6 = 00000000493a0e3e 000000000b46e7b9

p4_label_53:
!	%l6 = 00000000493a0e3e, immed = fffff355, %l4 = 000000005a008b8d
	andn	%l6,-0xcab,%l4		! %l4 = 0000000000000c2a
!	Mem[00000000218000d0] = 5ac8c259ee9978ae, %f2  = bc2355ce 09938e07
	ldd	[%i3+0x0d0],%f2 	! %f2  = 5ac8c259 ee9978ae
	fbl	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000021800000] = 09d41ea9, %l5 = 00000000bb30ab1b
	ldswa	[%i3+%g0]0x80,%l5	! %l5 = 0000000009d41ea9
p4_b27:
	membar	#Sync			! Added by membar checker (218)
	set	p4_b28,%o7
	fblg,pt	%fcc1,p4_near_2_le	! Branch Taken, %fcc1 = 2

p4_label_54:
!	Mem[0000000020000008] = 0011b7ca, %l5 = 0000000009d41ea9
	ldswa	[%i0+%o6]0x80,%l5	! %l5 = 000000000011b7ca
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p4_branch_failed
	mov	0x01c,%g2
p4_b28:
!	Registers modified during the branch to p4_near_2
!	%l1  = abb88ed6fa9e95d8
!	%l3  = d22e3da85a0fab6a
!	%l6  = 00000000000000ee
	fbl,pt	%fcc3,p4_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[00000000218000c8] = fb83e6ee, %l7 = 000000000b46e7b9
	ldsh	[%i3+0x0c8],%l7		! %l7 = fffffffffffffb83
p4_b29:
!	Mem[0000000023000000] = e6bf1a74 7a041c3b 35d13147 526ebb46
!	Mem[0000000023000010] = 4cf4da3c 4690f9ea a2db0588 36d1f139
!	Mem[0000000023000020] = 56575e8c 13fbf957 5c9c01b7 4881c574
!	Mem[0000000023000030] = 2499ec7c 96903968 66a66930 df963e0a
	ldda	[%i6]ASI_BLK_P,%f16	! Block Load from 0000000023000000
!	Mem[00000000200000c0] = ff1dbf47 1bab30bb 4c8a2a78 15ddb226
!	Mem[00000000200000d0] = 2d298de4 d26149e4 95c17fd0 3a7de241
!	Mem[00000000200000e0] = a1570c48 db1ee587 f28227ac dfac4015
!	Mem[00000000200000f0] = b16930dc de156163 e4e0bf9f 8d8b005a
	ldda	[%i0+%g6]ASI_BLK_P,%f0	! Block Load from 00000000200000c0

p4_label_55:
	bcs,a	p4_not_taken_0		! Branch Not Taken, %ccr = 00
!	%l7 = fffffffffffffb83, %l4 = 0000000000000c2a, %l5 = 000000000011b7ca
	xnorcc	%l7,%l4,%l5		! Annulled
p4_b30:
!	%f27 = 4881c574, %f16 = e6bf1a74 7a041c3b
	fstod	%f27,%f16		! %f16 = 411038ae 80000000
!	Mem[0000000022000090] = 10866aab, %l0 = 528fae7df8c7c699
	lduha	[%i4+0x090]%asi,%l0	! %l0 = 0000000000001086
!	Mem[0000000071800024] = 5a008b8d, %l3 = d22e3da85a0fab6a
	ldsw	[%o3+0x024],%l3		! %l3 = 000000005a008b8d

p4_label_56:
!	%f16 = 411038ae 80000000 35d13147 526ebb46
!	%f20 = 4cf4da3c 4690f9ea a2db0588 36d1f139
!	%f24 = 56575e8c 13fbf957 5c9c01b7 4881c574
!	%f28 = 2499ec7c 96903968 66a66930 df963e0a
	stda	%f16,[%i3+%g6]ASI_BLK_P	! Block Store to 00000000218000c0
!	%l4 = 0000000000000c2a, %l6 = 00000000000000ee, %l3 = 000000005a008b8d
	sllx	%l4,%l6,%l3		! %l3 = 030a800000000000
!	Mem[0000000021000008] = ffd70106, %l2 = 00000000199e4406
	ldsha	[%i2+%o6]0x80,%l2	! %l2 = ffffffffffffffd7
!	Mem[0000000020000000] = bb30ab1b 47bf1dff 0011b7ca 782a8a4c
!	Mem[0000000020000010] = e44961d2 e48d292d 41e27d3a d07fc195
!	Mem[0000000020000020] = 87e51edb 480c57a1 1540acdf ac2782f2
!	Mem[0000000020000030] = 636115de dc3069b1 5a008b8d 9fbfe0e4
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000020000000
!	Mem[0000000021800008] = 7ad70106, %l6 = 00000000000000ee
	ldsha	[%i3+%o6]0x80,%l6	! %l6 = 0000000000007ad7

p4_label_57:
!	Mem[000000002280004c] = 0b170dac, %l2 = ffffffffffffffd7
	ldsha	[%i5+0x04c]%asi,%l2	! %l2 = 0000000000000b17
!	Mem[0000000021000008] = ffd70106, %l6 = 0000000000007ad7
	lduha	[%i2+%o6]0x80,%l6	! %l6 = 000000000000ffd7
!	%f32 = f2f6a42d c1d7f210 44061be9 c3501086
!	%f36 = 838b3e2f 519bbb5a f58d987a b4d0b30d
!	%f40 = 4b64df38 eb686f39 17dc06f0 04b54e0d
!	%f44 = e245e869 f9f2af2b e1154e10 003e9da8
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
	fblg,a,pt %fcc2,p4_branch_failed	! Branch Not Taken, %fcc2 = 0
!	Mem[0000000022800008] = 839fdbb0, %l4 = 0000000000000c2a
	ldswa	[%i5+%o6]0x80,%l4	! Annulled
p4_b31:

p4_label_58:
!	Mem[00000000200000e0] = a1570c48, %l2 = 0000000000000b17
	lduwa	[%i0+0x0e0]%asi,%l2	! %l2 = 00000000a1570c48
!	Mem[0000000070000024] = 7e3b287e, %l6 = 000000000000ffd7
	lduw	[%o0+0x024],%l6		! %l6 = 000000007e3b287e
!	Mem[0000000021800000] = 09d41ea95a0fab6a, %l4 = 0000000000000c2a
	ldxa	[%i3+%g0]0x80,%l4	! %l4 = 09d41ea95a0fab6a
!	Mem[0000000071800020] = 00000000, %l0 = 0000000000001086
	ldub	[%o3+0x021],%l0		! %l0 = 0000000000000000
!	Mem[0000000070000060] = d22e3da8, %l6 = 000000007e3b287e
	lduba	[%o0+0x063]%asi,%l6	! %l6 = 00000000000000a8

p4_label_59:
!	Mem[0000000071000024] = 7adcc322, %l1 = abb88ed6fa9e95d8
	ldsha	[%o2+0x024]%asi,%l1	! %l1 = 0000000000007adc
!	%f16 = ff1dbf47 1bab30bb 4c8a2a78 cab71100
!	%f20 = 2d298de4 d26149e4 95c17fd0 3a7de241
!	%f24 = a1570c48 db1ee587 f28227ac dfac4015
!	%f28 = b16930dc de156163 e4e0bf9f 8d8b005a
	stda	%f16,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040
!	%l6 = 00000000000000a8, %l0 = 0000000000000000, %y  = 00000000
	smulcc	%l6,%l0,%l4		! %l4 = 0000000000000000, %ccr = 44
!	Mem[0000000070800064] = f8c7c699, %l0 = 0000000000000000
	ldsba	[%o1+0x064]%asi,%l0	! %l0 = fffffffffffffff8
	membar	#Sync			! Added by membar checker (219)
!	Mem[00000000218000c0] = 411038ae 80000000 35d13147 526ebb46
!	Mem[00000000218000d0] = 4cf4da3c 4690f9ea a2db0588 36d1f139
!	Mem[00000000218000e0] = 56575e8c 13fbf957 5c9c01b7 4881c574
!	Mem[00000000218000f0] = 2499ec7c 96903968 66a66930 df963e0a
	ldda	[%i3+%g6]ASI_BLK_P,%f0	! Block Load from 00000000218000c0

p4_label_60:
!	%l3 = 030a800000000000, %l1 = 0000000000007adc, %l0 = fffffffffffffff8
	orncc	%l3,%l1,%l0		! %l0 = ffffffffffff8523, %ccr = 88
	fbul,a,pn %fcc2,p4_branch_failed	! Branch Not Taken, %fcc2 = 0
!	%f30 = e4e0bf9f 8d8b005a, %f26 = f28227ac dfac4015
	fcmped	%fcc3,%f30,%f26	! Annulled
p4_b32:
!	Mem[0000000021800078] = 6c15cf56c54b779b, %l5 = 000000000011b7ca
	ldx	[%i3+0x078],%l5		! %l5 = 6c15cf56c54b779b
!	Mem[0000000020800048] = 19927db1, %l3 = 030a800000000000
	ldswa	[%i1+0x048]%asi,%l3	! %l3 = 0000000019927db1

p4_label_61:
!	%l1 = 0000000000007adc, immed = 0000000f, %l2 = 00000000a1570c48
	sllx	%l1,0x00f,%l2		! %l2 = 000000003d6e0000
!	%l5 = 6c15cf56c54b779b, immed = 0000000a, %l4 = 0000000000000000
	sllx	%l5,0x00a,%l4		! %l4 = 573d5b152dde6c00
!	Mem[0000000020800008] = abfd2116, %l0 = ffffffffffff8523
	ldsba	[%i1+%o6]0x80,%l0	! %l0 = ffffffffffffffab
!	Mem[0000000021000038] = 493a0e3e, %l4 = 573d5b152dde6c00
	lduw	[%i2+0x038],%l4		! %l4 = 00000000493a0e3e
!	Mem[0000000020800000] = 979e8607 13b08edb abfd2116 b17d9219
!	Mem[0000000020800010] = 1acd971f 204681da b080bf4f a04bf89b
!	Mem[0000000020800020] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[0000000020800030] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%i1]ASI_BLK_PL,%f16	! Block Load from 0000000020800000

p4_label_62:
!	%f16 = db8eb013 07869e97 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%i2+%g6]ASI_BLK_P	! Block Store to 00000000210000c0
!	Mem[0000000071000020] = 83a9fc6f, %l0 = ffffffffffffffab
	lduha	[%o2+0x022]%asi,%l0	! %l0 = 000000000000fc6f
!	Mem[0000000020000008] = 0011b7ca, %l7 = fffffffffffffb83
	lduha	[%i0+%o6]0x80,%l7	! %l7 = 0000000000000011
!	Mem[0000000020000000] = bb30ab1b 47bf1dff 0011b7ca 782a8a4c
!	Mem[0000000020000010] = e44961d2 e48d292d 41e27d3a d07fc195
!	Mem[0000000020000020] = 87e51edb 480c57a1 1540acdf ac2782f2
!	Mem[0000000020000030] = 636115de dc3069b1 5a008b8d 9fbfe0e4
	ldda	[%i0]ASI_BLK_PL,%f0	! Block Load from 0000000020000000
!	Mem[0000000070800060] = 528fae7d, %l6 = 00000000000000a8
	ldsh	[%o1+0x060],%l6		! %l6 = 000000000000528f

p4_label_63:
!	Mem[0000000021000040] = bb30ab1b47bf1dff, %l4 = 00000000493a0e3e
	ldx	[%i2+0x040],%l4		! %l4 = bb30ab1b47bf1dff
!	Branch On Register, %l3 = 0000000019927db1
	brz,a,pn %l3,p4_not_taken_0	! Branch Not Taken
!	Mem[0000000020000000] = bb30ab1b, %l0 = 000000000000fc6f
	ldsha	[%i0+%g0]0x80,%l0	! Annulled
p4_b33:
!	Mem[0000000070800020] = ad733243e4a37c8e, %l5 = 6c15cf56c54b779b
	ldx	[%o1+0x020],%l5		! %l5 = ad733243e4a37c8e
!	Mem[0000000070800024] = e4a37c8e, %l4 = bb30ab1b47bf1dff
	lduw	[%o1+0x024],%l4		! %l4 = 00000000e4a37c8e

p4_label_64:
!	Mem[0000000020800000] = 979e8607, %l6 = 000000000000528f
	ldsha	[%i1+%g0]0x80,%l6	! %l6 = ffffffffffff979e
!	Branch On Register, %l0 = 000000000000fc6f
	brz,a,pt %l0,p4_not_taken_0	! Branch Not Taken
!	Mem[0000000020800008] = abfd2116, %l6 = ffffffffffff979e
	ldsba	[%i1+%o6]0x80,%l6	! Annulled
p4_b34:
!	Mem[0000000020000090] = 0ac0efc4, %l5 = ad733243e4a37c8e
	lduba	[%i0+0x092]%asi,%l5	! %l5 = 00000000000000ef
!	Mem[0000000072000040] = ff1dbf47 1bab30bb 4c8a2a78 cab71100
!	Mem[0000000072000050] = 2d298de4 d26149e4 95c17fd0 3a7de241
!	Mem[0000000072000060] = a1570c48 db1ee587 f28227ac dfac4015
!	Mem[0000000072000070] = b16930dc de156163 e4e0bf9f 8d8b005a
	ldda	[%o4+%g5]ASI_BLK_P,%f48	! Block Load from 0000000072000040

p4_label_65:
!	Mem[0000000070000060] = d22e3da8, %l5 = 00000000000000ef
	lduh	[%o0+0x062],%l5		! %l5 = 0000000000003da8
!	Mem[0000000071800060] = 19064406fffffc21, %l6 = ffffffffffff979e
	ldx	[%o3+0x060],%l6		! %l6 = 19064406fffffc21
!	Mem[0000000071800060] = 19064406fffffc21, %l0 = 000000000000fc6f
	ldx	[%o3+0x060],%l0		! %l0 = 19064406fffffc21
!	%f16 = db8eb013 07869e97 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[00000000218000a0] = 9cb09dfb60491a3d, %l2 = 000000003d6e0000
	ldx	[%i3+0x0a0],%l2		! %l2 = 9cb09dfb60491a3d

p4_label_66:
!	Mem[0000000070000024] = 7e3b287e, %l2 = 9cb09dfb60491a3d
	ldsh	[%o0+0x026],%l2		! %l2 = 000000000000287e
	bn	p4_not_taken_0		! Branch Not Taken, %ccr = 88
!	Mem[0000000021000008] = ffd70106, %l7 = 0000000000000011
	ldsha	[%i2+%o6]0x80,%l7	! %l7 = ffffffffffffffd7
p4_b35:
!	%l3 = 0000000019927db1, immed = 0000072c, %l5 = 0000000000003da8
	xor	%l3,0x72c,%l5		! %l5 = 0000000019927a9d
!	Mem[0000000070000020] = 76a843ed, %l3 = 0000000019927db1
	ldsb	[%o0+0x021],%l3		! %l3 = ffffffffffffffa8

p4_label_67:
!	Mem[0000000021000098] = abb88ed6, %l6 = 19064406fffffc21
	ldsw	[%i2+0x098],%l6		! %l6 = ffffffffabb88ed6
	fbg	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000071000020] = 83a9fc6f7adcc322, %l5 = 0000000019927a9d
	ldx	[%o2+0x020],%l5		! %l5 = 83a9fc6f7adcc322
p4_b36:
	fblg,a,pt %fcc3,p4_branch_failed	! Branch Not Taken, %fcc3 = 0
!	Mem[0000000020000000] = bb30ab1b47bf1dff, %l1 = 0000000000007adc
	ldxa	[%i0+%g0]0x80,%l1	! Annulled
p4_b37:

p4_label_68:
!	Mem[0000000021000000] = 09d41ea9 5a0fab6a ffd70106 b5fd6f02
!	Mem[0000000021000010] = 228154fd c4007477 483d8ca5 c7db1ab2
!	Mem[0000000021000020] = 295958ed 2d2183e0 51e70b27 33081cfa
!	Mem[0000000021000030] = 576c7424 963b3a02 493a0e3e 0b46e7b9
	ldda	[%i2]ASI_BLK_P,%f0	! Block Load from 0000000021000000
!	Mem[000000002080008c] = b5fd6f02, %l4 = 00000000e4a37c8e
	ldsba	[%i1+0x08d]%asi,%l4	! %l4 = fffffffffffffffd
!	Mem[0000000020800008] = abfd2116, %l4 = fffffffffffffffd
	lduwa	[%i1+0x008]%asi,%l4	! %l4 = 00000000abfd2116
!	Mem[0000000071800027] = 5a008b8d, %l4 = 00000000abfd2116
	ldstuba	[%o3+0x027]%asi,%l4	! %l4 = 000000000000008d
!	Mem[0000000021800008] = 7ad70106, %l6 = ffffffffabb88ed6
	ldswa	[%i3+%o6]0x80,%l6	! %l6 = 000000007ad70106

p4_label_69:
!	call to call_1, CWP = 0
	membar	#Sync			! Added by membar checker (220)
	call	p4_call_1_he
!	%l6 = 000000007ad70106, %l6 = 000000007ad70106, %y  = 00000000
	smulcc	%l6,%l6,%l4		! %l4 = 3af1a18c70150c24, %ccr = 00
!	Registers modified during the branch to p4_call_1
!	%l0  = 0000000019064406
!	%l1  = 00000000fffffc21
!	%l2  = 228154fdc4007477
!	%l4  = 0000000076a843ed
!	%l5  = 000000007e3b287e
!	%l6  = 83a9fc6f7adcc322
!	Branch On Register, %l0 = 0000000019064406
	brgez,pt %l0,p4_b38		! Branch Taken
!	%f2  = ffd70106 b5fd6f02, %f2  = ffd70106 b5fd6f02, %f14 = 493a0e3e 0b46e7b9
	fdivd	%f2 ,%f2 ,%f14		! %f14 = 3ff00000 00000000
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p4_branch_failed
	mov	0x026,%g2
p4_b38:
!	Mem[000000002080004c] = 1621fdab, %l1 = 00000000fffffc21
	lduba	[%i1+0x04f]%asi,%l1	! %l1 = 00000000000000ab

p4_label_70:
	set	p4_b39,%o7
	fba,a	p4_far_2_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000020800080] = 09d41ea9, %l2 = 228154fdc4007477
	ldsw	[%i1+0x080],%l2		! Annulled
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p4_branch_failed
	mov	0x027,%g2
p4_b39:
!	Registers modified during the branch to p4_far_2
!	%l0  = 00000000493a0e3e
!	%l1  = 000000000b46e7b9
!	%l2  = ffffffffffffffdf
!	%l4  = ea2bb3542f791da4
!	%l6  = 0000000076a85059
!	%l7  = 528fae7df8c7c699
!	Mem[0000000020000080] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[0000000020000090] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000200000a0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000200000b0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i0+%g4]ASI_BLK_P,%f0	! Block Load from 0000000020000080
!	%f16 = db8eb013 07869e97 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	Mem[0000000020800090] = 228154fdc4007477, %l2 = ffffffffffffffdf
	ldx	[%i1+0x090],%l2		! %l2 = 228154fdc4007477

p4_label_71:
!	Mem[0000000021800008] = 7ad70106, %l2 = 228154fdc4007477
	ldsha	[%i3+%o6]0x80,%l2	! %l2 = 0000000000007ad7
!	%l4 = ea2bb3542f791da4
	setx	0x449926c7449926c7,%g7,%l4 ! %l4 = 449926c7449926c7
!	Mem[0000000071800060] = 19064406fffffc21, %l2 = 0000000000007ad7
	ldx	[%o3+0x060],%l2		! %l2 = 19064406fffffc21
!	Mem[0000000020800000] = 979e8607, %l7 = 528fae7df8c7c699
	lduwa	[%i1+%g0]0x80,%l7	! %l7 = 00000000979e8607
	membar	#Sync			! Added by membar checker (221)
!	Mem[0000000072000040] = 979e8607 13b08edb abfd2116 b17d9219
!	Mem[0000000072000050] = 1acd971f 204681da b080bf4f a04bf89b
!	Mem[0000000072000060] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[0000000072000070] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040

p4_label_72:
!	%f16 = db8eb013 07869e97 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%i0+%g5]ASI_BLK_PL	! Block Store to 0000000020000040
!	Mem[0000000020000008] = 0011b7ca, %l1 = 000000000b46e7b9
	lduha	[%i0+%o6]0x80,%l1	! %l1 = 0000000000000011
!	Mem[0000000020800000] = 979e860713b08edb, %l2 = 19064406fffffc21
	ldxa	[%i1+%g0]0x80,%l2	! %l2 = 979e860713b08edb
!	Mem[0000000020800008] = abfd2116 b17d9219, %l4 = 449926c7, %l5 = 7e3b287e
	ldda	[%i1+%o6]0x80,%l4	! %l4 = 00000000abfd2116 00000000b17d9219
!	%f16 = db8eb013 07869e97 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%o4+%g5]ASI_BLK_P	! Block Store to 0000000072000040

p4_label_73:
!	Mem[0000000020000000] = bb30ab1b, %l0 = 00000000493a0e3e
	ldswa	[%i0+%g0]0x80,%l0	! %l0 = ffffffffbb30ab1b
!	Mem[0000000021800080] = 979e8607 13b08edb abfd2116 b17d9219
!	Mem[0000000021800090] = 1acd971f 204681da b080bf4f cab71100
!	Mem[00000000218000a0] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[00000000218000b0] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 0000000021800080
	fblg,a	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000020800084] = 5a0fab6a, %l7 = 00000000979e8607
	ldub	[%i1+0x084],%l7		! Annulled
p4_b40:
!	Mem[000000002180005c] = d68effab, %l0 = ffffffffbb30ab1b
	ldsh	[%i3+0x05e],%l0		! %l0 = ffffffffffffffab

p4_label_74:
!	Mem[0000000020800014] = 204681da, %l5 = b17d9219, %l0 = ffffffab
	add	%i1,0x14,%g1
	casa	[%g1]0x80,%l5,%l0	! %l0 = 00000000204681da
	membar	#Sync			! Added by membar checker (222)
!	Mem[0000000072000040] = db8eb013 07869e97 19927db1 1621fdab
!	Mem[0000000072000050] = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	Mem[0000000072000060] = 3d1a4960 fb9db09c 479425fe 1531a644
!	Mem[0000000072000070] = e0daa36a 959eadc1 31a1f6eb ae91be61
	ldda	[%o4+%g5]ASI_BLK_PL,%f48	! Block Load from 0000000072000040
!	%f16 = db8eb013 07869e97 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%i2+%g5]ASI_BLK_P	! Block Store to 0000000021000040
	membar	#Sync			! Added by membar checker (223)
	set	p4_b41,%o7
	fba,pt	%fcc2,p4_near_1_le	! Branch Taken, %fcc2 = 0
!	Mem[0000000021800000] = 09d41ea9, %l5 = 00000000b17d9219
	ldswa	[%i3+%g0]0x80,%l5	! %l5 = 0000000009d41ea9
!	The following code should not be executed
	ldsb	[%i2+0x055],%l5
	ldda	[%i3+0x000]%asi,%l0
	ldx	[%i2+0x038],%l2
	stda	%f32,[%i4]ASI_BLK_PL
	ldsw	[%i2+0x03c],%l6
	ldsba	[%i0+0x088]%asi,%l5
	nop
	ba	p4_branch_failed
	mov	0x029,%g2
p4_b41:
!	Registers modified during the branch to p4_near_1
!	%l0  = ffffffff8957a339
!	%l3  = ffffffffffffffa9

p4_label_75:
!	Mem[0000000071800020] = 00000000, %l0 = ffffffff8957a339
	lduba	[%o3+0x021]%asi,%l0	! %l0 = 0000000000000000
!	%f32 = f2f6a42d c1d7f210 44061be9 c3501086
!	%f36 = 838b3e2f 519bbb5a f58d987a b4d0b30d
!	%f40 = 4b64df38 eb686f39 17dc06f0 04b54e0d
!	%f44 = e245e869 f9f2af2b e1154e10 003e9da8
	stda	%f32,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[0000000020000080] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[0000000020000090] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000200000a0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000200000b0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i0+%g4]ASI_BLK_PL,%f16	! Block Load from 0000000020000080
!	Mem[0000000020800008] = abfd2116b17d9219, %l7 = 00000000979e8607
	ldxa	[%i1+%o6]0x80,%l7	! %l7 = abfd2116b17d9219
!	%l2 = 13b08edb, %l3 = ffffffa9, Mem[0000000070000060] = d22e3da8 5a0fab6a
	stda	%l2,[%o0+0x060]%asi	! Mem[0000000070000060] = 13b08edb ffffffa9

p4_label_76:
!	%f16 = eccfd358 a1bdf36e 078e9309 ce5523bc
!	%f20 = 2ede155e c4efc00a 408678c1 1d7d5515
!	%f24 = 2adf9862 f81dae65 e9ec7863 ebc614da
!	%f28 = 088e96f6 8885ccf4 d62eb665 aa546b8c
	stda	%f16,[%i1+%g6]ASI_BLK_PL	! Block Store to 00000000208000c0
!	Mem[0000000070800060] = 528fae7d f8c7c699 9c4d073f cc67e033
	prefetcha [%o1+0x060]%asi,1
!	Mem[0000000070000024] = 7e3b287e, %l7 = abfd2116b17d9219
	lduwa	[%o0+0x024]%asi,%l7	! %l7 = 000000007e3b287e
!	Mem[0000000070000020] = 76a843ed7e3b287e, %l2 = 979e860713b08edb
	ldxa	[%o0+0x020]%asi,%l2	! %l2 = 76a843ed7e3b287e
!	call to call_3, CWP = 0
	membar	#Sync			! Added by membar checker (224)
	call	p4_call_3_le

p4_label_77:
!	%l0 = 0000000000000000, immed = fffff73e, %l5 = 0000000009d41ea9
	orcc	%l0,-0x8c2,%l5		! %l5 = fffffffffffff73e, %ccr = 88
!	Registers modified during the branch to p4_call_3
!	%l4  = 00000000abfd2116
!	%l5  = 00000000b17d9219
!	%l7  = 0000000000000056
!	Mem[0000000071800024] = 5a008bff, %l2 = 76a843ed7e3b287e
	ldub	[%o3+0x024],%l2		! %l2 = 000000000000005a
!	%l7 = 0000000000000056, immed = 00000ef7, %l1 = 0000000000000011
	xorcc	%l7,0xef7,%l1		! %l1 = 0000000000000ea1, %ccr = 00
!	Mem[0000000021800008] = 7ad70106 b5fd6f02, %l4 = abfd2116, %l5 = b17d9219
	ldda	[%i3+%o6]0x80,%l4	! %l4 = 000000007ad70106 00000000b5fd6f02
!	%f16 = eccfd358 a1bdf36e 078e9309 ce5523bc
!	%f20 = 2ede155e c4efc00a 408678c1 1d7d5515
!	%f24 = 2adf9862 f81dae65 e9ec7863 ebc614da
!	%f28 = 088e96f6 8885ccf4 d62eb665 aa546b8c
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 0000000021000080

p4_label_78:
!	Mem[00000000218000c0] = 411038ae 80000000 35d13147 526ebb46
!	Mem[00000000218000d0] = 4cf4da3c 4690f9ea a2db0588 36d1f139
!	Mem[00000000218000e0] = 56575e8c 13fbf957 5c9c01b7 4881c574
!	Mem[00000000218000f0] = 2499ec7c 96903968 66a66930 df963e0a
	ldda	[%i3+%g6]ASI_BLK_PL,%f16	! Block Load from 00000000218000c0
!	Mem[0000000071000060] = 53410a550fe80262, %l6 = 0000000076a85059
	ldx	[%o2+0x060],%l6		! %l6 = 53410a550fe80262
!	%f32 = f2f6a42d c1d7f210 44061be9 c3501086
!	%f36 = 838b3e2f 519bbb5a f58d987a b4d0b30d
!	%f40 = 4b64df38 eb686f39 17dc06f0 04b54e0d
!	%f44 = e245e869 f9f2af2b e1154e10 003e9da8
	stda	%f32,[%o4]ASI_BLK_P	! Block Store to 0000000072000000
!	%l0 = 0000000000000000, %l5 = 00000000b5fd6f02, %y  = 3af1a18c
	sdiv	%l0,%l5,%l3		! %l3 = ffffffff80000000
	mov	%l0,%y			! %y = 00000000
!	%l4 = 000000007ad70106
	setx	0xa19cd027a19cd027,%g7,%l4 ! %l4 = a19cd027a19cd027

p4_label_79:
!	Mem[0000000070000020] = 76a843ed7e3b287e, %l0 = 0000000000000000
	ldx	[%o0+0x020],%l0		! %l0 = 76a843ed7e3b287e
!	%f16 = 00000080 ae381041 46bb6e52 4731d135
!	%f20 = eaf99046 3cdaf44c 39f1d136 8805dba2
!	%f24 = 57f9fb13 8c5e5756 74c58148 b7019c5c
!	%f28 = 68399096 7cec9924 0a3e96df 3069a666
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000021800040
!	Mem[0000000020000008] = 0011b7ca782a8a4c, %l0 = 76a843ed7e3b287e
	ldxa	[%i0+%o6]0x80,%l0	! %l0 = 0011b7ca782a8a4c
!	Mem[000000007200004c] = 1621fdab, %l7 = 0000000000000056
	lduh	[%o4+0x04c],%g2		! %g2 = 0000000000001621
!	Mem[0000000070800024] = e4a37c8e, %l4 = a19cd027a19cd027
	lduw	[%o1+0x024],%l4		! %l4 = 00000000e4a37c8e

p4_label_80:
	membar	#Sync			! Added by membar checker (225)
	set	p4_b42,%o7
	fbue,a,pn %fcc3,p4_near_1_le	! Branch Taken, %fcc3 = 0
!	Mem[0000000021000020] = 295958ed2d2183e0, %l2 = 000000000000005a
	ldx	[%i2+0x020],%l2		! %l2 = 295958ed2d2183e0
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p4_branch_failed
	mov	0x02a,%g2
p4_b42:
!	Registers modified during the branch to p4_near_1
!	%l0  = acbef5aaf017f102
!	%l3  = fffffffffffff821
!	%l1 = 0000000000000ea1, %l7 = 0000000000000056, %l6 = 53410a550fe80262
	srlx	%l1,%l7,%l6		! %l6 = 0000000000000000
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f cab71100
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i0+%g6]ASI_BLK_P	! Block Store to 00000000200000c0
!	Mem[0000000070000020] = 76a843ed, %l5 = 00000000b5fd6f02
	swapa	[%o0+0x020]%asi,%l5	! %l5 = 0000000076a843ed

p4_label_81:
	membar	#Sync			! Added by membar checker (226)
	set	p4_b43,%o7
	fbge,pt	%fcc1,p4_near_2_he	! Branch Taken, %fcc1 = 2
!	Mem[0000000020800008] = abfd2116, %l3 = fffffffffffff821
	lduba	[%i1+%o6]0x80,%l3	! %l3 = 00000000000000ab
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p4_branch_failed
	mov	0x02b,%g2
p4_b43:
!	Registers modified during the branch to p4_near_2
!	%l1  = 000000000000007a
!	%l3  = 00000000ffffffa9
!	%l5  = 00000000959eadc1
!	%l7  = 46bb6e524731d135
!	%l5 = 00000000959eadc1, Mem[0000000021000000] = 09d41ea9
	stha	%l5,[%i2+%g0]0x80	! Mem[0000000021000000] = adc11ea9
!	Mem[0000000071000060] = 53410a55, %l1 = 000000000000007a
	ldsw	[%o2+0x060],%l1		! %l1 = 0000000053410a55
!	Mem[0000000021000040] = db8eb013 07869e97 19927db1 1621fdab
!	Mem[0000000021000050] = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	Mem[0000000021000060] = 3d1a4960 fb9db09c 479425fe 1531a644
!	Mem[0000000021000070] = e0daa36a 959eadc1 31a1f6eb ae91be61
	ldda	[%i2+%g5]ASI_BLK_P,%f16	! Block Load from 0000000021000040

p4_label_82:
!	Mem[0000000070800060] = 528fae7df8c7c699, %l2 = 295958ed2d2183e0
	ldx	[%o1+0x060],%l2		! %l2 = 528fae7df8c7c699
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f cab71100
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i3]ASI_BLK_P	! Block Store to 0000000021800000
!	Mem[0000000020800080] = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	Mem[0000000020800090] = 228154fd c4007477 483d8ca5 c7db1ab2
!	Mem[00000000208000a0] = 295958ed 2d2183e0 51e70b27 33081cfa
!	Mem[00000000208000b0] = 576c7424 963b3a02 493a0e3e 0b46e7b9
	ldda	[%i1+%g4]ASI_BLK_P,%f16	! Block Load from 0000000020800080
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i2+%g4]ASI_BLK_PL	! Block Store to 0000000021000080
!	Mem[0000000021000008] = ffd70106, %l5 = 00000000959eadc1
	ldsba	[%i2+%o6]0x80,%l5	! %l5 = ffffffffffffffff

p4_label_83:
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	%l2 = 528fae7df8c7c699
	sethi	%hi(0x7f5e0400),%l2	! %l2 = 000000007f5e0400
!	Mem[0000000071800060] = 19064406 fffffc21 2d869d36 b1198fa0
	prefetcha [%o3+0x060]%asi,23
	membar	#Sync			! Added by membar checker (227)
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%o4+%g5]ASI_BLK_PL	! Block Store to 0000000072000040
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i3+%g5]ASI_BLK_P	! Block Store to 0000000021800040

p4_label_84:
!	Mem[0000000072000000] = f2f6a42d c1d7f210 44061be9 c3501086
!	Mem[0000000072000010] = 838b3e2f 519bbb5a f58d987a b4d0b30d
!	Mem[0000000072000020] = 4b64df38 eb686f39 17dc06f0 04b54e0d
!	Mem[0000000072000030] = e245e869 f9f2af2b e1154e10 003e9da8
	ldda	[%o4]ASI_BLK_PL,%f48	! Block Load from 0000000072000000
	membar	#Sync			! Added by membar checker (228)
!	Mem[0000000072000074] = 6c57b9e7, %l5 = ffffffffffffffff
	ldsb	[%o4+0x076],%g2		! %g2 = 000000000000006c
!	Mem[0000000070000024] = 7e3b287e, %l0 = acbef5aaf017f102
	lduh	[%o0+0x024],%l0		! %l0 = 0000000000007e3b
!	Mem[0000000021000000] = adc11ea9 5a0fab6a ffd70106 b5fd6f02
!	Mem[0000000021000010] = 228154fd c4007477 483d8ca5 c7db1ab2
!	Mem[0000000021000020] = 295958ed 2d2183e0 51e70b27 33081cfa
!	Mem[0000000021000030] = 576c7424 963b3a02 493a0e3e 0b46e7b9
	ldda	[%i2]ASI_BLK_P,%f0	! Block Load from 0000000021000000
!	Mem[00000000218000e4] = 13fbf957, %l4 = 00000000e4a37c8e
	ldswa	[%i3+0x0e4]%asi,%l4	! %l4 = 0000000013fbf957

p4_label_85:
!	%l7 = 46bb6e524731d135, %l3 = 00000000ffffffa9, %y  = 00000000
	umul	%l7,%l3,%l7		! %l7 = 4731d11cce11e6fd
!	%l1 = 0000000053410a55, immed = 000006ab, %y  = 4731d11c
	umul	%l1,0x6ab,%l0		! %l0 = 0000022b22afe4c7
	fbne,a	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000071800064] = fffffc21, %l6 = 0000000000000000
	ldub	[%o3+0x066],%l6		! Annulled
p4_b44:
!	%f18 = 7ad70106, %f18 = 7ad70106
	fcmpes	%fcc0,%f18,%f18		! %fcc0 = 0

p4_label_86:
!	%l5 = ffffffffffffffff, immed = 00000416, %l6 = 0000000000000000
	xor	%l5,0x416,%l6		! %l6 = fffffffffffffbe9
!	Mem[0000000020000020] = 87e51edb480c57a1, %l2 = 000000007f5e0400
	ldxa	[%i0+0x020]%asi,%l2	! %l2 = 87e51edb480c57a1
!	Mem[0000000020000028] = 1540acdf, %l6 = fffffffffffffbe9
	ldswa	[%i0+0x028]%asi,%l6	! %l6 = 000000001540acdf
!	Mem[0000000021000000] = adc11ea9, %l0 = 0000022b22afe4c7
	lduba	[%i2+%g0]0x80,%l0	! %l0 = 00000000000000ad
!	Mem[0000000070800020] = ad733243, %l0 = 00000000000000ad
	ldsb	[%o1+0x020],%l0		! %l0 = ffffffffffffffad

p4_label_87:
!	Mem[0000000072000068] = 33270be7, %l2 = 87e51edb480c57a1
	ldsba	[%o4+0x06b]%asi,%g2	! %g2 = 0000000000000033
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i3+%g4]ASI_BLK_PL	! Block Store to 0000000021800080
!	Mem[0000000021000050] = da8146201f97cd1a, %l2 = 87e51edb480c57a1
	ldx	[%i2+0x050],%l2		! %l2 = da8146201f97cd1a
	membar	#Sync
	fblg,a	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000020000000] = bb30ab1b, %l3 = 00000000ffffffa9
	lduha	[%i0+%g0]0x80,%l3	! Annulled
p4_b45:

p4_label_88:
!	Mem[0000000021800034] = 6aa3dae0, %l0 = ffffffffffffffad
	lduw	[%i3+0x034],%l0		! %l0 = 000000006aa3dae0
	fbe,pn	%fcc1,p4_branch_failed	! Branch Not Taken, %fcc1 = 2
!	Mem[0000000071800064] = fffffc21, %l4 = 0000000013fbf957
	ldsb	[%o3+0x066],%l4		! %l4 = fffffffffffffffc
p4_b46:
!	%l2 = da8146201f97cd1a, Mem[0000000070800023] = ad733243
	stb	%l2,[%o1+0x023]		! Mem[0000000070800020] = ad73321a
!	Mem[0000000071800020] = 000000005a008bff, %l2 = da8146201f97cd1a
	ldx	[%o3+0x020],%l2		! %l2 = 000000005a008bff

p4_label_89:
!	Mem[00000000208000d0] = 0ac0efc45e15de2e, %l0 = 000000006aa3dae0
	ldx	[%i1+0x0d0],%l0		! %l0 = 0ac0efc45e15de2e
!	%f0  = adc11ea9 5a0fab6a ffd70106 b5fd6f02
!	%f4  = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f8  = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f12 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f0,[%o4]ASI_BLK_PL	! Block Store to 0000000072000000
!	Mem[00000000210000b0] = 023a3b9624746c57, %l7 = 4731d11cce11e6fd
	ldx	[%i2+0x0b0],%l7		! %l7 = 023a3b9624746c57
!	Mem[0000000021000000] = adc11ea9 5a0fab6a, %l4 = fffffffc, %l5 = ffffffff
	ldda	[%i2+%g0]0x80,%l4	! %l4 = 00000000adc11ea9 000000005a0fab6a
!	Mem[00000000210000b4] = 24746c57, %l7 = 023a3b9624746c57
	ldsw	[%i2+0x0b4],%l7		! %l7 = 0000000024746c57

p4_label_90:
	membar	#Sync			! Added by membar checker (229)
!	Mem[0000000072000018] = b21adbc7, %l5 = 000000005a0fab6a
	ldswa	[%o4+0x018]%asi,%g2	! %g2 = 000000005a0fab6a
!	Mem[00000000208000c0] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[00000000208000d0] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000208000e0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000208000f0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i1+%g6]ASI_BLK_PL,%f0	! Block Load from 00000000208000c0
!	Mem[0000000071000020] = 83a9fc6f 7adcc322 4c8025ec 2baa22fa
	prefetch [%o2+0x020],1
!	Mem[0000000070800064] = f8c7c699, %l2 = 000000005a008bff
	ldsb	[%o1+0x065],%l2		! %l2 = ffffffffffffffc7
!	Mem[0000000071800020] = 00000000, %l0 = 0ac0efc45e15de2e
	ldsha	[%o3+0x020]%asi,%l0	! %l0 = 0000000000000000

p4_label_91:
!	Mem[0000000021800000] = 979e8607, %l4 = 00000000adc11ea9
	ldsba	[%i3+%g0]0x80,%l4	! %l4 = ffffffffffffff97
!	Mem[0000000020800000] = 979e8607, %l2 = ffffffffffffffc7
	lduha	[%i1+%g0]0x80,%l2	! %l2 = 000000000000979e
!	Mem[0000000022000070] = 2c00b801, %l1 = 0000000053410a55
	ldub	[%i4+0x071],%l1		! %l1 = 0000000000000000
!	Mem[0000000020000020] = 87e51edb, %l5 = 000000005a0fab6a
	ldswa	[%i0+0x020]%asi,%l5	! %l5 = ffffffff87e51edb
!	Mem[0000000071000060] = 53410a55 0fe80262, %l2 = 0000979e, %l3 = ffffffa9
	ldd	[%o2+0x060],%l2		! %l2 = 0000000053410a55 000000000fe80262

p4_label_92:
!	Mem[0000000071800060] = 19064406fffffc21, %l7 = 0000000024746c57
	ldxa	[%o3+0x060]%asi,%l7	! %l7 = 19064406fffffc21
!	Mem[000000002180006c] = 33081cfa, %l4 = ffffffffffffff97
	lduh	[%i3+0x06c],%l4		! %l4 = 0000000000003308
!	%f0  = eccfd358 a1bdf36e 078e9309 ce5523bc
!	%f4  = 2ede155e c4efc00a 408678c1 1d7d5515
!	%f8  = 2adf9862 f81dae65 e9ec7863 ebc614da
!	%f12 = 088e96f6 8885ccf4 d62eb665 aa546b8c
	stda	%f0,[%i1+%g5]ASI_BLK_PL	! Block Store to 0000000020800040
!	Mem[0000000070800060] = 528fae7d, %l5 = ffffffff87e51edb
	ldub	[%o1+0x062],%l5		! %l5 = 00000000000000ae
	membar	#Sync			! Added by membar checker (230)
!	Branch On Register, %l0 = 0000000000000000
	brlez,a,pt %l0,p4_b47		! Branch Taken

p4_label_93:
!	Mem[0000000070000020] = b5fd6f02, %l5 = 00000000000000ae
	ldsh	[%o0+0x022],%l5		! %l5 = 0000000000006f02
!	The following code should not be executed
	stda	%f32,[%i1]ASI_BLK_PL
	lduw	[%o1+0x040],%l4
	ldsb	[%o1+0x043],%l7
	lduha	[%i6+0x020]%asi,%l4
	stda	%f32,[%i1]ASI_BLK_PL
	stda	%f0,[%i0]ASI_BLK_PL
	ldda	[%i2]ASI_BLK_P,%f16
	lduha	[%i2+0x08a]%asi,%l4
	ba	p4_branch_failed
	mov	0x02f,%g2
p4_b47:
!	Mem[00000000210000a8] = fa1c0833270be751, %l5 = 0000000000006f02
	ldx	[%i2+0x0a8],%l5		! %l5 = fa1c0833270be751
!	Mem[0000000072000000] = 6aab0f5a a91ec1ad 026ffdb5 0601d7ff
!	Mem[0000000072000010] = 777400c4 fd548122 b21adbc7 a58c3d48
!	Mem[0000000072000020] = e083212d ed585929 fa1c0833 270be751
!	Mem[0000000072000030] = 023a3b96 24746c57 b9e7460b 3e0e3a49
	ldda	[%o4]ASI_BLK_P,%f48	! Block Load from 0000000072000000
	set	p4_b48,%o7
	fbuge	p4_far_0_he		! Branch Taken, %fcc0 = 0
!	Mem[0000000021800008] = abfd2116, %l1 = 0000000000000000
	ldswa	[%i3+%o6]0x80,%l1	! %l1 = ffffffffabfd2116
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba	p4_branch_failed
	mov	0x030,%g2
p4_b48:
!	Registers modified during the branch to p4_far_0
!	%l2  = e083212ded585929
!	%l3  = 00000000ffffffa9
!	%l6  = 9a9708b05e874206

p4_label_94:
	bcc,a	p4_b49			! Branch Taken, %ccr = 88, CWP = 0
!	Mem[0000000020800000] = 979e8607, %l3 = 00000000ffffffa9
	lduba	[%i1+%g0]0x80,%l3	! %l3 = 0000000000000097
!	The following code should not be executed
	stda	%f0,[%i4]ASI_BLK_PL
	ldsh	[%i2+0x018],%l2
	ldda	[%i2]ASI_BLK_P,%f32
	ldsha	[%i2+0x08c]%asi,%l6
	ldub	[%i3+0x06a],%l7
	ba	p4_branch_failed
	mov	0x031,%g2
p4_b49:
!	%l5 = fa1c0833270be751, immed = 000008f4, %l0 = 0000000000000000
	taddcc	%l5,0x8f4,%l0		! %l0 = fa1c0833270bf045, %ccr = 82
	set	p4_b50,%o7
	fbule,pn %fcc3,p4_near_2_le	! Branch Taken, %fcc3 = 0
!	%l7 = 19064406fffffc21, %l4 = 0000000000003308, %l0 = fa1c0833270bf045
	sub	%l7,%l4,%l0		! %l0 = 19064406ffffc919
!	The following code should not be executed
	std	%f16,[%i0+0x098]
	ldda	[%i3]ASI_BLK_P,%f0
	ldda	[%i1]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x032,%g2
p4_b50:
!	Registers modified during the branch to p4_near_2
!	%l1  = b080bf4fa04bf89b
!	%l3  = 13b08edbffffffa9
!	%l6  = 0000000000000046

p4_label_95:
!	Mem[0000000020000000] = bb30ab1b, %l4 = 0000000000003308
	ldsba	[%i0+%g0]0x80,%l4	! %l4 = ffffffffffffffbb
!	Mem[0000000021000098] = b21adbc7a58c3d48, %l4 = ffffffffffffffbb
	ldx	[%i2+0x098],%l4		! %l4 = b21adbc7a58c3d48
!	%l7 = 19064406fffffc21, Mem[00000000208000c8] = bc2355ce09938e07
	stx	%l7,[%i1+0x0c8]		! Mem[00000000208000c8] = 19064406fffffc21
!	Mem[00000000218000b0] = 023a3b9624746c57, %l2 = e083212ded585929
	ldx	[%i3+0x0b0],%l2		! %l2 = 023a3b9624746c57
!	Mem[00000000210000c0] = db8eb013 07869e97 19927db1 1621fdab
!	Mem[00000000210000d0] = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	Mem[00000000210000e0] = 3d1a4960 fb9db09c 479425fe 1531a644
!	Mem[00000000210000f0] = e0daa36a 959eadc1 31a1f6eb ae91be61
	ldda	[%i2+%g6]ASI_BLK_P,%f0	! Block Load from 00000000210000c0

p4_label_96:
!	Mem[0000000021000040] = db8eb013 07869e97 19927db1 1621fdab
!	Mem[0000000021000050] = da814620 1f97cd1a 9bf84ba0 4fbf80b0
!	Mem[0000000021000060] = 3d1a4960 fb9db09c 479425fe 1531a644
!	Mem[0000000021000070] = e0daa36a 959eadc1 31a1f6eb ae91be61
	ldda	[%i2+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000021000040
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i0]ASI_BLK_P	! Block Store to 0000000020000000
!	%l6 = 0000000000000046, %l3 = 13b08edbffffffa9, %y  = 0000022b
	mulx	%l6,%l3,%l1		! %l1 = 62471027ffffe836
!	Mem[0000000070000024] = 7e3b287e, %l7 = 19064406fffffc21
	ldsw	[%o0+0x024],%l7		! %l7 = 000000007e3b287e
!	Mem[0000000070800020] = ad73321a, %l7 = 000000007e3b287e
	lduh	[%o1+0x022],%l7		! %l7 = 000000000000321a

p4_label_97:
!	%f0  = 979e8607 13b08edb abfd2116 b17d9219
!	%f4  = 1acd971f 204681da b080bf4f a04bf89b
!	%f8  = 9cb09dfb 60491a3d 44a63115 fe259447
!	%f12 = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	stda	%f0,[%i2+%g5]ASI_BLK_PL	! Block Store to 0000000021000040
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i1+%g6]ASI_BLK_P	! Block Store to 00000000208000c0
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i0+%g5]ASI_BLK_P	! Block Store to 0000000020000040
!	Mem[0000000020800000] = 979e8607 13b08edb, %l6 = 00000046, %l7 = 0000321a
	ldd	[%i1+0x000],%l6		! %l6 = 00000000979e8607 0000000013b08edb
!	Mem[0000000070800060] = 528fae7df8c7c699, %l4 = b21adbc7a58c3d48
	ldx	[%o1+0x060],%l4		! %l4 = 528fae7df8c7c699

p4_label_98:
!	Mem[0000000070000020] = b5fd6f02, %l7 = 0000000013b08edb
	swapa	[%o0+0x020]%asi,%l7	! %l7 = 00000000b5fd6f02
!	Mem[0000000021000008] = ffd70106, %l6 = 00000000979e8607
	lduwa	[%i2+%o6]0x80,%l6	! %l6 = 00000000ffd70106
	membar	#Sync			! Added by membar checker (231)
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 295958ed 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i0]ASI_BLK_PL	! Block Store to 0000000020000000
	bgu	p4_b51			! Branch Taken, %ccr = 82, CWP = 0
!	Mem[0000000070800024] = e4a37c8e, %l1 = 62471027ffffe836
	ldsh	[%o1+0x024],%l1		! %l1 = ffffffffffffe4a3
!	The following code should not be executed
	ldsha	[%o0+0x042]%asi,%l6
	ldda	[%i3]ASI_BLK_P,%f0
	ba	p4_branch_failed
	mov	0x033,%g2
p4_b51:

p4_label_99:
!	Mem[00000000200000b4] = f6968e08, %l7 = 00000000b5fd6f02
	lduba	[%i0+0x0b5]%asi,%l7	! %l7 = 0000000000000096
!	%l1 = ffffffffffffe4a3, %l0 = 19064406ffffc919, %l2 = 023a3b9624746c57
	add	%l1,%l0,%l2		! %l2 = 19064406ffffadbc
!	Mem[0000000072000060] = 212ded58, %l4 = 528fae7df8c7c699
	ldsh	[%o4+0x062],%g2		! %g2 = 000000000000212d
!	Mem[0000000021800091] = 777400c4, %l0 = 19064406ffffc919
	ldstuba	[%i3+0x091]%asi,%l0	! %l0 = 0000000000000074
!	Mem[0000000020000080] = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	Mem[0000000020000090] = 0ac0efc4 5e15de2e 15557d1d c1788640
!	Mem[00000000200000a0] = 65ae1df8 6298df2a da14c6eb 6378ece9
!	Mem[00000000200000b0] = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	ldda	[%i0+%g4]ASI_BLK_P,%f16	! Block Load from 0000000020000080

p4_label_100:
!	Mem[00000000200000b4] = f6968e08, %l1 = ffffffffffffe4a3
	lduha	[%i0+0x0b4]%asi,%l1	! %l1 = 000000000000f696
!	Mem[0000000021800000] = 979e8607, %l0 = 0000000000000074
	lduha	[%i3+%g0]0x80,%l0	! %l0 = 000000000000979e
	membar	#Sync			! Added by membar checker (232)
!	Mem[0000000020000008] = 026ffdb5, %l0 = 000000000000979e
	ldsha	[%i0+0x008]%asi,%l0	! %l0 = 000000000000026f
!	Mem[0000000021800080] = 6aab0f5a a91ed409 026ffdb5 0601d77a
!	Mem[0000000021800090] = 77ff00c4 fd548122 b21adbc7 a58c3d48
!	Mem[00000000218000a0] = e083212d ed585929 fa1c0833 270be751
!	Mem[00000000218000b0] = 023a3b96 24746c57 b9e7460b 3e0e3a49
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 0000000021800080
!	%f0  = 6aab0f5a a91ed409 026ffdb5 0601d77a
!	%f4  = 77ff00c4 fd548122 b21adbc7 a58c3d48
!	%f8  = e083212d ed585929 fa1c0833 270be751
!	%f12 = 023a3b96 24746c57 b9e7460b 3e0e3a49
	stda	%f0,[%i1]ASI_BLK_P	! Block Store to 0000000020800000

p4_label_101:
!	%f16 = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	%f20 = 0ac0efc4 5e15de2e 15557d1d c1788640
!	%f24 = 65ae1df8 6298df2a da14c6eb 6378ece9
!	%f28 = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	stda	%f16,[%i1+%g4]ASI_BLK_PL	! Block Store to 0000000020800080

	ba,a	p4_not_taken_0_end
p4_not_taken_0:
!	The following code should not be executed
	ldx	[%o0+0x040],%l4
	ldda	[%i5]ASI_BLK_P,%f16
	ba,a	p4_branch_failed
p4_not_taken_0_end:

!	Mem[0000000020000000] = 6aab0f5a, %l1 = 000000000000f696
	ldsha	[%i0+%g0]0x80,%l1	! %l1 = 0000000000006aab
!	Mem[000000007200006c] = 270be751, %l5 = fa1c0833270be751
	lduw	[%o4+0x06c],%g2		! %g2 = fa1c0833270be751
!	Mem[0000000023000008] = 35d13147 526ebb46, %l0 = 0000026f, %l1 = 00006aab
	ldda	[%i6+%o6]0x80,%l0	! %l0 = 0000000035d13147 00000000526ebb46
!	%l0 = 0000000035d13147, Mem[0000000021800000] = 979e8607
	stha	%l0,[%i3+%g0]0x80	! Mem[0000000021800000] = 31478607

p4_label_102:
!	Mem[0000000021000000] = adc11ea9, %l1 = 00000000526ebb46
	lduwa	[%i2+%g0]0x80,%l1	! %l1 = 00000000adc11ea9
!	%l3 = 13b08edbffffffa9, immed = fffffcb3, %y  = 0000022b
	mulx	%l3,-0x34d,%l6		! %l6 = 023873d400011f2b
	membar	#Sync			! Added by membar checker (233)
!	%f16 = 6ef3bda1 58d3cfec bc2355ce 09938e07
!	%f20 = 0ac0efc4 5e15de2e 15557d1d c1788640
!	%f24 = 65ae1df8 6298df2a da14c6eb 6378ece9
!	%f28 = f4cc8588 f6968e08 8c6b54aa 65b62ed6
	stda	%f16,[%i1+%g4]ASI_BLK_P	! Block Store to 0000000020800080
!	Mem[00000000208000e0] = 295958ed, %l5 = fa1c0833270be751
	swapa	[%i1+0x0e0]%asi,%l5	! %l5 = 00000000295958ed
!	Mem[0000000021800000] = 31478607 13b08edb abfd2116 b17d9219
!	Mem[0000000021800010] = 1acd971f 204681da b080bf4f cab71100
!	Mem[0000000021800020] = 9cb09dfb 60491a3d 44a63115 fe259447
!	Mem[0000000021800030] = c1ad9e95 6aa3dae0 61be91ae ebf6a131
	ldda	[%i3]ASI_BLK_PL,%f16	! Block Load from 0000000021800000

p4_label_103:
!	Mem[0000000020000020] = e083212d ed585929 fa1c0833 270be751
	prefetch [%i0+0x020],3
!	Mem[000000002000007c] = 0b46e7b9, %l7 = 0000000000000096
	ldub	[%i0+0x07d],%l7		! %l7 = 0000000000000046
!	Mem[0000000021800080] = 6aab0f5a a91ed409 026ffdb5 0601d77a
!	Mem[0000000021800090] = 77ff00c4 fd548122 b21adbc7 a58c3d48
!	Mem[00000000218000a0] = e083212d ed585929 fa1c0833 270be751
!	Mem[00000000218000b0] = 023a3b96 24746c57 b9e7460b 3e0e3a49
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 0000000021800080
!	%l5 = 00000000295958ed, %l1 = 00000000adc11ea9, %l6 = 023873d400011f2b
	or	%l5,%l1,%l6		! %l6 = 00000000add95eed
!	%f16 = db8eb013 07864731 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 0011b7ca 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%i2+%g6]ASI_BLK_PL	! Block Store to 00000000210000c0

p4_label_104:
!	Mem[0000000021800040] = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	Mem[0000000021800050] = 228154fd c4007477 483d8ca5 c7db1ab2
!	Mem[0000000021800060] = 295958ed 2d2183e0 51e70b27 33081cfa
!	Mem[0000000021800070] = 576c7424 963b3a02 493a0e3e 0b46e7b9
	ldda	[%i3+%g5]ASI_BLK_PL,%f0	! Block Load from 0000000021800040
!	Mem[0000000020800040] = 6ef3bda158d3cfec, %l2 = 19064406ffffadbc, %l7 = 0000000000000046
	add	%i1,0x40,%g1
	casxa	[%g1]0x80,%l2,%l7	! %l7 = 6ef3bda158d3cfec
!	Mem[0000000072000018] = b21adbc7 a58c3d48, %l0 = 35d13147, %l1 = adc11ea9
	ldda	[%o4+0x018]%asi,%g2	! %l0 = 0000000035d13147 00000000adc11ea9
!	Mem[0000000071000060] = 53410a55, %l6 = 00000000add95eed
	ldsw	[%o2+0x060],%l6		! %l6 = 0000000053410a55
!	%f16 = db8eb013 07864731 19927db1 1621fdab
!	%f20 = da814620 1f97cd1a 0011b7ca 4fbf80b0
!	%f24 = 3d1a4960 fb9db09c 479425fe 1531a644
!	%f28 = e0daa36a 959eadc1 31a1f6eb ae91be61
	stda	%f16,[%i6+%g6]ASI_BLK_PL	! Block Store to 00000000230000c0

p4_label_105:
!	Mem[0000000020000000] = 6aab0f5a a91ed409 026ffdb5 0601d77a
!	Mem[0000000020000010] = 777400c4 fd548122 b21adbc7 a58c3d48
!	Mem[0000000020000020] = e083212d ed585929 fa1c0833 270be751
!	Mem[0000000020000030] = 023a3b96 24746c57 b9e7460b 3e0e3a49
	ldda	[%i0]ASI_BLK_PL,%f16	! Block Load from 0000000020000000
!	Mem[0000000021800080] = 6aab0f5a a91ed409 026ffdb5 0601d77a
!	Mem[0000000021800090] = 77ff00c4 fd548122 b21adbc7 a58c3d48
!	Mem[00000000218000a0] = e083212d ed585929 fa1c0833 270be751
!	Mem[00000000218000b0] = 023a3b96 24746c57 b9e7460b 3e0e3a49
	ldda	[%i3+%g4]ASI_BLK_P,%f0	! Block Load from 0000000021800080
	fbu,a	%fcc0,p4_branch_failed	! Branch Not Taken, %fcc0 = 0
!	Mem[0000000071000020] = 83a9fc6f, %l5 = 00000000295958ed
	lduw	[%o2+0x020],%l5		! Annulled
p4_b52:
!	%f22 = 483d8ca5, %f23 = c7db1ab2, %f24 = 295958ed
	fsubs	%f22,%f23,%f24		! %f24 = 48958cff

p4_label_106:
!	Mem[0000000021000000] = adc11ea9, %l3 = 13b08edbffffffa9
	lduha	[%i2+%g0]0x80,%l3	! %l3 = 000000000000adc1
!	Mem[00000000208000fc] = 0b46e7b9, %l5 = 00000000295958ed
	ldsb	[%i1+0x0ff],%l5		! %l5 = ffffffffffffffb9
!	Mem[000000002000009c] = c1788640, %l2 = 19064406ffffadbc
	swap	[%i0+0x09c],%l2		! %l2 = 00000000c1788640
!	%l4 = 528fae7df8c7c699, Mem[0000000071000020] = 83a9fc6f
	stw	%l4,[%o2+0x020]		! Mem[0000000071000020] = f8c7c699
!	Mem[0000000021800098] = b21adbc7a58c3d48, %l0 = 0000000035d13147
	ldx	[%i3+0x098],%l0		! %l0 = b21adbc7a58c3d48

p4_label_107:
!	%f16 = 09d41ea9 5a0fab6a 7ad70106 b5fd6f02
!	%f20 = 228154fd c4007477 483d8ca5 c7db1ab2
!	%f24 = 48958cff 2d2183e0 51e70b27 33081cfa
!	%f28 = 576c7424 963b3a02 493a0e3e 0b46e7b9
	stda	%f16,[%i0+%g4]ASI_BLK_PL	! Block Store to 0000000020000080
!	Mem[0000000022800008] = 839fdbb0, %l5 = ffffffffffffffb9
	ldsha	[%i5+%o6]0x80,%l5	! %l5 = ffffffffffff839f
!	%f16 = 09d41ea9 5a0f