// Copyright (c) 2015 Princeton University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Princeton University nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY PRINCETON UNIVERSITY "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL PRINCETON UNIVERSITY BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//==================================================================================================
//  Filename      : iob_mon.v
//  Created On    : 2014-05-08
//  Last Modified : 2014-05-08
//  Revision      :
//  Author        : Yaosheng Fu
//  Company       : Princeton University
//  Email         : yfu@princeton.edu
//
//  Description   : Monitors for the IO bridge
//
//
//====================================================================================================




`include "sys.h"
`include "iop.h"
`include "cross_module.h.tmp"

module iob_mon (
    input wire clk
);


always @ (posedge clk)
begin
    if(`TOP_MOD.ciop_iob.noc_in_val && `TOP_MOD.ciop_iob.noc_in_rdy)
    begin
        $display("Iob NOC1 received a packet: %h", `TOP_MOD.ciop_iob.noc_in_data);
    end
    if(`TOP_MOD.ciop_iob.noc_out_val && `TOP_MOD.ciop_iob.noc_out_rdy)
    begin
        $display("Iob NOC2 sent a packet: %h", `TOP_MOD.ciop_iob.noc_out_data);
    end
    
    if(`TOP_MOD.ciop_iob.pcx_iob_data[123])
    begin
        $display("Iob PCX received a packet: %h\n", `TOP_MOD.ciop_iob.pcx_iob_data);
    end
    if(`TOP_MOD.ciop_iob.cpx_data[144])
    begin
        $display("Iob CPX sent a packet: %h\n", `TOP_MOD.ciop_iob.cpx_data);
    end

end


endmodule

